/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IPipelineConnections;
import org.apache.manifoldcf.agents.interfaces.IPipelineSpecificationBasic;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnection;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class PipelineConnections
implements IPipelineConnections {
    protected final IPipelineSpecificationBasic spec;
    protected final String[] transformationConnectionNames;
    protected final ITransformationConnection[] transformationConnections;
    protected final String[] outputConnectionNames;
    protected final IOutputConnection[] outputConnections;
    protected final Map<Integer, Integer> transformationConnectionLookupMap = new HashMap<Integer, Integer>();
    protected final Map<Integer, Integer> outputConnectionLookupMap = new HashMap<Integer, Integer>();

    public PipelineConnections(IPipelineSpecificationBasic spec, ITransformationConnectionManager transformationConnectionManager, IOutputConnectionManager outputConnectionManager) throws ManifoldCFException {
        String connectionName;
        this.spec = spec;
        int count = spec.getStageCount();
        HashSet<String> transformations = new HashSet<String>();
        HashSet<String> outputs = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            if (spec.checkStageOutputConnection(i)) {
                outputs.add(spec.getStageConnectionName(i));
                continue;
            }
            transformations.add(spec.getStageConnectionName(i));
        }
        HashMap<String, Integer> transformationNameMap = new HashMap<String, Integer>();
        HashMap<String, Integer> outputNameMap = new HashMap<String, Integer>();
        this.transformationConnectionNames = new String[transformations.size()];
        this.outputConnectionNames = new String[outputs.size()];
        int index = 0;
        Iterator iterator = transformations.iterator();
        while (iterator.hasNext()) {
            this.transformationConnectionNames[index] = connectionName = (String)iterator.next();
            transformationNameMap.put(connectionName, new Integer(index++));
        }
        index = 0;
        iterator = outputs.iterator();
        while (iterator.hasNext()) {
            this.outputConnectionNames[index] = connectionName = (String)iterator.next();
            outputNameMap.put(connectionName, new Integer(index++));
        }
        this.transformationConnections = transformationConnectionManager.loadMultiple(this.transformationConnectionNames);
        this.outputConnections = outputConnectionManager.loadMultiple(this.outputConnectionNames);
        for (int i = 0; i < count; ++i) {
            if (spec.checkStageOutputConnection(i)) {
                this.outputConnectionLookupMap.put(new Integer(i), (Integer)outputNameMap.get(spec.getStageConnectionName(i)));
                continue;
            }
            this.transformationConnectionLookupMap.put(new Integer(i), (Integer)transformationNameMap.get(spec.getStageConnectionName(i)));
        }
    }

    public int getStageCount() {
        return this.spec.getStageCount();
    }

    public int[] getStageChildren(int stage) {
        return this.spec.getStageChildren(stage);
    }

    public int getStageParent(int stage) {
        return this.spec.getStageParent(stage);
    }

    public String getStageConnectionName(int stage) {
        return this.spec.getStageConnectionName(stage);
    }

    public boolean checkStageOutputConnection(int stage) {
        return this.spec.checkStageOutputConnection(stage);
    }

    public int getOutputCount() {
        return this.spec.getOutputCount();
    }

    public int getOutputStage(int index) {
        return this.spec.getOutputStage(index);
    }

    public String[] getTransformationConnectionNames() {
        return this.transformationConnectionNames;
    }

    public ITransformationConnection[] getTransformationConnections() {
        return this.transformationConnections;
    }

    public String[] getOutputConnectionNames() {
        return this.outputConnectionNames;
    }

    public IOutputConnection[] getOutputConnections() {
        return this.outputConnections;
    }

    public Integer getTransformationConnectionIndex(int stage) {
        return this.transformationConnectionLookupMap.get(new Integer(stage));
    }

    public Integer getOutputConnectionIndex(int stage) {
        return this.outputConnectionLookupMap.get(new Integer(stage));
    }
}

