/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.management.StandardMBean;
import org.apache.knox.gateway.services.security.token.TokenStateServiceStatisticsMBean;

public class TokenStateServiceStatistics
extends StandardMBean
implements TokenStateServiceStatisticsMBean {
    private final AtomicInteger numberOfTokensAdded = new AtomicInteger(0);
    private final AtomicInteger numberOfTokensRenewed = new AtomicInteger(0);
    private final Map<String, AtomicInteger> keystoreInteractions = new ConcurrentHashMap<String, AtomicInteger>();
    private final AtomicLong gatewayCredentialsFileSize = new AtomicLong(0L);

    public TokenStateServiceStatistics() {
        super(TokenStateServiceStatisticsMBean.class, false);
    }

    public void addToken() {
        this.numberOfTokensAdded.incrementAndGet();
    }

    public void renewToken() {
        this.numberOfTokensRenewed.incrementAndGet();
    }

    public void interactKeystore(KeystoreInteraction keystoreInteraction) {
        this.keystoreInteractions.putIfAbsent(keystoreInteraction.getKey(), new AtomicInteger(0));
        this.keystoreInteractions.get(keystoreInteraction.getKey()).incrementAndGet();
    }

    public void setGatewayCredentialsFileSize(long gatewayCredentialsFileSize) {
        this.gatewayCredentialsFileSize.set(gatewayCredentialsFileSize);
    }

    public int getNumberOfTokensAdded() {
        return this.numberOfTokensAdded.get();
    }

    public int getNumberOfTokensRenewed() {
        return this.numberOfTokensRenewed.get();
    }

    public Map<String, Integer> getKeystoreInteractions() {
        return this.keystoreInteractions.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((AtomicInteger)entry.getValue()).get()));
    }

    public long getGatewayCredentialsFileSize() {
        return this.gatewayCredentialsFileSize.get();
    }

    public static enum KeystoreInteraction {
        SAVE_ALIAS("saveAlias"),
        REMOVE_ALIAS("removeAlias"),
        GET_PASSWORD("getPassword"),
        GET_ALIAS("getAlias");

        private final String key;

        private KeystoreInteraction(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

