/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxsso;

import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.knox.gateway.service.knoxsso.KnoxSSOutMessages;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.token.TokenStateService;
import org.apache.knox.gateway.services.security.token.TokenUtils;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.session.control.ConcurrentSessionVerifier;
import org.apache.knox.gateway.util.Tokens;
import org.apache.knox.gateway.util.Urls;

@Path(value="knoxssout/api/v1/webssout")
public class WebSSOutResource {
    private static final KnoxSSOutMessages log = (KnoxSSOutMessages)MessagesFactory.get(KnoxSSOutMessages.class);
    private static final String SSO_COOKIE_NAME = "knoxsso.cookie.name";
    private static final String DEFAULT_SSO_COOKIE_NAME = "hadoop-jwt";
    static final String RESOURCE_PATH = "knoxssout/api/v1/webssout";
    private String cookieName;
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;
    @Context
    ServletContext context;

    @PostConstruct
    public void init() {
        this.cookieName = this.context.getInitParameter(SSO_COOKIE_NAME);
        if (this.cookieName == null) {
            this.cookieName = DEFAULT_SSO_COOKIE_NAME;
        }
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        boolean rc = this.removeAuthenticationToken(this.response);
        if (rc) {
            return Response.ok().entity((Object)"{ \"loggedOut\" : true }").build();
        }
        return Response.ok().entity((Object)"{ \"loggedOut\" : false }").build();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        boolean rc = this.removeAuthenticationToken(this.response);
        if (rc) {
            return Response.ok().entity((Object)"{ \"loggedOut\" : true }").build();
        }
        return Response.ok().entity((Object)"{ \"loggedOut\" : false }").build();
    }

    private boolean removeAuthenticationToken(HttpServletResponse response) {
        boolean rc = true;
        Cookie c = new Cookie(this.cookieName, null);
        c.setMaxAge(0);
        c.setPath("/");
        try {
            String domainName = Urls.getDomainName((String)this.request.getRequestURL().toString(), null);
            if (domainName != null) {
                c.setDomain(domainName);
            }
        }
        catch (MalformedURLException e) {
            log.problemWithCookieDomainUsingDefault();
            rc = false;
        }
        response.addCookie(c);
        Optional<Cookie> ssoCookie = this.findCookie(this.cookieName);
        if (ssoCookie.isPresent()) {
            GatewayServices gwServices = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
            if (gwServices != null) {
                ConcurrentSessionVerifier verifier = (ConcurrentSessionVerifier)gwServices.getService(ServiceType.CONCURRENT_SESSION_VERIFIER);
                verifier.sessionEndedForUser(this.request.getUserPrincipal().getName(), ssoCookie.get().getValue());
                this.removeKnoxSsoCookie(ssoCookie.get(), gwServices);
            }
        } else {
            log.couldNotFindCookieWithTokenToRemove(this.cookieName, this.request.getUserPrincipal().getName());
        }
        return rc;
    }

    private void removeKnoxSsoCookie(Cookie ssoCookie, GatewayServices gwServices) {
        TokenStateService tokenStateService = (TokenStateService)gwServices.getService(ServiceType.TOKEN_STATE_SERVICE);
        if (tokenStateService != null) {
            try {
                JWTToken jwt = new JWTToken(ssoCookie.getValue());
                tokenStateService.revokeToken(jwt);
                String revoker = SubjectUtils.getCurrentEffectivePrincipalName();
                log.revokedToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)ssoCookie.getValue()), Tokens.getTokenIDDisplayText((String)TokenUtils.getTokenId((JWT)jwt)), revoker);
            }
            catch (ParseException | UnknownTokenException throwable) {
                // empty catch block
            }
        }
    }

    private String getTopologyName() {
        return (String)this.context.getAttribute("org.apache.knox.gateway.gateway.cluster");
    }

    private Optional<Cookie> findCookie(String cookieName) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            return Arrays.stream(cookies).filter(cookie -> cookie.getName().equals(cookieName)).findFirst();
        }
        return Optional.empty();
    }
}

