/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.drda.AppRequester;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.impl.drda.DssTrace;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

class Session {
    protected static final int INIT = 1;
    protected static final int ATTEXC = 2;
    protected static final int SECACC = 3;
    protected static final int CHKSEC = 4;
    protected static final int CLOSED = 5;
    protected static final int DRDA_SESSION = 1;
    protected static final int CMD_SESSION = 2;
    private static final String TRACENAME_PREFIX = "Server";
    private static final String TRACENAME_SUFFIX = ".trace";
    protected Socket clientSocket;
    protected int connNum;
    protected InputStream sessionInput;
    protected OutputStream sessionOutput;
    protected String traceFileName;
    protected boolean traceOn;
    protected int state;
    protected int sessionType;
    protected String drdaID;
    protected DssTrace dssTrace;
    protected AppRequester appRequester;
    protected Database database;
    protected int qryinsid;
    protected LocalizedResource langUtil;
    private Hashtable<String, Database> dbtable;
    private NetworkServerControlImpl nsctrl;

    Session(NetworkServerControlImpl networkServerControlImpl, int n, Socket socket, String string, boolean bl) throws Exception {
        this.nsctrl = networkServerControlImpl;
        this.connNum = n;
        this.clientSocket = socket;
        this.traceOn = bl;
        if (bl) {
            this.dssTrace = new DssTrace();
        }
        this.dbtable = new Hashtable();
        this.initialize(string);
    }

    protected void close() throws SQLException {
        try {
            this.sessionInput.close();
            this.sessionOutput.close();
            this.clientSocket.close();
            this.setTraceOff();
            if (this.dbtable != null) {
                Enumeration<Database> enumeration = this.dbtable.elements();
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement().close();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.state = 5;
            this.dbtable = null;
            this.database = null;
        }
    }

    protected void initTrace(String string, boolean bl) throws Exception {
        this.traceFileName = string != null ? string + "/" + TRACENAME_PREFIX + this.connNum + TRACENAME_SUFFIX : TRACENAME_PREFIX + this.connNum + TRACENAME_SUFFIX;
        if (this.dssTrace == null) {
            this.dssTrace = new DssTrace();
        }
        try {
            this.dssTrace.startComBufferTrace(this.traceFileName);
            this.traceOn = true;
        }
        catch (Exception exception) {
            if (bl) {
                throw exception;
            }
            this.nsctrl.consoleExceptionPrintTrace(exception);
        }
    }

    protected void setTraceOn(String string, boolean bl) throws Exception {
        if (this.traceOn) {
            return;
        }
        this.initTrace(string, bl);
    }

    protected boolean isTraceOn() {
        return this.traceOn;
    }

    protected int getConnNum() {
        return this.connNum;
    }

    protected void setTraceOff() {
        if (!this.traceOn) {
            return;
        }
        this.traceOn = false;
        if (this.traceFileName != null) {
            this.dssTrace.stopComBufferTrace();
        }
    }

    protected void addDatabase(Database database) {
        this.dbtable.put(database.getDatabaseName(), database);
    }

    protected Database getDatabase(String string) {
        return this.dbtable.get(string);
    }

    protected int getRequiredSecurityCodepoint() {
        switch (this.state) {
            case 2: {
                return 4205;
            }
            case 3: {
                return 4206;
            }
        }
        return -1;
    }

    protected boolean requiresSecurityCodepoint() {
        return this.getRequiredSecurityCodepoint() != -1;
    }

    protected void setState(int n) {
        this.state = n;
    }

    private void initialize(String string) throws Exception {
        this.sessionInput = this.clientSocket.getInputStream();
        this.sessionOutput = this.clientSocket.getOutputStream();
        if (this.traceOn) {
            this.initTrace(string, false);
        }
        this.state = 1;
    }

    protected String buildRuntimeInfo(String string, LocalizedResource localizedResource) {
        String string2 = "";
        string2 = string2 + string + localizedResource.getTextMessage("DRDA_RuntimeInfoSessionNumber.I", new Object[0]) + this.connNum + "\n";
        Database database = this.database;
        if (database != null) {
            string2 = string2 + database.buildRuntimeInfo(string, localizedResource);
            string2 = string2 + "\n";
        }
        return string2;
    }
}

