/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.operational;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.DateUtils;
import org.apache.directory.api.util.TimeProvider;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.FilteringOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.Subordinates;
import org.apache.directory.server.core.shared.SchemaService;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationalAttributeInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(OperationalAttributeInterceptor.class);
    private final EntryFilter denormalizingSearchFilter = new OperationalAttributeDenormalizingSearchFilter();
    private final EntryFilter operationalAttributeSearchFilter = new OperationalAttributeSearchFilter();
    private final EntryFilter subordinatesSearchFilter = new SubordinatesSearchFilter();
    private Dn subschemaSubentryDn;
    private Dn adminDn;

    public OperationalAttributeInterceptor() {
        super(InterceptorEnum.OPERATIONAL_ATTRIBUTE_INTERCEPTOR);
    }

    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        Value subschemaSubentry = directoryService.getPartitionNexus().getRootDseValue(directoryService.getAtProvider().getSubschemaSubentry());
        this.subschemaSubentryDn = this.dnFactory.create(subschemaSubentry.getString());
        this.adminDn = this.dnFactory.create("uid=admin,ou=system");
    }

    public void destroy() {
    }

    private boolean checkAddOperationalAttribute(boolean isAdmin, Entry entry, AttributeType attribute) throws LdapException {
        if (entry.containsAttribute(attribute)) {
            if (!isAdmin) {
                String message = I18n.err((I18n)I18n.ERR_30, (Object[])new Object[]{attribute});
                LOG.error(message);
                throw new LdapNoPermissionException(message);
            }
            return true;
        }
        return false;
    }

    public void add(AddOperationContext addContext) throws LdapException {
        String principal = OperationalAttributeInterceptor.getPrincipal((OperationContext)addContext).getName();
        Entry entry = addContext.getEntry();
        boolean isAdmin = addContext.getSession().getAuthenticatedPrincipal().getDn().equals((Object)this.adminDn);
        if (!this.checkAddOperationalAttribute(isAdmin, entry, this.directoryService.getAtProvider().getEntryUUID())) {
            entry.put(this.directoryService.getAtProvider().getEntryUUID(), new String[]{UUID.randomUUID().toString()});
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, this.directoryService.getAtProvider().getEntryCSN())) {
            entry.put(this.directoryService.getAtProvider().getEntryCSN(), new String[]{this.directoryService.getCSN().toString()});
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, this.directoryService.getAtProvider().getCreatorsName())) {
            entry.put(this.directoryService.getAtProvider().getCreatorsName(), new String[]{principal});
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, this.directoryService.getAtProvider().getCreateTimestamp())) {
            entry.put(this.directoryService.getAtProvider().getCreateTimestamp(), new String[]{DateUtils.getGeneralizedTime((TimeProvider)this.directoryService.getTimeProvider())});
        }
        this.checkAddOperationalAttribute(isAdmin, entry, this.directoryService.getAtProvider().getAccessControlSubentries());
        this.checkAddOperationalAttribute(isAdmin, entry, this.directoryService.getAtProvider().getCollectiveAttributeSubentries());
        this.checkAddOperationalAttribute(isAdmin, entry, this.directoryService.getAtProvider().getTriggerExecutionSubentries());
        this.checkAddOperationalAttribute(isAdmin, entry, this.directoryService.getAtProvider().getSubschemaSubentry());
        this.next(addContext);
    }

    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        Dn dn = lookupContext.getDn();
        if (dn.getNormName().equals(this.subschemaSubentryDn.getNormName())) {
            Entry serverEntry = SchemaService.getSubschemaEntry((DirectoryService)this.directoryService, (FilteringOperationContext)lookupContext);
            serverEntry.setDn(dn);
            return serverEntry;
        }
        Entry entry = this.next(lookupContext);
        this.denormalizeEntryOpAttrs(entry);
        this.processSubordinates((OperationContext)lookupContext, lookupContext.getReturningAttributes(), lookupContext.isAllOperationalAttributes(), entry);
        return entry;
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        List mods = modifyContext.getModItems();
        boolean isAdmin = modifyContext.getSession().getAuthenticatedPrincipal().getDn().equals((Object)this.adminDn);
        boolean modifierAtPresent = false;
        boolean modifiedTimeAtPresent = false;
        boolean entryCsnAtPresent = false;
        Dn dn = modifyContext.getDn();
        for (Modification modification : mods) {
            AttributeType attributeType = modification.getAttribute().getAttributeType();
            if (attributeType.equals((Object)this.directoryService.getAtProvider().getModifiersName())) {
                if (!isAdmin) {
                    String message = I18n.err((I18n)I18n.ERR_31, (Object[])new Object[0]);
                    LOG.error(message);
                    throw new LdapNoPermissionException(message);
                }
                modifierAtPresent = true;
            }
            if (attributeType.equals((Object)this.directoryService.getAtProvider().getModifyTimestamp())) {
                if (!isAdmin) {
                    String message = I18n.err((I18n)I18n.ERR_30, (Object[])new Object[]{attributeType});
                    LOG.error(message);
                    throw new LdapNoPermissionException(message);
                }
                modifiedTimeAtPresent = true;
            }
            if (attributeType.equals((Object)this.directoryService.getAtProvider().getEntryCSN())) {
                if (!isAdmin) {
                    String message = I18n.err((I18n)I18n.ERR_30, (Object[])new Object[]{attributeType});
                    LOG.error(message);
                    throw new LdapNoPermissionException(message);
                }
                entryCsnAtPresent = true;
            }
            if (!PWD_POLICY_STATE_ATTRIBUTE_TYPES.contains(attributeType) || isAdmin) continue;
            String message = I18n.err((I18n)I18n.ERR_30, (Object[])new Object[]{attributeType});
            LOG.error(message);
            throw new LdapNoPermissionException(message);
        }
        if (!dn.equals((Object)this.subschemaSubentryDn)) {
            DefaultAttribute attribute;
            if (!modifierAtPresent) {
                attribute = new DefaultAttribute(this.directoryService.getAtProvider().getModifiersName(), new String[]{OperationalAttributeInterceptor.getPrincipal((OperationContext)modifyContext).getName()});
                DefaultModification modifiersName = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)attribute);
                mods.add(modifiersName);
            }
            if (!modifiedTimeAtPresent) {
                attribute = new DefaultAttribute(this.directoryService.getAtProvider().getModifyTimestamp(), new String[]{DateUtils.getGeneralizedTime((TimeProvider)this.directoryService.getTimeProvider())});
                DefaultModification timestamp = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)attribute);
                mods.add(timestamp);
            }
            if (!entryCsnAtPresent) {
                String csn = this.directoryService.getCSN().toString();
                DefaultAttribute attribute2 = new DefaultAttribute(this.directoryService.getAtProvider().getEntryCSN(), new String[]{csn});
                DefaultModification updatedCsn = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)attribute2);
                mods.add(updatedCsn);
            }
        }
        this.next(modifyContext);
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        Entry modifiedEntry = moveContext.getOriginalEntry().clone();
        modifiedEntry.put("modifiersName", new String[]{OperationalAttributeInterceptor.getPrincipal((OperationContext)moveContext).getName()});
        modifiedEntry.put("modifyTimestamp", new String[]{DateUtils.getGeneralizedTime((TimeProvider)this.directoryService.getTimeProvider())});
        DefaultAttribute csnAt = new DefaultAttribute(this.directoryService.getAtProvider().getEntryCSN(), new String[]{this.directoryService.getCSN().toString()});
        modifiedEntry.put(new Attribute[]{csnAt});
        modifiedEntry.setDn(moveContext.getNewDn());
        moveContext.setModifiedEntry(modifiedEntry);
        this.next(moveContext);
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Entry modifiedEntry = moveAndRenameContext.getModifiedEntry();
        modifiedEntry.put("modifiersName", new String[]{OperationalAttributeInterceptor.getPrincipal((OperationContext)moveAndRenameContext).getName()});
        modifiedEntry.put("modifyTimestamp", new String[]{DateUtils.getGeneralizedTime((TimeProvider)this.directoryService.getTimeProvider())});
        modifiedEntry.setDn(moveAndRenameContext.getNewDn());
        DefaultAttribute csnAt = new DefaultAttribute(this.directoryService.getAtProvider().getEntryCSN(), new String[]{this.directoryService.getCSN().toString()});
        modifiedEntry.put(new Attribute[]{csnAt});
        moveAndRenameContext.setModifiedEntry(modifiedEntry);
        this.next(moveAndRenameContext);
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        Entry entry = ((ClonedServerEntry)renameContext.getEntry()).getClonedEntry();
        entry.put("modifiersName", new String[]{OperationalAttributeInterceptor.getPrincipal((OperationContext)renameContext).getName()});
        entry.put("modifyTimestamp", new String[]{DateUtils.getGeneralizedTime((TimeProvider)this.directoryService.getTimeProvider())});
        Entry modifiedEntry = renameContext.getOriginalEntry().clone();
        modifiedEntry.put("modifiersName", new String[]{OperationalAttributeInterceptor.getPrincipal((OperationContext)renameContext).getName()});
        modifiedEntry.put("modifyTimestamp", new String[]{DateUtils.getGeneralizedTime((TimeProvider)this.directoryService.getTimeProvider())});
        DefaultAttribute csnAt = new DefaultAttribute(this.directoryService.getAtProvider().getEntryCSN(), new String[]{this.directoryService.getCSN().toString()});
        modifiedEntry.put(new Attribute[]{csnAt});
        renameContext.setModifiedEntry(modifiedEntry);
        this.next(renameContext);
    }

    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        EntryFilteringCursor cursor = this.next(searchContext);
        if (searchContext.isAllOperationalAttributes() || searchContext.getReturningAttributes() != null && !searchContext.getReturningAttributes().isEmpty()) {
            if (this.directoryService.isDenormalizeOpAttrsEnabled()) {
                cursor.addEntryFilter(this.denormalizingSearchFilter);
            }
            cursor.addEntryFilter(this.operationalAttributeSearchFilter);
            cursor.addEntryFilter(this.subordinatesSearchFilter);
            return cursor;
        }
        return cursor;
    }

    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Entry entry = deleteContext.getEntry();
        DefaultAttribute csnAt = new DefaultAttribute(this.directoryService.getAtProvider().getEntryCSN(), new String[]{this.directoryService.getCSN().toString()});
        entry.put(new Attribute[]{csnAt});
        this.next(deleteContext);
    }

    private void denormalizeEntryOpAttrs(Entry entry) throws LdapException {
        if (this.directoryService.isDenormalizeOpAttrsEnabled()) {
            Dn modifiersName;
            Attribute attr = entry.get("creatorsName");
            if (attr != null) {
                Dn creatorsName = this.dnFactory.create(attr.getString());
                attr.clear();
                attr.add(new String[]{this.denormalizeTypes(creatorsName).getName()});
            }
            if ((attr = entry.get("modifiersName")) != null) {
                modifiersName = this.dnFactory.create(attr.getString());
                attr.clear();
                attr.add(new String[]{this.denormalizeTypes(modifiersName).getName()});
            }
            if ((attr = entry.get("schemaModifiersName")) != null) {
                modifiersName = this.dnFactory.create(attr.getString());
                attr.clear();
                attr.add(new String[]{this.denormalizeTypes(modifiersName).getName()});
            }
        }
    }

    private Dn denormalizeTypes(Dn dn) throws LdapException {
        Dn newDn = new Dn(this.schemaManager);
        int size = dn.size();
        for (int pos = 0; pos < size; ++pos) {
            Rdn rdn = dn.getRdn(size - 1 - pos);
            if (rdn.size() == 0) {
                newDn = newDn.add(new Rdn());
                continue;
            }
            if (rdn.size() == 1) {
                String name = this.schemaManager.lookupAttributeTypeRegistry(rdn.getNormType()).getName();
                String value = rdn.getValue();
                newDn = newDn.add(new Rdn(name, value));
                continue;
            }
            StringBuilder buf = new StringBuilder();
            Iterator atavs = rdn.iterator();
            while (atavs.hasNext()) {
                Ava atav = (Ava)atavs.next();
                String type = this.schemaManager.lookupAttributeTypeRegistry(rdn.getNormType()).getName();
                buf.append(type).append('=').append(atav.getValue().getString());
                if (!atavs.hasNext()) continue;
                buf.append('+');
            }
            newDn = newDn.add(new Rdn(buf.toString()));
        }
        return newDn;
    }

    private void processSubordinates(OperationContext operationContext, Set<AttributeTypeOptions> returningAttributes, boolean allAttributes, Entry entry) throws LdapException {
        if (Dn.isNullOrEmpty((Dn)entry.getDn())) {
            return;
        }
        AttributeType nbChildrenAt = this.directoryService.getAtProvider().getNbChildren();
        AttributeTypeOptions nbChildrenAto = new AttributeTypeOptions(nbChildrenAt);
        AttributeType nbSubordinatesAt = this.directoryService.getAtProvider().getNbSubordinates();
        AttributeTypeOptions nbSubordinatesAto = new AttributeTypeOptions(nbSubordinatesAt);
        AttributeType hasSubordinatesAt = this.directoryService.getAtProvider().getHasSubordinates();
        AttributeTypeOptions hasSubordinatesAto = new AttributeTypeOptions(hasSubordinatesAt);
        AttributeType structuralObjectClassAt = this.directoryService.getAtProvider().getStructuralObjectClass();
        AttributeTypeOptions structuralObjectClassAto = new AttributeTypeOptions(structuralObjectClassAt);
        if (returningAttributes != null) {
            boolean structuralObjectClassRequested;
            boolean nbChildrenRequested = returningAttributes.contains(nbChildrenAto) || allAttributes;
            boolean nbSubordinatesRequested = returningAttributes.contains(nbSubordinatesAto) || allAttributes;
            boolean hasSubordinatesRequested = returningAttributes.contains(hasSubordinatesAto) || allAttributes;
            boolean bl = structuralObjectClassRequested = returningAttributes.contains(structuralObjectClassAto) || allAttributes;
            if (nbChildrenRequested || nbSubordinatesRequested || hasSubordinatesRequested || structuralObjectClassRequested) {
                Partition partition = this.directoryService.getPartitionNexus().getPartition(entry.getDn());
                Subordinates subordinates = partition.getSubordinates(operationContext.getTransaction(), entry);
                long nbChildren = subordinates.getNbChildren();
                long nbSubordinates = subordinates.getNbSubordinates();
                if (nbChildrenRequested) {
                    entry.add(new Attribute[]{new DefaultAttribute(nbChildrenAt, new String[]{Long.toString(nbChildren)})});
                }
                if (nbSubordinatesRequested) {
                    entry.add(new Attribute[]{new DefaultAttribute(nbSubordinatesAt, new String[]{Long.toString(nbSubordinates)})});
                }
                if (hasSubordinatesRequested) {
                    if (nbSubordinates > 0L) {
                        entry.add(new Attribute[]{new DefaultAttribute(hasSubordinatesAt, new String[]{"TRUE"})});
                    } else {
                        entry.add(new Attribute[]{new DefaultAttribute(hasSubordinatesAt, new String[]{"FALSE"})});
                    }
                }
                if (structuralObjectClassRequested) {
                    Attribute objectClasses = entry.get("objectClass");
                    HashMap<String, ObjectClass> superiors = new HashMap<String, ObjectClass>();
                    ObjectClass[] objectClassArray = new ObjectClass[objectClasses.size()];
                    int nbStructural = 0;
                    for (Value objectClassValue : objectClasses) {
                        ObjectClass objectClass = (ObjectClass)this.schemaManager.getObjectClassRegistry().get(objectClassValue.getNormalized());
                        if (!objectClass.isStructural()) continue;
                        objectClassArray[nbStructural++] = objectClass;
                        superiors.put(((ObjectClass)objectClass.getSuperiors().get(0)).getOid(), objectClass);
                    }
                    if (nbStructural == 1) {
                        entry.add(new Attribute[]{new DefaultAttribute(structuralObjectClassAt, new String[]{objectClassArray[0].getName()})});
                    } else {
                        ObjectClass topStructural = objectClassArray[0];
                        for (ObjectClass oc : objectClassArray) {
                            if (superiors.containsKey(oc.getOid())) continue;
                            entry.add(new Attribute[]{new DefaultAttribute(structuralObjectClassAt, new String[]{oc.getName()})});
                            break;
                        }
                    }
                }
            }
        }
    }

    private class SubordinatesSearchFilter
    implements EntryFilter {
        private SubordinatesSearchFilter() {
        }

        public boolean accept(SearchOperationContext searchOperationContext, Entry entry) throws LdapException {
            OperationalAttributeInterceptor.this.processSubordinates((OperationContext)searchOperationContext, searchOperationContext.getReturningAttributes(), searchOperationContext.isAllOperationalAttributes(), entry);
            return true;
        }

        public String toString(String tabs) {
            return tabs + "SubordinatesSearchFilter";
        }
    }

    private class OperationalAttributeSearchFilter
    implements EntryFilter {
        private OperationalAttributeSearchFilter() {
        }

        public boolean accept(SearchOperationContext operation, Entry entry) throws LdapException {
            if (operation.getReturningAttributesString() == null) {
                return true;
            }
            SchemaManager schemaManager = operation.getSession().getDirectoryService().getSchemaManager();
            if (operation.isAllOperationalAttributes() || operation.getReturningAttributes().contains(new AttributeTypeOptions(schemaManager.getAttributeType("subschemaSubentry")))) {
                AttributeType subschemaSubentryAt = schemaManager.getAttributeType("subschemaSubentry");
                entry.add(new Attribute[]{new DefaultAttribute(subschemaSubentryAt, new Value[]{OperationalAttributeInterceptor.this.directoryService.getPartitionNexus().getRootDseValue(subschemaSubentryAt)})});
            }
            return true;
        }

        public String toString(String tabs) {
            return tabs + "OperationalAttributeSearchFilter";
        }
    }

    private class OperationalAttributeDenormalizingSearchFilter
    implements EntryFilter {
        private OperationalAttributeDenormalizingSearchFilter() {
        }

        public boolean accept(SearchOperationContext operation, Entry entry) throws LdapException {
            if (operation.getReturningAttributesString() == null) {
                return true;
            }
            OperationalAttributeInterceptor.this.denormalizeEntryOpAttrs(entry);
            return true;
        }

        public String toString(String tabs) {
            return tabs + "OperationalAttributeDenormalizingSearchFilter";
        }
    }
}

