/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.PredicateUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.objecttools.ObjectRest;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;

public class JsonList
extends LinkedList<Object> {
    private static final long serialVersionUID = 1L;
    public static final JsonList EMPTY_LIST = new JsonList(){
        private static final long serialVersionUID = 1L;

        @Override
        public void add(int location, Object object) {
            throw ThrowableUtils.unsupportedOpReadOnly();
        }

        @Override
        public ListIterator<Object> listIterator(int location) {
            return Collections.emptyList().listIterator(location);
        }

        @Override
        public Object remove(int location) {
            throw ThrowableUtils.unsupportedOpReadOnly();
        }

        @Override
        public Object set(int location, Object object) {
            throw ThrowableUtils.unsupportedOpReadOnly();
        }

        @Override
        public List<Object> subList(int start, int end) {
            return Collections.emptyList().subList(start, end);
        }
    };
    transient BeanSession session = null;
    private transient ObjectRest objectRest;

    public static JsonList create() {
        return new JsonList();
    }

    public static JsonList of(Collection<?> values) {
        return values == null ? null : new JsonList(values);
    }

    public static JsonList of(Object ... values) {
        return new JsonList(values);
    }

    public static JsonList ofArrays(Object[] ... values) {
        JsonList l = new JsonList();
        for (Object[] v : values) {
            l.add(v);
        }
        return l;
    }

    public static JsonList ofCollections(Collection<?> ... values) {
        JsonList l = new JsonList();
        for (Collection<?> v : values) {
            l.add(v);
        }
        return l;
    }

    public static JsonList ofJson(CharSequence json) throws ParseException {
        return json == null ? null : new JsonList(json);
    }

    public static JsonList ofJson(Reader json) throws ParseException {
        return json == null ? null : new JsonList(json);
    }

    public static JsonList ofJsonOrCdl(String s) throws ParseException {
        if (Utils.e(s)) {
            return null;
        }
        if (!StringUtils.isProbablyJsonArray(s, true)) {
            return new JsonList(StringUtils.splita(s.trim(), ','));
        }
        return new JsonList(s);
    }

    public static JsonList ofText(CharSequence in, Parser p) throws ParseException {
        return in == null ? null : new JsonList(in, p);
    }

    public static JsonList ofText(Reader in, Parser p) throws ParseException {
        return in == null ? null : new JsonList(in);
    }

    public JsonList() {
    }

    public JsonList(BeanSession session) {
        this.session = session;
    }

    public JsonList(CharSequence json) throws ParseException {
        this(json, (Parser)JsonParser.DEFAULT);
    }

    public JsonList(CharSequence in, Parser p) throws ParseException {
        this(p == null ? BeanContext.DEFAULT_SESSION : p.getBeanContext().getSession());
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        if (Utils.nn(in)) {
            p.parseIntoCollection(in, this, this.bs().object());
        }
    }

    public JsonList(Collection<?> copyFrom) {
        super(copyFrom);
    }

    public JsonList(Object ... entries) {
        Collections.addAll(this, entries);
    }

    public JsonList(Reader json) throws ParseException {
        this.parse(json, JsonParser.DEFAULT);
    }

    public JsonList(Reader in, Parser p) throws ParseException {
        this(p == null ? BeanContext.DEFAULT_SESSION : p.getBeanContext().getSession());
        this.parse(in, p);
    }

    public JsonList append(Collection<?> values) {
        if (Utils.nn(values)) {
            this.addAll(values);
        }
        return this;
    }

    public JsonList append(Object value) {
        this.add(value);
        return this;
    }

    public JsonList append(Object ... values) {
        Collections.addAll(this, values);
        return this;
    }

    public JsonList appendIf(boolean flag, Object value) {
        if (flag) {
            this.append(value);
        }
        return this;
    }

    public <T> JsonList appendIf(Predicate<T> test, T value) {
        return this.appendIf(PredicateUtils.test(test, value), value);
    }

    public JsonList appendReverse(List<?> values) {
        ListIterator<?> i = values.listIterator(values.size());
        while (i.hasPrevious()) {
            this.add(i.previous());
        }
        return this;
    }

    public JsonList appendReverse(Object ... values) {
        for (int i = values.length - 1; i >= 0; --i) {
            this.add(values[i]);
        }
        return this;
    }

    public String asJson() {
        return this.toString();
    }

    public String asString() {
        return Json5Serializer.DEFAULT.toString(this);
    }

    public String asString(WriterSerializer serializer) {
        return serializer.toString(this);
    }

    public Object cast(ClassMeta<?> cm) {
        try {
            return JsonParser.DEFAULT.parse(Json5Serializer.DEFAULT.serialize(this), cm);
        }
        catch (ParseException | SerializeException e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    public Object deleteAt(String path) {
        return this.getObjectRest().delete(path);
    }

    public <E> Iterable<E> elements(final Class<E> childType) {
        final Iterator iterator = this.iterator();
        return () -> new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return JsonList.this.bs().convertToType(iterator.next(), childType);
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public <T> T get(int index, Class<T> type) {
        return this.bs().convertToType(this.get(index), type);
    }

    public <T> T get(int index, Type type, Type ... args) {
        return this.bs().convertToType(this.get(index), type, args);
    }

    public <T> T getAt(String path, Class<T> type) {
        return this.getObjectRest().get(path, type);
    }

    public <T> T getAt(String path, Type type, Type ... args) {
        return this.getObjectRest().get(path, type, args);
    }

    public BeanSession getBeanSession() {
        return this.session;
    }

    public Boolean getBoolean(int index) {
        return this.get(index, Boolean.class);
    }

    public ClassMeta<?> getClassMeta(int index) {
        return this.bs().getClassMetaForObject(this.get(index));
    }

    public Integer getInt(int index) {
        return this.get(index, Integer.class);
    }

    public JsonList getList(int index) {
        return this.get(index, JsonList.class);
    }

    public <E> List<E> getList(int index, Class<E> elementType) {
        return (List)this.bs().convertToType(this.get(index), (Type)((Object)List.class), elementType);
    }

    public Long getLong(int index) {
        return this.get(index, Long.class);
    }

    public JsonMap getMap(int index) {
        return this.get(index, JsonMap.class);
    }

    public <K, V> Map<K, V> getMap(int index, Class<K> keyType, Class<V> valType) {
        return (Map)this.bs().convertToType(this.get(index), (Type)((Object)Map.class), keyType, valType);
    }

    public String getString(int index) {
        return this.get(index, String.class);
    }

    public boolean isUnmodifiable() {
        return false;
    }

    public JsonList modifiable() {
        if (this.isUnmodifiable()) {
            return new JsonList((Collection<?>)this);
        }
        return this;
    }

    public Object postAt(String path, Object o) {
        return this.getObjectRest().post(path, o);
    }

    public Object putAt(String path, Object o) {
        return this.getObjectRest().put(path, o);
    }

    public JsonList session(BeanSession session) {
        this.session = session;
        return this;
    }

    public JsonList setBeanSession(BeanSession value) {
        this.session = value;
        return this;
    }

    @Override
    public String toString() {
        return Json5.of(this);
    }

    public JsonList unmodifiable() {
        JsonList jsonList = this;
        if (jsonList instanceof UnmodifiableJsonList) {
            UnmodifiableJsonList this2 = (UnmodifiableJsonList)jsonList;
            return this2;
        }
        return new UnmodifiableJsonList(this);
    }

    public JsonList writeTo(Writer w) throws IOException, SerializeException {
        JsonSerializer.DEFAULT.serialize(this, w);
        return this;
    }

    private ObjectRest getObjectRest() {
        if (this.objectRest == null) {
            this.objectRest = new ObjectRest(this);
        }
        return this.objectRest;
    }

    private void parse(Reader r, Parser p) throws ParseException {
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        p.parseIntoCollection(r, this, this.bs().object());
    }

    BeanSession bs() {
        if (this.session == null) {
            this.session = BeanContext.DEFAULT_SESSION;
        }
        return this.session;
    }

    private static class UnmodifiableJsonList
    extends JsonList {
        private static final long serialVersionUID = 1L;

        UnmodifiableJsonList(JsonList contents) {
            if (Utils.nn(contents)) {
                contents.forEach(x$0 -> super.add(x$0));
            }
        }

        @Override
        public void add(int location, Object object) {
            throw ThrowableUtils.unsupportedOpReadOnly();
        }

        @Override
        public boolean isUnmodifiable() {
            return true;
        }

        @Override
        public Object remove(int location) {
            throw ThrowableUtils.unsupportedOpReadOnly();
        }

        @Override
        public Object set(int location, Object object) {
            throw ThrowableUtils.unsupportedOpReadOnly();
        }
    }
}

