/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.FilterFactory;
import org.apache.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.tsfile.read.reader.series.PaginationController;

public class SeriesScanOptions {
    private Filter globalTimeFilter;
    private Filter pushDownFilter;
    private final long pushDownLimit;
    private final long pushDownOffset;
    private final Set<String> allSensors;

    public SeriesScanOptions(Filter globalTimeFilter, Filter pushDownFilter, long pushDownLimit, long pushDownOffset, Set<String> allSensors) {
        this.globalTimeFilter = globalTimeFilter;
        this.pushDownFilter = pushDownFilter;
        this.pushDownLimit = pushDownLimit;
        this.pushDownOffset = pushDownOffset;
        this.allSensors = allSensors;
    }

    public static SeriesScanOptions getDefaultSeriesScanOptions(PartialPath seriesPath) {
        Builder builder = new Builder();
        if (seriesPath instanceof AlignedPath) {
            builder.withAllSensors(new HashSet<String>(((AlignedPath)seriesPath).getMeasurementList()));
        } else {
            builder.withAllSensors(new HashSet<String>(Collections.singletonList(seriesPath.getMeasurement())));
        }
        return builder.build();
    }

    public Filter getGlobalTimeFilter() {
        return this.globalTimeFilter;
    }

    public Filter getPushDownFilter() {
        return this.pushDownFilter;
    }

    public Set<String> getAllSensors() {
        return this.allSensors;
    }

    public PaginationController getPaginationController() {
        return new PaginationController(this.pushDownLimit, this.pushDownOffset);
    }

    public void setTTL(long dataTTL) {
        this.globalTimeFilter = SeriesScanOptions.updateFilterUsingTTL(this.globalTimeFilter, dataTTL);
    }

    public static Filter updateFilterUsingTTL(Filter filter, long dataTTL) {
        if (dataTTL != Long.MAX_VALUE) {
            filter = filter != null ? FilterFactory.and((Filter)filter, (Filter)TimeFilterApi.gtEq((long)(CommonDateTimeUtils.currentTime() - dataTTL))) : TimeFilterApi.gtEq((long)(CommonDateTimeUtils.currentTime() - dataTTL));
        }
        return filter;
    }

    public static class Builder {
        private Filter globalTimeFilter = null;
        private Filter pushDownFilter = null;
        private long pushDownLimit = 0L;
        private long pushDownOffset = 0L;
        private Set<String> allSensors;

        public Builder withGlobalTimeFilter(Filter globalTimeFilter) {
            this.globalTimeFilter = globalTimeFilter;
            return this;
        }

        public Builder withPushDownFilter(Filter pushDownFilter) {
            this.pushDownFilter = pushDownFilter;
            return this;
        }

        public Builder withPushDownLimit(long pushDownLimit) {
            this.pushDownLimit = pushDownLimit;
            return this;
        }

        public Builder withPushDownOffset(long pushDownOffset) {
            this.pushDownOffset = pushDownOffset;
            return this;
        }

        public void withAllSensors(Set<String> allSensors) {
            this.allSensors = allSensors;
        }

        public SeriesScanOptions build() {
            return new SeriesScanOptions(this.globalTimeFilter, this.pushDownFilter, this.pushDownLimit, this.pushDownOffset, this.allSensors);
        }
    }
}

