/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.Node;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceNode;

public class InstanceNode
extends Node
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11879");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11889");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11887");

    public InstanceNode(NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, ReferenceNode[] references) {
        super(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references);
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    protected InstanceNode(InstanceNodeBuilder<?, ?> b) {
        super((Node.NodeBuilder<?, ?>)b);
    }

    public static InstanceNodeBuilder<?, ?> builder() {
        return new InstanceNodeBuilderImpl();
    }

    public InstanceNodeBuilder<?, ?> toBuilder() {
        return new InstanceNodeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceNode)) {
            return false;
        }
        InstanceNode other = (InstanceNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InstanceNode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "InstanceNode()";
    }

    private static final class InstanceNodeBuilderImpl
    extends InstanceNodeBuilder<InstanceNode, InstanceNodeBuilderImpl> {
        private InstanceNodeBuilderImpl() {
        }

        @Override
        protected InstanceNodeBuilderImpl self() {
            return this;
        }

        @Override
        public InstanceNode build() {
            return new InstanceNode(this);
        }
    }

    public static abstract class InstanceNodeBuilder<C extends InstanceNode, B extends InstanceNodeBuilder<C, B>>
    extends Node.NodeBuilder<C, B> {
        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            InstanceNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(InstanceNode instance, InstanceNodeBuilder<?, ?> b) {
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "InstanceNode.InstanceNodeBuilder(super=" + super.toString() + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<InstanceNode> {
        @Override
        public Class<InstanceNode> getType() {
            return InstanceNode.class;
        }

        @Override
        public InstanceNode decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            NodeClass nodeClass = decoder.readEnum("NodeClass", NodeClass.class);
            QualifiedName browseName = decoder.readQualifiedName("BrowseName");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            ReferenceNode[] references = (ReferenceNode[])decoder.readStructArray("References", ReferenceNode.TYPE_ID);
            return new InstanceNode(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, InstanceNode value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeEnum("NodeClass", value.getNodeClass());
            encoder.writeQualifiedName("BrowseName", value.getBrowseName());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeStructArray("References", (Object[])value.getReferences(), ReferenceNode.TYPE_ID);
        }
    }
}

