/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.io.netty.handler.ipfilter;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.shaded.io.netty.channel.ChannelFuture;
import org.apache.ignite.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.ignite.shaded.io.netty.channel.ChannelHandler;
import org.apache.ignite.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.ignite.shaded.io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import org.apache.ignite.shaded.io.netty.util.concurrent.GenericFutureListener;

@ChannelHandler.Sharable
public class UniqueIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final Set<InetAddress> connected = ConcurrentHashMap.newKeySet();

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        final InetAddress remoteIp = remoteAddress.getAddress();
        if (!this.connected.add(remoteIp)) {
            return false;
        }
        ctx.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                UniqueIpFilter.this.connected.remove(remoteIp);
            }
        });
        return true;
    }
}

