/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.uri;

import java.io.File;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.spi.IgniteSpiException;

class GridUriDeploymentFileResourceLoader {
    private final ClassLoader clsLdr;
    private final File scanPathDir;

    GridUriDeploymentFileResourceLoader(ClassLoader clsLdr, File scanPathDir) {
        this.clsLdr = clsLdr;
        this.scanPathDir = scanPathDir;
    }

    Class<? extends ComputeTask<?, ?>> createResource(String fileName, boolean ignoreUnknownRsrc) throws IgniteSpiException {
        block4: {
            if (this.scanPathDir.isDirectory()) {
                fileName = fileName.substring(this.scanPathDir.getAbsolutePath().length() + 1);
            }
            if (fileName.endsWith(".class")) {
                String str = fileName;
                str = str.replaceAll("\\/|\\\\", ".");
                str = str.substring(0, str.indexOf(".class"));
                try {
                    return this.clsLdr.loadClass(str);
                }
                catch (ClassNotFoundException e) {
                    if (ignoreUnknownRsrc) break block4;
                    throw new IgniteSpiException("Failed to load class: " + str, (Throwable)e);
                }
            }
        }
        return null;
    }
}

