/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.List;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryListener;
import org.junit.platform.engine.OutputDirectoryCreator;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;

@API(status=API.Status.STABLE, since="1.0")
public interface EngineDiscoveryRequest {
    public <T extends DiscoverySelector> List<T> getSelectorsByType(Class<T> var1);

    public <T extends DiscoveryFilter<?>> List<T> getFiltersByType(Class<T> var1);

    public ConfigurationParameters getConfigurationParameters();

    @API(status=API.Status.STABLE, since="1.10")
    default public EngineDiscoveryListener getDiscoveryListener() {
        return EngineDiscoveryListener.NOOP;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.14")
    default public OutputDirectoryProvider getOutputDirectoryProvider() {
        return OutputDirectoryProvider.castOrAdapt(this.getOutputDirectoryCreator());
    }

    @API(status=API.Status.MAINTAINED, since="1.14")
    default public OutputDirectoryCreator getOutputDirectoryCreator() {
        throw new JUnitException("OutputDirectoryCreator not available; probably due to unaligned versions of the junit-platform-engine and junit-platform-launcher jars on the classpath/module path.");
    }
}

