/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.grails.forge.api.options;

import io.micronaut.context.MessageSource;
import io.micronaut.context.i18n.ResourceBundleMessageSource;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import org.grails.forge.api.RequestInfo;
import org.grails.forge.api.SelectOptionsDTO;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

/**
 * Gets Information about select options for the Grails Forge.
 *
 * @since 6.0.0
 */
@Controller("/select-options")
public class SelectOptionsController implements SelectOptionsOperations {

    @Inject
    MessageSource messageSource;

    /**
     * Gets select options for the Grails Forge
     *
     * @return Select Options and their defaults.
     */
    @Override
    @Get(uri = "/", produces = MediaType.APPLICATION_JSON)
    public SelectOptionsDTO selectOptions(RequestInfo requestInfo) {
        MessageSource.MessageContext context = MessageSource.MessageContext.of(requestInfo.getLocale());
        return SelectOptionsDTO.make(messageSource, context);
    }

    @Singleton
    static class SelectOptionMessages extends ResourceBundleMessageSource {
        SelectOptionMessages() {
            super("select_options");
        }
    }
}
