/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flex.compiler.internal.graph.IGraph;
import org.apache.flex.compiler.internal.graph.IGraphEdge;

public class Graph<V, E extends IGraphEdge<V>>
implements IGraph<V, E> {
    private final Map<V, Map<V, E>> vertexToOutgoingEdges = new HashMap<V, Map<V, E>>();
    private final Map<V, Map<V, E>> vertexToIncomingEdges = new HashMap<V, Map<V, E>>();

    public Graph() {
        assert (this.vertexToOutgoingEdges.size() == this.vertexToIncomingEdges.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addVertex(V vertex) {
        try {
            assert (this.vertexToOutgoingEdges.size() == this.vertexToIncomingEdges.size());
            boolean vertexExists = this.vertexToOutgoingEdges.containsKey(vertex);
            assert (vertexExists == this.vertexToIncomingEdges.containsKey(vertex));
            if (!vertexExists) {
                this.vertexToOutgoingEdges.put(vertex, null);
                this.vertexToIncomingEdges.put(vertex, null);
                boolean bl = !vertexExists;
                return bl;
            }
        }
        finally {
            assert (this.vertexToOutgoingEdges.size() == this.vertexToIncomingEdges.size());
        }
        return false;
    }

    private void removeVertex(Map<V, Map<V, E>> vertexMap, V vertex) {
        Map<V, E> edgeMap = vertexMap.get(vertex);
        if (edgeMap != null) {
            ArrayList<E> outgoingEdges = new ArrayList<E>(edgeMap.values());
            for (IGraphEdge e : outgoingEdges) {
                this.removeEdge(e);
            }
        }
    }

    @Override
    public void removeVertex(V vertex) {
        assert (this.vertexToOutgoingEdges.size() == this.vertexToIncomingEdges.size());
        try {
            this.removeVertex(this.vertexToOutgoingEdges, vertex);
            this.removeVertex(this.vertexToIncomingEdges, vertex);
            this.vertexToOutgoingEdges.remove(vertex);
            this.vertexToIncomingEdges.remove(vertex);
        }
        finally {
            assert (this.vertexToOutgoingEdges.size() == this.vertexToIncomingEdges.size());
        }
    }

    public void addVertices(Collection<V> vertices) {
        for (V v : vertices) {
            this.addVertex(v);
        }
    }

    private E addEdgeToVertexMap(Map<V, Map<V, E>> vertexMap, V v1, V v2, E edge) {
        Map<E, E> edgeMap = vertexMap.get(v1);
        if (edgeMap == null) {
            edgeMap = new HashMap<V, E>();
            vertexMap.put((Map<E, E>)v1, (Map<Map<E, E>, E>)edgeMap);
        }
        return (E)((IGraphEdge)edgeMap.put(v2, edge));
    }

    private E removeEdgeFromVertexMap(Map<V, Map<V, E>> vertexMap, V v1, V v2) {
        Map<V, E> edgeMap = vertexMap.get(v1);
        if (edgeMap == null) {
            return null;
        }
        return (E)((IGraphEdge)edgeMap.remove(v2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E setEdge(E edge) {
        try {
            assert (this.vertexToOutgoingEdges.size() == this.vertexToIncomingEdges.size());
            E existingOutgoingEdge = this.addEdgeToVertexMap(this.vertexToOutgoingEdges, edge.getFrom(), edge.getTo(), edge);
            E existingIncomingEdge = this.addEdgeToVertexMap(this.vertexToIncomingEdges, edge.getTo(), edge.getFrom(), edge);
            assert (existingOutgoingEdge == existingIncomingEdge);
            E e = existingOutgoingEdge;
            return e;
        }
        finally {
            assert (this.vertexToOutgoingEdges.size() == this.vertexToIncomingEdges.size());
        }
    }

    private Set<E> getEdgeSet(Map<V, Map<V, E>> vertexMap, V v) {
        Map<V, E> edgeMap = vertexMap.get(v);
        HashSet<E> result = Collections.EMPTY_SET;
        if (edgeMap != null && edgeMap.size() > 0) {
            Collection<E> edges = edgeMap.values();
            result = new HashSet<E>(edges.size());
            result.addAll(edges);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<E> getOutgoingEdges(V vertex) {
        return this.getEdgeSet(this.vertexToOutgoingEdges, vertex);
    }

    @Override
    public Set<E> getIncomingEdges(V vertex) {
        return this.getEdgeSet(this.vertexToIncomingEdges, vertex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E removeEdge(E edge) {
        try {
            assert (this.vertexToOutgoingEdges.size() == this.vertexToIncomingEdges.size());
            E outgoingRemoved = this.removeEdgeFromVertexMap(this.vertexToOutgoingEdges, edge.getFrom(), edge.getTo());
            E incomingRemoved = this.removeEdgeFromVertexMap(this.vertexToIncomingEdges, edge.getTo(), edge.getFrom());
            assert (outgoingRemoved == incomingRemoved);
            E e = outgoingRemoved;
            return e;
        }
        finally {
            assert (this.vertexToOutgoingEdges.size() == this.vertexToIncomingEdges.size());
        }
    }

    @Override
    public Set<V> getVertices() {
        assert (this.vertexToOutgoingEdges.size() == this.vertexToIncomingEdges.size());
        return Collections.unmodifiableSet(this.vertexToIncomingEdges.keySet());
    }

    @Override
    public E getEdge(V from, V to) {
        assert (this.vertexToOutgoingEdges.size() == this.vertexToIncomingEdges.size());
        Map<V, E> edgeMap = this.vertexToOutgoingEdges.get(from);
        if (edgeMap != null) {
            return (E)((IGraphEdge)edgeMap.get(to));
        }
        return null;
    }
}

