/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.actions;

import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldifeditor.editor.LdifEditor;
import org.apache.directory.studio.ldifeditor.editor.actions.AbstractLdifAction;
import org.apache.directory.studio.ldifeditor.editor.actions.Messages;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;

public class FormatLdifRecordAction
extends AbstractLdifAction {
    public FormatLdifRecordAction(LdifEditor editor) {
        super(Messages.getString("FormatLdifRecordAction.FormatRecord"), editor);
    }

    @Override
    protected void doRun() {
        LdifContainer[] containers = super.getSelectedLdifContainers();
        if (containers.length > 0) {
            IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            String old = document.get();
            StringBuffer sb = new StringBuffer();
            sb.append(old.substring(0, containers[0].getOffset()));
            int i = 0;
            while (i < containers.length) {
                LdifContainer container = containers[i];
                sb.append(container.toFormattedString(Utils.getLdifFormatParameters()));
                ++i;
            }
            sb.append(old.substring(containers[containers.length - 1].getOffset() + containers[containers.length - 1].getLength(), old.length()));
            ISourceViewer sourceViewer = (ISourceViewer)this.editor.getAdapter(ISourceViewer.class);
            int topIndex = sourceViewer.getTopIndex();
            document.set(sb.toString());
            sourceViewer.setTopIndex(topIndex);
        }
    }

    public void update() {
        LdifContainer[] ldifContainers = super.getSelectedLdifContainers();
        int i = 0;
        while (i < ldifContainers.length) {
            LdifContainer container = ldifContainers[i];
            if (!(container instanceof LdifRecord)) {
                super.setEnabled(false);
                return;
            }
            ++i;
        }
        super.setEnabled(true);
    }
}

