/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui;

import java.io.IOException;
import java.net.URL;
import java.util.PropertyResourceBundle;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IAuthHandler;
import org.apache.directory.studio.connection.core.ICertificateHandler;
import org.apache.directory.studio.connection.core.IReferralHandler;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.ConnectionUICertificateHandler;
import org.apache.directory.studio.connection.ui.ConnectionUIReferralHandler;
import org.apache.directory.studio.connection.ui.ExceptionHandler;
import org.apache.directory.studio.connection.ui.Messages;
import org.apache.directory.studio.connection.ui.UIAuthHandler;
import org.apache.directory.studio.connection.ui.UiThreadEventRunner;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ConnectionUIPlugin
extends AbstractUIPlugin {
    private static ConnectionUIPlugin plugin;
    private ExceptionHandler exceptionHandler;
    private EventRunner eventRunner;
    private PropertyResourceBundle properties;

    public ConnectionUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new ExceptionHandler();
        }
        if (this.eventRunner == null) {
            this.eventRunner = new UiThreadEventRunner();
        }
        ConnectionCorePlugin defaultPlugin = ConnectionCorePlugin.getDefault();
        defaultPlugin.setAuthHandler((IAuthHandler)new UIAuthHandler());
        defaultPlugin.setReferralHandler((IReferralHandler)new ConnectionUIReferralHandler());
        defaultPlugin.setCertificateHandler((ICertificateHandler)new ConnectionUICertificateHandler());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (this.exceptionHandler != null) {
            this.exceptionHandler = null;
        }
        if (this.eventRunner != null) {
            this.eventRunner = null;
        }
    }

    public static ConnectionUIPlugin getDefault() {
        return plugin;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        URL url;
        if (key != null && (url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(key), null)) != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }

    public Image getImage(String key) {
        ImageDescriptor imageDescriptor;
        Image image = this.getImageRegistry().get(key);
        if (image == null && (imageDescriptor = this.getImageDescriptor(key)) != null) {
            image = imageDescriptor.createImage();
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    public EventRunner getEventRunner() {
        return this.eventRunner;
    }

    public PropertyResourceBundle getPluginProperties() {
        if (this.properties == null) {
            try {
                this.properties = new PropertyResourceBundle(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("plugin.properties"), (boolean)false));
            }
            catch (IOException e) {
                this.getLog().log((IStatus)new Status(4, "org.apache.directory.studio.connection.ui", 0, Messages.getString("ConnectionUIPlugin.UnableGetPluginProperties"), (Throwable)e));
            }
        }
        return this.properties;
    }
}

