/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class ReturningAttributesContentAssistProcessor
implements ISubjectControlContentAssistProcessor {
    private char[] autoActivationCharacters;
    private List<String> proposals;

    public ReturningAttributesContentAssistProcessor(List<String> proposals) {
        this.setProposals(proposals);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationCharacters;
    }

    public void setProposals(List<String> newProposals) {
        this.proposals = newProposals == null ? new ArrayList<String>() : newProposals;
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if ("+".equals(o1) && !"+".equals(o2)) {
                    return 4;
                }
                if ("+".equals(o2) && !"+".equals(o1)) {
                    return -4;
                }
                if ("*".equals(o1) && !"*".equals(o2)) {
                    return 3;
                }
                if ("*".equals(o2) && !"*".equals(o1)) {
                    return -3;
                }
                if (o1.startsWith("@") && !o2.startsWith("@")) {
                    return 2;
                }
                if (o2.startsWith("@") && !o1.startsWith("@")) {
                    return -2;
                }
                return o1.compareToIgnoreCase(o2);
            }
        };
        Collections.sort(this.proposals, comparator);
        HashSet<Character> characterSet = new HashSet<Character>();
        for (String string : this.proposals) {
            int k = 0;
            while (k < string.length()) {
                char ch = string.charAt(k);
                characterSet.add(Character.valueOf(Character.toLowerCase(ch)));
                characterSet.add(Character.valueOf(Character.toUpperCase(ch)));
                ++k;
            }
        }
        this.autoActivationCharacters = new char[characterSet.size()];
        int i = 0;
        for (Character ch : characterSet) {
            this.autoActivationCharacters[i] = ch.charValue();
            ++i;
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        IDocument document = contentAssistSubjectControl.getDocument();
        String text = document.get();
        int start = 0;
        int i = documentOffset - 1;
        while (i >= 0) {
            char c = text.charAt(i);
            if (c == ',' || Character.isWhitespace(c)) {
                start = i + 1;
                break;
            }
            --i;
        }
        String attribute = text.substring(start, documentOffset);
        ArrayList<CompletionProposal> proposalList = new ArrayList<CompletionProposal>();
        for (String string : this.proposals) {
            if (!string.toUpperCase().startsWith(attribute.toUpperCase())) continue;
            CompletionProposal proposal = new CompletionProposal(String.valueOf(string) + ", ", start, documentOffset - start, string.length() + 2, null, string, null, null);
            proposalList.add(proposal);
        }
        return proposalList.toArray(new ICompletionProposal[proposalList.size()]);
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

