/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.search;

import java.util.ArrayList;
import org.apache.directory.api.ldap.model.filter.FilterEncoder;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.search.AbstractFilter;

final class SubstringFilter
extends AbstractFilter {
    private String attribute;
    private String initial;
    private String[] any;
    private String end;

    private SubstringFilter(String attribute, String initial, String[] any, String end) {
        this.attribute = attribute;
        this.initial = initial;
        if (any != null && any.length != 0) {
            ArrayList<String> anyList = new ArrayList<String>();
            for (String string : any) {
                if (Strings.isEmpty((String)string)) continue;
                anyList.add(string);
            }
            if (!anyList.isEmpty()) {
                this.any = anyList.toArray(new String[0]);
            }
        }
        this.end = end;
    }

    public static SubstringFilter startsWith(String attribute, String ... parts) {
        if (parts != null && parts.length > 0) {
            if (parts.length > 1) {
                String[] any = new String[parts.length - 1];
                System.arraycopy(parts, 1, any, 0, any.length);
                return new SubstringFilter(attribute, parts[0], any, null);
            }
            return new SubstringFilter(attribute, parts[0], null, null);
        }
        return new SubstringFilter(attribute, null, null, null);
    }

    public static SubstringFilter endsWith(String attribute, String ... parts) {
        if (parts != null && parts.length > 0) {
            if (parts.length > 1) {
                String[] any = new String[parts.length - 1];
                System.arraycopy(parts, 0, any, 0, any.length);
                return new SubstringFilter(attribute, null, any, parts[parts.length - 1]);
            }
            return new SubstringFilter(attribute, null, null, parts[0]);
        }
        return new SubstringFilter(attribute, null, null, null);
    }

    public static SubstringFilter contains(String attribute, String ... parts) {
        if (parts != null && parts.length > 0) {
            if (parts.length > 1) {
                String[] any = new String[parts.length];
                System.arraycopy(parts, 0, any, 0, any.length);
                return new SubstringFilter(attribute, null, any, null);
            }
            return new SubstringFilter(attribute, null, parts, null);
        }
        return new SubstringFilter(attribute, null, null, null);
    }

    public static SubstringFilter substring(String attribute, String ... parts) {
        if (parts != null && parts.length > 0) {
            if (parts.length > 2) {
                String[] any = new String[parts.length - 2];
                System.arraycopy(parts, 1, any, 0, any.length);
                return new SubstringFilter(attribute, parts[0], any, parts[parts.length - 1]);
            }
            if (parts.length > 1) {
                return new SubstringFilter(attribute, parts[0], null, parts[1]);
            }
            return new SubstringFilter(attribute, parts[0], null, null);
        }
        return new SubstringFilter(attribute, null, null, null);
    }

    @Override
    public StringBuilder build(StringBuilder builder) {
        builder.append("(").append(this.attribute).append('=');
        if (!Strings.isEmpty((String)this.initial)) {
            builder.append(FilterEncoder.encodeFilterValue((String)this.initial));
        }
        if (this.any != null) {
            for (String string : this.any) {
                builder.append('*').append(FilterEncoder.encodeFilterValue((String)string));
            }
        }
        builder.append('*');
        if (!Strings.isEmpty((String)this.end)) {
            builder.append(FilterEncoder.encodeFilterValue((String)this.end));
        }
        builder.append(")");
        return builder;
    }
}

