/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.hierarchy;

import java.util.List;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.hierarchy.RootObject;

public class HierarchyManager {
    private MultiValuedMap<Object, Object> parentsMap = new ArrayListValuedHashMap();
    private MultiValuedMap<Object, Object> childrenMap = new ArrayListValuedHashMap();
    private SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
    private RootObject root;

    public HierarchyManager() {
        this.loadSchema();
    }

    private void addAttributeType(AttributeType at) {
        this.checkAliasesAndOID((SchemaObject)at);
        String superiorName = at.getSuperiorOid();
        if (superiorName != null) {
            AttributeType superior = this.schemaHandler.getAttributeType(superiorName);
            if (superior != null) {
                this.parentsMap.put((Object)at, (Object)superior);
                this.childrenMap.put((Object)superior, (Object)at);
            } else {
                this.parentsMap.put((Object)at, (Object)Strings.toLowerCase((String)superiorName));
                this.childrenMap.put((Object)Strings.toLowerCase((String)superiorName), (Object)at);
                this.childrenMap.put((Object)this.root, (Object)at);
            }
        } else {
            this.parentsMap.put((Object)at, (Object)this.root);
            this.childrenMap.put((Object)this.root, (Object)at);
        }
    }

    private void addObjectClass(ObjectClass oc) {
        this.checkAliasesAndOID((SchemaObject)oc);
        List superClasseNames = oc.getSuperiorOids();
        if (superClasseNames != null && superClasseNames.size() > 0) {
            for (String superClassName : superClasseNames) {
                ObjectClass superClass = this.schemaHandler.getObjectClass(superClassName);
                if (superClass == null) {
                    this.parentsMap.put((Object)oc, (Object)Strings.toLowerCase((String)superClassName));
                    this.childrenMap.put((Object)Strings.toLowerCase((String)superClassName), (Object)oc);
                    this.childrenMap.put((Object)this.root, (Object)oc);
                    continue;
                }
                this.parentsMap.put((Object)oc, (Object)superClass);
                this.childrenMap.put((Object)superClass, (Object)oc);
            }
        } else {
            ObjectClass topOC = this.schemaHandler.getObjectClass("2.5.6.0");
            if (oc.equals((Object)topOC)) {
                this.parentsMap.put((Object)oc, (Object)this.root);
                this.childrenMap.put((Object)this.root, (Object)oc);
            } else if (topOC != null) {
                this.parentsMap.put((Object)oc, (Object)topOC);
                this.childrenMap.put((Object)topOC, (Object)oc);
            } else {
                this.parentsMap.put((Object)oc, (Object)"2.5.6.0");
                this.childrenMap.put((Object)"2.5.6.0", (Object)oc);
                this.childrenMap.put((Object)this.root, (Object)oc);
            }
        }
    }

    public void attributeTypeAdded(AttributeType at) {
        this.addAttributeType(at);
    }

    public void attributeTypeModified(AttributeType at) {
        List<Object> parents = this.getParents(at);
        if (parents != null) {
            for (Object parent : parents) {
                this.childrenMap.removeMapping(parent, (Object)at);
            }
            this.parentsMap.remove((Object)at);
        }
        this.addAttributeType(at);
    }

    public void attributeTypeRemoved(AttributeType at) {
        this.removeAttributeType(at);
    }

    private void checkAliasesAndOID(SchemaObject object) {
        List children;
        String oid;
        List aliases = object.getNames();
        if (aliases != null) {
            for (String alias : aliases) {
                List children2 = (List)this.childrenMap.get((Object)Strings.toLowerCase((String)alias));
                if (children2 == null) continue;
                for (Object value : children2) {
                    this.childrenMap.put((Object)object, value);
                    this.parentsMap.removeMapping(value, (Object)Strings.toLowerCase((String)alias));
                    this.parentsMap.put(value, (Object)object);
                }
                this.childrenMap.remove((Object)Strings.toLowerCase((String)alias));
            }
        }
        if ((oid = object.getOid()) != null && (children = (List)this.childrenMap.get((Object)Strings.toLowerCase((String)oid))) != null) {
            for (Object value : children) {
                this.childrenMap.put((Object)object, value);
                if (oid.equals("2.5.6.0")) {
                    this.childrenMap.removeMapping((Object)this.root, value);
                }
                this.parentsMap.removeMapping(value, (Object)Strings.toLowerCase((String)oid));
                this.parentsMap.put(value, (Object)object);
            }
            this.childrenMap.remove((Object)Strings.toLowerCase((String)oid));
        }
    }

    public List<Object> getChildren(Object o) {
        return (List)this.childrenMap.get(o);
    }

    public List<Object> getParents(Object o) {
        return (List)this.parentsMap.get(o);
    }

    public RootObject getRootObject() {
        return this.root;
    }

    private void loadSchema() {
        if (this.schemaHandler != null) {
            this.root = new RootObject();
            for (Schema schema : this.schemaHandler.getSchemas()) {
                for (AttributeType at : schema.getAttributeTypes()) {
                    this.addAttributeType(at);
                }
                for (ObjectClass oc : schema.getObjectClasses()) {
                    this.addObjectClass(oc);
                }
            }
        }
    }

    public void objectClassAdded(ObjectClass oc) {
        this.addObjectClass(oc);
    }

    public void objectClassModified(ObjectClass oc) {
        List<Object> parents = this.getParents(oc);
        if (parents != null) {
            for (Object parent : parents) {
                this.childrenMap.removeMapping(parent, (Object)oc);
            }
            this.parentsMap.remove((Object)oc);
        }
        this.addObjectClass(oc);
    }

    public void objectClassRemoved(ObjectClass oc) {
        this.removeObjectClass(oc);
    }

    private void removeAttributeType(AttributeType at) {
        String superiorName = at.getSuperiorOid();
        if (superiorName != null && !"".equals(superiorName)) {
            AttributeType superiorAT = this.schemaHandler.getAttributeType(superiorName);
            if (superiorAT == null) {
                this.childrenMap.removeMapping((Object)Strings.toLowerCase((String)superiorName), (Object)at);
            } else {
                this.childrenMap.removeMapping((Object)superiorAT, (Object)at);
            }
        } else {
            this.childrenMap.removeMapping((Object)this.root, (Object)at);
        }
        List<Object> children = this.getChildren(at);
        if (children != null) {
            for (Object child : children) {
                AttributeType childAT = (AttributeType)child;
                this.parentsMap.removeMapping(child, (Object)at);
                this.parentsMap.put(child, (Object)this.root);
                this.childrenMap.put((Object)this.root, child);
                String childSuperiorName = childAT.getSuperiorOid();
                if (childSuperiorName == null || "".equals(childSuperiorName)) continue;
                this.parentsMap.put(child, (Object)Strings.toLowerCase((String)childSuperiorName));
                this.childrenMap.put((Object)Strings.toLowerCase((String)childSuperiorName), child);
            }
        }
        this.childrenMap.remove((Object)at);
        this.parentsMap.remove((Object)at);
    }

    private void removeObjectClass(ObjectClass oc) {
        List superClassesNames = oc.getSuperiorOids();
        if (superClassesNames != null && superClassesNames.size() > 0) {
            for (String superClassName : superClassesNames) {
                if ("".equals(superClassName)) continue;
                ObjectClass superClassOC = this.schemaHandler.getObjectClass(superClassName);
                if (superClassOC == null) {
                    this.childrenMap.removeMapping((Object)Strings.toLowerCase((String)superClassName), (Object)oc);
                    this.childrenMap.removeMapping((Object)this.root, (Object)oc);
                    continue;
                }
                this.childrenMap.removeMapping((Object)superClassOC, (Object)oc);
            }
        } else if (oc.getOid().equals("2.5.6.0")) {
            this.childrenMap.removeMapping((Object)this.root, (Object)oc);
        } else {
            ObjectClass topOC = this.schemaHandler.getObjectClass("2.5.6.0");
            if (topOC != null) {
                this.childrenMap.removeMapping((Object)topOC, (Object)oc);
            } else {
                this.childrenMap.removeMapping((Object)"2.5.6.0", (Object)oc);
            }
        }
        List<Object> children = this.getChildren(oc);
        if (children != null) {
            for (Object child : children) {
                ObjectClass childOC = (ObjectClass)child;
                this.parentsMap.removeMapping(child, (Object)oc);
                this.parentsMap.put(child, (Object)this.root);
                this.childrenMap.put((Object)this.root, child);
                List childSuperClassesNames = childOC.getSuperiorOids();
                if (childSuperClassesNames != null && childSuperClassesNames.size() > 0) {
                    String correctSuperClassName = this.getCorrectSuperClassName(oc, childSuperClassesNames);
                    if (correctSuperClassName == null) continue;
                    this.parentsMap.put(child, (Object)Strings.toLowerCase((String)correctSuperClassName));
                    this.childrenMap.put((Object)Strings.toLowerCase((String)correctSuperClassName), child);
                    continue;
                }
                this.parentsMap.put(child, (Object)"2.5.6.0");
                this.childrenMap.put((Object)"2.5.6.0", child);
            }
        }
        this.childrenMap.remove((Object)oc);
        this.parentsMap.remove((Object)oc);
    }

    private String getCorrectSuperClassName(ObjectClass oc, List<String> childSuperClassesNames) {
        List aliases;
        if (childSuperClassesNames != null && (aliases = oc.getNames()) != null) {
            for (String childSuperClassName : childSuperClassesNames) {
                if (!aliases.contains(childSuperClassName)) continue;
                return childSuperClassName;
            }
        }
        return null;
    }
}

