/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandler;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.view.dialogs.RenameProjectDialog;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProjectWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RenameProjectAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private TableViewer viewer;
    private ProjectsHandler projectsHandler;

    public RenameProjectAction(TableViewer viewer) {
        super(Messages.getString("RenameProjectAction.RenameProjectAction"));
        this.setToolTipText(this.getText());
        this.setId(PluginConstants.CMD_RENAME_PROJECT);
        this.setActionDefinitionId(PluginConstants.CMD_RENAME_PROJECT);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/rename.gif"));
        this.setEnabled(false);
        this.viewer = viewer;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                RenameProjectAction.this.setEnabled(selection.size() == 1);
            }
        });
        this.projectsHandler = Activator.getDefault().getProjectsHandler();
    }

    public void run() {
        Project project;
        RenameProjectDialog dialog;
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && selection.size() == 1 && (dialog = new RenameProjectDialog((project = ((ProjectWrapper)selection.getFirstElement()).getProject()).getName())).open() == 0) {
            this.projectsHandler.renameProject(project, dialog.getNewName());
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

