/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.view.dialogs.PreviousSearchesDialog;
import org.apache.directory.studio.schemaeditor.view.search.SearchPage;
import org.apache.directory.studio.schemaeditor.view.views.SearchView;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class MenuCreator
implements IMenuCreator {
    private Menu menu;
    private SearchView view;

    public MenuCreator(SearchView view) {
        this.view = view;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Control parent) {
        MenuItem item;
        String[] previousSearches;
        this.menu = new Menu(parent);
        String[] stringArray = previousSearches = SearchPage.loadSearchStringHistory();
        int n = previousSearches.length;
        int n2 = 0;
        while (n2 < n) {
            final String search = stringArray[n2];
            MenuItem item2 = new MenuItem(this.menu, 16);
            item2.setText(search);
            item2.setImage(Activator.getDefault().getImage("resources/icons/search_history_item.gif"));
            item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuCreator.this.view.setSearchInput(search, SearchPage.loadSearchIn().toArray(new SearchPage.SearchInEnum[0]), SearchPage.loadScope());
                }
            });
            if (search.equals(this.view.getSearchString())) {
                item2.setSelection(true);
            }
            ++n2;
        }
        if (previousSearches.length == 0) {
            item = new MenuItem(this.menu, 16);
            item.setText(Messages.getString("ShowSearchHistoryAction.None"));
            item.setEnabled(false);
            item.setSelection(true);
        }
        new MenuItem(this.menu, 2);
        item = new MenuItem(this.menu, 8);
        item.setText(Messages.getString("ShowSearchHistoryAction.History"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviousSearchesDialog dialog = new PreviousSearchesDialog(MenuCreator.this.view);
                dialog.open();
            }
        });
        item = new MenuItem(this.menu, 8);
        item.setText(Messages.getString("ShowSearchHistoryAction.ClearHistory"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPage.clearSearchHistory();
            }
        });
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }
}

