/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.sourceeditor;

import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;

public class ACIFormattingStrategy
implements IFormattingStrategy {
    public static final String INDENT_STRING = "    ";
    public static final String NEWLINE = BrowserCoreConstants.LINE_SEPARATOR;
    private ISourceViewer sourceViewer;

    public ACIFormattingStrategy(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        String oldContent = this.sourceViewer.getDocument().get();
        String newContent = this.internFormat(oldContent);
        this.sourceViewer.getDocument().set(newContent);
        return null;
    }

    public void formatterStarts(String initialIndentation) {
    }

    public void formatterStops() {
    }

    private String internFormat(String content) {
        StringBuilder sb = new StringBuilder();
        boolean newLineStarted = true;
        boolean inQuotedString = false;
        boolean oneLineMode = false;
        int indent = 0;
        int contentLength = content.length();
        int i = 0;
        while (i < contentLength) {
            int x;
            char c = content.charAt(i);
            if (c == '\"') {
                inQuotedString ^= true;
            }
            if (c == '{' && !inQuotedString) {
                oneLineMode = this.checkInOneLine(i, content);
                if (oneLineMode) {
                    sb.append(c);
                    newLineStarted = false;
                } else {
                    if (!newLineStarted) {
                        sb.append(NEWLINE);
                        x = 0;
                        while (x < indent) {
                            sb.append(INDENT_STRING);
                            ++x;
                        }
                    }
                    sb.append(c);
                    sb.append(NEWLINE);
                    newLineStarted = true;
                    ++indent;
                    x = 0;
                    while (x < indent) {
                        sb.append(INDENT_STRING);
                        ++x;
                    }
                }
            } else if (c == '}' && !inQuotedString) {
                if (oneLineMode) {
                    sb.append(c);
                    newLineStarted = false;
                    oneLineMode = false;
                } else {
                    --indent;
                    if (newLineStarted) {
                        sb.delete(sb.length() - INDENT_STRING.length(), sb.length());
                    } else {
                        sb.append(NEWLINE);
                        x = 0;
                        while (x < indent) {
                            sb.append(INDENT_STRING);
                            ++x;
                        }
                    }
                    sb.append(c);
                    sb.append(NEWLINE);
                    newLineStarted = true;
                    x = 0;
                    while (x < indent) {
                        sb.append(INDENT_STRING);
                        ++x;
                    }
                }
            } else if (c == ',' && !inQuotedString) {
                if (oneLineMode) {
                    sb.append(c);
                    newLineStarted = false;
                } else {
                    sb.append(c);
                    sb.append(NEWLINE);
                    newLineStarted = true;
                    x = 0;
                    while (x < indent) {
                        sb.append(INDENT_STRING);
                        ++x;
                    }
                }
            } else if (Character.isWhitespace(c)) {
                char c1 = 'A';
                if (i + 1 < contentLength) {
                    c1 = content.charAt(i + 1);
                }
                if (!newLineStarted && c != '\n' && c != '\r' && !Character.isWhitespace(c1) && c1 != '\n' && c1 != '\r') {
                    sb.append(c);
                }
            } else {
                sb.append(c);
                newLineStarted = false;
            }
            ++i;
        }
        return sb.toString();
    }

    private boolean checkInOneLine(int i, String content) {
        boolean inQuote = false;
        int commaCounter = 0;
        int contentLength = content.length();
        int k = i + 1;
        while (k < contentLength) {
            char c = content.charAt(k);
            if (c == '\"') {
                inQuote ^= true;
            }
            if (c == '{' && !inQuote) {
                return false;
            }
            if (c == '}' && !inQuote) {
                return true;
            }
            if (c == ',' && !inQuote && ++commaCounter > 1) {
                return false;
            }
            ++k;
        }
        return false;
    }
}

