/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.search.SubstringFilter;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreFinal
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFinal.class);

    public StoreFinal() {
        super("Store a final value");
    }

    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        SubstringFilter substringFilter = (SubstringFilter)container.getTerminalFilter();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_05140_EMPTY_SUBSTRING_FINAL_FILTER_PDU, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        String finalValue = Strings.utf8ToString((byte[])tlv.getValue().getData());
        substringFilter.setFinalSubstrings(finalValue);
        container.unstackFilters();
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05154_STORED_FINAL_SUBSTRING, (Object[])new Object[]{finalValue}));
        }
    }
}

