/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;

public abstract class AbstractAcceptor
implements Acceptor {
    protected final Map<String, ProtocolManager> protocolMap;

    public AbstractAcceptor(Map<String, ProtocolManager> protocolMap) {
        this.protocolMap = protocolMap;
    }

    @Override
    public void updateInterceptors(List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) {
        for (ProtocolManager manager : this.protocolMap.values()) {
            manager.updateInterceptors(incomingInterceptors, outgoingInterceptors);
        }
    }

    public Map<String, ProtocolManager> getProtocolMap() {
        return Collections.unmodifiableMap(this.protocolMap);
    }
}

