/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.eventing.backend.notification;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.ws.eventing.EventType;
import org.apache.cxf.ws.eventing.backend.database.SubscriptionTicket;
import org.apache.cxf.ws.eventing.backend.notification.FilteringInterceptor;
import org.apache.cxf.ws.eventing.backend.notification.WrappedSink;
import org.apache.cxf.ws.eventing.shared.handlers.ReferenceParametersAddingHandler;

class EventSinkInterfaceNotificationTask
implements Runnable {
    protected static final Logger LOG = LogUtils.getLogger(EventSinkInterfaceNotificationTask.class);
    SubscriptionTicket target;
    Object event;
    Class<?> endpointInterface;

    EventSinkInterfaceNotificationTask(SubscriptionTicket ticket, Object event, Class<?> endpointInterface) {
        this.target = ticket;
        this.event = event;
        this.endpointInterface = endpointInterface;
    }

    @Override
    public void run() {
        try {
            Object param;
            Object proxy;
            LOG.info("Starting notification task for subscription UUID " + String.valueOf(this.target.getUuid()));
            Method method = null;
            Class<?> eventClass = this.event.getClass();
            Object[] eventClassArray = new Class[]{eventClass};
            if (this.target.isWrappedDelivery()) {
                proxy = this.getProxy(WrappedSink.class, (Class<?>[])eventClassArray);
                param = new EventType();
                ((EventType)param).getContent().add(eventClass.isAnnotationPresent(XmlRootElement.class) ? this.event : this.convertToJAXBElement(this.event));
                method = WrappedSink.class.getMethod("notifyEvent", EventType.class);
            } else {
                proxy = this.getProxy(this.endpointInterface, new Class[0]);
                Method[] methods = this.endpointInterface.getMethods();
                for (int i = 0; i < methods.length && method == null; ++i) {
                    if (!Arrays.equals(methods[i].getParameterTypes(), eventClassArray)) continue;
                    method = methods[i];
                }
                if (method == null) {
                    LOG.severe("Couldn't find corresponding method for event of type " + eventClass.getCanonicalName() + " in event sink interface" + this.endpointInterface.getCanonicalName());
                    return;
                }
                param = this.event;
            }
            method.invoke(proxy, param);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected JAXBElement<?> convertToJAXBElement(Object evt) {
        Class<?> eventClass = evt.getClass();
        String tns = this.endpointInterface.getAnnotation(WebService.class).targetNamespace();
        return new JAXBElement(new QName(tns, eventClass.getName()), eventClass, evt);
    }

    protected Object getProxy(Class<?> sinkInterface, Class<?> ... extraClasses) {
        ReferenceParametersAddingHandler handler = new ReferenceParametersAddingHandler(this.target.getNotificationReferenceParams());
        JaxWsProxyFactoryBean service = new JaxWsProxyFactoryBean();
        service.getOutInterceptors().add(new LoggingOutInterceptor());
        service.setServiceClass(sinkInterface);
        service.setAddress(this.target.getTargetURL());
        service.getHandlers().add(handler);
        if (this.target.getFilter() != null && this.target.getFilter().getContent().size() > 0) {
            service.getOutInterceptors().add(new FilteringInterceptor(this.target.getFilter()));
        }
        if (extraClasses != null && extraClasses.length > 0) {
            HashMap<String, Class<?>[]> props = new HashMap<String, Class<?>[]>();
            props.put("jaxb.additionalContextClasses", extraClasses);
            service.getClientFactoryBean().getServiceFactory().setProperties(props);
        }
        return service.create();
    }
}

