/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.DatabaseObjectsFactory;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.ExtProperties;

public class DataSourceResourceLoader
extends ResourceLoader {
    private static final String DATABASE_OBJECTS_FACTORY_DEFAULT_CLASS = "org.apache.velocity.runtime.resource.loader.DefaultDatabaseObjectsFactory";
    private DataSource dataSource;
    private DatabaseObjectsFactory factory;
    private String templateColumn;
    private String timestampColumn;
    private String templateSQL;
    private String timestampSQL;

    @Override
    public void init(ExtProperties configuration) {
        String tableName = StringUtils.trim(configuration.getString("resource.table"));
        String keyColumn = StringUtils.trim(configuration.getString("resource.key_column"));
        this.templateColumn = StringUtils.trim(configuration.getString("resource.template_column"));
        this.timestampColumn = StringUtils.trim(configuration.getString("resource.timestamp_column"));
        this.templateSQL = "SELECT " + this.templateColumn + " FROM " + tableName + " WHERE " + keyColumn + " = ?";
        this.timestampSQL = "SELECT " + this.timestampColumn + " FROM " + tableName + " WHERE " + keyColumn + " = ?";
        String dataSourceName = StringUtils.trim(configuration.getString("resource.datasource_url"));
        if (this.dataSource != null) {
            this.log.debug("DataSourceResourceLoader: using dataSource instance with table \"{}\"", (Object)tableName);
            this.log.debug("DataSourceResourceLoader: using columns \"{}\", \"{}\" and \"{}\"", keyColumn, this.templateColumn, this.timestampColumn);
        } else if (dataSourceName != null) {
            this.log.debug("DataSourceResourceLoader: using \"{}\" datasource with table \"{}\"", (Object)dataSourceName, (Object)tableName);
            this.log.debug("DataSourceResourceLoader: using columns \"{}\", \"{}\" and \"{}\"", keyColumn, this.templateColumn, this.timestampColumn);
            try {
                this.dataSource = (DataSource)new InitialContext().lookup(dataSourceName);
            }
            catch (NamingException ne) {
                throw new VelocityException("could not lookup datasource for name: " + dataSourceName, ne);
            }
            this.log.trace("DataSourceResourceLoader initialized.");
        } else {
            String msg = "DataSourceResourceLoader not properly initialized. No DataSource was identified.";
            this.log.error(msg);
            throw new RuntimeException(msg);
        }
        String factoryClassName = configuration.getString("database_objects_factory.class");
        if (factoryClassName == null) {
            factoryClassName = DATABASE_OBJECTS_FACTORY_DEFAULT_CLASS;
        }
        try {
            Class<?> factoryClass = ClassUtils.getClass(factoryClassName);
            this.factory = (DatabaseObjectsFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.factory.init(this.dataSource, configuration.subset("database_objects_factory"));
        }
        catch (Exception e) {
            throw new VelocityException("could not find database objects factory class", e);
        }
        this.log.trace("DataSourceResourceLoader initialized.");
    }

    public void setDataSource(DataSource dataSource) {
        if (this.factory != null) {
            throw new VelocityException("cannot change data source after initialization");
        }
        this.dataSource = dataSource;
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        return resource.getLastModified() != this.readLastModified(resource, "checking timestamp");
    }

    @Override
    public long getLastModified(Resource resource) {
        return this.readLastModified(resource, "getting timestamp");
    }

    @Override
    public synchronized Reader getResourceReader(String name, String encoding) throws ResourceNotFoundException {
        if (StringUtils.isEmpty(name)) {
            throw new ResourceNotFoundException("DataSourceResourceLoader: Template name was empty or null");
        }
        ResultSet rs = null;
        try {
            PreparedStatement statement = this.factory.prepareStatement(this.templateSQL);
            rs = this.fetchResult(statement, name);
            if (rs.next()) {
                Reader reader = this.getReader(rs, this.templateColumn, encoding);
                if (reader == null) {
                    throw new ResourceNotFoundException("DataSourceResourceLoader: template column for '" + name + "' is null");
                }
                return new SelfCleaningReader(reader, rs);
            }
            throw new ResourceNotFoundException("DataSourceResourceLoader: could not find resource '" + name + "'");
        }
        catch (Exception e) {
            String msg = "DataSourceResourceLoader: database problem while getting resource '" + name + "': ";
            this.log.error(msg, e);
            throw new ResourceNotFoundException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long readLastModified(Resource resource, String operation) {
        long timeStamp = 0L;
        String name = resource.getName();
        if (name == null || name.length() == 0) {
            String msg = "DataSourceResourceLoader: Template name was empty or null";
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.factory.prepareStatement(this.timestampSQL);
            rs = this.fetchResult(statement, name);
            if (!rs.next()) {
                String msg = "DataSourceResourceLoader: could not find resource " + name + " while " + operation;
                this.log.error(msg);
                throw new ResourceNotFoundException(msg);
            }
            Timestamp ts = rs.getTimestamp(this.timestampColumn);
            timeStamp = ts != null ? ts.getTime() : 0L;
            this.closeResultSet(rs);
            if (statement == null) return timeStamp;
        }
        catch (Exception e) {
            try {
                String msg = "DataSourceResourceLoader: database problem while " + operation + " of '" + name + "': ";
                this.log.error(msg, e);
                throw new VelocityException(msg, e, this.rsvc.getLogContext().getStackTrace());
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                if (statement == null) throw throwable;
                try {
                    this.factory.releaseStatement(this.timestampSQL, statement);
                    throw throwable;
                }
                catch (SQLException sqle) {
                    this.log.debug("DataSourceResourceLoader: error releasing prepared statement", sqle);
                }
                throw throwable;
            }
        }
        try {
            this.factory.releaseStatement(this.timestampSQL, statement);
            return timeStamp;
        }
        catch (SQLException sqle) {
            this.log.debug("DataSourceResourceLoader: error releasing prepared statement", sqle);
            return timeStamp;
        }
    }

    private void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected ResultSet fetchResult(PreparedStatement ps, String templateName) throws SQLException {
        ps.setString(1, templateName);
        return ps.executeQuery();
    }

    protected Reader getReader(ResultSet resultSet, String column, String encoding) throws SQLException {
        return this.getReader(resultSet, column);
    }

    protected Reader getReader(ResultSet resultSet, String column) throws SQLException {
        return resultSet.getCharacterStream(column);
    }

    public void clear() {
        if (this.factory != null) {
            this.factory.clear();
        }
    }

    private class SelfCleaningReader
    extends FilterReader {
        private final ResultSet resultSet;

        public SelfCleaningReader(Reader reader, ResultSet resultSet) {
            super(reader);
            this.resultSet = resultSet;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                this.resultSet.close();
                DataSourceResourceLoader.this.factory.releaseStatement(DataSourceResourceLoader.this.templateSQL, (PreparedStatement)this.resultSet.getStatement());
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

