/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import org.apache.commons.validator.routines.checkdigit.AbstractCheckDigitTest;
import org.apache.commons.validator.routines.checkdigit.ECNumberCheckDigit;
import org.junit.jupiter.api.BeforeEach;

class ECNumberCheckDigitTest
extends AbstractCheckDigitTest {
    private static final String MIN = "000-001-6";
    private static final String FORMALDEHYDE = "200-001-8";
    private static final String DEXAMETHASONE = "200-003-9";
    private static final String ARSENIC = "231-148-6";
    private static final String ASBESTOS = "603-721-4";
    private static final String MAX = "999-999-2";

    ECNumberCheckDigitTest() {
    }

    @Override
    protected String removeCheckDigit(String code) {
        String cde = (String)ECNumberCheckDigit.REGEX_VALIDATOR.validate(code);
        if (cde == null || cde.length() <= this.checkDigitLth) {
            return null;
        }
        return cde.substring(0, cde.length() - this.checkDigitLth);
    }

    @BeforeEach
    protected void setUp() {
        this.routine = ECNumberCheckDigit.getInstance();
        this.valid = new String[]{MIN, FORMALDEHYDE, DEXAMETHASONE, ARSENIC, ASBESTOS, MAX};
    }
}

