/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.text.TextStringBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TextStringBuilderAppendInsertTest {
    private static final String SEP = System.lineSeparator();
    private static final Object FOO = new Object(){

        public String toString() {
            return "foo";
        }
    };

    @Test
    public void testAppendNewLine() {
        TextStringBuilder sb = new TextStringBuilder("---");
        sb.appendNewLine().append("+++");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("---" + SEP + "+++"));
        sb = new TextStringBuilder("---");
        sb.setNewLineText("#").appendNewLine().setNewLineText(null).appendNewLine();
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("---#" + SEP));
    }

    @Test
    public void testAppendWithNullText() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.appendNull();
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULL");
        sb.append(null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULLNULL");
        sb.append(FOO);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULLNULLfoo");
        sb.append((String)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULLNULLfooNULL");
        sb.append("");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULLNULLfooNULL");
        sb.append("bar");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULLNULLfooNULLbar");
        sb.append((StringBuffer)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULLNULLfooNULLbarNULL");
        sb.append(new StringBuffer("baz"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULLNULLfooNULLbarNULLbaz");
    }

    @Test
    public void testAppend_Object() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendNull();
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.append(null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.append(FOO);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append((StringBuffer)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append(new StringBuffer("baz"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobaz");
        sb.append(new TextStringBuilder("yes"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobazyes");
        sb.append((CharSequence)"Seq");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobazyesSeq");
        sb.append(new StringBuilder("bld"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobazyesSeqbld");
    }

    @Test
    public void testAppend_StringBuilder() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((String)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULL");
        sb = new TextStringBuilder();
        sb.append(new StringBuilder("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append(new StringBuilder(""));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append(new StringBuilder("bar"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobar");
    }

    @Test
    public void testAppend_String() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((String)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULL");
        sb = new TextStringBuilder();
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append("");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append("bar");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobar");
    }

    @Test
    public void testAppend_String_int_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((String)null, 0, 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULL");
        sb = new TextStringBuilder();
        sb.append("foo", 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        try {
            sb.append("bar", -1, 1);
            Assertions.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 3, 1);
            Assertions.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 1, -1);
            Assertions.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 1, 3);
            Assertions.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", -1, 3);
            Assertions.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 4, 0);
            Assertions.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append("bar", 3, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append("abcbardef", 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobar");
        sb.append((CharSequence)"abcbardef", 4, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarard");
    }

    @Test
    public void testAppend_StringBuilder_int_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((String)null, 0, 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULL");
        sb = new TextStringBuilder();
        sb.append(new StringBuilder("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        try {
            sb.append(new StringBuilder("bar"), -1, 1);
            Assertions.fail((String)"append(StringBuilder, -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 3, 1);
            Assertions.fail((String)"append(StringBuilder, 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 1, -1);
            Assertions.fail((String)"append(StringBuilder,, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 1, 3);
            Assertions.fail((String)"append(StringBuilder, 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), -1, 3);
            Assertions.fail((String)"append(StringBuilder, -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 4, 0);
            Assertions.fail((String)"append(StringBuilder, 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new StringBuilder("bar"), 3, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append(new StringBuilder("abcbardef"), 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobar");
        sb.append(new StringBuilder("abcbardef"), 4, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarard");
    }

    @Test
    public void testAppend_StringBuffer() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((StringBuffer)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULL");
        sb = new TextStringBuilder();
        sb.append(new StringBuffer("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append(new StringBuffer(""));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append(new StringBuffer("bar"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobar");
    }

    @Test
    public void testAppend_StringBuffer_int_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((StringBuffer)null, 0, 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULL");
        sb = new TextStringBuilder();
        sb.append(new StringBuffer("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        try {
            sb.append(new StringBuffer("bar"), -1, 1);
            Assertions.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 3, 1);
            Assertions.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 1, -1);
            Assertions.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 1, 3);
            Assertions.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), -1, 3);
            Assertions.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 4, 0);
            Assertions.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new StringBuffer("bar"), 3, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append(new StringBuffer("abcbardef"), 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobar");
    }

    @Test
    public void testAppend_TextStringBuilder() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((TextStringBuilder)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULL");
        sb = new TextStringBuilder();
        sb.append(new TextStringBuilder("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append(new TextStringBuilder(""));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append(new TextStringBuilder("bar"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobar");
    }

    @Test
    public void testAppend_TextStringBuilder_int_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((TextStringBuilder)null, 0, 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULL");
        sb = new TextStringBuilder();
        sb.append(new TextStringBuilder("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        try {
            sb.append(new TextStringBuilder("bar"), -1, 1);
            Assertions.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new TextStringBuilder("bar"), 3, 1);
            Assertions.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new TextStringBuilder("bar"), 1, -1);
            Assertions.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new TextStringBuilder("bar"), 1, 3);
            Assertions.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new TextStringBuilder("bar"), -1, 3);
            Assertions.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new TextStringBuilder("bar"), 4, 0);
            Assertions.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new TextStringBuilder("bar"), 3, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append(new TextStringBuilder("abcbardef"), 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobar");
    }

    @Test
    public void testAppend_CharArray() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((char[])null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULL");
        sb = new TextStringBuilder();
        sb.append(new char[0]);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.append(new char[]{'f', 'o', 'o'});
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
    }

    @Test
    public void testAppend_CharArray_int_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((char[])null, 0, 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"NULL");
        sb = new TextStringBuilder();
        sb.append(new char[]{'f', 'o', 'o'}, 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        try {
            sb.append(new char[]{'b', 'a', 'r'}, -1, 1);
            Assertions.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 3, 1);
            Assertions.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 1, -1);
            Assertions.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 1, 3);
            Assertions.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, -1, 3);
            Assertions.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 4, 0);
            Assertions.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new char[]{'b', 'a', 'r'}, 3, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.append(new char[]{'a', 'b', 'c', 'b', 'a', 'r', 'd', 'e', 'f'}, 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobar");
    }

    @Test
    public void testAppend_Boolean() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append(true);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"true");
        sb.append(false);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"truefalse");
        sb.append('!');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"truefalse!");
    }

    @Test
    public void testAppend_PrimitiveNumber() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append(0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"0");
        sb.append(1L);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"01");
        sb.append(2.3f);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"012.3");
        sb.append(4.5);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"012.34.5");
    }

    @Test
    public void testAppendln_FormattedString() {
        final int[] count = new int[2];
        TextStringBuilder sb = new TextStringBuilder(){
            private static final long serialVersionUID = 1L;

            public TextStringBuilder append(String str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public TextStringBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("Hello %s", new Object[]{"Alice"});
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("Hello Alice" + SEP));
        Assertions.assertThat((int)count[0]).isEqualTo(2);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_Object() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendln(null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("" + SEP));
        sb.appendln(FOO);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)(SEP + "foo" + SEP));
        sb.appendln((Object)6);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)(SEP + "foo" + SEP + "6" + SEP));
    }

    @Test
    public void testAppendln_String() {
        final int[] count = new int[2];
        TextStringBuilder sb = new TextStringBuilder(){
            private static final long serialVersionUID = 1L;

            public TextStringBuilder append(String str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public TextStringBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("foo" + SEP));
        Assertions.assertThat((int)count[0]).isEqualTo(2);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_String_int_int() {
        final int[] count = new int[2];
        TextStringBuilder sb = new TextStringBuilder(){
            private static final long serialVersionUID = 1L;

            public TextStringBuilder append(String str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public TextStringBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo", 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("foo" + SEP));
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_StringBuffer() {
        final int[] count = new int[2];
        TextStringBuilder sb = new TextStringBuilder(){
            private static final long serialVersionUID = 1L;

            public TextStringBuilder append(StringBuffer str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public TextStringBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuffer("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("foo" + SEP));
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_StringBuilder() {
        final int[] count = new int[2];
        TextStringBuilder sb = new TextStringBuilder(){
            private static final long serialVersionUID = 1L;

            public TextStringBuilder append(StringBuilder str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public TextStringBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuilder("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("foo" + SEP));
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_StringBuffer_int_int() {
        final int[] count = new int[2];
        TextStringBuilder sb = new TextStringBuilder(){
            private static final long serialVersionUID = 1L;

            public TextStringBuilder append(StringBuffer str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public TextStringBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuffer("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("foo" + SEP));
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_StringBuilder_int_int() {
        final int[] count = new int[2];
        TextStringBuilder sb = new TextStringBuilder(){
            private static final long serialVersionUID = 1L;

            public TextStringBuilder append(StringBuilder str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public TextStringBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuilder("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("foo" + SEP));
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_TextStringBuilder() {
        final int[] count = new int[2];
        TextStringBuilder sb = new TextStringBuilder(){
            private static final long serialVersionUID = 1L;

            public TextStringBuilder append(TextStringBuilder str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public TextStringBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new TextStringBuilder("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("foo" + SEP));
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_TextStringBuilder_int_int() {
        final int[] count = new int[2];
        TextStringBuilder sb = new TextStringBuilder(){
            private static final long serialVersionUID = 1L;

            public TextStringBuilder append(TextStringBuilder str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public TextStringBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new TextStringBuilder("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("foo" + SEP));
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_CharArray() {
        final int[] count = new int[2];
        TextStringBuilder sb = new TextStringBuilder(){
            private static final long serialVersionUID = 1L;

            public TextStringBuilder append(char[] str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public TextStringBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo".toCharArray());
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("foo" + SEP));
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_CharArray_int_int() {
        final int[] count = new int[2];
        TextStringBuilder sb = new TextStringBuilder(){
            private static final long serialVersionUID = 1L;

            public TextStringBuilder append(char[] str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public TextStringBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo".toCharArray(), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("foo" + SEP));
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_Boolean() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendln(true);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("true" + SEP));
        sb.clear();
        sb.appendln(false);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("false" + SEP));
    }

    @Test
    public void testAppendln_PrimitiveNumber() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendln(0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("0" + SEP));
        sb.clear();
        sb.appendln(1L);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("1" + SEP));
        sb.clear();
        sb.appendln(2.3f);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("2.3" + SEP));
        sb.clear();
        sb.appendln(4.5);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)("4.5" + SEP));
    }

    @Test
    public void testAppendPadding() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.appendPadding(-1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.appendPadding(0, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.appendPadding(1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo-");
        sb.appendPadding(16, '-');
        Assertions.assertThat((int)sb.length()).isEqualTo(20);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo-----------------");
    }

    @Test
    public void testAppendFixedWidthPadLeft() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendFixedWidthPadLeft((Object)"foo", -1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 0, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"o");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 2, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"oo");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 3, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 4, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"-foo");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 10, '-');
        Assertions.assertThat((int)sb.length()).isEqualTo(10);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"-------foo");
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadLeft(null, 5, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"-null");
    }

    @Test
    public void testAppendFixedWidthPadLeft_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendFixedWidthPadLeft(123, -1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 0, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"3");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 2, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"23");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 3, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"123");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 4, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"-123");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 10, '-');
        Assertions.assertThat((int)sb.length()).isEqualTo(10);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"-------123");
    }

    @Test
    public void testAppendFixedWidthPadRight() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendFixedWidthPadRight((Object)"foo", -1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 0, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"f");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 2, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"fo");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 3, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 4, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo-");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 10, '-');
        Assertions.assertThat((int)sb.length()).isEqualTo(10);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo-------");
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadRight(null, 5, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"null-");
    }

    @Test
    public void testLang299() {
        TextStringBuilder sb = new TextStringBuilder(1);
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"f");
    }

    @Test
    public void testAppendFixedWidthPadRight_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendFixedWidthPadRight(123, -1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 0, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"1");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 2, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"12");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 3, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"123");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 4, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"123-");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 10, '-');
        Assertions.assertThat((int)sb.length()).isEqualTo(10);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"123-------");
    }

    @Test
    public void testAppend_FormattedString() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append("Hi", (Object[])null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"Hi");
        sb = new TextStringBuilder();
        sb.append("Hi", new Object[]{"Alice"});
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"Hi");
        sb = new TextStringBuilder();
        sb.append("Hi %s", new Object[]{"Alice"});
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"Hi Alice");
        sb = new TextStringBuilder();
        sb.append("Hi %s %,d", new Object[]{"Alice", 5000});
        char groupingSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
        String expected = "Hi Alice 5" + groupingSeparator + "000";
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)expected);
    }

    @Test
    public void testAppendAll_Array() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendAll((Object[])null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendAll(new Object[0]);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendAll(new Object[]{"foo", "bar", "baz"});
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarbaz");
        sb.clear();
        sb.appendAll((Object[])new String[]{"foo", "bar", "baz"});
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarbaz");
    }

    @Test
    public void testAppendAll_Collection() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendAll((Iterable)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendAll((Iterable)Collections.EMPTY_LIST);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz"));
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarbaz");
    }

    @Test
    public void testAppendAll_Iterator() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendAll((Iterator)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendAll(Collections.EMPTY_LIST.iterator());
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz").iterator());
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarbaz");
    }

    @Test
    public void testAppendWithSeparators_Array() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendWithSeparators((Object[])null, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendWithSeparators(new Object[0], ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,bar,baz");
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarbaz");
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,,baz");
    }

    @Test
    public void testAppendWithSeparators_Collection() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendWithSeparators((Iterable)null, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendWithSeparators((Iterable)Collections.EMPTY_LIST, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,bar,baz");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarbaz");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,,baz");
    }

    @Test
    public void testAppendWithSeparators_Iterator() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendWithSeparators((Iterator)null, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendWithSeparators(Collections.EMPTY_LIST.iterator(), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,bar,baz");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarbaz");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz").iterator(), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,,baz");
    }

    @Test
    public void testAppendWithSeparatorsWithNullText() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("null");
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,null,baz");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,null,baz");
    }

    @Test
    public void testAppendSeparator_String() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendSeparator(",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.appendSeparator(",");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,");
    }

    @Test
    public void testAppendSeparator_String_String() {
        TextStringBuilder sb = new TextStringBuilder();
        String startSeparator = "order by ";
        String standardSeparator = ",";
        String foo = "foo";
        sb.appendSeparator(null, null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.appendSeparator(",", null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.appendSeparator(",", "order by ");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"order by ");
        sb.appendSeparator(null, null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"order by ");
        sb.appendSeparator(null, "order by ");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"order by ");
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"order by foo");
        sb.appendSeparator(",", "order by ");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"order by foo,");
    }

    @Test
    public void testAppendSeparator_char() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendSeparator(',');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.appendSeparator(',');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,");
    }

    @Test
    public void testAppendSeparator_char_char() {
        TextStringBuilder sb = new TextStringBuilder();
        int startSeparator = 58;
        int standardSeparator = 44;
        String foo = "foo";
        sb.appendSeparator(',', ':');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)String.valueOf(':'));
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)(String.valueOf(':') + "foo"));
        sb.appendSeparator(',', ':');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)(String.valueOf(':') + "foo" + ','));
    }

    @Test
    public void testAppendSeparator_String_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendSeparator(",", 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.appendSeparator(",", 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,");
        sb.appendSeparator(",", -1);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,");
    }

    @Test
    public void testAppendSeparator_char_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendSeparator(',', 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"");
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo");
        sb.appendSeparator(',', 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,");
        sb.appendSeparator(',', -1);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foo,");
    }

    @Test
    public void testInsert() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, FOO);
            Assertions.fail((String)"insert(-1, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, FOO);
            Assertions.fail((String)"insert(7, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        sb.insert(0, FOO);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, "foo");
            Assertions.fail((String)"insert(-1, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, "foo");
            Assertions.fail((String)"insert(7, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, (String)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        sb.insert(0, "foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, new char[]{'f', 'o', 'o'});
            Assertions.fail((String)"insert(-1, char[]) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, new char[]{'f', 'o', 'o'});
            Assertions.fail((String)"insert(7, char[]) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, (char[])null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        sb.insert(0, new char[0]);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        sb.insert(0, new char[]{'f', 'o', 'o'});
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
            Assertions.fail((String)"insert(-1, char[], 3, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
            Assertions.fail((String)"insert(7, char[], 3, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, (char[])null, 0, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        sb.insert(0, new char[0], 0, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, -1, 3);
            Assertions.fail((String)"insert(0, char[], -1, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 10, 3);
            Assertions.fail((String)"insert(0, char[], 10, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, -1);
            Assertions.fail((String)"insert(0, char[], 0, -1) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 10);
            Assertions.fail((String)"insert(0, char[], 0, 10) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foobarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, true);
            Assertions.fail((String)"insert(-1, boolean) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, true);
            Assertions.fail((String)"insert(7, boolean) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, true);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"truebarbaz");
        sb.insert(0, false);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"falsetruebarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, '!');
            Assertions.fail((String)"insert(-1, char) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, '!');
            Assertions.fail((String)"insert(7, char) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, '!');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"!barbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, 0);
            Assertions.fail((String)"insert(-1, int) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, 0);
            Assertions.fail((String)"insert(7, int) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, '0');
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"0barbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, 1L);
            Assertions.fail((String)"insert(-1, long) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, 1L);
            Assertions.fail((String)"insert(7, long) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, 1L);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"1barbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, 2.3f);
            Assertions.fail((String)"insert(-1, float) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, 2.3f);
            Assertions.fail((String)"insert(7, float) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, 2.3f);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"2.3barbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, 4.5);
            Assertions.fail((String)"insert(-1, double) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, 4.5);
            Assertions.fail((String)"insert(7, double) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, 4.5);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"4.5barbaz");
    }

    @Test
    public void testInsertWithNullText() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("null");
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, FOO);
            Assertions.fail((String)"insert(-1, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, FOO);
            Assertions.fail((String)"insert(7, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"nullbarbaz");
        sb.insert(0, FOO);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foonullbarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"barbaz");
        try {
            sb.insert(-1, "foo");
            Assertions.fail((String)"insert(-1, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.insert(7, "foo");
            Assertions.fail((String)"insert(7, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, (String)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"nullbarbaz");
        sb.insert(0, "foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"foonullbarbaz");
        sb.insert(0, (char[])null);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"nullfoonullbarbaz");
        sb.insert(0, (char[])null, 0, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo((Object)"nullnullfoonullbarbaz");
    }
}

