'use strict';

var fs25 = require('fs');
var path5 = require('path');
var Url = require('url');
var process8 = require('process');
var assert40 = require('assert');
var util2 = require('util');
var os8 = require('os');
var tty = require('tty');
var childProcess = require('child_process');
var crypto = require('crypto');
var esbuild = require('esbuild');
var fs12 = require('fs/promises');
var miniflare = require('miniflare');
var async_hooks = require('async_hooks');
var console$1 = require('console');
var S = require('readline');
var Stream = require('stream');
var http = require('http');
var https = require('https');
var zlib = require('zlib');
var web = require('stream/web');
var events = require('events');
var module2 = require('module');
var buffer = require('buffer');
var promises = require('timers/promises');
var domain = require('domain');
var consumers = require('stream/consumers');
var string_decoder = require('string_decoder');
var blake3Wasm = require('blake3-wasm');
var workerd = require('workerd');
var net = require('net');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var fs25__namespace = /*#__PURE__*/_interopNamespace(fs25);
var path5__namespace = /*#__PURE__*/_interopNamespace(path5);
var Url__default = /*#__PURE__*/_interopDefault(Url);
var process8__default = /*#__PURE__*/_interopDefault(process8);
var assert40__default = /*#__PURE__*/_interopDefault(assert40);
var util2__namespace = /*#__PURE__*/_interopNamespace(util2);
var os8__namespace = /*#__PURE__*/_interopNamespace(os8);
var tty__default = /*#__PURE__*/_interopDefault(tty);
var childProcess__default = /*#__PURE__*/_interopDefault(childProcess);
var crypto__default = /*#__PURE__*/_interopDefault(crypto);
var esbuild__namespace = /*#__PURE__*/_interopNamespace(esbuild);
var fs12__default = /*#__PURE__*/_interopDefault(fs12);
var async_hooks__namespace = /*#__PURE__*/_interopNamespace(async_hooks);
var S__default = /*#__PURE__*/_interopDefault(S);
var Stream__namespace = /*#__PURE__*/_interopNamespace(Stream);
var http__namespace = /*#__PURE__*/_interopNamespace(http);
var https__namespace = /*#__PURE__*/_interopNamespace(https);
var zlib__namespace = /*#__PURE__*/_interopNamespace(zlib);
var events__default = /*#__PURE__*/_interopDefault(events);
var module2__default = /*#__PURE__*/_interopDefault(module2);
var domain__namespace = /*#__PURE__*/_interopNamespace(domain);
var net__default = /*#__PURE__*/_interopDefault(net);

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __require = /* @__PURE__ */ ((x7) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x7, {
  get: (a6, b7) => (typeof require !== "undefined" ? require : a6)[b7]
}) : x7)(function(x7) {
  if (typeof require !== "undefined") return require.apply(this, arguments);
  throw Error('Dynamic require of "' + x7 + '" is not supported');
});
var __esm = (fn2, res) => function __init() {
  return fn2 && (res = (0, fn2[__getOwnPropNames(fn2)[0]])(fn2 = 0)), res;
};
var __commonJS = (cb2, mod) => function __require2() {
  return mod || (0, cb2[__getOwnPropNames(cb2)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all2) => {
  for (var name2 in all2)
    __defProp(target, name2, { get: all2[name2], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget);
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// import_meta_url.js
var import_meta_url;
var init_import_meta_url = __esm({
  "import_meta_url.js"() {
    import_meta_url = __require("url").pathToFileURL(__filename);
  }
});

// ../../node_modules/.pnpm/cloudflare@5.2.0_encoding@0.1.13/node_modules/cloudflare/_shims/registry.mjs
function setShims(shims, options = { auto: false }) {
  if (auto) {
    throw new Error(`you must \`import 'cloudflare/shims/${shims.kind}'\` before importing anything else from cloudflare`);
  }
  if (kind) {
    throw new Error(`can't \`import 'cloudflare/shims/${shims.kind}'\` after \`import 'cloudflare/shims/${kind}'\``);
  }
  auto = options.auto;
  kind = shims.kind;
  fetch2 = shims.fetch;
  shims.Request;
  shims.Response;
  shims.Headers;
  FormData2 = shims.FormData;
  shims.Blob;
  File2 = shims.File;
  shims.ReadableStream;
  getMultipartRequestOptions = shims.getMultipartRequestOptions;
  getDefaultAgent = shims.getDefaultAgent;
  fileFromPath = shims.fileFromPath;
  isFsReadStream = shims.isFsReadStream;
}
var auto, kind, fetch2, FormData2, File2, getMultipartRequestOptions, getDefaultAgent, fileFromPath, isFsReadStream;
var init_registry = __esm({
  "../../node_modules/.pnpm/cloudflare@5.2.0_encoding@0.1.13/node_modules/cloudflare/_shims/registry.mjs"() {
    init_import_meta_url();
    auto = false;
    kind = void 0;
    fetch2 = void 0;
    FormData2 = void 0;
    File2 = void 0;
    getMultipartRequestOptions = void 0;
    getDefaultAgent = void 0;
    fileFromPath = void 0;
    isFsReadStream = void 0;
    __name(setShims, "setShims");
  }
});

// ../../node_modules/.pnpm/cloudflare@5.2.0_encoding@0.1.13/node_modules/cloudflare/_shims/MultipartBody.mjs
var MultipartBody;
var init_MultipartBody = __esm({
  "../../node_modules/.pnpm/cloudflare@5.2.0_encoding@0.1.13/node_modules/cloudflare/_shims/MultipartBody.mjs"() {
    init_import_meta_url();
    MultipartBody = class {
      static {
        __name(this, "MultipartBody");
      }
      constructor(body) {
        this.body = body;
      }
      get [Symbol.toStringTag]() {
        return "MultipartBody";
      }
    };
  }
});

// ../workers-utils/dist/chunk-4DJ4YNBY.mjs
function formatCompatibilityDate(date) {
  return date.toISOString().slice(0, 10);
}
function assertNever(_value) {
}
function mapWorkerMetadataBindings(bindings) {
  return bindings.filter((binding) => binding.type !== "secret_text").reduce((configObj, binding) => {
    switch (binding.type) {
      case "plain_text":
        {
          configObj.vars = {
            ...configObj.vars ?? {},
            [binding.name]: binding.text
          };
        }
        break;
      case "json":
        {
          configObj.vars = {
            ...configObj.vars ?? {},
            name: binding.name,
            json: binding.json
          };
        }
        break;
      case "kv_namespace":
        {
          configObj.kv_namespaces = [
            ...configObj.kv_namespaces ?? [],
            { id: binding.namespace_id, binding: binding.name }
          ];
        }
        break;
      case "durable_object_namespace":
        {
          configObj.durable_objects = {
            bindings: [
              ...configObj.durable_objects?.bindings ?? [],
              {
                name: binding.name,
                class_name: binding.class_name,
                script_name: binding.script_name,
                environment: binding.environment
              }
            ]
          };
        }
        break;
      case "d1":
        {
          configObj.d1_databases = [
            ...configObj.d1_databases ?? [],
            {
              binding: binding.name,
              database_id: binding.id
            }
          ];
        }
        break;
      case "browser":
        {
          configObj.browser = {
            binding: binding.name
          };
        }
        break;
      case "ai":
        {
          configObj.ai = {
            binding: binding.name
          };
        }
        break;
      case "images":
        {
          configObj.images = {
            binding: binding.name
          };
        }
        break;
      case "media":
        {
          configObj.media = {
            binding: binding.name
          };
        }
        break;
      case "r2_bucket":
        {
          configObj.r2_buckets = [
            ...configObj.r2_buckets ?? [],
            {
              binding: binding.name,
              bucket_name: binding.bucket_name,
              jurisdiction: binding.jurisdiction
            }
          ];
        }
        break;
      case "secrets_store_secret":
        {
          configObj.secrets_store_secrets = [
            ...configObj.secrets_store_secrets ?? [],
            {
              binding: binding.name,
              store_id: binding.store_id,
              secret_name: binding.secret_name
            }
          ];
        }
        break;
      case "unsafe_hello_world": {
        configObj.unsafe_hello_world = [
          ...configObj.unsafe_hello_world ?? [],
          {
            binding: binding.name,
            enable_timer: binding.enable_timer
          }
        ];
        break;
      }
      case "service":
        {
          configObj.services = [
            ...configObj.services ?? [],
            {
              binding: binding.name,
              service: binding.service,
              environment: binding.environment,
              entrypoint: binding.entrypoint
            }
          ];
        }
        break;
      case "analytics_engine":
        {
          configObj.analytics_engine_datasets = [
            ...configObj.analytics_engine_datasets ?? [],
            { binding: binding.name, dataset: binding.dataset }
          ];
        }
        break;
      case "dispatch_namespace":
        {
          configObj.dispatch_namespaces = [
            ...configObj.dispatch_namespaces ?? [],
            {
              binding: binding.name,
              namespace: binding.namespace,
              ...binding.outbound && {
                outbound: {
                  service: binding.outbound.worker.service,
                  environment: binding.outbound.worker.environment,
                  parameters: binding.outbound.params?.map((p7) => p7.name) ?? []
                }
              }
            }
          ];
        }
        break;
      case "logfwdr":
        {
          configObj.logfwdr = {
            bindings: [
              ...configObj.logfwdr?.bindings ?? [],
              { name: binding.name, destination: binding.destination }
            ]
          };
        }
        break;
      case "wasm_module":
        {
          configObj.wasm_modules = {
            ...configObj.wasm_modules ?? {},
            [binding.name]: binding.part
          };
        }
        break;
      case "text_blob":
        {
          configObj.text_blobs = {
            ...configObj.text_blobs ?? {},
            [binding.name]: binding.part
          };
        }
        break;
      case "data_blob":
        {
          configObj.data_blobs = {
            ...configObj.data_blobs ?? {},
            [binding.name]: binding.part
          };
        }
        break;
      case "secret_text":
        break;
      case "version_metadata": {
        {
          configObj.version_metadata = {
            binding: binding.name
          };
        }
        break;
      }
      case "send_email": {
        configObj.send_email = [
          ...configObj.send_email ?? [],
          {
            name: binding.name,
            destination_address: binding.destination_address,
            allowed_destination_addresses: binding.allowed_destination_addresses,
            allowed_sender_addresses: binding.allowed_sender_addresses
          }
        ];
        break;
      }
      case "queue":
        configObj.queues ??= { producers: [] };
        configObj.queues.producers = [
          ...configObj.queues.producers ?? [],
          {
            binding: binding.name,
            queue: binding.queue_name,
            delivery_delay: binding.delivery_delay
          }
        ];
        break;
      case "vectorize":
        configObj.vectorize = [
          ...configObj.vectorize ?? [],
          {
            binding: binding.name,
            index_name: binding.index_name
          }
        ];
        break;
      case "hyperdrive":
        configObj.hyperdrive = [
          ...configObj.hyperdrive ?? [],
          {
            binding: binding.name,
            id: binding.id
          }
        ];
        break;
      case "mtls_certificate":
        configObj.mtls_certificates = [
          ...configObj.mtls_certificates ?? [],
          {
            binding: binding.name,
            certificate_id: binding.certificate_id
          }
        ];
        break;
      case "pipelines":
        configObj.pipelines = [
          ...configObj.pipelines ?? [],
          {
            binding: binding.name,
            pipeline: binding.pipeline
          }
        ];
        break;
      case "assets":
        configObj.assets = {
          binding: binding.name
          // Note: we currently don't get all the assets information from the
          //      API, so here we are only able to set the name of the binding
          //      hopefully in the future we can properly fully support the binding
        };
        break;
      case "inherit":
        configObj.unsafe = {
          bindings: [...configObj.unsafe?.bindings ?? [], binding],
          metadata: configObj.unsafe?.metadata ?? void 0
        };
        break;
      case "workflow":
        {
          configObj.workflows = [
            ...configObj.workflows ?? [],
            {
              binding: binding.name,
              name: binding.workflow_name,
              class_name: binding.class_name,
              script_name: binding.script_name
            }
          ];
        }
        break;
      case "worker_loader":
        {
          configObj.worker_loaders = [
            ...configObj.worker_loaders ?? [],
            {
              binding: binding.name
            }
          ];
        }
        break;
      case "ratelimit":
        {
          configObj.ratelimits = [
            ...configObj.ratelimits ?? [],
            {
              name: binding.name,
              namespace_id: binding.namespace_id,
              simple: {
                limit: binding.simple.limit,
                period: binding.simple.period
              }
            }
          ];
        }
        break;
      case "vpc_service":
        {
          configObj.vpc_services = [
            ...configObj.vpc_services ?? [],
            {
              binding: binding.name,
              service_id: binding.service_id
            }
          ];
        }
        break;
      default: {
        configObj.unsafe = {
          bindings: [...configObj.unsafe?.bindings ?? [], binding],
          metadata: configObj.unsafe?.metadata ?? void 0
        };
      }
    }
    return configObj;
  }, {});
}
function convertWorkerToWranglerConfig(config) {
  const mappedBindings = mapWorkerMetadataBindings(config.bindings);
  const durableObjectClassNames = config.bindings.filter(
    (binding) => binding.type === "durable_object_namespace" && binding.script_name === config.name
  ).map(
    (durableObject) => durableObject.class_name
  );
  const allRoutes = [
    ...config.routes.map((r8) => ({
      pattern: r8.pattern,
      zone_name: r8.zone_name
    })),
    ...config.domains.map((c7) => ({
      pattern: c7.hostname,
      zone_name: c7.zone_name,
      custom_domain: true
    }))
  ];
  return {
    name: config.name,
    main: config.entrypoint,
    workers_dev: config.subdomain.enabled,
    preview_urls: config.subdomain.previews_enabled,
    compatibility_date: config.compatibility_date ?? formatCompatibilityDate(/* @__PURE__ */ new Date()),
    compatibility_flags: config.compatibility_flags,
    ...allRoutes.length ? { routes: allRoutes } : {},
    placement: config.placement?.mode === "smart" ? { mode: "smart" } : void 0,
    limits: config.limits,
    ...durableObjectClassNames.length && config.migration_tag ? {
      migrations: [
        {
          tag: config.migration_tag,
          new_classes: durableObjectClassNames
        }
      ]
    } : {},
    ...config.schedules.length ? {
      triggers: {
        crons: config.schedules.map((scheduled) => scheduled.cron)
      }
    } : {},
    tail_consumers: config.tail_consumers ?? void 0,
    observability: config.observability,
    ...mappedBindings
  };
}
function constructWranglerConfig(workerOrWorkers) {
  let workers;
  if (Array.isArray(workerOrWorkers)) {
    workers = workerOrWorkers;
  } else {
    workers = [workerOrWorkers];
  }
  const topLevelEnv = workers.find(
    (w7) => !w7.tags?.some((t8) => t8.startsWith(ENVIRONMENT_TAG_PREFIX))
  );
  const workerName = topLevelEnv?.name ?? workers[0].name;
  const entrypoint = topLevelEnv?.entrypoint ?? workers[0].entrypoint;
  let combinedConfig;
  if (topLevelEnv) {
    combinedConfig = convertWorkerToWranglerConfig(topLevelEnv);
  } else {
    combinedConfig = {
      name: workerName,
      main: entrypoint
    };
  }
  for (const env6 of workers) {
    const serviceTag = env6.tags?.find(
      (t8) => t8 === `${SERVICE_TAG_PREFIX}${workerName}`
    );
    const envTag = env6.tags?.find((t8) => t8.startsWith(ENVIRONMENT_TAG_PREFIX));
    if (serviceTag !== `${SERVICE_TAG_PREFIX}${workerName}` || envTag === void 0) {
      continue;
    }
    const [_5, envName] = envTag.split("=");
    combinedConfig.env ??= {};
    combinedConfig.env[envName] = convertWorkerToWranglerConfig(env6);
  }
  return combinedConfig;
}
var __defProp2, __name2, INHERIT_SYMBOL, SERVICE_TAG_PREFIX, ENVIRONMENT_TAG_PREFIX, PATH_TO_DEPLOY_CONFIG;
var init_chunk_4DJ4YNBY = __esm({
  "../workers-utils/dist/chunk-4DJ4YNBY.mjs"() {
    init_import_meta_url();
    __defProp2 = Object.defineProperty;
    __name2 = /* @__PURE__ */ __name((target, value) => __defProp2(target, "name", { value, configurable: true }), "__name");
    INHERIT_SYMBOL = Symbol.for("inherit_binding");
    SERVICE_TAG_PREFIX = "cf:service=";
    ENVIRONMENT_TAG_PREFIX = "cf:environment=";
    PATH_TO_DEPLOY_CONFIG = ".wrangler/deploy/config.json";
    __name(formatCompatibilityDate, "formatCompatibilityDate");
    __name2(formatCompatibilityDate, "formatCompatibilityDate");
    __name(assertNever, "assertNever");
    __name2(assertNever, "assertNever");
    __name(mapWorkerMetadataBindings, "mapWorkerMetadataBindings");
    __name2(mapWorkerMetadataBindings, "mapWorkerMetadataBindings");
    __name(convertWorkerToWranglerConfig, "convertWorkerToWranglerConfig");
    __name2(convertWorkerToWranglerConfig, "convertWorkerToWranglerConfig");
    __name(constructWranglerConfig, "constructWranglerConfig");
    __name2(constructWranglerConfig, "constructWranglerConfig");
  }
});
function getLineColFromPtr(string, ptr) {
  let lines = string.slice(0, ptr).split(/\r\n|\n|\r/g);
  return [lines.length, lines.pop().length + 1];
}
function makeCodeBlock(string, line, column) {
  let lines = string.split(/\r\n|\n|\r/g);
  let codeblock = "";
  let numberLen = (Math.log10(line + 1) | 0) + 1;
  for (let i6 = line - 1; i6 <= line + 1; i6++) {
    let l7 = lines[i6 - 1];
    if (!l7)
      continue;
    codeblock += i6.toString().padEnd(numberLen, " ");
    codeblock += ":  ";
    codeblock += l7;
    codeblock += "\n";
    if (i6 === line) {
      codeblock += " ".repeat(numberLen + column + 2);
      codeblock += "^\n";
    }
  }
  return codeblock;
}
function isEscaped(str, ptr) {
  let i6 = 0;
  while (str[ptr - ++i6] === "\\")
    ;
  return --i6 && i6 % 2;
}
function indexOfNewline(str, start = 0, end = str.length) {
  let idx = str.indexOf("\n", start);
  if (str[idx - 1] === "\r")
    idx--;
  return idx <= end ? idx : -1;
}
function skipComment(str, ptr) {
  for (let i6 = ptr; i6 < str.length; i6++) {
    let c7 = str[i6];
    if (c7 === "\n")
      return i6;
    if (c7 === "\r" && str[i6 + 1] === "\n")
      return i6 + 1;
    if (c7 < " " && c7 !== "	" || c7 === "\x7F") {
      throw new TomlError2("control characters are not allowed in comments", {
        toml: str,
        ptr
      });
    }
  }
  return str.length;
}
function skipVoid(str, ptr, banNewLines, banComments) {
  let c7;
  while ((c7 = str[ptr]) === " " || c7 === "	" || !banNewLines && (c7 === "\n" || c7 === "\r" && str[ptr + 1] === "\n"))
    ptr++;
  return banComments || c7 !== "#" ? ptr : skipVoid(str, skipComment(str, ptr), banNewLines);
}
function skipUntil(str, ptr, sep6, end, banNewLines = false) {
  if (!end) {
    ptr = indexOfNewline(str, ptr);
    return ptr < 0 ? str.length : ptr;
  }
  for (let i6 = ptr; i6 < str.length; i6++) {
    let c7 = str[i6];
    if (c7 === "#") {
      i6 = indexOfNewline(str, i6);
    } else if (c7 === sep6) {
      return i6 + 1;
    } else if (c7 === end || banNewLines && (c7 === "\n" || c7 === "\r" && str[i6 + 1] === "\n")) {
      return i6;
    }
  }
  throw new TomlError2("cannot find end of structure", {
    toml: str,
    ptr
  });
}
function getStringEnd(str, seek) {
  let first = str[seek];
  let target = first === str[seek + 1] && str[seek + 1] === str[seek + 2] ? str.slice(seek, seek + 3) : first;
  seek += target.length - 1;
  do
    seek = str.indexOf(target, ++seek);
  while (seek > -1 && first !== "'" && isEscaped(str, seek));
  if (seek > -1) {
    seek += target.length;
    if (target.length > 1) {
      if (str[seek] === first)
        seek++;
      if (str[seek] === first)
        seek++;
    }
  }
  return seek;
}
function parseString(str, ptr = 0, endPtr = str.length) {
  let isLiteral = str[ptr] === "'";
  let isMultiline = str[ptr++] === str[ptr] && str[ptr] === str[ptr + 1];
  if (isMultiline) {
    endPtr -= 2;
    if (str[ptr += 2] === "\r")
      ptr++;
    if (str[ptr] === "\n")
      ptr++;
  }
  let tmp = 0;
  let isEscape;
  let parsed = "";
  let sliceStart = ptr;
  while (ptr < endPtr - 1) {
    let c7 = str[ptr++];
    if (c7 === "\n" || c7 === "\r" && str[ptr] === "\n") {
      if (!isMultiline) {
        throw new TomlError2("newlines are not allowed in strings", {
          toml: str,
          ptr: ptr - 1
        });
      }
    } else if (c7 < " " && c7 !== "	" || c7 === "\x7F") {
      throw new TomlError2("control characters are not allowed in strings", {
        toml: str,
        ptr: ptr - 1
      });
    }
    if (isEscape) {
      isEscape = false;
      if (c7 === "u" || c7 === "U") {
        let code = str.slice(ptr, ptr += c7 === "u" ? 4 : 8);
        if (!ESCAPE_REGEX.test(code)) {
          throw new TomlError2("invalid unicode escape", {
            toml: str,
            ptr: tmp
          });
        }
        try {
          parsed += String.fromCodePoint(parseInt(code, 16));
        } catch {
          throw new TomlError2("invalid unicode escape", {
            toml: str,
            ptr: tmp
          });
        }
      } else if (isMultiline && (c7 === "\n" || c7 === " " || c7 === "	" || c7 === "\r")) {
        ptr = skipVoid(str, ptr - 1, true);
        if (str[ptr] !== "\n" && str[ptr] !== "\r") {
          throw new TomlError2("invalid escape: only line-ending whitespace may be escaped", {
            toml: str,
            ptr: tmp
          });
        }
        ptr = skipVoid(str, ptr);
      } else if (c7 in ESC_MAP) {
        parsed += ESC_MAP[c7];
      } else {
        throw new TomlError2("unrecognized escape sequence", {
          toml: str,
          ptr: tmp
        });
      }
      sliceStart = ptr;
    } else if (!isLiteral && c7 === "\\") {
      tmp = ptr - 1;
      isEscape = true;
      parsed += str.slice(sliceStart, tmp);
    }
  }
  return parsed + str.slice(sliceStart, endPtr - 1);
}
function parseValue(value, toml, ptr, integersAsBigInt) {
  if (value === "true")
    return true;
  if (value === "false")
    return false;
  if (value === "-inf")
    return -Infinity;
  if (value === "inf" || value === "+inf")
    return Infinity;
  if (value === "nan" || value === "+nan" || value === "-nan")
    return NaN;
  if (value === "-0")
    return integersAsBigInt ? 0n : 0;
  let isInt = INT_REGEX.test(value);
  if (isInt || FLOAT_REGEX.test(value)) {
    if (LEADING_ZERO.test(value)) {
      throw new TomlError2("leading zeroes are not allowed", {
        toml,
        ptr
      });
    }
    value = value.replace(/_/g, "");
    let numeric = +value;
    if (isNaN(numeric)) {
      throw new TomlError2("invalid number", {
        toml,
        ptr
      });
    }
    if (isInt) {
      if ((isInt = !Number.isSafeInteger(numeric)) && !integersAsBigInt) {
        throw new TomlError2("integer value cannot be represented losslessly", {
          toml,
          ptr
        });
      }
      if (isInt || integersAsBigInt === true)
        numeric = BigInt(value);
    }
    return numeric;
  }
  const date = new TomlDate(value);
  if (!date.isValid()) {
    throw new TomlError2("invalid value", {
      toml,
      ptr
    });
  }
  return date;
}
function sliceAndTrimEndOf(str, startPtr, endPtr, allowNewLines) {
  let value = str.slice(startPtr, endPtr);
  let commentIdx = value.indexOf("#");
  if (commentIdx > -1) {
    skipComment(str, commentIdx);
    value = value.slice(0, commentIdx);
  }
  let trimmed = value.trimEnd();
  if (!allowNewLines) {
    let newlineIdx = value.indexOf("\n", trimmed.length);
    if (newlineIdx > -1) {
      throw new TomlError2("newlines are not allowed in inline tables", {
        toml: str,
        ptr: startPtr + newlineIdx
      });
    }
  }
  return [trimmed, commentIdx];
}
function extractValue(str, ptr, end, depth, integersAsBigInt) {
  if (depth === 0) {
    throw new TomlError2("document contains excessively nested structures. aborting.", {
      toml: str,
      ptr
    });
  }
  let c7 = str[ptr];
  if (c7 === "[" || c7 === "{") {
    let [value, endPtr2] = c7 === "[" ? parseArray(str, ptr, depth, integersAsBigInt) : parseInlineTable(str, ptr, depth, integersAsBigInt);
    let newPtr = end ? skipUntil(str, endPtr2, ",", end) : endPtr2;
    if (endPtr2 - newPtr && end === "}") {
      let nextNewLine = indexOfNewline(str, endPtr2, newPtr);
      if (nextNewLine > -1) {
        throw new TomlError2("newlines are not allowed in inline tables", {
          toml: str,
          ptr: nextNewLine
        });
      }
    }
    return [value, newPtr];
  }
  let endPtr;
  if (c7 === '"' || c7 === "'") {
    endPtr = getStringEnd(str, ptr);
    let parsed = parseString(str, ptr, endPtr);
    if (end) {
      endPtr = skipVoid(str, endPtr, end !== "]");
      if (str[endPtr] && str[endPtr] !== "," && str[endPtr] !== end && str[endPtr] !== "\n" && str[endPtr] !== "\r") {
        throw new TomlError2("unexpected character encountered", {
          toml: str,
          ptr: endPtr
        });
      }
      endPtr += +(str[endPtr] === ",");
    }
    return [parsed, endPtr];
  }
  endPtr = skipUntil(str, ptr, ",", end);
  let slice = sliceAndTrimEndOf(str, ptr, endPtr - +(str[endPtr - 1] === ","), end === "]");
  if (!slice[0]) {
    throw new TomlError2("incomplete key-value declaration: no value specified", {
      toml: str,
      ptr
    });
  }
  if (end && slice[1] > -1) {
    endPtr = skipVoid(str, ptr + slice[1]);
    endPtr += +(str[endPtr] === ",");
  }
  return [
    parseValue(slice[0], str, ptr, integersAsBigInt),
    endPtr
  ];
}
function parseKey(str, ptr, end = "=") {
  let dot = ptr - 1;
  let parsed = [];
  let endPtr = str.indexOf(end, ptr);
  if (endPtr < 0) {
    throw new TomlError2("incomplete key-value: cannot find end of key", {
      toml: str,
      ptr
    });
  }
  do {
    let c7 = str[ptr = ++dot];
    if (c7 !== " " && c7 !== "	") {
      if (c7 === '"' || c7 === "'") {
        if (c7 === str[ptr + 1] && c7 === str[ptr + 2]) {
          throw new TomlError2("multiline strings are not allowed in keys", {
            toml: str,
            ptr
          });
        }
        let eos = getStringEnd(str, ptr);
        if (eos < 0) {
          throw new TomlError2("unfinished string encountered", {
            toml: str,
            ptr
          });
        }
        dot = str.indexOf(".", eos);
        let strEnd = str.slice(eos, dot < 0 || dot > endPtr ? endPtr : dot);
        let newLine = indexOfNewline(strEnd);
        if (newLine > -1) {
          throw new TomlError2("newlines are not allowed in keys", {
            toml: str,
            ptr: ptr + dot + newLine
          });
        }
        if (strEnd.trimStart()) {
          throw new TomlError2("found extra tokens after the string part", {
            toml: str,
            ptr: eos
          });
        }
        if (endPtr < eos) {
          endPtr = str.indexOf(end, eos);
          if (endPtr < 0) {
            throw new TomlError2("incomplete key-value: cannot find end of key", {
              toml: str,
              ptr
            });
          }
        }
        parsed.push(parseString(str, ptr, eos));
      } else {
        dot = str.indexOf(".", ptr);
        let part = str.slice(ptr, dot < 0 || dot > endPtr ? endPtr : dot);
        if (!KEY_PART_RE.test(part)) {
          throw new TomlError2("only letter, numbers, dashes and underscores are allowed in keys", {
            toml: str,
            ptr
          });
        }
        parsed.push(part.trimEnd());
      }
    }
  } while (dot + 1 && dot < endPtr);
  return [parsed, skipVoid(str, endPtr + 1, true, true)];
}
function parseInlineTable(str, ptr, depth, integersAsBigInt) {
  let res = {};
  let seen = /* @__PURE__ */ new Set();
  let c7;
  let comma = 0;
  ptr++;
  while ((c7 = str[ptr++]) !== "}" && c7) {
    let err = { toml: str, ptr: ptr - 1 };
    if (c7 === "\n") {
      throw new TomlError2("newlines are not allowed in inline tables", err);
    } else if (c7 === "#") {
      throw new TomlError2("inline tables cannot contain comments", err);
    } else if (c7 === ",") {
      throw new TomlError2("expected key-value, found comma", err);
    } else if (c7 !== " " && c7 !== "	") {
      let k7;
      let t8 = res;
      let hasOwn2 = false;
      let [key, keyEndPtr] = parseKey(str, ptr - 1);
      for (let i6 = 0; i6 < key.length; i6++) {
        if (i6)
          t8 = hasOwn2 ? t8[k7] : t8[k7] = {};
        k7 = key[i6];
        if ((hasOwn2 = Object.hasOwn(t8, k7)) && (typeof t8[k7] !== "object" || seen.has(t8[k7]))) {
          throw new TomlError2("trying to redefine an already defined value", {
            toml: str,
            ptr
          });
        }
        if (!hasOwn2 && k7 === "__proto__") {
          Object.defineProperty(t8, k7, { enumerable: true, configurable: true, writable: true });
        }
      }
      if (hasOwn2) {
        throw new TomlError2("trying to redefine an already defined value", {
          toml: str,
          ptr
        });
      }
      let [value, valueEndPtr] = extractValue(str, keyEndPtr, "}", depth - 1, integersAsBigInt);
      seen.add(value);
      t8[k7] = value;
      ptr = valueEndPtr;
      comma = str[ptr - 1] === "," ? ptr - 1 : 0;
    }
  }
  if (comma) {
    throw new TomlError2("trailing commas are not allowed in inline tables", {
      toml: str,
      ptr: comma
    });
  }
  if (!c7) {
    throw new TomlError2("unfinished table encountered", {
      toml: str,
      ptr
    });
  }
  return [res, ptr];
}
function parseArray(str, ptr, depth, integersAsBigInt) {
  let res = [];
  let c7;
  ptr++;
  while ((c7 = str[ptr++]) !== "]" && c7) {
    if (c7 === ",") {
      throw new TomlError2("expected value, found comma", {
        toml: str,
        ptr: ptr - 1
      });
    } else if (c7 === "#")
      ptr = skipComment(str, ptr);
    else if (c7 !== " " && c7 !== "	" && c7 !== "\n" && c7 !== "\r") {
      let e8 = extractValue(str, ptr - 1, "]", depth - 1, integersAsBigInt);
      res.push(e8[0]);
      ptr = e8[1];
    }
  }
  if (!c7) {
    throw new TomlError2("unfinished array encountered", {
      toml: str,
      ptr
    });
  }
  return [res, ptr];
}
function peekTable(key, table, meta, type) {
  let t8 = table;
  let m7 = meta;
  let k7;
  let hasOwn2 = false;
  let state2;
  for (let i6 = 0; i6 < key.length; i6++) {
    if (i6) {
      t8 = hasOwn2 ? t8[k7] : t8[k7] = {};
      m7 = (state2 = m7[k7]).c;
      if (type === 0 && (state2.t === 1 || state2.t === 2)) {
        return null;
      }
      if (state2.t === 2) {
        let l7 = t8.length - 1;
        t8 = t8[l7];
        m7 = m7[l7].c;
      }
    }
    k7 = key[i6];
    if ((hasOwn2 = Object.hasOwn(t8, k7)) && m7[k7]?.t === 0 && m7[k7]?.d) {
      return null;
    }
    if (!hasOwn2) {
      if (k7 === "__proto__") {
        Object.defineProperty(t8, k7, { enumerable: true, configurable: true, writable: true });
        Object.defineProperty(m7, k7, { enumerable: true, configurable: true, writable: true });
      }
      m7[k7] = {
        t: i6 < key.length - 1 && type === 2 ? 3 : type,
        d: false,
        i: 0,
        c: {}
      };
    }
  }
  state2 = m7[k7];
  if (state2.t !== type && !(type === 1 && state2.t === 3)) {
    return null;
  }
  if (type === 2) {
    if (!state2.d) {
      state2.d = true;
      t8[k7] = [];
    }
    t8[k7].push(t8 = {});
    state2.c[state2.i++] = state2 = { t: 1, d: false, i: 0, c: {} };
  }
  if (state2.d) {
    return null;
  }
  state2.d = true;
  if (type === 1) {
    t8 = hasOwn2 ? t8[k7] : t8[k7] = {};
  } else if (type === 0 && hasOwn2) {
    return null;
  }
  return [k7, t8, state2.c];
}
function parse(toml, { maxDepth = 1e3, integersAsBigInt } = {}) {
  let res = {};
  let meta = {};
  let tbl = res;
  let m7 = meta;
  for (let ptr = skipVoid(toml, 0); ptr < toml.length; ) {
    if (toml[ptr] === "[") {
      let isTableArray = toml[++ptr] === "[";
      let k7 = parseKey(toml, ptr += +isTableArray, "]");
      if (isTableArray) {
        if (toml[k7[1] - 1] !== "]") {
          throw new TomlError2("expected end of table declaration", {
            toml,
            ptr: k7[1] - 1
          });
        }
        k7[1]++;
      }
      let p7 = peekTable(
        k7[0],
        res,
        meta,
        isTableArray ? 2 : 1
        /* Type.EXPLICIT */
      );
      if (!p7) {
        throw new TomlError2("trying to redefine an already defined table or value", {
          toml,
          ptr
        });
      }
      m7 = p7[2];
      tbl = p7[1];
      ptr = k7[1];
    } else {
      let k7 = parseKey(toml, ptr);
      let p7 = peekTable(
        k7[0],
        tbl,
        m7,
        0
        /* Type.DOTTED */
      );
      if (!p7) {
        throw new TomlError2("trying to redefine an already defined table or value", {
          toml,
          ptr
        });
      }
      let v8 = extractValue(toml, k7[1], void 0, maxDepth, integersAsBigInt);
      p7[1][p7[0]] = v8[0];
      ptr = v8[1];
    }
    ptr = skipVoid(toml, ptr, true);
    if (toml[ptr] && toml[ptr] !== "\n" && toml[ptr] !== "\r") {
      throw new TomlError2("each key-value declaration must be followed by an end-of-line", {
        toml,
        ptr
      });
    }
    ptr = skipVoid(toml, ptr);
  }
  return res;
}
function extendedTypeOf(obj) {
  let type = typeof obj;
  if (type === "object") {
    if (Array.isArray(obj))
      return "array";
    if (obj instanceof Date)
      return "date";
  }
  return type;
}
function isArrayOfTables(obj) {
  for (let i6 = 0; i6 < obj.length; i6++) {
    if (extendedTypeOf(obj[i6]) !== "object")
      return false;
  }
  return obj.length != 0;
}
function formatString(s6) {
  return JSON.stringify(s6).replace(/\x7f/g, "\\u007f");
}
function stringifyValue(val2, type, depth, numberAsFloat) {
  if (depth === 0) {
    throw new Error("Could not stringify the object: maximum object depth exceeded");
  }
  if (type === "number") {
    if (isNaN(val2))
      return "nan";
    if (val2 === Infinity)
      return "inf";
    if (val2 === -Infinity)
      return "-inf";
    if (numberAsFloat && Number.isInteger(val2))
      return val2.toFixed(1);
    return val2.toString();
  }
  if (type === "bigint" || type === "boolean") {
    return val2.toString();
  }
  if (type === "string") {
    return formatString(val2);
  }
  if (type === "date") {
    if (isNaN(val2.getTime())) {
      throw new TypeError("cannot serialize invalid date");
    }
    return val2.toISOString();
  }
  if (type === "object") {
    return stringifyInlineTable(val2, depth, numberAsFloat);
  }
  if (type === "array") {
    return stringifyArray(val2, depth, numberAsFloat);
  }
}
function stringifyInlineTable(obj, depth, numberAsFloat) {
  let keys = Object.keys(obj);
  if (keys.length === 0)
    return "{}";
  let res = "{ ";
  for (let i6 = 0; i6 < keys.length; i6++) {
    let k7 = keys[i6];
    if (i6)
      res += ", ";
    res += BARE_KEY.test(k7) ? k7 : formatString(k7);
    res += " = ";
    res += stringifyValue(obj[k7], extendedTypeOf(obj[k7]), depth - 1, numberAsFloat);
  }
  return res + " }";
}
function stringifyArray(array, depth, numberAsFloat) {
  if (array.length === 0)
    return "[]";
  let res = "[ ";
  for (let i6 = 0; i6 < array.length; i6++) {
    if (i6)
      res += ", ";
    if (array[i6] === null || array[i6] === void 0) {
      throw new TypeError("arrays cannot contain null or undefined values");
    }
    res += stringifyValue(array[i6], extendedTypeOf(array[i6]), depth - 1, numberAsFloat);
  }
  return res + " ]";
}
function stringifyArrayTable(array, key, depth, numberAsFloat) {
  if (depth === 0) {
    throw new Error("Could not stringify the object: maximum object depth exceeded");
  }
  let res = "";
  for (let i6 = 0; i6 < array.length; i6++) {
    res += `${res && "\n"}[[${key}]]
`;
    res += stringifyTable(0, array[i6], key, depth, numberAsFloat);
  }
  return res;
}
function stringifyTable(tableKey, obj, prefix, depth, numberAsFloat) {
  if (depth === 0) {
    throw new Error("Could not stringify the object: maximum object depth exceeded");
  }
  let preamble = "";
  let tables = "";
  let keys = Object.keys(obj);
  for (let i6 = 0; i6 < keys.length; i6++) {
    let k7 = keys[i6];
    if (obj[k7] !== null && obj[k7] !== void 0) {
      let type = extendedTypeOf(obj[k7]);
      if (type === "symbol" || type === "function") {
        throw new TypeError(`cannot serialize values of type '${type}'`);
      }
      let key = BARE_KEY.test(k7) ? k7 : formatString(k7);
      if (type === "array" && isArrayOfTables(obj[k7])) {
        tables += (tables && "\n") + stringifyArrayTable(obj[k7], prefix ? `${prefix}.${key}` : key, depth - 1, numberAsFloat);
      } else if (type === "object") {
        let tblKey = prefix ? `${prefix}.${key}` : key;
        tables += (tables && "\n") + stringifyTable(tblKey, obj[k7], tblKey, depth - 1, numberAsFloat);
      } else {
        preamble += key;
        preamble += " = ";
        preamble += stringifyValue(obj[k7], type, depth, numberAsFloat);
        preamble += "\n";
      }
    }
  }
  if (tableKey && (preamble || !tables))
    preamble = preamble ? `[${tableKey}]
${preamble}` : `[${tableKey}]`;
  return preamble && tables ? `${preamble}
${tables}` : preamble || tables;
}
function stringify(obj, { maxDepth = 1e3, numbersAsFloat = false } = {}) {
  if (extendedTypeOf(obj) !== "object") {
    throw new TypeError("stringify can only be called with an object");
  }
  let str = stringifyTable(0, obj, "", maxDepth, numbersAsFloat);
  if (str[str.length - 1] !== "\n")
    return str + "\n";
  return str;
}
function createScanner(text, ignoreTrivia = false) {
  const len = text.length;
  let pos = 0, value = "", tokenOffset = 0, token = 16, lineNumber = 0, lineStartOffset = 0, tokenLineStartOffset = 0, prevTokenLineStartOffset = 0, scanError = 0;
  function scanHexDigits(count, exact) {
    let digits2 = 0;
    let value2 = 0;
    while (digits2 < count || !exact) {
      let ch2 = text.charCodeAt(pos);
      if (ch2 >= 48 && ch2 <= 57) {
        value2 = value2 * 16 + ch2 - 48;
      } else if (ch2 >= 65 && ch2 <= 70) {
        value2 = value2 * 16 + ch2 - 65 + 10;
      } else if (ch2 >= 97 && ch2 <= 102) {
        value2 = value2 * 16 + ch2 - 97 + 10;
      } else {
        break;
      }
      pos++;
      digits2++;
    }
    if (digits2 < count) {
      value2 = -1;
    }
    return value2;
  }
  __name(scanHexDigits, "scanHexDigits");
  __name2(scanHexDigits, "scanHexDigits");
  function setPosition(newPosition) {
    pos = newPosition;
    value = "";
    tokenOffset = 0;
    token = 16;
    scanError = 0;
  }
  __name(setPosition, "setPosition");
  __name2(setPosition, "setPosition");
  function scanNumber() {
    let start = pos;
    if (text.charCodeAt(pos) === 48) {
      pos++;
    } else {
      pos++;
      while (pos < text.length && isDigit2(text.charCodeAt(pos))) {
        pos++;
      }
    }
    if (pos < text.length && text.charCodeAt(pos) === 46) {
      pos++;
      if (pos < text.length && isDigit2(text.charCodeAt(pos))) {
        pos++;
        while (pos < text.length && isDigit2(text.charCodeAt(pos))) {
          pos++;
        }
      } else {
        scanError = 3;
        return text.substring(start, pos);
      }
    }
    let end = pos;
    if (pos < text.length && (text.charCodeAt(pos) === 69 || text.charCodeAt(pos) === 101)) {
      pos++;
      if (pos < text.length && text.charCodeAt(pos) === 43 || text.charCodeAt(pos) === 45) {
        pos++;
      }
      if (pos < text.length && isDigit2(text.charCodeAt(pos))) {
        pos++;
        while (pos < text.length && isDigit2(text.charCodeAt(pos))) {
          pos++;
        }
        end = pos;
      } else {
        scanError = 3;
      }
    }
    return text.substring(start, end);
  }
  __name(scanNumber, "scanNumber");
  __name2(scanNumber, "scanNumber");
  function scanString() {
    let result = "", start = pos;
    while (true) {
      if (pos >= len) {
        result += text.substring(start, pos);
        scanError = 2;
        break;
      }
      const ch2 = text.charCodeAt(pos);
      if (ch2 === 34) {
        result += text.substring(start, pos);
        pos++;
        break;
      }
      if (ch2 === 92) {
        result += text.substring(start, pos);
        pos++;
        if (pos >= len) {
          scanError = 2;
          break;
        }
        const ch22 = text.charCodeAt(pos++);
        switch (ch22) {
          case 34:
            result += '"';
            break;
          case 92:
            result += "\\";
            break;
          case 47:
            result += "/";
            break;
          case 98:
            result += "\b";
            break;
          case 102:
            result += "\f";
            break;
          case 110:
            result += "\n";
            break;
          case 114:
            result += "\r";
            break;
          case 116:
            result += "	";
            break;
          case 117:
            const ch3 = scanHexDigits(4, true);
            if (ch3 >= 0) {
              result += String.fromCharCode(ch3);
            } else {
              scanError = 4;
            }
            break;
          default:
            scanError = 5;
        }
        start = pos;
        continue;
      }
      if (ch2 >= 0 && ch2 <= 31) {
        if (isLineBreak(ch2)) {
          result += text.substring(start, pos);
          scanError = 2;
          break;
        } else {
          scanError = 6;
        }
      }
      pos++;
    }
    return result;
  }
  __name(scanString, "scanString");
  __name2(scanString, "scanString");
  function scanNext() {
    value = "";
    scanError = 0;
    tokenOffset = pos;
    lineStartOffset = lineNumber;
    prevTokenLineStartOffset = tokenLineStartOffset;
    if (pos >= len) {
      tokenOffset = len;
      return token = 17;
    }
    let code = text.charCodeAt(pos);
    if (isWhiteSpace(code)) {
      do {
        pos++;
        value += String.fromCharCode(code);
        code = text.charCodeAt(pos);
      } while (isWhiteSpace(code));
      return token = 15;
    }
    if (isLineBreak(code)) {
      pos++;
      value += String.fromCharCode(code);
      if (code === 13 && text.charCodeAt(pos) === 10) {
        pos++;
        value += "\n";
      }
      lineNumber++;
      tokenLineStartOffset = pos;
      return token = 14;
    }
    switch (code) {
      // tokens: []{}:,
      case 123:
        pos++;
        return token = 1;
      case 125:
        pos++;
        return token = 2;
      case 91:
        pos++;
        return token = 3;
      case 93:
        pos++;
        return token = 4;
      case 58:
        pos++;
        return token = 6;
      case 44:
        pos++;
        return token = 5;
      // strings
      case 34:
        pos++;
        value = scanString();
        return token = 10;
      // comments
      case 47:
        const start = pos - 1;
        if (text.charCodeAt(pos + 1) === 47) {
          pos += 2;
          while (pos < len) {
            if (isLineBreak(text.charCodeAt(pos))) {
              break;
            }
            pos++;
          }
          value = text.substring(start, pos);
          return token = 12;
        }
        if (text.charCodeAt(pos + 1) === 42) {
          pos += 2;
          const safeLength = len - 1;
          let commentClosed = false;
          while (pos < safeLength) {
            const ch2 = text.charCodeAt(pos);
            if (ch2 === 42 && text.charCodeAt(pos + 1) === 47) {
              pos += 2;
              commentClosed = true;
              break;
            }
            pos++;
            if (isLineBreak(ch2)) {
              if (ch2 === 13 && text.charCodeAt(pos) === 10) {
                pos++;
              }
              lineNumber++;
              tokenLineStartOffset = pos;
            }
          }
          if (!commentClosed) {
            pos++;
            scanError = 1;
          }
          value = text.substring(start, pos);
          return token = 13;
        }
        value += String.fromCharCode(code);
        pos++;
        return token = 16;
      // numbers
      case 45:
        value += String.fromCharCode(code);
        pos++;
        if (pos === len || !isDigit2(text.charCodeAt(pos))) {
          return token = 16;
        }
      // found a minus, followed by a number so
      // we fall through to proceed with scanning
      // numbers
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
        value += scanNumber();
        return token = 11;
      // literals and unknown symbols
      default:
        while (pos < len && isUnknownContentCharacter(code)) {
          pos++;
          code = text.charCodeAt(pos);
        }
        if (tokenOffset !== pos) {
          value = text.substring(tokenOffset, pos);
          switch (value) {
            case "true":
              return token = 8;
            case "false":
              return token = 9;
            case "null":
              return token = 7;
          }
          return token = 16;
        }
        value += String.fromCharCode(code);
        pos++;
        return token = 16;
    }
  }
  __name(scanNext, "scanNext");
  __name2(scanNext, "scanNext");
  function isUnknownContentCharacter(code) {
    if (isWhiteSpace(code) || isLineBreak(code)) {
      return false;
    }
    switch (code) {
      case 125:
      case 93:
      case 123:
      case 91:
      case 34:
      case 58:
      case 44:
      case 47:
        return false;
    }
    return true;
  }
  __name(isUnknownContentCharacter, "isUnknownContentCharacter");
  __name2(isUnknownContentCharacter, "isUnknownContentCharacter");
  function scanNextNonTrivia() {
    let result;
    do {
      result = scanNext();
    } while (result >= 12 && result <= 15);
    return result;
  }
  __name(scanNextNonTrivia, "scanNextNonTrivia");
  __name2(scanNextNonTrivia, "scanNextNonTrivia");
  return {
    setPosition,
    getPosition: /* @__PURE__ */ __name2(() => pos, "getPosition"),
    scan: ignoreTrivia ? scanNextNonTrivia : scanNext,
    getToken: /* @__PURE__ */ __name2(() => token, "getToken"),
    getTokenValue: /* @__PURE__ */ __name2(() => value, "getTokenValue"),
    getTokenOffset: /* @__PURE__ */ __name2(() => tokenOffset, "getTokenOffset"),
    getTokenLength: /* @__PURE__ */ __name2(() => pos - tokenOffset, "getTokenLength"),
    getTokenStartLine: /* @__PURE__ */ __name2(() => lineStartOffset, "getTokenStartLine"),
    getTokenStartCharacter: /* @__PURE__ */ __name2(() => tokenOffset - prevTokenLineStartOffset, "getTokenStartCharacter"),
    getTokenError: /* @__PURE__ */ __name2(() => scanError, "getTokenError")
  };
}
function isWhiteSpace(ch2) {
  return ch2 === 32 || ch2 === 9;
}
function isLineBreak(ch2) {
  return ch2 === 10 || ch2 === 13;
}
function isDigit2(ch2) {
  return ch2 >= 48 && ch2 <= 57;
}
function format(documentText, range, options) {
  let initialIndentLevel;
  let formatText;
  let formatTextStart;
  let rangeStart;
  let rangeEnd;
  if (range) {
    rangeStart = range.offset;
    rangeEnd = rangeStart + range.length;
    formatTextStart = rangeStart;
    while (formatTextStart > 0 && !isEOL(documentText, formatTextStart - 1)) {
      formatTextStart--;
    }
    let endOffset = rangeEnd;
    while (endOffset < documentText.length && !isEOL(documentText, endOffset)) {
      endOffset++;
    }
    formatText = documentText.substring(formatTextStart, endOffset);
    initialIndentLevel = computeIndentLevel(formatText, options);
  } else {
    formatText = documentText;
    initialIndentLevel = 0;
    formatTextStart = 0;
    rangeStart = 0;
    rangeEnd = documentText.length;
  }
  const eol = getEOL(options, documentText);
  let numberLineBreaks = 0;
  let indentLevel = 0;
  let indentValue;
  if (options.insertSpaces) {
    indentValue = repeat(" ", options.tabSize || 4);
  } else {
    indentValue = "	";
  }
  let scanner = createScanner(formatText, false);
  let hasError = false;
  function newLinesAndIndent() {
    if (numberLineBreaks > 1) {
      return repeat(eol, numberLineBreaks) + repeat(indentValue, initialIndentLevel + indentLevel);
    } else {
      return eol + repeat(indentValue, initialIndentLevel + indentLevel);
    }
  }
  __name(newLinesAndIndent, "newLinesAndIndent");
  __name2(newLinesAndIndent, "newLinesAndIndent");
  function scanNext() {
    let token = scanner.scan();
    numberLineBreaks = 0;
    while (token === 15 || token === 14) {
      if (token === 14 && options.keepLines) {
        numberLineBreaks += 1;
      } else if (token === 14) {
        numberLineBreaks = 1;
      }
      token = scanner.scan();
    }
    hasError = token === 16 || scanner.getTokenError() !== 0;
    return token;
  }
  __name(scanNext, "scanNext");
  __name2(scanNext, "scanNext");
  const editOperations = [];
  function addEdit(text, startOffset, endOffset) {
    if (!hasError && (!range || startOffset < rangeEnd && endOffset > rangeStart) && documentText.substring(startOffset, endOffset) !== text) {
      editOperations.push({ offset: startOffset, length: endOffset - startOffset, content: text });
    }
  }
  __name(addEdit, "addEdit");
  __name2(addEdit, "addEdit");
  let firstToken = scanNext();
  if (options.keepLines && numberLineBreaks > 0) {
    addEdit(repeat(eol, numberLineBreaks), 0, 0);
  }
  if (firstToken !== 17) {
    let firstTokenStart = scanner.getTokenOffset() + formatTextStart;
    let initialIndent = repeat(indentValue, initialIndentLevel);
    addEdit(initialIndent, formatTextStart, firstTokenStart);
  }
  while (firstToken !== 17) {
    let firstTokenEnd = scanner.getTokenOffset() + scanner.getTokenLength() + formatTextStart;
    let secondToken = scanNext();
    let replaceContent = "";
    let needsLineBreak = false;
    while (numberLineBreaks === 0 && (secondToken === 12 || secondToken === 13)) {
      let commentTokenStart = scanner.getTokenOffset() + formatTextStart;
      addEdit(" ", firstTokenEnd, commentTokenStart);
      firstTokenEnd = scanner.getTokenOffset() + scanner.getTokenLength() + formatTextStart;
      needsLineBreak = secondToken === 12;
      replaceContent = needsLineBreak ? newLinesAndIndent() : "";
      secondToken = scanNext();
    }
    if (secondToken === 2) {
      if (firstToken !== 1) {
        indentLevel--;
      }
      if (options.keepLines && numberLineBreaks > 0 || !options.keepLines && firstToken !== 1) {
        replaceContent = newLinesAndIndent();
      } else if (options.keepLines) {
        replaceContent = " ";
      }
    } else if (secondToken === 4) {
      if (firstToken !== 3) {
        indentLevel--;
      }
      if (options.keepLines && numberLineBreaks > 0 || !options.keepLines && firstToken !== 3) {
        replaceContent = newLinesAndIndent();
      } else if (options.keepLines) {
        replaceContent = " ";
      }
    } else {
      switch (firstToken) {
        case 3:
        case 1:
          indentLevel++;
          if (options.keepLines && numberLineBreaks > 0 || !options.keepLines) {
            replaceContent = newLinesAndIndent();
          } else {
            replaceContent = " ";
          }
          break;
        case 5:
          if (options.keepLines && numberLineBreaks > 0 || !options.keepLines) {
            replaceContent = newLinesAndIndent();
          } else {
            replaceContent = " ";
          }
          break;
        case 12:
          replaceContent = newLinesAndIndent();
          break;
        case 13:
          if (numberLineBreaks > 0) {
            replaceContent = newLinesAndIndent();
          } else if (!needsLineBreak) {
            replaceContent = " ";
          }
          break;
        case 6:
          if (options.keepLines && numberLineBreaks > 0) {
            replaceContent = newLinesAndIndent();
          } else if (!needsLineBreak) {
            replaceContent = " ";
          }
          break;
        case 10:
          if (options.keepLines && numberLineBreaks > 0) {
            replaceContent = newLinesAndIndent();
          } else if (secondToken === 6 && !needsLineBreak) {
            replaceContent = "";
          }
          break;
        case 7:
        case 8:
        case 9:
        case 11:
        case 2:
        case 4:
          if (options.keepLines && numberLineBreaks > 0) {
            replaceContent = newLinesAndIndent();
          } else {
            if ((secondToken === 12 || secondToken === 13) && !needsLineBreak) {
              replaceContent = " ";
            } else if (secondToken !== 5 && secondToken !== 17) {
              hasError = true;
            }
          }
          break;
        case 16:
          hasError = true;
          break;
      }
      if (numberLineBreaks > 0 && (secondToken === 12 || secondToken === 13)) {
        replaceContent = newLinesAndIndent();
      }
    }
    if (secondToken === 17) {
      if (options.keepLines && numberLineBreaks > 0) {
        replaceContent = newLinesAndIndent();
      } else {
        replaceContent = options.insertFinalNewline ? eol : "";
      }
    }
    const secondTokenStart = scanner.getTokenOffset() + formatTextStart;
    addEdit(replaceContent, firstTokenEnd, secondTokenStart);
    firstToken = secondToken;
  }
  return editOperations;
}
function repeat(s6, count) {
  let result = "";
  for (let i6 = 0; i6 < count; i6++) {
    result += s6;
  }
  return result;
}
function computeIndentLevel(content, options) {
  let i6 = 0;
  let nChars = 0;
  const tabSize = options.tabSize || 4;
  while (i6 < content.length) {
    let ch2 = content.charAt(i6);
    if (ch2 === " ") {
      nChars++;
    } else if (ch2 === "	") {
      nChars += tabSize;
    } else {
      break;
    }
    i6++;
  }
  return Math.floor(nChars / tabSize);
}
function getEOL(options, text) {
  for (let i6 = 0; i6 < text.length; i6++) {
    const ch2 = text.charAt(i6);
    if (ch2 === "\r") {
      if (i6 + 1 < text.length && text.charAt(i6 + 1) === "\n") {
        return "\r\n";
      }
      return "\r";
    } else if (ch2 === "\n") {
      return "\n";
    }
  }
  return options && options.eol || "\n";
}
function isEOL(text, offset) {
  return "\r\n".indexOf(text.charAt(offset)) !== -1;
}
function parse2(text, errors = [], options = ParseOptions.DEFAULT) {
  let currentProperty = null;
  let currentParent = [];
  const previousParents = [];
  function onValue(value) {
    if (Array.isArray(currentParent)) {
      currentParent.push(value);
    } else if (currentProperty !== null) {
      currentParent[currentProperty] = value;
    }
  }
  __name(onValue, "onValue");
  __name2(onValue, "onValue");
  const visitor = {
    onObjectBegin: /* @__PURE__ */ __name2(() => {
      const object = {};
      onValue(object);
      previousParents.push(currentParent);
      currentParent = object;
      currentProperty = null;
    }, "onObjectBegin"),
    onObjectProperty: /* @__PURE__ */ __name2((name2) => {
      currentProperty = name2;
    }, "onObjectProperty"),
    onObjectEnd: /* @__PURE__ */ __name2(() => {
      currentParent = previousParents.pop();
    }, "onObjectEnd"),
    onArrayBegin: /* @__PURE__ */ __name2(() => {
      const array = [];
      onValue(array);
      previousParents.push(currentParent);
      currentParent = array;
      currentProperty = null;
    }, "onArrayBegin"),
    onArrayEnd: /* @__PURE__ */ __name2(() => {
      currentParent = previousParents.pop();
    }, "onArrayEnd"),
    onLiteralValue: onValue,
    onError: /* @__PURE__ */ __name2((error2, offset, length) => {
      errors.push({ error: error2, offset, length });
    }, "onError")
  };
  visit(text, visitor, options);
  return currentParent[0];
}
function parseTree(text, errors = [], options = ParseOptions.DEFAULT) {
  let currentParent = { type: "array", offset: -1, length: -1, children: [], parent: void 0 };
  function ensurePropertyComplete(endOffset) {
    if (currentParent.type === "property") {
      currentParent.length = endOffset - currentParent.offset;
      currentParent = currentParent.parent;
    }
  }
  __name(ensurePropertyComplete, "ensurePropertyComplete");
  __name2(ensurePropertyComplete, "ensurePropertyComplete");
  function onValue(valueNode) {
    currentParent.children.push(valueNode);
    return valueNode;
  }
  __name(onValue, "onValue");
  __name2(onValue, "onValue");
  const visitor = {
    onObjectBegin: /* @__PURE__ */ __name2((offset) => {
      currentParent = onValue({ type: "object", offset, length: -1, parent: currentParent, children: [] });
    }, "onObjectBegin"),
    onObjectProperty: /* @__PURE__ */ __name2((name2, offset, length) => {
      currentParent = onValue({ type: "property", offset, length: -1, parent: currentParent, children: [] });
      currentParent.children.push({ type: "string", value: name2, offset, length, parent: currentParent });
    }, "onObjectProperty"),
    onObjectEnd: /* @__PURE__ */ __name2((offset, length) => {
      ensurePropertyComplete(offset + length);
      currentParent.length = offset + length - currentParent.offset;
      currentParent = currentParent.parent;
      ensurePropertyComplete(offset + length);
    }, "onObjectEnd"),
    onArrayBegin: /* @__PURE__ */ __name2((offset, length) => {
      currentParent = onValue({ type: "array", offset, length: -1, parent: currentParent, children: [] });
    }, "onArrayBegin"),
    onArrayEnd: /* @__PURE__ */ __name2((offset, length) => {
      currentParent.length = offset + length - currentParent.offset;
      currentParent = currentParent.parent;
      ensurePropertyComplete(offset + length);
    }, "onArrayEnd"),
    onLiteralValue: /* @__PURE__ */ __name2((value, offset, length) => {
      onValue({ type: getNodeType(value), offset, length, parent: currentParent, value });
      ensurePropertyComplete(offset + length);
    }, "onLiteralValue"),
    onSeparator: /* @__PURE__ */ __name2((sep6, offset, length) => {
      if (currentParent.type === "property") {
        if (sep6 === ":") {
          currentParent.colonOffset = offset;
        } else if (sep6 === ",") {
          ensurePropertyComplete(offset);
        }
      }
    }, "onSeparator"),
    onError: /* @__PURE__ */ __name2((error2, offset, length) => {
      errors.push({ error: error2, offset, length });
    }, "onError")
  };
  visit(text, visitor, options);
  const result = currentParent.children[0];
  if (result) {
    delete result.parent;
  }
  return result;
}
function findNodeAtLocation(root, path610) {
  if (!root) {
    return void 0;
  }
  let node2 = root;
  for (let segment of path610) {
    if (typeof segment === "string") {
      if (node2.type !== "object" || !Array.isArray(node2.children)) {
        return void 0;
      }
      let found = false;
      for (const propertyNode of node2.children) {
        if (Array.isArray(propertyNode.children) && propertyNode.children[0].value === segment && propertyNode.children.length === 2) {
          node2 = propertyNode.children[1];
          found = true;
          break;
        }
      }
      if (!found) {
        return void 0;
      }
    } else {
      const index = segment;
      if (node2.type !== "array" || index < 0 || !Array.isArray(node2.children) || index >= node2.children.length) {
        return void 0;
      }
      node2 = node2.children[index];
    }
  }
  return node2;
}
function visit(text, visitor, options = ParseOptions.DEFAULT) {
  const _scanner = createScanner(text, false);
  const _jsonPath = [];
  function toNoArgVisit(visitFunction) {
    return visitFunction ? () => visitFunction(_scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter()) : () => true;
  }
  __name(toNoArgVisit, "toNoArgVisit");
  __name2(toNoArgVisit, "toNoArgVisit");
  function toNoArgVisitWithPath(visitFunction) {
    return visitFunction ? () => visitFunction(_scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter(), () => _jsonPath.slice()) : () => true;
  }
  __name(toNoArgVisitWithPath, "toNoArgVisitWithPath");
  __name2(toNoArgVisitWithPath, "toNoArgVisitWithPath");
  function toOneArgVisit(visitFunction) {
    return visitFunction ? (arg) => visitFunction(arg, _scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter()) : () => true;
  }
  __name(toOneArgVisit, "toOneArgVisit");
  __name2(toOneArgVisit, "toOneArgVisit");
  function toOneArgVisitWithPath(visitFunction) {
    return visitFunction ? (arg) => visitFunction(arg, _scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter(), () => _jsonPath.slice()) : () => true;
  }
  __name(toOneArgVisitWithPath, "toOneArgVisitWithPath");
  __name2(toOneArgVisitWithPath, "toOneArgVisitWithPath");
  const onObjectBegin = toNoArgVisitWithPath(visitor.onObjectBegin), onObjectProperty = toOneArgVisitWithPath(visitor.onObjectProperty), onObjectEnd = toNoArgVisit(visitor.onObjectEnd), onArrayBegin = toNoArgVisitWithPath(visitor.onArrayBegin), onArrayEnd = toNoArgVisit(visitor.onArrayEnd), onLiteralValue = toOneArgVisitWithPath(visitor.onLiteralValue), onSeparator = toOneArgVisit(visitor.onSeparator), onComment = toNoArgVisit(visitor.onComment), onError = toOneArgVisit(visitor.onError);
  const disallowComments = options && options.disallowComments;
  const allowTrailingComma = options && options.allowTrailingComma;
  function scanNext() {
    while (true) {
      const token = _scanner.scan();
      switch (_scanner.getTokenError()) {
        case 4:
          handleError2(
            14
            /* ParseErrorCode.InvalidUnicode */
          );
          break;
        case 5:
          handleError2(
            15
            /* ParseErrorCode.InvalidEscapeCharacter */
          );
          break;
        case 3:
          handleError2(
            13
            /* ParseErrorCode.UnexpectedEndOfNumber */
          );
          break;
        case 1:
          if (!disallowComments) {
            handleError2(
              11
              /* ParseErrorCode.UnexpectedEndOfComment */
            );
          }
          break;
        case 2:
          handleError2(
            12
            /* ParseErrorCode.UnexpectedEndOfString */
          );
          break;
        case 6:
          handleError2(
            16
            /* ParseErrorCode.InvalidCharacter */
          );
          break;
      }
      switch (token) {
        case 12:
        case 13:
          if (disallowComments) {
            handleError2(
              10
              /* ParseErrorCode.InvalidCommentToken */
            );
          } else {
            onComment();
          }
          break;
        case 16:
          handleError2(
            1
            /* ParseErrorCode.InvalidSymbol */
          );
          break;
        case 15:
        case 14:
          break;
        default:
          return token;
      }
    }
  }
  __name(scanNext, "scanNext");
  __name2(scanNext, "scanNext");
  function handleError2(error2, skipUntilAfter = [], skipUntil22 = []) {
    onError(error2);
    if (skipUntilAfter.length + skipUntil22.length > 0) {
      let token = _scanner.getToken();
      while (token !== 17) {
        if (skipUntilAfter.indexOf(token) !== -1) {
          scanNext();
          break;
        } else if (skipUntil22.indexOf(token) !== -1) {
          break;
        }
        token = scanNext();
      }
    }
  }
  __name(handleError2, "handleError");
  __name2(handleError2, "handleError");
  function parseString22(isValue) {
    const value = _scanner.getTokenValue();
    if (isValue) {
      onLiteralValue(value);
    } else {
      onObjectProperty(value);
      _jsonPath.push(value);
    }
    scanNext();
    return true;
  }
  __name(parseString22, "parseString2");
  __name2(parseString22, "parseString");
  function parseLiteral() {
    switch (_scanner.getToken()) {
      case 11:
        const tokenValue = _scanner.getTokenValue();
        let value = Number(tokenValue);
        if (isNaN(value)) {
          handleError2(
            2
            /* ParseErrorCode.InvalidNumberFormat */
          );
          value = 0;
        }
        onLiteralValue(value);
        break;
      case 7:
        onLiteralValue(null);
        break;
      case 8:
        onLiteralValue(true);
        break;
      case 9:
        onLiteralValue(false);
        break;
      default:
        return false;
    }
    scanNext();
    return true;
  }
  __name(parseLiteral, "parseLiteral");
  __name2(parseLiteral, "parseLiteral");
  function parseProperty() {
    if (_scanner.getToken() !== 10) {
      handleError2(3, [], [
        2,
        5
        /* SyntaxKind.CommaToken */
      ]);
      return false;
    }
    parseString22(false);
    if (_scanner.getToken() === 6) {
      onSeparator(":");
      scanNext();
      if (!parseValue22()) {
        handleError2(4, [], [
          2,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
    } else {
      handleError2(5, [], [
        2,
        5
        /* SyntaxKind.CommaToken */
      ]);
    }
    _jsonPath.pop();
    return true;
  }
  __name(parseProperty, "parseProperty");
  __name2(parseProperty, "parseProperty");
  function parseObject() {
    onObjectBegin();
    scanNext();
    let needsComma = false;
    while (_scanner.getToken() !== 2 && _scanner.getToken() !== 17) {
      if (_scanner.getToken() === 5) {
        if (!needsComma) {
          handleError2(4, [], []);
        }
        onSeparator(",");
        scanNext();
        if (_scanner.getToken() === 2 && allowTrailingComma) {
          break;
        }
      } else if (needsComma) {
        handleError2(6, [], []);
      }
      if (!parseProperty()) {
        handleError2(4, [], [
          2,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
      needsComma = true;
    }
    onObjectEnd();
    if (_scanner.getToken() !== 2) {
      handleError2(7, [
        2
        /* SyntaxKind.CloseBraceToken */
      ], []);
    } else {
      scanNext();
    }
    return true;
  }
  __name(parseObject, "parseObject");
  __name2(parseObject, "parseObject");
  function parseArray22() {
    onArrayBegin();
    scanNext();
    let isFirstElement = true;
    let needsComma = false;
    while (_scanner.getToken() !== 4 && _scanner.getToken() !== 17) {
      if (_scanner.getToken() === 5) {
        if (!needsComma) {
          handleError2(4, [], []);
        }
        onSeparator(",");
        scanNext();
        if (_scanner.getToken() === 4 && allowTrailingComma) {
          break;
        }
      } else if (needsComma) {
        handleError2(6, [], []);
      }
      if (isFirstElement) {
        _jsonPath.push(0);
        isFirstElement = false;
      } else {
        _jsonPath[_jsonPath.length - 1]++;
      }
      if (!parseValue22()) {
        handleError2(4, [], [
          4,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
      needsComma = true;
    }
    onArrayEnd();
    if (!isFirstElement) {
      _jsonPath.pop();
    }
    if (_scanner.getToken() !== 4) {
      handleError2(8, [
        4
        /* SyntaxKind.CloseBracketToken */
      ], []);
    } else {
      scanNext();
    }
    return true;
  }
  __name(parseArray22, "parseArray2");
  __name2(parseArray22, "parseArray");
  function parseValue22() {
    switch (_scanner.getToken()) {
      case 3:
        return parseArray22();
      case 1:
        return parseObject();
      case 10:
        return parseString22(true);
      default:
        return parseLiteral();
    }
  }
  __name(parseValue22, "parseValue2");
  __name2(parseValue22, "parseValue");
  scanNext();
  if (_scanner.getToken() === 17) {
    if (options.allowEmptyContent) {
      return true;
    }
    handleError2(4, [], []);
    return false;
  }
  if (!parseValue22()) {
    handleError2(4, [], []);
    return false;
  }
  if (_scanner.getToken() !== 17) {
    handleError2(9, [], []);
  }
  return true;
}
function getNodeType(value) {
  switch (typeof value) {
    case "boolean":
      return "boolean";
    case "number":
      return "number";
    case "string":
      return "string";
    case "object": {
      if (!value) {
        return "null";
      } else if (Array.isArray(value)) {
        return "array";
      }
      return "object";
    }
    default:
      return "null";
  }
}
function setProperty(text, originalPath, value, options) {
  const path610 = originalPath.slice();
  const errors = [];
  const root = parseTree(text, errors);
  let parent = void 0;
  let lastSegment = void 0;
  while (path610.length > 0) {
    lastSegment = path610.pop();
    parent = findNodeAtLocation(root, path610);
    if (parent === void 0 && value !== void 0) {
      if (typeof lastSegment === "string") {
        value = { [lastSegment]: value };
      } else {
        value = [value];
      }
    } else {
      break;
    }
  }
  if (!parent) {
    if (value === void 0) {
      throw new Error("Can not delete in empty document");
    }
    return withFormatting(text, { offset: root ? root.offset : 0, length: root ? root.length : 0, content: JSON.stringify(value) }, options);
  } else if (parent.type === "object" && typeof lastSegment === "string" && Array.isArray(parent.children)) {
    const existing = findNodeAtLocation(parent, [lastSegment]);
    if (existing !== void 0) {
      if (value === void 0) {
        if (!existing.parent) {
          throw new Error("Malformed AST");
        }
        const propertyIndex = parent.children.indexOf(existing.parent);
        let removeBegin;
        let removeEnd = existing.parent.offset + existing.parent.length;
        if (propertyIndex > 0) {
          let previous = parent.children[propertyIndex - 1];
          removeBegin = previous.offset + previous.length;
        } else {
          removeBegin = parent.offset + 1;
          if (parent.children.length > 1) {
            let next = parent.children[1];
            removeEnd = next.offset;
          }
        }
        return withFormatting(text, { offset: removeBegin, length: removeEnd - removeBegin, content: "" }, options);
      } else {
        return withFormatting(text, { offset: existing.offset, length: existing.length, content: JSON.stringify(value) }, options);
      }
    } else {
      if (value === void 0) {
        return [];
      }
      const newProperty = `${JSON.stringify(lastSegment)}: ${JSON.stringify(value)}`;
      const index = options.getInsertionIndex ? options.getInsertionIndex(parent.children.map((p7) => p7.children[0].value)) : parent.children.length;
      let edit;
      if (index > 0) {
        let previous = parent.children[index - 1];
        edit = { offset: previous.offset + previous.length, length: 0, content: "," + newProperty };
      } else if (parent.children.length === 0) {
        edit = { offset: parent.offset + 1, length: 0, content: newProperty };
      } else {
        edit = { offset: parent.offset + 1, length: 0, content: newProperty + "," };
      }
      return withFormatting(text, edit, options);
    }
  } else if (parent.type === "array" && typeof lastSegment === "number" && Array.isArray(parent.children)) {
    const insertIndex = lastSegment;
    if (insertIndex === -1) {
      const newProperty = `${JSON.stringify(value)}`;
      let edit;
      if (parent.children.length === 0) {
        edit = { offset: parent.offset + 1, length: 0, content: newProperty };
      } else {
        const previous = parent.children[parent.children.length - 1];
        edit = { offset: previous.offset + previous.length, length: 0, content: "," + newProperty };
      }
      return withFormatting(text, edit, options);
    } else if (value === void 0 && parent.children.length >= 0) {
      const removalIndex = lastSegment;
      const toRemove = parent.children[removalIndex];
      let edit;
      if (parent.children.length === 1) {
        edit = { offset: parent.offset + 1, length: parent.length - 2, content: "" };
      } else if (parent.children.length - 1 === removalIndex) {
        let previous = parent.children[removalIndex - 1];
        let offset = previous.offset + previous.length;
        let parentEndOffset = parent.offset + parent.length;
        edit = { offset, length: parentEndOffset - 2 - offset, content: "" };
      } else {
        edit = { offset: toRemove.offset, length: parent.children[removalIndex + 1].offset - toRemove.offset, content: "" };
      }
      return withFormatting(text, edit, options);
    } else if (value !== void 0) {
      let edit;
      const newProperty = `${JSON.stringify(value)}`;
      if (!options.isArrayInsertion && parent.children.length > lastSegment) {
        const toModify = parent.children[lastSegment];
        edit = { offset: toModify.offset, length: toModify.length, content: newProperty };
      } else if (parent.children.length === 0 || lastSegment === 0) {
        edit = { offset: parent.offset + 1, length: 0, content: parent.children.length === 0 ? newProperty : newProperty + "," };
      } else {
        const index = lastSegment > parent.children.length ? parent.children.length : lastSegment;
        const previous = parent.children[index - 1];
        edit = { offset: previous.offset + previous.length, length: 0, content: "," + newProperty };
      }
      return withFormatting(text, edit, options);
    } else {
      throw new Error(`Can not ${value === void 0 ? "remove" : options.isArrayInsertion ? "insert" : "modify"} Array index ${insertIndex} as length is not sufficient`);
    }
  } else {
    throw new Error(`Can not add ${typeof lastSegment !== "number" ? "index" : "property"} to parent of type ${parent.type}`);
  }
}
function withFormatting(text, edit, options) {
  if (!options.formattingOptions) {
    return [edit];
  }
  let newText = applyEdit(text, edit);
  let begin = edit.offset;
  let end = edit.offset + edit.content.length;
  if (edit.length === 0 || edit.content.length === 0) {
    while (begin > 0 && !isEOL(newText, begin - 1)) {
      begin--;
    }
    while (end < newText.length && !isEOL(newText, end)) {
      end++;
    }
  }
  const edits = format(newText, { offset: begin, length: end - begin }, { ...options.formattingOptions, keepLines: false });
  for (let i6 = edits.length - 1; i6 >= 0; i6--) {
    const edit2 = edits[i6];
    newText = applyEdit(newText, edit2);
    begin = Math.min(begin, edit2.offset);
    end = Math.max(end, edit2.offset + edit2.length);
    end += edit2.content.length - edit2.length;
  }
  const editLength = text.length - (newText.length - end) - begin;
  return [{ offset: begin, length: editLength, content: newText.substring(begin, end) }];
}
function applyEdit(text, edit) {
  return text.substring(0, edit.offset) + edit.content + text.substring(edit.offset + edit.length);
}
function printParseErrorCode(code) {
  switch (code) {
    case 1:
      return "InvalidSymbol";
    case 2:
      return "InvalidNumberFormat";
    case 3:
      return "PropertyNameExpected";
    case 4:
      return "ValueExpected";
    case 5:
      return "ColonExpected";
    case 6:
      return "CommaExpected";
    case 7:
      return "CloseBraceExpected";
    case 8:
      return "CloseBracketExpected";
    case 9:
      return "EndOfFileExpected";
    case 10:
      return "InvalidCommentToken";
    case 11:
      return "UnexpectedEndOfComment";
    case 12:
      return "UnexpectedEndOfString";
    case 13:
      return "UnexpectedEndOfNumber";
    case 14:
      return "InvalidUnicode";
    case 15:
      return "InvalidEscapeCharacter";
    case 16:
      return "InvalidCharacter";
  }
  return "<unknown ParseErrorCode>";
}
function format2(documentText, range, options) {
  return format(documentText, range, options);
}
function modify(text, path610, value, options) {
  return setProperty(text, path610, value, options);
}
function applyEdits(text, edits) {
  let sortedEdits = edits.slice(0).sort((a6, b7) => {
    const diff = a6.offset - b7.offset;
    if (diff === 0) {
      return a6.length - b7.length;
    }
    return diff;
  });
  let lastModifiedOffset = text.length;
  for (let i6 = sortedEdits.length - 1; i6 >= 0; i6--) {
    let e8 = sortedEdits[i6];
    if (e8.offset + e8.length <= lastModifiedOffset) {
      text = applyEdit(text, e8);
    } else {
      throw new Error("Overlapping edit");
    }
    lastModifiedOffset = e8.offset;
  }
  return text;
}
function createFatalError(message, isJson, code, telemetryMessage) {
  if (isJson) {
    return new JsonFriendlyFatalError(
      JSON.stringify(message),
      code,
      telemetryMessage
    );
  } else {
    return new FatalError(`${message}`, code, telemetryMessage);
  }
}
function parseTOML(input, file) {
  try {
    return dist_default.parse(input);
  } catch (err) {
    if (!(err instanceof TomlError2)) {
      throw err;
    }
    const location = {
      lineText: input.split("\n")[err.line - 1],
      line: err.line,
      column: err.column - 1,
      file,
      fileText: input
    };
    throw new ParseError({
      text: err.message.substring(0, err.message.indexOf("\n")),
      location,
      telemetryMessage: "TOML parse error"
    });
  }
}
function parsePackageJSON(input, file) {
  return parseJSON(input, file);
}
function parseJSON(input, file) {
  return parseJSONC(input, file, {
    allowEmptyContent: false,
    allowTrailingComma: false,
    disallowComments: true
  });
}
function parseJSONC(input, file, options = { allowTrailingComma: true }) {
  const errors = [];
  const data = parse3(input, errors, options);
  if (errors.length) {
    throw new ParseError({
      text: printParseErrorCode(errors[0].error),
      location: {
        ...indexLocation({ file, fileText: input }, errors[0].offset + 1),
        length: errors[0].length
      },
      telemetryMessage: "JSON(C) parse error"
    });
  }
  return data;
}
function readFileSyncToBuffer(file) {
  try {
    return fs25.readFileSync(file);
  } catch (err) {
    const { message } = err;
    throw new ParseError({
      text: `Could not read file: ${file}`,
      notes: [
        {
          text: message.replace(file, path5.resolve(file))
        }
      ]
    });
  }
}
function readFileSync(file) {
  try {
    const buffer = fs25.readFileSync(file);
    return removeBOMAndValidate(buffer, file);
  } catch (err) {
    if (err instanceof ParseError) {
      throw err;
    }
    const { message } = err;
    throw new ParseError({
      text: `Could not read file: ${file}`,
      notes: [
        {
          text: message.replace(file, path5.resolve(file))
        }
      ],
      telemetryMessage: "Could not read file"
    });
  }
}
function indexLocation(file, index) {
  let lineText, line = 0, column = 0, cursor = 0;
  const { fileText = "" } = file;
  for (const row of fileText.split("\n")) {
    line++;
    cursor += row.length + 1;
    if (cursor >= index) {
      lineText = row;
      column = row.length - (cursor - index);
      break;
    }
  }
  return { lineText, line, column, ...file };
}
function searchLocation(file, query) {
  let lineText, length, line = 0, column = 0;
  const queryText = String(query);
  const { fileText = "" } = file;
  for (const content of fileText.split("\n")) {
    line++;
    const index = content.indexOf(queryText);
    if (index >= 0) {
      lineText = content;
      column = index;
      length = queryText.length;
      break;
    }
  }
  return { lineText, line, column, length, ...file };
}
function parseHumanDuration(s6) {
  const unitsMap = new Map(Object.entries(units));
  s6 = s6.trim().toLowerCase();
  let base = 1;
  for (const [name2, _5] of unitsMap) {
    if (s6.endsWith(name2)) {
      s6 = s6.substring(0, s6.length - name2.length);
      base = unitsMap.get(name2) || 1;
      break;
    }
  }
  return Number(s6) * base;
}
function parseNonHyphenedUuid(uuid) {
  if (uuid == null || uuid.includes("-")) {
    return uuid;
  }
  if (uuid.length != 32) {
    return null;
  }
  const uuid_parts = [];
  uuid_parts.push(uuid.slice(0, 8));
  uuid_parts.push(uuid.slice(8, 12));
  uuid_parts.push(uuid.slice(12, 16));
  uuid_parts.push(uuid.slice(16, 20));
  uuid_parts.push(uuid.slice(20));
  let hyphenated = "";
  uuid_parts.forEach((part) => hyphenated += part + "-");
  return hyphenated.slice(0, 36);
}
function parseByteSize(s6, base = void 0) {
  const match3 = s6.match(
    /^(\d*\.*\d*)\s*([kKmMgGtTpP]{0,1})([i]{0,1}[bB]{0,1})$/
  );
  if (!match3) {
    return NaN;
  }
  const size = match3[1];
  if (size.length === 0 || isNaN(Number(size))) {
    return NaN;
  }
  const unit = match3[2].toLowerCase();
  const sizeUnits = {
    k: 1,
    m: 2,
    g: 3,
    t: 4,
    p: 5
  };
  if (unit.length !== 0 && !(unit in sizeUnits)) {
    return NaN;
  }
  const binary = match3[3].toLowerCase() == "ib";
  if (binary && unit.length === 0) {
    return NaN;
  }
  const pow = sizeUnits[unit] || 0;
  return Math.floor(
    Number(size) * Math.pow(base ?? (binary ? 1024 : 1e3), pow)
  );
}
function removeBOMAndValidate(buffer, file) {
  for (const bom of UNSUPPORTED_BOMS) {
    if (buffer.length >= bom.buffer.length && buffer.subarray(0, bom.buffer.length).equals(bom.buffer)) {
      throw new ParseError({
        text: `Configuration file contains ${bom.encoding} byte order marker`,
        notes: [
          {
            text: `The file "${file}" appears to be encoded as ${bom.encoding}. Please save the file as UTF-8 without BOM.`
          }
        ],
        location: { file, line: 1, column: 0 },
        telemetryMessage: `${bom.encoding} BOM detected`
      });
    }
  }
  const content = buffer.toString("utf-8");
  if (content.charCodeAt(0) === 65279) {
    return content.slice(1);
  }
  return content;
}
function checkType(type) {
  if (type in typeMappings) {
    return;
  }
  throw new Error(`Invalid type specified: ${type}`);
}
function locatePathSync(paths, {
  cwd: cwd2 = process8__default.default.cwd(),
  type = "file",
  allowSymlinks = true
} = {}) {
  checkType(type);
  cwd2 = toPath(cwd2);
  const statFunction = allowSymlinks ? fs25__namespace.default.statSync : fs25__namespace.default.lstatSync;
  for (const path_ of paths) {
    try {
      const stat9 = statFunction(path5__namespace.default.resolve(cwd2, path_));
      if (matchType(type, stat9)) {
        return path_;
      }
    } catch {
    }
  }
}
function findUpMultipleSync(name2, options = {}) {
  let directory = path5__namespace.default.resolve(toPath2(options.cwd) || "");
  const { root } = path5__namespace.default.parse(directory);
  const stopAt = options.stopAt || root;
  const limit2 = options.limit || Number.POSITIVE_INFINITY;
  const paths = [name2].flat();
  const runMatcher = /* @__PURE__ */ __name2((locateOptions) => {
    if (typeof name2 !== "function") {
      return locatePathSync(paths, locateOptions);
    }
    const foundPath = name2(locateOptions.cwd);
    if (typeof foundPath === "string") {
      return locatePathSync([foundPath], locateOptions);
    }
    return foundPath;
  }, "runMatcher");
  const matches = [];
  while (true) {
    const foundPath = runMatcher({ ...options, cwd: directory });
    if (foundPath === findUpStop) {
      break;
    }
    if (foundPath) {
      matches.push(path5__namespace.default.resolve(directory, foundPath));
    }
    if (directory === stopAt || matches.length >= limit2) {
      break;
    }
    directory = path5__namespace.default.dirname(directory);
  }
  return matches;
}
function findUpSync(name2, options = {}) {
  const matches = findUpMultipleSync(name2, { ...options, limit: 1 });
  return matches[0];
}
function dedent(templ) {
  var values = [];
  for (var _i2 = 1; _i2 < arguments.length; _i2++) {
    values[_i2 - 1] = arguments[_i2];
  }
  var strings = Array.from(typeof templ === "string" ? [templ] : templ);
  strings[strings.length - 1] = strings[strings.length - 1].replace(/\r?\n([\t ]*)$/, "");
  var indentLengths = strings.reduce(function(arr, str) {
    var matches = str.match(/\n([\t ]+|(?!\s).)/g);
    if (matches) {
      return arr.concat(matches.map(function(match3) {
        var _a5, _b2;
        return (_b2 = (_a5 = match3.match(/[\t ]/g)) === null || _a5 === void 0 ? void 0 : _a5.length) !== null && _b2 !== void 0 ? _b2 : 0;
      }));
    }
    return arr;
  }, []);
  if (indentLengths.length) {
    var pattern_1 = new RegExp("\n[	 ]{" + Math.min.apply(Math, indentLengths) + "}", "g");
    strings = strings.map(function(str) {
      return str.replace(pattern_1, "\n");
    });
  }
  strings[0] = strings[0].replace(/^\r?\n/, "");
  var string = strings[0];
  values.forEach(function(value, i6) {
    var endentations = string.match(/(?:^|\n)( *)$/);
    var endentation = endentations ? endentations[1] : "";
    var indentedValue = value;
    if (typeof value === "string" && value.includes("\n")) {
      indentedValue = String(value).split("\n").map(function(str, i22) {
        return i22 === 0 ? str : "" + endentation + str;
      }).join("\n");
    }
    string += indentedValue + strings[i6 + 1];
  });
  return string;
}
function resolveWranglerConfigPath({
  config,
  script
}, options) {
  if (config !== void 0) {
    return {
      userConfigPath: config,
      configPath: config,
      deployConfigPath: void 0,
      redirected: false
    };
  }
  const leafPath = script !== void 0 ? path5__namespace.default.dirname(script) : process.cwd();
  return findWranglerConfig(leafPath, options);
}
function findWranglerConfig(referencePath = process.cwd(), { useRedirectIfAvailable = false } = {}) {
  const userConfigPath = findUpSync(`wrangler.json`, { cwd: referencePath }) ?? findUpSync(`wrangler.jsonc`, { cwd: referencePath }) ?? findUpSync(`wrangler.toml`, { cwd: referencePath });
  if (!useRedirectIfAvailable) {
    return {
      userConfigPath,
      configPath: userConfigPath,
      deployConfigPath: void 0,
      redirected: false
    };
  }
  const { configPath, deployConfigPath, redirected } = findRedirectedWranglerConfig(referencePath, userConfigPath);
  return {
    userConfigPath,
    configPath,
    deployConfigPath,
    redirected
  };
}
function findRedirectedWranglerConfig(cwd2, userConfigPath) {
  const deployConfigPath = findUpSync(PATH_TO_DEPLOY_CONFIG, { cwd: cwd2 });
  if (deployConfigPath === void 0) {
    return { configPath: userConfigPath, deployConfigPath, redirected: false };
  }
  let redirectedConfigPath;
  const deployConfigFile = readFileSync(deployConfigPath);
  try {
    const deployConfig = parseJSONC(deployConfigFile, deployConfigPath);
    redirectedConfigPath = deployConfig.configPath && path5__namespace.default.resolve(path5__namespace.default.dirname(deployConfigPath), deployConfig.configPath);
  } catch (e8) {
    throw new UserError(
      `Failed to parse the deploy configuration file at ${path5__namespace.default.relative(".", deployConfigPath)}`,
      { cause: e8 }
    );
  }
  if (!redirectedConfigPath) {
    throw new UserError(esm_default`
			A deploy configuration file was found at "${path5__namespace.default.relative(".", deployConfigPath)}".
			But this is not valid - the required "configPath" property was not found.
			Instead this file contains:
			\`\`\`
			${deployConfigFile}
			\`\`\`
		`);
  }
  if (!fs25.existsSync(redirectedConfigPath)) {
    throw new UserError(esm_default`
				There is a deploy configuration at "${path5__namespace.default.relative(".", deployConfigPath)}".
				But the redirected configuration path it points to, "${path5__namespace.default.relative(".", redirectedConfigPath)}", does not exist.
			`);
  }
  if (userConfigPath) {
    if (path5__namespace.default.join(path5__namespace.default.dirname(userConfigPath), PATH_TO_DEPLOY_CONFIG) !== deployConfigPath) {
      throw new UserError(esm_default`
					Found both a user configuration file at "${path5__namespace.default.relative(".", userConfigPath)}"
					and a deploy configuration file at "${path5__namespace.default.relative(".", deployConfigPath)}".
					But these do not share the same base path so it is not clear which should be used.
				`);
    }
  }
  return {
    configPath: redirectedConfigPath,
    deployConfigPath,
    redirected: true
  };
}
function isRedirectedRawConfig(rawConfig, configPath, userConfigPath) {
  return configPath !== void 0 && configPath !== userConfigPath;
}
function configFormat(configPath) {
  if (configPath?.endsWith("toml")) {
    return "toml";
  } else if (configPath?.endsWith("json") || configPath?.endsWith("jsonc")) {
    return "jsonc";
  }
  return "none";
}
function configFileName(configPath) {
  const format32 = configFormat(configPath);
  if (format32 === "toml") {
    return "wrangler.toml";
  } else if (format32 === "jsonc") {
    return "wrangler.json";
  } else {
    return "Wrangler configuration";
  }
}
function formatConfigSnippet(snippet, configPath, formatted = true) {
  const format32 = configFormat(configPath);
  if (format32 === "toml") {
    return dist_default.stringify(snippet);
  } else {
    return formatted ? JSON.stringify(snippet, null, 2) : JSON.stringify(snippet);
  }
}
function isDir(inputPath) {
  const stats = fs25.statSync(inputPath);
  return stats.isDirectory();
}
function isValidWorkflowName(name2) {
  if (typeof name2 !== "string") {
    return false;
  }
  if (name2.length > MAX_WORKFLOW_NAME_LENGTH) {
    return false;
  }
  return ALLOWED_WORKFLOW_NAME_REGEX.test(name2);
}
function indentText(str) {
  return str.split("\n").map(
    (line, index) => (index === 0 ? line : `  ${line}`).replace(/^\s*$/, "")
  ).join("\n");
}
function deprecated(diagnostics, config, fieldPath, message, remove, title = "Deprecation", type = "warning") {
  const BOLD = "\x1B[1m";
  const NORMAL = "\x1B[0m";
  const diagnosticMessage = `${BOLD}${title}${NORMAL}: "${fieldPath}":
${message}`;
  const result = unwindPropertyPath(config, fieldPath);
  if (result !== void 0 && result.field in result.container) {
    diagnostics[`${type}s`].push(diagnosticMessage);
    if (remove) {
      delete result.container[result.field];
    }
  }
}
function experimental(diagnostics, config, fieldPath) {
  const result = unwindPropertyPath(config, fieldPath);
  if (result !== void 0 && result.field in result.container && !("WRANGLER_DISABLE_EXPERIMENTAL_WARNING" in process.env)) {
    diagnostics.warnings.push(
      `"${fieldPath}" fields are experimental and may change or break at any time.`
    );
  }
}
function inheritable(diagnostics, topLevelEnv, rawEnv, field, validate3, defaultValue, transformFn = (v8) => v8) {
  validate3(diagnostics, field, rawEnv[field], topLevelEnv);
  return (
    // `rawEnv === topLevelEnv` is a special case where the user has provided an environment name
    // but that named environment is not actually defined in the configuration.
    // In that case we have reused the topLevelEnv as the rawEnv,
    // and so we need to process the `transformFn()` anyway rather than just using the field in the `rawEnv`.
    (rawEnv !== topLevelEnv ? rawEnv[field] : void 0) ?? transformFn(topLevelEnv?.[field]) ?? defaultValue
  );
}
function inheritableInWranglerEnvironments(diagnostics, useServiceEnvironments2, topLevelEnv, rawEnv, field, validate3, transformFn = (v8) => v8, defaultValue) {
  const usingServiceEnvironments = useServiceEnvironments2 && topLevelEnv !== void 0;
  return usingServiceEnvironments ? notAllowedInNamedServiceEnvironment(
    diagnostics,
    topLevelEnv,
    rawEnv,
    field
  ) : inheritable(
    diagnostics,
    topLevelEnv,
    rawEnv,
    field,
    validate3,
    defaultValue,
    transformFn
  );
}
function notAllowedInNamedServiceEnvironment(diagnostics, topLevelEnv, rawEnv, field) {
  if (field in rawEnv) {
    diagnostics.errors.push(
      `The "${field}" field is not allowed in named service environments.
Please remove the field from this environment.`
    );
  }
  return topLevelEnv[field];
}
function notInheritable(diagnostics, topLevelEnv, rawConfig, rawEnv, envName, field, validate3, defaultValue) {
  if (rawEnv[field] !== void 0) {
    validate3(diagnostics, field, rawEnv[field], topLevelEnv);
  } else {
    if (rawConfig?.[field] !== void 0) {
      diagnostics.warnings.push(
        `"${field}" exists at the top level, but not on "env.${envName}".
This is not what you probably want, since "${field}" is not inherited by environments.
Please add "${field}" to "env.${envName}".`
      );
    }
  }
  return rawEnv[field] ?? defaultValue;
}
function unwindPropertyPath(root, path610) {
  let container = root;
  const parts = path610.split(".");
  for (let i6 = 0; i6 < parts.length - 1; i6++) {
    if (!hasProperty(container, parts[i6])) {
      return;
    }
    container = container[parts[i6]];
  }
  return { container, field: parts[parts.length - 1] };
}
function isValidR2BucketName(name2) {
  return typeof name2 === "string" && /^[a-z0-9][a-z0-9-]{1,61}[a-z0-9]$/.test(name2);
}
function isPagesConfig(rawConfig) {
  return rawConfig.pages_build_output_dir !== void 0;
}
function normalizeAndValidateConfig(rawConfig, configPath, userConfigPath, args, preserveOriginalMain = false) {
  const diagnostics = new Diagnostics(
    `Processing ${configPath ? path5__namespace.default.relative(process.cwd(), configPath) : "wrangler"} configuration:`
  );
  validateOptionalProperty(
    diagnostics,
    "",
    "legacy_env",
    rawConfig.legacy_env,
    "boolean"
  );
  validateOptionalProperty(
    diagnostics,
    "",
    "send_metrics",
    rawConfig.send_metrics,
    "boolean"
  );
  validateOptionalProperty(
    diagnostics,
    "",
    "keep_vars",
    rawConfig.keep_vars,
    "boolean"
  );
  validateOptionalProperty(
    diagnostics,
    "",
    "pages_build_output_dir",
    rawConfig.pages_build_output_dir,
    "string"
  );
  validateOptionalProperty(
    diagnostics,
    "",
    "$schema",
    rawConfig.$schema,
    "string"
  );
  const useServiceEnvironments2 = !(args["legacy-env"] ?? rawConfig.legacy_env ?? true);
  if (useServiceEnvironments2) {
    diagnostics.warnings.push(
      "Service environments are deprecated, and will be removed in the future. DO NOT USE IN PRODUCTION."
    );
  }
  const isDispatchNamespace = typeof args["dispatch-namespace"] === "string" && args["dispatch-namespace"].trim() !== "";
  const topLevelEnv = normalizeAndValidateEnvironment(
    diagnostics,
    configPath,
    rawConfig,
    isDispatchNamespace,
    preserveOriginalMain
  );
  const isRedirectedConfig = isRedirectedRawConfig(
    rawConfig,
    configPath,
    userConfigPath
  );
  const definedEnvironments = Object.keys(rawConfig.env ?? {});
  if (isRedirectedConfig && definedEnvironments.length > 0) {
    diagnostics.errors.push(
      dedent`
				Redirected configurations cannot include environments but the following have been found:\n${definedEnvironments.map((env6) => `	- ${env6}`).join("\n")}


				Such configurations are generated by tools, meaning that one of the tools
				your application is using is generating the incorrect configuration.
				Report this issue to the tool's author so that this can be fixed there.
				`
    );
  }
  const envName = args.env;
  assert40__default.default(envName === void 0 || typeof envName === "string");
  let activeEnv = topLevelEnv;
  if (envName) {
    if (isRedirectedConfig) {
      if (!isPagesConfig(rawConfig)) {
        diagnostics.errors.push(dedent`
					You have specified the environment "${envName}", but are using a redirected configuration, produced by a build tool such as Vite.
					You need to set the environment in your build tool, rather than via Wrangler.
					For example, if you are using Vite, refer to these docs: https://developers.cloudflare.com/workers/vite-plugin/reference/cloudflare-environments/
				`);
      }
    } else {
      const envDiagnostics = new Diagnostics(
        `"env.${envName}" environment configuration`
      );
      const rawEnv = rawConfig.env?.[envName];
      if (rawEnv !== void 0) {
        activeEnv = normalizeAndValidateEnvironment(
          envDiagnostics,
          configPath,
          rawEnv,
          isDispatchNamespace,
          preserveOriginalMain,
          envName,
          topLevelEnv,
          useServiceEnvironments2,
          rawConfig
        );
        diagnostics.addChild(envDiagnostics);
      } else if (!isPagesConfig(rawConfig)) {
        activeEnv = normalizeAndValidateEnvironment(
          envDiagnostics,
          configPath,
          topLevelEnv,
          // in this case reuse the topLevelEnv to ensure that nonInherited fields are not removed
          isDispatchNamespace,
          preserveOriginalMain,
          envName,
          topLevelEnv,
          useServiceEnvironments2,
          rawConfig
        );
        const envNames = rawConfig.env ? `The available configured environment names are: ${JSON.stringify(
          Object.keys(rawConfig.env)
        )}
` : "";
        const message = `No environment found in configuration with name "${envName}".
Before using \`--env=${envName}\` there should be an equivalent environment section in the configuration.
${envNames}
Consider adding an environment configuration section to the ${configFileName(configPath)} file:
\`\`\`
[env.` + envName + "]\n```\n";
        if (envNames.length > 0) {
          diagnostics.errors.push(message);
        } else {
          diagnostics.warnings.push(message);
        }
      }
    }
  }
  const config = {
    configPath,
    userConfigPath,
    topLevelName: isRedirectedConfig ? rawConfig.topLevelName : rawConfig.name,
    definedEnvironments: isRedirectedConfig ? rawConfig.definedEnvironments : definedEnvironments,
    targetEnvironment: isRedirectedConfig ? rawConfig.targetEnvironment : envName,
    pages_build_output_dir: normalizeAndValidatePagesBuildOutputDir(
      configPath,
      rawConfig.pages_build_output_dir
    ),
    /** Legacy_env is wrangler environments, as opposed to service environments. Wrangler environments is not legacy.  */
    legacy_env: !useServiceEnvironments2,
    send_metrics: rawConfig.send_metrics,
    keep_vars: rawConfig.keep_vars,
    ...activeEnv,
    dev: normalizeAndValidateDev(diagnostics, rawConfig.dev ?? {}, args),
    site: normalizeAndValidateSite(
      diagnostics,
      configPath,
      rawConfig,
      activeEnv.main
    ),
    alias: normalizeAndValidateAliases(diagnostics, configPath, rawConfig),
    wasm_modules: normalizeAndValidateModulePaths(
      diagnostics,
      configPath,
      "wasm_modules",
      rawConfig.wasm_modules
    ),
    text_blobs: normalizeAndValidateModulePaths(
      diagnostics,
      configPath,
      "text_blobs",
      rawConfig.text_blobs
    ),
    data_blobs: normalizeAndValidateModulePaths(
      diagnostics,
      configPath,
      "data_blobs",
      rawConfig.data_blobs
    )
  };
  validateBindingsHaveUniqueNames(diagnostics, config);
  validateAdditionalProperties(
    diagnostics,
    "top-level",
    Object.keys(rawConfig),
    [...Object.keys(config), "env", "$schema"]
  );
  applyPythonConfig(config, args);
  return { config, diagnostics };
}
function applyPythonConfig(config, args) {
  const mainModule = args.script ?? config.main;
  if (typeof mainModule === "string" && mainModule.endsWith(".py")) {
    config.no_bundle = true;
    if (!config.rules.some((rule) => rule.type === "PythonModule")) {
      config.rules.push({ type: "PythonModule", globs: ["**/*.py"] });
    }
    if (!config.compatibility_flags.includes("python_workers")) {
      throw new UserError(
        "The `python_workers` compatibility flag is required to use Python."
      );
    }
  }
}
function normalizeAndValidateBuild(diagnostics, rawEnv, rawBuild, configPath) {
  const { command: command2, cwd: cwd2, watch_dir = "./src", ...rest } = rawBuild;
  validateAdditionalProperties(diagnostics, "build", Object.keys(rest), []);
  validateOptionalProperty(diagnostics, "build", "command", command2, "string");
  validateOptionalProperty(diagnostics, "build", "cwd", cwd2, "string");
  if (Array.isArray(watch_dir)) {
    validateTypedArray(diagnostics, "build.watch_dir", watch_dir, "string");
  } else {
    validateOptionalProperty(
      diagnostics,
      "build",
      "watch_dir",
      watch_dir,
      "string"
    );
  }
  return {
    command: command2,
    watch_dir: (
      // - `watch_dir` only matters when `command` is defined, so we apply
      // a default only when `command` is defined
      // - `configPath` will always be defined since `build` can only
      // be configured in the Wrangler configuration file, but who knows, that may
      // change in the future, so we do a check anyway
      command2 && configPath ? Array.isArray(watch_dir) ? watch_dir.map(
        (dir) => path5__namespace.default.relative(
          process.cwd(),
          path5__namespace.default.join(path5__namespace.default.dirname(configPath), `${dir}`)
        )
      ) : path5__namespace.default.relative(
        process.cwd(),
        path5__namespace.default.join(path5__namespace.default.dirname(configPath), `${watch_dir}`)
      ) : watch_dir
    ),
    cwd: cwd2
  };
}
function normalizeAndValidateMainField(configPath, rawMain) {
  const configDir = path5__namespace.default.dirname(configPath ?? "wrangler.toml");
  if (rawMain !== void 0) {
    if (typeof rawMain === "string") {
      const directory = path5__namespace.default.resolve(configDir);
      return path5__namespace.default.resolve(directory, rawMain);
    } else {
      return rawMain;
    }
  } else {
    return;
  }
}
function normalizeAndValidateBaseDirField(configPath, rawDir) {
  const configDir = path5__namespace.default.dirname(configPath ?? "wrangler.toml");
  if (rawDir !== void 0) {
    if (typeof rawDir === "string") {
      const directory = path5__namespace.default.resolve(configDir);
      return path5__namespace.default.resolve(directory, rawDir);
    } else {
      return rawDir;
    }
  } else {
    return;
  }
}
function normalizeAndValidatePagesBuildOutputDir(configPath, rawPagesDir) {
  const configDir = path5__namespace.default.dirname(configPath ?? "wrangler.toml");
  if (rawPagesDir !== void 0) {
    if (typeof rawPagesDir === "string") {
      const directory = path5__namespace.default.resolve(configDir);
      return path5__namespace.default.resolve(directory, rawPagesDir);
    } else {
      return rawPagesDir;
    }
  } else {
    return;
  }
}
function normalizeAndValidateDev(diagnostics, rawDev, args) {
  assert40__default.default(typeof args === "object" && args !== null && !Array.isArray(args));
  const {
    localProtocol: localProtocolArg,
    upstreamProtocol: upstreamProtocolArg,
    remote: remoteArg,
    enableContainers: enableContainersArg
  } = args;
  assert40__default.default(
    localProtocolArg === void 0 || localProtocolArg === "http" || localProtocolArg === "https"
  );
  assert40__default.default(
    upstreamProtocolArg === void 0 || upstreamProtocolArg === "http" || upstreamProtocolArg === "https"
  );
  assert40__default.default(remoteArg === void 0 || typeof remoteArg === "boolean");
  assert40__default.default(
    enableContainersArg === void 0 || typeof enableContainersArg === "boolean"
  );
  const {
    // On Windows, when specifying `localhost` as the socket hostname, `workerd`
    // will only listen on the IPv4 loopback `127.0.0.1`, not the IPv6 `::1`:
    // https://github.com/cloudflare/workerd/issues/1408
    // On Node 17+, `fetch()` will only try to fetch the IPv6 address.
    // For now, on Windows, we default to listening on IPv4 only and using
    // `127.0.0.1` when sending control requests to `workerd` (e.g. with the
    // `ProxyController`).
    ip = process.platform === "win32" ? "127.0.0.1" : "localhost",
    port,
    inspector_port,
    local_protocol = localProtocolArg ?? "http",
    // In remote mode upstream_protocol must be https, otherwise it defaults to local_protocol.
    upstream_protocol = upstreamProtocolArg ?? remoteArg ? "https" : local_protocol,
    host,
    enable_containers = enableContainersArg ?? true,
    container_engine,
    ...rest
  } = rawDev;
  validateAdditionalProperties(diagnostics, "dev", Object.keys(rest), []);
  validateOptionalProperty(diagnostics, "dev", "ip", ip, "string");
  validateOptionalProperty(diagnostics, "dev", "port", port, "number");
  validateOptionalProperty(
    diagnostics,
    "dev",
    "inspector_port",
    inspector_port,
    "number"
  );
  validateOptionalProperty(
    diagnostics,
    "dev",
    "local_protocol",
    local_protocol,
    "string",
    ["http", "https"]
  );
  validateOptionalProperty(
    diagnostics,
    "dev",
    "upstream_protocol",
    upstream_protocol,
    "string",
    ["http", "https"]
  );
  validateOptionalProperty(diagnostics, "dev", "host", host, "string");
  validateOptionalProperty(
    diagnostics,
    "dev",
    "enable_containers",
    enable_containers,
    "boolean"
  );
  validateOptionalProperty(
    diagnostics,
    "dev",
    "container_engine",
    container_engine,
    "string"
  );
  return {
    ip,
    port,
    inspector_port,
    local_protocol,
    upstream_protocol,
    host,
    enable_containers,
    container_engine
  };
}
function normalizeAndValidateAssets(diagnostics, topLevelEnv, rawEnv) {
  return inheritable(
    diagnostics,
    topLevelEnv,
    rawEnv,
    "assets",
    validateAssetsConfig,
    void 0
  );
}
function normalizeAndValidateSite(diagnostics, configPath, rawConfig, mainEntryPoint) {
  if (rawConfig?.site !== void 0) {
    const { bucket, include = [], exclude = [], ...rest } = rawConfig.site;
    validateAdditionalProperties(diagnostics, "site", Object.keys(rest), [
      "entry-point"
    ]);
    validateRequiredProperty(diagnostics, "site", "bucket", bucket, "string");
    validateTypedArray(diagnostics, "sites.include", include, "string");
    validateTypedArray(diagnostics, "sites.exclude", exclude, "string");
    validateOptionalProperty(
      diagnostics,
      "site",
      "entry-point",
      rawConfig.site["entry-point"],
      "string"
    );
    deprecated(
      diagnostics,
      rawConfig,
      `site.entry-point`,
      `Delete the \`site.entry-point\` field, then add the top level \`main\` field to your configuration file:
\`\`\`
main = "${path5__namespace.default.join(
        String(rawConfig.site["entry-point"]) || "workers-site",
        path5__namespace.default.extname(String(rawConfig.site["entry-point"]) || "workers-site") ? "" : "index.js"
      )}"
\`\`\``,
      false,
      void 0,
      "warning"
    );
    let siteEntryPoint = rawConfig.site["entry-point"];
    if (!mainEntryPoint && !siteEntryPoint) {
      diagnostics.warnings.push(
        `Because you've defined a [site] configuration, we're defaulting to "workers-site" for the deprecated \`site.entry-point\`field.
Add the top level \`main\` field to your configuration file:
\`\`\`
main = "workers-site/index.js"
\`\`\``
      );
      siteEntryPoint = "workers-site";
    } else if (mainEntryPoint && siteEntryPoint) {
      diagnostics.errors.push(
        `Don't define both the \`main\` and \`site.entry-point\` fields in your configuration.
They serve the same purpose: to point to the entry-point of your worker.
Delete the deprecated \`site.entry-point\` field from your config.`
      );
    }
    if (configPath && siteEntryPoint) {
      siteEntryPoint = path5__namespace.default.relative(
        process.cwd(),
        path5__namespace.default.join(path5__namespace.default.dirname(configPath), siteEntryPoint)
      );
    }
    return {
      bucket,
      "entry-point": siteEntryPoint,
      include,
      exclude
    };
  }
  return void 0;
}
function normalizeAndValidateAliases(diagnostics, configPath, rawConfig) {
  if (rawConfig?.alias === void 0) {
    return void 0;
  }
  if (["string", "boolean", "number"].includes(typeof rawConfig?.alias) || typeof rawConfig?.alias !== "object") {
    diagnostics.errors.push(
      `Expected alias to be an object, but got ${typeof rawConfig?.alias}`
    );
    return void 0;
  }
  let isValid2 = true;
  for (const [key, value] of Object.entries(rawConfig?.alias)) {
    if (typeof value !== "string") {
      diagnostics.errors.push(
        `Expected alias["${key}"] to be a string, but got ${typeof value}`
      );
      isValid2 = false;
    }
  }
  if (isValid2) {
    return rawConfig.alias;
  }
  return;
}
function normalizeAndValidateModulePaths(diagnostics, configPath, field, rawMapping) {
  if (rawMapping === void 0) {
    return void 0;
  }
  const mapping = {};
  for (const [name2, filePath] of Object.entries(rawMapping)) {
    if (isString(diagnostics, `${field}['${name2}']`, filePath, void 0)) {
      if (configPath) {
        mapping[name2] = configPath ? path5__namespace.default.relative(
          process.cwd(),
          path5__namespace.default.join(path5__namespace.default.dirname(configPath), filePath)
        ) : filePath;
      }
    }
  }
  return mapping;
}
function isValidRouteValue(item) {
  if (!item) {
    return false;
  }
  if (typeof item === "string") {
    return true;
  }
  if (typeof item === "object") {
    if (!hasProperty(item, "pattern") || typeof item.pattern !== "string") {
      return false;
    }
    const otherKeys = Object.keys(item).length - 1;
    const hasZoneId = hasProperty(item, "zone_id") && typeof item.zone_id === "string";
    const hasZoneName = hasProperty(item, "zone_name") && typeof item.zone_name === "string";
    const hasCustomDomainFlag = hasProperty(item, "custom_domain") && typeof item.custom_domain === "boolean";
    if (otherKeys === 2 && hasCustomDomainFlag && (hasZoneId || hasZoneName)) {
      return true;
    } else if (otherKeys === 1 && (hasZoneId || hasZoneName || hasCustomDomainFlag)) {
      return true;
    }
  }
  return false;
}
function mutateEmptyStringAccountIDValue(diagnostics, rawEnv) {
  if (rawEnv.account_id === "") {
    diagnostics.warnings.push(
      `The "account_id" field in your configuration is an empty string and will be ignored.
Please remove the "account_id" field from your configuration.`
    );
    rawEnv.account_id = void 0;
  }
  return rawEnv;
}
function mutateEmptyStringRouteValue(diagnostics, rawEnv) {
  if (rawEnv["route"] === "") {
    diagnostics.warnings.push(
      `The "route" field in your configuration is an empty string and will be ignored.
Please remove the "route" field from your configuration.`
    );
    rawEnv["route"] = void 0;
  }
  return rawEnv;
}
function normalizeAndValidateRoute(diagnostics, topLevelEnv, rawEnv) {
  return inheritable(
    diagnostics,
    topLevelEnv,
    mutateEmptyStringRouteValue(diagnostics, rawEnv),
    "route",
    isRoute,
    void 0
  );
}
function validateRoutes(diagnostics, topLevelEnv, rawEnv) {
  return inheritable(
    diagnostics,
    topLevelEnv,
    rawEnv,
    "routes",
    all(isRouteArray, isMutuallyExclusiveWith(rawEnv, "route")),
    void 0
  );
}
function normalizeAndValidatePlacement(diagnostics, topLevelEnv, rawEnv) {
  if (rawEnv.placement) {
    validateRequiredProperty(
      diagnostics,
      "placement",
      "mode",
      rawEnv.placement.mode,
      "string",
      ["off", "smart"]
    );
    validateOptionalProperty(
      diagnostics,
      "placement",
      "hint",
      rawEnv.placement.hint,
      "string"
    );
    if (rawEnv.placement.hint && rawEnv.placement.mode !== "smart") {
      diagnostics.errors.push(
        `"placement.hint" cannot be set if "placement.mode" is not "smart"`
      );
    }
  }
  return inheritable(
    diagnostics,
    topLevelEnv,
    rawEnv,
    "placement",
    () => true,
    void 0
  );
}
function validateTailConsumer(diagnostics, field, value) {
  if (typeof value !== "object" || value === null) {
    diagnostics.errors.push(
      `"${field}" should be an object but got ${JSON.stringify(value)}.`
    );
    return false;
  }
  let isValid2 = true;
  isValid2 = isValid2 && validateRequiredProperty(
    diagnostics,
    field,
    "service",
    value.service,
    "string"
  );
  isValid2 = isValid2 && validateOptionalProperty(
    diagnostics,
    field,
    "environment",
    value.environment,
    "string"
  );
  return isValid2;
}
function validateStreamingTailConsumer(diagnostics, field, value) {
  if (typeof value !== "object" || value === null || Array.isArray(value)) {
    diagnostics.errors.push(
      `"${field}" should be an object but got ${JSON.stringify(value)}.`
    );
    return false;
  }
  return validateRequiredProperty(
    diagnostics,
    field,
    "service",
    value.service,
    "string"
  );
}
function normalizeAndValidateEnvironment(diagnostics, configPath, rawEnv, isDispatchNamespace, preserveOriginalMain, envName = "top level", topLevelEnv, useServiceEnvironments2, rawConfig) {
  deprecated(
    diagnostics,
    rawEnv,
    // @ts-expect-error Removed from the config type
    "node_compat",
    `The "node_compat" field is no longer supported as of Wrangler v4. Instead, use the \`nodejs_compat\` compatibility flag. This includes the functionality from legacy \`node_compat\` polyfills and natively implemented Node.js APIs. See https://developers.cloudflare.com/workers/runtime-apis/nodejs for more information.`,
    true,
    "Removed",
    "error"
  );
  experimental(diagnostics, rawEnv, "unsafe");
  const route = normalizeAndValidateRoute(diagnostics, topLevelEnv, rawEnv);
  const account_id = inheritableInWranglerEnvironments(
    diagnostics,
    useServiceEnvironments2,
    topLevelEnv,
    mutateEmptyStringAccountIDValue(diagnostics, rawEnv),
    "account_id",
    isString,
    void 0,
    void 0
  );
  const routes = validateRoutes(diagnostics, topLevelEnv, rawEnv);
  const workers_dev = inheritable(
    diagnostics,
    topLevelEnv,
    rawEnv,
    "workers_dev",
    isBoolean,
    void 0
  );
  const preview_urls = inheritable(
    diagnostics,
    topLevelEnv,
    rawEnv,
    "preview_urls",
    isBoolean,
    void 0
  );
  const build5 = normalizeAndValidateBuild(
    diagnostics,
    rawEnv,
    rawEnv.build ?? topLevelEnv?.build ?? {},
    configPath
  );
  const environment = {
    // Inherited fields
    account_id,
    compatibility_date: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "compatibility_date",
      validateCompatibilityDate,
      void 0
    ),
    compatibility_flags: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "compatibility_flags",
      isStringArray,
      []
    ),
    jsx_factory: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "jsx_factory",
      isString,
      "React.createElement"
    ),
    jsx_fragment: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "jsx_fragment",
      isString,
      "React.Fragment"
    ),
    tsconfig: validateAndNormalizeTsconfig(
      diagnostics,
      topLevelEnv,
      rawEnv,
      configPath
    ),
    rules: validateAndNormalizeRules(diagnostics, topLevelEnv, rawEnv, envName),
    name: inheritableInWranglerEnvironments(
      diagnostics,
      useServiceEnvironments2,
      topLevelEnv,
      rawEnv,
      "name",
      isDispatchNamespace ? isString : isValidName,
      appendEnvName(envName),
      void 0
    ),
    main: preserveOriginalMain ? inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "main",
      isString,
      void 0
    ) : normalizeAndValidateMainField(
      configPath,
      inheritable(
        diagnostics,
        topLevelEnv,
        rawEnv,
        "main",
        isString,
        void 0
      )
    ),
    find_additional_modules: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "find_additional_modules",
      isBoolean,
      void 0
    ),
    preserve_file_names: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "preserve_file_names",
      isBoolean,
      void 0
    ),
    base_dir: normalizeAndValidateBaseDirField(
      configPath,
      inheritable(
        diagnostics,
        topLevelEnv,
        rawEnv,
        "base_dir",
        isString,
        void 0
      )
    ),
    route,
    routes,
    triggers: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "triggers",
      validateTriggers,
      { crons: void 0 }
    ),
    assets: normalizeAndValidateAssets(diagnostics, topLevelEnv, rawEnv),
    limits: normalizeAndValidateLimits(diagnostics, topLevelEnv, rawEnv),
    placement: normalizeAndValidatePlacement(diagnostics, topLevelEnv, rawEnv),
    build: build5,
    workers_dev,
    preview_urls,
    // Not inherited fields
    vars: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "vars",
      validateVars(envName),
      {}
    ),
    define: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "define",
      validateDefines(envName),
      {}
    ),
    durable_objects: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "durable_objects",
      validateBindingsProperty(envName, validateDurableObjectBinding),
      {
        bindings: []
      }
    ),
    workflows: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "workflows",
      all(
        validateBindingArray(envName, validateWorkflowBinding),
        validateUniqueNameProperty
      ),
      []
    ),
    migrations: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "migrations",
      validateMigrations,
      []
    ),
    kv_namespaces: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "kv_namespaces",
      validateBindingArray(envName, validateKVBinding),
      []
    ),
    cloudchamber: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "cloudchamber",
      validateCloudchamberConfig,
      {}
    ),
    containers: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "containers",
      validateContainerApp(envName, rawEnv.name, configPath),
      void 0
    ),
    send_email: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "send_email",
      validateBindingArray(envName, validateSendEmailBinding),
      []
    ),
    queues: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "queues",
      validateQueues(envName),
      { producers: [], consumers: [] }
    ),
    r2_buckets: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "r2_buckets",
      validateBindingArray(envName, validateR2Binding),
      []
    ),
    d1_databases: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "d1_databases",
      validateBindingArray(envName, validateD1Binding),
      []
    ),
    vectorize: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "vectorize",
      validateBindingArray(envName, validateVectorizeBinding),
      []
    ),
    hyperdrive: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "hyperdrive",
      validateBindingArray(envName, validateHyperdriveBinding),
      []
    ),
    services: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "services",
      validateBindingArray(envName, validateServiceBinding),
      []
    ),
    analytics_engine_datasets: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "analytics_engine_datasets",
      validateBindingArray(envName, validateAnalyticsEngineBinding),
      []
    ),
    dispatch_namespaces: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "dispatch_namespaces",
      validateBindingArray(envName, validateWorkerNamespaceBinding),
      []
    ),
    mtls_certificates: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "mtls_certificates",
      validateBindingArray(envName, validateMTlsCertificateBinding),
      []
    ),
    tail_consumers: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "tail_consumers",
      validateTailConsumers,
      void 0
    ),
    streaming_tail_consumers: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "streaming_tail_consumers",
      validateStreamingTailConsumers,
      void 0
    ),
    unsafe: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "unsafe",
      validateUnsafeSettings(envName),
      {}
    ),
    browser: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "browser",
      validateNamedSimpleBinding(envName),
      void 0
    ),
    ai: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "ai",
      validateAIBinding(envName),
      void 0
    ),
    images: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "images",
      validateNamedSimpleBinding(envName),
      void 0
    ),
    media: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "media",
      validateNamedSimpleBinding(envName),
      void 0
    ),
    pipelines: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "pipelines",
      validateBindingArray(envName, validatePipelineBinding),
      []
    ),
    secrets_store_secrets: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "secrets_store_secrets",
      validateBindingArray(envName, validateSecretsStoreSecretBinding),
      []
    ),
    unsafe_hello_world: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "unsafe_hello_world",
      validateBindingArray(envName, validateHelloWorldBinding),
      []
    ),
    worker_loaders: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "worker_loaders",
      validateBindingArray(envName, validateWorkerLoaderBinding),
      []
    ),
    ratelimits: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "ratelimits",
      validateBindingArray(envName, validateRateLimitBinding),
      []
    ),
    vpc_services: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "vpc_services",
      validateBindingArray(envName, validateVpcServiceBinding),
      []
    ),
    version_metadata: notInheritable(
      diagnostics,
      topLevelEnv,
      rawConfig,
      rawEnv,
      envName,
      "version_metadata",
      validateVersionMetadataBinding(envName),
      void 0
    ),
    logfwdr: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "logfwdr",
      validateCflogfwdrObject(envName),
      {
        bindings: []
      }
    ),
    no_bundle: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "no_bundle",
      isBoolean,
      void 0
    ),
    minify: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "minify",
      isBoolean,
      void 0
    ),
    keep_names: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "keep_names",
      isBoolean,
      void 0
    ),
    first_party_worker: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "first_party_worker",
      isBoolean,
      void 0
    ),
    logpush: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "logpush",
      isBoolean,
      void 0
    ),
    upload_source_maps: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "upload_source_maps",
      isBoolean,
      void 0
    ),
    observability: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "observability",
      validateObservability,
      void 0
    ),
    compliance_region: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "compliance_region",
      isOneOf("public", "fedramp_high"),
      void 0
    ),
    python_modules: inheritable(
      diagnostics,
      topLevelEnv,
      rawEnv,
      "python_modules",
      validatePythonModules,
      { exclude: ["**/*.pyc"] }
    )
  };
  warnIfDurableObjectsHaveNoMigrations(
    diagnostics,
    environment.durable_objects,
    environment.migrations,
    configPath
  );
  return environment;
}
function validateAndNormalizeTsconfig(diagnostics, topLevelEnv, rawEnv, configPath) {
  const tsconfig = inheritable(
    diagnostics,
    topLevelEnv,
    rawEnv,
    "tsconfig",
    isString,
    void 0
  );
  return configPath && tsconfig ? path5__namespace.default.relative(
    process.cwd(),
    path5__namespace.default.join(path5__namespace.default.dirname(configPath), tsconfig)
  ) : tsconfig;
}
function validateContainerApp(envName, topLevelName, configPath) {
  return (diagnostics, field, value, config) => {
    if (!value) {
      return true;
    }
    if (!Array.isArray(value)) {
      diagnostics.errors.push(
        `"containers" field should be an array, but got ${JSON.stringify(value)}`
      );
      return false;
    }
    for (const containerAppOptional of value) {
      if (!isOptionalProperty(value, "name", "string")) {
        diagnostics.errors.push(
          `Field "name", when present, should be a string, but got ${JSON.stringify(value)}`
        );
      }
      validateRequiredProperty(
        diagnostics,
        field,
        "class_name",
        containerAppOptional.class_name,
        "string"
      );
      validateOptionalProperty(
        diagnostics,
        field,
        "name",
        containerAppOptional.name,
        "string"
      );
      if (!containerAppOptional.name) {
        if (!topLevelName || !isOptionalProperty(containerAppOptional, "class_name", "string")) {
          diagnostics.errors.push(
            `Must have either a top level "name" and "containers.class_name" field defined, or have field "containers.name" defined.`
          );
        }
        let name2 = `${topLevelName}-${containerAppOptional.class_name}`;
        name2 += config === void 0 ? "" : `-${envName}`;
        containerAppOptional.name = name2.toLowerCase().replace(/ /g, "-");
      }
      if (!containerAppOptional.configuration?.image && !containerAppOptional.image) {
        diagnostics.errors.push(
          `"containers.image" field must be defined for each container app. This should be the path to your Dockerfile or an image URI pointing to the Cloudflare registry.`
        );
      }
      if ("configuration" in containerAppOptional) {
        diagnostics.warnings.push(
          `"containers.configuration" is deprecated. Use top level "containers" fields instead. "configuration.image" should be "image", limits should be set via "instance_type".`
        );
        if (typeof containerAppOptional.configuration !== "object" || Array.isArray(containerAppOptional.configuration)) {
          diagnostics.errors.push(
            `"containers.configuration" should be an object`
          );
        }
        if (containerAppOptional.instance_type && (containerAppOptional.configuration.disk !== void 0 || containerAppOptional.configuration.vcpu !== void 0 || containerAppOptional.configuration.memory_mib !== void 0)) {
          diagnostics.errors.push(
            `Cannot set custom limits via "containers.configuration" and use preset "instance_type" limits at the same time.`
          );
        }
      }
      validateOptionalProperty(
        diagnostics,
        field,
        "image_build_context",
        containerAppOptional.image_build_context,
        "string"
      );
      let resolvedImage = containerAppOptional.image ?? containerAppOptional.configuration?.image;
      let resolvedBuildContextPath = void 0;
      try {
        if (isDockerfile(resolvedImage, configPath)) {
          const baseDir = configPath ? path5__namespace.default.dirname(configPath) : process.cwd();
          resolvedImage = path5__namespace.default.resolve(baseDir, resolvedImage);
          resolvedBuildContextPath = containerAppOptional.image_build_context ? path5__namespace.default.resolve(baseDir, containerAppOptional.image_build_context) : path5__namespace.default.dirname(resolvedImage);
        }
      } catch (err) {
        if (err instanceof Error && err.message) {
          diagnostics.errors.push(err.message);
        } else {
          throw err;
        }
      }
      containerAppOptional.image = resolvedImage;
      containerAppOptional.image_build_context = resolvedBuildContextPath;
      if (containerAppOptional.rollout_step_percentage !== void 0) {
        const rolloutStep = containerAppOptional.rollout_step_percentage;
        if (typeof rolloutStep === "number") {
          const allowedSingleValues = [5, 10, 20, 25, 50, 100];
          if (!allowedSingleValues.includes(rolloutStep)) {
            diagnostics.errors.push(
              `"containers.rollout_step_percentage" must be one of [5, 10, 20, 25, 50, 100], but got ${rolloutStep}`
            );
          }
        } else if (Array.isArray(rolloutStep)) {
          const nonNumber = [];
          const outOfRange = [];
          let index = 0;
          let ascending = true;
          for (const step of rolloutStep) {
            if (typeof step !== "number") {
              nonNumber.push(step);
            } else {
              if (step < 10 || step > 100) {
                outOfRange.push(step);
              }
              if (ascending && index > 0 && step < rolloutStep[index - 1]) {
                diagnostics.errors.push(
                  `"containers.rollout_step_percentage" array elements must be in ascending order, but got "${rolloutStep}"`
                );
                ascending = false;
              }
              if (index === rolloutStep.length - 1 && step !== 100) {
                diagnostics.errors.push(
                  `The final step in "containers.rollout_step_percentage" must be 100, but got "${step}"`
                );
              }
              index++;
            }
          }
          if (nonNumber.length) {
            diagnostics.errors.push(
              `"containers.rollout_step_percentage" array elements must be numbers, but got "${nonNumber.join(", ")}"`
            );
          }
          if (outOfRange.length) {
            diagnostics.errors.push(
              `"containers.rollout_step_percentage" array elements must be between 10 and 100, but got "${outOfRange.join(", ")}"`
            );
          }
        } else {
          diagnostics.errors.push(
            `"containers.rollout_step_percentage" must be a number or array of numbers, but got "${rolloutStep}"`
          );
        }
      }
      validateOptionalProperty(
        diagnostics,
        field,
        "rollout_kind",
        containerAppOptional.rollout_kind,
        "string",
        ["full_auto", "full_manual", "none"]
      );
      if (!isOptionalProperty(
        containerAppOptional,
        "rollout_active_grace_period",
        "number"
      ) || containerAppOptional.rollout_active_grace_period < 0) {
        diagnostics.errors.push(
          `"containers.rollout_active_grace_period" field should be a positive number but got "${containerAppOptional.rollout_active_grace_period}"`
        );
      }
      validateOptionalProperty(
        diagnostics,
        field,
        "max_instances",
        containerAppOptional.max_instances,
        "number"
      );
      if (containerAppOptional.max_instances !== void 0 && containerAppOptional.max_instances < 0) {
        diagnostics.errors.push(
          `"containers.max_instances" field should be a positive number, but got ${containerAppOptional.max_instances}`
        );
      }
      if (containerAppOptional.rollout_step_percentage !== void 0 && containerAppOptional.max_instances !== void 0 && Array.isArray(containerAppOptional.rollout_step_percentage)) {
        const rolloutStepsCount = containerAppOptional.rollout_step_percentage.length;
        if (rolloutStepsCount > containerAppOptional.max_instances) {
          diagnostics.errors.push(
            `"containers.rollout_step_percentage" cannot have more steps (${rolloutStepsCount}) than "max_instances" (${containerAppOptional.max_instances})`
          );
        }
      }
      validateOptionalProperty(
        diagnostics,
        field,
        "image_vars",
        containerAppOptional.image_vars,
        "object"
      );
      validateOptionalProperty(
        diagnostics,
        field,
        "scheduling_policy",
        containerAppOptional.scheduling_policy,
        "string",
        ["regional", "moon", "default"]
      );
      if ("instances" in containerAppOptional) {
        diagnostics.warnings.push(
          `"containers.instances" is deprecated. Use "containers.max_instances" instead.`
        );
      }
      if ("durable_objects" in containerAppOptional) {
        diagnostics.warnings.push(
          `"containers.durable_objects" is deprecated. Use the "class_name" field instead.`
        );
      }
      if ("unsafe" in containerAppOptional) {
        if (containerAppOptional.unsafe && typeof containerAppOptional.unsafe !== "object" || Array.isArray(containerAppOptional.unsafe)) {
          diagnostics.errors.push(
            `The field "containers.unsafe" should be an object but got ${JSON.stringify(
              typeof containerAppOptional.unsafe
            )}.`
          );
        }
      }
      validateAdditionalProperties(
        diagnostics,
        field,
        Object.keys(containerAppOptional),
        [
          "name",
          "instances",
          "max_instances",
          "image",
          "image_build_context",
          "image_vars",
          "class_name",
          "scheduling_policy",
          "instance_type",
          "configuration",
          "constraints",
          "affinities",
          "rollout_step_percentage",
          "rollout_kind",
          "durable_objects",
          "rollout_active_grace_period",
          "unsafe"
        ]
      );
      if ("configuration" in containerAppOptional) {
        validateAdditionalProperties(
          diagnostics,
          `${field}.configuration`,
          Object.keys(containerAppOptional.configuration),
          ["image", "secrets", "labels", "disk", "vcpu", "memory_mib"]
        );
      }
      if (typeof containerAppOptional.instance_type === "string") {
        validateOptionalProperty(
          diagnostics,
          field,
          "instance_type",
          containerAppOptional.instance_type,
          "string",
          ALLOWED_INSTANCE_TYPES
        );
        if (containerAppOptional.instance_type === "dev") {
          diagnostics.warnings.push(
            `The "dev" instance_type has been renamed to "lite" and will be removed in a subsequent version. Please update your configuration to use "lite" instead.`
          );
        }
        if (containerAppOptional.instance_type === "standard") {
          diagnostics.warnings.push(
            `The "standard" instance_type has been renamed to "standard-1" and will be removed in a subsequent version. Please update your configuration to use "standard-1" instead.`
          );
        }
      } else if (validateOptionalProperty(
        diagnostics,
        field,
        "instance_type",
        containerAppOptional.instance_type,
        "object"
      ) && containerAppOptional.instance_type) {
        const instanceTypeProperties = ["vcpu", "memory_mib", "disk_mb"];
        instanceTypeProperties.forEach((key) => {
          if (!isOptionalProperty(
            containerAppOptional.instance_type,
            key,
            "number"
          )) {
            diagnostics.errors.push(
              `"containers.instance_type.${key}", when present, should be a number.`
            );
          }
        });
        validateAdditionalProperties(
          diagnostics,
          `${field}.instance_type`,
          Object.keys(containerAppOptional.instance_type),
          instanceTypeProperties
        );
      }
    }
    if (diagnostics.errors.length > 0) {
      return false;
    }
    return true;
  };
}
function validateWorkerNamespaceOutbound(diagnostics, field, value) {
  if (typeof value !== "object" || value === null) {
    diagnostics.errors.push(
      `"${field}" should be an object, but got ${JSON.stringify(value)}`
    );
    return false;
  }
  let isValid2 = true;
  isValid2 = isValid2 && validateRequiredProperty(
    diagnostics,
    field,
    "service",
    value.service,
    "string"
  );
  isValid2 = isValid2 && validateOptionalProperty(
    diagnostics,
    field,
    "environment",
    value.environment,
    "string"
  );
  isValid2 = isValid2 && validateOptionalTypedArray(
    diagnostics,
    `${field}.parameters`,
    value.parameters,
    "string"
  );
  return isValid2;
}
function validateQueues(envName) {
  return (diagnostics, field, value, config) => {
    const fieldPath = config === void 0 ? `${field}` : `env.${envName}.${field}`;
    if (typeof value !== "object" || Array.isArray(value) || value === null) {
      diagnostics.errors.push(
        `The field "${fieldPath}" should be an object but got ${JSON.stringify(
          value
        )}.`
      );
      return false;
    }
    let isValid2 = true;
    if (!validateAdditionalProperties(
      diagnostics,
      fieldPath,
      Object.keys(value),
      ["consumers", "producers"]
    )) {
      isValid2 = false;
    }
    if (hasProperty(value, "consumers")) {
      const consumers = value.consumers;
      if (!Array.isArray(consumers)) {
        diagnostics.errors.push(
          `The field "${fieldPath}.consumers" should be an array but got ${JSON.stringify(
            consumers
          )}.`
        );
        isValid2 = false;
      }
      for (let i6 = 0; i6 < consumers.length; i6++) {
        const consumer = consumers[i6];
        const consumerPath = `${fieldPath}.consumers[${i6}]`;
        if (!validateConsumer(diagnostics, consumerPath, consumer, config)) {
          isValid2 = false;
        }
      }
    }
    if (hasProperty(value, "producers")) {
      if (!validateBindingArray(envName, validateQueueBinding)(
        diagnostics,
        `${field}.producers`,
        value.producers,
        config
      )) {
        isValid2 = false;
      }
    }
    return isValid2;
  };
}
function normalizeAndValidateLimits(diagnostics, topLevelEnv, rawEnv) {
  if (rawEnv.limits) {
    validateRequiredProperty(
      diagnostics,
      "limits",
      "cpu_ms",
      rawEnv.limits.cpu_ms,
      "number"
    );
  }
  return inheritable(
    diagnostics,
    topLevelEnv,
    rawEnv,
    "limits",
    () => true,
    void 0
  );
}
function warnIfDurableObjectsHaveNoMigrations(diagnostics, durableObjects, migrations, configPath) {
  if (Array.isArray(durableObjects.bindings) && durableObjects.bindings.length > 0) {
    const exportedDurableObjects = (durableObjects.bindings || []).filter(
      (binding) => !binding.script_name
    );
    if (exportedDurableObjects.length > 0 && migrations.length === 0) {
      if (!exportedDurableObjects.some(
        (exportedDurableObject) => typeof exportedDurableObject.class_name !== "string"
      )) {
        const durableObjectClassnames = exportedDurableObjects.map(
          (durable) => durable.class_name
        );
        diagnostics.warnings.push(dedent`
				In your ${configFileName(configPath)} file, you have configured \`durable_objects\` exported by this Worker (${durableObjectClassnames.join(", ")}), but no \`migrations\` for them. This may not work as expected until you add a \`migrations\` section to your ${configFileName(configPath)} file. Add the following configuration:

				\`\`\`
				${formatConfigSnippet(
          {
            migrations: [{ tag: "v1", new_classes: durableObjectClassnames }]
          },
          configPath
        )}
				\`\`\`

				Refer to https://developers.cloudflare.com/durable-objects/reference/durable-objects-migrations/ for more details.`);
      }
    }
  }
}
function isRemoteValid(targetObject, fieldPath, diagnostics) {
  if (!isOptionalProperty(targetObject, "remote", "boolean")) {
    diagnostics.errors.push(
      `"${fieldPath}" should, optionally, have a boolean "remote" field but got ${JSON.stringify(
        targetObject
      )}.`
    );
    return false;
  }
  return true;
}
function validatePagesConfig(config, envNames, projectName) {
  if (!config.pages_build_output_dir) {
    throw new FatalError(`Attempting to validate Pages configuration file, but "pages_build_output_dir" field was not found.
		"pages_build_output_dir" is required for Pages projects.`);
  }
  const diagnostics = new Diagnostics(
    `Running configuration file validation for Pages:`
  );
  validateMainField(config, diagnostics);
  validateProjectName(projectName, diagnostics);
  validatePagesEnvironmentNames(envNames, diagnostics);
  validateUnsupportedFields(config, diagnostics);
  validateDurableObjectBinding2(config, diagnostics);
  return diagnostics;
}
function validateMainField(config, diagnostics) {
  if (config.main !== void 0) {
    diagnostics.errors.push(
      `Configuration file cannot contain both both "main" and "pages_build_output_dir" configuration keys.
Please use "main" if you are deploying a Worker, or "pages_build_output_dir" if you are deploying a Pages project.`
    );
  }
}
function validateProjectName(name2, diagnostics) {
  if (name2 === void 0 || name2.trim() === "") {
    diagnostics.errors.push(
      `Missing top-level field "name" in configuration file.
Pages requires the name of your project to be configured at the top-level of your Wrangler configuration file. This is because, in Pages, environments target the same project.`
    );
  }
}
function validatePagesEnvironmentNames(envNames, diagnostics) {
  if (!envNames?.length) {
    return;
  }
  const unsupportedPagesEnvNames = envNames.filter(
    (name2) => name2 !== "preview" && name2 !== "production"
  );
  if (unsupportedPagesEnvNames.length > 0) {
    diagnostics.errors.push(
      `Configuration file contains the following environment names that are not supported by Pages projects:
${unsupportedPagesEnvNames.map((name2) => `"${name2}"`).join()}.
The supported named-environments for Pages are "preview" and "production".`
    );
  }
}
function validateUnsupportedFields(config, diagnostics) {
  const unsupportedFields = new Set(Object.keys(config));
  for (const field of supportedPagesConfigFields) {
    if (field === "queues" && config.queues?.consumers?.length) {
      continue;
    }
    unsupportedFields.delete(field);
  }
  for (const field of unsupportedFields) {
    if (config[field] === void 0 || JSON.stringify(config[field]) === JSON.stringify(defaultWranglerConfig[field])) {
      unsupportedFields.delete(field);
    }
  }
  if (unsupportedFields.size > 0) {
    const fields = Array.from(unsupportedFields.keys());
    fields.forEach((field) => {
      if (field === "queues" && config.queues?.consumers?.length) {
        diagnostics.errors.push(
          `Configuration file for Pages projects does not support "queues.consumers"`
        );
      } else {
        diagnostics.errors.push(
          `Configuration file for Pages projects does not support "${field}"`
        );
      }
    });
  }
}
function validateDurableObjectBinding2(config, diagnostics) {
  if (config.durable_objects.bindings.length > 0) {
    const invalidBindings = config.durable_objects.bindings.filter(
      (binding) => !isRequiredProperty(binding, "script_name", "string")
    );
    if (invalidBindings.length > 0) {
      diagnostics.errors.push(
        `Durable Objects bindings should specify a "script_name".
Pages requires Durable Object bindings to specify the name of the Worker where the Durable Object is defined.`
      );
    }
  }
}
var defaultWranglerConfig, TomlError2, DATE_TIME_RE, TomlDate, INT_REGEX, FLOAT_REGEX, LEADING_ZERO, ESCAPE_REGEX, ESC_MAP, KEY_PART_RE, BARE_KEY, dist_default, CharacterCodes, ParseOptions, ScanError, SyntaxKind, parse3, ParseErrorCode, UserError, FatalError, CommandLineArgsError, JsonFriendlyFatalError, MissingConfigError, ParseError, APIError, units, UNSUPPORTED_BOMS, typeMappings, matchType, toPath, toPath2, findUpStop, esm_default, parseRawConfigFile; exports.experimental_readRawConfig = void 0; exports.experimental_patchConfig = void 0; var getJSONPath, PatchConfigError, ApplicationRollout, BadRequestWithCodeError, CreateApplicationRolloutRequest, DeploymentNotFoundError, ImageRegistryAlreadyExistsError, ImageRegistryIsPublic, ImageRegistryNotAllowedError, ImageRegistryNotFoundError, ImageRegistryProtocolAlreadyExists, ImageRegistryProtocolIsReferencedError, ImageRegistryProtocolNotFound, ProvisionerConfiguration, RolloutStep, SecretNameAlreadyExists, SecretNotFound, SSHPublicKeyNotFoundError, UpdateApplicationRolloutRequest, UserError2, isDockerfile, MAX_WORKFLOW_NAME_LENGTH, ALLOWED_STRING_ID_PATTERN, ALLOWED_WORKFLOW_INSTANCE_ID_REGEX, ALLOWED_WORKFLOW_NAME_REGEX, Diagnostics, appendEnvName, isString, isValidName, isValidDateTimeStringFormat, isStringArray, isOneOf, all, isMutuallyExclusiveWith, isBoolean, validateRequiredProperty, validateAtLeastOnePropertyRequired, validateOptionalProperty, validateTypedArray, validateOptionalTypedArray, isRequiredProperty, isOptionalProperty, hasProperty, validateAdditionalProperties, getBindingNames, isBindingList, isNamespaceList, isRecord, validateUniqueNameProperty, bucketFormatMessage, friendlyBindingNames, ENGLISH, ALLOWED_INSTANCE_TYPES, isRoute, isRouteArray, validateTailConsumers, validateStreamingTailConsumers, validateAndNormalizeRules, validateTriggers, validateRules, validateRule, validateDefines, validateVars, validateBindingsProperty, validateUnsafeSettings, validateDurableObjectBinding, workflowNameFormatMessage, validateWorkflowBinding, validateCflogfwdrObject, validateCflogfwdrBinding, validateAssetsConfig, validateNamedSimpleBinding, validateAIBinding, validateVersionMetadataBinding, validateUnsafeBinding, validateBindingArray, validateCloudchamberConfig, validateKVBinding, validateSendEmailBinding, validateQueueBinding, validateR2Binding, validateD1Binding, validateVectorizeBinding, validateHyperdriveBinding, validateVpcServiceBinding, validateBindingsHaveUniqueNames, validateServiceBinding, validateAnalyticsEngineBinding, validateWorkerNamespaceBinding, validateMTlsCertificateBinding, validateConsumer, validateCompatibilityDate, validatePipelineBinding, validateSecretsStoreSecretBinding, validateHelloWorldBinding, validateWorkerLoaderBinding, validateRateLimitBinding, validateMigrations, validateObservability, validatePythonModules, supportedPagesConfigFields;
var init_dist = __esm({
  "../workers-utils/dist/index.mjs"() {
    init_import_meta_url();
    init_chunk_4DJ4YNBY();
    init_chunk_4DJ4YNBY();
    defaultWranglerConfig = {
      /* COMPUTED_FIELDS */
      configPath: void 0,
      userConfigPath: void 0,
      topLevelName: void 0,
      definedEnvironments: void 0,
      targetEnvironment: void 0,
      /*====================================================*/
      /*      Fields supported by both Workers & Pages      */
      /*====================================================*/
      /* TOP-LEVEL ONLY FIELDS */
      pages_build_output_dir: void 0,
      send_metrics: void 0,
      dev: {
        ip: process.platform === "win32" ? "127.0.0.1" : "localhost",
        port: void 0,
        // the default of 8787 is set at runtime
        inspector_port: void 0,
        // the default of 9229 is set at runtime
        local_protocol: "http",
        upstream_protocol: "http",
        host: void 0,
        // Note this one is also workers only
        enable_containers: true,
        container_engine: void 0
      },
      /** INHERITABLE ENVIRONMENT FIELDS **/
      name: void 0,
      compatibility_date: void 0,
      compatibility_flags: [],
      limits: void 0,
      placement: void 0,
      /** NON-INHERITABLE ENVIRONMENT FIELDS **/
      vars: {},
      durable_objects: { bindings: [] },
      kv_namespaces: [],
      queues: {
        producers: [],
        consumers: []
        // WORKERS SUPPORT ONLY!!
      },
      r2_buckets: [],
      d1_databases: [],
      vectorize: [],
      hyperdrive: [],
      workflows: [],
      secrets_store_secrets: [],
      services: [],
      analytics_engine_datasets: [],
      ai: void 0,
      images: void 0,
      media: void 0,
      version_metadata: void 0,
      unsafe_hello_world: [],
      ratelimits: [],
      worker_loaders: [],
      /*====================================================*/
      /*           Fields supported by Workers only         */
      /*====================================================*/
      /* TOP-LEVEL ONLY FIELDS */
      legacy_env: true,
      site: void 0,
      wasm_modules: void 0,
      text_blobs: void 0,
      data_blobs: void 0,
      keep_vars: void 0,
      alias: void 0,
      /** INHERITABLE ENVIRONMENT FIELDS **/
      account_id: void 0,
      main: void 0,
      find_additional_modules: void 0,
      preserve_file_names: void 0,
      base_dir: void 0,
      workers_dev: void 0,
      preview_urls: void 0,
      route: void 0,
      routes: void 0,
      tsconfig: void 0,
      jsx_factory: "React.createElement",
      jsx_fragment: "React.Fragment",
      migrations: [],
      triggers: {
        crons: void 0
      },
      rules: [],
      build: { command: void 0, watch_dir: "./src", cwd: void 0 },
      no_bundle: void 0,
      minify: void 0,
      keep_names: void 0,
      dispatch_namespaces: [],
      first_party_worker: void 0,
      logfwdr: { bindings: [] },
      logpush: void 0,
      upload_source_maps: void 0,
      assets: void 0,
      observability: { enabled: true },
      /** The default here is undefined so that we can delegate to the CLOUDFLARE_COMPLIANCE_REGION environment variable. */
      compliance_region: void 0,
      python_modules: { exclude: ["**/*.pyc"] },
      /** NON-INHERITABLE ENVIRONMENT FIELDS **/
      define: {},
      cloudchamber: {},
      containers: void 0,
      send_email: [],
      browser: void 0,
      unsafe: {},
      mtls_certificates: [],
      tail_consumers: void 0,
      streaming_tail_consumers: void 0,
      pipelines: [],
      vpc_services: []
    };
    __name(getLineColFromPtr, "getLineColFromPtr");
    __name2(getLineColFromPtr, "getLineColFromPtr");
    __name(makeCodeBlock, "makeCodeBlock");
    __name2(makeCodeBlock, "makeCodeBlock");
    TomlError2 = class extends Error {
      static {
        __name(this, "TomlError");
      }
      static {
        __name2(this, "TomlError");
      }
      line;
      column;
      codeblock;
      constructor(message, options) {
        const [line, column] = getLineColFromPtr(options.toml, options.ptr);
        const codeblock = makeCodeBlock(options.toml, line, column);
        super(`Invalid TOML document: ${message}

${codeblock}`, options);
        this.line = line;
        this.column = column;
        this.codeblock = codeblock;
      }
    };
    __name(isEscaped, "isEscaped");
    __name2(isEscaped, "isEscaped");
    __name(indexOfNewline, "indexOfNewline");
    __name2(indexOfNewline, "indexOfNewline");
    __name(skipComment, "skipComment");
    __name2(skipComment, "skipComment");
    __name(skipVoid, "skipVoid");
    __name2(skipVoid, "skipVoid");
    __name(skipUntil, "skipUntil");
    __name2(skipUntil, "skipUntil");
    __name(getStringEnd, "getStringEnd");
    __name2(getStringEnd, "getStringEnd");
    DATE_TIME_RE = /^(\d{4}-\d{2}-\d{2})?[T ]?(?:(\d{2}):\d{2}:\d{2}(?:\.\d+)?)?(Z|[-+]\d{2}:\d{2})?$/i;
    TomlDate = class _TomlDate extends Date {
      static {
        __name(this, "_TomlDate");
      }
      static {
        __name2(this, "TomlDate");
      }
      #hasDate = false;
      #hasTime = false;
      #offset = null;
      constructor(date) {
        let hasDate = true;
        let hasTime = true;
        let offset = "Z";
        if (typeof date === "string") {
          let match3 = date.match(DATE_TIME_RE);
          if (match3) {
            if (!match3[1]) {
              hasDate = false;
              date = `0000-01-01T${date}`;
            }
            hasTime = !!match3[2];
            hasTime && date[10] === " " && (date = date.replace(" ", "T"));
            if (match3[2] && +match3[2] > 23) {
              date = "";
            } else {
              offset = match3[3] || null;
              date = date.toUpperCase();
              if (!offset && hasTime)
                date += "Z";
            }
          } else {
            date = "";
          }
        }
        super(date);
        if (!isNaN(this.getTime())) {
          this.#hasDate = hasDate;
          this.#hasTime = hasTime;
          this.#offset = offset;
        }
      }
      isDateTime() {
        return this.#hasDate && this.#hasTime;
      }
      isLocal() {
        return !this.#hasDate || !this.#hasTime || !this.#offset;
      }
      isDate() {
        return this.#hasDate && !this.#hasTime;
      }
      isTime() {
        return this.#hasTime && !this.#hasDate;
      }
      isValid() {
        return this.#hasDate || this.#hasTime;
      }
      toISOString() {
        let iso = super.toISOString();
        if (this.isDate())
          return iso.slice(0, 10);
        if (this.isTime())
          return iso.slice(11, 23);
        if (this.#offset === null)
          return iso.slice(0, -1);
        if (this.#offset === "Z")
          return iso;
        let offset = +this.#offset.slice(1, 3) * 60 + +this.#offset.slice(4, 6);
        offset = this.#offset[0] === "-" ? offset : -offset;
        let offsetDate = new Date(this.getTime() - offset * 6e4);
        return offsetDate.toISOString().slice(0, -1) + this.#offset;
      }
      static wrapAsOffsetDateTime(jsDate, offset = "Z") {
        let date = new _TomlDate(jsDate);
        date.#offset = offset;
        return date;
      }
      static wrapAsLocalDateTime(jsDate) {
        let date = new _TomlDate(jsDate);
        date.#offset = null;
        return date;
      }
      static wrapAsLocalDate(jsDate) {
        let date = new _TomlDate(jsDate);
        date.#hasTime = false;
        date.#offset = null;
        return date;
      }
      static wrapAsLocalTime(jsDate) {
        let date = new _TomlDate(jsDate);
        date.#hasDate = false;
        date.#offset = null;
        return date;
      }
    };
    INT_REGEX = /^((0x[0-9a-fA-F](_?[0-9a-fA-F])*)|(([+-]|0[ob])?\d(_?\d)*))$/;
    FLOAT_REGEX = /^[+-]?\d(_?\d)*(\.\d(_?\d)*)?([eE][+-]?\d(_?\d)*)?$/;
    LEADING_ZERO = /^[+-]?0[0-9_]/;
    ESCAPE_REGEX = /^[0-9a-f]{4,8}$/i;
    ESC_MAP = {
      b: "\b",
      t: "	",
      n: "\n",
      f: "\f",
      r: "\r",
      '"': '"',
      "\\": "\\"
    };
    __name(parseString, "parseString");
    __name2(parseString, "parseString");
    __name(parseValue, "parseValue");
    __name2(parseValue, "parseValue");
    __name(sliceAndTrimEndOf, "sliceAndTrimEndOf");
    __name2(sliceAndTrimEndOf, "sliceAndTrimEndOf");
    __name(extractValue, "extractValue");
    __name2(extractValue, "extractValue");
    KEY_PART_RE = /^[a-zA-Z0-9-_]+[ \t]*$/;
    __name(parseKey, "parseKey");
    __name2(parseKey, "parseKey");
    __name(parseInlineTable, "parseInlineTable");
    __name2(parseInlineTable, "parseInlineTable");
    __name(parseArray, "parseArray");
    __name2(parseArray, "parseArray");
    __name(peekTable, "peekTable");
    __name2(peekTable, "peekTable");
    __name(parse, "parse");
    __name2(parse, "parse");
    BARE_KEY = /^[a-z0-9-_]+$/i;
    __name(extendedTypeOf, "extendedTypeOf");
    __name2(extendedTypeOf, "extendedTypeOf");
    __name(isArrayOfTables, "isArrayOfTables");
    __name2(isArrayOfTables, "isArrayOfTables");
    __name(formatString, "formatString");
    __name2(formatString, "formatString");
    __name(stringifyValue, "stringifyValue");
    __name2(stringifyValue, "stringifyValue");
    __name(stringifyInlineTable, "stringifyInlineTable");
    __name2(stringifyInlineTable, "stringifyInlineTable");
    __name(stringifyArray, "stringifyArray");
    __name2(stringifyArray, "stringifyArray");
    __name(stringifyArrayTable, "stringifyArrayTable");
    __name2(stringifyArrayTable, "stringifyArrayTable");
    __name(stringifyTable, "stringifyTable");
    __name2(stringifyTable, "stringifyTable");
    __name(stringify, "stringify");
    __name2(stringify, "stringify");
    dist_default = { parse, stringify, TomlDate, TomlError: TomlError2 };
    __name(createScanner, "createScanner");
    __name2(createScanner, "createScanner");
    __name(isWhiteSpace, "isWhiteSpace");
    __name2(isWhiteSpace, "isWhiteSpace");
    __name(isLineBreak, "isLineBreak");
    __name2(isLineBreak, "isLineBreak");
    __name(isDigit2, "isDigit");
    __name2(isDigit2, "isDigit");
    (function(CharacterCodes2) {
      CharacterCodes2[CharacterCodes2["lineFeed"] = 10] = "lineFeed";
      CharacterCodes2[CharacterCodes2["carriageReturn"] = 13] = "carriageReturn";
      CharacterCodes2[CharacterCodes2["space"] = 32] = "space";
      CharacterCodes2[CharacterCodes2["_0"] = 48] = "_0";
      CharacterCodes2[CharacterCodes2["_1"] = 49] = "_1";
      CharacterCodes2[CharacterCodes2["_2"] = 50] = "_2";
      CharacterCodes2[CharacterCodes2["_3"] = 51] = "_3";
      CharacterCodes2[CharacterCodes2["_4"] = 52] = "_4";
      CharacterCodes2[CharacterCodes2["_5"] = 53] = "_5";
      CharacterCodes2[CharacterCodes2["_6"] = 54] = "_6";
      CharacterCodes2[CharacterCodes2["_7"] = 55] = "_7";
      CharacterCodes2[CharacterCodes2["_8"] = 56] = "_8";
      CharacterCodes2[CharacterCodes2["_9"] = 57] = "_9";
      CharacterCodes2[CharacterCodes2["a"] = 97] = "a";
      CharacterCodes2[CharacterCodes2["b"] = 98] = "b";
      CharacterCodes2[CharacterCodes2["c"] = 99] = "c";
      CharacterCodes2[CharacterCodes2["d"] = 100] = "d";
      CharacterCodes2[CharacterCodes2["e"] = 101] = "e";
      CharacterCodes2[CharacterCodes2["f"] = 102] = "f";
      CharacterCodes2[CharacterCodes2["g"] = 103] = "g";
      CharacterCodes2[CharacterCodes2["h"] = 104] = "h";
      CharacterCodes2[CharacterCodes2["i"] = 105] = "i";
      CharacterCodes2[CharacterCodes2["j"] = 106] = "j";
      CharacterCodes2[CharacterCodes2["k"] = 107] = "k";
      CharacterCodes2[CharacterCodes2["l"] = 108] = "l";
      CharacterCodes2[CharacterCodes2["m"] = 109] = "m";
      CharacterCodes2[CharacterCodes2["n"] = 110] = "n";
      CharacterCodes2[CharacterCodes2["o"] = 111] = "o";
      CharacterCodes2[CharacterCodes2["p"] = 112] = "p";
      CharacterCodes2[CharacterCodes2["q"] = 113] = "q";
      CharacterCodes2[CharacterCodes2["r"] = 114] = "r";
      CharacterCodes2[CharacterCodes2["s"] = 115] = "s";
      CharacterCodes2[CharacterCodes2["t"] = 116] = "t";
      CharacterCodes2[CharacterCodes2["u"] = 117] = "u";
      CharacterCodes2[CharacterCodes2["v"] = 118] = "v";
      CharacterCodes2[CharacterCodes2["w"] = 119] = "w";
      CharacterCodes2[CharacterCodes2["x"] = 120] = "x";
      CharacterCodes2[CharacterCodes2["y"] = 121] = "y";
      CharacterCodes2[CharacterCodes2["z"] = 122] = "z";
      CharacterCodes2[CharacterCodes2["A"] = 65] = "A";
      CharacterCodes2[CharacterCodes2["B"] = 66] = "B";
      CharacterCodes2[CharacterCodes2["C"] = 67] = "C";
      CharacterCodes2[CharacterCodes2["D"] = 68] = "D";
      CharacterCodes2[CharacterCodes2["E"] = 69] = "E";
      CharacterCodes2[CharacterCodes2["F"] = 70] = "F";
      CharacterCodes2[CharacterCodes2["G"] = 71] = "G";
      CharacterCodes2[CharacterCodes2["H"] = 72] = "H";
      CharacterCodes2[CharacterCodes2["I"] = 73] = "I";
      CharacterCodes2[CharacterCodes2["J"] = 74] = "J";
      CharacterCodes2[CharacterCodes2["K"] = 75] = "K";
      CharacterCodes2[CharacterCodes2["L"] = 76] = "L";
      CharacterCodes2[CharacterCodes2["M"] = 77] = "M";
      CharacterCodes2[CharacterCodes2["N"] = 78] = "N";
      CharacterCodes2[CharacterCodes2["O"] = 79] = "O";
      CharacterCodes2[CharacterCodes2["P"] = 80] = "P";
      CharacterCodes2[CharacterCodes2["Q"] = 81] = "Q";
      CharacterCodes2[CharacterCodes2["R"] = 82] = "R";
      CharacterCodes2[CharacterCodes2["S"] = 83] = "S";
      CharacterCodes2[CharacterCodes2["T"] = 84] = "T";
      CharacterCodes2[CharacterCodes2["U"] = 85] = "U";
      CharacterCodes2[CharacterCodes2["V"] = 86] = "V";
      CharacterCodes2[CharacterCodes2["W"] = 87] = "W";
      CharacterCodes2[CharacterCodes2["X"] = 88] = "X";
      CharacterCodes2[CharacterCodes2["Y"] = 89] = "Y";
      CharacterCodes2[CharacterCodes2["Z"] = 90] = "Z";
      CharacterCodes2[CharacterCodes2["asterisk"] = 42] = "asterisk";
      CharacterCodes2[CharacterCodes2["backslash"] = 92] = "backslash";
      CharacterCodes2[CharacterCodes2["closeBrace"] = 125] = "closeBrace";
      CharacterCodes2[CharacterCodes2["closeBracket"] = 93] = "closeBracket";
      CharacterCodes2[CharacterCodes2["colon"] = 58] = "colon";
      CharacterCodes2[CharacterCodes2["comma"] = 44] = "comma";
      CharacterCodes2[CharacterCodes2["dot"] = 46] = "dot";
      CharacterCodes2[CharacterCodes2["doubleQuote"] = 34] = "doubleQuote";
      CharacterCodes2[CharacterCodes2["minus"] = 45] = "minus";
      CharacterCodes2[CharacterCodes2["openBrace"] = 123] = "openBrace";
      CharacterCodes2[CharacterCodes2["openBracket"] = 91] = "openBracket";
      CharacterCodes2[CharacterCodes2["plus"] = 43] = "plus";
      CharacterCodes2[CharacterCodes2["slash"] = 47] = "slash";
      CharacterCodes2[CharacterCodes2["formFeed"] = 12] = "formFeed";
      CharacterCodes2[CharacterCodes2["tab"] = 9] = "tab";
    })(CharacterCodes || (CharacterCodes = {}));
    __name(format, "format");
    __name2(format, "format");
    __name(repeat, "repeat");
    __name2(repeat, "repeat");
    __name(computeIndentLevel, "computeIndentLevel");
    __name2(computeIndentLevel, "computeIndentLevel");
    __name(getEOL, "getEOL");
    __name2(getEOL, "getEOL");
    __name(isEOL, "isEOL");
    __name2(isEOL, "isEOL");
    (function(ParseOptions2) {
      ParseOptions2.DEFAULT = {
        allowTrailingComma: false
      };
    })(ParseOptions || (ParseOptions = {}));
    __name(parse2, "parse2");
    __name2(parse2, "parse");
    __name(parseTree, "parseTree");
    __name2(parseTree, "parseTree");
    __name(findNodeAtLocation, "findNodeAtLocation");
    __name2(findNodeAtLocation, "findNodeAtLocation");
    __name(visit, "visit");
    __name2(visit, "visit");
    __name(getNodeType, "getNodeType");
    __name2(getNodeType, "getNodeType");
    __name(setProperty, "setProperty");
    __name2(setProperty, "setProperty");
    __name(withFormatting, "withFormatting");
    __name2(withFormatting, "withFormatting");
    __name(applyEdit, "applyEdit");
    __name2(applyEdit, "applyEdit");
    (function(ScanError2) {
      ScanError2[ScanError2["None"] = 0] = "None";
      ScanError2[ScanError2["UnexpectedEndOfComment"] = 1] = "UnexpectedEndOfComment";
      ScanError2[ScanError2["UnexpectedEndOfString"] = 2] = "UnexpectedEndOfString";
      ScanError2[ScanError2["UnexpectedEndOfNumber"] = 3] = "UnexpectedEndOfNumber";
      ScanError2[ScanError2["InvalidUnicode"] = 4] = "InvalidUnicode";
      ScanError2[ScanError2["InvalidEscapeCharacter"] = 5] = "InvalidEscapeCharacter";
      ScanError2[ScanError2["InvalidCharacter"] = 6] = "InvalidCharacter";
    })(ScanError || (ScanError = {}));
    (function(SyntaxKind2) {
      SyntaxKind2[SyntaxKind2["OpenBraceToken"] = 1] = "OpenBraceToken";
      SyntaxKind2[SyntaxKind2["CloseBraceToken"] = 2] = "CloseBraceToken";
      SyntaxKind2[SyntaxKind2["OpenBracketToken"] = 3] = "OpenBracketToken";
      SyntaxKind2[SyntaxKind2["CloseBracketToken"] = 4] = "CloseBracketToken";
      SyntaxKind2[SyntaxKind2["CommaToken"] = 5] = "CommaToken";
      SyntaxKind2[SyntaxKind2["ColonToken"] = 6] = "ColonToken";
      SyntaxKind2[SyntaxKind2["NullKeyword"] = 7] = "NullKeyword";
      SyntaxKind2[SyntaxKind2["TrueKeyword"] = 8] = "TrueKeyword";
      SyntaxKind2[SyntaxKind2["FalseKeyword"] = 9] = "FalseKeyword";
      SyntaxKind2[SyntaxKind2["StringLiteral"] = 10] = "StringLiteral";
      SyntaxKind2[SyntaxKind2["NumericLiteral"] = 11] = "NumericLiteral";
      SyntaxKind2[SyntaxKind2["LineCommentTrivia"] = 12] = "LineCommentTrivia";
      SyntaxKind2[SyntaxKind2["BlockCommentTrivia"] = 13] = "BlockCommentTrivia";
      SyntaxKind2[SyntaxKind2["LineBreakTrivia"] = 14] = "LineBreakTrivia";
      SyntaxKind2[SyntaxKind2["Trivia"] = 15] = "Trivia";
      SyntaxKind2[SyntaxKind2["Unknown"] = 16] = "Unknown";
      SyntaxKind2[SyntaxKind2["EOF"] = 17] = "EOF";
    })(SyntaxKind || (SyntaxKind = {}));
    parse3 = parse2;
    (function(ParseErrorCode2) {
      ParseErrorCode2[ParseErrorCode2["InvalidSymbol"] = 1] = "InvalidSymbol";
      ParseErrorCode2[ParseErrorCode2["InvalidNumberFormat"] = 2] = "InvalidNumberFormat";
      ParseErrorCode2[ParseErrorCode2["PropertyNameExpected"] = 3] = "PropertyNameExpected";
      ParseErrorCode2[ParseErrorCode2["ValueExpected"] = 4] = "ValueExpected";
      ParseErrorCode2[ParseErrorCode2["ColonExpected"] = 5] = "ColonExpected";
      ParseErrorCode2[ParseErrorCode2["CommaExpected"] = 6] = "CommaExpected";
      ParseErrorCode2[ParseErrorCode2["CloseBraceExpected"] = 7] = "CloseBraceExpected";
      ParseErrorCode2[ParseErrorCode2["CloseBracketExpected"] = 8] = "CloseBracketExpected";
      ParseErrorCode2[ParseErrorCode2["EndOfFileExpected"] = 9] = "EndOfFileExpected";
      ParseErrorCode2[ParseErrorCode2["InvalidCommentToken"] = 10] = "InvalidCommentToken";
      ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfComment"] = 11] = "UnexpectedEndOfComment";
      ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfString"] = 12] = "UnexpectedEndOfString";
      ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfNumber"] = 13] = "UnexpectedEndOfNumber";
      ParseErrorCode2[ParseErrorCode2["InvalidUnicode"] = 14] = "InvalidUnicode";
      ParseErrorCode2[ParseErrorCode2["InvalidEscapeCharacter"] = 15] = "InvalidEscapeCharacter";
      ParseErrorCode2[ParseErrorCode2["InvalidCharacter"] = 16] = "InvalidCharacter";
    })(ParseErrorCode || (ParseErrorCode = {}));
    __name(printParseErrorCode, "printParseErrorCode");
    __name2(printParseErrorCode, "printParseErrorCode");
    __name(format2, "format2");
    __name2(format2, "format");
    __name(modify, "modify");
    __name2(modify, "modify");
    __name(applyEdits, "applyEdits");
    __name2(applyEdits, "applyEdits");
    UserError = class extends Error {
      static {
        __name(this, "UserError");
      }
      static {
        __name2(this, "UserError");
      }
      telemetryMessage;
      constructor(message, options) {
        super(message, options);
        Object.setPrototypeOf(this, new.target.prototype);
        this.telemetryMessage = options?.telemetryMessage === true ? message : options?.telemetryMessage;
      }
    };
    (class extends UserError {
      static {
        __name(this, "DeprecationError");
      }
      static {
        __name2(this, "DeprecationError");
      }
      constructor(message, options) {
        super(`Deprecation:
${message}`, options);
      }
    });
    FatalError = class extends UserError {
      static {
        __name(this, "FatalError");
      }
      constructor(message, code, options) {
        super(message, options);
        this.code = code;
      }
      static {
        __name2(this, "FatalError");
      }
    };
    CommandLineArgsError = class extends UserError {
      static {
        __name(this, "CommandLineArgsError");
      }
      static {
        __name2(this, "CommandLineArgsError");
      }
    };
    JsonFriendlyFatalError = class extends FatalError {
      static {
        __name(this, "JsonFriendlyFatalError");
      }
      constructor(message, code, options) {
        super(message, code, options);
        this.code = code;
      }
      static {
        __name2(this, "JsonFriendlyFatalError");
      }
    };
    MissingConfigError = class extends Error {
      static {
        __name(this, "MissingConfigError");
      }
      static {
        __name2(this, "MissingConfigError");
      }
      telemetryMessage;
      constructor(key) {
        super(`Missing config value for ${key}`);
        this.telemetryMessage = `Missing config value for ${key}`;
      }
    };
    __name(createFatalError, "createFatalError");
    __name2(createFatalError, "createFatalError");
    ParseError = class extends UserError {
      static {
        __name(this, "ParseError");
      }
      static {
        __name2(this, "ParseError");
      }
      text;
      notes;
      location;
      kind;
      constructor({ text, notes, location, kind: kind2, telemetryMessage }) {
        super(text, { telemetryMessage });
        this.name = this.constructor.name;
        this.text = text;
        this.notes = notes ?? [];
        this.location = location;
        this.kind = kind2 ?? "error";
      }
    };
    APIError = class extends ParseError {
      static {
        __name(this, "APIError");
      }
      static {
        __name2(this, "APIError");
      }
      #status;
      code;
      accountTag;
      constructor({ status: status2, ...rest }) {
        super(rest);
        this.name = this.constructor.name;
        this.#status = status2;
      }
      isGatewayError() {
        if (this.#status !== void 0) {
          return [524].includes(this.#status);
        }
        return false;
      }
      isRetryable() {
        return String(this.#status).startsWith("5");
      }
      // Allow `APIError`s to be marked as handled.
      #reportable = true;
      get reportable() {
        return this.#reportable;
      }
      preventReport() {
        this.#reportable = false;
      }
    };
    __name(parseTOML, "parseTOML");
    __name2(parseTOML, "parseTOML");
    __name(parsePackageJSON, "parsePackageJSON");
    __name2(parsePackageJSON, "parsePackageJSON");
    __name(parseJSON, "parseJSON");
    __name2(parseJSON, "parseJSON");
    __name(parseJSONC, "parseJSONC");
    __name2(parseJSONC, "parseJSONC");
    __name(readFileSyncToBuffer, "readFileSyncToBuffer");
    __name2(readFileSyncToBuffer, "readFileSyncToBuffer");
    __name(readFileSync, "readFileSync");
    __name2(readFileSync, "readFileSync");
    __name(indexLocation, "indexLocation");
    __name2(indexLocation, "indexLocation");
    __name(searchLocation, "searchLocation");
    __name2(searchLocation, "searchLocation");
    units = {
      nanoseconds: 1e-9,
      nanosecond: 1e-9,
      microseconds: 1e-6,
      microsecond: 1e-6,
      milliseconds: 1e-3,
      millisecond: 1e-3,
      seconds: 1,
      second: 1,
      minutes: 60,
      minute: 60,
      hours: 3600,
      hour: 3600,
      days: 86400,
      day: 86400,
      weeks: 604800,
      week: 604800,
      month: 18144e3,
      year: 220752e3,
      nsecs: 1e-9,
      nsec: 1e-9,
      usecs: 1e-6,
      usec: 1e-6,
      msecs: 1e-3,
      msec: 1e-3,
      secs: 1,
      sec: 1,
      mins: 60,
      min: 60,
      ns: 1e-9,
      us: 1e-6,
      ms: 1e-3,
      mo: 18144e3,
      yr: 220752e3,
      s: 1,
      m: 60,
      h: 3600,
      d: 86400,
      w: 604800,
      y: 220752e3
    };
    __name(parseHumanDuration, "parseHumanDuration");
    __name2(parseHumanDuration, "parseHumanDuration");
    __name(parseNonHyphenedUuid, "parseNonHyphenedUuid");
    __name2(parseNonHyphenedUuid, "parseNonHyphenedUuid");
    __name(parseByteSize, "parseByteSize");
    __name2(parseByteSize, "parseByteSize");
    UNSUPPORTED_BOMS = [
      {
        buffer: Buffer.from([0, 0, 254, 255]),
        encoding: "UTF-32 BE"
      },
      {
        buffer: Buffer.from([255, 254, 0, 0]),
        encoding: "UTF-32 LE"
      },
      {
        buffer: Buffer.from([254, 255]),
        encoding: "UTF-16 BE"
      },
      {
        buffer: Buffer.from([255, 254]),
        encoding: "UTF-16 LE"
      }
    ];
    __name(removeBOMAndValidate, "removeBOMAndValidate");
    __name2(removeBOMAndValidate, "removeBOMAndValidate");
    typeMappings = {
      directory: "isDirectory",
      file: "isFile"
    };
    __name(checkType, "checkType");
    __name2(checkType, "checkType");
    matchType = /* @__PURE__ */ __name2((type, stat9) => type === void 0 || stat9[typeMappings[type]](), "matchType");
    toPath = /* @__PURE__ */ __name2((urlOrPath) => urlOrPath instanceof URL ? Url.fileURLToPath(urlOrPath) : urlOrPath, "toPath");
    __name(locatePathSync, "locatePathSync");
    __name2(locatePathSync, "locatePathSync");
    toPath2 = /* @__PURE__ */ __name2((urlOrPath) => urlOrPath instanceof URL ? Url.fileURLToPath(urlOrPath) : urlOrPath, "toPath");
    findUpStop = Symbol("findUpStop");
    __name(findUpMultipleSync, "findUpMultipleSync");
    __name2(findUpMultipleSync, "findUpMultipleSync");
    __name(findUpSync, "findUpSync");
    __name2(findUpSync, "findUpSync");
    __name(dedent, "dedent");
    __name2(dedent, "dedent");
    esm_default = dedent;
    __name(resolveWranglerConfigPath, "resolveWranglerConfigPath");
    __name2(resolveWranglerConfigPath, "resolveWranglerConfigPath");
    __name(findWranglerConfig, "findWranglerConfig");
    __name2(findWranglerConfig, "findWranglerConfig");
    __name(findRedirectedWranglerConfig, "findRedirectedWranglerConfig");
    __name2(findRedirectedWranglerConfig, "findRedirectedWranglerConfig");
    __name(isRedirectedRawConfig, "isRedirectedRawConfig");
    __name2(isRedirectedRawConfig, "isRedirectedRawConfig");
    __name(configFormat, "configFormat");
    __name2(configFormat, "configFormat");
    __name(configFileName, "configFileName");
    __name2(configFileName, "configFileName");
    __name(formatConfigSnippet, "formatConfigSnippet");
    __name2(formatConfigSnippet, "formatConfigSnippet");
    parseRawConfigFile = /* @__PURE__ */ __name2((configPath) => {
      if (configPath.endsWith(".toml")) {
        return parseTOML(readFileSync(configPath), configPath);
      }
      if (configPath.endsWith(".json") || configPath.endsWith(".jsonc")) {
        return parseJSONC(readFileSync(configPath), configPath);
      }
      return {};
    }, "parseRawConfigFile");
    exports.experimental_readRawConfig = /* @__PURE__ */ __name2((args, options = {}) => {
      const { configPath, userConfigPath, deployConfigPath, redirected } = resolveWranglerConfigPath(args, options);
      const rawConfig = parseRawConfigFile(configPath ?? "");
      return {
        rawConfig,
        configPath,
        userConfigPath,
        deployConfigPath,
        redirected
      };
    }, "experimental_readRawConfig");
    exports.experimental_patchConfig = /* @__PURE__ */ __name2((configPath, patch, isArrayInsertion = true) => {
      let configString = readFileSync(configPath);
      if (configPath.endsWith("toml")) {
        if (configString.includes("#")) {
          throw new PatchConfigError(
            "cannot patch .toml config if comments are present"
          );
        } else {
          configString = JSON.stringify(parseTOML(configString));
        }
      }
      const patchPaths = [];
      getJSONPath(patch, patchPaths, isArrayInsertion);
      for (const patchPath of patchPaths) {
        const value = patchPath.pop();
        const edit = modify(configString, patchPath, value, {
          isArrayInsertion
        });
        configString = applyEdits(configString, edit);
      }
      const formatEdit = format2(configString, void 0, {});
      configString = applyEdits(configString, formatEdit);
      if (configPath.endsWith(".toml")) {
        configString = dist_default.stringify(parseJSONC(configString));
      }
      fs25.writeFileSync(configPath, configString);
      return configString;
    }, "experimental_patchConfig");
    getJSONPath = /* @__PURE__ */ __name2((obj, allPaths, isArrayInsertion, prevPath = []) => {
      for (const [k7, v8] of Object.entries(obj)) {
        const currentPath = [...prevPath, k7];
        if (Array.isArray(v8)) {
          v8.forEach((x7, i6) => {
            if (isArrayInsertion) {
              allPaths.push([...currentPath, -1, x7]);
            } else if (typeof x7 === "object" && x7 !== null) {
              getJSONPath(x7, allPaths, isArrayInsertion, [...currentPath, i6]);
            } else {
              allPaths.push([...currentPath, i6, x7]);
            }
          });
        } else if (typeof v8 === "object" && v8 !== null) {
          getJSONPath(v8, allPaths, isArrayInsertion, currentPath);
        } else {
          allPaths.push([...currentPath, v8]);
        }
      }
    }, "getJSONPath");
    PatchConfigError = class extends Error {
      static {
        __name(this, "PatchConfigError");
      }
      static {
        __name2(this, "PatchConfigError");
      }
    };
    ((ApplicationRollout22) => {
      ((kind2) => {
        kind2["FULL_AUTO"] = "full_auto";
        kind2["FULL_MANUAL"] = "full_manual";
        kind2["DURABLE_OBJECTS_AUTO"] = "durable_objects_auto";
      })(ApplicationRollout22.kind || (ApplicationRollout22.kind = {}));
      ((strategy2) => {
        strategy2["ROLLING"] = "rolling";
      })(ApplicationRollout22.strategy || (ApplicationRollout22.strategy = {}));
      ((status2) => {
        status2["PENDING"] = "pending";
        status2["PROGRESSING"] = "progressing";
        status2["COMPLETED"] = "completed";
        status2["REVERTED"] = "reverted";
        status2["REPLACED"] = "replaced";
      })(ApplicationRollout22.status || (ApplicationRollout22.status = {}));
    })(ApplicationRollout || (ApplicationRollout = {}));
    ((BadRequestWithCodeError22) => {
      ((error2) => {
        error2["VALIDATE_INPUT"] = "VALIDATE_INPUT";
      })(BadRequestWithCodeError22.error || (BadRequestWithCodeError22.error = {}));
    })(BadRequestWithCodeError || (BadRequestWithCodeError = {}));
    ((CreateApplicationRolloutRequest22) => {
      ((strategy2) => {
        strategy2["ROLLING"] = "rolling";
      })(CreateApplicationRolloutRequest22.strategy || (CreateApplicationRolloutRequest22.strategy = {}));
      ((step_percentage2) => {
        step_percentage2[step_percentage2["_5"] = 5] = "_5";
        step_percentage2[step_percentage2["_10"] = 10] = "_10";
        step_percentage2[step_percentage2["_20"] = 20] = "_20";
        step_percentage2[step_percentage2["_25"] = 25] = "_25";
        step_percentage2[step_percentage2["_50"] = 50] = "_50";
        step_percentage2[step_percentage2["_100"] = 100] = "_100";
      })(CreateApplicationRolloutRequest22.step_percentage || (CreateApplicationRolloutRequest22.step_percentage = {}));
      ((kind2) => {
        kind2["FULL_AUTO"] = "full_auto";
        kind2["FULL_MANUAL"] = "full_manual";
      })(CreateApplicationRolloutRequest22.kind || (CreateApplicationRolloutRequest22.kind = {}));
    })(CreateApplicationRolloutRequest || (CreateApplicationRolloutRequest = {}));
    ((DeploymentNotFoundError22) => {
      ((error2) => {
        error2["DEPLOYMENT_NOT_FOUND"] = "DEPLOYMENT_NOT_FOUND";
      })(DeploymentNotFoundError22.error || (DeploymentNotFoundError22.error = {}));
    })(DeploymentNotFoundError || (DeploymentNotFoundError = {}));
    ((ImageRegistryAlreadyExistsError22) => {
      ((error2) => {
        error2["IMAGE_REGISTRY_ALREADY_EXISTS"] = "IMAGE_REGISTRY_ALREADY_EXISTS";
      })(ImageRegistryAlreadyExistsError22.error || (ImageRegistryAlreadyExistsError22.error = {}));
    })(ImageRegistryAlreadyExistsError || (ImageRegistryAlreadyExistsError = {}));
    ((ImageRegistryIsPublic22) => {
      ((error2) => {
        error2["IMAGE_REGISTRY_IS_PUBLIC"] = "IMAGE_REGISTRY_IS_PUBLIC";
      })(ImageRegistryIsPublic22.error || (ImageRegistryIsPublic22.error = {}));
    })(ImageRegistryIsPublic || (ImageRegistryIsPublic = {}));
    ((ImageRegistryNotAllowedError22) => {
      ((error2) => {
        error2["IMAGE_REGISTRY_NOT_ALLOWED"] = "IMAGE_REGISTRY_NOT_ALLOWED";
      })(ImageRegistryNotAllowedError22.error || (ImageRegistryNotAllowedError22.error = {}));
    })(ImageRegistryNotAllowedError || (ImageRegistryNotAllowedError = {}));
    ((ImageRegistryNotFoundError22) => {
      ((error2) => {
        error2["IMAGE_REGISTRY_NOT_FOUND"] = "IMAGE_REGISTRY_NOT_FOUND";
      })(ImageRegistryNotFoundError22.error || (ImageRegistryNotFoundError22.error = {}));
    })(ImageRegistryNotFoundError || (ImageRegistryNotFoundError = {}));
    ((ImageRegistryProtocolAlreadyExists22) => {
      ((error2) => {
        error2["IMAGE_REGISTRY_PROTOCOL_ALREADY_EXISTS"] = "IMAGE_REGISTRY_PROTOCOL_ALREADY_EXISTS";
      })(ImageRegistryProtocolAlreadyExists22.error || (ImageRegistryProtocolAlreadyExists22.error = {}));
    })(ImageRegistryProtocolAlreadyExists || (ImageRegistryProtocolAlreadyExists = {}));
    ((ImageRegistryProtocolIsReferencedError22) => {
      ((error2) => {
        error2["IMAGE_REGISTRY_PROTO_IS_REFERENCED"] = "IMAGE_REGISTRY_PROTO_IS_REFERENCED";
      })(ImageRegistryProtocolIsReferencedError22.error || (ImageRegistryProtocolIsReferencedError22.error = {}));
    })(ImageRegistryProtocolIsReferencedError || (ImageRegistryProtocolIsReferencedError = {}));
    ((ImageRegistryProtocolNotFound22) => {
      ((error2) => {
        error2["IMAGE_REGISTRY_PROTOCOL_NOT_FOUND"] = "IMAGE_REGISTRY_PROTOCOL_NOT_FOUND";
      })(ImageRegistryProtocolNotFound22.error || (ImageRegistryProtocolNotFound22.error = {}));
    })(ImageRegistryProtocolNotFound || (ImageRegistryProtocolNotFound = {}));
    ((ProvisionerConfiguration22) => {
      ((type2) => {
        type2["NONE"] = "none";
        type2["CLOUDINIT"] = "cloudinit";
      })(ProvisionerConfiguration22.type || (ProvisionerConfiguration22.type = {}));
    })(ProvisionerConfiguration || (ProvisionerConfiguration = {}));
    ((RolloutStep22) => {
      ((status2) => {
        status2["PENDING"] = "pending";
        status2["PROGRESSING"] = "progressing";
        status2["REVERTING"] = "reverting";
        status2["COMPLETED"] = "completed";
        status2["REVERTED"] = "reverted";
      })(RolloutStep22.status || (RolloutStep22.status = {}));
    })(RolloutStep || (RolloutStep = {}));
    ((SecretNameAlreadyExists22) => {
      ((error2) => {
        error2["SECRET_NAME_ALREADY_EXISTS"] = "SECRET_NAME_ALREADY_EXISTS";
      })(SecretNameAlreadyExists22.error || (SecretNameAlreadyExists22.error = {}));
    })(SecretNameAlreadyExists || (SecretNameAlreadyExists = {}));
    ((SecretNotFound22) => {
      ((error2) => {
        error2["SECRET_NAME_NOT_FOUND"] = "SECRET_NAME_NOT_FOUND";
      })(SecretNotFound22.error || (SecretNotFound22.error = {}));
    })(SecretNotFound || (SecretNotFound = {}));
    ((SSHPublicKeyNotFoundError22) => {
      ((error2) => {
        error2["SSH_PUBLIC_KEY_NOT_FOUND"] = "SSH_PUBLIC_KEY_NOT_FOUND";
      })(SSHPublicKeyNotFoundError22.error || (SSHPublicKeyNotFoundError22.error = {}));
    })(SSHPublicKeyNotFoundError || (SSHPublicKeyNotFoundError = {}));
    ((UpdateApplicationRolloutRequest22) => {
      ((action2) => {
        action2["NEXT"] = "next";
        action2["PREVIOUS"] = "previous";
        action2["REVERT"] = "revert";
      })(UpdateApplicationRolloutRequest22.action || (UpdateApplicationRolloutRequest22.action = {}));
    })(UpdateApplicationRolloutRequest || (UpdateApplicationRolloutRequest = {}));
    UserError2 = class extends Error {
      static {
        __name(this, "UserError2");
      }
      static {
        __name2(this, "UserError");
      }
      telemetryMessage;
      constructor(message, options) {
        super(message, options);
        Object.setPrototypeOf(this, new.target.prototype);
        this.telemetryMessage = options?.telemetryMessage === true ? message : options?.telemetryMessage;
      }
    };
    __name(isDir, "isDir");
    __name2(isDir, "isDir");
    isDockerfile = /* @__PURE__ */ __name2((image, configPath) => {
      const baseDir = configPath ? path5__namespace.default.dirname(configPath) : process.cwd();
      const maybeDockerfile = path5__namespace.default.resolve(baseDir, image);
      if (fs25.existsSync(maybeDockerfile)) {
        if (isDir(maybeDockerfile)) {
          throw new UserError2(
            `${image} is a directory, you should specify a path to the Dockerfile`
          );
        }
        return true;
      }
      const errorPrefix = `The image "${image}" does not appear to be a valid path to a Dockerfile, or a valid image registry path:
`;
      try {
        new URL(`https://${image}`);
      } catch (e8) {
        if (e8 instanceof Error) {
          throw new UserError2(errorPrefix + e8.message);
        }
        throw e8;
      }
      const imageParts = image.split("/");
      if (!imageParts[imageParts.length - 1]?.includes(":")) {
        throw new UserError2(
          errorPrefix + `If this is an image registry path, it needs to include at least a tag ':' (e.g: docker.io/httpd:1)`
        );
      }
      if (image.includes("://")) {
        throw new UserError2(
          errorPrefix + `Image reference should not include the protocol part (e.g: docker.io/httpd:1, not https://docker.io/httpd:1)`
        );
      }
      return false;
    }, "isDockerfile");
    MAX_WORKFLOW_NAME_LENGTH = 64;
    ALLOWED_STRING_ID_PATTERN = "^[a-zA-Z0-9_][a-zA-Z0-9-_]*$";
    ALLOWED_WORKFLOW_INSTANCE_ID_REGEX = new RegExp(
      ALLOWED_STRING_ID_PATTERN
    );
    ALLOWED_WORKFLOW_NAME_REGEX = ALLOWED_WORKFLOW_INSTANCE_ID_REGEX;
    __name(isValidWorkflowName, "isValidWorkflowName");
    __name2(isValidWorkflowName, "isValidWorkflowName");
    Diagnostics = class {
      static {
        __name(this, "Diagnostics");
      }
      /**
       * Create a new Diagnostics object.
       * @param description A general description of this collection of messages.
       */
      constructor(description) {
        this.description = description;
      }
      static {
        __name2(this, "Diagnostics");
      }
      errors = [];
      warnings = [];
      children = [];
      /**
       * Merge the given `diagnostics` into this as a child.
       */
      addChild(diagnostics) {
        if (diagnostics.hasErrors() || diagnostics.hasWarnings()) {
          this.children.push(diagnostics);
        }
      }
      /** Does this or any of its children have errors. */
      hasErrors() {
        if (this.errors.length > 0) {
          return true;
        } else {
          return this.children.some((child) => child.hasErrors());
        }
      }
      /** Render the errors of this and all its children. */
      renderErrors() {
        return this.render("errors");
      }
      /** Does this or any of its children have warnings. */
      hasWarnings() {
        if (this.warnings.length > 0) {
          return true;
        } else {
          return this.children.some((child) => child.hasWarnings());
        }
      }
      /** Render the warnings of this and all its children. */
      renderWarnings() {
        return this.render("warnings");
      }
      render(field) {
        const hasMethod = field === "errors" ? "hasErrors" : "hasWarnings";
        return indentText(
          `${this.description}
` + // Output all the fields (errors or warnings) at this level
          this[field].map((message) => `- ${indentText(message)}`).join("\n") + // Output all the child diagnostics at the next level
          this.children.map(
            (child) => child[hasMethod]() ? "\n- " + child.render(field) : ""
          ).filter((output) => output !== "").join("\n")
        );
      }
    };
    __name(indentText, "indentText");
    __name2(indentText, "indentText");
    __name(deprecated, "deprecated");
    __name2(deprecated, "deprecated");
    __name(experimental, "experimental");
    __name2(experimental, "experimental");
    __name(inheritable, "inheritable");
    __name2(inheritable, "inheritable");
    __name(inheritableInWranglerEnvironments, "inheritableInWranglerEnvironments");
    __name2(inheritableInWranglerEnvironments, "inheritableInWranglerEnvironments");
    appendEnvName = /* @__PURE__ */ __name2((envName) => (fieldValue) => fieldValue ? `${fieldValue}-${envName}` : void 0, "appendEnvName");
    __name(notAllowedInNamedServiceEnvironment, "notAllowedInNamedServiceEnvironment");
    __name2(notAllowedInNamedServiceEnvironment, "notAllowedInNamedServiceEnvironment");
    __name(notInheritable, "notInheritable");
    __name2(notInheritable, "notInheritable");
    __name(unwindPropertyPath, "unwindPropertyPath");
    __name2(unwindPropertyPath, "unwindPropertyPath");
    isString = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (value !== void 0 && typeof value !== "string") {
        diagnostics.errors.push(
          `Expected "${field}" to be of type string but got ${JSON.stringify(
            value
          )}.`
        );
        return false;
      }
      return true;
    }, "isString");
    isValidName = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value === "string" && /^$|^[a-z0-9_][a-z0-9-_]*$/.test(value) || value === void 0) {
        return true;
      } else {
        diagnostics.errors.push(
          `Expected "${field}" to be of type string, alphanumeric and lowercase with dashes only but got ${JSON.stringify(
            value
          )}.`
        );
        return false;
      }
    }, "isValidName");
    isValidDateTimeStringFormat = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      let isValid2 = true;
      if (value.includes("\u2013") || // en-dash
      value.includes("\u2014")) {
        diagnostics.errors.push(
          `"${field}" field should use ISO-8601 accepted hyphens (-) rather than en-dashes (\u2013) or em-dashes (\u2014).`
        );
        isValid2 = false;
      }
      const data = new Date(value.replaceAll(/–|—/g, "-"));
      if (isNaN(data.getTime())) {
        diagnostics.errors.push(
          `"${field}" field should be a valid ISO-8601 date (YYYY-MM-DD), but got ${JSON.stringify(value)}.`
        );
        isValid2 = false;
      }
      return isValid2;
    }, "isValidDateTimeStringFormat");
    isStringArray = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (value !== void 0 && (!Array.isArray(value) || value.some((item) => typeof item !== "string"))) {
        diagnostics.errors.push(
          `Expected "${field}" to be of type string array but got ${JSON.stringify(
            value
          )}.`
        );
        return false;
      }
      return true;
    }, "isStringArray");
    isOneOf = /* @__PURE__ */ __name2((...choices) => (diagnostics, field, value) => {
      if (value !== void 0 && !choices.some((choice) => value === choice)) {
        diagnostics.errors.push(
          `Expected "${field}" field to be one of ${JSON.stringify(
            choices
          )} but got ${JSON.stringify(value)}.`
        );
        return false;
      }
      return true;
    }, "isOneOf");
    all = /* @__PURE__ */ __name2((...validations) => {
      return (diagnostics, field, value, config) => {
        let passedValidations = true;
        for (const validate3 of validations) {
          if (!validate3(diagnostics, field, value, config)) {
            passedValidations = false;
          }
        }
        return passedValidations;
      };
    }, "all");
    isMutuallyExclusiveWith = /* @__PURE__ */ __name2((container, ...fields) => {
      return (diagnostics, field, value) => {
        if (value === void 0) {
          return true;
        }
        for (const exclusiveWith of fields) {
          if (container[exclusiveWith] !== void 0) {
            diagnostics.errors.push(
              `Expected exactly one of the following fields ${JSON.stringify([
                field,
                ...fields
              ])}.`
            );
            return false;
          }
        }
        return true;
      };
    }, "isMutuallyExclusiveWith");
    isBoolean = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (value !== void 0 && typeof value !== "boolean") {
        diagnostics.errors.push(
          `Expected "${field}" to be of type boolean but got ${JSON.stringify(
            value
          )}.`
        );
        return false;
      }
      return true;
    }, "isBoolean");
    validateRequiredProperty = /* @__PURE__ */ __name2((diagnostics, container, key, value, type, choices) => {
      if (container) {
        container += ".";
      }
      if (value === void 0) {
        diagnostics.errors.push(`"${container}${key}" is a required field.`);
        return false;
      } else if (typeof value !== type) {
        diagnostics.errors.push(
          `Expected "${container}${key}" to be of type ${type} but got ${JSON.stringify(
            value
          )}.`
        );
        return false;
      } else if (choices) {
        if (!isOneOf(...choices)(diagnostics, `${container}${key}`, value, void 0)) {
          return false;
        }
      }
      return true;
    }, "validateRequiredProperty");
    validateAtLeastOnePropertyRequired = /* @__PURE__ */ __name2((diagnostics, container, properties) => {
      const containerPath = container ? `${container}.` : "";
      if (properties.every((property) => property.value === void 0)) {
        diagnostics.errors.push(
          `${properties.map(({ key }) => `"${containerPath}${key}"`).join(" or ")} is required.`
        );
        return false;
      }
      const errors = [];
      for (const prop of properties) {
        if (typeof prop.value === prop.type) {
          return true;
        }
        errors.push(
          `Expected "${containerPath}${prop.key}" to be of type ${prop.type} but got ${JSON.stringify(
            prop.value
          )}.`
        );
      }
      diagnostics.errors.push(...errors);
      return false;
    }, "validateAtLeastOnePropertyRequired");
    validateOptionalProperty = /* @__PURE__ */ __name2((diagnostics, container, key, value, type, choices) => {
      if (value !== void 0) {
        return validateRequiredProperty(
          diagnostics,
          container,
          key,
          value,
          type,
          choices
        );
      }
      return true;
    }, "validateOptionalProperty");
    validateTypedArray = /* @__PURE__ */ __name2((diagnostics, container, value, type) => {
      let isValid2 = true;
      if (!Array.isArray(value)) {
        diagnostics.errors.push(
          `Expected "${container}" to be an array of ${type}s but got ${JSON.stringify(
            value
          )}`
        );
        isValid2 = false;
      } else {
        for (let i6 = 0; i6 < value.length; i6++) {
          isValid2 = validateRequiredProperty(
            diagnostics,
            container,
            `[${i6}]`,
            value[i6],
            type
          ) && isValid2;
        }
      }
      return isValid2;
    }, "validateTypedArray");
    validateOptionalTypedArray = /* @__PURE__ */ __name2((diagnostics, container, value, type) => {
      if (value !== void 0) {
        return validateTypedArray(diagnostics, container, value, type);
      }
      return true;
    }, "validateOptionalTypedArray");
    isRequiredProperty = /* @__PURE__ */ __name2((target, property, type, choices) => hasProperty(target, property) && typeof target[property] === type && (choices === void 0 || choices.includes(target[property])), "isRequiredProperty");
    isOptionalProperty = /* @__PURE__ */ __name2((target, property, type) => !hasProperty(target, property) || typeof target[property] === type, "isOptionalProperty");
    hasProperty = /* @__PURE__ */ __name2((target, property) => property in target, "hasProperty");
    validateAdditionalProperties = /* @__PURE__ */ __name2((diagnostics, fieldPath, restProps, knownProps) => {
      const restPropSet = new Set(restProps);
      for (const knownProp of knownProps) {
        restPropSet.delete(knownProp);
      }
      if (restPropSet.size > 0) {
        const fields = Array.from(restPropSet.keys()).map((field) => `"${field}"`);
        diagnostics.warnings.push(
          `Unexpected fields found in ${fieldPath} field: ${fields}`
        );
        return false;
      }
      return true;
    }, "validateAdditionalProperties");
    getBindingNames = /* @__PURE__ */ __name2((value) => {
      if (typeof value !== "object" || value === null) {
        return [];
      }
      if (isBindingList(value)) {
        return value.bindings.map(({ name: name2 }) => name2);
      } else if (isNamespaceList(value)) {
        return value.map(({ binding }) => binding);
      } else if (isRecord(value)) {
        if (value["binding"] !== void 0) {
          return [value["binding"]];
        }
        return Object.keys(value).filter((k7) => value[k7] !== void 0);
      } else {
        return [];
      }
    }, "getBindingNames");
    isBindingList = /* @__PURE__ */ __name2((value) => isRecord(value) && "bindings" in value && Array.isArray(value.bindings) && value.bindings.every(
      (binding) => isRecord(binding) && "name" in binding && typeof binding.name === "string"
    ), "isBindingList");
    isNamespaceList = /* @__PURE__ */ __name2((value) => Array.isArray(value) && value.every(
      (entry) => isRecord(entry) && "binding" in entry && typeof entry.binding === "string"
    ), "isNamespaceList");
    isRecord = /* @__PURE__ */ __name2((value) => typeof value === "object" && value !== null && !Array.isArray(value), "isRecord");
    validateUniqueNameProperty = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (Array.isArray(value)) {
        const nameCount = /* @__PURE__ */ new Map();
        Object.entries(value).forEach(([_5, entry]) => {
          nameCount.set(entry.name, (nameCount.get(entry.name) ?? 0) + 1);
        });
        const duplicates = Array.from(nameCount.entries()).filter(([_5, count]) => count > 1).map(([name2]) => name2);
        if (duplicates.length > 0) {
          const list = duplicates.join('", "');
          diagnostics.errors.push(
            `"${field}" bindings must have unique "name" values; duplicate(s) found: "${list}"`
          );
          return false;
        }
      }
      return true;
    }, "validateUniqueNameProperty");
    __name(isValidR2BucketName, "isValidR2BucketName");
    __name2(isValidR2BucketName, "isValidR2BucketName");
    bucketFormatMessage = `Bucket names must begin and end with an alphanumeric character, only contain lowercase letters, numbers, and hyphens, and be between 3 and 63 characters long.`;
    friendlyBindingNames = {
      data_blobs: "Data Blob",
      durable_objects: "Durable Object",
      kv_namespaces: "KV Namespace",
      send_email: "Send Email",
      queues: "Queue",
      d1_databases: "D1 Database",
      vectorize: "Vectorize Index",
      hyperdrive: "Hyperdrive Config",
      r2_buckets: "R2 Bucket",
      logfwdr: "logfwdr",
      services: "Worker",
      analytics_engine_datasets: "Analytics Engine Dataset",
      text_blobs: "Text Blob",
      browser: "Browser",
      ai: "AI",
      images: "Images",
      media: "Media",
      version_metadata: "Worker Version Metadata",
      unsafe: "Unsafe Metadata",
      vars: "Environment Variable",
      wasm_modules: "Wasm Module",
      dispatch_namespaces: "Dispatch Namespace",
      mtls_certificates: "mTLS Certificate",
      workflows: "Workflow",
      pipelines: "Pipeline",
      secrets_store_secrets: "Secrets Store Secret",
      ratelimits: "Rate Limit",
      assets: "Assets",
      unsafe_hello_world: "Hello World",
      worker_loaders: "Worker Loader",
      vpc_services: "VPC Service"
    };
    ENGLISH = new Intl.ListFormat("en-US");
    ALLOWED_INSTANCE_TYPES = [
      "lite",
      "basic",
      "standard-1",
      "standard-2",
      "standard-3",
      "standard-4",
      "dev",
      // legacy
      "standard"
      // legacy
    ];
    __name(isPagesConfig, "isPagesConfig");
    __name2(isPagesConfig, "isPagesConfig");
    __name(normalizeAndValidateConfig, "normalizeAndValidateConfig");
    __name2(normalizeAndValidateConfig, "normalizeAndValidateConfig");
    __name(applyPythonConfig, "applyPythonConfig");
    __name2(applyPythonConfig, "applyPythonConfig");
    __name(normalizeAndValidateBuild, "normalizeAndValidateBuild");
    __name2(normalizeAndValidateBuild, "normalizeAndValidateBuild");
    __name(normalizeAndValidateMainField, "normalizeAndValidateMainField");
    __name2(normalizeAndValidateMainField, "normalizeAndValidateMainField");
    __name(normalizeAndValidateBaseDirField, "normalizeAndValidateBaseDirField");
    __name2(normalizeAndValidateBaseDirField, "normalizeAndValidateBaseDirField");
    __name(normalizeAndValidatePagesBuildOutputDir, "normalizeAndValidatePagesBuildOutputDir");
    __name2(normalizeAndValidatePagesBuildOutputDir, "normalizeAndValidatePagesBuildOutputDir");
    __name(normalizeAndValidateDev, "normalizeAndValidateDev");
    __name2(normalizeAndValidateDev, "normalizeAndValidateDev");
    __name(normalizeAndValidateAssets, "normalizeAndValidateAssets");
    __name2(normalizeAndValidateAssets, "normalizeAndValidateAssets");
    __name(normalizeAndValidateSite, "normalizeAndValidateSite");
    __name2(normalizeAndValidateSite, "normalizeAndValidateSite");
    __name(normalizeAndValidateAliases, "normalizeAndValidateAliases");
    __name2(normalizeAndValidateAliases, "normalizeAndValidateAliases");
    __name(normalizeAndValidateModulePaths, "normalizeAndValidateModulePaths");
    __name2(normalizeAndValidateModulePaths, "normalizeAndValidateModulePaths");
    __name(isValidRouteValue, "isValidRouteValue");
    __name2(isValidRouteValue, "isValidRouteValue");
    __name(mutateEmptyStringAccountIDValue, "mutateEmptyStringAccountIDValue");
    __name2(mutateEmptyStringAccountIDValue, "mutateEmptyStringAccountIDValue");
    __name(mutateEmptyStringRouteValue, "mutateEmptyStringRouteValue");
    __name2(mutateEmptyStringRouteValue, "mutateEmptyStringRouteValue");
    isRoute = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (value !== void 0 && !isValidRouteValue(value)) {
        diagnostics.errors.push(
          `Expected "${field}" to be either a string, or an object with shape { pattern, custom_domain, zone_id | zone_name }, but got ${JSON.stringify(
            value
          )}.`
        );
        return false;
      }
      return true;
    }, "isRoute");
    isRouteArray = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (value === void 0) {
        return true;
      }
      if (!Array.isArray(value)) {
        diagnostics.errors.push(
          `Expected "${field}" to be an array but got ${JSON.stringify(value)}.`
        );
        return false;
      }
      const invalidRoutes = [];
      for (const item of value) {
        if (!isValidRouteValue(item)) {
          invalidRoutes.push(item);
        }
      }
      if (invalidRoutes.length > 0) {
        diagnostics.errors.push(
          `Expected "${field}" to be an array of either strings or objects with the shape { pattern, custom_domain, zone_id | zone_name }, but these weren't valid: ${JSON.stringify(
            invalidRoutes,
            null,
            2
          )}.`
        );
      }
      return invalidRoutes.length === 0;
    }, "isRouteArray");
    __name(normalizeAndValidateRoute, "normalizeAndValidateRoute");
    __name2(normalizeAndValidateRoute, "normalizeAndValidateRoute");
    __name(validateRoutes, "validateRoutes");
    __name2(validateRoutes, "validateRoutes");
    __name(normalizeAndValidatePlacement, "normalizeAndValidatePlacement");
    __name2(normalizeAndValidatePlacement, "normalizeAndValidatePlacement");
    __name(validateTailConsumer, "validateTailConsumer");
    __name2(validateTailConsumer, "validateTailConsumer");
    validateTailConsumers = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (!value) {
        return true;
      }
      if (!Array.isArray(value)) {
        diagnostics.errors.push(
          `Expected "${field}" to be an array but got ${JSON.stringify(value)}.`
        );
        return false;
      }
      let isValid2 = true;
      for (let i6 = 0; i6 < value.length; i6++) {
        isValid2 = validateTailConsumer(diagnostics, `${field}[${i6}]`, value[i6]) && isValid2;
      }
      return isValid2;
    }, "validateTailConsumers");
    __name(validateStreamingTailConsumer, "validateStreamingTailConsumer");
    __name2(validateStreamingTailConsumer, "validateStreamingTailConsumer");
    validateStreamingTailConsumers = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (!value) {
        return true;
      }
      if (!Array.isArray(value)) {
        diagnostics.errors.push(
          `Expected "${field}" to be an array but got ${JSON.stringify(value)}.`
        );
        return false;
      }
      let isValid2 = true;
      for (let i6 = 0; i6 < value.length; i6++) {
        isValid2 = validateStreamingTailConsumer(diagnostics, `${field}[${i6}]`, value[i6]) && isValid2;
      }
      return isValid2;
    }, "validateStreamingTailConsumers");
    __name(normalizeAndValidateEnvironment, "normalizeAndValidateEnvironment");
    __name2(normalizeAndValidateEnvironment, "normalizeAndValidateEnvironment");
    __name(validateAndNormalizeTsconfig, "validateAndNormalizeTsconfig");
    __name2(validateAndNormalizeTsconfig, "validateAndNormalizeTsconfig");
    validateAndNormalizeRules = /* @__PURE__ */ __name2((diagnostics, topLevelEnv, rawEnv, envName) => {
      return inheritable(
        diagnostics,
        topLevelEnv,
        rawEnv,
        "rules",
        validateRules(envName),
        []
      );
    }, "validateAndNormalizeRules");
    validateTriggers = /* @__PURE__ */ __name2((diagnostics, triggersFieldName, triggersValue) => {
      if (triggersValue === void 0 || triggersValue === null) {
        return true;
      }
      if (typeof triggersValue !== "object") {
        diagnostics.errors.push(
          `Expected "${triggersFieldName}" to be of type object but got ${JSON.stringify(
            triggersValue
          )}.`
        );
        return false;
      }
      let isValid2 = true;
      if ("crons" in triggersValue && !Array.isArray(triggersValue.crons)) {
        diagnostics.errors.push(
          `Expected "${triggersFieldName}.crons" to be of type array, but got ${JSON.stringify(triggersValue)}.`
        );
        isValid2 = false;
      }
      isValid2 = validateAdditionalProperties(
        diagnostics,
        triggersFieldName,
        Object.keys(triggersValue),
        ["crons"]
      ) && isValid2;
      return isValid2;
    }, "validateTriggers");
    validateRules = /* @__PURE__ */ __name2((envName) => (diagnostics, field, envValue, config) => {
      if (!envValue) {
        return true;
      }
      const fieldPath = config === void 0 ? `${field}` : `env.${envName}.${field}`;
      if (!Array.isArray(envValue)) {
        diagnostics.errors.push(
          `The field "${fieldPath}" should be an array but got ${JSON.stringify(
            envValue
          )}.`
        );
        return false;
      }
      let isValid2 = true;
      for (let i6 = 0; i6 < envValue.length; i6++) {
        isValid2 = validateRule(diagnostics, `${fieldPath}[${i6}]`, envValue[i6], config) && isValid2;
      }
      return isValid2;
    }, "validateRules");
    validateRule = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"${field}" should be an object but got ${JSON.stringify(value)}.`
        );
        return false;
      }
      let isValid2 = true;
      const rule = value;
      if (!isRequiredProperty(rule, "type", "string", [
        "ESModule",
        "CommonJS",
        "CompiledWasm",
        "Text",
        "Data"
      ])) {
        diagnostics.errors.push(
          `bindings should have a string "type" field, which contains one of "ESModule", "CommonJS", "CompiledWasm", "Text", or "Data".`
        );
        isValid2 = false;
      }
      isValid2 = validateTypedArray(diagnostics, `${field}.globs`, rule.globs, "string") && isValid2;
      if (!isOptionalProperty(rule, "fallthrough", "boolean")) {
        diagnostics.errors.push(
          `the field "fallthrough", when present, should be a boolean.`
        );
        isValid2 = false;
      }
      return isValid2;
    }, "validateRule");
    validateDefines = /* @__PURE__ */ __name2((envName) => (diagnostics, field, value, config) => {
      let isValid2 = true;
      const fieldPath = config === void 0 ? `${field}` : `env.${envName}.${field}`;
      if (typeof value === "object" && value !== null) {
        for (const varName in value) {
          if (typeof value[varName] !== "string") {
            diagnostics.errors.push(
              `The field "${fieldPath}.${varName}" should be a string but got ${JSON.stringify(
                value[varName]
              )}.`
            );
            isValid2 = false;
          }
        }
      } else {
        if (value !== void 0) {
          diagnostics.errors.push(
            `The field "${fieldPath}" should be an object but got ${JSON.stringify(
              value
            )}.
`
          );
          isValid2 = false;
        }
      }
      const configDefines = Object.keys(config?.define ?? {});
      if (configDefines.length > 0) {
        if (typeof value === "object" && value !== null) {
          const configEnvDefines = config === void 0 ? [] : Object.keys(value);
          for (const varName of configDefines) {
            if (!(varName in value)) {
              diagnostics.warnings.push(
                `"define.${varName}" exists at the top level, but not on "${fieldPath}".
This is not what you probably want, since "define" configuration is not inherited by environments.
Please add "define.${varName}" to "env.${envName}".`
              );
            }
          }
          for (const varName of configEnvDefines) {
            if (!configDefines.includes(varName)) {
              diagnostics.warnings.push(
                `"${varName}" exists on "env.${envName}", but not on the top level.
This is not what you probably want, since "define" configuration within environments can only override existing top level "define" configuration
Please remove "${fieldPath}.${varName}", or add "define.${varName}".`
              );
            }
          }
        }
      }
      return isValid2;
    }, "validateDefines");
    validateVars = /* @__PURE__ */ __name2((envName) => (diagnostics, field, value, config) => {
      let isValid2 = true;
      const fieldPath = config === void 0 ? `${field}` : `env.${envName}.${field}`;
      const configVars = Object.keys(config?.vars ?? {});
      if (configVars.length > 0) {
        if (typeof value !== "object" || value === null) {
          diagnostics.errors.push(
            `The field "${fieldPath}" should be an object but got ${JSON.stringify(
              value
            )}.
`
          );
          isValid2 = false;
        } else {
          for (const varName of configVars) {
            if (!(varName in value)) {
              diagnostics.warnings.push(
                `"vars.${varName}" exists at the top level, but not on "${fieldPath}".
This is not what you probably want, since "vars" configuration is not inherited by environments.
Please add "vars.${varName}" to "env.${envName}".`
              );
            }
          }
        }
      }
      return isValid2;
    }, "validateVars");
    validateBindingsProperty = /* @__PURE__ */ __name2((envName, validateBinding) => (diagnostics, field, value, config) => {
      let isValid2 = true;
      const fieldPath = config === void 0 ? `${field}` : `env.${envName}.${field}`;
      if (value !== void 0) {
        if (typeof value !== "object" || value === null || Array.isArray(value)) {
          diagnostics.errors.push(
            `The field "${fieldPath}" should be an object but got ${JSON.stringify(
              value
            )}.`
          );
          isValid2 = false;
        } else if (!hasProperty(value, "bindings")) {
          diagnostics.errors.push(
            `The field "${fieldPath}" is missing the required "bindings" property.`
          );
          isValid2 = false;
        } else if (!Array.isArray(value.bindings)) {
          diagnostics.errors.push(
            `The field "${fieldPath}.bindings" should be an array but got ${JSON.stringify(
              value.bindings
            )}.`
          );
          isValid2 = false;
        } else {
          for (let i6 = 0; i6 < value.bindings.length; i6++) {
            const binding = value.bindings[i6];
            const bindingDiagnostics = new Diagnostics(
              `"${fieldPath}.bindings[${i6}]": ${JSON.stringify(binding)}`
            );
            isValid2 = validateBinding(
              bindingDiagnostics,
              `${fieldPath}.bindings[${i6}]`,
              binding,
              config
            ) && isValid2;
            diagnostics.addChild(bindingDiagnostics);
          }
        }
        const configBindingNames = getBindingNames(
          config?.[field]
        );
        if (isValid2 && configBindingNames.length > 0) {
          const envBindingNames = new Set(getBindingNames(value));
          const missingBindings = configBindingNames.filter(
            (name2) => !envBindingNames.has(name2)
          );
          if (missingBindings.length > 0) {
            diagnostics.warnings.push(
              `The following bindings are at the top level, but not on "env.${envName}".
This is not what you probably want, since "${field}" configuration is not inherited by environments.
Please add a binding for each to "${fieldPath}.bindings":
` + missingBindings.map((name2) => `- ${name2}`).join("\n")
            );
          }
        }
      }
      return isValid2;
    }, "validateBindingsProperty");
    validateUnsafeSettings = /* @__PURE__ */ __name2((envName) => (diagnostics, field, value, config) => {
      const fieldPath = config === void 0 ? `${field}` : `env.${envName}.${field}`;
      if (typeof value !== "object" || value === null || Array.isArray(value)) {
        diagnostics.errors.push(
          `The field "${fieldPath}" should be an object but got ${JSON.stringify(
            value
          )}.`
        );
        return false;
      }
      if (hasProperty(value, "bindings") && value.bindings !== void 0) {
        const validateBindingsFn = validateBindingsProperty(
          envName,
          validateUnsafeBinding
        );
        const valid = validateBindingsFn(diagnostics, field, value, config);
        if (!valid) {
          return false;
        }
      }
      if (hasProperty(value, "metadata") && value.metadata !== void 0 && (typeof value.metadata !== "object" || value.metadata === null || Array.isArray(value.metadata))) {
        diagnostics.errors.push(
          `The field "${fieldPath}.metadata" should be an object but got ${JSON.stringify(
            value.metadata
          )}.`
        );
        return false;
      }
      if (hasProperty(value, "capnp") && value.capnp !== void 0) {
        if (typeof value.capnp !== "object" || value.capnp === null || Array.isArray(value.capnp)) {
          diagnostics.errors.push(
            `The field "${fieldPath}.capnp" should be an object but got ${JSON.stringify(
              value.capnp
            )}.`
          );
          return false;
        }
        if (hasProperty(value.capnp, "compiled_schema")) {
          if (hasProperty(value.capnp, "base_path") || hasProperty(value.capnp, "source_schemas")) {
            diagnostics.errors.push(
              `The field "${fieldPath}.capnp" cannot contain both "compiled_schema" and one of "base_path" or "source_schemas".`
            );
            return false;
          }
          if (typeof value.capnp.compiled_schema !== "string") {
            diagnostics.errors.push(
              `The field "${fieldPath}.capnp.compiled_schema", when present, should be a string but got ${JSON.stringify(
                value.capnp.compiled_schema
              )}.`
            );
            return false;
          }
        } else {
          if (!isRequiredProperty(value.capnp, "base_path", "string")) {
            diagnostics.errors.push(
              `The field "${fieldPath}.capnp.base_path", when present, should be a string but got ${JSON.stringify(
                value.capnp.base_path
              )}`
            );
          }
          if (!validateTypedArray(
            diagnostics,
            `${fieldPath}.capnp.source_schemas`,
            value.capnp.source_schemas,
            "string"
          )) {
            return false;
          }
        }
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "bindings",
        "metadata",
        "capnp"
      ]);
      return true;
    }, "validateUnsafeSettings");
    validateDurableObjectBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `Expected "${field}" to be an object but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "name", "string")) {
        diagnostics.errors.push(`binding should have a string "name" field.`);
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "class_name", "string")) {
        diagnostics.errors.push(`binding should have a string "class_name" field.`);
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "script_name", "string")) {
        diagnostics.errors.push(
          `the field "script_name", when present, should be a string.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "environment", "string")) {
        diagnostics.errors.push(
          `the field "environment", when present, should be a string.`
        );
        isValid2 = false;
      }
      if ("environment" in value && !("script_name" in value)) {
        diagnostics.errors.push(
          `binding should have a "script_name" field if "environment" is present.`
        );
        isValid2 = false;
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "class_name",
        "environment",
        "name",
        "script_name"
      ]);
      return isValid2;
    }, "validateDurableObjectBinding");
    workflowNameFormatMessage = `Workflow names must be 1-64 characters long, start with a letter, number, or underscore, and may only contain letters, numbers, underscores, or hyphens.`;
    validateWorkflowBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"workflows" bindings should be objects, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "name", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "name" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      } else if (!isValidWorkflowName(value.name)) {
        diagnostics.errors.push(
          `"${field}" binding "name" field is invalid. ${workflowNameFormatMessage}`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "class_name", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "class_name" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "script_name", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should, optionally, have a string "script_name" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "remote", "boolean")) {
        diagnostics.errors.push(
          `"${field}" bindings should, optionally, have a boolean "remote" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "name",
        "class_name",
        "script_name",
        "remote"
      ]);
      return isValid2;
    }, "validateWorkflowBinding");
    validateCflogfwdrObject = /* @__PURE__ */ __name2((envName) => (diagnostics, field, value, topLevelEnv) => {
      const bindingsValidation = validateBindingsProperty(
        envName,
        validateCflogfwdrBinding
      );
      if (!bindingsValidation(diagnostics, field, value, topLevelEnv)) {
        return false;
      }
      const v8 = value;
      if (v8?.schema !== void 0) {
        diagnostics.errors.push(
          `"${field}" binding "schema" property has been replaced with the "unsafe.capnp" object, which expects a "base_path" and an array of "source_schemas" to compile, or a "compiled_schema" property.`
        );
        return false;
      }
      return true;
    }, "validateCflogfwdrObject");
    validateCflogfwdrBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `Expected "${field}" to be an object but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "name", "string")) {
        diagnostics.errors.push(`binding should have a string "name" field.`);
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "destination", "string")) {
        diagnostics.errors.push(
          `binding should have a string "destination" field.`
        );
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "destination",
        "name"
      ]);
      return isValid2;
    }, "validateCflogfwdrBinding");
    validateAssetsConfig = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (value === void 0) {
        return true;
      }
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"${field}" should be an object, but got value ${JSON.stringify(
            field
          )} of type ${typeof value}`
        );
        return false;
      }
      let isValid2 = true;
      isValid2 = validateOptionalProperty(
        diagnostics,
        field,
        "directory",
        value.directory,
        "string"
      ) && isValid2;
      isValid2 = validateOptionalProperty(
        diagnostics,
        field,
        "binding",
        value.binding,
        "string"
      ) && isValid2;
      isValid2 = validateOptionalProperty(
        diagnostics,
        field,
        "html_handling",
        value.html_handling,
        "string",
        [
          "auto-trailing-slash",
          "force-trailing-slash",
          "drop-trailing-slash",
          "none"
        ]
      ) && isValid2;
      isValid2 = validateOptionalProperty(
        diagnostics,
        field,
        "not_found_handling",
        value.not_found_handling,
        "string",
        ["single-page-application", "404-page", "none"]
      ) && isValid2;
      if (value.run_worker_first !== void 0) {
        if (typeof value.run_worker_first === "boolean") {
          isValid2 = validateOptionalProperty(
            diagnostics,
            field,
            "run_worker_first",
            value.run_worker_first,
            "boolean"
          ) && isValid2;
        } else if (Array.isArray(value.run_worker_first)) {
          isValid2 = validateOptionalTypedArray(
            diagnostics,
            "assets.run_worker_first",
            value.run_worker_first,
            "string"
          ) && isValid2;
        } else {
          diagnostics.errors.push(
            `The field "${field}.run_worker_first" should be an array of strings or a boolean, but got ${JSON.stringify(
              value.run_worker_first
            )}.`
          );
          isValid2 = false;
        }
      }
      isValid2 = validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "directory",
        "binding",
        "html_handling",
        "not_found_handling",
        "run_worker_first"
      ]) && isValid2;
      return isValid2;
    }, "validateAssetsConfig");
    validateNamedSimpleBinding = /* @__PURE__ */ __name2((envName) => (diagnostics, field, value, config) => {
      const fieldPath = config === void 0 ? `${field}` : `env.${envName}.${field}`;
      if (typeof value !== "object" || value === null || Array.isArray(value)) {
        diagnostics.errors.push(
          `The field "${fieldPath}" should be an object but got ${JSON.stringify(
            value
          )}.`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(`binding should have a string "binding" field.`);
        isValid2 = false;
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "remote"
      ]);
      return isValid2;
    }, "validateNamedSimpleBinding");
    validateAIBinding = /* @__PURE__ */ __name2((envName) => (diagnostics, field, value, config) => {
      const fieldPath = config === void 0 ? `${field}` : `env.${envName}.${field}`;
      if (typeof value !== "object" || value === null || Array.isArray(value)) {
        diagnostics.errors.push(
          `The field "${fieldPath}" should be an object but got ${JSON.stringify(
            value
          )}.`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(`binding should have a string "binding" field.`);
        isValid2 = false;
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      return isValid2;
    }, "validateAIBinding");
    validateVersionMetadataBinding = /* @__PURE__ */ __name2((envName) => (diagnostics, field, value, config) => {
      const fieldPath = config === void 0 ? `${field}` : `env.${envName}.${field}`;
      if (typeof value !== "object" || value === null || Array.isArray(value)) {
        diagnostics.errors.push(
          `The field "${fieldPath}" should be an object but got ${JSON.stringify(
            value
          )}.`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(`binding should have a string "binding" field.`);
        isValid2 = false;
      }
      return isValid2;
    }, "validateVersionMetadataBinding");
    validateUnsafeBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `Expected ${field} to be an object but got ${JSON.stringify(value)}.`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "name", "string")) {
        diagnostics.errors.push(`binding should have a string "name" field.`);
        isValid2 = false;
      }
      if (isRequiredProperty(value, "type", "string")) {
        const safeBindings = [
          "plain_text",
          "secret_text",
          "json",
          "wasm_module",
          "data_blob",
          "text_blob",
          "browser",
          "ai",
          "kv_namespace",
          "durable_object_namespace",
          "d1_database",
          "r2_bucket",
          "service",
          "logfwdr",
          "mtls_certificate",
          "pipeline",
          "worker_loader",
          "vpc_service",
          "media"
        ];
        if (safeBindings.includes(value.type)) {
          diagnostics.warnings.push(
            `The binding type "${value.type}" is directly supported by wrangler.
Consider migrating this unsafe binding to a format for '${value.type}' bindings that is supported by wrangler for optimal support.
For more details, see https://developers.cloudflare.com/workers/cli-wrangler/configuration`
          );
        }
        if (value.type === "metadata" && isRequiredProperty(value, "name", "string")) {
          diagnostics.warnings.push(
            "The deployment object in the metadata binding is now deprecated. Please switch using the version_metadata binding for access to version specific fields: https://developers.cloudflare.com/workers/runtime-apis/bindings/version-metadata"
          );
        }
      } else {
        diagnostics.errors.push(`binding should have a string "type" field.`);
        isValid2 = false;
      }
      return isValid2;
    }, "validateUnsafeBinding");
    validateBindingArray = /* @__PURE__ */ __name2((envName, validateBinding) => (diagnostics, field, envValue, config) => {
      if (envValue === void 0) {
        return true;
      }
      const fieldPath = config === void 0 ? `${field}` : `env.${envName}.${field}`;
      if (!Array.isArray(envValue)) {
        diagnostics.errors.push(
          `The field "${fieldPath}" should be an array but got ${JSON.stringify(
            envValue
          )}.`
        );
        return false;
      }
      let isValid2 = true;
      for (let i6 = 0; i6 < envValue.length; i6++) {
        isValid2 = validateBinding(
          diagnostics,
          `${fieldPath}[${i6}]`,
          envValue[i6],
          config
        ) && isValid2;
      }
      const configValue = config?.[field];
      if (Array.isArray(configValue)) {
        const configBindingNames = configValue.map((value) => value.binding);
        if (configBindingNames.length > 0) {
          const envBindingNames = new Set(envValue.map((value) => value.binding));
          for (const configBindingName of configBindingNames) {
            if (!envBindingNames.has(configBindingName)) {
              diagnostics.warnings.push(
                `There is a ${field} binding with name "${configBindingName}" at the top level, but not on "env.${envName}".
This is not what you probably want, since "${field}" configuration is not inherited by environments.
Please add a binding for "${configBindingName}" to "env.${envName}.${field}.bindings".`
              );
            }
          }
        }
      }
      return isValid2;
    }, "validateBindingArray");
    __name(validateContainerApp, "validateContainerApp");
    __name2(validateContainerApp, "validateContainerApp");
    validateCloudchamberConfig = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null || Array.isArray(value)) {
        diagnostics.errors.push(
          `"cloudchamber" should be an object, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      const optionalAttrsByType = {
        string: ["memory", "image", "location"],
        boolean: ["ipv4"],
        number: ["vcpu"]
      };
      let isValid2 = true;
      Object.entries(optionalAttrsByType).forEach(([attrType, attrNames]) => {
        attrNames.forEach((key) => {
          if (!isOptionalProperty(value, key, attrType)) {
            diagnostics.errors.push(
              `"${field}" bindings should, optionally, have a ${attrType} "${key}" field but got ${JSON.stringify(
                value
              )}.`
            );
            isValid2 = false;
          }
        });
      });
      if ("instance_type" in value && value.instance_type !== void 0) {
        if (typeof value.instance_type !== "string" || !ALLOWED_INSTANCE_TYPES.includes(value.instance_type)) {
          diagnostics.errors.push(
            `"instance_type" should be one of 'lite', 'basic', 'standard-1', 'standard-2', 'standard-3', or 'standard-4', but got ${value.instance_type}`
          );
        }
        if ("memory" in value && value.memory !== void 0 || "vcpu" in value && value.vcpu !== void 0) {
          diagnostics.errors.push(
            `"${field}" configuration should not set either "memory" or "vcpu" with "instance_type"`
          );
        }
      }
      return isValid2;
    }, "validateCloudchamberConfig");
    validateKVBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"kv_namespaces" bindings should be objects, but got ${JSON.stringify(
            value
          )}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "id", "string") || value.id !== void 0 && value.id.length === 0) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "id" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "preview_id", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should, optionally, have a string "preview_id" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "id",
        "preview_id",
        "remote"
      ]);
      return isValid2;
    }, "validateKVBinding");
    validateSendEmailBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"send_email" bindings should be objects, but got ${JSON.stringify(
            value
          )}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "name", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "name" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "destination_address", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should, optionally, have a string "destination_address" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "allowed_destination_addresses", "object")) {
        diagnostics.errors.push(
          `"${field}" bindings should, optionally, have a []string "allowed_destination_addresses" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "allowed_sender_addresses", "object")) {
        diagnostics.errors.push(
          `"${field}" bindings should, optionally, have a []string "allowed_sender_addresses" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if ("destination_address" in value && "allowed_destination_addresses" in value) {
        diagnostics.errors.push(
          `"${field}" bindings should have either a "destination_address" or "allowed_destination_addresses" field, but not both.`
        );
        isValid2 = false;
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "allowed_sender_addresses",
        "allowed_destination_addresses",
        "destination_address",
        "name",
        "binding",
        "remote"
      ]);
      return isValid2;
    }, "validateSendEmailBinding");
    validateQueueBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"queue" bindings should be objects, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      if (!validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "queue",
        "delivery_delay",
        "remote"
      ])) {
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "queue", "string") || value.queue.length === 0) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "queue" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      const options = [{ key: "delivery_delay", type: "number" }];
      for (const optionalOpt of options) {
        if (!isOptionalProperty(value, optionalOpt.key, optionalOpt.type)) {
          diagnostics.errors.push(
            `"${field}" should, optionally, have a ${optionalOpt.type} "${optionalOpt.key}" field but got ${JSON.stringify(value)}.`
          );
          isValid2 = false;
        }
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      return isValid2;
    }, "validateQueueBinding");
    validateR2Binding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"r2_buckets" bindings should be objects, but got ${JSON.stringify(
            value
          )}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "bucket_name", "string") || value.bucket_name !== void 0 && value.bucket_name.length === 0) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "bucket_name" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (isValid2 && hasProperty(value, "bucket_name") && !isValidR2BucketName(value.bucket_name)) {
        diagnostics.errors.push(
          `${field}.bucket_name=${JSON.stringify(value.bucket_name)} is invalid. ${bucketFormatMessage}`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "preview_bucket_name", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should, optionally, have a string "preview_bucket_name" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (isValid2 && hasProperty(value, "preview_bucket_name") && !isValidR2BucketName(value.preview_bucket_name)) {
        diagnostics.errors.push(
          `${field}.preview_bucket_name= ${JSON.stringify(value.preview_bucket_name)} is invalid. ${bucketFormatMessage}`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "jurisdiction", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should, optionally, have a string "jurisdiction" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "bucket_name",
        "preview_bucket_name",
        "jurisdiction",
        "remote"
      ]);
      return isValid2;
    }, "validateR2Binding");
    validateD1Binding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"d1_databases" bindings should be objects, but got ${JSON.stringify(
            value
          )}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "database_id", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a "database_id" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "preview_database_id", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should, optionally, have a string "preview_database_id" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "database_id",
        "database_internal_env",
        "database_name",
        "migrations_dir",
        "migrations_table",
        "preview_database_id",
        "remote"
      ]);
      return isValid2;
    }, "validateD1Binding");
    validateVectorizeBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"vectorize" bindings should be objects, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "index_name", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have an "index_name" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "index_name",
        "remote"
      ]);
      return isValid2;
    }, "validateVectorizeBinding");
    validateHyperdriveBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"hyperdrive" bindings should be objects, but got ${JSON.stringify(
            value
          )}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "id", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a "id" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "id",
        "localConnectionString"
      ]);
      return isValid2;
    }, "validateHyperdriveBinding");
    validateVpcServiceBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"vpc_services" bindings should be objects, but got ${JSON.stringify(
            value
          )}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "service_id", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a "service_id" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "service_id",
        "remote"
      ]);
      return isValid2;
    }, "validateVpcServiceBinding");
    validateBindingsHaveUniqueNames = /* @__PURE__ */ __name2((diagnostics, config) => {
      let hasDuplicates = false;
      const bindingNamesArray = Object.entries(friendlyBindingNames);
      const bindingsGroupedByType = Object.fromEntries(
        bindingNamesArray.map(([bindingType, binding]) => [
          binding,
          getBindingNames(
            bindingType === "queues" ? config[bindingType]?.producers : config[bindingType]
          )
        ])
      );
      const bindingsGroupedByName = {};
      for (const bindingType in bindingsGroupedByType) {
        const bindingNames = bindingsGroupedByType[bindingType];
        for (const bindingName of bindingNames) {
          if (!(bindingName in bindingsGroupedByName)) {
            bindingsGroupedByName[bindingName] = [];
          }
          if (bindingName === "ASSETS" && isPagesConfig(config)) {
            diagnostics.errors.push(
              `The name 'ASSETS' is reserved in Pages projects. Please use a different name for your ${bindingType} binding.`
            );
          }
          bindingsGroupedByName[bindingName].push(bindingType);
        }
      }
      for (const bindingName in bindingsGroupedByName) {
        const bindingTypes = bindingsGroupedByName[bindingName];
        if (bindingTypes.length < 2) {
          continue;
        }
        hasDuplicates = true;
        const sameType = bindingTypes.filter((type, i6) => bindingTypes.indexOf(type) !== i6).filter(
          (type, i6, duplicateBindingTypes) => duplicateBindingTypes.indexOf(type) === i6
        );
        const differentTypes = bindingTypes.filter(
          (type, i6) => bindingTypes.indexOf(type) === i6
        );
        if (differentTypes.length > 1) {
          diagnostics.errors.push(
            `${bindingName} assigned to ${ENGLISH.format(differentTypes)} bindings.`
          );
        }
        sameType.forEach((bindingType) => {
          diagnostics.errors.push(
            `${bindingName} assigned to multiple ${bindingType} bindings.`
          );
        });
      }
      if (hasDuplicates) {
        const problem = "Bindings must have unique names, so that they can all be referenced in the worker.";
        const resolution = "Please change your bindings to have unique names.";
        diagnostics.errors.push(`${problem}
${resolution}`);
      }
      return !hasDuplicates;
    }, "validateBindingsHaveUniqueNames");
    validateServiceBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"services" bindings should be objects, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "service", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "service" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "environment", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "environment" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "entrypoint", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "entrypoint" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      return isValid2;
    }, "validateServiceBinding");
    validateAnalyticsEngineBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"analytics_engine" bindings should be objects, but got ${JSON.stringify(
            value
          )}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "dataset", "string") || value.dataset?.length === 0) {
        diagnostics.errors.push(
          `"${field}" bindings should, optionally, have a string "dataset" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "dataset"
      ]);
      return isValid2;
    }, "validateAnalyticsEngineBinding");
    validateWorkerNamespaceBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"${field}" binding should be objects, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "namespace", "string")) {
        diagnostics.errors.push(
          `"${field}" should have a string "namespace" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (hasProperty(value, "outbound")) {
        if (!validateWorkerNamespaceOutbound(
          diagnostics,
          `${field}.outbound`,
          value.outbound ?? {}
        )) {
          diagnostics.errors.push(`"${field}" has an invalid outbound definition.`);
          isValid2 = false;
        }
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      return isValid2;
    }, "validateWorkerNamespaceBinding");
    __name(validateWorkerNamespaceOutbound, "validateWorkerNamespaceOutbound");
    __name2(validateWorkerNamespaceOutbound, "validateWorkerNamespaceOutbound");
    validateMTlsCertificateBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"mtls_certificates" bindings should be objects, but got ${JSON.stringify(
            value
          )}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "certificate_id", "string") || value.certificate_id.length === 0) {
        diagnostics.errors.push(
          `"${field}" bindings should have a string "certificate_id" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "certificate_id",
        "remote"
      ]);
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      return isValid2;
    }, "validateMTlsCertificateBinding");
    __name(validateQueues, "validateQueues");
    __name2(validateQueues, "validateQueues");
    validateConsumer = /* @__PURE__ */ __name2((diagnostics, field, value, _config) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"${field}" should be a objects, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "queue",
        "type",
        "max_batch_size",
        "max_batch_timeout",
        "max_retries",
        "dead_letter_queue",
        "max_concurrency",
        "visibility_timeout_ms",
        "retry_delay"
      ])) {
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "queue", "string")) {
        diagnostics.errors.push(
          `"${field}" should have a string "queue" field but got ${JSON.stringify(
            value
          )}.`
        );
      }
      const options = [
        { key: "type", type: "string" },
        { key: "max_batch_size", type: "number" },
        { key: "max_batch_timeout", type: "number" },
        { key: "max_retries", type: "number" },
        { key: "dead_letter_queue", type: "string" },
        { key: "max_concurrency", type: "number" },
        { key: "visibility_timeout_ms", type: "number" },
        { key: "retry_delay", type: "number" }
      ];
      for (const optionalOpt of options) {
        if (!isOptionalProperty(value, optionalOpt.key, optionalOpt.type)) {
          diagnostics.errors.push(
            `"${field}" should, optionally, have a ${optionalOpt.type} "${optionalOpt.key}" field but got ${JSON.stringify(value)}.`
          );
          isValid2 = false;
        }
      }
      return isValid2;
    }, "validateConsumer");
    validateCompatibilityDate = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (value === void 0) {
        return true;
      }
      if (typeof value !== "string") {
        diagnostics.errors.push(
          `Expected "${field}" to be of type string but got ${JSON.stringify(value)}.`
        );
        return false;
      }
      return isValidDateTimeStringFormat(diagnostics, field, value);
    }, "validateCompatibilityDate");
    validatePipelineBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"pipeline" bindings should be objects, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "pipeline", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a string "pipeline" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRemoteValid(value, field, diagnostics)) {
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "pipeline",
        "remote"
      ]);
      return isValid2;
    }, "validatePipelineBinding");
    validateSecretsStoreSecretBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"secrets_store_secrets" bindings should be objects, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "store_id", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a string "store_id" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "secret_name", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a string "secret_name" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "store_id",
        "secret_name"
      ]);
      return isValid2;
    }, "validateSecretsStoreSecretBinding");
    validateHelloWorldBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"unsafe_hello_world" bindings should be objects, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isOptionalProperty(value, "enable_timer", "boolean")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a boolean "enable_timer" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding",
        "enable_timer"
      ]);
      return isValid2;
    }, "validateHelloWorldBinding");
    validateWorkerLoaderBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"worker_loader" bindings should be objects, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "binding", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a string "binding" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "binding"
      ]);
      return isValid2;
    }, "validateWorkerLoaderBinding");
    validateRateLimitBinding = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (typeof value !== "object" || value === null) {
        diagnostics.errors.push(
          `"ratelimits" bindings should be objects, but got ${JSON.stringify(value)}`
        );
        return false;
      }
      let isValid2 = true;
      if (!isRequiredProperty(value, "name", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a string "name" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!isRequiredProperty(value, "namespace_id", "string")) {
        diagnostics.errors.push(
          `"${field}" bindings must have a string "namespace_id" field but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      }
      if (!hasProperty(value, "simple") || typeof value.simple !== "object" || value.simple === null) {
        diagnostics.errors.push(
          `"${field}" bindings must have a "simple" configuration object but got ${JSON.stringify(
            value
          )}.`
        );
        isValid2 = false;
      } else {
        if (!isRequiredProperty(value.simple, "limit", "number")) {
          diagnostics.errors.push(
            `"${field}" bindings "simple.limit" must be a number but got ${JSON.stringify(
              value.simple
            )}.`
          );
          isValid2 = false;
        }
        if (!isRequiredProperty(value.simple, "period", "number")) {
          diagnostics.errors.push(
            `"${field}" bindings "simple.period" is required and must be a number but got ${JSON.stringify(
              value.simple
            )}.`
          );
          isValid2 = false;
        } else if (![10, 60].includes(value.simple.period)) {
          diagnostics.errors.push(
            `"${field}" bindings "simple.period" must be either 10 or 60 but got ${JSON.stringify(
              value.simple.period
            )}.`
          );
          isValid2 = false;
        }
        validateAdditionalProperties(
          diagnostics,
          `${field}.simple`,
          Object.keys(value.simple),
          ["limit", "period"]
        );
      }
      validateAdditionalProperties(diagnostics, field, Object.keys(value), [
        "name",
        "namespace_id",
        "simple"
      ]);
      return isValid2;
    }, "validateRateLimitBinding");
    __name(normalizeAndValidateLimits, "normalizeAndValidateLimits");
    __name2(normalizeAndValidateLimits, "normalizeAndValidateLimits");
    validateMigrations = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      const rawMigrations = value ?? [];
      if (!Array.isArray(rawMigrations)) {
        diagnostics.errors.push(
          `The optional "${field}" field should be an array, but got ${JSON.stringify(
            rawMigrations
          )}`
        );
        return false;
      }
      let valid = true;
      for (let i6 = 0; i6 < rawMigrations.length; i6++) {
        const {
          tag,
          new_classes,
          new_sqlite_classes,
          renamed_classes,
          deleted_classes,
          transferred_classes,
          ...rest
        } = rawMigrations[i6];
        valid = validateAdditionalProperties(
          diagnostics,
          "migrations",
          Object.keys(rest),
          []
        ) && valid;
        valid = validateRequiredProperty(
          diagnostics,
          `migrations[${i6}]`,
          `tag`,
          tag,
          "string"
        ) && valid;
        valid = validateOptionalTypedArray(
          diagnostics,
          `migrations[${i6}].new_classes`,
          new_classes,
          "string"
        ) && valid;
        valid = validateOptionalTypedArray(
          diagnostics,
          `migrations[${i6}].new_sqlite_classes`,
          new_sqlite_classes,
          "string"
        ) && valid;
        if (renamed_classes !== void 0) {
          if (!Array.isArray(renamed_classes)) {
            diagnostics.errors.push(
              `Expected "migrations[${i6}].renamed_classes" to be an array of "{from: string, to: string}" objects but got ${JSON.stringify(
                renamed_classes
              )}.`
            );
            valid = false;
          } else if (renamed_classes.some(
            (c7) => typeof c7 !== "object" || !isRequiredProperty(c7, "from", "string") || !isRequiredProperty(c7, "to", "string")
          )) {
            diagnostics.errors.push(
              `Expected "migrations[${i6}].renamed_classes" to be an array of "{from: string, to: string}" objects but got ${JSON.stringify(
                renamed_classes
              )}.`
            );
            valid = false;
          }
        }
        if (transferred_classes !== void 0) {
          if (!Array.isArray(transferred_classes)) {
            diagnostics.errors.push(
              `Expected "migrations[${i6}].transferred_classes" to be an array of "{from: string, from_script: string, to: string}" objects but got ${JSON.stringify(
                transferred_classes
              )}.`
            );
            valid = false;
          } else if (transferred_classes.some(
            (c7) => typeof c7 !== "object" || !isRequiredProperty(c7, "from", "string") || !isRequiredProperty(c7, "from_script", "string") || !isRequiredProperty(c7, "to", "string")
          )) {
            diagnostics.errors.push(
              `Expected "migrations[${i6}].transferred_classes" to be an array of "{from: string, from_script: string, to: string}" objects but got ${JSON.stringify(
                transferred_classes
              )}.`
            );
            valid = false;
          }
        }
        valid = validateOptionalTypedArray(
          diagnostics,
          `migrations[${i6}].deleted_classes`,
          deleted_classes,
          "string"
        ) && valid;
      }
      return valid;
    }, "validateMigrations");
    validateObservability = /* @__PURE__ */ __name2((diagnostics, field, value) => {
      if (value === void 0) {
        return true;
      }
      if (typeof value !== "object") {
        diagnostics.errors.push(
          `"${field}" should be an object but got ${JSON.stringify(value)}.`
        );
        return false;
      }
      const val2 = value;
      let isValid2 = true;
      isValid2 = validateAtLeastOnePropertyRequired(diagnostics, field, [
        {
          key: "enabled",
          value: val2.enabled,
          type: "boolean"
        },
        {
          key: "logs.enabled",
          value: val2.logs?.enabled,
          type: "boolean"
        },
        {
          key: "traces.enabled",
          value: val2.traces?.enabled,
          type: "boolean"
        }
      ]) && isValid2;
      isValid2 = validateOptionalProperty(
        diagnostics,
        field,
        "head_sampling_rate",
        val2.head_sampling_rate,
        "number"
      ) && isValid2;
      isValid2 = validateOptionalProperty(diagnostics, field, "logs", val2.logs, "object") && isValid2;
      isValid2 = validateOptionalProperty(
        diagnostics,
        field,
        "traces",
        val2.traces,
        "object"
      ) && isValid2;
      isValid2 = validateAdditionalProperties(diagnostics, field, Object.keys(val2), [
        "enabled",
        "head_sampling_rate",
        "logs",
        "traces"
      ]) && isValid2;
      if (typeof val2.logs === "object") {
        isValid2 = validateOptionalProperty(
          diagnostics,
          field,
          "logs.enabled",
          val2.logs.enabled,
          "boolean"
        ) && isValid2;
        isValid2 = validateOptionalProperty(
          diagnostics,
          field,
          "logs.head_sampling_rate",
          val2.logs.head_sampling_rate,
          "number"
        ) && isValid2;
        isValid2 = validateOptionalProperty(
          diagnostics,
          field,
          "logs.invocation_logs",
          val2.logs.invocation_logs,
          "boolean"
        ) && isValid2;
        isValid2 = validateOptionalTypedArray(
          diagnostics,
          "logs.destinations",
          val2.logs?.destinations,
          "string"
        ) && isValid2;
        isValid2 = validateOptionalProperty(
          diagnostics,
          field,
          "logs.persist",
          val2.logs.persist,
          "boolean"
        ) && isValid2;
        isValid2 = validateAdditionalProperties(diagnostics, field, Object.keys(val2.logs), [
          "enabled",
          "head_sampling_rate",
          "invocation_logs",
          "destinations",
          "persist"
        ]) && isValid2;
      }
      if (typeof val2.traces === "object") {
        isValid2 = validateOptionalProperty(
          diagnostics,
          field,
          "traces.enabled",
          val2.traces.enabled,
          "boolean"
        ) && isValid2;
        isValid2 = validateOptionalProperty(
          diagnostics,
          field,
          "traces.head_sampling_rate",
          val2.traces.head_sampling_rate,
          "number"
        ) && isValid2;
        isValid2 = validateOptionalTypedArray(
          diagnostics,
          "traces.destinations",
          val2.traces?.destinations,
          "string"
        ) && isValid2;
        isValid2 = validateOptionalProperty(
          diagnostics,
          field,
          "traces.persist",
          val2.traces.persist,
          "boolean"
        ) && isValid2;
        isValid2 = validateAdditionalProperties(
          diagnostics,
          field,
          Object.keys(val2.traces),
          ["enabled", "head_sampling_rate", "destinations", "persist"]
        ) && isValid2;
      }
      const samplingRate = val2?.head_sampling_rate;
      if (samplingRate && (samplingRate < 0 || samplingRate > 1)) {
        diagnostics.errors.push(
          `"${field}.head_sampling_rate" must be a value between 0 and 1.`
        );
      }
      return isValid2;
    }, "validateObservability");
    __name(warnIfDurableObjectsHaveNoMigrations, "warnIfDurableObjectsHaveNoMigrations");
    __name2(warnIfDurableObjectsHaveNoMigrations, "warnIfDurableObjectsHaveNoMigrations");
    validatePythonModules = /* @__PURE__ */ __name2((diagnostics, field, value, topLevelEnv) => {
      if (value === void 0) {
        return true;
      }
      if (typeof value !== "object" || value === null || Array.isArray(value)) {
        diagnostics.errors.push(
          `"${field}" should be an object but got ${JSON.stringify(value)}.`
        );
        return false;
      }
      const val2 = value;
      if (!("exclude" in val2)) {
        return false;
      }
      if (!isStringArray(diagnostics, `${field}.exclude`, val2.exclude, topLevelEnv)) {
        return false;
      }
      return true;
    }, "validatePythonModules");
    __name(isRemoteValid, "isRemoteValid");
    __name2(isRemoteValid, "isRemoteValid");
    supportedPagesConfigFields = [
      "pages_build_output_dir",
      "name",
      "compatibility_date",
      "compatibility_flags",
      "send_metrics",
      "no_bundle",
      "limits",
      "placement",
      "vars",
      "durable_objects",
      "kv_namespaces",
      "queues",
      // `producers` ONLY
      "r2_buckets",
      "d1_databases",
      "vectorize",
      "hyperdrive",
      "services",
      "analytics_engine_datasets",
      "ai",
      "version_metadata",
      "dev",
      "mtls_certificates",
      "browser",
      "upload_source_maps",
      // normalizeAndValidateConfig() sets these values
      "configPath",
      "userConfigPath",
      "topLevelName",
      "definedEnvironments",
      "targetEnvironment"
    ];
    __name(validatePagesConfig, "validatePagesConfig");
    __name2(validatePagesConfig, "validatePagesConfig");
    __name(validateMainField, "validateMainField");
    __name2(validateMainField, "validateMainField");
    __name(validateProjectName, "validateProjectName");
    __name2(validateProjectName, "validateProjectName");
    __name(validatePagesEnvironmentNames, "validatePagesEnvironmentNames");
    __name2(validatePagesEnvironmentNames, "validatePagesEnvironmentNames");
    __name(validateUnsupportedFields, "validateUnsupportedFields");
    __name2(validateUnsupportedFields, "validateUnsupportedFields");
    __name(validateDurableObjectBinding2, "validateDurableObjectBinding2");
    __name2(validateDurableObjectBinding2, "validateDurableObjectBinding");
  }
});

// ../../node_modules/.pnpm/yargs@17.7.2/node_modules/yargs/build/lib/yerror.js
var YError;
var init_yerror = __esm({
  "../../node_modules/.pnpm/yargs@17.7.2/node_modules/yargs/build/lib/yerror.js"() {
    init_import_meta_url();
    YError = class _YError extends Error {
      static {
        __name(this, "YError");
      }
      constructor(msg) {
        super(msg || "yargs error");
        this.name = "YError";
        if (Error.captureStackTrace) {
          Error.captureStackTrace(this, _YError);
        }
      }
    };
  }
});

// ../../node_modules/.pnpm/yargs@17.7.2/node_modules/yargs/build/lib/utils/apply-extends.js
function applyExtends(config, cwd2, mergeExtends, _shim) {
  shim = _shim;
  let defaultConfig = {};
  if (Object.prototype.hasOwnProperty.call(config, "extends")) {
    if (typeof config.extends !== "string")
      return defaultConfig;
    const isPath = /\.json|\..*rc$/.test(config.extends);
    let pathToDefault = null;
    if (!isPath) {
      try {
        pathToDefault = __require.resolve(config.extends);
      } catch (_err) {
        return config;
      }
    } else {
      pathToDefault = getPathToDefaultConfig(cwd2, config.extends);
    }
    checkForCircularExtends(pathToDefault);
    previouslyVisitedConfigs.push(pathToDefault);
    defaultConfig = isPath ? JSON.parse(shim.readFileSync(pathToDefault, "utf8")) : __require(config.extends);
    delete config.extends;
    defaultConfig = applyExtends(defaultConfig, shim.path.dirname(pathToDefault), mergeExtends, shim);
  }
  previouslyVisitedConfigs = [];
  return mergeExtends ? mergeDeep(defaultConfig, config) : Object.assign({}, defaultConfig, config);
}
function checkForCircularExtends(cfgPath) {
  if (previouslyVisitedConfigs.indexOf(cfgPath) > -1) {
    throw new YError(`Circular extended configurations: '${cfgPath}'.`);
  }
}
function getPathToDefaultConfig(cwd2, pathToExtend) {
  return shim.path.resolve(cwd2, pathToExtend);
}
function mergeDeep(config1, config2) {
  const target = {};
  function isObject4(obj) {
    return obj && typeof obj === "object" && !Array.isArray(obj);
  }
  __name(isObject4, "isObject");
  Object.assign(target, config1);
  for (const key of Object.keys(config2)) {
    if (isObject4(config2[key]) && isObject4(target[key])) {
      target[key] = mergeDeep(config1[key], config2[key]);
    } else {
      target[key] = config2[key];
    }
  }
  return target;
}
var previouslyVisitedConfigs, shim;
var init_apply_extends = __esm({
  "../../node_modules/.pnpm/yargs@17.7.2/node_modules/yargs/build/lib/utils/apply-extends.js"() {
    init_import_meta_url();
    init_yerror();
    previouslyVisitedConfigs = [];
    __name(applyExtends, "applyExtends");
    __name(checkForCircularExtends, "checkForCircularExtends");
    __name(getPathToDefaultConfig, "getPathToDefaultConfig");
    __name(mergeDeep, "mergeDeep");
  }
});

// ../../node_modules/.pnpm/yargs@17.7.2/node_modules/yargs/build/lib/utils/process-argv.js
function getProcessArgvBinIndex() {
  if (isBundledElectronApp())
    return 0;
  return 1;
}
function isBundledElectronApp() {
  return isElectronApp() && !process.defaultApp;
}
function isElectronApp() {
  return !!process.versions.electron;
}
function hideBin(argv) {
  return argv.slice(getProcessArgvBinIndex() + 1);
}
function getProcessArgvBin() {
  return process.argv[getProcessArgvBinIndex()];
}
var init_process_argv = __esm({
  "../../node_modules/.pnpm/yargs@17.7.2/node_modules/yargs/build/lib/utils/process-argv.js"() {
    init_import_meta_url();
    __name(getProcessArgvBinIndex, "getProcessArgvBinIndex");
    __name(isBundledElectronApp, "isBundledElectronApp");
    __name(isElectronApp, "isElectronApp");
    __name(hideBin, "hideBin");
    __name(getProcessArgvBin, "getProcessArgvBin");
  }
});

// ../../node_modules/.pnpm/yargs-parser@21.1.1/node_modules/yargs-parser/build/lib/string-utils.js
function camelCase(str) {
  const isCamelCase = str !== str.toLowerCase() && str !== str.toUpperCase();
  if (!isCamelCase) {
    str = str.toLowerCase();
  }
  if (str.indexOf("-") === -1 && str.indexOf("_") === -1) {
    return str;
  } else {
    let camelcase = "";
    let nextChrUpper = false;
    const leadingHyphens = str.match(/^-+/);
    for (let i6 = leadingHyphens ? leadingHyphens[0].length : 0; i6 < str.length; i6++) {
      let chr = str.charAt(i6);
      if (nextChrUpper) {
        nextChrUpper = false;
        chr = chr.toUpperCase();
      }
      if (i6 !== 0 && (chr === "-" || chr === "_")) {
        nextChrUpper = true;
      } else if (chr !== "-" && chr !== "_") {
        camelcase += chr;
      }
    }
    return camelcase;
  }
}
function decamelize(str, joinString) {
  const lowercase = str.toLowerCase();
  joinString = joinString || "-";
  let notCamelcase = "";
  for (let i6 = 0; i6 < str.length; i6++) {
    const chrLower = lowercase.charAt(i6);
    const chrString = str.charAt(i6);
    if (chrLower !== chrString && i6 > 0) {
      notCamelcase += `${joinString}${lowercase.charAt(i6)}`;
    } else {
      notCamelcase += chrString;
    }
  }
  return notCamelcase;
}
function looksLikeNumber(x7) {
  if (x7 === null || x7 === void 0)
    return false;
  if (typeof x7 === "number")
    return true;
  if (/^0x[0-9a-f]+$/i.test(x7))
    return true;
  if (/^0[^.]/.test(x7))
    return false;
  return /^[-]?(?:\d+(?:\.\d*)?|\.\d+)(e[-+]?\d+)?$/.test(x7);
}
var init_string_utils = __esm({
  "../../node_modules/.pnpm/yargs-parser@21.1.1/node_modules/yargs-parser/build/lib/string-utils.js"() {
    init_import_meta_url();
    __name(camelCase, "camelCase");
    __name(decamelize, "decamelize");
    __name(looksLikeNumber, "looksLikeNumber");
  }
});

// ../../node_modules/.pnpm/yargs-parser@21.1.1/node_modules/yargs-parser/build/lib/tokenize-arg-string.js
function tokenizeArgString(argString) {
  if (Array.isArray(argString)) {
    return argString.map((e8) => typeof e8 !== "string" ? e8 + "" : e8);
  }
  argString = argString.trim();
  let i6 = 0;
  let prevC = null;
  let c7 = null;
  let opening = null;
  const args = [];
  for (let ii = 0; ii < argString.length; ii++) {
    prevC = c7;
    c7 = argString.charAt(ii);
    if (c7 === " " && !opening) {
      if (!(prevC === " ")) {
        i6++;
      }
      continue;
    }
    if (c7 === opening) {
      opening = null;
    } else if ((c7 === "'" || c7 === '"') && !opening) {
      opening = c7;
    }
    if (!args[i6])
      args[i6] = "";
    args[i6] += c7;
  }
  return args;
}
var init_tokenize_arg_string = __esm({
  "../../node_modules/.pnpm/yargs-parser@21.1.1/node_modules/yargs-parser/build/lib/tokenize-arg-string.js"() {
    init_import_meta_url();
    __name(tokenizeArgString, "tokenizeArgString");
  }
});

// ../../node_modules/.pnpm/yargs-parser@21.1.1/node_modules/yargs-parser/build/lib/yargs-parser-types.js
var DefaultValuesForTypeKey;
var init_yargs_parser_types = __esm({
  "../../node_modules/.pnpm/yargs-parser@21.1.1/node_modules/yargs-parser/build/lib/yargs-parser-types.js"() {
    init_import_meta_url();
    (function(DefaultValuesForTypeKey2) {
      DefaultValuesForTypeKey2["BOOLEAN"] = "boolean";
      DefaultValuesForTypeKey2["STRING"] = "string";
      DefaultValuesForTypeKey2["NUMBER"] = "number";
      DefaultValuesForTypeKey2["ARRAY"] = "array";
    })(DefaultValuesForTypeKey || (DefaultValuesForTypeKey = {}));
  }
});

// ../../node_modules/.pnpm/yargs-parser@21.1.1/node_modules/yargs-parser/build/lib/yargs-parser.js
function combineAliases(aliases2) {
  const aliasArrays = [];
  const combined = /* @__PURE__ */ Object.create(null);
  let change = true;
  Object.keys(aliases2).forEach(function(key) {
    aliasArrays.push([].concat(aliases2[key], key));
  });
  while (change) {
    change = false;
    for (let i6 = 0; i6 < aliasArrays.length; i6++) {
      for (let ii = i6 + 1; ii < aliasArrays.length; ii++) {
        const intersect = aliasArrays[i6].filter(function(v8) {
          return aliasArrays[ii].indexOf(v8) !== -1;
        });
        if (intersect.length) {
          aliasArrays[i6] = aliasArrays[i6].concat(aliasArrays[ii]);
          aliasArrays.splice(ii, 1);
          change = true;
          break;
        }
      }
    }
  }
  aliasArrays.forEach(function(aliasArray) {
    aliasArray = aliasArray.filter(function(v8, i6, self2) {
      return self2.indexOf(v8) === i6;
    });
    const lastAlias = aliasArray.pop();
    if (lastAlias !== void 0 && typeof lastAlias === "string") {
      combined[lastAlias] = aliasArray;
    }
  });
  return combined;
}
function increment(orig) {
  return orig !== void 0 ? orig + 1 : 1;
}
function sanitizeKey(key) {
  if (key === "__proto__")
    return "___proto___";
  return key;
}
function stripQuotes(val2) {
  return typeof val2 === "string" && (val2[0] === "'" || val2[0] === '"') && val2[val2.length - 1] === val2[0] ? val2.substring(1, val2.length - 1) : val2;
}
var mixin, YargsParser;
var init_yargs_parser = __esm({
  "../../node_modules/.pnpm/yargs-parser@21.1.1/node_modules/yargs-parser/build/lib/yargs-parser.js"() {
    init_import_meta_url();
    init_tokenize_arg_string();
    init_yargs_parser_types();
    init_string_utils();
    YargsParser = class {
      static {
        __name(this, "YargsParser");
      }
      constructor(_mixin) {
        mixin = _mixin;
      }
      parse(argsInput, options) {
        const opts = Object.assign({
          alias: void 0,
          array: void 0,
          boolean: void 0,
          config: void 0,
          configObjects: void 0,
          configuration: void 0,
          coerce: void 0,
          count: void 0,
          default: void 0,
          envPrefix: void 0,
          narg: void 0,
          normalize: void 0,
          string: void 0,
          number: void 0,
          __: void 0,
          key: void 0
        }, options);
        const args = tokenizeArgString(argsInput);
        const inputIsString = typeof argsInput === "string";
        const aliases2 = combineAliases(Object.assign(/* @__PURE__ */ Object.create(null), opts.alias));
        const configuration = Object.assign({
          "boolean-negation": true,
          "camel-case-expansion": true,
          "combine-arrays": false,
          "dot-notation": true,
          "duplicate-arguments-array": true,
          "flatten-duplicate-arrays": true,
          "greedy-arrays": true,
          "halt-at-non-option": false,
          "nargs-eats-options": false,
          "negation-prefix": "no-",
          "parse-numbers": true,
          "parse-positional-numbers": true,
          "populate--": false,
          "set-placeholder-key": false,
          "short-option-groups": true,
          "strip-aliased": false,
          "strip-dashed": false,
          "unknown-options-as-args": false
        }, opts.configuration);
        const defaults3 = Object.assign(/* @__PURE__ */ Object.create(null), opts.default);
        const configObjects = opts.configObjects || [];
        const envPrefix = opts.envPrefix;
        const notFlagsOption = configuration["populate--"];
        const notFlagsArgv = notFlagsOption ? "--" : "_";
        const newAliases = /* @__PURE__ */ Object.create(null);
        const defaulted = /* @__PURE__ */ Object.create(null);
        const __ = opts.__ || mixin.format;
        const flags2 = {
          aliases: /* @__PURE__ */ Object.create(null),
          arrays: /* @__PURE__ */ Object.create(null),
          bools: /* @__PURE__ */ Object.create(null),
          strings: /* @__PURE__ */ Object.create(null),
          numbers: /* @__PURE__ */ Object.create(null),
          counts: /* @__PURE__ */ Object.create(null),
          normalize: /* @__PURE__ */ Object.create(null),
          configs: /* @__PURE__ */ Object.create(null),
          nargs: /* @__PURE__ */ Object.create(null),
          coercions: /* @__PURE__ */ Object.create(null),
          keys: []
        };
        const negative = /^-([0-9]+(\.[0-9]+)?|\.[0-9]+)$/;
        const negatedBoolean = new RegExp("^--" + configuration["negation-prefix"] + "(.+)");
        [].concat(opts.array || []).filter(Boolean).forEach(function(opt) {
          const key = typeof opt === "object" ? opt.key : opt;
          const assignment = Object.keys(opt).map(function(key2) {
            const arrayFlagKeys = {
              boolean: "bools",
              string: "strings",
              number: "numbers"
            };
            return arrayFlagKeys[key2];
          }).filter(Boolean).pop();
          if (assignment) {
            flags2[assignment][key] = true;
          }
          flags2.arrays[key] = true;
          flags2.keys.push(key);
        });
        [].concat(opts.boolean || []).filter(Boolean).forEach(function(key) {
          flags2.bools[key] = true;
          flags2.keys.push(key);
        });
        [].concat(opts.string || []).filter(Boolean).forEach(function(key) {
          flags2.strings[key] = true;
          flags2.keys.push(key);
        });
        [].concat(opts.number || []).filter(Boolean).forEach(function(key) {
          flags2.numbers[key] = true;
          flags2.keys.push(key);
        });
        [].concat(opts.count || []).filter(Boolean).forEach(function(key) {
          flags2.counts[key] = true;
          flags2.keys.push(key);
        });
        [].concat(opts.normalize || []).filter(Boolean).forEach(function(key) {
          flags2.normalize[key] = true;
          flags2.keys.push(key);
        });
        if (typeof opts.narg === "object") {
          Object.entries(opts.narg).forEach(([key, value]) => {
            if (typeof value === "number") {
              flags2.nargs[key] = value;
              flags2.keys.push(key);
            }
          });
        }
        if (typeof opts.coerce === "object") {
          Object.entries(opts.coerce).forEach(([key, value]) => {
            if (typeof value === "function") {
              flags2.coercions[key] = value;
              flags2.keys.push(key);
            }
          });
        }
        if (typeof opts.config !== "undefined") {
          if (Array.isArray(opts.config) || typeof opts.config === "string") {
            [].concat(opts.config).filter(Boolean).forEach(function(key) {
              flags2.configs[key] = true;
            });
          } else if (typeof opts.config === "object") {
            Object.entries(opts.config).forEach(([key, value]) => {
              if (typeof value === "boolean" || typeof value === "function") {
                flags2.configs[key] = value;
              }
            });
          }
        }
        extendAliases(opts.key, aliases2, opts.default, flags2.arrays);
        Object.keys(defaults3).forEach(function(key) {
          (flags2.aliases[key] || []).forEach(function(alias) {
            defaults3[alias] = defaults3[key];
          });
        });
        let error2 = null;
        checkConfiguration();
        let notFlags = [];
        const argv = Object.assign(/* @__PURE__ */ Object.create(null), { _: [] });
        const argvReturn = {};
        for (let i6 = 0; i6 < args.length; i6++) {
          const arg = args[i6];
          const truncatedArg = arg.replace(/^-{3,}/, "---");
          let broken;
          let key;
          let letters;
          let m7;
          let next;
          let value;
          if (arg !== "--" && /^-/.test(arg) && isUnknownOptionAsArg(arg)) {
            pushPositional(arg);
          } else if (truncatedArg.match(/^---+(=|$)/)) {
            pushPositional(arg);
            continue;
          } else if (arg.match(/^--.+=/) || !configuration["short-option-groups"] && arg.match(/^-.+=/)) {
            m7 = arg.match(/^--?([^=]+)=([\s\S]*)$/);
            if (m7 !== null && Array.isArray(m7) && m7.length >= 3) {
              if (checkAllAliases(m7[1], flags2.arrays)) {
                i6 = eatArray(i6, m7[1], args, m7[2]);
              } else if (checkAllAliases(m7[1], flags2.nargs) !== false) {
                i6 = eatNargs(i6, m7[1], args, m7[2]);
              } else {
                setArg(m7[1], m7[2], true);
              }
            }
          } else if (arg.match(negatedBoolean) && configuration["boolean-negation"]) {
            m7 = arg.match(negatedBoolean);
            if (m7 !== null && Array.isArray(m7) && m7.length >= 2) {
              key = m7[1];
              setArg(key, checkAllAliases(key, flags2.arrays) ? [false] : false);
            }
          } else if (arg.match(/^--.+/) || !configuration["short-option-groups"] && arg.match(/^-[^-]+/)) {
            m7 = arg.match(/^--?(.+)/);
            if (m7 !== null && Array.isArray(m7) && m7.length >= 2) {
              key = m7[1];
              if (checkAllAliases(key, flags2.arrays)) {
                i6 = eatArray(i6, key, args);
              } else if (checkAllAliases(key, flags2.nargs) !== false) {
                i6 = eatNargs(i6, key, args);
              } else {
                next = args[i6 + 1];
                if (next !== void 0 && (!next.match(/^-/) || next.match(negative)) && !checkAllAliases(key, flags2.bools) && !checkAllAliases(key, flags2.counts)) {
                  setArg(key, next);
                  i6++;
                } else if (/^(true|false)$/.test(next)) {
                  setArg(key, next);
                  i6++;
                } else {
                  setArg(key, defaultValue(key));
                }
              }
            }
          } else if (arg.match(/^-.\..+=/)) {
            m7 = arg.match(/^-([^=]+)=([\s\S]*)$/);
            if (m7 !== null && Array.isArray(m7) && m7.length >= 3) {
              setArg(m7[1], m7[2]);
            }
          } else if (arg.match(/^-.\..+/) && !arg.match(negative)) {
            next = args[i6 + 1];
            m7 = arg.match(/^-(.\..+)/);
            if (m7 !== null && Array.isArray(m7) && m7.length >= 2) {
              key = m7[1];
              if (next !== void 0 && !next.match(/^-/) && !checkAllAliases(key, flags2.bools) && !checkAllAliases(key, flags2.counts)) {
                setArg(key, next);
                i6++;
              } else {
                setArg(key, defaultValue(key));
              }
            }
          } else if (arg.match(/^-[^-]+/) && !arg.match(negative)) {
            letters = arg.slice(1, -1).split("");
            broken = false;
            for (let j7 = 0; j7 < letters.length; j7++) {
              next = arg.slice(j7 + 2);
              if (letters[j7 + 1] && letters[j7 + 1] === "=") {
                value = arg.slice(j7 + 3);
                key = letters[j7];
                if (checkAllAliases(key, flags2.arrays)) {
                  i6 = eatArray(i6, key, args, value);
                } else if (checkAllAliases(key, flags2.nargs) !== false) {
                  i6 = eatNargs(i6, key, args, value);
                } else {
                  setArg(key, value);
                }
                broken = true;
                break;
              }
              if (next === "-") {
                setArg(letters[j7], next);
                continue;
              }
              if (/[A-Za-z]/.test(letters[j7]) && /^-?\d+(\.\d*)?(e-?\d+)?$/.test(next) && checkAllAliases(next, flags2.bools) === false) {
                setArg(letters[j7], next);
                broken = true;
                break;
              }
              if (letters[j7 + 1] && letters[j7 + 1].match(/\W/)) {
                setArg(letters[j7], next);
                broken = true;
                break;
              } else {
                setArg(letters[j7], defaultValue(letters[j7]));
              }
            }
            key = arg.slice(-1)[0];
            if (!broken && key !== "-") {
              if (checkAllAliases(key, flags2.arrays)) {
                i6 = eatArray(i6, key, args);
              } else if (checkAllAliases(key, flags2.nargs) !== false) {
                i6 = eatNargs(i6, key, args);
              } else {
                next = args[i6 + 1];
                if (next !== void 0 && (!/^(-|--)[^-]/.test(next) || next.match(negative)) && !checkAllAliases(key, flags2.bools) && !checkAllAliases(key, flags2.counts)) {
                  setArg(key, next);
                  i6++;
                } else if (/^(true|false)$/.test(next)) {
                  setArg(key, next);
                  i6++;
                } else {
                  setArg(key, defaultValue(key));
                }
              }
            }
          } else if (arg.match(/^-[0-9]$/) && arg.match(negative) && checkAllAliases(arg.slice(1), flags2.bools)) {
            key = arg.slice(1);
            setArg(key, defaultValue(key));
          } else if (arg === "--") {
            notFlags = args.slice(i6 + 1);
            break;
          } else if (configuration["halt-at-non-option"]) {
            notFlags = args.slice(i6);
            break;
          } else {
            pushPositional(arg);
          }
        }
        applyEnvVars(argv, true);
        applyEnvVars(argv, false);
        setConfig(argv);
        setConfigObjects();
        applyDefaultsAndAliases(argv, flags2.aliases, defaults3, true);
        applyCoercions(argv);
        if (configuration["set-placeholder-key"])
          setPlaceholderKeys(argv);
        Object.keys(flags2.counts).forEach(function(key) {
          if (!hasKey2(argv, key.split(".")))
            setArg(key, 0);
        });
        if (notFlagsOption && notFlags.length)
          argv[notFlagsArgv] = [];
        notFlags.forEach(function(key) {
          argv[notFlagsArgv].push(key);
        });
        if (configuration["camel-case-expansion"] && configuration["strip-dashed"]) {
          Object.keys(argv).filter((key) => key !== "--" && key.includes("-")).forEach((key) => {
            delete argv[key];
          });
        }
        if (configuration["strip-aliased"]) {
          [].concat(...Object.keys(aliases2).map((k7) => aliases2[k7])).forEach((alias) => {
            if (configuration["camel-case-expansion"] && alias.includes("-")) {
              delete argv[alias.split(".").map((prop) => camelCase(prop)).join(".")];
            }
            delete argv[alias];
          });
        }
        function pushPositional(arg) {
          const maybeCoercedNumber = maybeCoerceNumber("_", arg);
          if (typeof maybeCoercedNumber === "string" || typeof maybeCoercedNumber === "number") {
            argv._.push(maybeCoercedNumber);
          }
        }
        __name(pushPositional, "pushPositional");
        function eatNargs(i6, key, args2, argAfterEqualSign) {
          let ii;
          let toEat = checkAllAliases(key, flags2.nargs);
          toEat = typeof toEat !== "number" || isNaN(toEat) ? 1 : toEat;
          if (toEat === 0) {
            if (!isUndefined(argAfterEqualSign)) {
              error2 = Error(__("Argument unexpected for: %s", key));
            }
            setArg(key, defaultValue(key));
            return i6;
          }
          let available = isUndefined(argAfterEqualSign) ? 0 : 1;
          if (configuration["nargs-eats-options"]) {
            if (args2.length - (i6 + 1) + available < toEat) {
              error2 = Error(__("Not enough arguments following: %s", key));
            }
            available = toEat;
          } else {
            for (ii = i6 + 1; ii < args2.length; ii++) {
              if (!args2[ii].match(/^-[^0-9]/) || args2[ii].match(negative) || isUnknownOptionAsArg(args2[ii]))
                available++;
              else
                break;
            }
            if (available < toEat)
              error2 = Error(__("Not enough arguments following: %s", key));
          }
          let consumed = Math.min(available, toEat);
          if (!isUndefined(argAfterEqualSign) && consumed > 0) {
            setArg(key, argAfterEqualSign);
            consumed--;
          }
          for (ii = i6 + 1; ii < consumed + i6 + 1; ii++) {
            setArg(key, args2[ii]);
          }
          return i6 + consumed;
        }
        __name(eatNargs, "eatNargs");
        function eatArray(i6, key, args2, argAfterEqualSign) {
          let argsToSet = [];
          let next = argAfterEqualSign || args2[i6 + 1];
          const nargsCount = checkAllAliases(key, flags2.nargs);
          if (checkAllAliases(key, flags2.bools) && !/^(true|false)$/.test(next)) {
            argsToSet.push(true);
          } else if (isUndefined(next) || isUndefined(argAfterEqualSign) && /^-/.test(next) && !negative.test(next) && !isUnknownOptionAsArg(next)) {
            if (defaults3[key] !== void 0) {
              const defVal = defaults3[key];
              argsToSet = Array.isArray(defVal) ? defVal : [defVal];
            }
          } else {
            if (!isUndefined(argAfterEqualSign)) {
              argsToSet.push(processValue(key, argAfterEqualSign, true));
            }
            for (let ii = i6 + 1; ii < args2.length; ii++) {
              if (!configuration["greedy-arrays"] && argsToSet.length > 0 || nargsCount && typeof nargsCount === "number" && argsToSet.length >= nargsCount)
                break;
              next = args2[ii];
              if (/^-/.test(next) && !negative.test(next) && !isUnknownOptionAsArg(next))
                break;
              i6 = ii;
              argsToSet.push(processValue(key, next, inputIsString));
            }
          }
          if (typeof nargsCount === "number" && (nargsCount && argsToSet.length < nargsCount || isNaN(nargsCount) && argsToSet.length === 0)) {
            error2 = Error(__("Not enough arguments following: %s", key));
          }
          setArg(key, argsToSet);
          return i6;
        }
        __name(eatArray, "eatArray");
        function setArg(key, val2, shouldStripQuotes = inputIsString) {
          if (/-/.test(key) && configuration["camel-case-expansion"]) {
            const alias = key.split(".").map(function(prop) {
              return camelCase(prop);
            }).join(".");
            addNewAlias(key, alias);
          }
          const value = processValue(key, val2, shouldStripQuotes);
          const splitKey = key.split(".");
          setKey(argv, splitKey, value);
          if (flags2.aliases[key]) {
            flags2.aliases[key].forEach(function(x7) {
              const keyProperties = x7.split(".");
              setKey(argv, keyProperties, value);
            });
          }
          if (splitKey.length > 1 && configuration["dot-notation"]) {
            (flags2.aliases[splitKey[0]] || []).forEach(function(x7) {
              let keyProperties = x7.split(".");
              const a6 = [].concat(splitKey);
              a6.shift();
              keyProperties = keyProperties.concat(a6);
              if (!(flags2.aliases[key] || []).includes(keyProperties.join("."))) {
                setKey(argv, keyProperties, value);
              }
            });
          }
          if (checkAllAliases(key, flags2.normalize) && !checkAllAliases(key, flags2.arrays)) {
            const keys = [key].concat(flags2.aliases[key] || []);
            keys.forEach(function(key2) {
              Object.defineProperty(argvReturn, key2, {
                enumerable: true,
                get() {
                  return val2;
                },
                set(value2) {
                  val2 = typeof value2 === "string" ? mixin.normalize(value2) : value2;
                }
              });
            });
          }
        }
        __name(setArg, "setArg");
        function addNewAlias(key, alias) {
          if (!(flags2.aliases[key] && flags2.aliases[key].length)) {
            flags2.aliases[key] = [alias];
            newAliases[alias] = true;
          }
          if (!(flags2.aliases[alias] && flags2.aliases[alias].length)) {
            addNewAlias(alias, key);
          }
        }
        __name(addNewAlias, "addNewAlias");
        function processValue(key, val2, shouldStripQuotes) {
          if (shouldStripQuotes) {
            val2 = stripQuotes(val2);
          }
          if (checkAllAliases(key, flags2.bools) || checkAllAliases(key, flags2.counts)) {
            if (typeof val2 === "string")
              val2 = val2 === "true";
          }
          let value = Array.isArray(val2) ? val2.map(function(v8) {
            return maybeCoerceNumber(key, v8);
          }) : maybeCoerceNumber(key, val2);
          if (checkAllAliases(key, flags2.counts) && (isUndefined(value) || typeof value === "boolean")) {
            value = increment();
          }
          if (checkAllAliases(key, flags2.normalize) && checkAllAliases(key, flags2.arrays)) {
            if (Array.isArray(val2))
              value = val2.map((val3) => {
                return mixin.normalize(val3);
              });
            else
              value = mixin.normalize(val2);
          }
          return value;
        }
        __name(processValue, "processValue");
        function maybeCoerceNumber(key, value) {
          if (!configuration["parse-positional-numbers"] && key === "_")
            return value;
          if (!checkAllAliases(key, flags2.strings) && !checkAllAliases(key, flags2.bools) && !Array.isArray(value)) {
            const shouldCoerceNumber = looksLikeNumber(value) && configuration["parse-numbers"] && Number.isSafeInteger(Math.floor(parseFloat(`${value}`)));
            if (shouldCoerceNumber || !isUndefined(value) && checkAllAliases(key, flags2.numbers)) {
              value = Number(value);
            }
          }
          return value;
        }
        __name(maybeCoerceNumber, "maybeCoerceNumber");
        function setConfig(argv2) {
          const configLookup = /* @__PURE__ */ Object.create(null);
          applyDefaultsAndAliases(configLookup, flags2.aliases, defaults3);
          Object.keys(flags2.configs).forEach(function(configKey) {
            const configPath = argv2[configKey] || configLookup[configKey];
            if (configPath) {
              try {
                let config = null;
                const resolvedConfigPath = mixin.resolve(mixin.cwd(), configPath);
                const resolveConfig2 = flags2.configs[configKey];
                if (typeof resolveConfig2 === "function") {
                  try {
                    config = resolveConfig2(resolvedConfigPath);
                  } catch (e8) {
                    config = e8;
                  }
                  if (config instanceof Error) {
                    error2 = config;
                    return;
                  }
                } else {
                  config = mixin.require(resolvedConfigPath);
                }
                setConfigObject(config);
              } catch (ex) {
                if (ex.name === "PermissionDenied")
                  error2 = ex;
                else if (argv2[configKey])
                  error2 = Error(__("Invalid JSON config file: %s", configPath));
              }
            }
          });
        }
        __name(setConfig, "setConfig");
        function setConfigObject(config, prev) {
          Object.keys(config).forEach(function(key) {
            const value = config[key];
            const fullKey = prev ? prev + "." + key : key;
            if (typeof value === "object" && value !== null && !Array.isArray(value) && configuration["dot-notation"]) {
              setConfigObject(value, fullKey);
            } else {
              if (!hasKey2(argv, fullKey.split(".")) || checkAllAliases(fullKey, flags2.arrays) && configuration["combine-arrays"]) {
                setArg(fullKey, value);
              }
            }
          });
        }
        __name(setConfigObject, "setConfigObject");
        function setConfigObjects() {
          if (typeof configObjects !== "undefined") {
            configObjects.forEach(function(configObject) {
              setConfigObject(configObject);
            });
          }
        }
        __name(setConfigObjects, "setConfigObjects");
        function applyEnvVars(argv2, configOnly) {
          if (typeof envPrefix === "undefined")
            return;
          const prefix = typeof envPrefix === "string" ? envPrefix : "";
          const env6 = mixin.env();
          Object.keys(env6).forEach(function(envVar) {
            if (prefix === "" || envVar.lastIndexOf(prefix, 0) === 0) {
              const keys = envVar.split("__").map(function(key, i6) {
                if (i6 === 0) {
                  key = key.substring(prefix.length);
                }
                return camelCase(key);
              });
              if ((configOnly && flags2.configs[keys.join(".")] || !configOnly) && !hasKey2(argv2, keys)) {
                setArg(keys.join("."), env6[envVar]);
              }
            }
          });
        }
        __name(applyEnvVars, "applyEnvVars");
        function applyCoercions(argv2) {
          let coerce4;
          const applied = /* @__PURE__ */ new Set();
          Object.keys(argv2).forEach(function(key) {
            if (!applied.has(key)) {
              coerce4 = checkAllAliases(key, flags2.coercions);
              if (typeof coerce4 === "function") {
                try {
                  const value = maybeCoerceNumber(key, coerce4(argv2[key]));
                  [].concat(flags2.aliases[key] || [], key).forEach((ali) => {
                    applied.add(ali);
                    argv2[ali] = value;
                  });
                } catch (err) {
                  error2 = err;
                }
              }
            }
          });
        }
        __name(applyCoercions, "applyCoercions");
        function setPlaceholderKeys(argv2) {
          flags2.keys.forEach((key) => {
            if (~key.indexOf("."))
              return;
            if (typeof argv2[key] === "undefined")
              argv2[key] = void 0;
          });
          return argv2;
        }
        __name(setPlaceholderKeys, "setPlaceholderKeys");
        function applyDefaultsAndAliases(obj, aliases3, defaults4, canLog = false) {
          Object.keys(defaults4).forEach(function(key) {
            if (!hasKey2(obj, key.split("."))) {
              setKey(obj, key.split("."), defaults4[key]);
              if (canLog)
                defaulted[key] = true;
              (aliases3[key] || []).forEach(function(x7) {
                if (hasKey2(obj, x7.split(".")))
                  return;
                setKey(obj, x7.split("."), defaults4[key]);
              });
            }
          });
        }
        __name(applyDefaultsAndAliases, "applyDefaultsAndAliases");
        function hasKey2(obj, keys) {
          let o6 = obj;
          if (!configuration["dot-notation"])
            keys = [keys.join(".")];
          keys.slice(0, -1).forEach(function(key2) {
            o6 = o6[key2] || {};
          });
          const key = keys[keys.length - 1];
          if (typeof o6 !== "object")
            return false;
          else
            return key in o6;
        }
        __name(hasKey2, "hasKey");
        function setKey(obj, keys, value) {
          let o6 = obj;
          if (!configuration["dot-notation"])
            keys = [keys.join(".")];
          keys.slice(0, -1).forEach(function(key2) {
            key2 = sanitizeKey(key2);
            if (typeof o6 === "object" && o6[key2] === void 0) {
              o6[key2] = {};
            }
            if (typeof o6[key2] !== "object" || Array.isArray(o6[key2])) {
              if (Array.isArray(o6[key2])) {
                o6[key2].push({});
              } else {
                o6[key2] = [o6[key2], {}];
              }
              o6 = o6[key2][o6[key2].length - 1];
            } else {
              o6 = o6[key2];
            }
          });
          const key = sanitizeKey(keys[keys.length - 1]);
          const isTypeArray = checkAllAliases(keys.join("."), flags2.arrays);
          const isValueArray = Array.isArray(value);
          let duplicate = configuration["duplicate-arguments-array"];
          if (!duplicate && checkAllAliases(key, flags2.nargs)) {
            duplicate = true;
            if (!isUndefined(o6[key]) && flags2.nargs[key] === 1 || Array.isArray(o6[key]) && o6[key].length === flags2.nargs[key]) {
              o6[key] = void 0;
            }
          }
          if (value === increment()) {
            o6[key] = increment(o6[key]);
          } else if (Array.isArray(o6[key])) {
            if (duplicate && isTypeArray && isValueArray) {
              o6[key] = configuration["flatten-duplicate-arrays"] ? o6[key].concat(value) : (Array.isArray(o6[key][0]) ? o6[key] : [o6[key]]).concat([value]);
            } else if (!duplicate && Boolean(isTypeArray) === Boolean(isValueArray)) {
              o6[key] = value;
            } else {
              o6[key] = o6[key].concat([value]);
            }
          } else if (o6[key] === void 0 && isTypeArray) {
            o6[key] = isValueArray ? value : [value];
          } else if (duplicate && !(o6[key] === void 0 || checkAllAliases(key, flags2.counts) || checkAllAliases(key, flags2.bools))) {
            o6[key] = [o6[key], value];
          } else {
            o6[key] = value;
          }
        }
        __name(setKey, "setKey");
        function extendAliases(...args2) {
          args2.forEach(function(obj) {
            Object.keys(obj || {}).forEach(function(key) {
              if (flags2.aliases[key])
                return;
              flags2.aliases[key] = [].concat(aliases2[key] || []);
              flags2.aliases[key].concat(key).forEach(function(x7) {
                if (/-/.test(x7) && configuration["camel-case-expansion"]) {
                  const c7 = camelCase(x7);
                  if (c7 !== key && flags2.aliases[key].indexOf(c7) === -1) {
                    flags2.aliases[key].push(c7);
                    newAliases[c7] = true;
                  }
                }
              });
              flags2.aliases[key].concat(key).forEach(function(x7) {
                if (x7.length > 1 && /[A-Z]/.test(x7) && configuration["camel-case-expansion"]) {
                  const c7 = decamelize(x7, "-");
                  if (c7 !== key && flags2.aliases[key].indexOf(c7) === -1) {
                    flags2.aliases[key].push(c7);
                    newAliases[c7] = true;
                  }
                }
              });
              flags2.aliases[key].forEach(function(x7) {
                flags2.aliases[x7] = [key].concat(flags2.aliases[key].filter(function(y5) {
                  return x7 !== y5;
                }));
              });
            });
          });
        }
        __name(extendAliases, "extendAliases");
        function checkAllAliases(key, flag) {
          const toCheck = [].concat(flags2.aliases[key] || [], key);
          const keys = Object.keys(flag);
          const setAlias = toCheck.find((key2) => keys.includes(key2));
          return setAlias ? flag[setAlias] : false;
        }
        __name(checkAllAliases, "checkAllAliases");
        function hasAnyFlag(key) {
          const flagsKeys = Object.keys(flags2);
          const toCheck = [].concat(flagsKeys.map((k7) => flags2[k7]));
          return toCheck.some(function(flag) {
            return Array.isArray(flag) ? flag.includes(key) : flag[key];
          });
        }
        __name(hasAnyFlag, "hasAnyFlag");
        function hasFlagsMatching(arg, ...patterns) {
          const toCheck = [].concat(...patterns);
          return toCheck.some(function(pattern) {
            const match3 = arg.match(pattern);
            return match3 && hasAnyFlag(match3[1]);
          });
        }
        __name(hasFlagsMatching, "hasFlagsMatching");
        function hasAllShortFlags(arg) {
          if (arg.match(negative) || !arg.match(/^-[^-]+/)) {
            return false;
          }
          let hasAllFlags = true;
          let next;
          const letters = arg.slice(1).split("");
          for (let j7 = 0; j7 < letters.length; j7++) {
            next = arg.slice(j7 + 2);
            if (!hasAnyFlag(letters[j7])) {
              hasAllFlags = false;
              break;
            }
            if (letters[j7 + 1] && letters[j7 + 1] === "=" || next === "-" || /[A-Za-z]/.test(letters[j7]) && /^-?\d+(\.\d*)?(e-?\d+)?$/.test(next) || letters[j7 + 1] && letters[j7 + 1].match(/\W/)) {
              break;
            }
          }
          return hasAllFlags;
        }
        __name(hasAllShortFlags, "hasAllShortFlags");
        function isUnknownOptionAsArg(arg) {
          return configuration["unknown-options-as-args"] && isUnknownOption(arg);
        }
        __name(isUnknownOptionAsArg, "isUnknownOptionAsArg");
        function isUnknownOption(arg) {
          arg = arg.replace(/^-{3,}/, "--");
          if (arg.match(negative)) {
            return false;
          }
          if (hasAllShortFlags(arg)) {
            return false;
          }
          const flagWithEquals = /^-+([^=]+?)=[\s\S]*$/;
          const normalFlag = /^-+([^=]+?)$/;
          const flagEndingInHyphen = /^-+([^=]+?)-$/;
          const flagEndingInDigits = /^-+([^=]+?\d+)$/;
          const flagEndingInNonWordCharacters = /^-+([^=]+?)\W+.*$/;
          return !hasFlagsMatching(arg, flagWithEquals, negatedBoolean, normalFlag, flagEndingInHyphen, flagEndingInDigits, flagEndingInNonWordCharacters);
        }
        __name(isUnknownOption, "isUnknownOption");
        function defaultValue(key) {
          if (!checkAllAliases(key, flags2.bools) && !checkAllAliases(key, flags2.counts) && `${key}` in defaults3) {
            return defaults3[key];
          } else {
            return defaultForType(guessType2(key));
          }
        }
        __name(defaultValue, "defaultValue");
        function defaultForType(type) {
          const def = {
            [DefaultValuesForTypeKey.BOOLEAN]: true,
            [DefaultValuesForTypeKey.STRING]: "",
            [DefaultValuesForTypeKey.NUMBER]: void 0,
            [DefaultValuesForTypeKey.ARRAY]: []
          };
          return def[type];
        }
        __name(defaultForType, "defaultForType");
        function guessType2(key) {
          let type = DefaultValuesForTypeKey.BOOLEAN;
          if (checkAllAliases(key, flags2.strings))
            type = DefaultValuesForTypeKey.STRING;
          else if (checkAllAliases(key, flags2.numbers))
            type = DefaultValuesForTypeKey.NUMBER;
          else if (checkAllAliases(key, flags2.bools))
            type = DefaultValuesForTypeKey.BOOLEAN;
          else if (checkAllAliases(key, flags2.arrays))
            type = DefaultValuesForTypeKey.ARRAY;
          return type;
        }
        __name(guessType2, "guessType");
        function isUndefined(num) {
          return num === void 0;
        }
        __name(isUndefined, "isUndefined");
        function checkConfiguration() {
          Object.keys(flags2.counts).find((key) => {
            if (checkAllAliases(key, flags2.arrays)) {
              error2 = Error(__("Invalid configuration: %s, opts.count excludes opts.array.", key));
              return true;
            } else if (checkAllAliases(key, flags2.nargs)) {
              error2 = Error(__("Invalid configuration: %s, opts.count excludes opts.narg.", key));
              return true;
            }
            return false;
          });
        }
        __name(checkConfiguration, "checkConfiguration");
        return {
          aliases: Object.assign({}, flags2.aliases),
          argv: Object.assign(argvReturn, argv),
          configuration,
          defaulted: Object.assign({}, defaulted),
          error: error2,
          newAliases: Object.assign({}, newAliases)
        };
      }
    };
    __name(combineAliases, "combineAliases");
    __name(increment, "increment");
    __name(sanitizeKey, "sanitizeKey");
    __name(stripQuotes, "stripQuotes");
  }
});
var _a, _b, _c, minNodeVersion, nodeVersion, env, parser, yargsParser, lib_default;
var init_lib = __esm({
  "../../node_modules/.pnpm/yargs-parser@21.1.1/node_modules/yargs-parser/build/lib/index.js"() {
    init_import_meta_url();
    init_string_utils();
    init_yargs_parser();
    minNodeVersion = process && process.env && process.env.YARGS_MIN_NODE_VERSION ? Number(process.env.YARGS_MIN_NODE_VERSION) : 12;
    nodeVersion = (_b = (_a = process === null || process === void 0 ? void 0 : process.versions) === null || _a === void 0 ? void 0 : _a.node) !== null && _b !== void 0 ? _b : (_c = process === null || process === void 0 ? void 0 : process.version) === null || _c === void 0 ? void 0 : _c.slice(1);
    if (nodeVersion) {
      const major = Number(nodeVersion.match(/^([^.]+)/)[1]);
      if (major < minNodeVersion) {
        throw Error(`yargs parser supports a minimum Node.js version of ${minNodeVersion}. Read our version support policy: https://github.com/yargs/yargs-parser#supported-nodejs-versions`);
      }
    }
    env = process ? process.env : {};
    parser = new YargsParser({
      cwd: process.cwd,
      env: /* @__PURE__ */ __name(() => {
        return env;
      }, "env"),
      format: util2.format,
      normalize: path5.normalize,
      resolve: path5.resolve,
      // TODO: figure  out a  way to combine ESM and CJS coverage, such  that
      // we can exercise all the lines below:
      require: /* @__PURE__ */ __name((path77) => {
        if (typeof __require !== "undefined") {
          return __require(path77);
        } else if (path77.match(/\.json$/)) {
          return JSON.parse(fs25.readFileSync(path77, "utf8"));
        } else {
          throw Error("only .json config files are supported in ESM");
        }
      }, "require")
    });
    yargsParser = /* @__PURE__ */ __name(function Parser(args, opts) {
      const result = parser.parse(args.slice(), opts);
      return result.argv;
    }, "Parser");
    yargsParser.detailed = function(args, opts) {
      return parser.parse(args.slice(), opts);
    };
    yargsParser.camelCase = camelCase;
    yargsParser.decamelize = decamelize;
    yargsParser.looksLikeNumber = looksLikeNumber;
    lib_default = yargsParser;
  }
});

// ../../node_modules/.pnpm/cliui@8.0.1/node_modules/cliui/build/lib/index.js
function addBorder(col, ts, style) {
  if (col.border) {
    if (/[.']-+[.']/.test(ts)) {
      return "";
    }
    if (ts.trim().length !== 0) {
      return style;
    }
    return "  ";
  }
  return "";
}
function _minWidth(col) {
  const padding = col.padding || [];
  const minWidth = 1 + (padding[left] || 0) + (padding[right] || 0);
  if (col.border) {
    return minWidth + 4;
  }
  return minWidth;
}
function getWindowWidth() {
  if (typeof process === "object" && process.stdout && process.stdout.columns) {
    return process.stdout.columns;
  }
  return 80;
}
function alignRight(str, width) {
  str = str.trim();
  const strWidth = mixin2.stringWidth(str);
  if (strWidth < width) {
    return " ".repeat(width - strWidth) + str;
  }
  return str;
}
function alignCenter(str, width) {
  str = str.trim();
  const strWidth = mixin2.stringWidth(str);
  if (strWidth >= width) {
    return str;
  }
  return " ".repeat(width - strWidth >> 1) + str;
}
function cliui(opts, _mixin) {
  mixin2 = _mixin;
  return new UI({
    width: (opts === null || opts === void 0 ? void 0 : opts.width) || getWindowWidth(),
    wrap: opts === null || opts === void 0 ? void 0 : opts.wrap
  });
}
var align, top, right, bottom, left, UI, mixin2;
var init_lib2 = __esm({
  "../../node_modules/.pnpm/cliui@8.0.1/node_modules/cliui/build/lib/index.js"() {
    init_import_meta_url();
    align = {
      right: alignRight,
      center: alignCenter
    };
    top = 0;
    right = 1;
    bottom = 2;
    left = 3;
    UI = class {
      static {
        __name(this, "UI");
      }
      constructor(opts) {
        var _a5;
        this.width = opts.width;
        this.wrap = (_a5 = opts.wrap) !== null && _a5 !== void 0 ? _a5 : true;
        this.rows = [];
      }
      span(...args) {
        const cols = this.div(...args);
        cols.span = true;
      }
      resetOutput() {
        this.rows = [];
      }
      div(...args) {
        if (args.length === 0) {
          this.div("");
        }
        if (this.wrap && this.shouldApplyLayoutDSL(...args) && typeof args[0] === "string") {
          return this.applyLayoutDSL(args[0]);
        }
        const cols = args.map((arg) => {
          if (typeof arg === "string") {
            return this.colFromString(arg);
          }
          return arg;
        });
        this.rows.push(cols);
        return cols;
      }
      shouldApplyLayoutDSL(...args) {
        return args.length === 1 && typeof args[0] === "string" && /[\t\n]/.test(args[0]);
      }
      applyLayoutDSL(str) {
        const rows = str.split("\n").map((row) => row.split("	"));
        let leftColumnWidth = 0;
        rows.forEach((columns) => {
          if (columns.length > 1 && mixin2.stringWidth(columns[0]) > leftColumnWidth) {
            leftColumnWidth = Math.min(Math.floor(this.width * 0.5), mixin2.stringWidth(columns[0]));
          }
        });
        rows.forEach((columns) => {
          this.div(...columns.map((r8, i6) => {
            return {
              text: r8.trim(),
              padding: this.measurePadding(r8),
              width: i6 === 0 && columns.length > 1 ? leftColumnWidth : void 0
            };
          }));
        });
        return this.rows[this.rows.length - 1];
      }
      colFromString(text) {
        return {
          text,
          padding: this.measurePadding(text)
        };
      }
      measurePadding(str) {
        const noAnsi = mixin2.stripAnsi(str);
        return [0, noAnsi.match(/\s*$/)[0].length, 0, noAnsi.match(/^\s*/)[0].length];
      }
      toString() {
        const lines = [];
        this.rows.forEach((row) => {
          this.rowToString(row, lines);
        });
        return lines.filter((line) => !line.hidden).map((line) => line.text).join("\n");
      }
      rowToString(row, lines) {
        this.rasterize(row).forEach((rrow, r8) => {
          let str = "";
          rrow.forEach((col, c7) => {
            const { width } = row[c7];
            const wrapWidth = this.negatePadding(row[c7]);
            let ts = col;
            if (wrapWidth > mixin2.stringWidth(col)) {
              ts += " ".repeat(wrapWidth - mixin2.stringWidth(col));
            }
            if (row[c7].align && row[c7].align !== "left" && this.wrap) {
              const fn2 = align[row[c7].align];
              ts = fn2(ts, wrapWidth);
              if (mixin2.stringWidth(ts) < wrapWidth) {
                ts += " ".repeat((width || 0) - mixin2.stringWidth(ts) - 1);
              }
            }
            const padding = row[c7].padding || [0, 0, 0, 0];
            if (padding[left]) {
              str += " ".repeat(padding[left]);
            }
            str += addBorder(row[c7], ts, "| ");
            str += ts;
            str += addBorder(row[c7], ts, " |");
            if (padding[right]) {
              str += " ".repeat(padding[right]);
            }
            if (r8 === 0 && lines.length > 0) {
              str = this.renderInline(str, lines[lines.length - 1]);
            }
          });
          lines.push({
            text: str.replace(/ +$/, ""),
            span: row.span
          });
        });
        return lines;
      }
      // if the full 'source' can render in
      // the target line, do so.
      renderInline(source, previousLine) {
        const match3 = source.match(/^ */);
        const leadingWhitespace = match3 ? match3[0].length : 0;
        const target = previousLine.text;
        const targetTextWidth = mixin2.stringWidth(target.trimRight());
        if (!previousLine.span) {
          return source;
        }
        if (!this.wrap) {
          previousLine.hidden = true;
          return target + source;
        }
        if (leadingWhitespace < targetTextWidth) {
          return source;
        }
        previousLine.hidden = true;
        return target.trimRight() + " ".repeat(leadingWhitespace - targetTextWidth) + source.trimLeft();
      }
      rasterize(row) {
        const rrows = [];
        const widths = this.columnWidths(row);
        let wrapped;
        row.forEach((col, c7) => {
          col.width = widths[c7];
          if (this.wrap) {
            wrapped = mixin2.wrap(col.text, this.negatePadding(col), { hard: true }).split("\n");
          } else {
            wrapped = col.text.split("\n");
          }
          if (col.border) {
            wrapped.unshift("." + "-".repeat(this.negatePadding(col) + 2) + ".");
            wrapped.push("'" + "-".repeat(this.negatePadding(col) + 2) + "'");
          }
          if (col.padding) {
            wrapped.unshift(...new Array(col.padding[top] || 0).fill(""));
            wrapped.push(...new Array(col.padding[bottom] || 0).fill(""));
          }
          wrapped.forEach((str, r8) => {
            if (!rrows[r8]) {
              rrows.push([]);
            }
            const rrow = rrows[r8];
            for (let i6 = 0; i6 < c7; i6++) {
              if (rrow[i6] === void 0) {
                rrow.push("");
              }
            }
            rrow.push(str);
          });
        });
        return rrows;
      }
      negatePadding(col) {
        let wrapWidth = col.width || 0;
        if (col.padding) {
          wrapWidth -= (col.padding[left] || 0) + (col.padding[right] || 0);
        }
        if (col.border) {
          wrapWidth -= 4;
        }
        return wrapWidth;
      }
      columnWidths(row) {
        if (!this.wrap) {
          return row.map((col) => {
            return col.width || mixin2.stringWidth(col.text);
          });
        }
        let unset = row.length;
        let remainingWidth = this.width;
        const widths = row.map((col) => {
          if (col.width) {
            unset--;
            remainingWidth -= col.width;
            return col.width;
          }
          return void 0;
        });
        const unsetWidth = unset ? Math.floor(remainingWidth / unset) : 0;
        return widths.map((w7, i6) => {
          if (w7 === void 0) {
            return Math.max(unsetWidth, _minWidth(row[i6]));
          }
          return w7;
        });
      }
    };
    __name(addBorder, "addBorder");
    __name(_minWidth, "_minWidth");
    __name(getWindowWidth, "getWindowWidth");
    __name(alignRight, "alignRight");
    __name(alignCenter, "alignCenter");
    __name(cliui, "cliui");
  }
});

// ../../node_modules/.pnpm/cliui@8.0.1/node_modules/cliui/build/lib/string-utils.js
function stripAnsi(str) {
  return str.replace(ansi, "");
}
function wrap(str, width) {
  const [start, end] = str.match(ansi) || ["", ""];
  str = stripAnsi(str);
  let wrapped = "";
  for (let i6 = 0; i6 < str.length; i6++) {
    if (i6 !== 0 && i6 % width === 0) {
      wrapped += "\n";
    }
    wrapped += str.charAt(i6);
  }
  if (start && end) {
    wrapped = `${start}${wrapped}${end}`;
  }
  return wrapped;
}
var ansi;
var init_string_utils2 = __esm({
  "../../node_modules/.pnpm/cliui@8.0.1/node_modules/cliui/build/lib/string-utils.js"() {
    init_import_meta_url();
    ansi = new RegExp("\x1B(?:\\[(?:\\d+[ABCDEFGJKSTm]|\\d+;\\d+[Hfm]|\\d+;\\d+;\\d+m|6n|s|u|\\?25[lh])|\\w)", "g");
    __name(stripAnsi, "stripAnsi");
    __name(wrap, "wrap");
  }
});

// ../../node_modules/.pnpm/cliui@8.0.1/node_modules/cliui/index.mjs
function ui(opts) {
  return cliui(opts, {
    stringWidth: /* @__PURE__ */ __name((str) => {
      return [...str].length;
    }, "stringWidth"),
    stripAnsi,
    wrap
  });
}
var init_cliui = __esm({
  "../../node_modules/.pnpm/cliui@8.0.1/node_modules/cliui/index.mjs"() {
    init_import_meta_url();
    init_lib2();
    init_string_utils2();
    __name(ui, "ui");
  }
});
function sync_default(start, callback) {
  let dir = path5.resolve(".", start);
  let tmp, stats = fs25.statSync(dir);
  if (!stats.isDirectory()) {
    dir = path5.dirname(dir);
  }
  while (true) {
    tmp = callback(dir, fs25.readdirSync(dir));
    if (tmp) return path5.resolve(dir, tmp);
    dir = path5.dirname(tmp = dir);
    if (tmp === dir) break;
  }
}
var init_sync = __esm({
  "../../node_modules/.pnpm/escalade@3.2.0/node_modules/escalade/sync/index.mjs"() {
    init_import_meta_url();
    __name(sync_default, "default");
  }
});
var node_default;
var init_node = __esm({
  "../../node_modules/.pnpm/y18n@5.0.8/node_modules/y18n/build/lib/platform-shims/node.js"() {
    init_import_meta_url();
    node_default = {
      fs: {
        readFileSync: fs25.readFileSync,
        writeFile: fs25.writeFile
      },
      format: util2.format,
      resolve: path5.resolve,
      exists: /* @__PURE__ */ __name((file) => {
        try {
          return fs25.statSync(file).isFile();
        } catch (err) {
          return false;
        }
      }, "exists")
    };
  }
});

// ../../node_modules/.pnpm/y18n@5.0.8/node_modules/y18n/build/lib/index.js
function y18n(opts, _shim) {
  shim2 = _shim;
  const y18n3 = new Y18N(opts);
  return {
    __: y18n3.__.bind(y18n3),
    __n: y18n3.__n.bind(y18n3),
    setLocale: y18n3.setLocale.bind(y18n3),
    getLocale: y18n3.getLocale.bind(y18n3),
    updateLocale: y18n3.updateLocale.bind(y18n3),
    locale: y18n3.locale
  };
}
var shim2, Y18N;
var init_lib3 = __esm({
  "../../node_modules/.pnpm/y18n@5.0.8/node_modules/y18n/build/lib/index.js"() {
    init_import_meta_url();
    Y18N = class {
      static {
        __name(this, "Y18N");
      }
      constructor(opts) {
        opts = opts || {};
        this.directory = opts.directory || "./locales";
        this.updateFiles = typeof opts.updateFiles === "boolean" ? opts.updateFiles : true;
        this.locale = opts.locale || "en";
        this.fallbackToLanguage = typeof opts.fallbackToLanguage === "boolean" ? opts.fallbackToLanguage : true;
        this.cache = /* @__PURE__ */ Object.create(null);
        this.writeQueue = [];
      }
      __(...args) {
        if (typeof arguments[0] !== "string") {
          return this._taggedLiteral(arguments[0], ...arguments);
        }
        const str = args.shift();
        let cb2 = /* @__PURE__ */ __name(function() {
        }, "cb");
        if (typeof args[args.length - 1] === "function")
          cb2 = args.pop();
        cb2 = cb2 || function() {
        };
        if (!this.cache[this.locale])
          this._readLocaleFile();
        if (!this.cache[this.locale][str] && this.updateFiles) {
          this.cache[this.locale][str] = str;
          this._enqueueWrite({
            directory: this.directory,
            locale: this.locale,
            cb: cb2
          });
        } else {
          cb2();
        }
        return shim2.format.apply(shim2.format, [this.cache[this.locale][str] || str].concat(args));
      }
      __n() {
        const args = Array.prototype.slice.call(arguments);
        const singular = args.shift();
        const plural2 = args.shift();
        const quantity = args.shift();
        let cb2 = /* @__PURE__ */ __name(function() {
        }, "cb");
        if (typeof args[args.length - 1] === "function")
          cb2 = args.pop();
        if (!this.cache[this.locale])
          this._readLocaleFile();
        let str = quantity === 1 ? singular : plural2;
        if (this.cache[this.locale][singular]) {
          const entry = this.cache[this.locale][singular];
          str = entry[quantity === 1 ? "one" : "other"];
        }
        if (!this.cache[this.locale][singular] && this.updateFiles) {
          this.cache[this.locale][singular] = {
            one: singular,
            other: plural2
          };
          this._enqueueWrite({
            directory: this.directory,
            locale: this.locale,
            cb: cb2
          });
        } else {
          cb2();
        }
        const values = [str];
        if (~str.indexOf("%d"))
          values.push(quantity);
        return shim2.format.apply(shim2.format, values.concat(args));
      }
      setLocale(locale) {
        this.locale = locale;
      }
      getLocale() {
        return this.locale;
      }
      updateLocale(obj) {
        if (!this.cache[this.locale])
          this._readLocaleFile();
        for (const key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            this.cache[this.locale][key] = obj[key];
          }
        }
      }
      _taggedLiteral(parts, ...args) {
        let str = "";
        parts.forEach(function(part, i6) {
          const arg = args[i6 + 1];
          str += part;
          if (typeof arg !== "undefined") {
            str += "%s";
          }
        });
        return this.__.apply(this, [str].concat([].slice.call(args, 1)));
      }
      _enqueueWrite(work) {
        this.writeQueue.push(work);
        if (this.writeQueue.length === 1)
          this._processWriteQueue();
      }
      _processWriteQueue() {
        const _this = this;
        const work = this.writeQueue[0];
        const directory = work.directory;
        const locale = work.locale;
        const cb2 = work.cb;
        const languageFile = this._resolveLocaleFile(directory, locale);
        const serializedLocale = JSON.stringify(this.cache[locale], null, 2);
        shim2.fs.writeFile(languageFile, serializedLocale, "utf-8", function(err) {
          _this.writeQueue.shift();
          if (_this.writeQueue.length > 0)
            _this._processWriteQueue();
          cb2(err);
        });
      }
      _readLocaleFile() {
        let localeLookup = {};
        const languageFile = this._resolveLocaleFile(this.directory, this.locale);
        try {
          if (shim2.fs.readFileSync) {
            localeLookup = JSON.parse(shim2.fs.readFileSync(languageFile, "utf-8"));
          }
        } catch (err) {
          if (err instanceof SyntaxError) {
            err.message = "syntax error in " + languageFile;
          }
          if (err.code === "ENOENT")
            localeLookup = {};
          else
            throw err;
        }
        this.cache[this.locale] = localeLookup;
      }
      _resolveLocaleFile(directory, locale) {
        let file = shim2.resolve(directory, "./", locale + ".json");
        if (this.fallbackToLanguage && !this._fileExistsSync(file) && ~locale.lastIndexOf("_")) {
          const languageFile = shim2.resolve(directory, "./", locale.split("_")[0] + ".json");
          if (this._fileExistsSync(languageFile))
            file = languageFile;
        }
        return file;
      }
      _fileExistsSync(file) {
        return shim2.exists(file);
      }
    };
    __name(y18n, "y18n");
  }
});

// ../../node_modules/.pnpm/y18n@5.0.8/node_modules/y18n/index.mjs
var y18n2, y18n_default;
var init_y18n = __esm({
  "../../node_modules/.pnpm/y18n@5.0.8/node_modules/y18n/index.mjs"() {
    init_import_meta_url();
    init_node();
    init_lib3();
    y18n2 = /* @__PURE__ */ __name((opts) => {
      return y18n(opts, node_default);
    }, "y18n");
    y18n_default = y18n2;
  }
});
var REQUIRE_ERROR, REQUIRE_DIRECTORY_ERROR, __dirname2, mainFilename, esm_default2;
var init_esm = __esm({
  "../../node_modules/.pnpm/yargs@17.7.2/node_modules/yargs/lib/platform-shims/esm.mjs"() {
    init_import_meta_url();
    init_cliui();
    init_sync();
    init_lib();
    init_process_argv();
    init_yerror();
    init_y18n();
    REQUIRE_ERROR = "require is not supported by ESM";
    REQUIRE_DIRECTORY_ERROR = "loading a directory of commands is not supported yet for ESM";
    try {
      __dirname2 = Url.fileURLToPath(import_meta_url);
    } catch (e8) {
      __dirname2 = process.cwd();
    }
    mainFilename = __dirname2.substring(0, __dirname2.lastIndexOf("node_modules"));
    esm_default2 = {
      assert: {
        notStrictEqual: assert40.notStrictEqual,
        strictEqual: assert40.strictEqual
      },
      cliui: ui,
      findUp: sync_default,
      getEnv: /* @__PURE__ */ __name((key) => {
        return process.env[key];
      }, "getEnv"),
      inspect: util2.inspect,
      getCallerFile: /* @__PURE__ */ __name(() => {
        throw new YError(REQUIRE_DIRECTORY_ERROR);
      }, "getCallerFile"),
      getProcessArgvBin,
      mainFilename: mainFilename || process.cwd(),
      Parser: lib_default,
      path: {
        basename: path5.basename,
        dirname: path5.dirname,
        extname: path5.extname,
        relative: path5.relative,
        resolve: path5.resolve
      },
      process: {
        argv: /* @__PURE__ */ __name(() => process.argv, "argv"),
        cwd: process.cwd,
        emitWarning: /* @__PURE__ */ __name((warning, type) => process.emitWarning(warning, type), "emitWarning"),
        execPath: /* @__PURE__ */ __name(() => process.execPath, "execPath"),
        exit: process.exit,
        nextTick: process.nextTick,
        stdColumns: typeof process.stdout.columns !== "undefined" ? process.stdout.columns : null
      },
      readFileSync: fs25.readFileSync,
      require: /* @__PURE__ */ __name(() => {
        throw new YError(REQUIRE_ERROR);
      }, "require"),
      requireDirectory: /* @__PURE__ */ __name(() => {
        throw new YError(REQUIRE_DIRECTORY_ERROR);
      }, "requireDirectory"),
      stringWidth: /* @__PURE__ */ __name((str) => {
        return [...str].length;
      }, "stringWidth"),
      y18n: y18n_default({
        directory: path5.resolve(__dirname2, "../../../locales"),
        updateFiles: false
      })
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/symbols.js
var require_symbols = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/symbols.js"(exports2, module3) {
    init_import_meta_url();
    module3.exports = {
      kClose: Symbol("close"),
      kDestroy: Symbol("destroy"),
      kDispatch: Symbol("dispatch"),
      kUrl: Symbol("url"),
      kWriting: Symbol("writing"),
      kResuming: Symbol("resuming"),
      kQueue: Symbol("queue"),
      kConnect: Symbol("connect"),
      kConnecting: Symbol("connecting"),
      kKeepAliveDefaultTimeout: Symbol("default keep alive timeout"),
      kKeepAliveMaxTimeout: Symbol("max keep alive timeout"),
      kKeepAliveTimeoutThreshold: Symbol("keep alive timeout threshold"),
      kKeepAliveTimeoutValue: Symbol("keep alive timeout"),
      kKeepAlive: Symbol("keep alive"),
      kHeadersTimeout: Symbol("headers timeout"),
      kBodyTimeout: Symbol("body timeout"),
      kServerName: Symbol("server name"),
      kLocalAddress: Symbol("local address"),
      kHost: Symbol("host"),
      kNoRef: Symbol("no ref"),
      kBodyUsed: Symbol("used"),
      kBody: Symbol("abstracted request body"),
      kRunning: Symbol("running"),
      kBlocking: Symbol("blocking"),
      kPending: Symbol("pending"),
      kSize: Symbol("size"),
      kBusy: Symbol("busy"),
      kQueued: Symbol("queued"),
      kFree: Symbol("free"),
      kConnected: Symbol("connected"),
      kClosed: Symbol("closed"),
      kNeedDrain: Symbol("need drain"),
      kReset: Symbol("reset"),
      kDestroyed: Symbol.for("nodejs.stream.destroyed"),
      kResume: Symbol("resume"),
      kOnError: Symbol("on error"),
      kMaxHeadersSize: Symbol("max headers size"),
      kRunningIdx: Symbol("running index"),
      kPendingIdx: Symbol("pending index"),
      kError: Symbol("error"),
      kClients: Symbol("clients"),
      kClient: Symbol("client"),
      kParser: Symbol("parser"),
      kOnDestroyed: Symbol("destroy callbacks"),
      kPipelining: Symbol("pipelining"),
      kSocket: Symbol("socket"),
      kHostHeader: Symbol("host header"),
      kConnector: Symbol("connector"),
      kStrictContentLength: Symbol("strict content length"),
      kMaxRedirections: Symbol("maxRedirections"),
      kMaxRequests: Symbol("maxRequestsPerClient"),
      kProxy: Symbol("proxy agent options"),
      kCounter: Symbol("socket request counter"),
      kMaxResponseSize: Symbol("max response size"),
      kHTTP2Session: Symbol("http2Session"),
      kHTTP2SessionState: Symbol("http2Session state"),
      kRetryHandlerDefaultRetry: Symbol("retry agent default retry"),
      kConstruct: Symbol("constructable"),
      kListeners: Symbol("listeners"),
      kHTTPContext: Symbol("http context"),
      kMaxConcurrentStreams: Symbol("max concurrent streams"),
      kNoProxyAgent: Symbol("no proxy agent"),
      kHttpProxyAgent: Symbol("http proxy agent"),
      kHttpsProxyAgent: Symbol("https proxy agent")
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/util/timers.js
var require_timers = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/util/timers.js"(exports2, module3) {
    init_import_meta_url();
    var fastNow = 0;
    var RESOLUTION_MS = 1e3;
    var TICK_MS = (RESOLUTION_MS >> 1) - 1;
    var fastNowTimeout;
    var kFastTimer = Symbol("kFastTimer");
    var fastTimers = [];
    var NOT_IN_LIST = -2;
    var TO_BE_CLEARED = -1;
    var PENDING = 0;
    var ACTIVE = 1;
    function onTick() {
      fastNow += TICK_MS;
      let idx = 0;
      let len = fastTimers.length;
      while (idx < len) {
        const timer = fastTimers[idx];
        if (timer._state === PENDING) {
          timer._idleStart = fastNow - TICK_MS;
          timer._state = ACTIVE;
        } else if (timer._state === ACTIVE && fastNow >= timer._idleStart + timer._idleTimeout) {
          timer._state = TO_BE_CLEARED;
          timer._idleStart = -1;
          timer._onTimeout(timer._timerArg);
        }
        if (timer._state === TO_BE_CLEARED) {
          timer._state = NOT_IN_LIST;
          if (--len !== 0) {
            fastTimers[idx] = fastTimers[len];
          }
        } else {
          ++idx;
        }
      }
      fastTimers.length = len;
      if (fastTimers.length !== 0) {
        refreshTimeout();
      }
    }
    __name(onTick, "onTick");
    function refreshTimeout() {
      if (fastNowTimeout?.refresh) {
        fastNowTimeout.refresh();
      } else {
        clearTimeout(fastNowTimeout);
        fastNowTimeout = setTimeout(onTick, TICK_MS);
        fastNowTimeout?.unref();
      }
    }
    __name(refreshTimeout, "refreshTimeout");
    var FastTimer = class {
      static {
        __name(this, "FastTimer");
      }
      [kFastTimer] = true;
      /**
       * The state of the timer, which can be one of the following:
       * - NOT_IN_LIST (-2)
       * - TO_BE_CLEARED (-1)
       * - PENDING (0)
       * - ACTIVE (1)
       *
       * @type {-2|-1|0|1}
       * @private
       */
      _state = NOT_IN_LIST;
      /**
       * The number of milliseconds to wait before calling the callback.
       *
       * @type {number}
       * @private
       */
      _idleTimeout = -1;
      /**
       * The time in milliseconds when the timer was started. This value is used to
       * calculate when the timer should expire.
       *
       * @type {number}
       * @default -1
       * @private
       */
      _idleStart = -1;
      /**
       * The function to be executed when the timer expires.
       * @type {Function}
       * @private
       */
      _onTimeout;
      /**
       * The argument to be passed to the callback when the timer expires.
       *
       * @type {*}
       * @private
       */
      _timerArg;
      /**
       * @constructor
       * @param {Function} callback A function to be executed after the timer
       * expires.
       * @param {number} delay The time, in milliseconds that the timer should wait
       * before the specified function or code is executed.
       * @param {*} arg
       */
      constructor(callback, delay, arg) {
        this._onTimeout = callback;
        this._idleTimeout = delay;
        this._timerArg = arg;
        this.refresh();
      }
      /**
       * Sets the timer's start time to the current time, and reschedules the timer
       * to call its callback at the previously specified duration adjusted to the
       * current time.
       * Using this on a timer that has already called its callback will reactivate
       * the timer.
       *
       * @returns {void}
       */
      refresh() {
        if (this._state === NOT_IN_LIST) {
          fastTimers.push(this);
        }
        if (!fastNowTimeout || fastTimers.length === 1) {
          refreshTimeout();
        }
        this._state = PENDING;
      }
      /**
       * The `clear` method cancels the timer, preventing it from executing.
       *
       * @returns {void}
       * @private
       */
      clear() {
        this._state = TO_BE_CLEARED;
        this._idleStart = -1;
      }
    };
    module3.exports = {
      /**
       * The setTimeout() method sets a timer which executes a function once the
       * timer expires.
       * @param {Function} callback A function to be executed after the timer
       * expires.
       * @param {number} delay The time, in milliseconds that the timer should
       * wait before the specified function or code is executed.
       * @param {*} [arg] An optional argument to be passed to the callback function
       * when the timer expires.
       * @returns {NodeJS.Timeout|FastTimer}
       */
      setTimeout(callback, delay, arg) {
        return delay <= RESOLUTION_MS ? setTimeout(callback, delay, arg) : new FastTimer(callback, delay, arg);
      },
      /**
       * The clearTimeout method cancels an instantiated Timer previously created
       * by calling setTimeout.
       *
       * @param {NodeJS.Timeout|FastTimer} timeout
       */
      clearTimeout(timeout2) {
        if (timeout2[kFastTimer]) {
          timeout2.clear();
        } else {
          clearTimeout(timeout2);
        }
      },
      /**
       * The setFastTimeout() method sets a fastTimer which executes a function once
       * the timer expires.
       * @param {Function} callback A function to be executed after the timer
       * expires.
       * @param {number} delay The time, in milliseconds that the timer should
       * wait before the specified function or code is executed.
       * @param {*} [arg] An optional argument to be passed to the callback function
       * when the timer expires.
       * @returns {FastTimer}
       */
      setFastTimeout(callback, delay, arg) {
        return new FastTimer(callback, delay, arg);
      },
      /**
       * The clearTimeout method cancels an instantiated FastTimer previously
       * created by calling setFastTimeout.
       *
       * @param {FastTimer} timeout
       */
      clearFastTimeout(timeout2) {
        timeout2.clear();
      },
      /**
       * The now method returns the value of the internal fast timer clock.
       *
       * @returns {number}
       */
      now() {
        return fastNow;
      },
      /**
       * Trigger the onTick function to process the fastTimers array.
       * Exported for testing purposes only.
       * Marking as deprecated to discourage any use outside of testing.
       * @deprecated
       * @param {number} [delay=0] The delay in milliseconds to add to the now value.
       */
      tick(delay = 0) {
        fastNow += delay - RESOLUTION_MS + 1;
        onTick();
        onTick();
      },
      /**
       * Reset FastTimers.
       * Exported for testing purposes only.
       * Marking as deprecated to discourage any use outside of testing.
       * @deprecated
       */
      reset() {
        fastNow = 0;
        fastTimers.length = 0;
        clearTimeout(fastNowTimeout);
        fastNowTimeout = null;
      },
      /**
       * Exporting for testing purposes only.
       * Marking as deprecated to discourage any use outside of testing.
       * @deprecated
       */
      kFastTimer
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/errors.js
var require_errors = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/errors.js"(exports2, module3) {
    init_import_meta_url();
    var UndiciError = class extends Error {
      static {
        __name(this, "UndiciError");
      }
      constructor(message, options) {
        super(message, options);
        this.name = "UndiciError";
        this.code = "UND_ERR";
      }
    };
    var ConnectTimeoutError = class extends UndiciError {
      static {
        __name(this, "ConnectTimeoutError");
      }
      constructor(message) {
        super(message);
        this.name = "ConnectTimeoutError";
        this.message = message || "Connect Timeout Error";
        this.code = "UND_ERR_CONNECT_TIMEOUT";
      }
    };
    var HeadersTimeoutError = class extends UndiciError {
      static {
        __name(this, "HeadersTimeoutError");
      }
      constructor(message) {
        super(message);
        this.name = "HeadersTimeoutError";
        this.message = message || "Headers Timeout Error";
        this.code = "UND_ERR_HEADERS_TIMEOUT";
      }
    };
    var HeadersOverflowError = class extends UndiciError {
      static {
        __name(this, "HeadersOverflowError");
      }
      constructor(message) {
        super(message);
        this.name = "HeadersOverflowError";
        this.message = message || "Headers Overflow Error";
        this.code = "UND_ERR_HEADERS_OVERFLOW";
      }
    };
    var BodyTimeoutError = class extends UndiciError {
      static {
        __name(this, "BodyTimeoutError");
      }
      constructor(message) {
        super(message);
        this.name = "BodyTimeoutError";
        this.message = message || "Body Timeout Error";
        this.code = "UND_ERR_BODY_TIMEOUT";
      }
    };
    var ResponseStatusCodeError = class extends UndiciError {
      static {
        __name(this, "ResponseStatusCodeError");
      }
      constructor(message, statusCode, headers, body) {
        super(message);
        this.name = "ResponseStatusCodeError";
        this.message = message || "Response Status Code Error";
        this.code = "UND_ERR_RESPONSE_STATUS_CODE";
        this.body = body;
        this.status = statusCode;
        this.statusCode = statusCode;
        this.headers = headers;
      }
    };
    var InvalidArgumentError = class extends UndiciError {
      static {
        __name(this, "InvalidArgumentError");
      }
      constructor(message) {
        super(message);
        this.name = "InvalidArgumentError";
        this.message = message || "Invalid Argument Error";
        this.code = "UND_ERR_INVALID_ARG";
      }
    };
    var InvalidReturnValueError = class extends UndiciError {
      static {
        __name(this, "InvalidReturnValueError");
      }
      constructor(message) {
        super(message);
        this.name = "InvalidReturnValueError";
        this.message = message || "Invalid Return Value Error";
        this.code = "UND_ERR_INVALID_RETURN_VALUE";
      }
    };
    var AbortError2 = class extends UndiciError {
      static {
        __name(this, "AbortError");
      }
      constructor(message) {
        super(message);
        this.name = "AbortError";
        this.message = message || "The operation was aborted";
      }
    };
    var RequestAbortedError = class extends AbortError2 {
      static {
        __name(this, "RequestAbortedError");
      }
      constructor(message) {
        super(message);
        this.name = "AbortError";
        this.message = message || "Request aborted";
        this.code = "UND_ERR_ABORTED";
      }
    };
    var InformationalError = class extends UndiciError {
      static {
        __name(this, "InformationalError");
      }
      constructor(message) {
        super(message);
        this.name = "InformationalError";
        this.message = message || "Request information";
        this.code = "UND_ERR_INFO";
      }
    };
    var RequestContentLengthMismatchError = class extends UndiciError {
      static {
        __name(this, "RequestContentLengthMismatchError");
      }
      constructor(message) {
        super(message);
        this.name = "RequestContentLengthMismatchError";
        this.message = message || "Request body length does not match content-length header";
        this.code = "UND_ERR_REQ_CONTENT_LENGTH_MISMATCH";
      }
    };
    var ResponseContentLengthMismatchError = class extends UndiciError {
      static {
        __name(this, "ResponseContentLengthMismatchError");
      }
      constructor(message) {
        super(message);
        this.name = "ResponseContentLengthMismatchError";
        this.message = message || "Response body length does not match content-length header";
        this.code = "UND_ERR_RES_CONTENT_LENGTH_MISMATCH";
      }
    };
    var ClientDestroyedError = class extends UndiciError {
      static {
        __name(this, "ClientDestroyedError");
      }
      constructor(message) {
        super(message);
        this.name = "ClientDestroyedError";
        this.message = message || "The client is destroyed";
        this.code = "UND_ERR_DESTROYED";
      }
    };
    var ClientClosedError = class extends UndiciError {
      static {
        __name(this, "ClientClosedError");
      }
      constructor(message) {
        super(message);
        this.name = "ClientClosedError";
        this.message = message || "The client is closed";
        this.code = "UND_ERR_CLOSED";
      }
    };
    var SocketError = class extends UndiciError {
      static {
        __name(this, "SocketError");
      }
      constructor(message, socket) {
        super(message);
        this.name = "SocketError";
        this.message = message || "Socket error";
        this.code = "UND_ERR_SOCKET";
        this.socket = socket;
      }
    };
    var NotSupportedError = class extends UndiciError {
      static {
        __name(this, "NotSupportedError");
      }
      constructor(message) {
        super(message);
        this.name = "NotSupportedError";
        this.message = message || "Not supported error";
        this.code = "UND_ERR_NOT_SUPPORTED";
      }
    };
    var BalancedPoolMissingUpstreamError = class extends UndiciError {
      static {
        __name(this, "BalancedPoolMissingUpstreamError");
      }
      constructor(message) {
        super(message);
        this.name = "MissingUpstreamError";
        this.message = message || "No upstream has been added to the BalancedPool";
        this.code = "UND_ERR_BPL_MISSING_UPSTREAM";
      }
    };
    var HTTPParserError = class extends Error {
      static {
        __name(this, "HTTPParserError");
      }
      constructor(message, code, data) {
        super(message);
        this.name = "HTTPParserError";
        this.code = code ? `HPE_${code}` : void 0;
        this.data = data ? data.toString() : void 0;
      }
    };
    var ResponseExceededMaxSizeError = class extends UndiciError {
      static {
        __name(this, "ResponseExceededMaxSizeError");
      }
      constructor(message) {
        super(message);
        this.name = "ResponseExceededMaxSizeError";
        this.message = message || "Response content exceeded max size";
        this.code = "UND_ERR_RES_EXCEEDED_MAX_SIZE";
      }
    };
    var RequestRetryError = class extends UndiciError {
      static {
        __name(this, "RequestRetryError");
      }
      constructor(message, code, { headers, data }) {
        super(message);
        this.name = "RequestRetryError";
        this.message = message || "Request retry error";
        this.code = "UND_ERR_REQ_RETRY";
        this.statusCode = code;
        this.data = data;
        this.headers = headers;
      }
    };
    var ResponseError = class extends UndiciError {
      static {
        __name(this, "ResponseError");
      }
      constructor(message, code, { headers, body }) {
        super(message);
        this.name = "ResponseError";
        this.message = message || "Response error";
        this.code = "UND_ERR_RESPONSE";
        this.statusCode = code;
        this.body = body;
        this.headers = headers;
      }
    };
    var SecureProxyConnectionError = class extends UndiciError {
      static {
        __name(this, "SecureProxyConnectionError");
      }
      constructor(cause, message, options = {}) {
        super(message, { cause, ...options });
        this.name = "SecureProxyConnectionError";
        this.message = message || "Secure Proxy Connection failed";
        this.code = "UND_ERR_PRX_TLS";
        this.cause = cause;
      }
    };
    module3.exports = {
      AbortError: AbortError2,
      HTTPParserError,
      UndiciError,
      HeadersTimeoutError,
      HeadersOverflowError,
      BodyTimeoutError,
      RequestContentLengthMismatchError,
      ConnectTimeoutError,
      ResponseStatusCodeError,
      InvalidArgumentError,
      InvalidReturnValueError,
      RequestAbortedError,
      ClientDestroyedError,
      ClientClosedError,
      InformationalError,
      SocketError,
      NotSupportedError,
      ResponseContentLengthMismatchError,
      BalancedPoolMissingUpstreamError,
      ResponseExceededMaxSizeError,
      RequestRetryError,
      ResponseError,
      SecureProxyConnectionError
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/constants.js
var require_constants = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/constants.js"(exports2, module3) {
    init_import_meta_url();
    var wellknownHeaderNames = (
      /** @type {const} */
      [
        "Accept",
        "Accept-Encoding",
        "Accept-Language",
        "Accept-Ranges",
        "Access-Control-Allow-Credentials",
        "Access-Control-Allow-Headers",
        "Access-Control-Allow-Methods",
        "Access-Control-Allow-Origin",
        "Access-Control-Expose-Headers",
        "Access-Control-Max-Age",
        "Access-Control-Request-Headers",
        "Access-Control-Request-Method",
        "Age",
        "Allow",
        "Alt-Svc",
        "Alt-Used",
        "Authorization",
        "Cache-Control",
        "Clear-Site-Data",
        "Connection",
        "Content-Disposition",
        "Content-Encoding",
        "Content-Language",
        "Content-Length",
        "Content-Location",
        "Content-Range",
        "Content-Security-Policy",
        "Content-Security-Policy-Report-Only",
        "Content-Type",
        "Cookie",
        "Cross-Origin-Embedder-Policy",
        "Cross-Origin-Opener-Policy",
        "Cross-Origin-Resource-Policy",
        "Date",
        "Device-Memory",
        "Downlink",
        "ECT",
        "ETag",
        "Expect",
        "Expect-CT",
        "Expires",
        "Forwarded",
        "From",
        "Host",
        "If-Match",
        "If-Modified-Since",
        "If-None-Match",
        "If-Range",
        "If-Unmodified-Since",
        "Keep-Alive",
        "Last-Modified",
        "Link",
        "Location",
        "Max-Forwards",
        "Origin",
        "Permissions-Policy",
        "Pragma",
        "Proxy-Authenticate",
        "Proxy-Authorization",
        "RTT",
        "Range",
        "Referer",
        "Referrer-Policy",
        "Refresh",
        "Retry-After",
        "Sec-WebSocket-Accept",
        "Sec-WebSocket-Extensions",
        "Sec-WebSocket-Key",
        "Sec-WebSocket-Protocol",
        "Sec-WebSocket-Version",
        "Server",
        "Server-Timing",
        "Service-Worker-Allowed",
        "Service-Worker-Navigation-Preload",
        "Set-Cookie",
        "SourceMap",
        "Strict-Transport-Security",
        "Supports-Loading-Mode",
        "TE",
        "Timing-Allow-Origin",
        "Trailer",
        "Transfer-Encoding",
        "Upgrade",
        "Upgrade-Insecure-Requests",
        "User-Agent",
        "Vary",
        "Via",
        "WWW-Authenticate",
        "X-Content-Type-Options",
        "X-DNS-Prefetch-Control",
        "X-Frame-Options",
        "X-Permitted-Cross-Domain-Policies",
        "X-Powered-By",
        "X-Requested-With",
        "X-XSS-Protection"
      ]
    );
    var headerNameLowerCasedRecord = {};
    Object.setPrototypeOf(headerNameLowerCasedRecord, null);
    var wellknownHeaderNameBuffers = {};
    Object.setPrototypeOf(wellknownHeaderNameBuffers, null);
    function getHeaderNameAsBuffer(header) {
      let buffer = wellknownHeaderNameBuffers[header];
      if (buffer === void 0) {
        buffer = Buffer.from(header);
      }
      return buffer;
    }
    __name(getHeaderNameAsBuffer, "getHeaderNameAsBuffer");
    for (let i6 = 0; i6 < wellknownHeaderNames.length; ++i6) {
      const key = wellknownHeaderNames[i6];
      const lowerCasedKey = key.toLowerCase();
      headerNameLowerCasedRecord[key] = headerNameLowerCasedRecord[lowerCasedKey] = lowerCasedKey;
    }
    module3.exports = {
      wellknownHeaderNames,
      headerNameLowerCasedRecord,
      getHeaderNameAsBuffer
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/tree.js
var require_tree = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/tree.js"(exports2, module3) {
    init_import_meta_url();
    var {
      wellknownHeaderNames,
      headerNameLowerCasedRecord
    } = require_constants();
    var TstNode = class _TstNode {
      static {
        __name(this, "TstNode");
      }
      /** @type {any} */
      value = null;
      /** @type {null | TstNode} */
      left = null;
      /** @type {null | TstNode} */
      middle = null;
      /** @type {null | TstNode} */
      right = null;
      /** @type {number} */
      code;
      /**
       * @param {string} key
       * @param {any} value
       * @param {number} index
       */
      constructor(key, value, index) {
        if (index === void 0 || index >= key.length) {
          throw new TypeError("Unreachable");
        }
        const code = this.code = key.charCodeAt(index);
        if (code > 127) {
          throw new TypeError("key must be ascii string");
        }
        if (key.length !== ++index) {
          this.middle = new _TstNode(key, value, index);
        } else {
          this.value = value;
        }
      }
      /**
       * @param {string} key
       * @param {any} value
       * @returns {void}
       */
      add(key, value) {
        const length = key.length;
        if (length === 0) {
          throw new TypeError("Unreachable");
        }
        let index = 0;
        let node2 = this;
        while (true) {
          const code = key.charCodeAt(index);
          if (code > 127) {
            throw new TypeError("key must be ascii string");
          }
          if (node2.code === code) {
            if (length === ++index) {
              node2.value = value;
              break;
            } else if (node2.middle !== null) {
              node2 = node2.middle;
            } else {
              node2.middle = new _TstNode(key, value, index);
              break;
            }
          } else if (node2.code < code) {
            if (node2.left !== null) {
              node2 = node2.left;
            } else {
              node2.left = new _TstNode(key, value, index);
              break;
            }
          } else if (node2.right !== null) {
            node2 = node2.right;
          } else {
            node2.right = new _TstNode(key, value, index);
            break;
          }
        }
      }
      /**
       * @param {Uint8Array} key
       * @returns {TstNode | null}
       */
      search(key) {
        const keylength = key.length;
        let index = 0;
        let node2 = this;
        while (node2 !== null && index < keylength) {
          let code = key[index];
          if (code <= 90 && code >= 65) {
            code |= 32;
          }
          while (node2 !== null) {
            if (code === node2.code) {
              if (keylength === ++index) {
                return node2;
              }
              node2 = node2.middle;
              break;
            }
            node2 = node2.code < code ? node2.left : node2.right;
          }
        }
        return null;
      }
    };
    var TernarySearchTree = class {
      static {
        __name(this, "TernarySearchTree");
      }
      /** @type {TstNode | null} */
      node = null;
      /**
       * @param {string} key
       * @param {any} value
       * @returns {void}
       * */
      insert(key, value) {
        if (this.node === null) {
          this.node = new TstNode(key, value, 0);
        } else {
          this.node.add(key, value);
        }
      }
      /**
       * @param {Uint8Array} key
       * @returns {any}
       */
      lookup(key) {
        return this.node?.search(key)?.value ?? null;
      }
    };
    var tree = new TernarySearchTree();
    for (let i6 = 0; i6 < wellknownHeaderNames.length; ++i6) {
      const key = headerNameLowerCasedRecord[wellknownHeaderNames[i6]];
      tree.insert(key, key);
    }
    module3.exports = {
      TernarySearchTree,
      tree
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/util.js
var require_util = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/util.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var { kDestroyed, kBodyUsed, kListeners, kBody } = require_symbols();
    var { IncomingMessage } = __require("http");
    var stream2 = __require("stream");
    var net2 = __require("net");
    var { stringify: stringify4 } = __require("querystring");
    var { EventEmitter: EE } = __require("events");
    var timers = require_timers();
    var { InvalidArgumentError, ConnectTimeoutError } = require_errors();
    var { headerNameLowerCasedRecord } = require_constants();
    var { tree } = require_tree();
    var [nodeMajor, nodeMinor] = process.versions.node.split(".", 2).map((v8) => Number(v8));
    var BodyAsyncIterable = class {
      static {
        __name(this, "BodyAsyncIterable");
      }
      constructor(body) {
        this[kBody] = body;
        this[kBodyUsed] = false;
      }
      async *[Symbol.asyncIterator]() {
        assert48(!this[kBodyUsed], "disturbed");
        this[kBodyUsed] = true;
        yield* this[kBody];
      }
    };
    function noop() {
    }
    __name(noop, "noop");
    function wrapRequestBody(body) {
      if (isStream2(body)) {
        if (bodyLength(body) === 0) {
          body.on("data", function() {
            assert48(false);
          });
        }
        if (typeof body.readableDidRead !== "boolean") {
          body[kBodyUsed] = false;
          EE.prototype.on.call(body, "data", function() {
            this[kBodyUsed] = true;
          });
        }
        return body;
      } else if (body && typeof body.pipeTo === "function") {
        return new BodyAsyncIterable(body);
      } else if (body && typeof body !== "string" && !ArrayBuffer.isView(body) && isIterable(body)) {
        return new BodyAsyncIterable(body);
      } else {
        return body;
      }
    }
    __name(wrapRequestBody, "wrapRequestBody");
    function isStream2(obj) {
      return obj && typeof obj === "object" && typeof obj.pipe === "function" && typeof obj.on === "function";
    }
    __name(isStream2, "isStream");
    function isBlobLike2(object) {
      if (object === null) {
        return false;
      } else if (object instanceof Blob) {
        return true;
      } else if (typeof object !== "object") {
        return false;
      } else {
        const sTag = object[Symbol.toStringTag];
        return (sTag === "Blob" || sTag === "File") && ("stream" in object && typeof object.stream === "function" || "arrayBuffer" in object && typeof object.arrayBuffer === "function");
      }
    }
    __name(isBlobLike2, "isBlobLike");
    function serializePathWithQuery(url4, queryParams) {
      if (url4.includes("?") || url4.includes("#")) {
        throw new Error('Query params cannot be passed when url already contains "?" or "#".');
      }
      const stringified = stringify4(queryParams);
      if (stringified) {
        url4 += "?" + stringified;
      }
      return url4;
    }
    __name(serializePathWithQuery, "serializePathWithQuery");
    function isValidPort(port) {
      const value = parseInt(port, 10);
      return value === Number(port) && value >= 0 && value <= 65535;
    }
    __name(isValidPort, "isValidPort");
    function isHttpOrHttpsPrefixed(value) {
      return value != null && value[0] === "h" && value[1] === "t" && value[2] === "t" && value[3] === "p" && (value[4] === ":" || value[4] === "s" && value[5] === ":");
    }
    __name(isHttpOrHttpsPrefixed, "isHttpOrHttpsPrefixed");
    function parseURL3(url4) {
      if (typeof url4 === "string") {
        url4 = new URL(url4);
        if (!isHttpOrHttpsPrefixed(url4.origin || url4.protocol)) {
          throw new InvalidArgumentError("Invalid URL protocol: the URL must start with `http:` or `https:`.");
        }
        return url4;
      }
      if (!url4 || typeof url4 !== "object") {
        throw new InvalidArgumentError("Invalid URL: The URL argument must be a non-null object.");
      }
      if (!(url4 instanceof URL)) {
        if (url4.port != null && url4.port !== "" && isValidPort(url4.port) === false) {
          throw new InvalidArgumentError("Invalid URL: port must be a valid integer or a string representation of an integer.");
        }
        if (url4.path != null && typeof url4.path !== "string") {
          throw new InvalidArgumentError("Invalid URL path: the path must be a string or null/undefined.");
        }
        if (url4.pathname != null && typeof url4.pathname !== "string") {
          throw new InvalidArgumentError("Invalid URL pathname: the pathname must be a string or null/undefined.");
        }
        if (url4.hostname != null && typeof url4.hostname !== "string") {
          throw new InvalidArgumentError("Invalid URL hostname: the hostname must be a string or null/undefined.");
        }
        if (url4.origin != null && typeof url4.origin !== "string") {
          throw new InvalidArgumentError("Invalid URL origin: the origin must be a string or null/undefined.");
        }
        if (!isHttpOrHttpsPrefixed(url4.origin || url4.protocol)) {
          throw new InvalidArgumentError("Invalid URL protocol: the URL must start with `http:` or `https:`.");
        }
        const port = url4.port != null ? url4.port : url4.protocol === "https:" ? 443 : 80;
        let origin = url4.origin != null ? url4.origin : `${url4.protocol || ""}//${url4.hostname || ""}:${port}`;
        let path77 = url4.path != null ? url4.path : `${url4.pathname || ""}${url4.search || ""}`;
        if (origin[origin.length - 1] === "/") {
          origin = origin.slice(0, origin.length - 1);
        }
        if (path77 && path77[0] !== "/") {
          path77 = `/${path77}`;
        }
        return new URL(`${origin}${path77}`);
      }
      if (!isHttpOrHttpsPrefixed(url4.origin || url4.protocol)) {
        throw new InvalidArgumentError("Invalid URL protocol: the URL must start with `http:` or `https:`.");
      }
      return url4;
    }
    __name(parseURL3, "parseURL");
    function parseOrigin(url4) {
      url4 = parseURL3(url4);
      if (url4.pathname !== "/" || url4.search || url4.hash) {
        throw new InvalidArgumentError("invalid url");
      }
      return url4;
    }
    __name(parseOrigin, "parseOrigin");
    function getHostname(host) {
      if (host[0] === "[") {
        const idx2 = host.indexOf("]");
        assert48(idx2 !== -1);
        return host.substring(1, idx2);
      }
      const idx = host.indexOf(":");
      if (idx === -1) return host;
      return host.substring(0, idx);
    }
    __name(getHostname, "getHostname");
    function getServerName(host) {
      if (!host) {
        return null;
      }
      assert48(typeof host === "string");
      const servername = getHostname(host);
      if (net2.isIP(servername)) {
        return "";
      }
      return servername;
    }
    __name(getServerName, "getServerName");
    function deepClone(obj) {
      return JSON.parse(JSON.stringify(obj));
    }
    __name(deepClone, "deepClone");
    function isAsyncIterable(obj) {
      return !!(obj != null && typeof obj[Symbol.asyncIterator] === "function");
    }
    __name(isAsyncIterable, "isAsyncIterable");
    function isIterable(obj) {
      return !!(obj != null && (typeof obj[Symbol.iterator] === "function" || typeof obj[Symbol.asyncIterator] === "function"));
    }
    __name(isIterable, "isIterable");
    function bodyLength(body) {
      if (body == null) {
        return 0;
      } else if (isStream2(body)) {
        const state2 = body._readableState;
        return state2 && state2.objectMode === false && state2.ended === true && Number.isFinite(state2.length) ? state2.length : null;
      } else if (isBlobLike2(body)) {
        return body.size != null ? body.size : null;
      } else if (isBuffer(body)) {
        return body.byteLength;
      }
      return null;
    }
    __name(bodyLength, "bodyLength");
    function isDestroyed(body) {
      return body && !!(body.destroyed || body[kDestroyed] || stream2.isDestroyed?.(body));
    }
    __name(isDestroyed, "isDestroyed");
    function destroy(stream3, err) {
      if (stream3 == null || !isStream2(stream3) || isDestroyed(stream3)) {
        return;
      }
      if (typeof stream3.destroy === "function") {
        if (Object.getPrototypeOf(stream3).constructor === IncomingMessage) {
          stream3.socket = null;
        }
        stream3.destroy(err);
      } else if (err) {
        queueMicrotask(() => {
          stream3.emit("error", err);
        });
      }
      if (stream3.destroyed !== true) {
        stream3[kDestroyed] = true;
      }
    }
    __name(destroy, "destroy");
    var KEEPALIVE_TIMEOUT_EXPR = /timeout=(\d+)/;
    function parseKeepAliveTimeout(val2) {
      const m7 = val2.match(KEEPALIVE_TIMEOUT_EXPR);
      return m7 ? parseInt(m7[1], 10) * 1e3 : null;
    }
    __name(parseKeepAliveTimeout, "parseKeepAliveTimeout");
    function headerNameToString(value) {
      return typeof value === "string" ? headerNameLowerCasedRecord[value] ?? value.toLowerCase() : tree.lookup(value) ?? value.toString("latin1").toLowerCase();
    }
    __name(headerNameToString, "headerNameToString");
    function bufferToLowerCasedHeaderName(value) {
      return tree.lookup(value) ?? value.toString("latin1").toLowerCase();
    }
    __name(bufferToLowerCasedHeaderName, "bufferToLowerCasedHeaderName");
    function parseHeaders2(headers, obj) {
      if (obj === void 0) obj = {};
      for (let i6 = 0; i6 < headers.length; i6 += 2) {
        const key = headerNameToString(headers[i6]);
        let val2 = obj[key];
        if (val2) {
          if (typeof val2 === "string") {
            val2 = [val2];
            obj[key] = val2;
          }
          val2.push(headers[i6 + 1].toString("utf8"));
        } else {
          const headersValue = headers[i6 + 1];
          if (typeof headersValue === "string") {
            obj[key] = headersValue;
          } else {
            obj[key] = Array.isArray(headersValue) ? headersValue.map((x7) => x7.toString("utf8")) : headersValue.toString("utf8");
          }
        }
      }
      if ("content-length" in obj && "content-disposition" in obj) {
        obj["content-disposition"] = Buffer.from(obj["content-disposition"]).toString("latin1");
      }
      return obj;
    }
    __name(parseHeaders2, "parseHeaders");
    function parseRawHeaders(headers) {
      const headersLength = headers.length;
      const ret = new Array(headersLength);
      let hasContentLength = false;
      let contentDispositionIdx = -1;
      let key;
      let val2;
      let kLen = 0;
      for (let n7 = 0; n7 < headersLength; n7 += 2) {
        key = headers[n7];
        val2 = headers[n7 + 1];
        typeof key !== "string" && (key = key.toString());
        typeof val2 !== "string" && (val2 = val2.toString("utf8"));
        kLen = key.length;
        if (kLen === 14 && key[7] === "-" && (key === "content-length" || key.toLowerCase() === "content-length")) {
          hasContentLength = true;
        } else if (kLen === 19 && key[7] === "-" && (key === "content-disposition" || key.toLowerCase() === "content-disposition")) {
          contentDispositionIdx = n7 + 1;
        }
        ret[n7] = key;
        ret[n7 + 1] = val2;
      }
      if (hasContentLength && contentDispositionIdx !== -1) {
        ret[contentDispositionIdx] = Buffer.from(ret[contentDispositionIdx]).toString("latin1");
      }
      return ret;
    }
    __name(parseRawHeaders, "parseRawHeaders");
    function encodeRawHeaders(headers) {
      if (!Array.isArray(headers)) {
        throw new TypeError("expected headers to be an array");
      }
      return headers.map((x7) => Buffer.from(x7));
    }
    __name(encodeRawHeaders, "encodeRawHeaders");
    function isBuffer(buffer) {
      return buffer instanceof Uint8Array || Buffer.isBuffer(buffer);
    }
    __name(isBuffer, "isBuffer");
    function assertRequestHandler(handler, method, upgrade) {
      if (!handler || typeof handler !== "object") {
        throw new InvalidArgumentError("handler must be an object");
      }
      if (typeof handler.onRequestStart === "function") {
        return;
      }
      if (typeof handler.onConnect !== "function") {
        throw new InvalidArgumentError("invalid onConnect method");
      }
      if (typeof handler.onError !== "function") {
        throw new InvalidArgumentError("invalid onError method");
      }
      if (typeof handler.onBodySent !== "function" && handler.onBodySent !== void 0) {
        throw new InvalidArgumentError("invalid onBodySent method");
      }
      if (upgrade || method === "CONNECT") {
        if (typeof handler.onUpgrade !== "function") {
          throw new InvalidArgumentError("invalid onUpgrade method");
        }
      } else {
        if (typeof handler.onHeaders !== "function") {
          throw new InvalidArgumentError("invalid onHeaders method");
        }
        if (typeof handler.onData !== "function") {
          throw new InvalidArgumentError("invalid onData method");
        }
        if (typeof handler.onComplete !== "function") {
          throw new InvalidArgumentError("invalid onComplete method");
        }
      }
    }
    __name(assertRequestHandler, "assertRequestHandler");
    function isDisturbed(body) {
      return !!(body && (stream2.isDisturbed(body) || body[kBodyUsed]));
    }
    __name(isDisturbed, "isDisturbed");
    function getSocketInfo(socket) {
      return {
        localAddress: socket.localAddress,
        localPort: socket.localPort,
        remoteAddress: socket.remoteAddress,
        remotePort: socket.remotePort,
        remoteFamily: socket.remoteFamily,
        timeout: socket.timeout,
        bytesWritten: socket.bytesWritten,
        bytesRead: socket.bytesRead
      };
    }
    __name(getSocketInfo, "getSocketInfo");
    function ReadableStreamFrom(iterable) {
      let iterator;
      return new ReadableStream(
        {
          async start() {
            iterator = iterable[Symbol.asyncIterator]();
          },
          pull(controller) {
            async function pull() {
              const { done, value } = await iterator.next();
              if (done) {
                queueMicrotask(() => {
                  controller.close();
                  controller.byobRequest?.respond(0);
                });
              } else {
                const buf = Buffer.isBuffer(value) ? value : Buffer.from(value);
                if (buf.byteLength) {
                  controller.enqueue(new Uint8Array(buf));
                } else {
                  return await pull();
                }
              }
            }
            __name(pull, "pull");
            return pull();
          },
          async cancel() {
            await iterator.return();
          },
          type: "bytes"
        }
      );
    }
    __name(ReadableStreamFrom, "ReadableStreamFrom");
    function isFormDataLike(object) {
      return object && typeof object === "object" && typeof object.append === "function" && typeof object.delete === "function" && typeof object.get === "function" && typeof object.getAll === "function" && typeof object.has === "function" && typeof object.set === "function" && object[Symbol.toStringTag] === "FormData";
    }
    __name(isFormDataLike, "isFormDataLike");
    function addAbortListener(signal, listener) {
      if ("addEventListener" in signal) {
        signal.addEventListener("abort", listener, { once: true });
        return () => signal.removeEventListener("abort", listener);
      }
      signal.once("abort", listener);
      return () => signal.removeListener("abort", listener);
    }
    __name(addAbortListener, "addAbortListener");
    function isTokenCharCode(c7) {
      switch (c7) {
        case 34:
        case 40:
        case 41:
        case 44:
        case 47:
        case 58:
        case 59:
        case 60:
        case 61:
        case 62:
        case 63:
        case 64:
        case 91:
        case 92:
        case 93:
        case 123:
        case 125:
          return false;
        default:
          return c7 >= 33 && c7 <= 126;
      }
    }
    __name(isTokenCharCode, "isTokenCharCode");
    function isValidHTTPToken(characters) {
      if (characters.length === 0) {
        return false;
      }
      for (let i6 = 0; i6 < characters.length; ++i6) {
        if (!isTokenCharCode(characters.charCodeAt(i6))) {
          return false;
        }
      }
      return true;
    }
    __name(isValidHTTPToken, "isValidHTTPToken");
    var headerCharRegex = /[^\t\x20-\x7e\x80-\xff]/;
    function isValidHeaderValue(characters) {
      return !headerCharRegex.test(characters);
    }
    __name(isValidHeaderValue, "isValidHeaderValue");
    var rangeHeaderRegex = /^bytes (\d+)-(\d+)\/(\d+)?$/;
    function parseRangeHeader(range) {
      if (range == null || range === "") return { start: 0, end: null, size: null };
      const m7 = range ? range.match(rangeHeaderRegex) : null;
      return m7 ? {
        start: parseInt(m7[1]),
        end: m7[2] ? parseInt(m7[2]) : null,
        size: m7[3] ? parseInt(m7[3]) : null
      } : null;
    }
    __name(parseRangeHeader, "parseRangeHeader");
    function addListener(obj, name2, listener) {
      const listeners = obj[kListeners] ??= [];
      listeners.push([name2, listener]);
      obj.on(name2, listener);
      return obj;
    }
    __name(addListener, "addListener");
    function removeAllListeners(obj) {
      if (obj[kListeners] != null) {
        for (const [name2, listener] of obj[kListeners]) {
          obj.removeListener(name2, listener);
        }
        obj[kListeners] = null;
      }
      return obj;
    }
    __name(removeAllListeners, "removeAllListeners");
    function errorRequest(client, request4, err) {
      try {
        request4.onError(err);
        assert48(request4.aborted);
      } catch (err2) {
        client.emit("error", err2);
      }
    }
    __name(errorRequest, "errorRequest");
    var setupConnectTimeout = process.platform === "win32" ? (socketWeakRef, opts) => {
      if (!opts.timeout) {
        return noop;
      }
      let s1 = null;
      let s22 = null;
      const fastTimer = timers.setFastTimeout(() => {
        s1 = setImmediate(() => {
          s22 = setImmediate(() => onConnectTimeout(socketWeakRef.deref(), opts));
        });
      }, opts.timeout);
      return () => {
        timers.clearFastTimeout(fastTimer);
        clearImmediate(s1);
        clearImmediate(s22);
      };
    } : (socketWeakRef, opts) => {
      if (!opts.timeout) {
        return noop;
      }
      let s1 = null;
      const fastTimer = timers.setFastTimeout(() => {
        s1 = setImmediate(() => {
          onConnectTimeout(socketWeakRef.deref(), opts);
        });
      }, opts.timeout);
      return () => {
        timers.clearFastTimeout(fastTimer);
        clearImmediate(s1);
      };
    };
    function onConnectTimeout(socket, opts) {
      if (socket == null) {
        return;
      }
      let message = "Connect Timeout Error";
      if (Array.isArray(socket.autoSelectFamilyAttemptedAddresses)) {
        message += ` (attempted addresses: ${socket.autoSelectFamilyAttemptedAddresses.join(", ")},`;
      } else {
        message += ` (attempted address: ${opts.hostname}:${opts.port},`;
      }
      message += ` timeout: ${opts.timeout}ms)`;
      destroy(socket, new ConnectTimeoutError(message));
    }
    __name(onConnectTimeout, "onConnectTimeout");
    var kEnumerableProperty = /* @__PURE__ */ Object.create(null);
    kEnumerableProperty.enumerable = true;
    var normalizedMethodRecordsBase = {
      delete: "DELETE",
      DELETE: "DELETE",
      get: "GET",
      GET: "GET",
      head: "HEAD",
      HEAD: "HEAD",
      options: "OPTIONS",
      OPTIONS: "OPTIONS",
      post: "POST",
      POST: "POST",
      put: "PUT",
      PUT: "PUT"
    };
    var normalizedMethodRecords = {
      ...normalizedMethodRecordsBase,
      patch: "patch",
      PATCH: "PATCH"
    };
    Object.setPrototypeOf(normalizedMethodRecordsBase, null);
    Object.setPrototypeOf(normalizedMethodRecords, null);
    module3.exports = {
      kEnumerableProperty,
      isDisturbed,
      isBlobLike: isBlobLike2,
      parseOrigin,
      parseURL: parseURL3,
      getServerName,
      isStream: isStream2,
      isIterable,
      isAsyncIterable,
      isDestroyed,
      headerNameToString,
      bufferToLowerCasedHeaderName,
      addListener,
      removeAllListeners,
      errorRequest,
      parseRawHeaders,
      encodeRawHeaders,
      parseHeaders: parseHeaders2,
      parseKeepAliveTimeout,
      destroy,
      bodyLength,
      deepClone,
      ReadableStreamFrom,
      isBuffer,
      assertRequestHandler,
      getSocketInfo,
      isFormDataLike,
      serializePathWithQuery,
      addAbortListener,
      isValidHTTPToken,
      isValidHeaderValue,
      isTokenCharCode,
      parseRangeHeader,
      normalizedMethodRecordsBase,
      normalizedMethodRecords,
      isValidPort,
      isHttpOrHttpsPrefixed,
      nodeMajor,
      nodeMinor,
      safeHTTPMethods: Object.freeze(["GET", "HEAD", "OPTIONS", "TRACE"]),
      wrapRequestBody,
      setupConnectTimeout
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/util/stats.js
var require_stats = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/util/stats.js"(exports2, module3) {
    init_import_meta_url();
    var {
      kConnected,
      kPending,
      kRunning,
      kSize,
      kFree,
      kQueued
    } = require_symbols();
    var ClientStats = class {
      static {
        __name(this, "ClientStats");
      }
      constructor(client) {
        this.connected = client[kConnected];
        this.pending = client[kPending];
        this.running = client[kRunning];
        this.size = client[kSize];
      }
    };
    var PoolStats = class {
      static {
        __name(this, "PoolStats");
      }
      constructor(pool) {
        this.connected = pool[kConnected];
        this.free = pool[kFree];
        this.pending = pool[kPending];
        this.queued = pool[kQueued];
        this.running = pool[kRunning];
        this.size = pool[kSize];
      }
    };
    module3.exports = { ClientStats, PoolStats };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/diagnostics.js
var require_diagnostics = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/diagnostics.js"(exports2, module3) {
    init_import_meta_url();
    var diagnosticsChannel = __require("diagnostics_channel");
    var util3 = __require("util");
    var undiciDebugLog = util3.debuglog("undici");
    var fetchDebuglog = util3.debuglog("fetch");
    var websocketDebuglog = util3.debuglog("websocket");
    var channels = {
      // Client
      beforeConnect: diagnosticsChannel.channel("undici:client:beforeConnect"),
      connected: diagnosticsChannel.channel("undici:client:connected"),
      connectError: diagnosticsChannel.channel("undici:client:connectError"),
      sendHeaders: diagnosticsChannel.channel("undici:client:sendHeaders"),
      // Request
      create: diagnosticsChannel.channel("undici:request:create"),
      bodySent: diagnosticsChannel.channel("undici:request:bodySent"),
      bodyChunkSent: diagnosticsChannel.channel("undici:request:bodyChunkSent"),
      bodyChunkReceived: diagnosticsChannel.channel("undici:request:bodyChunkReceived"),
      headers: diagnosticsChannel.channel("undici:request:headers"),
      trailers: diagnosticsChannel.channel("undici:request:trailers"),
      error: diagnosticsChannel.channel("undici:request:error"),
      // WebSocket
      open: diagnosticsChannel.channel("undici:websocket:open"),
      close: diagnosticsChannel.channel("undici:websocket:close"),
      socketError: diagnosticsChannel.channel("undici:websocket:socket_error"),
      ping: diagnosticsChannel.channel("undici:websocket:ping"),
      pong: diagnosticsChannel.channel("undici:websocket:pong")
    };
    var isTrackingClientEvents = false;
    function trackClientEvents(debugLog = undiciDebugLog) {
      if (isTrackingClientEvents) {
        return;
      }
      isTrackingClientEvents = true;
      diagnosticsChannel.subscribe(
        "undici:client:beforeConnect",
        (evt) => {
          const {
            connectParams: { version: version5, protocol, port, host }
          } = evt;
          debugLog(
            "connecting to %s%s using %s%s",
            host,
            port ? `:${port}` : "",
            protocol,
            version5
          );
        }
      );
      diagnosticsChannel.subscribe(
        "undici:client:connected",
        (evt) => {
          const {
            connectParams: { version: version5, protocol, port, host }
          } = evt;
          debugLog(
            "connected to %s%s using %s%s",
            host,
            port ? `:${port}` : "",
            protocol,
            version5
          );
        }
      );
      diagnosticsChannel.subscribe(
        "undici:client:connectError",
        (evt) => {
          const {
            connectParams: { version: version5, protocol, port, host },
            error: error2
          } = evt;
          debugLog(
            "connection to %s%s using %s%s errored - %s",
            host,
            port ? `:${port}` : "",
            protocol,
            version5,
            error2.message
          );
        }
      );
      diagnosticsChannel.subscribe(
        "undici:client:sendHeaders",
        (evt) => {
          const {
            request: { method, path: path77, origin }
          } = evt;
          debugLog("sending request to %s %s%s", method, origin, path77);
        }
      );
    }
    __name(trackClientEvents, "trackClientEvents");
    var isTrackingRequestEvents = false;
    function trackRequestEvents(debugLog = undiciDebugLog) {
      if (isTrackingRequestEvents) {
        return;
      }
      isTrackingRequestEvents = true;
      diagnosticsChannel.subscribe(
        "undici:request:headers",
        (evt) => {
          const {
            request: { method, path: path77, origin },
            response: { statusCode }
          } = evt;
          debugLog(
            "received response to %s %s%s - HTTP %d",
            method,
            origin,
            path77,
            statusCode
          );
        }
      );
      diagnosticsChannel.subscribe(
        "undici:request:trailers",
        (evt) => {
          const {
            request: { method, path: path77, origin }
          } = evt;
          debugLog("trailers received from %s %s%s", method, origin, path77);
        }
      );
      diagnosticsChannel.subscribe(
        "undici:request:error",
        (evt) => {
          const {
            request: { method, path: path77, origin },
            error: error2
          } = evt;
          debugLog(
            "request to %s %s%s errored - %s",
            method,
            origin,
            path77,
            error2.message
          );
        }
      );
    }
    __name(trackRequestEvents, "trackRequestEvents");
    var isTrackingWebSocketEvents = false;
    function trackWebSocketEvents(debugLog = websocketDebuglog) {
      if (isTrackingWebSocketEvents) {
        return;
      }
      isTrackingWebSocketEvents = true;
      diagnosticsChannel.subscribe(
        "undici:websocket:open",
        (evt) => {
          const {
            address: { address, port }
          } = evt;
          debugLog("connection opened %s%s", address, port ? `:${port}` : "");
        }
      );
      diagnosticsChannel.subscribe(
        "undici:websocket:close",
        (evt) => {
          const { websocket, code, reason } = evt;
          debugLog(
            "closed connection to %s - %s %s",
            websocket.url,
            code,
            reason
          );
        }
      );
      diagnosticsChannel.subscribe(
        "undici:websocket:socket_error",
        (err) => {
          debugLog("connection errored - %s", err.message);
        }
      );
      diagnosticsChannel.subscribe(
        "undici:websocket:ping",
        (evt) => {
          debugLog("ping received");
        }
      );
      diagnosticsChannel.subscribe(
        "undici:websocket:pong",
        (evt) => {
          debugLog("pong received");
        }
      );
    }
    __name(trackWebSocketEvents, "trackWebSocketEvents");
    if (undiciDebugLog.enabled || fetchDebuglog.enabled) {
      trackClientEvents(fetchDebuglog.enabled ? fetchDebuglog : undiciDebugLog);
      trackRequestEvents(fetchDebuglog.enabled ? fetchDebuglog : undiciDebugLog);
    }
    if (websocketDebuglog.enabled) {
      trackClientEvents(undiciDebugLog.enabled ? undiciDebugLog : websocketDebuglog);
      trackWebSocketEvents(websocketDebuglog);
    }
    module3.exports = {
      channels
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/request.js
var require_request = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/request.js"(exports2, module3) {
    init_import_meta_url();
    var {
      InvalidArgumentError,
      NotSupportedError
    } = require_errors();
    var assert48 = __require("assert");
    var {
      isValidHTTPToken,
      isValidHeaderValue,
      isStream: isStream2,
      destroy,
      isBuffer,
      isFormDataLike,
      isIterable,
      isBlobLike: isBlobLike2,
      serializePathWithQuery,
      assertRequestHandler,
      getServerName,
      normalizedMethodRecords
    } = require_util();
    var { channels } = require_diagnostics();
    var { headerNameLowerCasedRecord } = require_constants();
    var invalidPathRegex = /[^\u0021-\u00ff]/;
    var kHandler = Symbol("handler");
    var Request7 = class {
      static {
        __name(this, "Request");
      }
      constructor(origin, {
        path: path77,
        method,
        body,
        headers,
        query,
        idempotent,
        blocking,
        upgrade,
        headersTimeout,
        bodyTimeout,
        reset,
        expectContinue,
        servername,
        throwOnError,
        maxRedirections
      }, handler) {
        if (typeof path77 !== "string") {
          throw new InvalidArgumentError("path must be a string");
        } else if (path77[0] !== "/" && !(path77.startsWith("http://") || path77.startsWith("https://")) && method !== "CONNECT") {
          throw new InvalidArgumentError("path must be an absolute URL or start with a slash");
        } else if (invalidPathRegex.test(path77)) {
          throw new InvalidArgumentError("invalid request path");
        }
        if (typeof method !== "string") {
          throw new InvalidArgumentError("method must be a string");
        } else if (normalizedMethodRecords[method] === void 0 && !isValidHTTPToken(method)) {
          throw new InvalidArgumentError("invalid request method");
        }
        if (upgrade && typeof upgrade !== "string") {
          throw new InvalidArgumentError("upgrade must be a string");
        }
        if (headersTimeout != null && (!Number.isFinite(headersTimeout) || headersTimeout < 0)) {
          throw new InvalidArgumentError("invalid headersTimeout");
        }
        if (bodyTimeout != null && (!Number.isFinite(bodyTimeout) || bodyTimeout < 0)) {
          throw new InvalidArgumentError("invalid bodyTimeout");
        }
        if (reset != null && typeof reset !== "boolean") {
          throw new InvalidArgumentError("invalid reset");
        }
        if (expectContinue != null && typeof expectContinue !== "boolean") {
          throw new InvalidArgumentError("invalid expectContinue");
        }
        if (throwOnError != null) {
          throw new InvalidArgumentError("invalid throwOnError");
        }
        if (maxRedirections != null && maxRedirections !== 0) {
          throw new InvalidArgumentError("maxRedirections is not supported, use the redirect interceptor");
        }
        this.headersTimeout = headersTimeout;
        this.bodyTimeout = bodyTimeout;
        this.method = method;
        this.abort = null;
        if (body == null) {
          this.body = null;
        } else if (isStream2(body)) {
          this.body = body;
          const rState = this.body._readableState;
          if (!rState || !rState.autoDestroy) {
            this.endHandler = /* @__PURE__ */ __name(function autoDestroy() {
              destroy(this);
            }, "autoDestroy");
            this.body.on("end", this.endHandler);
          }
          this.errorHandler = (err) => {
            if (this.abort) {
              this.abort(err);
            } else {
              this.error = err;
            }
          };
          this.body.on("error", this.errorHandler);
        } else if (isBuffer(body)) {
          this.body = body.byteLength ? body : null;
        } else if (ArrayBuffer.isView(body)) {
          this.body = body.buffer.byteLength ? Buffer.from(body.buffer, body.byteOffset, body.byteLength) : null;
        } else if (body instanceof ArrayBuffer) {
          this.body = body.byteLength ? Buffer.from(body) : null;
        } else if (typeof body === "string") {
          this.body = body.length ? Buffer.from(body) : null;
        } else if (isFormDataLike(body) || isIterable(body) || isBlobLike2(body)) {
          this.body = body;
        } else {
          throw new InvalidArgumentError("body must be a string, a Buffer, a Readable stream, an iterable, or an async iterable");
        }
        this.completed = false;
        this.aborted = false;
        this.upgrade = upgrade || null;
        this.path = query ? serializePathWithQuery(path77, query) : path77;
        this.origin = origin;
        this.idempotent = idempotent == null ? method === "HEAD" || method === "GET" : idempotent;
        this.blocking = blocking ?? this.method !== "HEAD";
        this.reset = reset == null ? null : reset;
        this.host = null;
        this.contentLength = null;
        this.contentType = null;
        this.headers = [];
        this.expectContinue = expectContinue != null ? expectContinue : false;
        if (Array.isArray(headers)) {
          if (headers.length % 2 !== 0) {
            throw new InvalidArgumentError("headers array must be even");
          }
          for (let i6 = 0; i6 < headers.length; i6 += 2) {
            processHeader(this, headers[i6], headers[i6 + 1]);
          }
        } else if (headers && typeof headers === "object") {
          if (headers[Symbol.iterator]) {
            for (const header of headers) {
              if (!Array.isArray(header) || header.length !== 2) {
                throw new InvalidArgumentError("headers must be in key-value pair format");
              }
              processHeader(this, header[0], header[1]);
            }
          } else {
            const keys = Object.keys(headers);
            for (let i6 = 0; i6 < keys.length; ++i6) {
              processHeader(this, keys[i6], headers[keys[i6]]);
            }
          }
        } else if (headers != null) {
          throw new InvalidArgumentError("headers must be an object or an array");
        }
        assertRequestHandler(handler, method, upgrade);
        this.servername = servername || getServerName(this.host) || null;
        this[kHandler] = handler;
        if (channels.create.hasSubscribers) {
          channels.create.publish({ request: this });
        }
      }
      onBodySent(chunk) {
        if (channels.bodyChunkSent.hasSubscribers) {
          channels.bodyChunkSent.publish({ request: this, chunk });
        }
        if (this[kHandler].onBodySent) {
          try {
            return this[kHandler].onBodySent(chunk);
          } catch (err) {
            this.abort(err);
          }
        }
      }
      onRequestSent() {
        if (channels.bodySent.hasSubscribers) {
          channels.bodySent.publish({ request: this });
        }
        if (this[kHandler].onRequestSent) {
          try {
            return this[kHandler].onRequestSent();
          } catch (err) {
            this.abort(err);
          }
        }
      }
      onConnect(abort) {
        assert48(!this.aborted);
        assert48(!this.completed);
        if (this.error) {
          abort(this.error);
        } else {
          this.abort = abort;
          return this[kHandler].onConnect(abort);
        }
      }
      onResponseStarted() {
        return this[kHandler].onResponseStarted?.();
      }
      onHeaders(statusCode, headers, resume, statusText) {
        assert48(!this.aborted);
        assert48(!this.completed);
        if (channels.headers.hasSubscribers) {
          channels.headers.publish({ request: this, response: { statusCode, headers, statusText } });
        }
        try {
          return this[kHandler].onHeaders(statusCode, headers, resume, statusText);
        } catch (err) {
          this.abort(err);
        }
      }
      onData(chunk) {
        assert48(!this.aborted);
        assert48(!this.completed);
        if (channels.bodyChunkReceived.hasSubscribers) {
          channels.bodyChunkReceived.publish({ request: this, chunk });
        }
        try {
          return this[kHandler].onData(chunk);
        } catch (err) {
          this.abort(err);
          return false;
        }
      }
      onUpgrade(statusCode, headers, socket) {
        assert48(!this.aborted);
        assert48(!this.completed);
        return this[kHandler].onUpgrade(statusCode, headers, socket);
      }
      onComplete(trailers) {
        this.onFinally();
        assert48(!this.aborted);
        assert48(!this.completed);
        this.completed = true;
        if (channels.trailers.hasSubscribers) {
          channels.trailers.publish({ request: this, trailers });
        }
        try {
          return this[kHandler].onComplete(trailers);
        } catch (err) {
          this.onError(err);
        }
      }
      onError(error2) {
        this.onFinally();
        if (channels.error.hasSubscribers) {
          channels.error.publish({ request: this, error: error2 });
        }
        if (this.aborted) {
          return;
        }
        this.aborted = true;
        return this[kHandler].onError(error2);
      }
      onFinally() {
        if (this.errorHandler) {
          this.body.off("error", this.errorHandler);
          this.errorHandler = null;
        }
        if (this.endHandler) {
          this.body.off("end", this.endHandler);
          this.endHandler = null;
        }
      }
      addHeader(key, value) {
        processHeader(this, key, value);
        return this;
      }
    };
    function processHeader(request4, key, val2) {
      if (val2 && (typeof val2 === "object" && !Array.isArray(val2))) {
        throw new InvalidArgumentError(`invalid ${key} header`);
      } else if (val2 === void 0) {
        return;
      }
      let headerName = headerNameLowerCasedRecord[key];
      if (headerName === void 0) {
        headerName = key.toLowerCase();
        if (headerNameLowerCasedRecord[headerName] === void 0 && !isValidHTTPToken(headerName)) {
          throw new InvalidArgumentError("invalid header key");
        }
      }
      if (Array.isArray(val2)) {
        const arr = [];
        for (let i6 = 0; i6 < val2.length; i6++) {
          if (typeof val2[i6] === "string") {
            if (!isValidHeaderValue(val2[i6])) {
              throw new InvalidArgumentError(`invalid ${key} header`);
            }
            arr.push(val2[i6]);
          } else if (val2[i6] === null) {
            arr.push("");
          } else if (typeof val2[i6] === "object") {
            throw new InvalidArgumentError(`invalid ${key} header`);
          } else {
            arr.push(`${val2[i6]}`);
          }
        }
        val2 = arr;
      } else if (typeof val2 === "string") {
        if (!isValidHeaderValue(val2)) {
          throw new InvalidArgumentError(`invalid ${key} header`);
        }
      } else if (val2 === null) {
        val2 = "";
      } else {
        val2 = `${val2}`;
      }
      if (request4.host === null && headerName === "host") {
        if (typeof val2 !== "string") {
          throw new InvalidArgumentError("invalid host header");
        }
        request4.host = val2;
      } else if (request4.contentLength === null && headerName === "content-length") {
        request4.contentLength = parseInt(val2, 10);
        if (!Number.isFinite(request4.contentLength)) {
          throw new InvalidArgumentError("invalid content-length header");
        }
      } else if (request4.contentType === null && headerName === "content-type") {
        request4.contentType = val2;
        request4.headers.push(key, val2);
      } else if (headerName === "transfer-encoding" || headerName === "keep-alive" || headerName === "upgrade") {
        throw new InvalidArgumentError(`invalid ${headerName} header`);
      } else if (headerName === "connection") {
        const value = typeof val2 === "string" ? val2.toLowerCase() : null;
        if (value !== "close" && value !== "keep-alive") {
          throw new InvalidArgumentError("invalid connection header");
        }
        if (value === "close") {
          request4.reset = true;
        }
      } else if (headerName === "expect") {
        throw new NotSupportedError("expect header not supported");
      } else {
        request4.headers.push(key, val2);
      }
    }
    __name(processHeader, "processHeader");
    module3.exports = Request7;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/wrap-handler.js
var require_wrap_handler = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/wrap-handler.js"(exports2, module3) {
    init_import_meta_url();
    var { InvalidArgumentError } = require_errors();
    module3.exports = class WrapHandler {
      static {
        __name(this, "WrapHandler");
      }
      #handler;
      constructor(handler) {
        this.#handler = handler;
      }
      static wrap(handler) {
        return handler.onRequestStart ? handler : new WrapHandler(handler);
      }
      // Unwrap Interface
      onConnect(abort, context2) {
        return this.#handler.onConnect?.(abort, context2);
      }
      onHeaders(statusCode, rawHeaders, resume, statusMessage) {
        return this.#handler.onHeaders?.(statusCode, rawHeaders, resume, statusMessage);
      }
      onUpgrade(statusCode, rawHeaders, socket) {
        return this.#handler.onUpgrade?.(statusCode, rawHeaders, socket);
      }
      onData(data) {
        return this.#handler.onData?.(data);
      }
      onComplete(trailers) {
        return this.#handler.onComplete?.(trailers);
      }
      onError(err) {
        if (!this.#handler.onError) {
          throw err;
        }
        return this.#handler.onError?.(err);
      }
      // Wrap Interface
      onRequestStart(controller, context2) {
        this.#handler.onConnect?.((reason) => controller.abort(reason), context2);
      }
      onRequestUpgrade(controller, statusCode, headers, socket) {
        const rawHeaders = [];
        for (const [key, val2] of Object.entries(headers)) {
          rawHeaders.push(Buffer.from(key), Array.isArray(val2) ? val2.map((v8) => Buffer.from(v8)) : Buffer.from(val2));
        }
        this.#handler.onUpgrade?.(statusCode, rawHeaders, socket);
      }
      onResponseStart(controller, statusCode, headers, statusMessage) {
        const rawHeaders = [];
        for (const [key, val2] of Object.entries(headers)) {
          rawHeaders.push(Buffer.from(key), Array.isArray(val2) ? val2.map((v8) => Buffer.from(v8)) : Buffer.from(val2));
        }
        if (this.#handler.onHeaders?.(statusCode, rawHeaders, () => controller.resume(), statusMessage) === false) {
          controller.pause();
        }
      }
      onResponseData(controller, data) {
        if (this.#handler.onData?.(data) === false) {
          controller.pause();
        }
      }
      onResponseEnd(controller, trailers) {
        const rawTrailers = [];
        for (const [key, val2] of Object.entries(trailers)) {
          rawTrailers.push(Buffer.from(key), Array.isArray(val2) ? val2.map((v8) => Buffer.from(v8)) : Buffer.from(val2));
        }
        this.#handler.onComplete?.(rawTrailers);
      }
      onResponseError(controller, err) {
        if (!this.#handler.onError) {
          throw new InvalidArgumentError("invalid onError method");
        }
        this.#handler.onError?.(err);
      }
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/dispatcher.js
var require_dispatcher = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/dispatcher.js"(exports2, module3) {
    init_import_meta_url();
    var EventEmitter5 = __require("events");
    var WrapHandler = require_wrap_handler();
    var wrapInterceptor = /* @__PURE__ */ __name((dispatch) => (opts, handler) => dispatch(opts, WrapHandler.wrap(handler)), "wrapInterceptor");
    var Dispatcher2 = class extends EventEmitter5 {
      static {
        __name(this, "Dispatcher");
      }
      dispatch() {
        throw new Error("not implemented");
      }
      close() {
        throw new Error("not implemented");
      }
      destroy() {
        throw new Error("not implemented");
      }
      compose(...args) {
        const interceptors = Array.isArray(args[0]) ? args[0] : args;
        let dispatch = this.dispatch.bind(this);
        for (const interceptor of interceptors) {
          if (interceptor == null) {
            continue;
          }
          if (typeof interceptor !== "function") {
            throw new TypeError(`invalid interceptor, expected function received ${typeof interceptor}`);
          }
          dispatch = interceptor(dispatch);
          dispatch = wrapInterceptor(dispatch);
          if (dispatch == null || typeof dispatch !== "function" || dispatch.length !== 2) {
            throw new TypeError("invalid interceptor");
          }
        }
        return new Proxy(this, {
          get: /* @__PURE__ */ __name((target, key) => key === "dispatch" ? dispatch : target[key], "get")
        });
      }
    };
    module3.exports = Dispatcher2;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/unwrap-handler.js
var require_unwrap_handler = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/unwrap-handler.js"(exports2, module3) {
    init_import_meta_url();
    var { parseHeaders: parseHeaders2 } = require_util();
    var { InvalidArgumentError } = require_errors();
    var kResume = Symbol("resume");
    var UnwrapController = class {
      static {
        __name(this, "UnwrapController");
      }
      #paused = false;
      #reason = null;
      #aborted = false;
      #abort;
      [kResume] = null;
      constructor(abort) {
        this.#abort = abort;
      }
      pause() {
        this.#paused = true;
      }
      resume() {
        if (this.#paused) {
          this.#paused = false;
          this[kResume]?.();
        }
      }
      abort(reason) {
        if (!this.#aborted) {
          this.#aborted = true;
          this.#reason = reason;
          this.#abort(reason);
        }
      }
      get aborted() {
        return this.#aborted;
      }
      get reason() {
        return this.#reason;
      }
      get paused() {
        return this.#paused;
      }
    };
    module3.exports = class UnwrapHandler {
      static {
        __name(this, "UnwrapHandler");
      }
      #handler;
      #controller;
      constructor(handler) {
        this.#handler = handler;
      }
      static unwrap(handler) {
        return !handler.onRequestStart ? handler : new UnwrapHandler(handler);
      }
      onConnect(abort, context2) {
        this.#controller = new UnwrapController(abort);
        this.#handler.onRequestStart?.(this.#controller, context2);
      }
      onUpgrade(statusCode, rawHeaders, socket) {
        this.#handler.onRequestUpgrade?.(this.#controller, statusCode, parseHeaders2(rawHeaders), socket);
      }
      onHeaders(statusCode, rawHeaders, resume, statusMessage) {
        this.#controller[kResume] = resume;
        this.#handler.onResponseStart?.(this.#controller, statusCode, parseHeaders2(rawHeaders), statusMessage);
        return !this.#controller.paused;
      }
      onData(data) {
        this.#handler.onResponseData?.(this.#controller, data);
        return !this.#controller.paused;
      }
      onComplete(rawTrailers) {
        this.#handler.onResponseEnd?.(this.#controller, parseHeaders2(rawTrailers));
      }
      onError(err) {
        if (!this.#handler.onResponseError) {
          throw new InvalidArgumentError("invalid onError method");
        }
        this.#handler.onResponseError?.(this.#controller, err);
      }
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/dispatcher-base.js
var require_dispatcher_base = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/dispatcher-base.js"(exports2, module3) {
    init_import_meta_url();
    var Dispatcher2 = require_dispatcher();
    var UnwrapHandler = require_unwrap_handler();
    var {
      ClientDestroyedError,
      ClientClosedError,
      InvalidArgumentError
    } = require_errors();
    var { kDestroy, kClose, kClosed, kDestroyed, kDispatch } = require_symbols();
    var kOnDestroyed = Symbol("onDestroyed");
    var kOnClosed = Symbol("onClosed");
    var DispatcherBase = class extends Dispatcher2 {
      static {
        __name(this, "DispatcherBase");
      }
      constructor() {
        super();
        this[kDestroyed] = false;
        this[kOnDestroyed] = null;
        this[kClosed] = false;
        this[kOnClosed] = [];
      }
      get destroyed() {
        return this[kDestroyed];
      }
      get closed() {
        return this[kClosed];
      }
      close(callback) {
        if (callback === void 0) {
          return new Promise((resolve28, reject) => {
            this.close((err, data) => {
              return err ? reject(err) : resolve28(data);
            });
          });
        }
        if (typeof callback !== "function") {
          throw new InvalidArgumentError("invalid callback");
        }
        if (this[kDestroyed]) {
          queueMicrotask(() => callback(new ClientDestroyedError(), null));
          return;
        }
        if (this[kClosed]) {
          if (this[kOnClosed]) {
            this[kOnClosed].push(callback);
          } else {
            queueMicrotask(() => callback(null, null));
          }
          return;
        }
        this[kClosed] = true;
        this[kOnClosed].push(callback);
        const onClosed = /* @__PURE__ */ __name(() => {
          const callbacks = this[kOnClosed];
          this[kOnClosed] = null;
          for (let i6 = 0; i6 < callbacks.length; i6++) {
            callbacks[i6](null, null);
          }
        }, "onClosed");
        this[kClose]().then(() => this.destroy()).then(() => {
          queueMicrotask(onClosed);
        });
      }
      destroy(err, callback) {
        if (typeof err === "function") {
          callback = err;
          err = null;
        }
        if (callback === void 0) {
          return new Promise((resolve28, reject) => {
            this.destroy(err, (err2, data) => {
              return err2 ? (
                /* istanbul ignore next: should never error */
                reject(err2)
              ) : resolve28(data);
            });
          });
        }
        if (typeof callback !== "function") {
          throw new InvalidArgumentError("invalid callback");
        }
        if (this[kDestroyed]) {
          if (this[kOnDestroyed]) {
            this[kOnDestroyed].push(callback);
          } else {
            queueMicrotask(() => callback(null, null));
          }
          return;
        }
        if (!err) {
          err = new ClientDestroyedError();
        }
        this[kDestroyed] = true;
        this[kOnDestroyed] = this[kOnDestroyed] || [];
        this[kOnDestroyed].push(callback);
        const onDestroyed = /* @__PURE__ */ __name(() => {
          const callbacks = this[kOnDestroyed];
          this[kOnDestroyed] = null;
          for (let i6 = 0; i6 < callbacks.length; i6++) {
            callbacks[i6](null, null);
          }
        }, "onDestroyed");
        this[kDestroy](err).then(() => {
          queueMicrotask(onDestroyed);
        });
      }
      dispatch(opts, handler) {
        if (!handler || typeof handler !== "object") {
          throw new InvalidArgumentError("handler must be an object");
        }
        handler = UnwrapHandler.unwrap(handler);
        try {
          if (!opts || typeof opts !== "object") {
            throw new InvalidArgumentError("opts must be an object.");
          }
          if (this[kDestroyed] || this[kOnDestroyed]) {
            throw new ClientDestroyedError();
          }
          if (this[kClosed]) {
            throw new ClientClosedError();
          }
          return this[kDispatch](opts, handler);
        } catch (err) {
          if (typeof handler.onError !== "function") {
            throw err;
          }
          handler.onError(err);
          return false;
        }
      }
    };
    module3.exports = DispatcherBase;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/connect.js
var require_connect = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/core/connect.js"(exports2, module3) {
    init_import_meta_url();
    var net2 = __require("net");
    var assert48 = __require("assert");
    var util3 = require_util();
    var { InvalidArgumentError } = require_errors();
    var tls;
    var SessionCache = class WeakSessionCache {
      static {
        __name(this, "WeakSessionCache");
      }
      constructor(maxCachedSessions) {
        this._maxCachedSessions = maxCachedSessions;
        this._sessionCache = /* @__PURE__ */ new Map();
        this._sessionRegistry = new FinalizationRegistry((key) => {
          if (this._sessionCache.size < this._maxCachedSessions) {
            return;
          }
          const ref = this._sessionCache.get(key);
          if (ref !== void 0 && ref.deref() === void 0) {
            this._sessionCache.delete(key);
          }
        });
      }
      get(sessionKey) {
        const ref = this._sessionCache.get(sessionKey);
        return ref ? ref.deref() : null;
      }
      set(sessionKey, session) {
        if (this._maxCachedSessions === 0) {
          return;
        }
        this._sessionCache.set(sessionKey, new WeakRef(session));
        this._sessionRegistry.register(session, sessionKey);
      }
    };
    function buildConnector({ allowH2, maxCachedSessions, socketPath, timeout: timeout2, session: customSession, ...opts }) {
      if (maxCachedSessions != null && (!Number.isInteger(maxCachedSessions) || maxCachedSessions < 0)) {
        throw new InvalidArgumentError("maxCachedSessions must be a positive integer or zero");
      }
      const options = { path: socketPath, ...opts };
      const sessionCache = new SessionCache(maxCachedSessions == null ? 100 : maxCachedSessions);
      timeout2 = timeout2 == null ? 1e4 : timeout2;
      allowH2 = allowH2 != null ? allowH2 : false;
      return /* @__PURE__ */ __name(function connect({ hostname: hostname2, host, protocol, port, servername, localAddress, httpSocket }, callback) {
        let socket;
        if (protocol === "https:") {
          if (!tls) {
            tls = __require("tls");
          }
          servername = servername || options.servername || util3.getServerName(host) || null;
          const sessionKey = servername || hostname2;
          assert48(sessionKey);
          const session = customSession || sessionCache.get(sessionKey) || null;
          port = port || 443;
          socket = tls.connect({
            highWaterMark: 16384,
            // TLS in node can't have bigger HWM anyway...
            ...options,
            servername,
            session,
            localAddress,
            ALPNProtocols: allowH2 ? ["http/1.1", "h2"] : ["http/1.1"],
            socket: httpSocket,
            // upgrade socket connection
            port,
            host: hostname2
          });
          socket.on("session", function(session2) {
            sessionCache.set(sessionKey, session2);
          });
        } else {
          assert48(!httpSocket, "httpSocket can only be sent on TLS update");
          port = port || 80;
          socket = net2.connect({
            highWaterMark: 64 * 1024,
            // Same as nodejs fs streams.
            ...options,
            localAddress,
            port,
            host: hostname2
          });
        }
        if (options.keepAlive == null || options.keepAlive) {
          const keepAliveInitialDelay = options.keepAliveInitialDelay === void 0 ? 6e4 : options.keepAliveInitialDelay;
          socket.setKeepAlive(true, keepAliveInitialDelay);
        }
        const clearConnectTimeout = util3.setupConnectTimeout(new WeakRef(socket), { timeout: timeout2, hostname: hostname2, port });
        socket.setNoDelay(true).once(protocol === "https:" ? "secureConnect" : "connect", function() {
          queueMicrotask(clearConnectTimeout);
          if (callback) {
            const cb2 = callback;
            callback = null;
            cb2(null, this);
          }
        }).on("error", function(err) {
          queueMicrotask(clearConnectTimeout);
          if (callback) {
            const cb2 = callback;
            callback = null;
            cb2(err);
          }
        });
        return socket;
      }, "connect");
    }
    __name(buildConnector, "buildConnector");
    module3.exports = buildConnector;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/llhttp/utils.js
var require_utils = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/llhttp/utils.js"(exports2) {
    init_import_meta_url();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.enumToMap = void 0;
    function enumToMap(obj, filter2 = [], exceptions = []) {
      var _a5, _b2;
      const emptyFilter = ((_a5 = filter2 === null || filter2 === void 0 ? void 0 : filter2.length) !== null && _a5 !== void 0 ? _a5 : 0) === 0;
      const emptyExceptions = ((_b2 = exceptions === null || exceptions === void 0 ? void 0 : exceptions.length) !== null && _b2 !== void 0 ? _b2 : 0) === 0;
      return Object.fromEntries(Object.entries(obj).filter(([, value]) => {
        return typeof value === "number" && (emptyFilter || filter2.includes(value)) && (emptyExceptions || !exceptions.includes(value));
      }));
    }
    __name(enumToMap, "enumToMap");
    exports2.enumToMap = enumToMap;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/llhttp/constants.js
var require_constants2 = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/llhttp/constants.js"(exports2) {
    init_import_meta_url();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SPECIAL_HEADERS = exports2.MINOR = exports2.MAJOR = exports2.HTAB_SP_VCHAR_OBS_TEXT = exports2.QUOTED_STRING = exports2.CONNECTION_TOKEN_CHARS = exports2.HEADER_CHARS = exports2.TOKEN = exports2.HEX = exports2.URL_CHAR = exports2.USERINFO_CHARS = exports2.MARK = exports2.ALPHANUM = exports2.NUM = exports2.HEX_MAP = exports2.NUM_MAP = exports2.ALPHA = exports2.STATUSES_HTTP = exports2.H_METHOD_MAP = exports2.METHOD_MAP = exports2.METHODS_RTSP = exports2.METHODS_ICE = exports2.METHODS_HTTP = exports2.HEADER_STATE = exports2.FINISH = exports2.STATUSES = exports2.METHODS = exports2.LENIENT_FLAGS = exports2.FLAGS = exports2.TYPE = exports2.ERROR = void 0;
    var utils_1 = require_utils();
    exports2.ERROR = {
      OK: 0,
      INTERNAL: 1,
      STRICT: 2,
      CR_EXPECTED: 25,
      LF_EXPECTED: 3,
      UNEXPECTED_CONTENT_LENGTH: 4,
      UNEXPECTED_SPACE: 30,
      CLOSED_CONNECTION: 5,
      INVALID_METHOD: 6,
      INVALID_URL: 7,
      INVALID_CONSTANT: 8,
      INVALID_VERSION: 9,
      INVALID_HEADER_TOKEN: 10,
      INVALID_CONTENT_LENGTH: 11,
      INVALID_CHUNK_SIZE: 12,
      INVALID_STATUS: 13,
      INVALID_EOF_STATE: 14,
      INVALID_TRANSFER_ENCODING: 15,
      CB_MESSAGE_BEGIN: 16,
      CB_HEADERS_COMPLETE: 17,
      CB_MESSAGE_COMPLETE: 18,
      CB_CHUNK_HEADER: 19,
      CB_CHUNK_COMPLETE: 20,
      PAUSED: 21,
      PAUSED_UPGRADE: 22,
      PAUSED_H2_UPGRADE: 23,
      USER: 24,
      CB_URL_COMPLETE: 26,
      CB_STATUS_COMPLETE: 27,
      CB_METHOD_COMPLETE: 32,
      CB_VERSION_COMPLETE: 33,
      CB_HEADER_FIELD_COMPLETE: 28,
      CB_HEADER_VALUE_COMPLETE: 29,
      CB_CHUNK_EXTENSION_NAME_COMPLETE: 34,
      CB_CHUNK_EXTENSION_VALUE_COMPLETE: 35,
      CB_RESET: 31
    };
    exports2.TYPE = {
      BOTH: 0,
      // default
      REQUEST: 1,
      RESPONSE: 2
    };
    exports2.FLAGS = {
      CONNECTION_KEEP_ALIVE: 1 << 0,
      CONNECTION_CLOSE: 1 << 1,
      CONNECTION_UPGRADE: 1 << 2,
      CHUNKED: 1 << 3,
      UPGRADE: 1 << 4,
      CONTENT_LENGTH: 1 << 5,
      SKIPBODY: 1 << 6,
      TRAILING: 1 << 7,
      // 1 << 8 is unused
      TRANSFER_ENCODING: 1 << 9
    };
    exports2.LENIENT_FLAGS = {
      HEADERS: 1 << 0,
      CHUNKED_LENGTH: 1 << 1,
      KEEP_ALIVE: 1 << 2,
      TRANSFER_ENCODING: 1 << 3,
      VERSION: 1 << 4,
      DATA_AFTER_CLOSE: 1 << 5,
      OPTIONAL_LF_AFTER_CR: 1 << 6,
      OPTIONAL_CRLF_AFTER_CHUNK: 1 << 7,
      OPTIONAL_CR_BEFORE_LF: 1 << 8,
      SPACES_AFTER_CHUNK_SIZE: 1 << 9
    };
    exports2.METHODS = {
      "DELETE": 0,
      "GET": 1,
      "HEAD": 2,
      "POST": 3,
      "PUT": 4,
      /* pathological */
      "CONNECT": 5,
      "OPTIONS": 6,
      "TRACE": 7,
      /* WebDAV */
      "COPY": 8,
      "LOCK": 9,
      "MKCOL": 10,
      "MOVE": 11,
      "PROPFIND": 12,
      "PROPPATCH": 13,
      "SEARCH": 14,
      "UNLOCK": 15,
      "BIND": 16,
      "REBIND": 17,
      "UNBIND": 18,
      "ACL": 19,
      /* subversion */
      "REPORT": 20,
      "MKACTIVITY": 21,
      "CHECKOUT": 22,
      "MERGE": 23,
      /* upnp */
      "M-SEARCH": 24,
      "NOTIFY": 25,
      "SUBSCRIBE": 26,
      "UNSUBSCRIBE": 27,
      /* RFC-5789 */
      "PATCH": 28,
      "PURGE": 29,
      /* CalDAV */
      "MKCALENDAR": 30,
      /* RFC-2068, section 19.6.1.2 */
      "LINK": 31,
      "UNLINK": 32,
      /* icecast */
      "SOURCE": 33,
      /* RFC-7540, section 11.6 */
      "PRI": 34,
      /* RFC-2326 RTSP */
      "DESCRIBE": 35,
      "ANNOUNCE": 36,
      "SETUP": 37,
      "PLAY": 38,
      "PAUSE": 39,
      "TEARDOWN": 40,
      "GET_PARAMETER": 41,
      "SET_PARAMETER": 42,
      "REDIRECT": 43,
      "RECORD": 44,
      /* RAOP */
      "FLUSH": 45,
      /* DRAFT https://www.ietf.org/archive/id/draft-ietf-httpbis-safe-method-w-body-02.html */
      "QUERY": 46
    };
    exports2.STATUSES = {
      CONTINUE: 100,
      SWITCHING_PROTOCOLS: 101,
      PROCESSING: 102,
      EARLY_HINTS: 103,
      RESPONSE_IS_STALE: 110,
      // Unofficial
      REVALIDATION_FAILED: 111,
      // Unofficial
      DISCONNECTED_OPERATION: 112,
      // Unofficial
      HEURISTIC_EXPIRATION: 113,
      // Unofficial
      MISCELLANEOUS_WARNING: 199,
      // Unofficial
      OK: 200,
      CREATED: 201,
      ACCEPTED: 202,
      NON_AUTHORITATIVE_INFORMATION: 203,
      NO_CONTENT: 204,
      RESET_CONTENT: 205,
      PARTIAL_CONTENT: 206,
      MULTI_STATUS: 207,
      ALREADY_REPORTED: 208,
      TRANSFORMATION_APPLIED: 214,
      // Unofficial
      IM_USED: 226,
      MISCELLANEOUS_PERSISTENT_WARNING: 299,
      // Unofficial
      MULTIPLE_CHOICES: 300,
      MOVED_PERMANENTLY: 301,
      FOUND: 302,
      SEE_OTHER: 303,
      NOT_MODIFIED: 304,
      USE_PROXY: 305,
      SWITCH_PROXY: 306,
      // No longer used
      TEMPORARY_REDIRECT: 307,
      PERMANENT_REDIRECT: 308,
      BAD_REQUEST: 400,
      UNAUTHORIZED: 401,
      PAYMENT_REQUIRED: 402,
      FORBIDDEN: 403,
      NOT_FOUND: 404,
      METHOD_NOT_ALLOWED: 405,
      NOT_ACCEPTABLE: 406,
      PROXY_AUTHENTICATION_REQUIRED: 407,
      REQUEST_TIMEOUT: 408,
      CONFLICT: 409,
      GONE: 410,
      LENGTH_REQUIRED: 411,
      PRECONDITION_FAILED: 412,
      PAYLOAD_TOO_LARGE: 413,
      URI_TOO_LONG: 414,
      UNSUPPORTED_MEDIA_TYPE: 415,
      RANGE_NOT_SATISFIABLE: 416,
      EXPECTATION_FAILED: 417,
      IM_A_TEAPOT: 418,
      PAGE_EXPIRED: 419,
      // Unofficial
      ENHANCE_YOUR_CALM: 420,
      // Unofficial
      MISDIRECTED_REQUEST: 421,
      UNPROCESSABLE_ENTITY: 422,
      LOCKED: 423,
      FAILED_DEPENDENCY: 424,
      TOO_EARLY: 425,
      UPGRADE_REQUIRED: 426,
      PRECONDITION_REQUIRED: 428,
      TOO_MANY_REQUESTS: 429,
      REQUEST_HEADER_FIELDS_TOO_LARGE_UNOFFICIAL: 430,
      // Unofficial
      REQUEST_HEADER_FIELDS_TOO_LARGE: 431,
      LOGIN_TIMEOUT: 440,
      // Unofficial
      NO_RESPONSE: 444,
      // Unofficial
      RETRY_WITH: 449,
      // Unofficial
      BLOCKED_BY_PARENTAL_CONTROL: 450,
      // Unofficial
      UNAVAILABLE_FOR_LEGAL_REASONS: 451,
      CLIENT_CLOSED_LOAD_BALANCED_REQUEST: 460,
      // Unofficial
      INVALID_X_FORWARDED_FOR: 463,
      // Unofficial
      REQUEST_HEADER_TOO_LARGE: 494,
      // Unofficial
      SSL_CERTIFICATE_ERROR: 495,
      // Unofficial
      SSL_CERTIFICATE_REQUIRED: 496,
      // Unofficial
      HTTP_REQUEST_SENT_TO_HTTPS_PORT: 497,
      // Unofficial
      INVALID_TOKEN: 498,
      // Unofficial
      CLIENT_CLOSED_REQUEST: 499,
      // Unofficial
      INTERNAL_SERVER_ERROR: 500,
      NOT_IMPLEMENTED: 501,
      BAD_GATEWAY: 502,
      SERVICE_UNAVAILABLE: 503,
      GATEWAY_TIMEOUT: 504,
      HTTP_VERSION_NOT_SUPPORTED: 505,
      VARIANT_ALSO_NEGOTIATES: 506,
      INSUFFICIENT_STORAGE: 507,
      LOOP_DETECTED: 508,
      BANDWIDTH_LIMIT_EXCEEDED: 509,
      NOT_EXTENDED: 510,
      NETWORK_AUTHENTICATION_REQUIRED: 511,
      WEB_SERVER_UNKNOWN_ERROR: 520,
      // Unofficial
      WEB_SERVER_IS_DOWN: 521,
      // Unofficial
      CONNECTION_TIMEOUT: 522,
      // Unofficial
      ORIGIN_IS_UNREACHABLE: 523,
      // Unofficial
      TIMEOUT_OCCURED: 524,
      // Unofficial
      SSL_HANDSHAKE_FAILED: 525,
      // Unofficial
      INVALID_SSL_CERTIFICATE: 526,
      // Unofficial
      RAILGUN_ERROR: 527,
      // Unofficial
      SITE_IS_OVERLOADED: 529,
      // Unofficial
      SITE_IS_FROZEN: 530,
      // Unofficial
      IDENTITY_PROVIDER_AUTHENTICATION_ERROR: 561,
      // Unofficial
      NETWORK_READ_TIMEOUT: 598,
      // Unofficial
      NETWORK_CONNECT_TIMEOUT: 599
      // Unofficial
    };
    exports2.FINISH = {
      SAFE: 0,
      SAFE_WITH_CB: 1,
      UNSAFE: 2
    };
    exports2.HEADER_STATE = {
      GENERAL: 0,
      CONNECTION: 1,
      CONTENT_LENGTH: 2,
      TRANSFER_ENCODING: 3,
      UPGRADE: 4,
      CONNECTION_KEEP_ALIVE: 5,
      CONNECTION_CLOSE: 6,
      CONNECTION_UPGRADE: 7,
      TRANSFER_ENCODING_CHUNKED: 8
    };
    exports2.METHODS_HTTP = [
      exports2.METHODS.DELETE,
      exports2.METHODS.GET,
      exports2.METHODS.HEAD,
      exports2.METHODS.POST,
      exports2.METHODS.PUT,
      exports2.METHODS.CONNECT,
      exports2.METHODS.OPTIONS,
      exports2.METHODS.TRACE,
      exports2.METHODS.COPY,
      exports2.METHODS.LOCK,
      exports2.METHODS.MKCOL,
      exports2.METHODS.MOVE,
      exports2.METHODS.PROPFIND,
      exports2.METHODS.PROPPATCH,
      exports2.METHODS.SEARCH,
      exports2.METHODS.UNLOCK,
      exports2.METHODS.BIND,
      exports2.METHODS.REBIND,
      exports2.METHODS.UNBIND,
      exports2.METHODS.ACL,
      exports2.METHODS.REPORT,
      exports2.METHODS.MKACTIVITY,
      exports2.METHODS.CHECKOUT,
      exports2.METHODS.MERGE,
      exports2.METHODS["M-SEARCH"],
      exports2.METHODS.NOTIFY,
      exports2.METHODS.SUBSCRIBE,
      exports2.METHODS.UNSUBSCRIBE,
      exports2.METHODS.PATCH,
      exports2.METHODS.PURGE,
      exports2.METHODS.MKCALENDAR,
      exports2.METHODS.LINK,
      exports2.METHODS.UNLINK,
      exports2.METHODS.PRI,
      // TODO(indutny): should we allow it with HTTP?
      exports2.METHODS.SOURCE,
      exports2.METHODS.QUERY
    ];
    exports2.METHODS_ICE = [
      exports2.METHODS.SOURCE
    ];
    exports2.METHODS_RTSP = [
      exports2.METHODS.OPTIONS,
      exports2.METHODS.DESCRIBE,
      exports2.METHODS.ANNOUNCE,
      exports2.METHODS.SETUP,
      exports2.METHODS.PLAY,
      exports2.METHODS.PAUSE,
      exports2.METHODS.TEARDOWN,
      exports2.METHODS.GET_PARAMETER,
      exports2.METHODS.SET_PARAMETER,
      exports2.METHODS.REDIRECT,
      exports2.METHODS.RECORD,
      exports2.METHODS.FLUSH,
      // For AirPlay
      exports2.METHODS.GET,
      exports2.METHODS.POST
    ];
    exports2.METHOD_MAP = (0, utils_1.enumToMap)(exports2.METHODS);
    exports2.H_METHOD_MAP = Object.fromEntries(Object.entries(exports2.METHODS).filter(([k7]) => k7.startsWith("H")));
    exports2.STATUSES_HTTP = [
      exports2.STATUSES.CONTINUE,
      exports2.STATUSES.SWITCHING_PROTOCOLS,
      exports2.STATUSES.PROCESSING,
      exports2.STATUSES.EARLY_HINTS,
      exports2.STATUSES.RESPONSE_IS_STALE,
      exports2.STATUSES.REVALIDATION_FAILED,
      exports2.STATUSES.DISCONNECTED_OPERATION,
      exports2.STATUSES.HEURISTIC_EXPIRATION,
      exports2.STATUSES.MISCELLANEOUS_WARNING,
      exports2.STATUSES.OK,
      exports2.STATUSES.CREATED,
      exports2.STATUSES.ACCEPTED,
      exports2.STATUSES.NON_AUTHORITATIVE_INFORMATION,
      exports2.STATUSES.NO_CONTENT,
      exports2.STATUSES.RESET_CONTENT,
      exports2.STATUSES.PARTIAL_CONTENT,
      exports2.STATUSES.MULTI_STATUS,
      exports2.STATUSES.ALREADY_REPORTED,
      exports2.STATUSES.TRANSFORMATION_APPLIED,
      exports2.STATUSES.IM_USED,
      exports2.STATUSES.MISCELLANEOUS_PERSISTENT_WARNING,
      exports2.STATUSES.MULTIPLE_CHOICES,
      exports2.STATUSES.MOVED_PERMANENTLY,
      exports2.STATUSES.FOUND,
      exports2.STATUSES.SEE_OTHER,
      exports2.STATUSES.NOT_MODIFIED,
      exports2.STATUSES.USE_PROXY,
      exports2.STATUSES.SWITCH_PROXY,
      exports2.STATUSES.TEMPORARY_REDIRECT,
      exports2.STATUSES.PERMANENT_REDIRECT,
      exports2.STATUSES.BAD_REQUEST,
      exports2.STATUSES.UNAUTHORIZED,
      exports2.STATUSES.PAYMENT_REQUIRED,
      exports2.STATUSES.FORBIDDEN,
      exports2.STATUSES.NOT_FOUND,
      exports2.STATUSES.METHOD_NOT_ALLOWED,
      exports2.STATUSES.NOT_ACCEPTABLE,
      exports2.STATUSES.PROXY_AUTHENTICATION_REQUIRED,
      exports2.STATUSES.REQUEST_TIMEOUT,
      exports2.STATUSES.CONFLICT,
      exports2.STATUSES.GONE,
      exports2.STATUSES.LENGTH_REQUIRED,
      exports2.STATUSES.PRECONDITION_FAILED,
      exports2.STATUSES.PAYLOAD_TOO_LARGE,
      exports2.STATUSES.URI_TOO_LONG,
      exports2.STATUSES.UNSUPPORTED_MEDIA_TYPE,
      exports2.STATUSES.RANGE_NOT_SATISFIABLE,
      exports2.STATUSES.EXPECTATION_FAILED,
      exports2.STATUSES.IM_A_TEAPOT,
      exports2.STATUSES.PAGE_EXPIRED,
      exports2.STATUSES.ENHANCE_YOUR_CALM,
      exports2.STATUSES.MISDIRECTED_REQUEST,
      exports2.STATUSES.UNPROCESSABLE_ENTITY,
      exports2.STATUSES.LOCKED,
      exports2.STATUSES.FAILED_DEPENDENCY,
      exports2.STATUSES.TOO_EARLY,
      exports2.STATUSES.UPGRADE_REQUIRED,
      exports2.STATUSES.PRECONDITION_REQUIRED,
      exports2.STATUSES.TOO_MANY_REQUESTS,
      exports2.STATUSES.REQUEST_HEADER_FIELDS_TOO_LARGE_UNOFFICIAL,
      exports2.STATUSES.REQUEST_HEADER_FIELDS_TOO_LARGE,
      exports2.STATUSES.LOGIN_TIMEOUT,
      exports2.STATUSES.NO_RESPONSE,
      exports2.STATUSES.RETRY_WITH,
      exports2.STATUSES.BLOCKED_BY_PARENTAL_CONTROL,
      exports2.STATUSES.UNAVAILABLE_FOR_LEGAL_REASONS,
      exports2.STATUSES.CLIENT_CLOSED_LOAD_BALANCED_REQUEST,
      exports2.STATUSES.INVALID_X_FORWARDED_FOR,
      exports2.STATUSES.REQUEST_HEADER_TOO_LARGE,
      exports2.STATUSES.SSL_CERTIFICATE_ERROR,
      exports2.STATUSES.SSL_CERTIFICATE_REQUIRED,
      exports2.STATUSES.HTTP_REQUEST_SENT_TO_HTTPS_PORT,
      exports2.STATUSES.INVALID_TOKEN,
      exports2.STATUSES.CLIENT_CLOSED_REQUEST,
      exports2.STATUSES.INTERNAL_SERVER_ERROR,
      exports2.STATUSES.NOT_IMPLEMENTED,
      exports2.STATUSES.BAD_GATEWAY,
      exports2.STATUSES.SERVICE_UNAVAILABLE,
      exports2.STATUSES.GATEWAY_TIMEOUT,
      exports2.STATUSES.HTTP_VERSION_NOT_SUPPORTED,
      exports2.STATUSES.VARIANT_ALSO_NEGOTIATES,
      exports2.STATUSES.INSUFFICIENT_STORAGE,
      exports2.STATUSES.LOOP_DETECTED,
      exports2.STATUSES.BANDWIDTH_LIMIT_EXCEEDED,
      exports2.STATUSES.NOT_EXTENDED,
      exports2.STATUSES.NETWORK_AUTHENTICATION_REQUIRED,
      exports2.STATUSES.WEB_SERVER_UNKNOWN_ERROR,
      exports2.STATUSES.WEB_SERVER_IS_DOWN,
      exports2.STATUSES.CONNECTION_TIMEOUT,
      exports2.STATUSES.ORIGIN_IS_UNREACHABLE,
      exports2.STATUSES.TIMEOUT_OCCURED,
      exports2.STATUSES.SSL_HANDSHAKE_FAILED,
      exports2.STATUSES.INVALID_SSL_CERTIFICATE,
      exports2.STATUSES.RAILGUN_ERROR,
      exports2.STATUSES.SITE_IS_OVERLOADED,
      exports2.STATUSES.SITE_IS_FROZEN,
      exports2.STATUSES.IDENTITY_PROVIDER_AUTHENTICATION_ERROR,
      exports2.STATUSES.NETWORK_READ_TIMEOUT,
      exports2.STATUSES.NETWORK_CONNECT_TIMEOUT
    ];
    exports2.ALPHA = [];
    for (let i6 = "A".charCodeAt(0); i6 <= "Z".charCodeAt(0); i6++) {
      exports2.ALPHA.push(String.fromCharCode(i6));
      exports2.ALPHA.push(String.fromCharCode(i6 + 32));
    }
    exports2.NUM_MAP = {
      0: 0,
      1: 1,
      2: 2,
      3: 3,
      4: 4,
      5: 5,
      6: 6,
      7: 7,
      8: 8,
      9: 9
    };
    exports2.HEX_MAP = {
      0: 0,
      1: 1,
      2: 2,
      3: 3,
      4: 4,
      5: 5,
      6: 6,
      7: 7,
      8: 8,
      9: 9,
      A: 10,
      B: 11,
      C: 12,
      D: 13,
      E: 14,
      F: 15,
      a: 10,
      b: 11,
      c: 12,
      d: 13,
      e: 14,
      f: 15
    };
    exports2.NUM = [
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9"
    ];
    exports2.ALPHANUM = exports2.ALPHA.concat(exports2.NUM);
    exports2.MARK = ["-", "_", ".", "!", "~", "*", "'", "(", ")"];
    exports2.USERINFO_CHARS = exports2.ALPHANUM.concat(exports2.MARK).concat(["%", ";", ":", "&", "=", "+", "$", ","]);
    exports2.URL_CHAR = [
      "!",
      '"',
      "$",
      "%",
      "&",
      "'",
      "(",
      ")",
      "*",
      "+",
      ",",
      "-",
      ".",
      "/",
      ":",
      ";",
      "<",
      "=",
      ">",
      "@",
      "[",
      "\\",
      "]",
      "^",
      "_",
      "`",
      "{",
      "|",
      "}",
      "~"
    ].concat(exports2.ALPHANUM);
    exports2.HEX = exports2.NUM.concat(["a", "b", "c", "d", "e", "f", "A", "B", "C", "D", "E", "F"]);
    exports2.TOKEN = [
      "!",
      "#",
      "$",
      "%",
      "&",
      "'",
      "*",
      "+",
      "-",
      ".",
      "^",
      "_",
      "`",
      "|",
      "~"
    ].concat(exports2.ALPHANUM);
    exports2.HEADER_CHARS = ["	"];
    for (let i6 = 32; i6 <= 255; i6++) {
      if (i6 !== 127) {
        exports2.HEADER_CHARS.push(i6);
      }
    }
    exports2.CONNECTION_TOKEN_CHARS = exports2.HEADER_CHARS.filter((c7) => c7 !== 44);
    exports2.QUOTED_STRING = ["	", " "];
    for (let i6 = 33; i6 <= 255; i6++) {
      if (i6 !== 34 && i6 !== 92) {
        exports2.QUOTED_STRING.push(i6);
      }
    }
    exports2.HTAB_SP_VCHAR_OBS_TEXT = ["	", " "];
    for (let i6 = 33; i6 <= 126; i6++) {
      exports2.HTAB_SP_VCHAR_OBS_TEXT.push(i6);
    }
    for (let i6 = 128; i6 <= 255; i6++) {
      exports2.HTAB_SP_VCHAR_OBS_TEXT.push(i6);
    }
    exports2.MAJOR = exports2.NUM_MAP;
    exports2.MINOR = exports2.MAJOR;
    exports2.SPECIAL_HEADERS = {
      "connection": exports2.HEADER_STATE.CONNECTION,
      "content-length": exports2.HEADER_STATE.CONTENT_LENGTH,
      "proxy-connection": exports2.HEADER_STATE.CONNECTION,
      "transfer-encoding": exports2.HEADER_STATE.TRANSFER_ENCODING,
      "upgrade": exports2.HEADER_STATE.UPGRADE
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/llhttp/llhttp-wasm.js
var require_llhttp_wasm = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/llhttp/llhttp-wasm.js"(exports2, module3) {
    init_import_meta_url();
    var { Buffer: Buffer7 } = __require("buffer");
    var wasmBase64 = "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";
    var wasmBuffer;
    Object.defineProperty(module3, "exports", {
      get: /* @__PURE__ */ __name(() => {
        return wasmBuffer ? wasmBuffer : wasmBuffer = Buffer7.from(wasmBase64, "base64");
      }, "get")
    });
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/llhttp/llhttp_simd-wasm.js
var require_llhttp_simd_wasm = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/llhttp/llhttp_simd-wasm.js"(exports2, module3) {
    init_import_meta_url();
    var { Buffer: Buffer7 } = __require("buffer");
    var wasmBase64 = "AGFzbQEAAAABJwdgAX8Bf2ADf39/AX9gAn9/AGABfwBgBH9/f38Bf2AAAGADf39/AALLAQgDZW52GHdhc21fb25faGVhZGVyc19jb21wbGV0ZQAEA2VudhV3YXNtX29uX21lc3NhZ2VfYmVnaW4AAANlbnYLd2FzbV9vbl91cmwAAQNlbnYOd2FzbV9vbl9zdGF0dXMAAQNlbnYUd2FzbV9vbl9oZWFkZXJfZmllbGQAAQNlbnYUd2FzbV9vbl9oZWFkZXJfdmFsdWUAAQNlbnYMd2FzbV9vbl9ib2R5AAEDZW52GHdhc21fb25fbWVzc2FnZV9jb21wbGV0ZQAAAzQzBQYAAAMAAAAAAAADAQMAAwMDAAACAAAAAAICAgICAgICAgIBAQEBAQEBAQEDAAADAAAABAUBcAESEgUDAQACBggBfwFBgNgECwfFBygGbWVtb3J5AgALX2luaXRpYWxpemUACBlfX2luZGlyZWN0X2Z1bmN0aW9uX3RhYmxlAQALbGxodHRwX2luaXQACRhsbGh0dHBfc2hvdWxkX2tlZXBfYWxpdmUANgxsbGh0dHBfYWxsb2MACwZtYWxsb2MAOAtsbGh0dHBfZnJlZQAMBGZyZWUADA9sbGh0dHBfZ2V0X3R5cGUADRVsbGh0dHBfZ2V0X2h0dHBfbWFqb3IADhVsbGh0dHBfZ2V0X2h0dHBfbWlub3IADxFsbGh0dHBfZ2V0X21ldGhvZAAQFmxsaHR0cF9nZXRfc3RhdHVzX2NvZGUAERJsbGh0dHBfZ2V0X3VwZ3JhZGUAEgxsbGh0dHBfcmVzZXQAEw5sbGh0dHBfZXhlY3V0ZQAUFGxsaHR0cF9zZXR0aW5nc19pbml0ABUNbGxodHRwX2ZpbmlzaAAWDGxsaHR0cF9wYXVzZQAXDWxsaHR0cF9yZXN1bWUAGBtsbGh0dHBfcmVzdW1lX2FmdGVyX3VwZ3JhZGUAGRBsbGh0dHBfZ2V0X2Vycm5vABoXbGxodHRwX2dldF9lcnJvcl9yZWFzb24AGxdsbGh0dHBfc2V0X2Vycm9yX3JlYXNvbgAcFGxsaHR0cF9nZXRfZXJyb3JfcG9zAB0RbGxodHRwX2Vycm5vX25hbWUAHhJsbGh0dHBfbWV0aG9kX25hbWUAHxJsbGh0dHBfc3RhdHVzX25hbWUAIBpsbGh0dHBfc2V0X2xlbmllbnRfaGVhZGVycwAhIWxsaHR0cF9zZXRfbGVuaWVudF9jaHVua2VkX2xlbmd0aAAiHWxsaHR0cF9zZXRfbGVuaWVudF9rZWVwX2FsaXZlACMkbGxodHRwX3NldF9sZW5pZW50X3RyYW5zZmVyX2VuY29kaW5nACQabGxodHRwX3NldF9sZW5pZW50X3ZlcnNpb24AJSNsbGh0dHBfc2V0X2xlbmllbnRfZGF0YV9hZnRlcl9jbG9zZQAmJ2xsaHR0cF9zZXRfbGVuaWVudF9vcHRpb25hbF9sZl9hZnRlcl9jcgAnLGxsaHR0cF9zZXRfbGVuaWVudF9vcHRpb25hbF9jcmxmX2FmdGVyX2NodW5rACgobGxodHRwX3NldF9sZW5pZW50X29wdGlvbmFsX2NyX2JlZm9yZV9sZgApKmxsaHR0cF9zZXRfbGVuaWVudF9zcGFjZXNfYWZ0ZXJfY2h1bmtfc2l6ZQAqGGxsaHR0cF9tZXNzYWdlX25lZWRzX2VvZgA1CRcBAEEBCxEBAgMEBQoGBzEzMi0uLCsvMArYywIzFgBB/NMAKAIABEAAC0H80wBBATYCAAsUACAAEDcgACACNgI4IAAgAToAKAsUACAAIAAvATQgAC0AMCAAEDYQAAseAQF/QcAAEDkiARA3IAFBgAg2AjggASAAOgAoIAELjwwBB38CQCAARQ0AIABBCGsiASAAQQRrKAIAIgBBeHEiBGohBQJAIABBAXENACAAQQNxRQ0BIAEgASgCACIAayIBQZDUACgCAEkNASAAIARqIQQCQAJAQZTUACgCACABRwRAIABB/wFNBEAgAEEDdiEDIAEoAggiACABKAIMIgJGBEBBgNQAQYDUACgCAEF+IAN3cTYCAAwFCyACIAA2AgggACACNgIMDAQLIAEoAhghBiABIAEoAgwiAEcEQCAAIAEoAggiAjYCCCACIAA2AgwMAwsgAUEUaiIDKAIAIgJFBEAgASgCECICRQ0CIAFBEGohAwsDQCADIQcgAiIAQRRqIgMoAgAiAg0AIABBEGohAyAAKAIQIgINAAsgB0EANgIADAILIAUoAgQiAEEDcUEDRw0CIAUgAEF+cTYCBEGI1AAgBDYCACAFIAQ2AgAgASAEQQFyNgIEDAMLQQAhAAsgBkUNAAJAIAEoAhwiAkECdEGw1gBqIgMoAgAgAUYEQCADIAA2AgAgAA0BQYTUAEGE1AAoAgBBfiACd3E2AgAMAgsgBkEQQRQgBigCECABRhtqIAA2AgAgAEUNAQsgACAGNgIYIAEoAhAiAgRAIAAgAjYCECACIAA2AhgLIAFBFGooAgAiAkUNACAAQRRqIAI2AgAgAiAANgIYCyABIAVPDQAgBSgCBCIAQQFxRQ0AAkACQAJAAkAgAEECcUUEQEGY1AAoAgAgBUYEQEGY1AAgATYCAEGM1ABBjNQAKAIAIARqIgA2AgAgASAAQQFyNgIEIAFBlNQAKAIARw0GQYjUAEEANgIAQZTUAEEANgIADAYLQZTUACgCACAFRgRAQZTUACABNgIAQYjUAEGI1AAoAgAgBGoiADYCACABIABBAXI2AgQgACABaiAANgIADAYLIABBeHEgBGohBCAAQf8BTQRAIABBA3YhAyAFKAIIIgAgBSgCDCICRgRAQYDUAEGA1AAoAgBBfiADd3E2AgAMBQsgAiAANgIIIAAgAjYCDAwECyAFKAIYIQYgBSAFKAIMIgBHBEBBkNQAKAIAGiAAIAUoAggiAjYCCCACIAA2AgwMAwsgBUEUaiIDKAIAIgJFBEAgBSgCECICRQ0CIAVBEGohAwsDQCADIQcgAiIAQRRqIgMoAgAiAg0AIABBEGohAyAAKAIQIgINAAsgB0EANgIADAILIAUgAEF+cTYCBCABIARqIAQ2AgAgASAEQQFyNgIEDAMLQQAhAAsgBkUNAAJAIAUoAhwiAkECdEGw1gBqIgMoAgAgBUYEQCADIAA2AgAgAA0BQYTUAEGE1AAoAgBBfiACd3E2AgAMAgsgBkEQQRQgBigCECAFRhtqIAA2AgAgAEUNAQsgACAGNgIYIAUoAhAiAgRAIAAgAjYCECACIAA2AhgLIAVBFGooAgAiAkUNACAAQRRqIAI2AgAgAiAANgIYCyABIARqIAQ2AgAgASAEQQFyNgIEIAFBlNQAKAIARw0AQYjUACAENgIADAELIARB/wFNBEAgBEF4cUGo1ABqIQACf0GA1AAoAgAiAkEBIARBA3Z0IgNxRQRAQYDUACACIANyNgIAIAAMAQsgACgCCAsiAiABNgIMIAAgATYCCCABIAA2AgwgASACNgIIDAELQR8hAiAEQf///wdNBEAgBEEmIARBCHZnIgBrdkEBcSAAQQF0a0E+aiECCyABIAI2AhwgAUIANwIQIAJBAnRBsNYAaiEAAkBBhNQAKAIAIgNBASACdCIHcUUEQCAAIAE2AgBBhNQAIAMgB3I2AgAgASAANgIYIAEgATYCCCABIAE2AgwMAQsgBEEZIAJBAXZrQQAgAkEfRxt0IQIgACgCACEAAkADQCAAIgMoAgRBeHEgBEYNASACQR12IQAgAkEBdCECIAMgAEEEcWpBEGoiBygCACIADQALIAcgATYCACABIAM2AhggASABNgIMIAEgATYCCAwBCyADKAIIIgAgATYCDCADIAE2AgggAUEANgIYIAEgAzYCDCABIAA2AggLQaDUAEGg1AAoAgBBAWsiAEF/IAAbNgIACwsHACAALQAoCwcAIAAtACoLBwAgAC0AKwsHACAALQApCwcAIAAvATQLBwAgAC0AMAtAAQR/IAAoAhghASAALwEuIQIgAC0AKCEDIAAoAjghBCAAEDcgACAENgI4IAAgAzoAKCAAIAI7AS4gACABNgIYC8X4AQIHfwN+IAEgAmohBAJAIAAiAygCDCIADQAgAygCBARAIAMgATYCBAsjAEEQayIJJAACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAn8CQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAgAygCHCICQQFrDuwB7gEB6AECAwQFBgcICQoLDA0ODxAREucBE+YBFBXlARYX5AEYGRobHB0eHyDvAe0BIeMBIiMkJSYnKCkqK+IBLC0uLzAxMuEB4AEzNN8B3gE1Njc4OTo7PD0+P0BBQkNERUZHSElKS0xNTk/pAVBRUlPdAdwBVNsBVdoBVldYWVpbXF1eX2BhYmNkZWZnaGlqa2xtbm9wcXJzdHV2d3h5ent8fX5/gAGBAYIBgwGEAYUBhgGHAYgBiQGKAYsBjAGNAY4BjwGQAZEBkgGTAZQBlQGWAZcBmAGZAZoBmwGcAZ0BngGfAaABoQGiAaMBpAGlAaYBpwGoAakBqgGrAawBrQGuAa8BsAGxAbIBswG0AbUBtgG3AbgBuQG6AbsBvAG9Ab4BvwHAAcEBwgHDAcQBxQHZAdgBxgHXAccB1gHIAckBygHLAcwBzQHOAc8B0AHRAdIB0wHUAQDqAQtBAAzUAQtBDgzTAQtBDQzSAQtBDwzRAQtBEAzQAQtBEQzPAQtBEgzOAQtBEwzNAQtBFAzMAQtBFQzLAQtBFgzKAQtBFwzJAQtBGAzIAQtBGQzHAQtBGgzGAQtBGwzFAQtBHAzEAQtBHQzDAQtBHgzCAQtBHwzBAQtBCAzAAQtBIAy/AQtBIgy+AQtBIQy9AQtBBwy8AQtBIwy7AQtBJAy6AQtBJQy5AQtBJgy4AQtBJwy3AQtBzgEMtgELQSgMtQELQSkMtAELQSoMswELQSsMsgELQc8BDLEBC0EtDLABC0EuDK8BC0EvDK4BC0EwDK0BC0ExDKwBC0EyDKsBC0EzDKoBC0HQAQypAQtBNAyoAQtBOAynAQtBDAymAQtBNQylAQtBNgykAQtBNwyjAQtBPQyiAQtBOQyhAQtB0QEMoAELQQsMnwELQT4MngELQToMnQELQQoMnAELQTsMmwELQTwMmgELQdIBDJkBC0HAAAyYAQtBPwyXAQtBwQAMlgELQQkMlQELQSwMlAELQcIADJMBC0HDAAySAQtBxAAMkQELQcUADJABC0HGAAyPAQtBxwAMjgELQcgADI0BC0HJAAyMAQtBygAMiwELQcsADIoBC0HMAAyJAQtBzQAMiAELQc4ADIcBC0HPAAyGAQtB0AAMhQELQdEADIQBC0HSAAyDAQtB1AAMggELQdMADIEBC0HVAAyAAQtB1gAMfwtB1wAMfgtB2AAMfQtB2QAMfAtB2gAMewtB2wAMegtB0wEMeQtB3AAMeAtB3QAMdwtBBgx2C0HeAAx1C0EFDHQLQd8ADHMLQQQMcgtB4AAMcQtB4QAMcAtB4gAMbwtB4wAMbgtBAwxtC0HkAAxsC0HlAAxrC0HmAAxqC0HoAAxpC0HnAAxoC0HpAAxnC0HqAAxmC0HrAAxlC0HsAAxkC0ECDGMLQe0ADGILQe4ADGELQe8ADGALQfAADF8LQfEADF4LQfIADF0LQfMADFwLQfQADFsLQfUADFoLQfYADFkLQfcADFgLQfgADFcLQfkADFYLQfoADFULQfsADFQLQfwADFMLQf0ADFILQf4ADFELQf8ADFALQYABDE8LQYEBDE4LQYIBDE0LQYMBDEwLQYQBDEsLQYUBDEoLQYYBDEkLQYcBDEgLQYgBDEcLQYkBDEYLQYoBDEULQYsBDEQLQYwBDEMLQY0BDEILQY4BDEELQY8BDEALQZABDD8LQZEBDD4LQZIBDD0LQZMBDDwLQZQBDDsLQZUBDDoLQZYBDDkLQZcBDDgLQZgBDDcLQZkBDDYLQZoBDDULQZsBDDQLQZwBDDMLQZ0BDDILQZ4BDDELQZ8BDDALQaABDC8LQaEBDC4LQaIBDC0LQaMBDCwLQaQBDCsLQaUBDCoLQaYBDCkLQacBDCgLQagBDCcLQakBDCYLQaoBDCULQasBDCQLQawBDCMLQa0BDCILQa4BDCELQa8BDCALQbABDB8LQbEBDB4LQbIBDB0LQbMBDBwLQbQBDBsLQbUBDBoLQbYBDBkLQbcBDBgLQbgBDBcLQQEMFgtBuQEMFQtBugEMFAtBuwEMEwtBvAEMEgtBvQEMEQtBvgEMEAtBvwEMDwtBwAEMDgtBwQEMDQtBwgEMDAtBwwEMCwtBxAEMCgtBxQEMCQtBxgEMCAtB1AEMBwtBxwEMBgtByAEMBQtByQEMBAtBygEMAwtBywEMAgtBzQEMAQtBzAELIQIDQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAIAMCfwJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACfwJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAn8CQAJAAkACQAJAAkACQAJ/AkACQAJAAn8CQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAIAMCfwJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACfwJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQCACDtQBAAECAwQFBgcICQoLDA0ODxARFBUWFxgZGhscHR4fICEjJCUnKCmIA4cDhQOEA/wC9QLuAusC6ALmAuMC4ALfAt0C2wLWAtUC1ALTAtICygLJAsgCxwLGAsUCxALDAr0CvAK6ArkCuAK3ArYCtQK0ArICsQKsAqoCqAKnAqYCpQKkAqMCogKhAqACnwKbApoCmQKYApcCkAKIAoQCgwKCAvkB9gH1AfQB8wHyAfEB8AHvAe0B6wHoAeMB4QHgAd8B3gHdAdwB2wHaAdkB2AHXAdYB1QHUAdIB0QHQAc8BzgHNAcwBywHKAckByAHHAcYBxQHEAcMBwgHBAcABvwG+Ab0BvAG7AboBuQG4AbcBtgG1AbQBswGyAbEBsAGvAa4BrQGsAasBqgGpAagBpwGmAaUBpAGjAaIBoQGgAZ8BngGdAZwBmwGaAZcBlgGRAZABjwGOAY0BjAGLAYoBiQGIAYUBhAGDAX59fHt6d3Z1LFFSU1RVVgsgASAERw1zQewBIQIMqQMLIAEgBEcNkAFB0QEhAgyoAwsgASAERw3pAUGEASECDKcDCyABIARHDfQBQfoAIQIMpgMLIAEgBEcNggJB9QAhAgylAwsgASAERw2JAkHzACECDKQDCyABIARHDYwCQfEAIQIMowMLIAEgBEcNHkEeIQIMogMLIAEgBEcNGUEYIQIMoQMLIAEgBEcNuAJBzQAhAgygAwsgASAERw3DAkHGACECDJ8DCyABIARHDcQCQcMAIQIMngMLIAEgBEcNygJBOCECDJ0DCyADLQAwQQFGDZUDDPICC0EAIQACQAJAAkAgAy0AKkUNACADLQArRQ0AIAMvATIiAkECcUUNAQwCCyADLwEyIgJBAXFFDQELQQEhACADLQAoQQFGDQAgAy8BNCIGQeQAa0HkAEkNACAGQcwBRg0AIAZBsAJGDQAgAkHAAHENAEEAIQAgAkGIBHFBgARGDQAgAkEocUEARyEACyADQQA7ATIgA0EAOgAxAkAgAEUEQCADQQA6ADEgAy0ALkEEcQ0BDJwDCyADQgA3AyALIANBADoAMSADQQE6ADYMSQtBACEAAkAgAygCOCICRQ0AIAIoAiwiAkUNACADIAIRAAAhAAsgAEUNSSAAQRVHDWMgA0EENgIcIAMgATYCFCADQb0aNgIQIANBFTYCDEEAIQIMmgMLIAEgBEYEQEEGIQIMmgMLIAEtAABBCkYNGQwBCyABIARGBEBBByECDJkDCwJAIAEtAABBCmsOBAIBAQABCyABQQFqIQFBECECDP4CCyADLQAuQYABcQ0YQQAhAiADQQA2AhwgAyABNgIUIANBqR82AhAgA0ECNgIMDJcDCyABQQFqIQEgA0Evai0AAEEBcQ0XQQAhAiADQQA2AhwgAyABNgIUIANBhB82AhAgA0EZNgIMDJYDCyADIAMpAyAiDCAEIAFrrSIKfSILQgAgCyAMWBs3AyAgCiAMWg0ZQQghAgyVAwsgASAERwRAIANBCTYCCCADIAE2AgRBEiECDPsCC0EJIQIMlAMLIAMpAyBQDZwCDEQLIAEgBEYEQEELIQIMkwMLIAEtAABBCkcNFyABQQFqIQEMGAsgA0Evai0AAEEBcUUNGgwnC0EAIQACQCADKAI4IgJFDQAgAigCSCICRQ0AIAMgAhEAACEACyAADRoMQwtBACEAAkAgAygCOCICRQ0AIAIoAkgiAkUNACADIAIRAAAhAAsgAA0bDCULQQAhAAJAIAMoAjgiAkUNACACKAJIIgJFDQAgAyACEQAAIQALIAANHAwzCyADQS9qLQAAQQFxRQ0dDCMLQQAhAAJAIAMoAjgiAkUNACACKAJMIgJFDQAgAyACEQAAIQALIAANHQxDC0EAIQACQCADKAI4IgJFDQAgAigCTCICRQ0AIAMgAhEAACEACyAADR4MIQsgASAERgRAQRMhAgyLAwsCQCABLQAAIgBBCmsOBCAkJAAjCyABQQFqIQEMIAtBACEAAkAgAygCOCICRQ0AIAIoAkwiAkUNACADIAIRAAAhAAsgAA0jDEMLIAEgBEYEQEEWIQIMiQMLIAEtAABB8D9qLQAAQQFHDSQM7QILAkADQCABLQAAQeA5ai0AACIAQQFHBEACQCAAQQJrDgIDACgLIAFBAWohAUEfIQIM8AILIAQgAUEBaiIBRw0AC0EYIQIMiAMLIAMoAgQhAEEAIQIgA0EANgIEIAMgACABQQFqIgEQMyIADSIMQgtBACEAAkAgAygCOCICRQ0AIAIoAkwiAkUNACADIAIRAAAhAAsgAA0kDCsLIAEgBEYEQEEcIQIMhgMLIANBCjYCCCADIAE2AgRBACEAAkAgAygCOCICRQ0AIAIoAkgiAkUNACADIAIRAAAhAAsgAA0mQSIhAgzrAgsgASAERwRAA0AgAS0AAEHgO2otAAAiAEEDRwRAIABBAWsOBRkbJ+wCJicLIAQgAUEBaiIBRw0AC0EbIQIMhQMLQRshAgyEAwsDQCABLQAAQeA9ai0AACIAQQNHBEAgAEEBaw4FEBIoFCcoCyAEIAFBAWoiAUcNAAtBHiECDIMDCyABIARHBEAgA0ELNgIIIAMgATYCBEEHIQIM6QILQR8hAgyCAwsgASAERgRAQSAhAgyCAwsCQCABLQAAQQ1rDhQvQEBAQEBAQEBAQEBAQEBAQEBAAEALQQAhAiADQQA2AhwgA0G3CzYCECADQQI2AgwgAyABQQFqNgIUDIEDCyADQS9qIQIDQCABIARGBEBBISECDIIDCwJAAkACQCABLQAAIgBBCWsOGAIAKioBKioqKioqKioqKioqKioqKioqAigLIAFBAWohASADQS9qLQAAQQFxRQ0LDBkLIAFBAWohAQwYCyABQQFqIQEgAi0AAEECcQ0AC0EAIQIgA0EANgIcIAMgATYCFCADQc4UNgIQIANBDDYCDAyAAwsgAUEBaiEBC0EAIQACQCADKAI4IgJFDQAgAigCVCICRQ0AIAMgAhEAACEACyAADQEM0QILIANCADcDIAw8CyAAQRVGBEAgA0EkNgIcIAMgATYCFCADQYYaNgIQIANBFTYCDEEAIQIM/QILQQAhAiADQQA2AhwgAyABNgIUIANB4g02AhAgA0EUNgIMDPwCCyADKAIEIQBBACECIANBADYCBCADIAAgASAMp2oiARAxIgBFDSsgA0EHNgIcIAMgATYCFCADIAA2AgwM+wILIAMtAC5BwABxRQ0BC0EAIQACQCADKAI4IgJFDQAgAigCUCICRQ0AIAMgAhEAACEACyAARQ0rIABBFUYEQCADQQo2AhwgAyABNgIUIANB8Rg2AhAgA0EVNgIMQQAhAgz6AgtBACECIANBADYCHCADIAE2AhQgA0GLDDYCECADQRM2AgwM+QILQQAhAiADQQA2AhwgAyABNgIUIANBsRQ2AhAgA0ECNgIMDPgCC0EAIQIgA0EANgIcIAMgATYCFCADQYwUNgIQIANBGTYCDAz3AgtBACECIANBADYCHCADIAE2AhQgA0HRHDYCECADQRk2AgwM9gILIABBFUYNPUEAIQIgA0EANgIcIAMgATYCFCADQaIPNgIQIANBIjYCDAz1AgsgAygCBCEAQQAhAiADQQA2AgQgAyAAIAEQMiIARQ0oIANBDTYCHCADIAE2AhQgAyAANgIMDPQCCyAAQRVGDTpBACECIANBADYCHCADIAE2AhQgA0GiDzYCECADQSI2AgwM8wILIAMoAgQhAEEAIQIgA0EANgIEIAMgACABEDIiAEUEQCABQQFqIQEMKAsgA0EONgIcIAMgADYCDCADIAFBAWo2AhQM8gILIABBFUYNN0EAIQIgA0EANgIcIAMgATYCFCADQaIPNgIQIANBIjYCDAzxAgsgAygCBCEAQQAhAiADQQA2AgQgAyAAIAEQMiIARQRAIAFBAWohAQwnCyADQQ82AhwgAyAANgIMIAMgAUEBajYCFAzwAgtBACECIANBADYCHCADIAE2AhQgA0HoFjYCECADQRk2AgwM7wILIABBFUYNM0EAIQIgA0EANgIcIAMgATYCFCADQc4MNgIQIANBIzYCDAzuAgsgAygCBCEAQQAhAiADQQA2AgQgAyAAIAEQMyIARQ0lIANBETYCHCADIAE2AhQgAyAANgIMDO0CCyAAQRVGDTBBACECIANBADYCHCADIAE2AhQgA0HODDYCECADQSM2AgwM7AILIAMoAgQhAEEAIQIgA0EANgIEIAMgACABEDMiAEUEQCABQQFqIQEMJQsgA0ESNgIcIAMgADYCDCADIAFBAWo2AhQM6wILIANBL2otAABBAXFFDQELQRUhAgzPAgtBACECIANBADYCHCADIAE2AhQgA0HoFjYCECADQRk2AgwM6AILIABBO0cNACABQQFqIQEMDAtBACECIANBADYCHCADIAE2AhQgA0GYFzYCECADQQI2AgwM5gILIABBFUYNKEEAIQIgA0EANgIcIAMgATYCFCADQc4MNgIQIANBIzYCDAzlAgsgA0EUNgIcIAMgATYCFCADIAA2AgwM5AILIAMoAgQhAEEAIQIgA0EANgIEIAMgACABEDMiAEUEQCABQQFqIQEM3AILIANBFTYCHCADIAA2AgwgAyABQQFqNgIUDOMCCyADKAIEIQBBACECIANBADYCBCADIAAgARAzIgBFBEAgAUEBaiEBDNoCCyADQRc2AhwgAyAANgIMIAMgAUEBajYCFAziAgsgAEEVRg0jQQAhAiADQQA2AhwgAyABNgIUIANBzgw2AhAgA0EjNgIMDOECCyADKAIEIQBBACECIANBADYCBCADIAAgARAzIgBFBEAgAUEBaiEBDB0LIANBGTYCHCADIAA2AgwgAyABQQFqNgIUDOACCyADKAIEIQBBACECIANBADYCBCADIAAgARAzIgBFBEAgAUEBaiEBDNYCCyADQRo2AhwgAyAANgIMIAMgAUEBajYCFAzfAgsgAEEVRg0fQQAhAiADQQA2AhwgAyABNgIUIANBog82AhAgA0EiNgIMDN4CCyADKAIEIQBBACECIANBADYCBCADIAAgARAyIgBFBEAgAUEBaiEBDBsLIANBHDYCHCADIAA2AgwgAyABQQFqNgIUDN0CCyADKAIEIQBBACECIANBADYCBCADIAAgARAyIgBFBEAgAUEBaiEBDNICCyADQR02AhwgAyAANgIMIAMgAUEBajYCFAzcAgsgAEE7Rw0BIAFBAWohAQtBJCECDMACC0EAIQIgA0EANgIcIAMgATYCFCADQc4UNgIQIANBDDYCDAzZAgsgASAERwRAA0AgAS0AAEEgRw3xASAEIAFBAWoiAUcNAAtBLCECDNkCC0EsIQIM2AILIAEgBEYEQEE0IQIM2AILAkACQANAAkAgAS0AAEEKaw4EAgAAAwALIAQgAUEBaiIBRw0AC0E0IQIM2QILIAMoAgQhACADQQA2AgQgAyAAIAEQMCIARQ2MAiADQTI2AhwgAyABNgIUIAMgADYCDEEAIQIM2AILIAMoAgQhACADQQA2AgQgAyAAIAEQMCIARQRAIAFBAWohAQyMAgsgA0EyNgIcIAMgADYCDCADIAFBAWo2AhRBACECDNcCCyABIARHBEACQANAIAEtAABBMGsiAEH/AXFBCk8EQEE5IQIMwAILIAMpAyAiC0KZs+bMmbPmzBlWDQEgAyALQgp+Igo3AyAgCiAArUL/AYMiC0J/hVYNASADIAogC3w3AyAgBCABQQFqIgFHDQALQcAAIQIM2AILIAMoAgQhACADQQA2AgQgAyAAIAFBAWoiARAwIgANFwzJAgtBwAAhAgzWAgsgASAERgRAQckAIQIM1gILAkADQAJAIAEtAABBCWsOGAACjwKPApMCjwKPAo8CjwKPAo8CjwKPAo8CjwKPAo8CjwKPAo8CjwKPAo8CAI8CCyAEIAFBAWoiAUcNAAtByQAhAgzWAgsgAUEBaiEBIANBL2otAABBAXENjwIgA0EANgIcIAMgATYCFCADQekPNgIQIANBCjYCDEEAIQIM1QILIAEgBEcEQANAIAEtAAAiAEEgRwRAAkACQAJAIABByABrDgsAAc0BzQHNAc0BzQHNAc0BzQECzQELIAFBAWohAUHZACECDL8CCyABQQFqIQFB2gAhAgy+AgsgAUEBaiEBQdsAIQIMvQILIAQgAUEBaiIBRw0AC0HuACECDNUCC0HuACECDNQCCyADQQI6ACgMMAtBACECIANBADYCHCADQbcLNgIQIANBAjYCDCADIAFBAWo2AhQM0gILQQAhAgy3AgtBDSECDLYCC0ERIQIMtQILQRMhAgy0AgtBFCECDLMCC0EWIQIMsgILQRchAgyxAgtBGCECDLACC0EZIQIMrwILQRohAgyuAgtBGyECDK0CC0EcIQIMrAILQR0hAgyrAgtBHiECDKoCC0EgIQIMqQILQSEhAgyoAgtBIyECDKcCC0EnIQIMpgILIANBPTYCHCADIAE2AhQgAyAANgIMQQAhAgy/AgsgA0EbNgIcIAMgATYCFCADQY8bNgIQIANBFTYCDEEAIQIMvgILIANBIDYCHCADIAE2AhQgA0GeGTYCECADQRU2AgxBACECDL0CCyADQRM2AhwgAyABNgIUIANBnhk2AhAgA0EVNgIMQQAhAgy8AgsgA0ELNgIcIAMgATYCFCADQZ4ZNgIQIANBFTYCDEEAIQIMuwILIANBEDYCHCADIAE2AhQgA0GeGTYCECADQRU2AgxBACECDLoCCyADQSA2AhwgAyABNgIUIANBjxs2AhAgA0EVNgIMQQAhAgy5AgsgA0ELNgIcIAMgATYCFCADQY8bNgIQIANBFTYCDEEAIQIMuAILIANBDDYCHCADIAE2AhQgA0GPGzYCECADQRU2AgxBACECDLcCC0EAIQIgA0EANgIcIAMgATYCFCADQa8ONgIQIANBEjYCDAy2AgsCQANAAkAgAS0AAEEKaw4EAAICAAILIAQgAUEBaiIBRw0AC0HsASECDLYCCwJAAkAgAy0ANkEBRw0AQQAhAAJAIAMoAjgiAkUNACACKAJYIgJFDQAgAyACEQAAIQALIABFDQAgAEEVRw0BIANB6wE2AhwgAyABNgIUIANB4hg2AhAgA0EVNgIMQQAhAgy3AgtBzAEhAgycAgsgA0EANgIcIAMgATYCFCADQfELNgIQIANBHzYCDEEAIQIMtQILAkACQCADLQAoQQFrDgIEAQALQcsBIQIMmwILQcQBIQIMmgILIANBAjoAMUEAIQACQCADKAI4IgJFDQAgAigCACICRQ0AIAMgAhEAACEACyAARQRAQc0BIQIMmgILIABBFUcEQCADQQA2AhwgAyABNgIUIANBrAw2AhAgA0EQNgIMQQAhAgy0AgsgA0HqATYCHCADIAE2AhQgA0GHGTYCECADQRU2AgxBACECDLMCCyABIARGBEBB6QEhAgyzAgsgAS0AAEHIAEYNASADQQE6ACgLQbYBIQIMlwILQcoBIQIMlgILIAEgBEcEQCADQQw2AgggAyABNgIEQckBIQIMlgILQegBIQIMrwILIAEgBEYEQEHnASECDK8CCyABLQAAQcgARw0EIAFBAWohAUHIASECDJQCCyABIARGBEBB5gEhAgyuAgsCQAJAIAEtAABBxQBrDhAABQUFBQUFBQUFBQUFBQUBBQsgAUEBaiEBQcYBIQIMlAILIAFBAWohAUHHASECDJMCC0HlASECIAEgBEYNrAIgAygCACIAIAQgAWtqIQUgASAAa0ECaiEGAkADQCABLQAAIABB99MAai0AAEcNAyAAQQJGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAMrQILIAMoAgQhACADQgA3AwAgAyAAIAZBAWoiARAtIgBFBEBB1AEhAgyTAgsgA0HkATYCHCADIAE2AhQgAyAANgIMQQAhAgysAgtB4wEhAiABIARGDasCIAMoAgAiACAEIAFraiEFIAEgAGtBAWohBgJAA0AgAS0AACAAQfXTAGotAABHDQIgAEEBRg0BIABBAWohACAEIAFBAWoiAUcNAAsgAyAFNgIADKwCCyADQYEEOwEoIAMoAgQhACADQgA3AwAgAyAAIAZBAWoiARAtIgANAwwCCyADQQA2AgALQQAhAiADQQA2AhwgAyABNgIUIANB0B42AhAgA0EINgIMDKkCC0HFASECDI4CCyADQeIBNgIcIAMgATYCFCADIAA2AgxBACECDKcCC0EAIQACQCADKAI4IgJFDQAgAigCOCICRQ0AIAMgAhEAACEACyAARQ1lIABBFUcEQCADQQA2AhwgAyABNgIUIANB1A42AhAgA0EgNgIMQQAhAgynAgsgA0GFATYCHCADIAE2AhQgA0HXGjYCECADQRU2AgxBACECDKYCC0HhASECIAQgASIARg2lAiAEIAFrIAMoAgAiAWohBSAAIAFrQQRqIQYCQANAIAAtAAAgAUHw0wBqLQAARw0BIAFBBEYNAyABQQFqIQEgBCAAQQFqIgBHDQALIAMgBTYCAAymAgsgA0EANgIcIAMgADYCFCADQYQ3NgIQIANBCDYCDCADQQA2AgBBACECDKUCCyABIARHBEAgA0ENNgIIIAMgATYCBEHCASECDIsCC0HgASECDKQCCyADQQA2AgAgBkEBaiEBC0HDASECDIgCCyABIARGBEBB3wEhAgyiAgsgAS0AAEEwayIAQf8BcUEKSQRAIAMgADoAKiABQQFqIQFBwQEhAgyIAgsgAygCBCEAIANBADYCBCADIAAgARAuIgBFDYgCIANB3gE2AhwgAyABNgIUIAMgADYCDEEAIQIMoQILIAEgBEYEQEHdASECDKECCwJAIAEtAABBLkYEQCABQQFqIQEMAQsgAygCBCEAIANBADYCBCADIAAgARAuIgBFDYkCIANB3AE2AhwgAyABNgIUIAMgADYCDEEAIQIMoQILQcABIQIMhgILIAEgBEYEQEHbASECDKACC0EAIQBBASEFQQEhB0EAIQICQAJAAkACQAJAAn8CQAJAAkACQAJAAkACQCABLQAAQTBrDgoKCQABAgMEBQYICwtBAgwGC0EDDAULQQQMBAtBBQwDC0EGDAILQQcMAQtBCAshAkEAIQVBACEHDAILQQkhAkEBIQBBACEFQQAhBwwBC0EAIQVBASECCyADIAI6ACsgAUEBaiEBAkACQCADLQAuQRBxDQACQAJAAkAgAy0AKg4DAQACBAsgB0UNAwwCCyAADQEMAgsgBUUNAQsgAygCBCEAIANBADYCBCADIAAgARAuIgBFDQIgA0HYATYCHCADIAE2AhQgAyAANgIMQQAhAgyiAgsgAygCBCEAIANBADYCBCADIAAgARAuIgBFDYsCIANB2QE2AhwgAyABNgIUIAMgADYCDEEAIQIMoQILIAMoAgQhACADQQA2AgQgAyAAIAEQLiIARQ2JAiADQdoBNgIcIAMgATYCFCADIAA2AgwMoAILQb8BIQIMhQILQQAhAAJAIAMoAjgiAkUNACACKAI8IgJFDQAgAyACEQAAIQALAkAgAARAIABBFUYNASADQQA2AhwgAyABNgIUIANBnA02AhAgA0EhNgIMQQAhAgygAgtBvgEhAgyFAgsgA0HXATYCHCADIAE2AhQgA0HWGTYCECADQRU2AgxBACECDJ4CCyABIARGBEBB1wEhAgyeAgsCQCABLQAAQSBGBEAgA0EAOwE0IAFBAWohAQwBCyADQQA2AhwgAyABNgIUIANB6xA2AhAgA0EJNgIMQQAhAgyeAgtBvQEhAgyDAgsgASAERgRAQdYBIQIMnQILAkAgAS0AAEEwa0H/AXEiAkEKSQRAIAFBAWohAQJAIAMvATQiAEGZM0sNACADIABBCmwiADsBNCAAQf7/A3EgAkH//wNzSw0AIAMgACACajsBNAwCC0EAIQIgA0EANgIcIAMgATYCFCADQYAdNgIQIANBDTYCDAyeAgsgA0EANgIcIAMgATYCFCADQYAdNgIQIANBDTYCDEEAIQIMnQILQbwBIQIMggILIAEgBEYEQEHVASECDJwCCwJAIAEtAABBMGtB/wFxIgJBCkkEQCABQQFqIQECQCADLwE0IgBBmTNLDQAgAyAAQQpsIgA7ATQgAEH+/wNxIAJB//8Dc0sNACADIAAgAmo7ATQMAgtBACECIANBADYCHCADIAE2AhQgA0GAHTYCECADQQ02AgwMnQILIANBADYCHCADIAE2AhQgA0GAHTYCECADQQ02AgxBACECDJwCC0G7ASECDIECCyABIARGBEBB1AEhAgybAgsCQCABLQAAQTBrQf8BcSICQQpJBEAgAUEBaiEBAkAgAy8BNCIAQZkzSw0AIAMgAEEKbCIAOwE0IABB/v8DcSACQf//A3NLDQAgAyAAIAJqOwE0DAILQQAhAiADQQA2AhwgAyABNgIUIANBgB02AhAgA0ENNgIMDJwCCyADQQA2AhwgAyABNgIUIANBgB02AhAgA0ENNgIMQQAhAgybAgtBugEhAgyAAgsgASAERgRAQdMBIQIMmgILAkACQAJAAkAgAS0AAEEKaw4XAgMDAAMDAwMDAwMDAwMDAwMDAwMDAwEDCyABQQFqDAULIAFBAWohAUG5ASECDIECCyABQQFqIQEgA0Evai0AAEEBcQ0IIANBADYCHCADIAE2AhQgA0GFCzYCECADQQ02AgxBACECDJoCCyADQQA2AhwgAyABNgIUIANBhQs2AhAgA0ENNgIMQQAhAgyZAgsgASAERwRAIANBDjYCCCADIAE2AgRBASECDP8BC0HSASECDJgCCwJAAkADQAJAIAEtAABBCmsOBAIAAAMACyAEIAFBAWoiAUcNAAtB0QEhAgyZAgsgAygCBCEAIANBADYCBCADIAAgARAsIgBFBEAgAUEBaiEBDAQLIANB0AE2AhwgAyAANgIMIAMgAUEBajYCFEEAIQIMmAILIAMoAgQhACADQQA2AgQgAyAAIAEQLCIADQEgAUEBagshAUG3ASECDPwBCyADQc8BNgIcIAMgADYCDCADIAFBAWo2AhRBACECDJUCC0G4ASECDPoBCyADQS9qLQAAQQFxDQEgA0EANgIcIAMgATYCFCADQc8bNgIQIANBGTYCDEEAIQIMkwILIAEgBEYEQEHPASECDJMCCwJAAkACQCABLQAAQQprDgQBAgIAAgsgAUEBaiEBDAILIAFBAWohAQwBCyADLQAuQcAAcUUNAQtBACEAAkAgAygCOCICRQ0AIAIoAjQiAkUNACADIAIRAAAhAAsgAEUNlgEgAEEVRgRAIANB2QA2AhwgAyABNgIUIANBvRk2AhAgA0EVNgIMQQAhAgySAgsgA0EANgIcIAMgATYCFCADQfgMNgIQIANBGzYCDEEAIQIMkQILIANBADYCHCADIAE2AhQgA0HHJzYCECADQQI2AgxBACECDJACCyABIARHBEAgA0EMNgIIIAMgATYCBEG1ASECDPYBC0HOASECDI8CCyABIARGBEBBzQEhAgyPAgsCQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAIAEtAABBwQBrDhUAAQIDWgQFBlpaWgcICQoLDA0ODxBaCyABQQFqIQFB8QAhAgyEAgsgAUEBaiEBQfIAIQIMgwILIAFBAWohAUH3ACECDIICCyABQQFqIQFB+wAhAgyBAgsgAUEBaiEBQfwAIQIMgAILIAFBAWohAUH/ACECDP8BCyABQQFqIQFBgAEhAgz+AQsgAUEBaiEBQYMBIQIM/QELIAFBAWohAUGMASECDPwBCyABQQFqIQFBjQEhAgz7AQsgAUEBaiEBQY4BIQIM+gELIAFBAWohAUGbASECDPkBCyABQQFqIQFBnAEhAgz4AQsgAUEBaiEBQaIBIQIM9wELIAFBAWohAUGqASECDPYBCyABQQFqIQFBrQEhAgz1AQsgAUEBaiEBQbQBIQIM9AELIAEgBEYEQEHMASECDI4CCyABLQAAQc4ARw1IIAFBAWohAUGzASECDPMBCyABIARGBEBBywEhAgyNAgsCQAJAAkAgAS0AAEHCAGsOEgBKSkpKSkpKSkoBSkpKSkpKAkoLIAFBAWohAUGuASECDPQBCyABQQFqIQFBsQEhAgzzAQsgAUEBaiEBQbIBIQIM8gELQcoBIQIgASAERg2LAiADKAIAIgAgBCABa2ohBSABIABrQQdqIQYCQANAIAEtAAAgAEHo0wBqLQAARw1FIABBB0YNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAyMAgsgA0EANgIAIAZBAWohAUEbDEULIAEgBEYEQEHJASECDIsCCwJAAkAgAS0AAEHJAGsOBwBHR0dHRwFHCyABQQFqIQFBrwEhAgzxAQsgAUEBaiEBQbABIQIM8AELQcgBIQIgASAERg2JAiADKAIAIgAgBCABa2ohBSABIABrQQFqIQYCQANAIAEtAAAgAEHm0wBqLQAARw1DIABBAUYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAyKAgsgA0EANgIAIAZBAWohAUEPDEMLQccBIQIgASAERg2IAiADKAIAIgAgBCABa2ohBSABIABrQQFqIQYCQANAIAEtAAAgAEHk0wBqLQAARw1CIABBAUYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAyJAgsgA0EANgIAIAZBAWohAUEgDEILQcYBIQIgASAERg2HAiADKAIAIgAgBCABa2ohBSABIABrQQJqIQYCQANAIAEtAAAgAEHh0wBqLQAARw1BIABBAkYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAyIAgsgA0EANgIAIAZBAWohAUESDEELIAEgBEYEQEHFASECDIcCCwJAAkAgAS0AAEHFAGsODgBDQ0NDQ0NDQ0NDQ0MBQwsgAUEBaiEBQasBIQIM7QELIAFBAWohAUGsASECDOwBC0HEASECIAEgBEYNhQIgAygCACIAIAQgAWtqIQUgASAAa0ECaiEGAkADQCABLQAAIABB3tMAai0AAEcNPyAAQQJGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAMhgILIANBADYCACAGQQFqIQFBBww/C0HDASECIAEgBEYNhAIgAygCACIAIAQgAWtqIQUgASAAa0EFaiEGAkADQCABLQAAIABB2NMAai0AAEcNPiAAQQVGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAMhQILIANBADYCACAGQQFqIQFBKAw+CyABIARGBEBBwgEhAgyEAgsCQAJAAkAgAS0AAEHFAGsOEQBBQUFBQUFBQUEBQUFBQUECQQsgAUEBaiEBQacBIQIM6wELIAFBAWohAUGoASECDOoBCyABQQFqIQFBqQEhAgzpAQtBwQEhAiABIARGDYICIAMoAgAiACAEIAFraiEFIAEgAGtBBmohBgJAA0AgAS0AACAAQdHTAGotAABHDTwgAEEGRg0BIABBAWohACAEIAFBAWoiAUcNAAsgAyAFNgIADIMCCyADQQA2AgAgBkEBaiEBQRoMPAtBwAEhAiABIARGDYECIAMoAgAiACAEIAFraiEFIAEgAGtBA2ohBgJAA0AgAS0AACAAQc3TAGotAABHDTsgAEEDRg0BIABBAWohACAEIAFBAWoiAUcNAAsgAyAFNgIADIICCyADQQA2AgAgBkEBaiEBQSEMOwsgASAERgRAQb8BIQIMgQILAkACQCABLQAAQcEAaw4UAD09PT09PT09PT09PT09PT09PQE9CyABQQFqIQFBowEhAgznAQsgAUEBaiEBQaYBIQIM5gELIAEgBEYEQEG+ASECDIACCwJAAkAgAS0AAEHVAGsOCwA8PDw8PDw8PDwBPAsgAUEBaiEBQaQBIQIM5gELIAFBAWohAUGlASECDOUBC0G9ASECIAEgBEYN/gEgAygCACIAIAQgAWtqIQUgASAAa0EIaiEGAkADQCABLQAAIABBxNMAai0AAEcNOCAAQQhGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM/wELIANBADYCACAGQQFqIQFBKgw4CyABIARGBEBBvAEhAgz+AQsgAS0AAEHQAEcNOCABQQFqIQFBJQw3C0G7ASECIAEgBEYN/AEgAygCACIAIAQgAWtqIQUgASAAa0ECaiEGAkADQCABLQAAIABBwdMAai0AAEcNNiAAQQJGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM/QELIANBADYCACAGQQFqIQFBDgw2CyABIARGBEBBugEhAgz8AQsgAS0AAEHFAEcNNiABQQFqIQFBoQEhAgzhAQsgASAERgRAQbkBIQIM+wELAkACQAJAAkAgAS0AAEHCAGsODwABAjk5OTk5OTk5OTk5AzkLIAFBAWohAUGdASECDOMBCyABQQFqIQFBngEhAgziAQsgAUEBaiEBQZ8BIQIM4QELIAFBAWohAUGgASECDOABC0G4ASECIAEgBEYN+QEgAygCACIAIAQgAWtqIQUgASAAa0ECaiEGAkADQCABLQAAIABBvtMAai0AAEcNMyAAQQJGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM+gELIANBADYCACAGQQFqIQFBFAwzC0G3ASECIAEgBEYN+AEgAygCACIAIAQgAWtqIQUgASAAa0EEaiEGAkADQCABLQAAIABBudMAai0AAEcNMiAAQQRGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM+QELIANBADYCACAGQQFqIQFBKwwyC0G2ASECIAEgBEYN9wEgAygCACIAIAQgAWtqIQUgASAAa0ECaiEGAkADQCABLQAAIABBttMAai0AAEcNMSAAQQJGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM+AELIANBADYCACAGQQFqIQFBLAwxC0G1ASECIAEgBEYN9gEgAygCACIAIAQgAWtqIQUgASAAa0ECaiEGAkADQCABLQAAIABB4dMAai0AAEcNMCAAQQJGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM9wELIANBADYCACAGQQFqIQFBEQwwC0G0ASECIAEgBEYN9QEgAygCACIAIAQgAWtqIQUgASAAa0EDaiEGAkADQCABLQAAIABBstMAai0AAEcNLyAAQQNGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM9gELIANBADYCACAGQQFqIQFBLgwvCyABIARGBEBBswEhAgz1AQsCQAJAAkACQAJAIAEtAABBwQBrDhUANDQ0NDQ0NDQ0NAE0NAI0NAM0NAQ0CyABQQFqIQFBkQEhAgzeAQsgAUEBaiEBQZIBIQIM3QELIAFBAWohAUGTASECDNwBCyABQQFqIQFBmAEhAgzbAQsgAUEBaiEBQZoBIQIM2gELIAEgBEYEQEGyASECDPQBCwJAAkAgAS0AAEHSAGsOAwAwATALIAFBAWohAUGZASECDNoBCyABQQFqIQFBBAwtC0GxASECIAEgBEYN8gEgAygCACIAIAQgAWtqIQUgASAAa0EBaiEGAkADQCABLQAAIABBsNMAai0AAEcNLCAAQQFGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM8wELIANBADYCACAGQQFqIQFBHQwsCyABIARGBEBBsAEhAgzyAQsCQAJAIAEtAABByQBrDgcBLi4uLi4ALgsgAUEBaiEBQZcBIQIM2AELIAFBAWohAUEiDCsLIAEgBEYEQEGvASECDPEBCyABLQAAQdAARw0rIAFBAWohAUGWASECDNYBCyABIARGBEBBrgEhAgzwAQsCQAJAIAEtAABBxgBrDgsALCwsLCwsLCwsASwLIAFBAWohAUGUASECDNYBCyABQQFqIQFBlQEhAgzVAQtBrQEhAiABIARGDe4BIAMoAgAiACAEIAFraiEFIAEgAGtBA2ohBgJAA0AgAS0AACAAQazTAGotAABHDSggAEEDRg0BIABBAWohACAEIAFBAWoiAUcNAAsgAyAFNgIADO8BCyADQQA2AgAgBkEBaiEBQQ0MKAtBrAEhAiABIARGDe0BIAMoAgAiACAEIAFraiEFIAEgAGtBAmohBgJAA0AgAS0AACAAQeHTAGotAABHDScgAEECRg0BIABBAWohACAEIAFBAWoiAUcNAAsgAyAFNgIADO4BCyADQQA2AgAgBkEBaiEBQQwMJwtBqwEhAiABIARGDewBIAMoAgAiACAEIAFraiEFIAEgAGtBAWohBgJAA0AgAS0AACAAQarTAGotAABHDSYgAEEBRg0BIABBAWohACAEIAFBAWoiAUcNAAsgAyAFNgIADO0BCyADQQA2AgAgBkEBaiEBQQMMJgtBqgEhAiABIARGDesBIAMoAgAiACAEIAFraiEFIAEgAGtBAWohBgJAA0AgAS0AACAAQajTAGotAABHDSUgAEEBRg0BIABBAWohACAEIAFBAWoiAUcNAAsgAyAFNgIADOwBCyADQQA2AgAgBkEBaiEBQSYMJQsgASAERgRAQakBIQIM6wELAkACQCABLQAAQdQAaw4CAAEnCyABQQFqIQFBjwEhAgzRAQsgAUEBaiEBQZABIQIM0AELQagBIQIgASAERg3pASADKAIAIgAgBCABa2ohBSABIABrQQFqIQYCQANAIAEtAAAgAEGm0wBqLQAARw0jIABBAUYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAzqAQsgA0EANgIAIAZBAWohAUEnDCMLQacBIQIgASAERg3oASADKAIAIgAgBCABa2ohBSABIABrQQFqIQYCQANAIAEtAAAgAEGk0wBqLQAARw0iIABBAUYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAzpAQsgA0EANgIAIAZBAWohAUEcDCILQaYBIQIgASAERg3nASADKAIAIgAgBCABa2ohBSABIABrQQVqIQYCQANAIAEtAAAgAEGe0wBqLQAARw0hIABBBUYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAzoAQsgA0EANgIAIAZBAWohAUEGDCELQaUBIQIgASAERg3mASADKAIAIgAgBCABa2ohBSABIABrQQRqIQYCQANAIAEtAAAgAEGZ0wBqLQAARw0gIABBBEYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAznAQsgA0EANgIAIAZBAWohAUEZDCALIAEgBEYEQEGkASECDOYBCwJAAkACQAJAIAEtAABBLWsOIwAkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJAEkJCQkJAIkJCQDJAsgAUEBaiEBQYQBIQIMzgELIAFBAWohAUGFASECDM0BCyABQQFqIQFBigEhAgzMAQsgAUEBaiEBQYsBIQIMywELQaMBIQIgASAERg3kASADKAIAIgAgBCABa2ohBSABIABrQQFqIQYCQANAIAEtAAAgAEGX0wBqLQAARw0eIABBAUYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAzlAQsgA0EANgIAIAZBAWohAUELDB4LIAEgBEYEQEGiASECDOQBCwJAAkAgAS0AAEHBAGsOAwAgASALIAFBAWohAUGGASECDMoBCyABQQFqIQFBiQEhAgzJAQsgASAERgRAQaEBIQIM4wELAkACQCABLQAAQcEAaw4PAB8fHx8fHx8fHx8fHx8BHwsgAUEBaiEBQYcBIQIMyQELIAFBAWohAUGIASECDMgBCyABIARGBEBBoAEhAgziAQsgAS0AAEHMAEcNHCABQQFqIQFBCgwbC0GfASECIAEgBEYN4AEgAygCACIAIAQgAWtqIQUgASAAa0EFaiEGAkADQCABLQAAIABBkdMAai0AAEcNGiAAQQVGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM4QELIANBADYCACAGQQFqIQFBHgwaC0GeASECIAEgBEYN3wEgAygCACIAIAQgAWtqIQUgASAAa0EGaiEGAkADQCABLQAAIABBitMAai0AAEcNGSAAQQZGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM4AELIANBADYCACAGQQFqIQFBFQwZC0GdASECIAEgBEYN3gEgAygCACIAIAQgAWtqIQUgASAAa0ECaiEGAkADQCABLQAAIABBh9MAai0AAEcNGCAAQQJGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM3wELIANBADYCACAGQQFqIQFBFwwYC0GcASECIAEgBEYN3QEgAygCACIAIAQgAWtqIQUgASAAa0EFaiEGAkADQCABLQAAIABBgdMAai0AAEcNFyAAQQVGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM3gELIANBADYCACAGQQFqIQFBGAwXCyABIARGBEBBmwEhAgzdAQsCQAJAIAEtAABByQBrDgcAGRkZGRkBGQsgAUEBaiEBQYEBIQIMwwELIAFBAWohAUGCASECDMIBC0GaASECIAEgBEYN2wEgAygCACIAIAQgAWtqIQUgASAAa0EBaiEGAkADQCABLQAAIABB5tMAai0AAEcNFSAAQQFGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM3AELIANBADYCACAGQQFqIQFBCQwVC0GZASECIAEgBEYN2gEgAygCACIAIAQgAWtqIQUgASAAa0EBaiEGAkADQCABLQAAIABB5NMAai0AAEcNFCAAQQFGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM2wELIANBADYCACAGQQFqIQFBHwwUC0GYASECIAEgBEYN2QEgAygCACIAIAQgAWtqIQUgASAAa0ECaiEGAkADQCABLQAAIABB/tIAai0AAEcNEyAAQQJGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM2gELIANBADYCACAGQQFqIQFBAgwTC0GXASECIAEgBEYN2AEgAygCACIAIAQgAWtqIQUgASAAa0EBaiEGA0AgAS0AACAAQfzSAGotAABHDREgAEEBRg0CIABBAWohACAEIAFBAWoiAUcNAAsgAyAFNgIADNgBCyABIARGBEBBlgEhAgzYAQtBASABLQAAQd8ARw0RGiABQQFqIQFB/QAhAgy9AQsgA0EANgIAIAZBAWohAUH+ACECDLwBC0GVASECIAEgBEYN1QEgAygCACIAIAQgAWtqIQUgASAAa0EIaiEGAkADQCABLQAAIABBxNMAai0AAEcNDyAAQQhGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM1gELIANBADYCACAGQQFqIQFBKQwPC0GUASECIAEgBEYN1AEgAygCACIAIAQgAWtqIQUgASAAa0EDaiEGAkADQCABLQAAIABB+NIAai0AAEcNDiAAQQNGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAM1QELIANBADYCACAGQQFqIQFBLQwOCyABIARGBEBBkwEhAgzUAQsgAS0AAEHFAEcNDiABQQFqIQFB+gAhAgy5AQsgASAERgRAQZIBIQIM0wELAkACQCABLQAAQcwAaw4IAA8PDw8PDwEPCyABQQFqIQFB+AAhAgy5AQsgAUEBaiEBQfkAIQIMuAELQZEBIQIgASAERg3RASADKAIAIgAgBCABa2ohBSABIABrQQRqIQYCQANAIAEtAAAgAEHz0gBqLQAARw0LIABBBEYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAzSAQsgA0EANgIAIAZBAWohAUEjDAsLQZABIQIgASAERg3QASADKAIAIgAgBCABa2ohBSABIABrQQJqIQYCQANAIAEtAAAgAEHw0gBqLQAARw0KIABBAkYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAzRAQsgA0EANgIAIAZBAWohAUEADAoLIAEgBEYEQEGPASECDNABCwJAAkAgAS0AAEHIAGsOCAAMDAwMDAwBDAsgAUEBaiEBQfMAIQIMtgELIAFBAWohAUH2ACECDLUBCyABIARGBEBBjgEhAgzPAQsCQAJAIAEtAABBzgBrDgMACwELCyABQQFqIQFB9AAhAgy1AQsgAUEBaiEBQfUAIQIMtAELIAEgBEYEQEGNASECDM4BCyABLQAAQdkARw0IIAFBAWohAUEIDAcLQYwBIQIgASAERg3MASADKAIAIgAgBCABa2ohBSABIABrQQNqIQYCQANAIAEtAAAgAEHs0gBqLQAARw0GIABBA0YNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAzNAQsgA0EANgIAIAZBAWohAUEFDAYLQYsBIQIgASAERg3LASADKAIAIgAgBCABa2ohBSABIABrQQVqIQYCQANAIAEtAAAgAEHm0gBqLQAARw0FIABBBUYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAzMAQsgA0EANgIAIAZBAWohAUEWDAULQYoBIQIgASAERg3KASADKAIAIgAgBCABa2ohBSABIABrQQJqIQYCQANAIAEtAAAgAEHh0wBqLQAARw0EIABBAkYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAzLAQsgA0EANgIAIAZBAWohAUEQDAQLIAEgBEYEQEGJASECDMoBCwJAAkAgAS0AAEHDAGsODAAGBgYGBgYGBgYGAQYLIAFBAWohAUHvACECDLABCyABQQFqIQFB8AAhAgyvAQtBiAEhAiABIARGDcgBIAMoAgAiACAEIAFraiEFIAEgAGtBBWohBgJAA0AgAS0AACAAQeDSAGotAABHDQIgAEEFRg0BIABBAWohACAEIAFBAWoiAUcNAAsgAyAFNgIADMkBCyADQQA2AgAgBkEBaiEBQSQMAgsgA0EANgIADAILIAEgBEYEQEGHASECDMcBCyABLQAAQcwARw0BIAFBAWohAUETCzoAKSADKAIEIQAgA0EANgIEIAMgACABEC0iAA0CDAELQQAhAiADQQA2AhwgAyABNgIUIANB6R42AhAgA0EGNgIMDMQBC0HuACECDKkBCyADQYYBNgIcIAMgATYCFCADIAA2AgxBACECDMIBC0EAIQACQCADKAI4IgJFDQAgAigCOCICRQ0AIAMgAhEAACEACyAARQ0AIABBFUYNASADQQA2AhwgAyABNgIUIANB1A42AhAgA0EgNgIMQQAhAgzBAQtB7QAhAgymAQsgA0GFATYCHCADIAE2AhQgA0HXGjYCECADQRU2AgxBACECDL8BCyABIARGBEBBhQEhAgy/AQsCQCABLQAAQSBGBEAgAUEBaiEBDAELIANBADYCHCADIAE2AhQgA0GGHjYCECADQQY2AgxBACECDL8BC0ECIQIMpAELA0AgAS0AAEEgRw0CIAQgAUEBaiIBRw0AC0GEASECDL0BCyABIARGBEBBgwEhAgy9AQsCQCABLQAAQQlrDgRAAABAAAtB6wAhAgyiAQsgAy0AKUEFRgRAQewAIQIMogELQeoAIQIMoQELIAEgBEYEQEGCASECDLsBCyADQQ82AgggAyABNgIEDAoLIAEgBEYEQEGBASECDLoBCwJAIAEtAABBCWsOBD0AAD0AC0HpACECDJ8BCyABIARHBEAgA0EPNgIIIAMgATYCBEHnACECDJ8BC0GAASECDLgBCwJAIAEgBEcEQANAIAEtAABB4M4Aai0AACIAQQNHBEACQCAAQQFrDgI/AAQLQeYAIQIMoQELIAQgAUEBaiIBRw0AC0H+ACECDLkBC0H+ACECDLgBCyADQQA2AhwgAyABNgIUIANBxh82AhAgA0EHNgIMQQAhAgy3AQsgASAERgRAQf8AIQIMtwELAkACQAJAIAEtAABB4NAAai0AAEEBaw4DPAIAAQtB6AAhAgyeAQsgA0EANgIcIAMgATYCFCADQYYSNgIQIANBBzYCDEEAIQIMtwELQeAAIQIMnAELIAEgBEcEQCABQQFqIQFB5QAhAgycAQtB/QAhAgy1AQsgBCABIgBGBEBB/AAhAgy1AQsgAC0AACIBQS9GBEAgAEEBaiEBQeQAIQIMmwELIAFBCWsiAkEXSw0BIAAhAUEBIAJ0QZuAgARxDTcMAQsgBCABIgBGBEBB+wAhAgy0AQsgAC0AAEEvRw0AIABBAWohAQwDC0EAIQIgA0EANgIcIAMgADYCFCADQcYfNgIQIANBBzYCDAyyAQsCQAJAAkACQAJAA0AgAS0AAEHgzABqLQAAIgBBBUcEQAJAAkAgAEEBaw4IPQUGBwgABAEIC0HhACECDJ8BCyABQQFqIQFB4wAhAgyeAQsgBCABQQFqIgFHDQALQfoAIQIMtgELIAFBAWoMFAsgAygCBCEAIANBADYCBCADIAAgARArIgBFDR4gA0HbADYCHCADIAE2AhQgAyAANgIMQQAhAgy0AQsgAygCBCEAIANBADYCBCADIAAgARArIgBFDR4gA0HdADYCHCADIAE2AhQgAyAANgIMQQAhAgyzAQsgAygCBCEAIANBADYCBCADIAAgARArIgBFDR4gA0HwADYCHCADIAE2AhQgAyAANgIMQQAhAgyyAQsgA0EANgIcIAMgATYCFCADQcsPNgIQIANBBzYCDEEAIQIMsQELIAEgBEYEQEH5ACECDLEBCwJAIAEtAABB4MwAai0AAEEBaw4INAQFBgAIAgMHCyABQQFqIQELQQMhAgyVAQsgAUEBagwNC0EAIQIgA0EANgIcIANBoxI2AhAgA0EHNgIMIAMgAUEBajYCFAytAQsgAygCBCEAIANBADYCBCADIAAgARArIgBFDRYgA0HbADYCHCADIAE2AhQgAyAANgIMQQAhAgysAQsgAygCBCEAIANBADYCBCADIAAgARArIgBFDRYgA0HdADYCHCADIAE2AhQgAyAANgIMQQAhAgyrAQsgAygCBCEAIANBADYCBCADIAAgARArIgBFDRYgA0HwADYCHCADIAE2AhQgAyAANgIMQQAhAgyqAQsgA0EANgIcIAMgATYCFCADQcsPNgIQIANBBzYCDEEAIQIMqQELQeIAIQIMjgELIAEgBEYEQEH4ACECDKgBCyABQQFqDAILIAEgBEYEQEH3ACECDKcBCyABQQFqDAELIAEgBEYNASABQQFqCyEBQQQhAgyKAQtB9gAhAgyjAQsDQCABLQAAQeDKAGotAAAiAEECRwRAIABBAUcEQEHfACECDIsBCwwnCyAEIAFBAWoiAUcNAAtB9QAhAgyiAQsgASAERgRAQfQAIQIMogELAkAgAS0AAEEJaw43JQMGJQQGBgYGBgYGBgYGBgYGBgYGBgYFBgYCBgYGBgYGBgYGBgYGBgYGBgYGBgYGBgYGBgYGAAYLIAFBAWoLIQFBBSECDIYBCyABQQFqDAYLIAMoAgQhACADQQA2AgQgAyAAIAEQKyIARQ0IIANB2wA2AhwgAyABNgIUIAMgADYCDEEAIQIMngELIAMoAgQhACADQQA2AgQgAyAAIAEQKyIARQ0IIANB3QA2AhwgAyABNgIUIAMgADYCDEEAIQIMnQELIAMoAgQhACADQQA2AgQgAyAAIAEQKyIARQ0IIANB8AA2AhwgAyABNgIUIAMgADYCDEEAIQIMnAELIANBADYCHCADIAE2AhQgA0G8EzYCECADQQc2AgxBACECDJsBCwJAAkACQAJAA0AgAS0AAEHgyABqLQAAIgBBBUcEQAJAIABBAWsOBiQDBAUGAAYLQd4AIQIMhgELIAQgAUEBaiIBRw0AC0HzACECDJ4BCyADKAIEIQAgA0EANgIEIAMgACABECsiAEUNByADQdsANgIcIAMgATYCFCADIAA2AgxBACECDJ0BCyADKAIEIQAgA0EANgIEIAMgACABECsiAEUNByADQd0ANgIcIAMgATYCFCADIAA2AgxBACECDJwBCyADKAIEIQAgA0EANgIEIAMgACABECsiAEUNByADQfAANgIcIAMgATYCFCADIAA2AgxBACECDJsBCyADQQA2AhwgAyABNgIUIANB3Ag2AhAgA0EHNgIMQQAhAgyaAQsgASAERg0BIAFBAWoLIQFBBiECDH4LQfIAIQIMlwELAkACQAJAAkADQCABLQAAQeDGAGotAAAiAEEFRwRAIABBAWsOBB8CAwQFCyAEIAFBAWoiAUcNAAtB8QAhAgyaAQsgAygCBCEAIANBADYCBCADIAAgARArIgBFDQMgA0HbADYCHCADIAE2AhQgAyAANgIMQQAhAgyZAQsgAygCBCEAIANBADYCBCADIAAgARArIgBFDQMgA0HdADYCHCADIAE2AhQgAyAANgIMQQAhAgyYAQsgAygCBCEAIANBADYCBCADIAAgARArIgBFDQMgA0HwADYCHCADIAE2AhQgAyAANgIMQQAhAgyXAQsgA0EANgIcIAMgATYCFCADQbQKNgIQIANBBzYCDEEAIQIMlgELQc4AIQIMewtB0AAhAgx6C0HdACECDHkLIAEgBEYEQEHwACECDJMBCwJAIAEtAABBCWsOBBYAABYACyABQQFqIQFB3AAhAgx4CyABIARGBEBB7wAhAgySAQsCQCABLQAAQQlrDgQVAAAVAAtBACEAAkAgAygCOCICRQ0AIAIoAjAiAkUNACADIAIRAAAhAAsgAEUEQEHTASECDHgLIABBFUcEQCADQQA2AhwgAyABNgIUIANBwQ02AhAgA0EaNgIMQQAhAgySAQsgA0HuADYCHCADIAE2AhQgA0HwGTYCECADQRU2AgxBACECDJEBC0HtACECIAEgBEYNkAEgAygCACIAIAQgAWtqIQUgASAAa0EDaiEGAkADQCABLQAAIABB18YAai0AAEcNBCAAQQNGDQEgAEEBaiEAIAQgAUEBaiIBRw0ACyADIAU2AgAMkQELIANBADYCACAGQQFqIQEgAy0AKSIAQSNrQQtJDQQCQCAAQQZLDQBBASAAdEHKAHFFDQAMBQtBACECIANBADYCHCADIAE2AhQgA0HlCTYCECADQQg2AgwMkAELQewAIQIgASAERg2PASADKAIAIgAgBCABa2ohBSABIABrQQJqIQYCQANAIAEtAAAgAEHUxgBqLQAARw0DIABBAkYNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAyQAQsgA0EANgIAIAZBAWohASADLQApQSFGDQMgA0EANgIcIAMgATYCFCADQYkKNgIQIANBCDYCDEEAIQIMjwELQesAIQIgASAERg2OASADKAIAIgAgBCABa2ohBSABIABrQQNqIQYCQANAIAEtAAAgAEHQxgBqLQAARw0CIABBA0YNASAAQQFqIQAgBCABQQFqIgFHDQALIAMgBTYCAAyPAQsgA0EANgIAIAZBAWohASADLQApIgBBI0kNAiAAQS5GDQIgA0EANgIcIAMgATYCFCADQcEJNgIQIANBCDYCDEEAIQIMjgELIANBADYCAAtBACECIANBADYCHCADIAE2AhQgA0GENzYCECADQQg2AgwMjAELQdgAIQIMcQsgASAERwRAIANBDTYCCCADIAE2AgRB1wAhAgxxC0HqACECDIoBCyABIARGBEBB6QAhAgyKAQsgAS0AAEEwayIAQf8BcUEKSQRAIAMgADoAKiABQQFqIQFB1gAhAgxwCyADKAIEIQAgA0EANgIEIAMgACABEC4iAEUNdCADQegANgIcIAMgATYCFCADIAA2AgxBACECDIkBCyABIARGBEBB5wAhAgyJAQsCQCABLQAAQS5GBEAgAUEBaiEBDAELIAMoAgQhACADQQA2AgQgAyAAIAEQLiIARQ11IANB5gA2AhwgAyABNgIUIAMgADYCDEEAIQIMiQELQdUAIQIMbgsgASAERgRAQeUAIQIMiAELQQAhAEEBIQVBASEHQQAhAgJAAkACQAJAAkACfwJAAkACQAJAAkACQAJAIAEtAABBMGsOCgoJAAECAwQFBggLC0ECDAYLQQMMBQtBBAwEC0EFDAMLQQYMAgtBBwwBC0EICyECQQAhBUEAIQcMAgtBCSECQQEhAEEAIQVBACEHDAELQQAhBUEBIQILIAMgAjoAKyABQQFqIQECQAJAIAMtAC5BEHENAAJAAkACQCADLQAqDgMBAAIECyAHRQ0DDAILIAANAQwCCyAFRQ0BCyADKAIEIQAgA0EANgIEIAMgACABEC4iAEUNAiADQeIANgIcIAMgATYCFCADIAA2AgxBACECDIoBCyADKAIEIQAgA0EANgIEIAMgACABEC4iAEUNdyADQeMANgIcIAMgATYCFCADIAA2AgxBACECDIkBCyADKAIEIQAgA0EANgIEIAMgACABEC4iAEUNdSADQeQANgIcIAMgATYCFCADIAA2AgwMiAELQdMAIQIMbQsgAy0AKUEiRg2AAUHSACECDGwLQQAhAAJAIAMoAjgiAkUNACACKAI8IgJFDQAgAyACEQAAIQALIABFBEBB1AAhAgxsCyAAQRVHBEAgA0EANgIcIAMgATYCFCADQZwNNgIQIANBITYCDEEAIQIMhgELIANB4QA2AhwgAyABNgIUIANB1hk2AhAgA0EVNgIMQQAhAgyFAQsgASAERgRAQeAAIQIMhQELAkACQAJAAkACQCABLQAAQQprDgQBBAQABAsgAUEBaiEBDAELIAFBAWohASADQS9qLQAAQQFxRQ0BC0HRACECDGwLIANBADYCHCADIAE2AhQgA0GIETYCECADQQk2AgxBACECDIUBCyADQQA2AhwgAyABNgIUIANBiBE2AhAgA0EJNgIMQQAhAgyEAQsgASAERgRAQd8AIQIMhAELIAEtAABBCkYEQCABQQFqIQEMCQsgAy0ALkHAAHENCCADQQA2AhwgAyABNgIUIANBiBE2AhAgA0ECNgIMQQAhAgyDAQsgASAERgRAQd0AIQIMgwELIAEtAAAiAkENRgRAIAFBAWohAUHPACECDGkLIAEhACACQQlrDgQFAQEFAQsgBCABIgBGBEBB3AAhAgyCAQsgAC0AAEEKRw0AIABBAWoMAgtBACECIANBADYCHCADIAA2AhQgA0G1LDYCECADQQc2AgwMgAELIAEgBEYEQEHbACECDIABCwJAIAEtAABBCWsOBAMAAAMACyABQQFqCyEBQc0AIQIMZAsgASAERgRAQdoAIQIMfgsgAS0AAEEJaw4EAAEBAAELQQAhAiADQQA2AhwgA0HsETYCECADQQc2AgwgAyABQQFqNgIUDHwLIANBgBI7ASpBACEAAkAgAygCOCICRQ0AIAIoAjAiAkUNACADIAIRAAAhAAsgAEUNACAAQRVHDQEgA0HZADYCHCADIAE2AhQgA0HwGTYCECADQRU2AgxBACECDHsLQcwAIQIMYAsgA0EANgIcIAMgATYCFCADQcENNgIQIANBGjYCDEEAIQIMeQsgASAERgRAQdkAIQIMeQsgAS0AAEEgRw06IAFBAWohASADLQAuQQFxDTogA0EANgIcIAMgATYCFCADQa0bNgIQIANBHjYCDEEAIQIMeAsgASAERgRAQdgAIQIMeAsCQAJAAkACQAJAIAEtAAAiAEEKaw4EAgMDAAELIAFBAWohAUErIQIMYQsgAEE6Rw0BIANBADYCHCADIAE2AhQgA0G5ETYCECADQQo2AgxBACECDHoLIAFBAWohASADQS9qLQAAQQFxRQ1tIAMtADJBgAFxRQRAIANBMmohAiADEDRBACEAAkAgAygCOCIGRQ0AIAYoAiQiBkUNACADIAYRAAAhAAsCQAJAIAAOFkpJSAEBAQEBAQEBAQEBAQEBAQEBAQABCyADQSk2AhwgAyABNgIUIANBshg2AhAgA0EVNgIMQQAhAgx7CyADQQA2AhwgAyABNgIUIANB3Qs2AhAgA0ERNgIMQQAhAgx6C0EAIQACQCADKAI4IgJFDQAgAigCVCICRQ0AIAMgAhEAACEACyAARQ1VIABBFUcNASADQQU2AhwgAyABNgIUIANBhho2AhAgA0EVNgIMQQAhAgx5C0HKACECDF4LQQAhAiADQQA2AhwgAyABNgIUIANB4g02AhAgA0EUNgIMDHcLIAMgAy8BMkGAAXI7ATIMOAsgASAERwRAIANBEDYCCCADIAE2AgRByQAhAgxcC0HXACECDHULIAEgBEYEQEHWACECDHULAkACQAJAAkAgAS0AACIAQSByIAAgAEHBAGtB/wFxQRpJG0H/AXFB4wBrDhMAPT09PT09PT09PT09AT09PQIDPQsgAUEBaiEBQcUAIQIMXQsgAUEBaiEBQcYAIQIMXAsgAUEBaiEBQccAIQIMWwsgAUEBaiEBQcgAIQIMWgtB1QAhAiAEIAEiAEYNcyAEIAFrIAMoAgAiAWohBiAAIAFrQQVqIQcDQCABQcDGAGotAAAgAC0AACIFQSByIAUgBUHBAGtB/wFxQRpJG0H/AXFHDQhBBCABQQVGDQoaIAFBAWohASAEIABBAWoiAEcNAAsgAyAGNgIADHMLQdQAIQIgBCABIgBGDXIgBCABayADKAIAIgFqIQYgACABa0EPaiEHA0AgAUGwxgBqLQAAIAAtAAAiBUEgciAFIAVBwQBrQf8BcUEaSRtB/wFxRw0HQQMgAUEPRg0JGiABQQFqIQEgBCAAQQFqIgBHDQALIAMgBjYCAAxyC0HTACECIAQgASIARg1xIAQgAWsgAygCACIBaiEGIAAgAWtBDmohBwNAIAFBksYAai0AACAALQAAIgVBIHIgBSAFQcEAa0H/AXFBGkkbQf8BcUcNBiABQQ5GDQcgAUEBaiEBIAQgAEEBaiIARw0ACyADIAY2AgAMcQtB0gAhAiAEIAEiAEYNcCAEIAFrIAMoAgAiAWohBSAAIAFrQQFqIQYDQCABQZDGAGotAAAgAC0AACIHQSByIAcgB0HBAGtB/wFxQRpJG0H/AXFHDQUgAUEBRg0CIAFBAWohASAEIABBAWoiAEcNAAsgAyAFNgIADHALIAEgBEYEQEHRACECDHALAkACQCABLQAAIgBBIHIgACAAQcEAa0H/AXFBGkkbQf8BcUHuAGsOBwA2NjY2NgE2CyABQQFqIQFBwgAhAgxWCyABQQFqIQFBwwAhAgxVCyADQQA2AgAgBkEBaiEBQcQAIQIMVAtB0AAhAiAEIAEiAEYNbSAEIAFrIAMoAgAiAWohBiAAIAFrQQlqIQcDQCABQYbGAGotAAAgAC0AACIFQSByIAUgBUHBAGtB/wFxQRpJG0H/AXFHDQJBAiABQQlGDQQaIAFBAWohASAEIABBAWoiAEcNAAsgAyAGNgIADG0LQc8AIQIgBCABIgBGDWwgBCABayADKAIAIgFqIQYgACABa0EFaiEHA0AgAUGAxgBqLQAAIAAtAAAiBUEgciAFIAVBwQBrQf8BcUEaSRtB/wFxRw0BIAFBBUYNAiABQQFqIQEgBCAAQQFqIgBHDQALIAMgBjYCAAxsCyAAIQEgA0EANgIADDALQQELOgAsIANBADYCACAHQQFqIQELQSwhAgxOCwJAA0AgAS0AAEGAxABqLQAAQQFHDQEgBCABQQFqIgFHDQALQc0AIQIMaAtBwQAhAgxNCyABIARGBEBBzAAhAgxnCyABLQAAQTpGBEAgAygCBCEAIANBADYCBCADIAAgARAvIgBFDTAgA0HLADYCHCADIAA2AgwgAyABQQFqNgIUQQAhAgxnCyADQQA2AhwgAyABNgIUIANBuRE2AhAgA0EKNgIMQQAhAgxmCwJAAkAgAy0ALEECaw4CAAEkCyADQTNqLQAAQQJxRQ0jIAMtAC5BAnENIyADQQA2AhwgAyABNgIUIANB1RM2AhAgA0ELNgIMQQAhAgxmCyADLQAyQSBxRQ0iIAMtAC5BAnENIiADQQA2AhwgAyABNgIUIANB7BI2AhAgA0EPNgIMQQAhAgxlC0EAIQACQCADKAI4IgJFDQAgAigCQCICRQ0AIAMgAhEAACEACyAARQRAQcAAIQIMSwsgAEEVRwRAIANBADYCHCADIAE2AhQgA0H4DjYCECADQRw2AgxBACECDGULIANBygA2AhwgAyABNgIUIANB8Bo2AhAgA0EVNgIMQQAhAgxkCyABIARHBEADQCABLQAAQfA/ai0AAEEBRw0XIAQgAUEBaiIBRw0AC0HEACECDGQLQcQAIQIMYwsgASAERwRAA0ACQCABLQAAIgBBIHIgACAAQcEAa0H/AXFBGkkbQf8BcSIAQQlGDQAgAEEgRg0AAkACQAJAAkAgAEHjAGsOEwADAwMDAwMDAQMDAwMDAwMDAwIDCyABQQFqIQFBNSECDE4LIAFBAWohAUE2IQIMTQsgAUEBaiEBQTchAgxMCwwVCyAEIAFBAWoiAUcNAAtBPCECDGMLQTwhAgxiCyABIARGBEBByAAhAgxiCyADQRE2AgggAyABNgIEAkACQAJAAkACQCADLQAsQQFrDgQUAAECCQsgAy0AMkEgcQ0DQdEBIQIMSwsCQCADLwEyIgBBCHFFDQAgAy0AKEEBRw0AIAMtAC5BCHFFDQILIAMgAEH3+wNxQYAEcjsBMgwLCyADIAMvATJBEHI7ATIMBAsgA0EANgIEIAMgASABEDAiAARAIANBwQA2AhwgAyAANgIMIAMgAUEBajYCFEEAIQIMYwsgAUEBaiEBDFILIANBADYCHCADIAE2AhQgA0GjEzYCECADQQQ2AgxBACECDGELQccAIQIgASAERg1gIAMoAgAiACAEIAFraiEFIAEgAGtBBmohBgJAA0AgAEHwwwBqLQAAIAEtAABBIHJHDQEgAEEGRg1GIABBAWohACAEIAFBAWoiAUcNAAsgAyAFNgIADGELIANBADYCAAwFCwJAIAEgBEcEQANAIAEtAABB8MEAai0AACIAQQFHBEAgAEECRw0DIAFBAWohAQwFCyAEIAFBAWoiAUcNAAtBxQAhAgxhC0HFACECDGALCyADQQA6ACwMAQtBCyECDEMLQT4hAgxCCwJAAkADQCABLQAAIgBBIEcEQAJAIABBCmsOBAMFBQMACyAAQSxGDQMMBAsgBCABQQFqIgFHDQALQcYAIQIMXQsgA0EIOgAsDA4LIAMtAChBAUcNAiADLQAuQQhxDQIgAygCBCEAIANBADYCBCADIAAgARAwIgAEQCADQcIANgIcIAMgADYCDCADIAFBAWo2AhRBACECDFwLIAFBAWohAQxKC0E6IQIMQAsCQANAIAEtAAAiAEEgRyAAQQlHcQ0BIAQgAUEBaiIBRw0AC0HDACECDFoLC0E7IQIMPgsCQAJAIAEgBEcEQANAIAEtAAAiAEEgRwRAIABBCmsOBAMEBAMECyAEIAFBAWoiAUcNAAtBPyECDFoLQT8hAgxZCyADIAMvATJBIHI7ATIMCgsgAygCBCEAIANBADYCBCADIAAgARAwIgBFDUggA0E+NgIcIAMgATYCFCADIAA2AgxBACECDFcLAkAgASAERwRAA0AgAS0AAEHwwQBqLQAAIgBBAUcEQCAAQQJGDQMMDAsgBCABQQFqIgFHDQALQTchAgxYC0E3IQIMVwsgAUEBaiEBDAQLQTshAiAEIAEiAEYNVSAEIAFrIAMoAgAiAWohBiAAIAFrQQVqIQcCQANAIAFBwMYAai0AACAALQAAIgVBIHIgBSAFQcEAa0H/AXFBGkkbQf8BcUcNASABQQVGBEBBByEBDDsLIAFBAWohASAEIABBAWoiAEcNAAsgAyAGNgIADFYLIANBADYCACAAIQEMBQtBOiECIAQgASIARg1UIAQgAWsgAygCACIBaiEGIAAgAWtBCGohBwJAA0AgAUHkP2otAAAgAC0AACIFQSByIAUgBUHBAGtB/wFxQRpJG0H/AXFHDQEgAUEIRgRAQQUhAQw6CyABQQFqIQEgBCAAQQFqIgBHDQALIAMgBjYCAAxVCyADQQA2AgAgACEBDAQLQTkhAiAEIAEiAEYNUyAEIAFrIAMoAgAiAWohBiAAIAFrQQNqIQcCQANAIAFB4D9qLQAAIAAtAAAiBUEgciAFIAVBwQBrQf8BcUEaSRtB/wFxRw0BIAFBA0YEQEEGIQEMOQsgAUEBaiEBIAQgAEEBaiIARw0ACyADIAY2AgAMVAsgA0EANgIAIAAhAQwDCwJAA0AgAS0AACIAQSBHBEAgAEEKaw4EBwQEBwILIAQgAUEBaiIBRw0AC0E4IQIMUwsgAEEsRw0BIAFBAWohAEEBIQECQAJAAkACQAJAIAMtACxBBWsOBAMBAgQACyAAIQEMBAtBAiEBDAELQQQhAQsgA0EBOgAsIAMgAy8BMiABcjsBMiAAIQEMAQsgAyADLwEyQQhyOwEyIAAhAQtBPSECDDcLIANBADoALAtBOCECDDULIAEgBEYEQEE2IQIMTwsCQAJAAkACQAJAIAEtAABBCmsOBAACAgECCyADKAIEIQAgA0EANgIEIAMgACABEDAiAEUNAiADQTM2AhwgAyABNgIUIAMgADYCDEEAIQIMUgsgAygCBCEAIANBADYCBCADIAAgARAwIgBFBEAgAUEBaiEBDAYLIANBMjYCHCADIAA2AgwgAyABQQFqNgIUQQAhAgxRCyADLQAuQQFxBEBB0AEhAgw3CyADKAIEIQAgA0EANgIEIAMgACABEDAiAA0BDEMLQTMhAgw1CyADQTU2AhwgAyABNgIUIAMgADYCDEEAIQIMTgtBNCECDDMLIANBL2otAABBAXENACADQQA2AhwgAyABNgIUIANB8RU2AhAgA0EZNgIMQQAhAgxMC0EyIQIMMQsgASAERgRAQTIhAgxLCwJAIAEtAABBCkYEQCABQQFqIQEMAQsgA0EANgIcIAMgATYCFCADQZgWNgIQIANBAzYCDEEAIQIMSwtBMSECDDALIAEgBEYEQEExIQIMSgsgAS0AACIAQQlHIABBIEdxDQEgAy0ALEEIRw0AIANBADoALAtBPCECDC4LQQEhAgJAAkACQAJAIAMtACxBBWsOBAMBAgAKCyADIAMvATJBCHI7ATIMCQtBAiECDAELQQQhAgsgA0EBOgAsIAMgAy8BMiACcjsBMgwGCyABIARGBEBBMCECDEcLIAEtAABBCkYEQCABQQFqIQEMAQsgAy0ALkEBcQ0AIANBADYCHCADIAE2AhQgA0HHJzYCECADQQI2AgxBACECDEYLQS8hAgwrCyABQQFqIQFBMCECDCoLIAEgBEYEQEEvIQIMRAsgAS0AACIAQQlHIABBIEdxRQRAIAFBAWohASADLQAuQQFxDQEgA0EANgIcIAMgATYCFCADQekPNgIQIANBCjYCDEEAIQIMRAtBASECAkACQAJAAkACQAJAIAMtACxBAmsOBwUEBAMBAgAECyADIAMvATJBCHI7ATIMAwtBAiECDAELQQQhAgsgA0EBOgAsIAMgAy8BMiACcjsBMgtBLiECDCoLIANBADYCHCADIAE2AhQgA0GzEjYCECADQQs2AgxBACECDEMLQdIBIQIMKAsgASAERgRAQS4hAgxCCyADQQA2AgQgA0ERNgIIIAMgASABEDAiAA0BC0EtIQIMJgsgA0EtNgIcIAMgATYCFCADIAA2AgxBACECDD8LQQAhAAJAIAMoAjgiAkUNACACKAJEIgJFDQAgAyACEQAAIQALIABFDQAgAEEVRw0BIANB2AA2AhwgAyABNgIUIANBnho2AhAgA0EVNgIMQQAhAgw+C0HLACECDCMLIANBADYCHCADIAE2AhQgA0GFDjYCECADQR02AgxBACECDDwLIAEgBEYEQEHOACECDDwLIAEtAAAiAEEgRg0CIABBOkYNAQsgA0EAOgAsQQkhAgwgCyADKAIEIQAgA0EANgIEIAMgACABEC8iAA0BDAILIAMtAC5BAXEEQEHPASECDB8LIAMoAgQhACADQQA2AgQgAyAAIAEQLyIARQ0CIANBKjYCHCADIAA2AgwgAyABQQFqNgIUQQAhAgw4CyADQcsANgIcIAMgADYCDCADIAFBAWo2AhRBACECDDcLIAFBAWohAUE/IQIMHAsgAUEBaiEBDCkLIAEgBEYEQEErIQIMNQsCQCABLQAAQQpGBEAgAUEBaiEBDAELIAMtAC5BwABxRQ0GCyADLQAyQYABcQRAQQAhAAJAIAMoAjgiAkUNACACKAJUIgJFDQAgAyACEQAAIQALIABFDREgAEEVRgRAIANBBTYCHCADIAE2AhQgA0GGGjYCECADQRU2AgxBACECDDYLIANBADYCHCADIAE2AhQgA0HiDTYCECADQRQ2AgxBACECDDULIANBMmohAiADEDRBACEAAkAgAygCOCIGRQ0AIAYoAiQiBkUNACADIAYRAAAhAAsgAA4WAgEABAQEBAQEBAQEBAQEBAQEBAQEAwQLIANBAToAMAsgAiACLwEAQcAAcjsBAAtBKiECDBcLIANBKTYCHCADIAE2AhQgA0GyGDYCECADQRU2AgxBACECDDALIANBADYCHCADIAE2AhQgA0HdCzYCECADQRE2AgxBACECDC8LIANBADYCHCADIAE2AhQgA0GdCzYCECADQQI2AgxBACECDC4LQQEhByADLwEyIgVBCHFFBEAgAykDIEIAUiEHCwJAIAMtADAEQEEBIQAgAy0AKUEFRg0BIAVBwABxRSAHcUUNAQsCQCADLQAoIgJBAkYEQEEBIQAgAy8BNCIGQeUARg0CQQAhACAFQcAAcQ0CIAZB5ABGDQIgBkHmAGtBAkkNAiAGQcwBRg0CIAZBsAJGDQIMAQtBACEAIAVBwABxDQELQQIhACAFQQhxDQAgBUGABHEEQAJAIAJBAUcNACADLQAuQQpxDQBBBSEADAILQQQhAAwBCyAFQSBxRQRAIAMQNUEAR0ECdCEADAELQQBBAyADKQMgUBshAAsCQCAAQQFrDgUAAQYHAgMLQQAhAgJAIAMoAjgiAEUNACAAKAIsIgBFDQAgAyAAEQAAIQILIAJFDSYgAkEVRgRAIANBAzYCHCADIAE2AhQgA0G9GjYCECADQRU2AgxBACECDC4LQQAhAiADQQA2AhwgAyABNgIUIANBrw42AhAgA0ESNgIMDC0LQc4BIQIMEgtBACECIANBADYCHCADIAE2AhQgA0HkHzYCECADQQ82AgwMKwtBACEAAkAgAygCOCICRQ0AIAIoAiwiAkUNACADIAIRAAAhAAsgAA0BC0EOIQIMDwsgAEEVRgRAIANBAjYCHCADIAE2AhQgA0G9GjYCECADQRU2AgxBACECDCkLQQAhAiADQQA2AhwgAyABNgIUIANBrw42AhAgA0ESNgIMDCgLQSkhAgwNCyADQQE6ADEMJAsgASAERwRAIANBCTYCCCADIAE2AgRBKCECDAwLQSYhAgwlCyADIAMpAyAiDCAEIAFrrSIKfSILQgAgCyAMWBs3AyAgCiAMVARAQSUhAgwlCyADKAIEIQBBACECIANBADYCBCADIAAgASAMp2oiARAxIgBFDQAgA0EFNgIcIAMgATYCFCADIAA2AgwMJAtBDyECDAkLIAEgBEYEQEEjIQIMIwtCACEKAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAIAEtAABBMGsONxcWAAECAwQFBgcUFBQUFBQUCAkKCwwNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQODxAREhMUC0ICIQoMFgtCAyEKDBULQgQhCgwUC0IFIQoMEwtCBiEKDBILQgchCgwRC0IIIQoMEAtCCSEKDA8LQgohCgwOC0ILIQoMDQtCDCEKDAwLQg0hCgwLC0IOIQoMCgtCDyEKDAkLQgohCgwIC0ILIQoMBwtCDCEKDAYLQg0hCgwFC0IOIQoMBAtCDyEKDAMLQQAhAiADQQA2AhwgAyABNgIUIANBzhQ2AhAgA0EMNgIMDCILIAEgBEYEQEEiIQIMIgtCACEKAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQCABLQAAQTBrDjcVFAABAgMEBQYHFhYWFhYWFggJCgsMDRYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWDg8QERITFgtCAiEKDBQLQgMhCgwTC0IEIQoMEgtCBSEKDBELQgYhCgwQC0IHIQoMDwtCCCEKDA4LQgkhCgwNC0IKIQoMDAtCCyEKDAsLQgwhCgwKC0INIQoMCQtCDiEKDAgLQg8hCgwHC0IKIQoMBgtCCyEKDAULQgwhCgwEC0INIQoMAwtCDiEKDAILQg8hCgwBC0IBIQoLIAFBAWohASADKQMgIgtC//////////8PWARAIAMgC0IEhiAKhDcDIAwCC0EAIQIgA0EANgIcIAMgATYCFCADQa0JNgIQIANBDDYCDAwfC0ElIQIMBAtBJiECDAMLIAMgAToALCADQQA2AgAgB0EBaiEBQQwhAgwCCyADQQA2AgAgBkEBaiEBQQohAgwBCyABQQFqIQFBCCECDAALAAtBACECIANBADYCHCADIAE2AhQgA0HVEDYCECADQQk2AgwMGAtBACECIANBADYCHCADIAE2AhQgA0HXCjYCECADQQk2AgwMFwtBACECIANBADYCHCADIAE2AhQgA0G/EDYCECADQQk2AgwMFgtBACECIANBADYCHCADIAE2AhQgA0GkETYCECADQQk2AgwMFQtBACECIANBADYCHCADIAE2AhQgA0HVEDYCECADQQk2AgwMFAtBACECIANBADYCHCADIAE2AhQgA0HXCjYCECADQQk2AgwMEwtBACECIANBADYCHCADIAE2AhQgA0G/EDYCECADQQk2AgwMEgtBACECIANBADYCHCADIAE2AhQgA0GkETYCECADQQk2AgwMEQtBACECIANBADYCHCADIAE2AhQgA0G/FjYCECADQQ82AgwMEAtBACECIANBADYCHCADIAE2AhQgA0G/FjYCECADQQ82AgwMDwtBACECIANBADYCHCADIAE2AhQgA0HIEjYCECADQQs2AgwMDgtBACECIANBADYCHCADIAE2AhQgA0GVCTYCECADQQs2AgwMDQtBACECIANBADYCHCADIAE2AhQgA0HpDzYCECADQQo2AgwMDAtBACECIANBADYCHCADIAE2AhQgA0GDEDYCECADQQo2AgwMCwtBACECIANBADYCHCADIAE2AhQgA0GmHDYCECADQQI2AgwMCgtBACECIANBADYCHCADIAE2AhQgA0HFFTYCECADQQI2AgwMCQtBACECIANBADYCHCADIAE2AhQgA0H/FzYCECADQQI2AgwMCAtBACECIANBADYCHCADIAE2AhQgA0HKFzYCECADQQI2AgwMBwsgA0ECNgIcIAMgATYCFCADQZQdNgIQIANBFjYCDEEAIQIMBgtB3gAhAiABIARGDQUgCUEIaiEHIAMoAgAhBQJAAkAgASAERwRAIAVBxsYAaiEIIAQgBWogAWshBiAFQX9zQQpqIgUgAWohAANAIAEtAAAgCC0AAEcEQEECIQgMAwsgBUUEQEEAIQggACEBDAMLIAVBAWshBSAIQQFqIQggBCABQQFqIgFHDQALIAYhBSAEIQELIAdBATYCACADIAU2AgAMAQsgA0EANgIAIAcgCDYCAAsgByABNgIEIAkoAgwhACAJKAIIDgMBBQIACwALIANBADYCHCADQa0dNgIQIANBFzYCDCADIABBAWo2AhRBACECDAMLIANBADYCHCADIAA2AhQgA0HCHTYCECADQQk2AgxBACECDAILIAEgBEYEQEEoIQIMAgsgA0EJNgIIIAMgATYCBEEnIQIMAQsgASAERgRAQQEhAgwBCwNAAkACQAJAIAEtAABBCmsOBAABAQABCyABQQFqIQEMAQsgAUEBaiEBIAMtAC5BIHENAEEAIQIgA0EANgIcIAMgATYCFCADQYwgNgIQIANBBTYCDAwCC0EBIQIgASAERw0ACwsgCUEQaiQAIAJFBEAgAygCDCEADAELIAMgAjYCHEEAIQAgAygCBCIBRQ0AIAMgASAEIAMoAggRAQAiAUUNACADIAQ2AhQgAyABNgIMIAEhAAsgAAu+AgECfyAAQQA6AAAgAEHcAGoiAUEBa0EAOgAAIABBADoAAiAAQQA6AAEgAUEDa0EAOgAAIAFBAmtBADoAACAAQQA6AAMgAUEEa0EAOgAAQQAgAGtBA3EiASAAaiIAQQA2AgBB3AAgAWtBfHEiAiAAaiIBQQRrQQA2AgACQCACQQlJDQAgAEEANgIIIABBADYCBCABQQhrQQA2AgAgAUEMa0EANgIAIAJBGUkNACAAQQA2AhggAEEANgIUIABBADYCECAAQQA2AgwgAUEQa0EANgIAIAFBFGtBADYCACABQRhrQQA2AgAgAUEca0EANgIAIAIgAEEEcUEYciICayIBQSBJDQAgACACaiEAA0AgAEIANwMYIABCADcDECAAQgA3AwggAEIANwMAIABBIGohACABQSBrIgFBH0sNAAsLC1YBAX8CQCAAKAIMDQACQAJAAkACQCAALQAxDgMBAAMCCyAAKAI4IgFFDQAgASgCLCIBRQ0AIAAgAREAACIBDQMLQQAPCwALIABB0Bg2AhBBDiEBCyABCxoAIAAoAgxFBEAgAEHJHjYCECAAQRU2AgwLCxQAIAAoAgxBFUYEQCAAQQA2AgwLCxQAIAAoAgxBFkYEQCAAQQA2AgwLCwcAIAAoAgwLBwAgACgCEAsJACAAIAE2AhALBwAgACgCFAsXACAAQSRPBEAACyAAQQJ0QZQ3aigCAAsXACAAQS9PBEAACyAAQQJ0QaQ4aigCAAu/CQEBf0HfLCEBAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAgAEHkAGsO9ANjYgABYWFhYWFhAgMEBWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWEGBwgJCgsMDQ4PYWFhYWEQYWFhYWFhYWFhYWERYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhEhMUFRYXGBkaG2FhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWEcHR4fICEiIyQlJicoKSorLC0uLzAxMjM0NTZhNzg5OmFhYWFhYWFhO2FhYTxhYWFhPT4/YWFhYWFhYWFAYWFBYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhQkNERUZHSElKS0xNTk9QUVJTYWFhYWFhYWFUVVZXWFlaW2FcXWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYV5hYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFfYGELQdUrDwtBgyUPC0G/MA8LQfI1DwtBtCgPC0GfKA8LQYEsDwtB1ioPC0H0Mw8LQa0zDwtByygPC0HOIw8LQcAjDwtB2SMPC0HRJA8LQZwzDwtBojYPC0H8Mw8LQeArDwtB4SUPC0HtIA8LQcQyDwtBqScPC0G5Ng8LQbggDwtBqyAPC0GjJA8LQbYkDwtBgSMPC0HhMg8LQZ80DwtByCkPC0HAMg8LQe4yDwtB8C8PC0HGNA8LQdAhDwtBmiQPC0HrLw8LQYQ1DwtByzUPC0GWMQ8LQcgrDwtB1C8PC0GTMA8LQd81DwtBtCMPC0G+NQ8LQdIpDwtBsyIPC0HNIA8LQZs2DwtBkCEPC0H/IA8LQa01DwtBsDQPC0HxJA8LQacqDwtB3TAPC0GLIg8LQcgvDwtB6yoPC0H0KQ8LQY8lDwtB3SIPC0HsJg8LQf0wDwtB1iYPC0GUNQ8LQY0jDwtBuikPC0HHIg8LQfIlDwtBtjMPC0GiIQ8LQf8vDwtBwCEPC0GBMw8LQcklDwtBqDEPC0HGMw8LQdM2DwtBxjYPC0HkNA8LQYgmDwtB7ScPC0H4IQ8LQakwDwtBjzQPC0GGNg8LQaovDwtBoSYPC0HsNg8LQZIpDwtBryYPC0GZIg8LQeAhDwsAC0G1JSEBCyABCxcAIAAgAC8BLkH+/wNxIAFBAEdyOwEuCxoAIAAgAC8BLkH9/wNxIAFBAEdBAXRyOwEuCxoAIAAgAC8BLkH7/wNxIAFBAEdBAnRyOwEuCxoAIAAgAC8BLkH3/wNxIAFBAEdBA3RyOwEuCxoAIAAgAC8BLkHv/wNxIAFBAEdBBHRyOwEuCxoAIAAgAC8BLkHf/wNxIAFBAEdBBXRyOwEuCxoAIAAgAC8BLkG//wNxIAFBAEdBBnRyOwEuCxoAIAAgAC8BLkH//gNxIAFBAEdBB3RyOwEuCxoAIAAgAC8BLkH//QNxIAFBAEdBCHRyOwEuCxoAIAAgAC8BLkH/+wNxIAFBAEdBCXRyOwEuCz4BAn8CQCAAKAI4IgNFDQAgAygCBCIDRQ0AIAAgASACIAFrIAMRAQAiBEF/Rw0AIABBzhE2AhBBGCEECyAECz4BAn8CQCAAKAI4IgNFDQAgAygCCCIDRQ0AIAAgASACIAFrIAMRAQAiBEF/Rw0AIABB5Ao2AhBBGCEECyAECz4BAn8CQCAAKAI4IgNFDQAgAygCDCIDRQ0AIAAgASACIAFrIAMRAQAiBEF/Rw0AIABB5R02AhBBGCEECyAECz4BAn8CQCAAKAI4IgNFDQAgAygCECIDRQ0AIAAgASACIAFrIAMRAQAiBEF/Rw0AIABBnRA2AhBBGCEECyAECz4BAn8CQCAAKAI4IgNFDQAgAygCFCIDRQ0AIAAgASACIAFrIAMRAQAiBEF/Rw0AIABBoh42AhBBGCEECyAECz4BAn8CQCAAKAI4IgNFDQAgAygCGCIDRQ0AIAAgASACIAFrIAMRAQAiBEF/Rw0AIABB7hQ2AhBBGCEECyAECz4BAn8CQCAAKAI4IgNFDQAgAygCKCIDRQ0AIAAgASACIAFrIAMRAQAiBEF/Rw0AIABB9gg2AhBBGCEECyAECz4BAn8CQCAAKAI4IgNFDQAgAygCHCIDRQ0AIAAgASACIAFrIAMRAQAiBEF/Rw0AIABB9xs2AhBBGCEECyAECz4BAn8CQCAAKAI4IgNFDQAgAygCICIDRQ0AIAAgASACIAFrIAMRAQAiBEF/Rw0AIABBlRU2AhBBGCEECyAECzgAIAACfyAALwEyQRRxQRRGBEBBASAALQAoQQFGDQEaIAAvATRB5QBGDAELIAAtAClBBUYLOgAwC1kBAn8CQCAALQAoQQFGDQAgAC8BNCIBQeQAa0HkAEkNACABQcwBRg0AIAFBsAJGDQAgAC8BMiIAQcAAcQ0AQQEhAiAAQYgEcUGABEYNACAAQShxRSECCyACC4wBAQJ/AkACQAJAIAAtACpFDQAgAC0AK0UNACAALwEyIgFBAnFFDQEMAgsgAC8BMiIBQQFxRQ0BC0EBIQIgAC0AKEEBRg0AIAAvATQiAEHkAGtB5ABJDQAgAEHMAUYNACAAQbACRg0AIAFBwABxDQBBACECIAFBiARxQYAERg0AIAFBKHFBAEchAgsgAgtzACAAQRBq/QwAAAAAAAAAAAAAAAAAAAAA/QsDACAA/QwAAAAAAAAAAAAAAAAAAAAA/QsDACAAQTBq/QwAAAAAAAAAAAAAAAAAAAAA/QsDACAAQSBq/QwAAAAAAAAAAAAAAAAAAAAA/QsDACAAQewBNgIcCwYAIAAQOQuaLQELfyMAQRBrIgokAEGY1AAoAgAiCUUEQEHY1wAoAgAiBUUEQEHk1wBCfzcCAEHc1wBCgICEgICAwAA3AgBB2NcAIApBCGpBcHFB2KrVqgVzIgU2AgBB7NcAQQA2AgBBvNcAQQA2AgALQcDXAEGA2AQ2AgBBkNQAQYDYBDYCAEGk1AAgBTYCAEGg1ABBfzYCAEHE1wBBgKgDNgIAA0AgAUG81ABqIAFBsNQAaiICNgIAIAIgAUGo1ABqIgM2AgAgAUG01ABqIAM2AgAgAUHE1ABqIAFBuNQAaiIDNgIAIAMgAjYCACABQczUAGogAUHA1ABqIgI2AgAgAiADNgIAIAFByNQAaiACNgIAIAFBIGoiAUGAAkcNAAtBjNgEQcGnAzYCAEGc1ABB6NcAKAIANgIAQYzUAEHApwM2AgBBmNQAQYjYBDYCAEHM/wdBODYCAEGI2AQhCQsCQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQCAAQewBTQRAQYDUACgCACIGQRAgAEETakFwcSAAQQtJGyIEQQN2IgB2IgFBA3EEQAJAIAFBAXEgAHJBAXMiAkEDdCIAQajUAGoiASAAQbDUAGooAgAiACgCCCIDRgRAQYDUACAGQX4gAndxNgIADAELIAEgAzYCCCADIAE2AgwLIABBCGohASAAIAJBA3QiAkEDcjYCBCAAIAJqIgAgACgCBEEBcjYCBAwRC0GI1AAoAgAiCCAETw0BIAEEQAJAQQIgAHQiAkEAIAJrciABIAB0cWgiAEEDdCICQajUAGoiASACQbDUAGooAgAiAigCCCIDRgRAQYDUACAGQX4gAHdxIgY2AgAMAQsgASADNgIIIAMgATYCDAsgAiAEQQNyNgIEIABBA3QiACAEayEFIAAgAmogBTYCACACIARqIgQgBUEBcjYCBCAIBEAgCEF4cUGo1ABqIQBBlNQAKAIAIQMCf0EBIAhBA3Z0IgEgBnFFBEBBgNQAIAEgBnI2AgAgAAwBCyAAKAIICyIBIAM2AgwgACADNgIIIAMgADYCDCADIAE2AggLIAJBCGohAUGU1AAgBDYCAEGI1AAgBTYCAAwRC0GE1AAoAgAiC0UNASALaEECdEGw1gBqKAIAIgAoAgRBeHEgBGshBSAAIQIDQAJAIAIoAhAiAUUEQCACQRRqKAIAIgFFDQELIAEoAgRBeHEgBGsiAyAFSSECIAMgBSACGyEFIAEgACACGyEAIAEhAgwBCwsgACgCGCEJIAAoAgwiAyAARwRAQZDUACgCABogAyAAKAIIIgE2AgggASADNgIMDBALIABBFGoiAigCACIBRQRAIAAoAhAiAUUNAyAAQRBqIQILA0AgAiEHIAEiA0EUaiICKAIAIgENACADQRBqIQIgAygCECIBDQALIAdBADYCAAwPC0F/IQQgAEG/f0sNACAAQRNqIgFBcHEhBEGE1AAoAgAiCEUNAEEAIARrIQUCQAJAAkACf0EAIARBgAJJDQAaQR8gBEH///8HSw0AGiAEQSYgAUEIdmciAGt2QQFxIABBAXRrQT5qCyIGQQJ0QbDWAGooAgAiAkUEQEEAIQFBACEDDAELQQAhASAEQRkgBkEBdmtBACAGQR9HG3QhAEEAIQMDQAJAIAIoAgRBeHEgBGsiByAFTw0AIAIhAyAHIgUNAEEAIQUgAiEBDAMLIAEgAkEUaigCACIHIAcgAiAAQR12QQRxakEQaigCACICRhsgASAHGyEBIABBAXQhACACDQALCyABIANyRQRAQQAhA0ECIAZ0IgBBACAAa3IgCHEiAEUNAyAAaEECdEGw1gBqKAIAIQELIAFFDQELA0AgASgCBEF4cSAEayICIAVJIQAgAiAFIAAbIQUgASADIAAbIQMgASgCECIABH8gAAUgAUEUaigCAAsiAQ0ACwsgA0UNACAFQYjUACgCACAEa08NACADKAIYIQcgAyADKAIMIgBHBEBBkNQAKAIAGiAAIAMoAggiATYCCCABIAA2AgwMDgsgA0EUaiICKAIAIgFFBEAgAygCECIBRQ0DIANBEGohAgsDQCACIQYgASIAQRRqIgIoAgAiAQ0AIABBEGohAiAAKAIQIgENAAsgBkEANgIADA0LQYjUACgCACIDIARPBEBBlNQAKAIAIQECQCADIARrIgJBEE8EQCABIARqIgAgAkEBcjYCBCABIANqIAI2AgAgASAEQQNyNgIEDAELIAEgA0EDcjYCBCABIANqIgAgACgCBEEBcjYCBEEAIQBBACECC0GI1AAgAjYCAEGU1AAgADYCACABQQhqIQEMDwtBjNQAKAIAIgMgBEsEQCAEIAlqIgAgAyAEayIBQQFyNgIEQZjUACAANgIAQYzUACABNgIAIAkgBEEDcjYCBCAJQQhqIQEMDwtBACEBIAQCf0HY1wAoAgAEQEHg1wAoAgAMAQtB5NcAQn83AgBB3NcAQoCAhICAgMAANwIAQdjXACAKQQxqQXBxQdiq1aoFczYCAEHs1wBBADYCAEG81wBBADYCAEGAgAQLIgAgBEHHAGoiBWoiBkEAIABrIgdxIgJPBEBB8NcAQTA2AgAMDwsCQEG41wAoAgAiAUUNAEGw1wAoAgAiCCACaiEAIAAgAU0gACAIS3ENAEEAIQFB8NcAQTA2AgAMDwtBvNcALQAAQQRxDQQCQAJAIAkEQEHA1wAhAQNAIAEoAgAiACAJTQRAIAAgASgCBGogCUsNAwsgASgCCCIBDQALC0EAEDoiAEF/Rg0FIAIhBkHc1wAoAgAiAUEBayIDIABxBEAgAiAAayAAIANqQQAgAWtxaiEGCyAEIAZPDQUgBkH+////B0sNBUG41wAoAgAiAwRAQbDXACgCACIHIAZqIQEgASAHTQ0GIAEgA0sNBgsgBhA6IgEgAEcNAQwHCyAGIANrIAdxIgZB/v///wdLDQQgBhA6IQAgACABKAIAIAEoAgRqRg0DIAAhAQsCQCAGIARByABqTw0AIAFBf0YNAEHg1wAoAgAiACAFIAZrakEAIABrcSIAQf7///8HSwRAIAEhAAwHCyAAEDpBf0cEQCAAIAZqIQYgASEADAcLQQAgBmsQOhoMBAsgASIAQX9HDQUMAwtBACEDDAwLQQAhAAwKCyAAQX9HDQILQbzXAEG81wAoAgBBBHI2AgALIAJB/v///wdLDQEgAhA6IQBBABA6IQEgAEF/Rg0BIAFBf0YNASAAIAFPDQEgASAAayIGIARBOGpNDQELQbDXAEGw1wAoAgAgBmoiATYCAEG01wAoAgAgAUkEQEG01wAgATYCAAsCQAJAAkBBmNQAKAIAIgIEQEHA1wAhAQNAIAAgASgCACIDIAEoAgQiBWpGDQIgASgCCCIBDQALDAILQZDUACgCACIBQQBHIAAgAU9xRQRAQZDUACAANgIAC0EAIQFBxNcAIAY2AgBBwNcAIAA2AgBBoNQAQX82AgBBpNQAQdjXACgCADYCAEHM1wBBADYCAANAIAFBvNQAaiABQbDUAGoiAjYCACACIAFBqNQAaiIDNgIAIAFBtNQAaiADNgIAIAFBxNQAaiABQbjUAGoiAzYCACADIAI2AgAgAUHM1ABqIAFBwNQAaiICNgIAIAIgAzYCACABQcjUAGogAjYCACABQSBqIgFBgAJHDQALQXggAGtBD3EiASAAaiICIAZBOGsiAyABayIBQQFyNgIEQZzUAEHo1wAoAgA2AgBBjNQAIAE2AgBBmNQAIAI2AgAgACADakE4NgIEDAILIAAgAk0NACACIANJDQAgASgCDEEIcQ0AQXggAmtBD3EiACACaiIDQYzUACgCACAGaiIHIABrIgBBAXI2AgQgASAFIAZqNgIEQZzUAEHo1wAoAgA2AgBBjNQAIAA2AgBBmNQAIAM2AgAgAiAHakE4NgIEDAELIABBkNQAKAIASQRAQZDUACAANgIACyAAIAZqIQNBwNcAIQECQAJAAkADQCADIAEoAgBHBEAgASgCCCIBDQEMAgsLIAEtAAxBCHFFDQELQcDXACEBA0AgASgCACIDIAJNBEAgAyABKAIEaiIFIAJLDQMLIAEoAgghAQwACwALIAEgADYCACABIAEoAgQgBmo2AgQgAEF4IABrQQ9xaiIJIARBA3I2AgQgA0F4IANrQQ9xaiIGIAQgCWoiBGshASACIAZGBEBBmNQAIAQ2AgBBjNQAQYzUACgCACABaiIANgIAIAQgAEEBcjYCBAwIC0GU1AAoAgAgBkYEQEGU1AAgBDYCAEGI1ABBiNQAKAIAIAFqIgA2AgAgBCAAQQFyNgIEIAAgBGogADYCAAwICyAGKAIEIgVBA3FBAUcNBiAFQXhxIQggBUH/AU0EQCAFQQN2IQMgBigCCCIAIAYoAgwiAkYEQEGA1ABBgNQAKAIAQX4gA3dxNgIADAcLIAIgADYCCCAAIAI2AgwMBgsgBigCGCEHIAYgBigCDCIARwRAIAAgBigCCCICNgIIIAIgADYCDAwFCyAGQRRqIgIoAgAiBUUEQCAGKAIQIgVFDQQgBkEQaiECCwNAIAIhAyAFIgBBFGoiAigCACIFDQAgAEEQaiECIAAoAhAiBQ0ACyADQQA2AgAMBAtBeCAAa0EPcSIBIABqIgcgBkE4ayIDIAFrIgFBAXI2AgQgACADakE4NgIEIAIgBUE3IAVrQQ9xakE/ayIDIAMgAkEQakkbIgNBIzYCBEGc1ABB6NcAKAIANgIAQYzUACABNgIAQZjUACAHNgIAIANBEGpByNcAKQIANwIAIANBwNcAKQIANwIIQcjXACADQQhqNgIAQcTXACAGNgIAQcDXACAANgIAQczXAEEANgIAIANBJGohAQNAIAFBBzYCACAFIAFBBGoiAUsNAAsgAiADRg0AIAMgAygCBEF+cTYCBCADIAMgAmsiBTYCACACIAVBAXI2AgQgBUH/AU0EQCAFQXhxQajUAGohAAJ/QYDUACgCACIBQQEgBUEDdnQiA3FFBEBBgNQAIAEgA3I2AgAgAAwBCyAAKAIICyIBIAI2AgwgACACNgIIIAIgADYCDCACIAE2AggMAQtBHyEBIAVB////B00EQCAFQSYgBUEIdmciAGt2QQFxIABBAXRrQT5qIQELIAIgATYCHCACQgA3AhAgAUECdEGw1gBqIQBBhNQAKAIAIgNBASABdCIGcUUEQCAAIAI2AgBBhNQAIAMgBnI2AgAgAiAANgIYIAIgAjYCCCACIAI2AgwMAQsgBUEZIAFBAXZrQQAgAUEfRxt0IQEgACgCACEDAkADQCADIgAoAgRBeHEgBUYNASABQR12IQMgAUEBdCEBIAAgA0EEcWpBEGoiBigCACIDDQALIAYgAjYCACACIAA2AhggAiACNgIMIAIgAjYCCAwBCyAAKAIIIgEgAjYCDCAAIAI2AgggAkEANgIYIAIgADYCDCACIAE2AggLQYzUACgCACIBIARNDQBBmNQAKAIAIgAgBGoiAiABIARrIgFBAXI2AgRBjNQAIAE2AgBBmNQAIAI2AgAgACAEQQNyNgIEIABBCGohAQwIC0EAIQFB8NcAQTA2AgAMBwtBACEACyAHRQ0AAkAgBigCHCICQQJ0QbDWAGoiAygCACAGRgRAIAMgADYCACAADQFBhNQAQYTUACgCAEF+IAJ3cTYCAAwCCyAHQRBBFCAHKAIQIAZGG2ogADYCACAARQ0BCyAAIAc2AhggBigCECICBEAgACACNgIQIAIgADYCGAsgBkEUaigCACICRQ0AIABBFGogAjYCACACIAA2AhgLIAEgCGohASAGIAhqIgYoAgQhBQsgBiAFQX5xNgIEIAEgBGogATYCACAEIAFBAXI2AgQgAUH/AU0EQCABQXhxQajUAGohAAJ/QYDUACgCACICQQEgAUEDdnQiAXFFBEBBgNQAIAEgAnI2AgAgAAwBCyAAKAIICyIBIAQ2AgwgACAENgIIIAQgADYCDCAEIAE2AggMAQtBHyEFIAFB////B00EQCABQSYgAUEIdmciAGt2QQFxIABBAXRrQT5qIQULIAQgBTYCHCAEQgA3AhAgBUECdEGw1gBqIQBBhNQAKAIAIgJBASAFdCIDcUUEQCAAIAQ2AgBBhNQAIAIgA3I2AgAgBCAANgIYIAQgBDYCCCAEIAQ2AgwMAQsgAUEZIAVBAXZrQQAgBUEfRxt0IQUgACgCACEAAkADQCAAIgIoAgRBeHEgAUYNASAFQR12IQAgBUEBdCEFIAIgAEEEcWpBEGoiAygCACIADQALIAMgBDYCACAEIAI2AhggBCAENgIMIAQgBDYCCAwBCyACKAIIIgAgBDYCDCACIAQ2AgggBEEANgIYIAQgAjYCDCAEIAA2AggLIAlBCGohAQwCCwJAIAdFDQACQCADKAIcIgFBAnRBsNYAaiICKAIAIANGBEAgAiAANgIAIAANAUGE1AAgCEF+IAF3cSIINgIADAILIAdBEEEUIAcoAhAgA0YbaiAANgIAIABFDQELIAAgBzYCGCADKAIQIgEEQCAAIAE2AhAgASAANgIYCyADQRRqKAIAIgFFDQAgAEEUaiABNgIAIAEgADYCGAsCQCAFQQ9NBEAgAyAEIAVqIgBBA3I2AgQgACADaiIAIAAoAgRBAXI2AgQMAQsgAyAEaiICIAVBAXI2AgQgAyAEQQNyNgIEIAIgBWogBTYCACAFQf8BTQRAIAVBeHFBqNQAaiEAAn9BgNQAKAIAIgFBASAFQQN2dCIFcUUEQEGA1AAgASAFcjYCACAADAELIAAoAggLIgEgAjYCDCAAIAI2AgggAiAANgIMIAIgATYCCAwBC0EfIQEgBUH///8HTQRAIAVBJiAFQQh2ZyIAa3ZBAXEgAEEBdGtBPmohAQsgAiABNgIcIAJCADcCECABQQJ0QbDWAGohAEEBIAF0IgQgCHFFBEAgACACNgIAQYTUACAEIAhyNgIAIAIgADYCGCACIAI2AgggAiACNgIMDAELIAVBGSABQQF2a0EAIAFBH0cbdCEBIAAoAgAhBAJAA0AgBCIAKAIEQXhxIAVGDQEgAUEddiEEIAFBAXQhASAAIARBBHFqQRBqIgYoAgAiBA0ACyAGIAI2AgAgAiAANgIYIAIgAjYCDCACIAI2AggMAQsgACgCCCIBIAI2AgwgACACNgIIIAJBADYCGCACIAA2AgwgAiABNgIICyADQQhqIQEMAQsCQCAJRQ0AAkAgACgCHCIBQQJ0QbDWAGoiAigCACAARgRAIAIgAzYCACADDQFBhNQAIAtBfiABd3E2AgAMAgsgCUEQQRQgCSgCECAARhtqIAM2AgAgA0UNAQsgAyAJNgIYIAAoAhAiAQRAIAMgATYCECABIAM2AhgLIABBFGooAgAiAUUNACADQRRqIAE2AgAgASADNgIYCwJAIAVBD00EQCAAIAQgBWoiAUEDcjYCBCAAIAFqIgEgASgCBEEBcjYCBAwBCyAAIARqIgcgBUEBcjYCBCAAIARBA3I2AgQgBSAHaiAFNgIAIAgEQCAIQXhxQajUAGohAUGU1AAoAgAhAwJ/QQEgCEEDdnQiAiAGcUUEQEGA1AAgAiAGcjYCACABDAELIAEoAggLIgIgAzYCDCABIAM2AgggAyABNgIMIAMgAjYCCAtBlNQAIAc2AgBBiNQAIAU2AgALIABBCGohAQsgCkEQaiQAIAELQwAgAEUEQD8AQRB0DwsCQCAAQf//A3ENACAAQQBIDQAgAEEQdkAAIgBBf0YEQEHw1wBBMDYCAEF/DwsgAEEQdA8LAAsL20AiAEGACAsJAQAAAAIAAAADAEGUCAsFBAAAAAUAQaQICwkGAAAABwAAAAgAQdwIC4IxSW52YWxpZCBjaGFyIGluIHVybCBxdWVyeQBTcGFuIGNhbGxiYWNrIGVycm9yIGluIG9uX2JvZHkAQ29udGVudC1MZW5ndGggb3ZlcmZsb3cAQ2h1bmsgc2l6ZSBvdmVyZmxvdwBJbnZhbGlkIG1ldGhvZCBmb3IgSFRUUC94LnggcmVxdWVzdABJbnZhbGlkIG1ldGhvZCBmb3IgUlRTUC94LnggcmVxdWVzdABFeHBlY3RlZCBTT1VSQ0UgbWV0aG9kIGZvciBJQ0UveC54IHJlcXVlc3QASW52YWxpZCBjaGFyIGluIHVybCBmcmFnbWVudCBzdGFydABFeHBlY3RlZCBkb3QAU3BhbiBjYWxsYmFjayBlcnJvciBpbiBvbl9zdGF0dXMASW52YWxpZCByZXNwb25zZSBzdGF0dXMARXhwZWN0ZWQgTEYgYWZ0ZXIgaGVhZGVycwBJbnZhbGlkIGNoYXJhY3RlciBpbiBjaHVuayBleHRlbnNpb25zAFVzZXIgY2FsbGJhY2sgZXJyb3IAYG9uX3Jlc2V0YCBjYWxsYmFjayBlcnJvcgBgb25fY2h1bmtfaGVhZGVyYCBjYWxsYmFjayBlcnJvcgBgb25fbWVzc2FnZV9iZWdpbmAgY2FsbGJhY2sgZXJyb3IAYG9uX2NodW5rX2V4dGVuc2lvbl92YWx1ZWAgY2FsbGJhY2sgZXJyb3IAYG9uX3N0YXR1c19jb21wbGV0ZWAgY2FsbGJhY2sgZXJyb3IAYG9uX3ZlcnNpb25fY29tcGxldGVgIGNhbGxiYWNrIGVycm9yAGBvbl91cmxfY29tcGxldGVgIGNhbGxiYWNrIGVycm9yAGBvbl9jaHVua19jb21wbGV0ZWAgY2FsbGJhY2sgZXJyb3IAYG9uX2hlYWRlcl92YWx1ZV9jb21wbGV0ZWAgY2FsbGJhY2sgZXJyb3IAYG9uX21lc3NhZ2VfY29tcGxldGVgIGNhbGxiYWNrIGVycm9yAGBvbl9tZXRob2RfY29tcGxldGVgIGNhbGxiYWNrIGVycm9yAGBvbl9oZWFkZXJfZmllbGRfY29tcGxldGVgIGNhbGxiYWNrIGVycm9yAGBvbl9jaHVua19leHRlbnNpb25fbmFtZWAgY2FsbGJhY2sgZXJyb3IAVW5leHBlY3RlZCBjaGFyIGluIHVybCBzZXJ2ZXIASW52YWxpZCBoZWFkZXIgdmFsdWUgY2hhcgBJbnZhbGlkIGhlYWRlciBmaWVsZCBjaGFyAFNwYW4gY2FsbGJhY2sgZXJyb3IgaW4gb25fdmVyc2lvbgBJbnZhbGlkIG1pbm9yIHZlcnNpb24ASW52YWxpZCBtYWpvciB2ZXJzaW9uAEV4cGVjdGVkIHNwYWNlIGFmdGVyIHZlcnNpb24ARXhwZWN0ZWQgQ1JMRiBhZnRlciB2ZXJzaW9uAEludmFsaWQgSFRUUCB2ZXJzaW9uAEludmFsaWQgaGVhZGVyIHRva2VuAFNwYW4gY2FsbGJhY2sgZXJyb3IgaW4gb25fdXJsAEludmFsaWQgY2hhcmFjdGVycyBpbiB1cmwAVW5leHBlY3RlZCBzdGFydCBjaGFyIGluIHVybABEb3VibGUgQCBpbiB1cmwARW1wdHkgQ29udGVudC1MZW5ndGgASW52YWxpZCBjaGFyYWN0ZXIgaW4gQ29udGVudC1MZW5ndGgAVHJhbnNmZXItRW5jb2RpbmcgY2FuJ3QgYmUgcHJlc2VudCB3aXRoIENvbnRlbnQtTGVuZ3RoAER1cGxpY2F0ZSBDb250ZW50LUxlbmd0aABJbnZhbGlkIGNoYXIgaW4gdXJsIHBhdGgAQ29udGVudC1MZW5ndGggY2FuJ3QgYmUgcHJlc2VudCB3aXRoIFRyYW5zZmVyLUVuY29kaW5nAE1pc3NpbmcgZXhwZWN0ZWQgQ1IgYWZ0ZXIgY2h1bmsgc2l6ZQBFeHBlY3RlZCBMRiBhZnRlciBjaHVuayBzaXplAEludmFsaWQgY2hhcmFjdGVyIGluIGNodW5rIHNpemUAU3BhbiBjYWxsYmFjayBlcnJvciBpbiBvbl9oZWFkZXJfdmFsdWUAU3BhbiBjYWxsYmFjayBlcnJvciBpbiBvbl9jaHVua19leHRlbnNpb25fdmFsdWUASW52YWxpZCBjaGFyYWN0ZXIgaW4gY2h1bmsgZXh0ZW5zaW9ucyB2YWx1ZQBNaXNzaW5nIGV4cGVjdGVkIENSIGFmdGVyIGhlYWRlciB2YWx1ZQBNaXNzaW5nIGV4cGVjdGVkIExGIGFmdGVyIGhlYWRlciB2YWx1ZQBJbnZhbGlkIGBUcmFuc2Zlci1FbmNvZGluZ2AgaGVhZGVyIHZhbHVlAE1pc3NpbmcgZXhwZWN0ZWQgQ1IgYWZ0ZXIgY2h1bmsgZXh0ZW5zaW9uIHZhbHVlAEludmFsaWQgY2hhcmFjdGVyIGluIGNodW5rIGV4dGVuc2lvbnMgcXVvdGUgdmFsdWUASW52YWxpZCBxdW90ZWQtcGFpciBpbiBjaHVuayBleHRlbnNpb25zIHF1b3RlZCB2YWx1ZQBJbnZhbGlkIGNoYXJhY3RlciBpbiBjaHVuayBleHRlbnNpb25zIHF1b3RlZCB2YWx1ZQBQYXVzZWQgYnkgb25faGVhZGVyc19jb21wbGV0ZQBJbnZhbGlkIEVPRiBzdGF0ZQBvbl9yZXNldCBwYXVzZQBvbl9jaHVua19oZWFkZXIgcGF1c2UAb25fbWVzc2FnZV9iZWdpbiBwYXVzZQBvbl9jaHVua19leHRlbnNpb25fdmFsdWUgcGF1c2UAb25fc3RhdHVzX2NvbXBsZXRlIHBhdXNlAG9uX3ZlcnNpb25fY29tcGxldGUgcGF1c2UAb25fdXJsX2NvbXBsZXRlIHBhdXNlAG9uX2NodW5rX2NvbXBsZXRlIHBhdXNlAG9uX2hlYWRlcl92YWx1ZV9jb21wbGV0ZSBwYXVzZQBvbl9tZXNzYWdlX2NvbXBsZXRlIHBhdXNlAG9uX21ldGhvZF9jb21wbGV0ZSBwYXVzZQBvbl9oZWFkZXJfZmllbGRfY29tcGxldGUgcGF1c2UAb25fY2h1bmtfZXh0ZW5zaW9uX25hbWUgcGF1c2UAVW5leHBlY3RlZCBzcGFjZSBhZnRlciBzdGFydCBsaW5lAE1pc3NpbmcgZXhwZWN0ZWQgQ1IgYWZ0ZXIgcmVzcG9uc2UgbGluZQBTcGFuIGNhbGxiYWNrIGVycm9yIGluIG9uX2NodW5rX2V4dGVuc2lvbl9uYW1lAEludmFsaWQgY2hhcmFjdGVyIGluIGNodW5rIGV4dGVuc2lvbnMgbmFtZQBNaXNzaW5nIGV4cGVjdGVkIENSIGFmdGVyIGNodW5rIGV4dGVuc2lvbiBuYW1lAEludmFsaWQgc3RhdHVzIGNvZGUAUGF1c2Ugb24gQ09OTkVDVC9VcGdyYWRlAFBhdXNlIG9uIFBSSS9VcGdyYWRlAEV4cGVjdGVkIEhUVFAvMiBDb25uZWN0aW9uIFByZWZhY2UAU3BhbiBjYWxsYmFjayBlcnJvciBpbiBvbl9tZXRob2QARXhwZWN0ZWQgc3BhY2UgYWZ0ZXIgbWV0aG9kAFNwYW4gY2FsbGJhY2sgZXJyb3IgaW4gb25faGVhZGVyX2ZpZWxkAFBhdXNlZABJbnZhbGlkIHdvcmQgZW5jb3VudGVyZWQASW52YWxpZCBtZXRob2QgZW5jb3VudGVyZWQATWlzc2luZyBleHBlY3RlZCBDUiBhZnRlciBjaHVuayBkYXRhAEV4cGVjdGVkIExGIGFmdGVyIGNodW5rIGRhdGEAVW5leHBlY3RlZCBjaGFyIGluIHVybCBzY2hlbWEAUmVxdWVzdCBoYXMgaW52YWxpZCBgVHJhbnNmZXItRW5jb2RpbmdgAERhdGEgYWZ0ZXIgYENvbm5lY3Rpb246IGNsb3NlYABTV0lUQ0hfUFJPWFkAVVNFX1BST1hZAE1LQUNUSVZJVFkAVU5QUk9DRVNTQUJMRV9FTlRJVFkAUVVFUlkAQ09QWQBNT1ZFRF9QRVJNQU5FTlRMWQBUT09fRUFSTFkATk9USUZZAEZBSUxFRF9ERVBFTkRFTkNZAEJBRF9HQVRFV0FZAFBMQVkAUFVUAENIRUNLT1VUAEdBVEVXQVlfVElNRU9VVABSRVFVRVNUX1RJTUVPVVQATkVUV09SS19DT05ORUNUX1RJTUVPVVQAQ09OTkVDVElPTl9USU1FT1VUAExPR0lOX1RJTUVPVVQATkVUV09SS19SRUFEX1RJTUVPVVQAUE9TVABNSVNESVJFQ1RFRF9SRVFVRVNUAENMSUVOVF9DTE9TRURfUkVRVUVTVABDTElFTlRfQ0xPU0VEX0xPQURfQkFMQU5DRURfUkVRVUVTVABCQURfUkVRVUVTVABIVFRQX1JFUVVFU1RfU0VOVF9UT19IVFRQU19QT1JUAFJFUE9SVABJTV9BX1RFQVBPVABSRVNFVF9DT05URU5UAE5PX0NPTlRFTlQAUEFSVElBTF9DT05URU5UAEhQRV9JTlZBTElEX0NPTlNUQU5UAEhQRV9DQl9SRVNFVABHRVQASFBFX1NUUklDVABDT05GTElDVABURU1QT1JBUllfUkVESVJFQ1QAUEVSTUFORU5UX1JFRElSRUNUAENPTk5FQ1QATVVMVElfU1RBVFVTAEhQRV9JTlZBTElEX1NUQVRVUwBUT09fTUFOWV9SRVFVRVNUUwBFQVJMWV9ISU5UUwBVTkFWQUlMQUJMRV9GT1JfTEVHQUxfUkVBU09OUwBPUFRJT05TAFNXSVRDSElOR19QUk9UT0NPTFMAVkFSSUFOVF9BTFNPX05FR09USUFURVMATVVMVElQTEVfQ0hPSUNFUwBJTlRFUk5BTF9TRVJWRVJfRVJST1IAV0VCX1NFUlZFUl9VTktOT1dOX0VSUk9SAFJBSUxHVU5fRVJST1IASURFTlRJVFlfUFJPVklERVJfQVVUSEVOVElDQVRJT05fRVJST1IAU1NMX0NFUlRJRklDQVRFX0VSUk9SAElOVkFMSURfWF9GT1JXQVJERURfRk9SAFNFVF9QQVJBTUVURVIAR0VUX1BBUkFNRVRFUgBIUEVfVVNFUgBTRUVfT1RIRVIASFBFX0NCX0NIVU5LX0hFQURFUgBFeHBlY3RlZCBMRiBhZnRlciBDUgBNS0NBTEVOREFSAFNFVFVQAFdFQl9TRVJWRVJfSVNfRE9XTgBURUFSRE9XTgBIUEVfQ0xPU0VEX0NPTk5FQ1RJT04ASEVVUklTVElDX0VYUElSQVRJT04ARElTQ09OTkVDVEVEX09QRVJBVElPTgBOT05fQVVUSE9SSVRBVElWRV9JTkZPUk1BVElPTgBIUEVfSU5WQUxJRF9WRVJTSU9OAEhQRV9DQl9NRVNTQUdFX0JFR0lOAFNJVEVfSVNfRlJPWkVOAEhQRV9JTlZBTElEX0hFQURFUl9UT0tFTgBJTlZBTElEX1RPS0VOAEZPUkJJRERFTgBFTkhBTkNFX1lPVVJfQ0FMTQBIUEVfSU5WQUxJRF9VUkwAQkxPQ0tFRF9CWV9QQVJFTlRBTF9DT05UUk9MAE1LQ09MAEFDTABIUEVfSU5URVJOQUwAUkVRVUVTVF9IRUFERVJfRklFTERTX1RPT19MQVJHRV9VTk9GRklDSUFMAEhQRV9PSwBVTkxJTksAVU5MT0NLAFBSSQBSRVRSWV9XSVRIAEhQRV9JTlZBTElEX0NPTlRFTlRfTEVOR1RIAEhQRV9VTkVYUEVDVEVEX0NPTlRFTlRfTEVOR1RIAEZMVVNIAFBST1BQQVRDSABNLVNFQVJDSABVUklfVE9PX0xPTkcAUFJPQ0VTU0lORwBNSVNDRUxMQU5FT1VTX1BFUlNJU1RFTlRfV0FSTklORwBNSVNDRUxMQU5FT1VTX1dBUk5JTkcASFBFX0lOVkFMSURfVFJBTlNGRVJfRU5DT0RJTkcARXhwZWN0ZWQgQ1JMRgBIUEVfSU5WQUxJRF9DSFVOS19TSVpFAE1PVkUAQ09OVElOVUUASFBFX0NCX1NUQVRVU19DT01QTEVURQBIUEVfQ0JfSEVBREVSU19DT01QTEVURQBIUEVfQ0JfVkVSU0lPTl9DT01QTEVURQBIUEVfQ0JfVVJMX0NPTVBMRVRFAEhQRV9DQl9DSFVOS19DT01QTEVURQBIUEVfQ0JfSEVBREVSX1ZBTFVFX0NPTVBMRVRFAEhQRV9DQl9DSFVOS19FWFRFTlNJT05fVkFMVUVfQ09NUExFVEUASFBFX0NCX0NIVU5LX0VYVEVOU0lPTl9OQU1FX0NPTVBMRVRFAEhQRV9DQl9NRVNTQUdFX0NPTVBMRVRFAEhQRV9DQl9NRVRIT0RfQ09NUExFVEUASFBFX0NCX0hFQURFUl9GSUVMRF9DT01QTEVURQBERUxFVEUASFBFX0lOVkFMSURfRU9GX1NUQVRFAElOVkFMSURfU1NMX0NFUlRJRklDQVRFAFBBVVNFAE5PX1JFU1BPTlNFAFVOU1VQUE9SVEVEX01FRElBX1RZUEUAR09ORQBOT1RfQUNDRVBUQUJMRQBTRVJWSUNFX1VOQVZBSUxBQkxFAFJBTkdFX05PVF9TQVRJU0ZJQUJMRQBPUklHSU5fSVNfVU5SRUFDSEFCTEUAUkVTUE9OU0VfSVNfU1RBTEUAUFVSR0UATUVSR0UAUkVRVUVTVF9IRUFERVJfRklFTERTX1RPT19MQVJHRQBSRVFVRVNUX0hFQURFUl9UT09fTEFSR0UAUEFZTE9BRF9UT09fTEFSR0UASU5TVUZGSUNJRU5UX1NUT1JBR0UASFBFX1BBVVNFRF9VUEdSQURFAEhQRV9QQVVTRURfSDJfVVBHUkFERQBTT1VSQ0UAQU5OT1VOQ0UAVFJBQ0UASFBFX1VORVhQRUNURURfU1BBQ0UAREVTQ1JJQkUAVU5TVUJTQ1JJQkUAUkVDT1JEAEhQRV9JTlZBTElEX01FVEhPRABOT1RfRk9VTkQAUFJPUEZJTkQAVU5CSU5EAFJFQklORABVTkFVVEhPUklaRUQATUVUSE9EX05PVF9BTExPV0VEAEhUVFBfVkVSU0lPTl9OT1RfU1VQUE9SVEVEAEFMUkVBRFlfUkVQT1JURUQAQUNDRVBURUQATk9UX0lNUExFTUVOVEVEAExPT1BfREVURUNURUQASFBFX0NSX0VYUEVDVEVEAEhQRV9MRl9FWFBFQ1RFRABDUkVBVEVEAElNX1VTRUQASFBFX1BBVVNFRABUSU1FT1VUX09DQ1VSRUQAUEFZTUVOVF9SRVFVSVJFRABQUkVDT05ESVRJT05fUkVRVUlSRUQAUFJPWFlfQVVUSEVOVElDQVRJT05fUkVRVUlSRUQATkVUV09SS19BVVRIRU5USUNBVElPTl9SRVFVSVJFRABMRU5HVEhfUkVRVUlSRUQAU1NMX0NFUlRJRklDQVRFX1JFUVVJUkVEAFVQR1JBREVfUkVRVUlSRUQAUEFHRV9FWFBJUkVEAFBSRUNPTkRJVElPTl9GQUlMRUQARVhQRUNUQVRJT05fRkFJTEVEAFJFVkFMSURBVElPTl9GQUlMRUQAU1NMX0hBTkRTSEFLRV9GQUlMRUQATE9DS0VEAFRSQU5TRk9STUFUSU9OX0FQUExJRUQATk9UX01PRElGSUVEAE5PVF9FWFRFTkRFRABCQU5EV0lEVEhfTElNSVRfRVhDRUVERUQAU0lURV9JU19PVkVSTE9BREVEAEhFQUQARXhwZWN0ZWQgSFRUUC8AAFIVAAAaFQAADxIAAOQZAACRFQAACRQAAC0ZAADkFAAA6REAAGkUAAChFAAAdhUAAEMWAABeEgAAlBcAABcWAAB9FAAAfxYAAEEXAACzEwAAwxYAAAQaAAC9GAAA0BgAAKATAADUGQAArxYAAGgWAABwFwAA2RYAAPwYAAD+EQAAWRcAAJcWAAAcFwAA9hYAAI0XAAALEgAAfxsAAC4RAACzEAAASRIAAK0SAAD2GAAAaBAAAGIVAAAQFQAAWhYAAEoZAAC1FQAAwRUAAGAVAABcGQAAWhkAAFMZAAAWFQAArREAAEIQAAC3EAAAVxgAAL8VAACJEAAAHBkAABoZAAC5FQAAURgAANwTAABbFQAAWRUAAOYYAABnFQAAERkAAO0YAADnEwAArhAAAMIXAAAAFAAAkhMAAIQTAABAEgAAJhkAAK8VAABiEABB6TkLAQEAQYA6C+ABAQECAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAwEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEAQeo7CwQBAAACAEGBPAteAwQDAwMDAwAAAwMAAwMAAwMDAwMDAwMDAwAFAAAAAAADAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwAAAAMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAAMAAwBB6j0LBAEAAAIAQYE+C14DAAMDAwMDAAADAwADAwADAwMDAwMDAwMDAAQABQAAAAMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAAAAAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMAAwADAEHgPwsNbG9zZWVlcC1hbGl2ZQBB+T8LAQEAQZDAAAvgAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAEH5wQALAQEAQZDCAAvnAQEBAQEBAQEBAQEBAQIBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBY2h1bmtlZABBocQAC14BAAEBAQEBAAABAQABAQABAQEBAQEBAQEBAAAAAAAAAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAAAAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEAAQABAEGAxgALIWVjdGlvbmVudC1sZW5ndGhvbnJveHktY29ubmVjdGlvbgBBsMYACytyYW5zZmVyLWVuY29kaW5ncGdyYWRlDQoNClNNDQoNClRUUC9DRS9UU1AvAEHpxgALBQECAAEDAEGAxwALXwQFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFAEHpyAALBQECAAEDAEGAyQALXwQFBQYFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFAEHpygALBAEAAAEAQYHLAAteAgIAAgICAgICAgICAgICAgICAgICAgICAgICAgICAAICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgBB6cwACwUBAgABAwBBgM0AC18EBQAABQUFBQUFBQUFBQUGBQUFBQUFBQUFBQUFAAUABwgFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUABQAFAAUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFAAAABQBB6c4ACwUBAQABAQBBgM8ACwEBAEGazwALQQIAAAAAAAADAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwAAAAAAAAMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAEHp0AALBQEBAAEBAEGA0QALAQEAQYrRAAsGAgAAAAACAEGh0QALOgMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAAAAAAAAAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMAQeDSAAuaAU5PVU5DRUVDS09VVE5FQ1RFVEVDUklCRUxVU0hFVEVBRFNFQVJDSFJHRUNUSVZJVFlMRU5EQVJWRU9USUZZUFRJT05TQ0hTRUFZU1RBVENIR0VVRVJZT1JESVJFQ1RPUlRSQ0hQQVJBTUVURVJVUkNFQlNDUklCRUFSRE9XTkFDRUlORE5LQ0tVQlNDUklCRUhUVFAvQURUUC8=";
    var wasmBuffer;
    Object.defineProperty(module3, "exports", {
      get: /* @__PURE__ */ __name(() => {
        return wasmBuffer ? wasmBuffer : wasmBuffer = Buffer7.from(wasmBase64, "base64");
      }, "get")
    });
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/constants.js
var require_constants3 = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/constants.js"(exports2, module3) {
    init_import_meta_url();
    var corsSafeListedMethods = (
      /** @type {const} */
      ["GET", "HEAD", "POST"]
    );
    var corsSafeListedMethodsSet = new Set(corsSafeListedMethods);
    var nullBodyStatus = (
      /** @type {const} */
      [101, 204, 205, 304]
    );
    var redirectStatus = (
      /** @type {const} */
      [301, 302, 303, 307, 308]
    );
    var redirectStatusSet = new Set(redirectStatus);
    var badPorts = (
      /** @type {const} */
      [
        "1",
        "7",
        "9",
        "11",
        "13",
        "15",
        "17",
        "19",
        "20",
        "21",
        "22",
        "23",
        "25",
        "37",
        "42",
        "43",
        "53",
        "69",
        "77",
        "79",
        "87",
        "95",
        "101",
        "102",
        "103",
        "104",
        "109",
        "110",
        "111",
        "113",
        "115",
        "117",
        "119",
        "123",
        "135",
        "137",
        "139",
        "143",
        "161",
        "179",
        "389",
        "427",
        "465",
        "512",
        "513",
        "514",
        "515",
        "526",
        "530",
        "531",
        "532",
        "540",
        "548",
        "554",
        "556",
        "563",
        "587",
        "601",
        "636",
        "989",
        "990",
        "993",
        "995",
        "1719",
        "1720",
        "1723",
        "2049",
        "3659",
        "4045",
        "4190",
        "5060",
        "5061",
        "6000",
        "6566",
        "6665",
        "6666",
        "6667",
        "6668",
        "6669",
        "6679",
        "6697",
        "10080"
      ]
    );
    var badPortsSet = new Set(badPorts);
    var referrerPolicyTokens = (
      /** @type {const} */
      [
        "no-referrer",
        "no-referrer-when-downgrade",
        "same-origin",
        "origin",
        "strict-origin",
        "origin-when-cross-origin",
        "strict-origin-when-cross-origin",
        "unsafe-url"
      ]
    );
    var referrerPolicy = (
      /** @type {const} */
      [
        "",
        ...referrerPolicyTokens
      ]
    );
    var referrerPolicyTokensSet = new Set(referrerPolicyTokens);
    var requestRedirect = (
      /** @type {const} */
      ["follow", "manual", "error"]
    );
    var safeMethods = (
      /** @type {const} */
      ["GET", "HEAD", "OPTIONS", "TRACE"]
    );
    var safeMethodsSet = new Set(safeMethods);
    var requestMode = (
      /** @type {const} */
      ["navigate", "same-origin", "no-cors", "cors"]
    );
    var requestCredentials = (
      /** @type {const} */
      ["omit", "same-origin", "include"]
    );
    var requestCache = (
      /** @type {const} */
      [
        "default",
        "no-store",
        "reload",
        "no-cache",
        "force-cache",
        "only-if-cached"
      ]
    );
    var requestBodyHeader = (
      /** @type {const} */
      [
        "content-encoding",
        "content-language",
        "content-location",
        "content-type",
        // See https://github.com/nodejs/undici/issues/2021
        // 'Content-Length' is a forbidden header name, which is typically
        // removed in the Headers implementation. However, undici doesn't
        // filter out headers, so we add it here.
        "content-length"
      ]
    );
    var requestDuplex = (
      /** @type {const} */
      [
        "half"
      ]
    );
    var forbiddenMethods = (
      /** @type {const} */
      ["CONNECT", "TRACE", "TRACK"]
    );
    var forbiddenMethodsSet = new Set(forbiddenMethods);
    var subresource = (
      /** @type {const} */
      [
        "audio",
        "audioworklet",
        "font",
        "image",
        "manifest",
        "paintworklet",
        "script",
        "style",
        "track",
        "video",
        "xslt",
        ""
      ]
    );
    var subresourceSet = new Set(subresource);
    module3.exports = {
      subresource,
      forbiddenMethods,
      requestBodyHeader,
      referrerPolicy,
      requestRedirect,
      requestMode,
      requestCredentials,
      requestCache,
      redirectStatus,
      corsSafeListedMethods,
      nullBodyStatus,
      safeMethods,
      badPorts,
      requestDuplex,
      subresourceSet,
      badPortsSet,
      redirectStatusSet,
      corsSafeListedMethodsSet,
      safeMethodsSet,
      forbiddenMethodsSet,
      referrerPolicyTokens: referrerPolicyTokensSet
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/global.js
var require_global = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/global.js"(exports2, module3) {
    init_import_meta_url();
    var globalOrigin = Symbol.for("undici.globalOrigin.1");
    function getGlobalOrigin() {
      return globalThis[globalOrigin];
    }
    __name(getGlobalOrigin, "getGlobalOrigin");
    function setGlobalOrigin(newOrigin) {
      if (newOrigin === void 0) {
        Object.defineProperty(globalThis, globalOrigin, {
          value: void 0,
          writable: true,
          enumerable: false,
          configurable: false
        });
        return;
      }
      const parsedURL = new URL(newOrigin);
      if (parsedURL.protocol !== "http:" && parsedURL.protocol !== "https:") {
        throw new TypeError(`Only http & https urls are allowed, received ${parsedURL.protocol}`);
      }
      Object.defineProperty(globalThis, globalOrigin, {
        value: parsedURL,
        writable: true,
        enumerable: false,
        configurable: false
      });
    }
    __name(setGlobalOrigin, "setGlobalOrigin");
    module3.exports = {
      getGlobalOrigin,
      setGlobalOrigin
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/data-url.js
var require_data_url = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/data-url.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var encoder = new TextEncoder();
    var HTTP_TOKEN_CODEPOINTS = /^[!#$%&'*+\-.^_|~A-Za-z0-9]+$/;
    var HTTP_WHITESPACE_REGEX = /[\u000A\u000D\u0009\u0020]/;
    var ASCII_WHITESPACE_REPLACE_REGEX = /[\u0009\u000A\u000C\u000D\u0020]/g;
    var HTTP_QUOTED_STRING_TOKENS = /^[\u0009\u0020-\u007E\u0080-\u00FF]+$/;
    function dataURLProcessor(dataURL) {
      assert48(dataURL.protocol === "data:");
      let input = URLSerializer(dataURL, true);
      input = input.slice(5);
      const position = { position: 0 };
      let mimeType = collectASequenceOfCodePointsFast(
        ",",
        input,
        position
      );
      const mimeTypeLength = mimeType.length;
      mimeType = removeASCIIWhitespace(mimeType, true, true);
      if (position.position >= input.length) {
        return "failure";
      }
      position.position++;
      const encodedBody = input.slice(mimeTypeLength + 1);
      let body = stringPercentDecode(encodedBody);
      if (/;(\u0020){0,}base64$/i.test(mimeType)) {
        const stringBody = isomorphicDecode(body);
        body = forgivingBase64(stringBody);
        if (body === "failure") {
          return "failure";
        }
        mimeType = mimeType.slice(0, -6);
        mimeType = mimeType.replace(/(\u0020)+$/, "");
        mimeType = mimeType.slice(0, -1);
      }
      if (mimeType.startsWith(";")) {
        mimeType = "text/plain" + mimeType;
      }
      let mimeTypeRecord = parseMIMEType(mimeType);
      if (mimeTypeRecord === "failure") {
        mimeTypeRecord = parseMIMEType("text/plain;charset=US-ASCII");
      }
      return { mimeType: mimeTypeRecord, body };
    }
    __name(dataURLProcessor, "dataURLProcessor");
    function URLSerializer(url4, excludeFragment = false) {
      if (!excludeFragment) {
        return url4.href;
      }
      const href = url4.href;
      const hashLength = url4.hash.length;
      const serialized = hashLength === 0 ? href : href.substring(0, href.length - hashLength);
      if (!hashLength && href.endsWith("#")) {
        return serialized.slice(0, -1);
      }
      return serialized;
    }
    __name(URLSerializer, "URLSerializer");
    function collectASequenceOfCodePoints(condition, input, position) {
      let result = "";
      while (position.position < input.length && condition(input[position.position])) {
        result += input[position.position];
        position.position++;
      }
      return result;
    }
    __name(collectASequenceOfCodePoints, "collectASequenceOfCodePoints");
    function collectASequenceOfCodePointsFast(char, input, position) {
      const idx = input.indexOf(char, position.position);
      const start = position.position;
      if (idx === -1) {
        position.position = input.length;
        return input.slice(start);
      }
      position.position = idx;
      return input.slice(start, position.position);
    }
    __name(collectASequenceOfCodePointsFast, "collectASequenceOfCodePointsFast");
    function stringPercentDecode(input) {
      const bytes = encoder.encode(input);
      return percentDecode(bytes);
    }
    __name(stringPercentDecode, "stringPercentDecode");
    function isHexCharByte(byte) {
      return byte >= 48 && byte <= 57 || byte >= 65 && byte <= 70 || byte >= 97 && byte <= 102;
    }
    __name(isHexCharByte, "isHexCharByte");
    function hexByteToNumber(byte) {
      return (
        // 0-9
        byte >= 48 && byte <= 57 ? byte - 48 : (byte & 223) - 55
      );
    }
    __name(hexByteToNumber, "hexByteToNumber");
    function percentDecode(input) {
      const length = input.length;
      const output = new Uint8Array(length);
      let j7 = 0;
      for (let i6 = 0; i6 < length; ++i6) {
        const byte = input[i6];
        if (byte !== 37) {
          output[j7++] = byte;
        } else if (byte === 37 && !(isHexCharByte(input[i6 + 1]) && isHexCharByte(input[i6 + 2]))) {
          output[j7++] = 37;
        } else {
          output[j7++] = hexByteToNumber(input[i6 + 1]) << 4 | hexByteToNumber(input[i6 + 2]);
          i6 += 2;
        }
      }
      return length === j7 ? output : output.subarray(0, j7);
    }
    __name(percentDecode, "percentDecode");
    function parseMIMEType(input) {
      input = removeHTTPWhitespace(input, true, true);
      const position = { position: 0 };
      const type = collectASequenceOfCodePointsFast(
        "/",
        input,
        position
      );
      if (type.length === 0 || !HTTP_TOKEN_CODEPOINTS.test(type)) {
        return "failure";
      }
      if (position.position >= input.length) {
        return "failure";
      }
      position.position++;
      let subtype = collectASequenceOfCodePointsFast(
        ";",
        input,
        position
      );
      subtype = removeHTTPWhitespace(subtype, false, true);
      if (subtype.length === 0 || !HTTP_TOKEN_CODEPOINTS.test(subtype)) {
        return "failure";
      }
      const typeLowercase = type.toLowerCase();
      const subtypeLowercase = subtype.toLowerCase();
      const mimeType = {
        type: typeLowercase,
        subtype: subtypeLowercase,
        /** @type {Map<string, string>} */
        parameters: /* @__PURE__ */ new Map(),
        // https://mimesniff.spec.whatwg.org/#mime-type-essence
        essence: `${typeLowercase}/${subtypeLowercase}`
      };
      while (position.position < input.length) {
        position.position++;
        collectASequenceOfCodePoints(
          // https://fetch.spec.whatwg.org/#http-whitespace
          (char) => HTTP_WHITESPACE_REGEX.test(char),
          input,
          position
        );
        let parameterName = collectASequenceOfCodePoints(
          (char) => char !== ";" && char !== "=",
          input,
          position
        );
        parameterName = parameterName.toLowerCase();
        if (position.position < input.length) {
          if (input[position.position] === ";") {
            continue;
          }
          position.position++;
        }
        if (position.position >= input.length) {
          break;
        }
        let parameterValue = null;
        if (input[position.position] === '"') {
          parameterValue = collectAnHTTPQuotedString(input, position, true);
          collectASequenceOfCodePointsFast(
            ";",
            input,
            position
          );
        } else {
          parameterValue = collectASequenceOfCodePointsFast(
            ";",
            input,
            position
          );
          parameterValue = removeHTTPWhitespace(parameterValue, false, true);
          if (parameterValue.length === 0) {
            continue;
          }
        }
        if (parameterName.length !== 0 && HTTP_TOKEN_CODEPOINTS.test(parameterName) && (parameterValue.length === 0 || HTTP_QUOTED_STRING_TOKENS.test(parameterValue)) && !mimeType.parameters.has(parameterName)) {
          mimeType.parameters.set(parameterName, parameterValue);
        }
      }
      return mimeType;
    }
    __name(parseMIMEType, "parseMIMEType");
    function forgivingBase64(data) {
      data = data.replace(ASCII_WHITESPACE_REPLACE_REGEX, "");
      let dataLength = data.length;
      if (dataLength % 4 === 0) {
        if (data.charCodeAt(dataLength - 1) === 61) {
          --dataLength;
          if (data.charCodeAt(dataLength - 1) === 61) {
            --dataLength;
          }
        }
      }
      if (dataLength % 4 === 1) {
        return "failure";
      }
      if (/[^+/0-9A-Za-z]/.test(data.length === dataLength ? data : data.substring(0, dataLength))) {
        return "failure";
      }
      const buffer = Buffer.from(data, "base64");
      return new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength);
    }
    __name(forgivingBase64, "forgivingBase64");
    function collectAnHTTPQuotedString(input, position, extractValue3 = false) {
      const positionStart = position.position;
      let value = "";
      assert48(input[position.position] === '"');
      position.position++;
      while (true) {
        value += collectASequenceOfCodePoints(
          (char) => char !== '"' && char !== "\\",
          input,
          position
        );
        if (position.position >= input.length) {
          break;
        }
        const quoteOrBackslash = input[position.position];
        position.position++;
        if (quoteOrBackslash === "\\") {
          if (position.position >= input.length) {
            value += "\\";
            break;
          }
          value += input[position.position];
          position.position++;
        } else {
          assert48(quoteOrBackslash === '"');
          break;
        }
      }
      if (extractValue3) {
        return value;
      }
      return input.slice(positionStart, position.position);
    }
    __name(collectAnHTTPQuotedString, "collectAnHTTPQuotedString");
    function serializeAMimeType(mimeType) {
      assert48(mimeType !== "failure");
      const { parameters, essence } = mimeType;
      let serialization = essence;
      for (let [name2, value] of parameters.entries()) {
        serialization += ";";
        serialization += name2;
        serialization += "=";
        if (!HTTP_TOKEN_CODEPOINTS.test(value)) {
          value = value.replace(/(\\|")/g, "\\$1");
          value = '"' + value;
          value += '"';
        }
        serialization += value;
      }
      return serialization;
    }
    __name(serializeAMimeType, "serializeAMimeType");
    function isHTTPWhiteSpace(char) {
      return char === 13 || char === 10 || char === 9 || char === 32;
    }
    __name(isHTTPWhiteSpace, "isHTTPWhiteSpace");
    function removeHTTPWhitespace(str, leading = true, trailing = true) {
      return removeChars(str, leading, trailing, isHTTPWhiteSpace);
    }
    __name(removeHTTPWhitespace, "removeHTTPWhitespace");
    function isASCIIWhitespace(char) {
      return char === 13 || char === 10 || char === 9 || char === 12 || char === 32;
    }
    __name(isASCIIWhitespace, "isASCIIWhitespace");
    function removeASCIIWhitespace(str, leading = true, trailing = true) {
      return removeChars(str, leading, trailing, isASCIIWhitespace);
    }
    __name(removeASCIIWhitespace, "removeASCIIWhitespace");
    function removeChars(str, leading, trailing, predicate) {
      let lead = 0;
      let trail = str.length - 1;
      if (leading) {
        while (lead < str.length && predicate(str.charCodeAt(lead))) lead++;
      }
      if (trailing) {
        while (trail > 0 && predicate(str.charCodeAt(trail))) trail--;
      }
      return lead === 0 && trail === str.length - 1 ? str : str.slice(lead, trail + 1);
    }
    __name(removeChars, "removeChars");
    function isomorphicDecode(input) {
      const length = input.length;
      if ((2 << 15) - 1 > length) {
        return String.fromCharCode.apply(null, input);
      }
      let result = "";
      let i6 = 0;
      let addition = (2 << 15) - 1;
      while (i6 < length) {
        if (i6 + addition > length) {
          addition = length - i6;
        }
        result += String.fromCharCode.apply(null, input.subarray(i6, i6 += addition));
      }
      return result;
    }
    __name(isomorphicDecode, "isomorphicDecode");
    function minimizeSupportedMimeType(mimeType) {
      switch (mimeType.essence) {
        case "application/ecmascript":
        case "application/javascript":
        case "application/x-ecmascript":
        case "application/x-javascript":
        case "text/ecmascript":
        case "text/javascript":
        case "text/javascript1.0":
        case "text/javascript1.1":
        case "text/javascript1.2":
        case "text/javascript1.3":
        case "text/javascript1.4":
        case "text/javascript1.5":
        case "text/jscript":
        case "text/livescript":
        case "text/x-ecmascript":
        case "text/x-javascript":
          return "text/javascript";
        case "application/json":
        case "text/json":
          return "application/json";
        case "image/svg+xml":
          return "image/svg+xml";
        case "text/xml":
        case "application/xml":
          return "application/xml";
      }
      if (mimeType.subtype.endsWith("+json")) {
        return "application/json";
      }
      if (mimeType.subtype.endsWith("+xml")) {
        return "application/xml";
      }
      return "";
    }
    __name(minimizeSupportedMimeType, "minimizeSupportedMimeType");
    module3.exports = {
      dataURLProcessor,
      URLSerializer,
      collectASequenceOfCodePoints,
      collectASequenceOfCodePointsFast,
      stringPercentDecode,
      parseMIMEType,
      collectAnHTTPQuotedString,
      serializeAMimeType,
      removeChars,
      removeHTTPWhitespace,
      minimizeSupportedMimeType,
      HTTP_TOKEN_CODEPOINTS,
      isomorphicDecode
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/webidl/index.js
var require_webidl = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/webidl/index.js"(exports2, module3) {
    init_import_meta_url();
    var { types: types4, inspect: inspect3 } = __require("util");
    var { markAsUncloneable } = __require("worker_threads");
    var UNDEFINED = 1;
    var BOOLEAN = 2;
    var STRING = 3;
    var SYMBOL = 4;
    var NUMBER = 5;
    var BIGINT = 6;
    var NULL = 7;
    var OBJECT = 8;
    var FunctionPrototypeSymbolHasInstance = Function.call.bind(Function.prototype[Symbol.hasInstance]);
    var webidl = {
      converters: {},
      util: {},
      errors: {},
      is: {}
    };
    webidl.errors.exception = function(message) {
      return new TypeError(`${message.header}: ${message.message}`);
    };
    webidl.errors.conversionFailed = function(opts) {
      const plural2 = opts.types.length === 1 ? "" : " one of";
      const message = `${opts.argument} could not be converted to${plural2}: ${opts.types.join(", ")}.`;
      return webidl.errors.exception({
        header: opts.prefix,
        message
      });
    };
    webidl.errors.invalidArgument = function(context2) {
      return webidl.errors.exception({
        header: context2.prefix,
        message: `"${context2.value}" is an invalid ${context2.type}.`
      });
    };
    webidl.brandCheck = function(V4, I5) {
      if (!FunctionPrototypeSymbolHasInstance(I5, V4)) {
        const err = new TypeError("Illegal invocation");
        err.code = "ERR_INVALID_THIS";
        throw err;
      }
    };
    webidl.brandCheckMultiple = function(List2) {
      const prototypes = List2.map((c7) => webidl.util.MakeTypeAssertion(c7));
      return (V4) => {
        if (prototypes.every((typeCheck) => !typeCheck(V4))) {
          const err = new TypeError("Illegal invocation");
          err.code = "ERR_INVALID_THIS";
          throw err;
        }
      };
    };
    webidl.argumentLengthCheck = function({ length }, min, ctx) {
      if (length < min) {
        throw webidl.errors.exception({
          message: `${min} argument${min !== 1 ? "s" : ""} required, but${length ? " only" : ""} ${length} found.`,
          header: ctx
        });
      }
    };
    webidl.illegalConstructor = function() {
      throw webidl.errors.exception({
        header: "TypeError",
        message: "Illegal constructor"
      });
    };
    webidl.util.MakeTypeAssertion = function(I5) {
      return (O4) => FunctionPrototypeSymbolHasInstance(I5, O4);
    };
    webidl.util.Type = function(V4) {
      switch (typeof V4) {
        case "undefined":
          return UNDEFINED;
        case "boolean":
          return BOOLEAN;
        case "string":
          return STRING;
        case "symbol":
          return SYMBOL;
        case "number":
          return NUMBER;
        case "bigint":
          return BIGINT;
        case "function":
        case "object": {
          if (V4 === null) {
            return NULL;
          }
          return OBJECT;
        }
      }
    };
    webidl.util.Types = {
      UNDEFINED,
      BOOLEAN,
      STRING,
      SYMBOL,
      NUMBER,
      BIGINT,
      NULL,
      OBJECT
    };
    webidl.util.TypeValueToString = function(o6) {
      switch (webidl.util.Type(o6)) {
        case UNDEFINED:
          return "Undefined";
        case BOOLEAN:
          return "Boolean";
        case STRING:
          return "String";
        case SYMBOL:
          return "Symbol";
        case NUMBER:
          return "Number";
        case BIGINT:
          return "BigInt";
        case NULL:
          return "Null";
        case OBJECT:
          return "Object";
      }
    };
    webidl.util.markAsUncloneable = markAsUncloneable || (() => {
    });
    webidl.util.ConvertToInt = function(V4, bitLength, signedness, opts) {
      let upperBound;
      let lowerBound2;
      if (bitLength === 64) {
        upperBound = Math.pow(2, 53) - 1;
        if (signedness === "unsigned") {
          lowerBound2 = 0;
        } else {
          lowerBound2 = Math.pow(-2, 53) + 1;
        }
      } else if (signedness === "unsigned") {
        lowerBound2 = 0;
        upperBound = Math.pow(2, bitLength) - 1;
      } else {
        lowerBound2 = Math.pow(-2, bitLength) - 1;
        upperBound = Math.pow(2, bitLength - 1) - 1;
      }
      let x7 = Number(V4);
      if (x7 === 0) {
        x7 = 0;
      }
      if (opts?.enforceRange === true) {
        if (Number.isNaN(x7) || x7 === Number.POSITIVE_INFINITY || x7 === Number.NEGATIVE_INFINITY) {
          throw webidl.errors.exception({
            header: "Integer conversion",
            message: `Could not convert ${webidl.util.Stringify(V4)} to an integer.`
          });
        }
        x7 = webidl.util.IntegerPart(x7);
        if (x7 < lowerBound2 || x7 > upperBound) {
          throw webidl.errors.exception({
            header: "Integer conversion",
            message: `Value must be between ${lowerBound2}-${upperBound}, got ${x7}.`
          });
        }
        return x7;
      }
      if (!Number.isNaN(x7) && opts?.clamp === true) {
        x7 = Math.min(Math.max(x7, lowerBound2), upperBound);
        if (Math.floor(x7) % 2 === 0) {
          x7 = Math.floor(x7);
        } else {
          x7 = Math.ceil(x7);
        }
        return x7;
      }
      if (Number.isNaN(x7) || x7 === 0 && Object.is(0, x7) || x7 === Number.POSITIVE_INFINITY || x7 === Number.NEGATIVE_INFINITY) {
        return 0;
      }
      x7 = webidl.util.IntegerPart(x7);
      x7 = x7 % Math.pow(2, bitLength);
      if (signedness === "signed" && x7 >= Math.pow(2, bitLength) - 1) {
        return x7 - Math.pow(2, bitLength);
      }
      return x7;
    };
    webidl.util.IntegerPart = function(n7) {
      const r8 = Math.floor(Math.abs(n7));
      if (n7 < 0) {
        return -1 * r8;
      }
      return r8;
    };
    webidl.util.Stringify = function(V4) {
      const type = webidl.util.Type(V4);
      switch (type) {
        case SYMBOL:
          return `Symbol(${V4.description})`;
        case OBJECT:
          return inspect3(V4);
        case STRING:
          return `"${V4}"`;
        case BIGINT:
          return `${V4}n`;
        default:
          return `${V4}`;
      }
    };
    webidl.sequenceConverter = function(converter) {
      return (V4, prefix, argument, Iterable) => {
        if (webidl.util.Type(V4) !== OBJECT) {
          throw webidl.errors.exception({
            header: prefix,
            message: `${argument} (${webidl.util.Stringify(V4)}) is not iterable.`
          });
        }
        const method = typeof Iterable === "function" ? Iterable() : V4?.[Symbol.iterator]?.();
        const seq = [];
        let index = 0;
        if (method === void 0 || typeof method.next !== "function") {
          throw webidl.errors.exception({
            header: prefix,
            message: `${argument} is not iterable.`
          });
        }
        while (true) {
          const { done, value } = method.next();
          if (done) {
            break;
          }
          seq.push(converter(value, prefix, `${argument}[${index++}]`));
        }
        return seq;
      };
    };
    webidl.recordConverter = function(keyConverter, valueConverter) {
      return (O4, prefix, argument) => {
        if (webidl.util.Type(O4) !== OBJECT) {
          throw webidl.errors.exception({
            header: prefix,
            message: `${argument} ("${webidl.util.TypeValueToString(O4)}") is not an Object.`
          });
        }
        const result = {};
        if (!types4.isProxy(O4)) {
          const keys2 = [...Object.getOwnPropertyNames(O4), ...Object.getOwnPropertySymbols(O4)];
          for (const key of keys2) {
            const keyName = webidl.util.Stringify(key);
            const typedKey = keyConverter(key, prefix, `Key ${keyName} in ${argument}`);
            const typedValue = valueConverter(O4[key], prefix, `${argument}[${keyName}]`);
            result[typedKey] = typedValue;
          }
          return result;
        }
        const keys = Reflect.ownKeys(O4);
        for (const key of keys) {
          const desc = Reflect.getOwnPropertyDescriptor(O4, key);
          if (desc?.enumerable) {
            const typedKey = keyConverter(key, prefix, argument);
            const typedValue = valueConverter(O4[key], prefix, argument);
            result[typedKey] = typedValue;
          }
        }
        return result;
      };
    };
    webidl.interfaceConverter = function(TypeCheck, name2) {
      return (V4, prefix, argument) => {
        if (!TypeCheck(V4)) {
          throw webidl.errors.exception({
            header: prefix,
            message: `Expected ${argument} ("${webidl.util.Stringify(V4)}") to be an instance of ${name2}.`
          });
        }
        return V4;
      };
    };
    webidl.dictionaryConverter = function(converters) {
      return (dictionary, prefix, argument) => {
        const dict = {};
        if (dictionary != null && webidl.util.Type(dictionary) !== OBJECT) {
          throw webidl.errors.exception({
            header: prefix,
            message: `Expected ${dictionary} to be one of: Null, Undefined, Object.`
          });
        }
        for (const options of converters) {
          const { key, defaultValue, required, converter } = options;
          if (required === true) {
            if (dictionary == null || !Object.hasOwn(dictionary, key)) {
              throw webidl.errors.exception({
                header: prefix,
                message: `Missing required key "${key}".`
              });
            }
          }
          let value = dictionary?.[key];
          const hasDefault = defaultValue !== void 0;
          if (hasDefault && value === void 0) {
            value = defaultValue();
          }
          if (required || hasDefault || value !== void 0) {
            value = converter(value, prefix, `${argument}.${key}`);
            if (options.allowedValues && !options.allowedValues.includes(value)) {
              throw webidl.errors.exception({
                header: prefix,
                message: `${value} is not an accepted type. Expected one of ${options.allowedValues.join(", ")}.`
              });
            }
            dict[key] = value;
          }
        }
        return dict;
      };
    };
    webidl.nullableConverter = function(converter) {
      return (V4, prefix, argument) => {
        if (V4 === null) {
          return V4;
        }
        return converter(V4, prefix, argument);
      };
    };
    webidl.is.USVString = function(value) {
      return typeof value === "string" && value.isWellFormed();
    };
    webidl.is.ReadableStream = webidl.util.MakeTypeAssertion(ReadableStream);
    webidl.is.Blob = webidl.util.MakeTypeAssertion(Blob);
    webidl.is.URLSearchParams = webidl.util.MakeTypeAssertion(URLSearchParams);
    webidl.is.File = webidl.util.MakeTypeAssertion(File);
    webidl.is.URL = webidl.util.MakeTypeAssertion(URL);
    webidl.is.AbortSignal = webidl.util.MakeTypeAssertion(AbortSignal);
    webidl.is.MessagePort = webidl.util.MakeTypeAssertion(MessagePort);
    webidl.converters.DOMString = function(V4, prefix, argument, opts) {
      if (V4 === null && opts?.legacyNullToEmptyString) {
        return "";
      }
      if (typeof V4 === "symbol") {
        throw webidl.errors.exception({
          header: prefix,
          message: `${argument} is a symbol, which cannot be converted to a DOMString.`
        });
      }
      return String(V4);
    };
    webidl.converters.ByteString = function(V4, prefix, argument) {
      if (typeof V4 === "symbol") {
        throw webidl.errors.exception({
          header: prefix,
          message: `${argument} is a symbol, which cannot be converted to a ByteString.`
        });
      }
      const x7 = String(V4);
      for (let index = 0; index < x7.length; index++) {
        if (x7.charCodeAt(index) > 255) {
          throw new TypeError(
            `Cannot convert argument to a ByteString because the character at index ${index} has a value of ${x7.charCodeAt(index)} which is greater than 255.`
          );
        }
      }
      return x7;
    };
    webidl.converters.USVString = function(value) {
      if (typeof value === "string") {
        return value.toWellFormed();
      }
      return `${value}`.toWellFormed();
    };
    webidl.converters.boolean = function(V4) {
      const x7 = Boolean(V4);
      return x7;
    };
    webidl.converters.any = function(V4) {
      return V4;
    };
    webidl.converters["long long"] = function(V4, prefix, argument) {
      const x7 = webidl.util.ConvertToInt(V4, 64, "signed", void 0, prefix, argument);
      return x7;
    };
    webidl.converters["unsigned long long"] = function(V4, prefix, argument) {
      const x7 = webidl.util.ConvertToInt(V4, 64, "unsigned", void 0, prefix, argument);
      return x7;
    };
    webidl.converters["unsigned long"] = function(V4, prefix, argument) {
      const x7 = webidl.util.ConvertToInt(V4, 32, "unsigned", void 0, prefix, argument);
      return x7;
    };
    webidl.converters["unsigned short"] = function(V4, prefix, argument, opts) {
      const x7 = webidl.util.ConvertToInt(V4, 16, "unsigned", opts, prefix, argument);
      return x7;
    };
    webidl.converters.ArrayBuffer = function(V4, prefix, argument, opts) {
      if (webidl.util.Type(V4) !== OBJECT || !types4.isAnyArrayBuffer(V4)) {
        throw webidl.errors.conversionFailed({
          prefix,
          argument: `${argument} ("${webidl.util.Stringify(V4)}")`,
          types: ["ArrayBuffer"]
        });
      }
      if (opts?.allowShared === false && types4.isSharedArrayBuffer(V4)) {
        throw webidl.errors.exception({
          header: "ArrayBuffer",
          message: "SharedArrayBuffer is not allowed."
        });
      }
      if (V4.resizable || V4.growable) {
        throw webidl.errors.exception({
          header: "ArrayBuffer",
          message: "Received a resizable ArrayBuffer."
        });
      }
      return V4;
    };
    webidl.converters.TypedArray = function(V4, T4, prefix, name2, opts) {
      if (webidl.util.Type(V4) !== OBJECT || !types4.isTypedArray(V4) || V4.constructor.name !== T4.name) {
        throw webidl.errors.conversionFailed({
          prefix,
          argument: `${name2} ("${webidl.util.Stringify(V4)}")`,
          types: [T4.name]
        });
      }
      if (opts?.allowShared === false && types4.isSharedArrayBuffer(V4.buffer)) {
        throw webidl.errors.exception({
          header: "ArrayBuffer",
          message: "SharedArrayBuffer is not allowed."
        });
      }
      if (V4.buffer.resizable || V4.buffer.growable) {
        throw webidl.errors.exception({
          header: "ArrayBuffer",
          message: "Received a resizable ArrayBuffer."
        });
      }
      return V4;
    };
    webidl.converters.DataView = function(V4, prefix, name2, opts) {
      if (webidl.util.Type(V4) !== OBJECT || !types4.isDataView(V4)) {
        throw webidl.errors.exception({
          header: prefix,
          message: `${name2} is not a DataView.`
        });
      }
      if (opts?.allowShared === false && types4.isSharedArrayBuffer(V4.buffer)) {
        throw webidl.errors.exception({
          header: "ArrayBuffer",
          message: "SharedArrayBuffer is not allowed."
        });
      }
      if (V4.buffer.resizable || V4.buffer.growable) {
        throw webidl.errors.exception({
          header: "ArrayBuffer",
          message: "Received a resizable ArrayBuffer."
        });
      }
      return V4;
    };
    webidl.converters["sequence<ByteString>"] = webidl.sequenceConverter(
      webidl.converters.ByteString
    );
    webidl.converters["sequence<sequence<ByteString>>"] = webidl.sequenceConverter(
      webidl.converters["sequence<ByteString>"]
    );
    webidl.converters["record<ByteString, ByteString>"] = webidl.recordConverter(
      webidl.converters.ByteString,
      webidl.converters.ByteString
    );
    webidl.converters.Blob = webidl.interfaceConverter(webidl.is.Blob, "Blob");
    webidl.converters.AbortSignal = webidl.interfaceConverter(
      webidl.is.AbortSignal,
      "AbortSignal"
    );
    module3.exports = {
      webidl
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/util.js
var require_util2 = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/util.js"(exports2, module3) {
    init_import_meta_url();
    var { Transform: Transform2 } = __require("stream");
    var zlib3 = __require("zlib");
    var { redirectStatusSet, referrerPolicyTokens, badPortsSet } = require_constants3();
    var { getGlobalOrigin } = require_global();
    var { collectASequenceOfCodePoints, collectAnHTTPQuotedString, removeChars, parseMIMEType } = require_data_url();
    var { performance: performance2 } = __require("perf_hooks");
    var { ReadableStreamFrom, isValidHTTPToken, normalizedMethodRecordsBase } = require_util();
    var assert48 = __require("assert");
    var { isUint8Array } = __require("util/types");
    var { webidl } = require_webidl();
    var supportedHashes = [];
    var crypto8;
    try {
      crypto8 = __require("crypto");
      const possibleRelevantHashes = ["sha256", "sha384", "sha512"];
      supportedHashes = crypto8.getHashes().filter((hash) => possibleRelevantHashes.includes(hash));
    } catch {
    }
    function responseURL(response) {
      const urlList = response.urlList;
      const length = urlList.length;
      return length === 0 ? null : urlList[length - 1].toString();
    }
    __name(responseURL, "responseURL");
    function responseLocationURL(response, requestFragment) {
      if (!redirectStatusSet.has(response.status)) {
        return null;
      }
      let location = response.headersList.get("location", true);
      if (location !== null && isValidHeaderValue(location)) {
        if (!isValidEncodedURL(location)) {
          location = normalizeBinaryStringToUtf8(location);
        }
        location = new URL(location, responseURL(response));
      }
      if (location && !location.hash) {
        location.hash = requestFragment;
      }
      return location;
    }
    __name(responseLocationURL, "responseLocationURL");
    function isValidEncodedURL(url4) {
      for (let i6 = 0; i6 < url4.length; ++i6) {
        const code = url4.charCodeAt(i6);
        if (code > 126 || // Non-US-ASCII + DEL
        code < 32) {
          return false;
        }
      }
      return true;
    }
    __name(isValidEncodedURL, "isValidEncodedURL");
    function normalizeBinaryStringToUtf8(value) {
      return Buffer.from(value, "binary").toString("utf8");
    }
    __name(normalizeBinaryStringToUtf8, "normalizeBinaryStringToUtf8");
    function requestCurrentURL(request4) {
      return request4.urlList[request4.urlList.length - 1];
    }
    __name(requestCurrentURL, "requestCurrentURL");
    function requestBadPort(request4) {
      const url4 = requestCurrentURL(request4);
      if (urlIsHttpHttpsScheme(url4) && badPortsSet.has(url4.port)) {
        return "blocked";
      }
      return "allowed";
    }
    __name(requestBadPort, "requestBadPort");
    function isErrorLike(object) {
      return object instanceof Error || (object?.constructor?.name === "Error" || object?.constructor?.name === "DOMException");
    }
    __name(isErrorLike, "isErrorLike");
    function isValidReasonPhrase(statusText) {
      for (let i6 = 0; i6 < statusText.length; ++i6) {
        const c7 = statusText.charCodeAt(i6);
        if (!(c7 === 9 || // HTAB
        c7 >= 32 && c7 <= 126 || // SP / VCHAR
        c7 >= 128 && c7 <= 255)) {
          return false;
        }
      }
      return true;
    }
    __name(isValidReasonPhrase, "isValidReasonPhrase");
    var isValidHeaderName = isValidHTTPToken;
    function isValidHeaderValue(potentialValue) {
      return (potentialValue[0] === "	" || potentialValue[0] === " " || potentialValue[potentialValue.length - 1] === "	" || potentialValue[potentialValue.length - 1] === " " || potentialValue.includes("\n") || potentialValue.includes("\r") || potentialValue.includes("\0")) === false;
    }
    __name(isValidHeaderValue, "isValidHeaderValue");
    function parseReferrerPolicy(actualResponse) {
      const policyHeader = (actualResponse.headersList.get("referrer-policy", true) ?? "").split(",");
      let policy = "";
      if (policyHeader.length) {
        for (let i6 = policyHeader.length; i6 !== 0; i6--) {
          const token = policyHeader[i6 - 1].trim();
          if (referrerPolicyTokens.has(token)) {
            policy = token;
            break;
          }
        }
      }
      return policy;
    }
    __name(parseReferrerPolicy, "parseReferrerPolicy");
    function setRequestReferrerPolicyOnRedirect(request4, actualResponse) {
      const policy = parseReferrerPolicy(actualResponse);
      if (policy !== "") {
        request4.referrerPolicy = policy;
      }
    }
    __name(setRequestReferrerPolicyOnRedirect, "setRequestReferrerPolicyOnRedirect");
    function crossOriginResourcePolicyCheck() {
      return "allowed";
    }
    __name(crossOriginResourcePolicyCheck, "crossOriginResourcePolicyCheck");
    function corsCheck() {
      return "success";
    }
    __name(corsCheck, "corsCheck");
    function TAOCheck() {
      return "success";
    }
    __name(TAOCheck, "TAOCheck");
    function appendFetchMetadata(httpRequest2) {
      let header = null;
      header = httpRequest2.mode;
      httpRequest2.headersList.set("sec-fetch-mode", header, true);
    }
    __name(appendFetchMetadata, "appendFetchMetadata");
    function appendRequestOriginHeader(request4) {
      let serializedOrigin = request4.origin;
      if (serializedOrigin === "client" || serializedOrigin === void 0) {
        return;
      }
      if (request4.responseTainting === "cors" || request4.mode === "websocket") {
        request4.headersList.append("origin", serializedOrigin, true);
      } else if (request4.method !== "GET" && request4.method !== "HEAD") {
        switch (request4.referrerPolicy) {
          case "no-referrer":
            serializedOrigin = null;
            break;
          case "no-referrer-when-downgrade":
          case "strict-origin":
          case "strict-origin-when-cross-origin":
            if (request4.origin && urlHasHttpsScheme(request4.origin) && !urlHasHttpsScheme(requestCurrentURL(request4))) {
              serializedOrigin = null;
            }
            break;
          case "same-origin":
            if (!sameOrigin(request4, requestCurrentURL(request4))) {
              serializedOrigin = null;
            }
            break;
        }
        request4.headersList.append("origin", serializedOrigin, true);
      }
    }
    __name(appendRequestOriginHeader, "appendRequestOriginHeader");
    function coarsenTime(timestamp, crossOriginIsolatedCapability) {
      return timestamp;
    }
    __name(coarsenTime, "coarsenTime");
    function clampAndCoarsenConnectionTimingInfo(connectionTimingInfo, defaultStartTime, crossOriginIsolatedCapability) {
      if (!connectionTimingInfo?.startTime || connectionTimingInfo.startTime < defaultStartTime) {
        return {
          domainLookupStartTime: defaultStartTime,
          domainLookupEndTime: defaultStartTime,
          connectionStartTime: defaultStartTime,
          connectionEndTime: defaultStartTime,
          secureConnectionStartTime: defaultStartTime,
          ALPNNegotiatedProtocol: connectionTimingInfo?.ALPNNegotiatedProtocol
        };
      }
      return {
        domainLookupStartTime: coarsenTime(connectionTimingInfo.domainLookupStartTime),
        domainLookupEndTime: coarsenTime(connectionTimingInfo.domainLookupEndTime),
        connectionStartTime: coarsenTime(connectionTimingInfo.connectionStartTime),
        connectionEndTime: coarsenTime(connectionTimingInfo.connectionEndTime),
        secureConnectionStartTime: coarsenTime(connectionTimingInfo.secureConnectionStartTime),
        ALPNNegotiatedProtocol: connectionTimingInfo.ALPNNegotiatedProtocol
      };
    }
    __name(clampAndCoarsenConnectionTimingInfo, "clampAndCoarsenConnectionTimingInfo");
    function coarsenedSharedCurrentTime(crossOriginIsolatedCapability) {
      return coarsenTime(performance2.now());
    }
    __name(coarsenedSharedCurrentTime, "coarsenedSharedCurrentTime");
    function createOpaqueTimingInfo(timingInfo) {
      return {
        startTime: timingInfo.startTime ?? 0,
        redirectStartTime: 0,
        redirectEndTime: 0,
        postRedirectStartTime: timingInfo.startTime ?? 0,
        finalServiceWorkerStartTime: 0,
        finalNetworkResponseStartTime: 0,
        finalNetworkRequestStartTime: 0,
        endTime: 0,
        encodedBodySize: 0,
        decodedBodySize: 0,
        finalConnectionTimingInfo: null
      };
    }
    __name(createOpaqueTimingInfo, "createOpaqueTimingInfo");
    function makePolicyContainer() {
      return {
        referrerPolicy: "strict-origin-when-cross-origin"
      };
    }
    __name(makePolicyContainer, "makePolicyContainer");
    function clonePolicyContainer(policyContainer) {
      return {
        referrerPolicy: policyContainer.referrerPolicy
      };
    }
    __name(clonePolicyContainer, "clonePolicyContainer");
    function determineRequestsReferrer(request4) {
      const policy = request4.referrerPolicy;
      assert48(policy);
      let referrerSource = null;
      if (request4.referrer === "client") {
        const globalOrigin = getGlobalOrigin();
        if (!globalOrigin || globalOrigin.origin === "null") {
          return "no-referrer";
        }
        referrerSource = new URL(globalOrigin);
      } else if (webidl.is.URL(request4.referrer)) {
        referrerSource = request4.referrer;
      }
      let referrerURL = stripURLForReferrer(referrerSource);
      const referrerOrigin = stripURLForReferrer(referrerSource, true);
      if (referrerURL.toString().length > 4096) {
        referrerURL = referrerOrigin;
      }
      switch (policy) {
        case "no-referrer":
          return "no-referrer";
        case "origin":
          if (referrerOrigin != null) {
            return referrerOrigin;
          }
          return stripURLForReferrer(referrerSource, true);
        case "unsafe-url":
          return referrerURL;
        case "strict-origin": {
          const currentURL = requestCurrentURL(request4);
          if (isURLPotentiallyTrustworthy(referrerURL) && !isURLPotentiallyTrustworthy(currentURL)) {
            return "no-referrer";
          }
          return referrerOrigin;
        }
        case "strict-origin-when-cross-origin": {
          const currentURL = requestCurrentURL(request4);
          if (sameOrigin(referrerURL, currentURL)) {
            return referrerURL;
          }
          if (isURLPotentiallyTrustworthy(referrerURL) && !isURLPotentiallyTrustworthy(currentURL)) {
            return "no-referrer";
          }
          return referrerOrigin;
        }
        case "same-origin":
          if (sameOrigin(request4, referrerURL)) {
            return referrerURL;
          }
          return "no-referrer";
        case "origin-when-cross-origin":
          if (sameOrigin(request4, referrerURL)) {
            return referrerURL;
          }
          return referrerOrigin;
        case "no-referrer-when-downgrade": {
          const currentURL = requestCurrentURL(request4);
          if (isURLPotentiallyTrustworthy(referrerURL) && !isURLPotentiallyTrustworthy(currentURL)) {
            return "no-referrer";
          }
          return referrerOrigin;
        }
      }
    }
    __name(determineRequestsReferrer, "determineRequestsReferrer");
    function stripURLForReferrer(url4, originOnly = false) {
      assert48(webidl.is.URL(url4));
      url4 = new URL(url4);
      if (urlIsLocal(url4)) {
        return "no-referrer";
      }
      url4.username = "";
      url4.password = "";
      url4.hash = "";
      if (originOnly === true) {
        url4.pathname = "";
        url4.search = "";
      }
      return url4;
    }
    __name(stripURLForReferrer, "stripURLForReferrer");
    var potentialleTrustworthyIPv4RegExp = new RegExp("^(?:(?:127\\.)(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\\.){2}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[1-9]))$");
    var potentialleTrustworthyIPv6RegExp = new RegExp("^(?:(?:(?:0{1,4}):){7}(?:(?:0{0,3}1))|(?:(?:0{1,4}):){1,6}(?::(?:0{0,3}1))|(?:::(?:0{0,3}1))|)$");
    function isOriginIPPotentiallyTrustworthy(origin) {
      if (origin.includes(":")) {
        if (origin[0] === "[" && origin[origin.length - 1] === "]") {
          origin = origin.slice(1, -1);
        }
        return potentialleTrustworthyIPv6RegExp.test(origin);
      }
      return potentialleTrustworthyIPv4RegExp.test(origin);
    }
    __name(isOriginIPPotentiallyTrustworthy, "isOriginIPPotentiallyTrustworthy");
    function isOriginPotentiallyTrustworthy(origin) {
      if (origin == null || origin === "null") {
        return false;
      }
      origin = new URL(origin);
      if (origin.protocol === "https:" || origin.protocol === "wss:") {
        return true;
      }
      if (isOriginIPPotentiallyTrustworthy(origin.hostname)) {
        return true;
      }
      if (origin.hostname === "localhost" || origin.hostname === "localhost.") {
        return true;
      }
      if (origin.hostname.endsWith(".localhost") || origin.hostname.endsWith(".localhost.")) {
        return true;
      }
      if (origin.protocol === "file:") {
        return true;
      }
      return false;
    }
    __name(isOriginPotentiallyTrustworthy, "isOriginPotentiallyTrustworthy");
    function isURLPotentiallyTrustworthy(url4) {
      if (!webidl.is.URL(url4)) {
        return false;
      }
      if (url4.href === "about:blank" || url4.href === "about:srcdoc") {
        return true;
      }
      if (url4.protocol === "data:") return true;
      if (url4.protocol === "blob:") return true;
      return isOriginPotentiallyTrustworthy(url4.origin);
    }
    __name(isURLPotentiallyTrustworthy, "isURLPotentiallyTrustworthy");
    function bytesMatch(bytes, metadataList) {
      if (crypto8 === void 0) {
        return true;
      }
      const parsedMetadata = parseMetadata(metadataList);
      if (parsedMetadata === "no metadata") {
        return true;
      }
      if (parsedMetadata.length === 0) {
        return true;
      }
      const strongest = getStrongestMetadata(parsedMetadata);
      const metadata = filterMetadataListByAlgorithm(parsedMetadata, strongest);
      for (const item of metadata) {
        const algorithm = item.algo;
        const expectedValue = item.hash;
        let actualValue = crypto8.createHash(algorithm).update(bytes).digest("base64");
        if (actualValue[actualValue.length - 1] === "=") {
          if (actualValue[actualValue.length - 2] === "=") {
            actualValue = actualValue.slice(0, -2);
          } else {
            actualValue = actualValue.slice(0, -1);
          }
        }
        if (compareBase64Mixed(actualValue, expectedValue)) {
          return true;
        }
      }
      return false;
    }
    __name(bytesMatch, "bytesMatch");
    var parseHashWithOptions = /(?<algo>sha256|sha384|sha512)-((?<hash>[A-Za-z0-9+/]+|[A-Za-z0-9_-]+)={0,2}(?:\s|$)( +[!-~]*)?)?/i;
    function parseMetadata(metadata) {
      const result = [];
      let empty = true;
      for (const token of metadata.split(" ")) {
        empty = false;
        const parsedToken = parseHashWithOptions.exec(token);
        if (parsedToken === null || parsedToken.groups === void 0 || parsedToken.groups.algo === void 0) {
          continue;
        }
        const algorithm = parsedToken.groups.algo.toLowerCase();
        if (supportedHashes.includes(algorithm)) {
          result.push(parsedToken.groups);
        }
      }
      if (empty === true) {
        return "no metadata";
      }
      return result;
    }
    __name(parseMetadata, "parseMetadata");
    function getStrongestMetadata(metadataList) {
      let algorithm = metadataList[0].algo;
      if (algorithm[3] === "5") {
        return algorithm;
      }
      for (let i6 = 1; i6 < metadataList.length; ++i6) {
        const metadata = metadataList[i6];
        if (metadata.algo[3] === "5") {
          algorithm = "sha512";
          break;
        } else if (algorithm[3] === "3") {
          continue;
        } else if (metadata.algo[3] === "3") {
          algorithm = "sha384";
        }
      }
      return algorithm;
    }
    __name(getStrongestMetadata, "getStrongestMetadata");
    function filterMetadataListByAlgorithm(metadataList, algorithm) {
      if (metadataList.length === 1) {
        return metadataList;
      }
      let pos = 0;
      for (let i6 = 0; i6 < metadataList.length; ++i6) {
        if (metadataList[i6].algo === algorithm) {
          metadataList[pos++] = metadataList[i6];
        }
      }
      metadataList.length = pos;
      return metadataList;
    }
    __name(filterMetadataListByAlgorithm, "filterMetadataListByAlgorithm");
    function compareBase64Mixed(actualValue, expectedValue) {
      if (actualValue.length !== expectedValue.length) {
        return false;
      }
      for (let i6 = 0; i6 < actualValue.length; ++i6) {
        if (actualValue[i6] !== expectedValue[i6]) {
          if (actualValue[i6] === "+" && expectedValue[i6] === "-" || actualValue[i6] === "/" && expectedValue[i6] === "_") {
            continue;
          }
          return false;
        }
      }
      return true;
    }
    __name(compareBase64Mixed, "compareBase64Mixed");
    function tryUpgradeRequestToAPotentiallyTrustworthyURL(request4) {
    }
    __name(tryUpgradeRequestToAPotentiallyTrustworthyURL, "tryUpgradeRequestToAPotentiallyTrustworthyURL");
    function sameOrigin(A4, B4) {
      if (A4.origin === B4.origin && A4.origin === "null") {
        return true;
      }
      if (A4.protocol === B4.protocol && A4.hostname === B4.hostname && A4.port === B4.port) {
        return true;
      }
      return false;
    }
    __name(sameOrigin, "sameOrigin");
    function isAborted2(fetchParams) {
      return fetchParams.controller.state === "aborted";
    }
    __name(isAborted2, "isAborted");
    function isCancelled(fetchParams) {
      return fetchParams.controller.state === "aborted" || fetchParams.controller.state === "terminated";
    }
    __name(isCancelled, "isCancelled");
    function normalizeMethod(method) {
      return normalizedMethodRecordsBase[method.toLowerCase()] ?? method;
    }
    __name(normalizeMethod, "normalizeMethod");
    function serializeJavascriptValueToJSONString(value) {
      const result = JSON.stringify(value);
      if (result === void 0) {
        throw new TypeError("Value is not JSON serializable");
      }
      assert48(typeof result === "string");
      return result;
    }
    __name(serializeJavascriptValueToJSONString, "serializeJavascriptValueToJSONString");
    var esIteratorPrototype = Object.getPrototypeOf(Object.getPrototypeOf([][Symbol.iterator]()));
    function createIterator(name2, kInternalIterator, keyIndex = 0, valueIndex = 1) {
      class FastIterableIterator {
        static {
          __name(this, "FastIterableIterator");
        }
        /** @type {any} */
        #target;
        /** @type {'key' | 'value' | 'key+value'} */
        #kind;
        /** @type {number} */
        #index;
        /**
         * @see https://webidl.spec.whatwg.org/#dfn-default-iterator-object
         * @param {unknown} target
         * @param {'key' | 'value' | 'key+value'} kind
         */
        constructor(target, kind2) {
          this.#target = target;
          this.#kind = kind2;
          this.#index = 0;
        }
        next() {
          if (typeof this !== "object" || this === null || !(#target in this)) {
            throw new TypeError(
              `'next' called on an object that does not implement interface ${name2} Iterator.`
            );
          }
          const index = this.#index;
          const values = kInternalIterator(this.#target);
          const len = values.length;
          if (index >= len) {
            return {
              value: void 0,
              done: true
            };
          }
          const { [keyIndex]: key, [valueIndex]: value } = values[index];
          this.#index = index + 1;
          let result;
          switch (this.#kind) {
            case "key":
              result = key;
              break;
            case "value":
              result = value;
              break;
            case "key+value":
              result = [key, value];
              break;
          }
          return {
            value: result,
            done: false
          };
        }
      }
      delete FastIterableIterator.prototype.constructor;
      Object.setPrototypeOf(FastIterableIterator.prototype, esIteratorPrototype);
      Object.defineProperties(FastIterableIterator.prototype, {
        [Symbol.toStringTag]: {
          writable: false,
          enumerable: false,
          configurable: true,
          value: `${name2} Iterator`
        },
        next: { writable: true, enumerable: true, configurable: true }
      });
      return function(target, kind2) {
        return new FastIterableIterator(target, kind2);
      };
    }
    __name(createIterator, "createIterator");
    function iteratorMixin(name2, object, kInternalIterator, keyIndex = 0, valueIndex = 1) {
      const makeIterator = createIterator(name2, kInternalIterator, keyIndex, valueIndex);
      const properties = {
        keys: {
          writable: true,
          enumerable: true,
          configurable: true,
          value: /* @__PURE__ */ __name(function keys() {
            webidl.brandCheck(this, object);
            return makeIterator(this, "key");
          }, "keys")
        },
        values: {
          writable: true,
          enumerable: true,
          configurable: true,
          value: /* @__PURE__ */ __name(function values() {
            webidl.brandCheck(this, object);
            return makeIterator(this, "value");
          }, "values")
        },
        entries: {
          writable: true,
          enumerable: true,
          configurable: true,
          value: /* @__PURE__ */ __name(function entries2() {
            webidl.brandCheck(this, object);
            return makeIterator(this, "key+value");
          }, "entries")
        },
        forEach: {
          writable: true,
          enumerable: true,
          configurable: true,
          value: /* @__PURE__ */ __name(function forEach(callbackfn, thisArg = globalThis) {
            webidl.brandCheck(this, object);
            webidl.argumentLengthCheck(arguments, 1, `${name2}.forEach`);
            if (typeof callbackfn !== "function") {
              throw new TypeError(
                `Failed to execute 'forEach' on '${name2}': parameter 1 is not of type 'Function'.`
              );
            }
            for (const { 0: key, 1: value } of makeIterator(this, "key+value")) {
              callbackfn.call(thisArg, value, key, this);
            }
          }, "forEach")
        }
      };
      return Object.defineProperties(object.prototype, {
        ...properties,
        [Symbol.iterator]: {
          writable: true,
          enumerable: false,
          configurable: true,
          value: properties.entries.value
        }
      });
    }
    __name(iteratorMixin, "iteratorMixin");
    function fullyReadBody(body, processBody, processBodyError) {
      const successSteps = processBody;
      const errorSteps = processBodyError;
      try {
        const reader = body.stream.getReader();
        readAllBytes(reader, successSteps, errorSteps);
      } catch (e8) {
        errorSteps(e8);
      }
    }
    __name(fullyReadBody, "fullyReadBody");
    function readableStreamClose(controller) {
      try {
        controller.close();
        controller.byobRequest?.respond(0);
      } catch (err) {
        if (!err.message.includes("Controller is already closed") && !err.message.includes("ReadableStream is already closed")) {
          throw err;
        }
      }
    }
    __name(readableStreamClose, "readableStreamClose");
    var invalidIsomorphicEncodeValueRegex = /[^\x00-\xFF]/;
    function isomorphicEncode(input) {
      assert48(!invalidIsomorphicEncodeValueRegex.test(input));
      return input;
    }
    __name(isomorphicEncode, "isomorphicEncode");
    async function readAllBytes(reader, successSteps, failureSteps) {
      try {
        const bytes = [];
        let byteLength = 0;
        do {
          const { done, value: chunk } = await reader.read();
          if (done) {
            successSteps(Buffer.concat(bytes, byteLength));
            return;
          }
          if (!isUint8Array(chunk)) {
            failureSteps(new TypeError("Received non-Uint8Array chunk"));
            return;
          }
          bytes.push(chunk);
          byteLength += chunk.length;
        } while (true);
      } catch (e8) {
        failureSteps(e8);
      }
    }
    __name(readAllBytes, "readAllBytes");
    function urlIsLocal(url4) {
      assert48("protocol" in url4);
      const protocol = url4.protocol;
      return protocol === "about:" || protocol === "blob:" || protocol === "data:";
    }
    __name(urlIsLocal, "urlIsLocal");
    function urlHasHttpsScheme(url4) {
      return typeof url4 === "string" && url4[5] === ":" && url4[0] === "h" && url4[1] === "t" && url4[2] === "t" && url4[3] === "p" && url4[4] === "s" || url4.protocol === "https:";
    }
    __name(urlHasHttpsScheme, "urlHasHttpsScheme");
    function urlIsHttpHttpsScheme(url4) {
      assert48("protocol" in url4);
      const protocol = url4.protocol;
      return protocol === "http:" || protocol === "https:";
    }
    __name(urlIsHttpHttpsScheme, "urlIsHttpHttpsScheme");
    function simpleRangeHeaderValue(value, allowWhitespace) {
      const data = value;
      if (!data.startsWith("bytes")) {
        return "failure";
      }
      const position = { position: 5 };
      if (allowWhitespace) {
        collectASequenceOfCodePoints(
          (char) => char === "	" || char === " ",
          data,
          position
        );
      }
      if (data.charCodeAt(position.position) !== 61) {
        return "failure";
      }
      position.position++;
      if (allowWhitespace) {
        collectASequenceOfCodePoints(
          (char) => char === "	" || char === " ",
          data,
          position
        );
      }
      const rangeStart = collectASequenceOfCodePoints(
        (char) => {
          const code = char.charCodeAt(0);
          return code >= 48 && code <= 57;
        },
        data,
        position
      );
      const rangeStartValue = rangeStart.length ? Number(rangeStart) : null;
      if (allowWhitespace) {
        collectASequenceOfCodePoints(
          (char) => char === "	" || char === " ",
          data,
          position
        );
      }
      if (data.charCodeAt(position.position) !== 45) {
        return "failure";
      }
      position.position++;
      if (allowWhitespace) {
        collectASequenceOfCodePoints(
          (char) => char === "	" || char === " ",
          data,
          position
        );
      }
      const rangeEnd = collectASequenceOfCodePoints(
        (char) => {
          const code = char.charCodeAt(0);
          return code >= 48 && code <= 57;
        },
        data,
        position
      );
      const rangeEndValue = rangeEnd.length ? Number(rangeEnd) : null;
      if (position.position < data.length) {
        return "failure";
      }
      if (rangeEndValue === null && rangeStartValue === null) {
        return "failure";
      }
      if (rangeStartValue > rangeEndValue) {
        return "failure";
      }
      return { rangeStartValue, rangeEndValue };
    }
    __name(simpleRangeHeaderValue, "simpleRangeHeaderValue");
    function buildContentRange(rangeStart, rangeEnd, fullLength) {
      let contentRange = "bytes ";
      contentRange += isomorphicEncode(`${rangeStart}`);
      contentRange += "-";
      contentRange += isomorphicEncode(`${rangeEnd}`);
      contentRange += "/";
      contentRange += isomorphicEncode(`${fullLength}`);
      return contentRange;
    }
    __name(buildContentRange, "buildContentRange");
    var InflateStream = class extends Transform2 {
      static {
        __name(this, "InflateStream");
      }
      #zlibOptions;
      /** @param {zlib.ZlibOptions} [zlibOptions] */
      constructor(zlibOptions) {
        super();
        this.#zlibOptions = zlibOptions;
      }
      _transform(chunk, encoding, callback) {
        if (!this._inflateStream) {
          if (chunk.length === 0) {
            callback();
            return;
          }
          this._inflateStream = (chunk[0] & 15) === 8 ? zlib3.createInflate(this.#zlibOptions) : zlib3.createInflateRaw(this.#zlibOptions);
          this._inflateStream.on("data", this.push.bind(this));
          this._inflateStream.on("end", () => this.push(null));
          this._inflateStream.on("error", (err) => this.destroy(err));
        }
        this._inflateStream.write(chunk, encoding, callback);
      }
      _final(callback) {
        if (this._inflateStream) {
          this._inflateStream.end();
          this._inflateStream = null;
        }
        callback();
      }
    };
    function createInflate(zlibOptions) {
      return new InflateStream(zlibOptions);
    }
    __name(createInflate, "createInflate");
    function extractMimeType(headers) {
      let charset = null;
      let essence = null;
      let mimeType = null;
      const values = getDecodeSplit("content-type", headers);
      if (values === null) {
        return "failure";
      }
      for (const value of values) {
        const temporaryMimeType = parseMIMEType(value);
        if (temporaryMimeType === "failure" || temporaryMimeType.essence === "*/*") {
          continue;
        }
        mimeType = temporaryMimeType;
        if (mimeType.essence !== essence) {
          charset = null;
          if (mimeType.parameters.has("charset")) {
            charset = mimeType.parameters.get("charset");
          }
          essence = mimeType.essence;
        } else if (!mimeType.parameters.has("charset") && charset !== null) {
          mimeType.parameters.set("charset", charset);
        }
      }
      if (mimeType == null) {
        return "failure";
      }
      return mimeType;
    }
    __name(extractMimeType, "extractMimeType");
    function gettingDecodingSplitting(value) {
      const input = value;
      const position = { position: 0 };
      const values = [];
      let temporaryValue = "";
      while (position.position < input.length) {
        temporaryValue += collectASequenceOfCodePoints(
          (char) => char !== '"' && char !== ",",
          input,
          position
        );
        if (position.position < input.length) {
          if (input.charCodeAt(position.position) === 34) {
            temporaryValue += collectAnHTTPQuotedString(
              input,
              position
            );
            if (position.position < input.length) {
              continue;
            }
          } else {
            assert48(input.charCodeAt(position.position) === 44);
            position.position++;
          }
        }
        temporaryValue = removeChars(temporaryValue, true, true, (char) => char === 9 || char === 32);
        values.push(temporaryValue);
        temporaryValue = "";
      }
      return values;
    }
    __name(gettingDecodingSplitting, "gettingDecodingSplitting");
    function getDecodeSplit(name2, list) {
      const value = list.get(name2, true);
      if (value === null) {
        return null;
      }
      return gettingDecodingSplitting(value);
    }
    __name(getDecodeSplit, "getDecodeSplit");
    var textDecoder = new TextDecoder();
    function utf8DecodeBytes(buffer) {
      if (buffer.length === 0) {
        return "";
      }
      if (buffer[0] === 239 && buffer[1] === 187 && buffer[2] === 191) {
        buffer = buffer.subarray(3);
      }
      const output = textDecoder.decode(buffer);
      return output;
    }
    __name(utf8DecodeBytes, "utf8DecodeBytes");
    var EnvironmentSettingsObjectBase = class {
      static {
        __name(this, "EnvironmentSettingsObjectBase");
      }
      get baseUrl() {
        return getGlobalOrigin();
      }
      get origin() {
        return this.baseUrl?.origin;
      }
      policyContainer = makePolicyContainer();
    };
    var EnvironmentSettingsObject = class {
      static {
        __name(this, "EnvironmentSettingsObject");
      }
      settingsObject = new EnvironmentSettingsObjectBase();
    };
    var environmentSettingsObject = new EnvironmentSettingsObject();
    module3.exports = {
      isAborted: isAborted2,
      isCancelled,
      isValidEncodedURL,
      ReadableStreamFrom,
      tryUpgradeRequestToAPotentiallyTrustworthyURL,
      clampAndCoarsenConnectionTimingInfo,
      coarsenedSharedCurrentTime,
      determineRequestsReferrer,
      makePolicyContainer,
      clonePolicyContainer,
      appendFetchMetadata,
      appendRequestOriginHeader,
      TAOCheck,
      corsCheck,
      crossOriginResourcePolicyCheck,
      createOpaqueTimingInfo,
      setRequestReferrerPolicyOnRedirect,
      isValidHTTPToken,
      requestBadPort,
      requestCurrentURL,
      responseURL,
      responseLocationURL,
      isURLPotentiallyTrustworthy,
      isValidReasonPhrase,
      sameOrigin,
      normalizeMethod,
      serializeJavascriptValueToJSONString,
      iteratorMixin,
      createIterator,
      isValidHeaderName,
      isValidHeaderValue,
      isErrorLike,
      fullyReadBody,
      bytesMatch,
      readableStreamClose,
      isomorphicEncode,
      urlIsLocal,
      urlHasHttpsScheme,
      urlIsHttpHttpsScheme,
      readAllBytes,
      simpleRangeHeaderValue,
      buildContentRange,
      parseMetadata,
      createInflate,
      extractMimeType,
      getDecodeSplit,
      utf8DecodeBytes,
      environmentSettingsObject,
      isOriginIPPotentiallyTrustworthy
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/formdata.js
var require_formdata = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/formdata.js"(exports2, module3) {
    init_import_meta_url();
    var { iteratorMixin } = require_util2();
    var { kEnumerableProperty } = require_util();
    var { webidl } = require_webidl();
    var nodeUtil = __require("util");
    var FormData13 = class _FormData {
      static {
        __name(this, "FormData");
      }
      #state = [];
      constructor(form = void 0) {
        webidl.util.markAsUncloneable(this);
        if (form !== void 0) {
          throw webidl.errors.conversionFailed({
            prefix: "FormData constructor",
            argument: "Argument 1",
            types: ["undefined"]
          });
        }
      }
      append(name2, value, filename = void 0) {
        webidl.brandCheck(this, _FormData);
        const prefix = "FormData.append";
        webidl.argumentLengthCheck(arguments, 2, prefix);
        name2 = webidl.converters.USVString(name2);
        if (arguments.length === 3 || webidl.is.Blob(value)) {
          value = webidl.converters.Blob(value, prefix, "value");
          if (filename !== void 0) {
            filename = webidl.converters.USVString(filename);
          }
        } else {
          value = webidl.converters.USVString(value);
        }
        const entry = makeEntry(name2, value, filename);
        this.#state.push(entry);
      }
      delete(name2) {
        webidl.brandCheck(this, _FormData);
        const prefix = "FormData.delete";
        webidl.argumentLengthCheck(arguments, 1, prefix);
        name2 = webidl.converters.USVString(name2);
        this.#state = this.#state.filter((entry) => entry.name !== name2);
      }
      get(name2) {
        webidl.brandCheck(this, _FormData);
        const prefix = "FormData.get";
        webidl.argumentLengthCheck(arguments, 1, prefix);
        name2 = webidl.converters.USVString(name2);
        const idx = this.#state.findIndex((entry) => entry.name === name2);
        if (idx === -1) {
          return null;
        }
        return this.#state[idx].value;
      }
      getAll(name2) {
        webidl.brandCheck(this, _FormData);
        const prefix = "FormData.getAll";
        webidl.argumentLengthCheck(arguments, 1, prefix);
        name2 = webidl.converters.USVString(name2);
        return this.#state.filter((entry) => entry.name === name2).map((entry) => entry.value);
      }
      has(name2) {
        webidl.brandCheck(this, _FormData);
        const prefix = "FormData.has";
        webidl.argumentLengthCheck(arguments, 1, prefix);
        name2 = webidl.converters.USVString(name2);
        return this.#state.findIndex((entry) => entry.name === name2) !== -1;
      }
      set(name2, value, filename = void 0) {
        webidl.brandCheck(this, _FormData);
        const prefix = "FormData.set";
        webidl.argumentLengthCheck(arguments, 2, prefix);
        name2 = webidl.converters.USVString(name2);
        if (arguments.length === 3 || webidl.is.Blob(value)) {
          value = webidl.converters.Blob(value, prefix, "value");
          if (filename !== void 0) {
            filename = webidl.converters.USVString(filename);
          }
        } else {
          value = webidl.converters.USVString(value);
        }
        const entry = makeEntry(name2, value, filename);
        const idx = this.#state.findIndex((entry2) => entry2.name === name2);
        if (idx !== -1) {
          this.#state = [
            ...this.#state.slice(0, idx),
            entry,
            ...this.#state.slice(idx + 1).filter((entry2) => entry2.name !== name2)
          ];
        } else {
          this.#state.push(entry);
        }
      }
      [nodeUtil.inspect.custom](depth, options) {
        const state2 = this.#state.reduce((a6, b7) => {
          if (a6[b7.name]) {
            if (Array.isArray(a6[b7.name])) {
              a6[b7.name].push(b7.value);
            } else {
              a6[b7.name] = [a6[b7.name], b7.value];
            }
          } else {
            a6[b7.name] = b7.value;
          }
          return a6;
        }, { __proto__: null });
        options.depth ??= depth;
        options.colors ??= true;
        const output = nodeUtil.formatWithOptions(options, state2);
        return `FormData ${output.slice(output.indexOf("]") + 2)}`;
      }
      /**
       * @param {FormData} formData
       */
      static getFormDataState(formData) {
        return formData.#state;
      }
      /**
       * @param {FormData} formData
       * @param {any[]} newState
       */
      static setFormDataState(formData, newState) {
        formData.#state = newState;
      }
    };
    var { getFormDataState, setFormDataState } = FormData13;
    Reflect.deleteProperty(FormData13, "getFormDataState");
    Reflect.deleteProperty(FormData13, "setFormDataState");
    iteratorMixin("FormData", FormData13, getFormDataState, "name", "value");
    Object.defineProperties(FormData13.prototype, {
      append: kEnumerableProperty,
      delete: kEnumerableProperty,
      get: kEnumerableProperty,
      getAll: kEnumerableProperty,
      has: kEnumerableProperty,
      set: kEnumerableProperty,
      [Symbol.toStringTag]: {
        value: "FormData",
        configurable: true
      }
    });
    function makeEntry(name2, value, filename) {
      if (typeof value === "string") ; else {
        if (!webidl.is.File(value)) {
          value = new File([value], "blob", { type: value.type });
        }
        if (filename !== void 0) {
          const options = {
            type: value.type,
            lastModified: value.lastModified
          };
          value = new File([value], filename, options);
        }
      }
      return { name: name2, value };
    }
    __name(makeEntry, "makeEntry");
    webidl.is.FormData = webidl.util.MakeTypeAssertion(FormData13);
    module3.exports = { FormData: FormData13, makeEntry, setFormDataState };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/formdata-parser.js
var require_formdata_parser = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/formdata-parser.js"(exports2, module3) {
    init_import_meta_url();
    var { bufferToLowerCasedHeaderName } = require_util();
    var { utf8DecodeBytes } = require_util2();
    var { HTTP_TOKEN_CODEPOINTS, isomorphicDecode } = require_data_url();
    var { makeEntry } = require_formdata();
    var { webidl } = require_webidl();
    var assert48 = __require("assert");
    var formDataNameBuffer = Buffer.from('form-data; name="');
    var filenameBuffer = Buffer.from("filename");
    var dd = Buffer.from("--");
    var ddcrlf = Buffer.from("--\r\n");
    function isAsciiString(chars) {
      for (let i6 = 0; i6 < chars.length; ++i6) {
        if ((chars.charCodeAt(i6) & -128) !== 0) {
          return false;
        }
      }
      return true;
    }
    __name(isAsciiString, "isAsciiString");
    function validateBoundary(boundary) {
      const length = boundary.length;
      if (length < 27 || length > 70) {
        return false;
      }
      for (let i6 = 0; i6 < length; ++i6) {
        const cp3 = boundary.charCodeAt(i6);
        if (!(cp3 >= 48 && cp3 <= 57 || cp3 >= 65 && cp3 <= 90 || cp3 >= 97 && cp3 <= 122 || cp3 === 39 || cp3 === 45 || cp3 === 95)) {
          return false;
        }
      }
      return true;
    }
    __name(validateBoundary, "validateBoundary");
    function multipartFormDataParser(input, mimeType) {
      assert48(mimeType !== "failure" && mimeType.essence === "multipart/form-data");
      const boundaryString = mimeType.parameters.get("boundary");
      if (boundaryString === void 0) {
        throw parsingError("missing boundary in content-type header");
      }
      const boundary = Buffer.from(`--${boundaryString}`, "utf8");
      const entryList = [];
      const position = { position: 0 };
      while (input[position.position] === 13 && input[position.position + 1] === 10) {
        position.position += 2;
      }
      let trailing = input.length;
      while (input[trailing - 1] === 10 && input[trailing - 2] === 13) {
        trailing -= 2;
      }
      if (trailing !== input.length) {
        input = input.subarray(0, trailing);
      }
      while (true) {
        if (input.subarray(position.position, position.position + boundary.length).equals(boundary)) {
          position.position += boundary.length;
        } else {
          throw parsingError("expected a value starting with -- and the boundary");
        }
        if (position.position === input.length - 2 && bufferStartsWith(input, dd, position) || position.position === input.length - 4 && bufferStartsWith(input, ddcrlf, position)) {
          return entryList;
        }
        if (input[position.position] !== 13 || input[position.position + 1] !== 10) {
          throw parsingError("expected CRLF");
        }
        position.position += 2;
        const result = parseMultipartFormDataHeaders(input, position);
        let { name: name2, filename, contentType, encoding } = result;
        position.position += 2;
        let body;
        {
          const boundaryIndex = input.indexOf(boundary.subarray(2), position.position);
          if (boundaryIndex === -1) {
            throw parsingError("expected boundary after body");
          }
          body = input.subarray(position.position, boundaryIndex - 4);
          position.position += body.length;
          if (encoding === "base64") {
            body = Buffer.from(body.toString(), "base64");
          }
        }
        if (input[position.position] !== 13 || input[position.position + 1] !== 10) {
          throw parsingError("expected CRLF");
        } else {
          position.position += 2;
        }
        let value;
        if (filename !== null) {
          contentType ??= "text/plain";
          if (!isAsciiString(contentType)) {
            contentType = "";
          }
          value = new File([body], filename, { type: contentType });
        } else {
          value = utf8DecodeBytes(Buffer.from(body));
        }
        assert48(webidl.is.USVString(name2));
        assert48(typeof value === "string" && webidl.is.USVString(value) || webidl.is.File(value));
        entryList.push(makeEntry(name2, value, filename));
      }
    }
    __name(multipartFormDataParser, "multipartFormDataParser");
    function parseMultipartFormDataHeaders(input, position) {
      let name2 = null;
      let filename = null;
      let contentType = null;
      let encoding = null;
      while (true) {
        if (input[position.position] === 13 && input[position.position + 1] === 10) {
          if (name2 === null) {
            throw parsingError("header name is null");
          }
          return { name: name2, filename, contentType, encoding };
        }
        let headerName = collectASequenceOfBytes(
          (char) => char !== 10 && char !== 13 && char !== 58,
          input,
          position
        );
        headerName = removeChars(headerName, true, true, (char) => char === 9 || char === 32);
        if (!HTTP_TOKEN_CODEPOINTS.test(headerName.toString())) {
          throw parsingError("header name does not match the field-name token production");
        }
        if (input[position.position] !== 58) {
          throw parsingError("expected :");
        }
        position.position++;
        collectASequenceOfBytes(
          (char) => char === 32 || char === 9,
          input,
          position
        );
        switch (bufferToLowerCasedHeaderName(headerName)) {
          case "content-disposition": {
            name2 = filename = null;
            if (!bufferStartsWith(input, formDataNameBuffer, position)) {
              throw parsingError('expected form-data; name=" for content-disposition header');
            }
            position.position += 17;
            name2 = parseMultipartFormDataName(input, position);
            if (input[position.position] === 59 && input[position.position + 1] === 32) {
              const at3 = { position: position.position + 2 };
              if (bufferStartsWith(input, filenameBuffer, at3)) {
                if (input[at3.position + 8] === 42) {
                  at3.position += 10;
                  collectASequenceOfBytes(
                    (char) => char === 32 || char === 9,
                    input,
                    at3
                  );
                  const headerValue = collectASequenceOfBytes(
                    (char) => char !== 32 && char !== 13 && char !== 10,
                    // ' ' or CRLF
                    input,
                    at3
                  );
                  if (headerValue[0] !== 117 && headerValue[0] !== 85 || // u or U
                  headerValue[1] !== 116 && headerValue[1] !== 84 || // t or T
                  headerValue[2] !== 102 && headerValue[2] !== 70 || // f or F
                  headerValue[3] !== 45 || // -
                  headerValue[4] !== 56) {
                    throw parsingError("unknown encoding, expected utf-8''");
                  }
                  filename = decodeURIComponent(new TextDecoder().decode(headerValue.subarray(7)));
                  position.position = at3.position;
                } else {
                  position.position += 11;
                  collectASequenceOfBytes(
                    (char) => char === 32 || char === 9,
                    input,
                    position
                  );
                  position.position++;
                  filename = parseMultipartFormDataName(input, position);
                }
              }
            }
            break;
          }
          case "content-type": {
            let headerValue = collectASequenceOfBytes(
              (char) => char !== 10 && char !== 13,
              input,
              position
            );
            headerValue = removeChars(headerValue, false, true, (char) => char === 9 || char === 32);
            contentType = isomorphicDecode(headerValue);
            break;
          }
          case "content-transfer-encoding": {
            let headerValue = collectASequenceOfBytes(
              (char) => char !== 10 && char !== 13,
              input,
              position
            );
            headerValue = removeChars(headerValue, false, true, (char) => char === 9 || char === 32);
            encoding = isomorphicDecode(headerValue);
            break;
          }
          default: {
            collectASequenceOfBytes(
              (char) => char !== 10 && char !== 13,
              input,
              position
            );
          }
        }
        if (input[position.position] !== 13 && input[position.position + 1] !== 10) {
          throw parsingError("expected CRLF");
        } else {
          position.position += 2;
        }
      }
    }
    __name(parseMultipartFormDataHeaders, "parseMultipartFormDataHeaders");
    function parseMultipartFormDataName(input, position) {
      assert48(input[position.position - 1] === 34);
      let name2 = collectASequenceOfBytes(
        (char) => char !== 10 && char !== 13 && char !== 34,
        input,
        position
      );
      if (input[position.position] !== 34) {
        throw parsingError('expected "');
      } else {
        position.position++;
      }
      name2 = new TextDecoder().decode(name2).replace(/%0A/ig, "\n").replace(/%0D/ig, "\r").replace(/%22/g, '"');
      return name2;
    }
    __name(parseMultipartFormDataName, "parseMultipartFormDataName");
    function collectASequenceOfBytes(condition, input, position) {
      let start = position.position;
      while (start < input.length && condition(input[start])) {
        ++start;
      }
      return input.subarray(position.position, position.position = start);
    }
    __name(collectASequenceOfBytes, "collectASequenceOfBytes");
    function removeChars(buf, leading, trailing, predicate) {
      let lead = 0;
      let trail = buf.length - 1;
      if (leading) {
        while (lead < buf.length && predicate(buf[lead])) lead++;
      }
      if (trailing) {
        while (trail > 0 && predicate(buf[trail])) trail--;
      }
      return lead === 0 && trail === buf.length - 1 ? buf : buf.subarray(lead, trail + 1);
    }
    __name(removeChars, "removeChars");
    function bufferStartsWith(buffer, start, position) {
      if (buffer.length < start.length) {
        return false;
      }
      for (let i6 = 0; i6 < start.length; i6++) {
        if (start[i6] !== buffer[position.position + i6]) {
          return false;
        }
      }
      return true;
    }
    __name(bufferStartsWith, "bufferStartsWith");
    function parsingError(cause) {
      return new TypeError("Failed to parse body as FormData.", { cause: new TypeError(cause) });
    }
    __name(parsingError, "parsingError");
    module3.exports = {
      multipartFormDataParser,
      validateBoundary
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/util/promise.js
var require_promise = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/util/promise.js"(exports2, module3) {
    init_import_meta_url();
    function createDeferredPromise() {
      let res;
      let rej;
      const promise = new Promise((resolve28, reject) => {
        res = resolve28;
        rej = reject;
      });
      return { promise, resolve: res, reject: rej };
    }
    __name(createDeferredPromise, "createDeferredPromise");
    module3.exports = {
      createDeferredPromise
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/body.js
var require_body = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/web/fetch/body.js"(exports2, module3) {
    init_import_meta_url();
    var util3 = require_util();
    var {
      ReadableStreamFrom,
      readableStreamClose,
      fullyReadBody,
      extractMimeType,
      utf8DecodeBytes
    } = require_util2();
    var { FormData: FormData13, setFormDataState } = require_formdata();
    var { webidl } = require_webidl();
    var assert48 = __require("assert");
    var { isErrored, isDisturbed } = __require("stream");
    var { isArrayBuffer: isArrayBuffer3 } = __require("util/types");
    var { serializeAMimeType } = require_data_url();
    var { multipartFormDataParser } = require_formdata_parser();
    var { createDeferredPromise } = require_promise();
    var random;
    try {
      const crypto8 = __require("crypto");
      random = /* @__PURE__ */ __name((max) => crypto8.randomInt(0, max), "random");
    } catch {
      random = /* @__PURE__ */ __name((max) => Math.floor(Math.random() * max), "random");
    }
    var textEncoder = new TextEncoder();
    function noop() {
    }
    __name(noop, "noop");
    var streamRegistry = new FinalizationRegistry((weakRef) => {
      const stream2 = weakRef.deref();
      if (stream2 && !stream2.locked && !isDisturbed(stream2) && !isErrored(stream2)) {
        stream2.cancel("Response object has been garbage collected").catch(noop);
      }
    });
    function extractBody(object, keepalive = false) {
      let stream2 = null;
      if (webidl.is.ReadableStream(object)) {
        stream2 = object;
      } else if (webidl.is.Blob(object)) {
        stream2 = object.stream();
      } else {
        stream2 = new ReadableStream({
          async pull(controller) {
            const buffer = typeof source === "string" ? textEncoder.encode(source) : source;
            if (buffer.byteLength) {
              controller.enqueue(buffer);
            }
            queueMicrotask(() => readableStreamClose(controller));
          },
          start() {
          },
          type: "bytes"
        });
      }
      assert48(webidl.is.ReadableStream(stream2));
      let action = null;
      let source = null;
      let length = null;
      let type = null;
      if (typeof object === "string") {
        source = object;
        type = "text/plain;charset=UTF-8";
      } else if (webidl.is.URLSearchParams(object)) {
        source = object.toString();
        type = "application/x-www-form-urlencoded;charset=UTF-8";
      } else if (isArrayBuffer3(object)) {
        source = new Uint8Array(object.slice());
      } else if (ArrayBuffer.isView(object)) {
        source = new Uint8Array(object.buffer.slice(object.byteOffset, object.byteOffset + object.byteLength));
      } else if (webidl.is.FormData(object)) {
        const boundary = `----formdata-undici-0${`${random(1e11)}`.padStart(11, "0")}`;
        const prefix = `--${boundary}\r
Content-Disposition: form-data`;
        const escape3 = /* @__PURE__ */ __name((str) => str.replace(/\n/g, "%0A").replace(/\r/g, "%0D").replace(/"/g, "%22"), "escape");
        const normalizeLinefeeds = /* @__PURE__ */ __name((value) => value.replace(/\r?\n|\r/g, "\r\n"), "normalizeLinefeeds");
        const blobParts = [];
        const rn = new Uint8Array([13, 10]);
        length = 0;
        let hasUnknownSizeValue = false;
        for (const [name2, value] of object) {
          if (typeof value === "string") {
            const chunk2 = textEncoder.encode(prefix + `; name="${escape3(normalizeLinefeeds(name2))}"\r
\r
${normalizeLinefeeds(value)}\r
`);
            blobParts.push(chunk2);
            length += chunk2.byteLength;
          } else {
            const chunk2 = textEncoder.encode(`${prefix}; name="${escape3(normalizeLinefeeds(name2))}"` + (value.name ? `; filename="${escape3(value.name)}"` : "") + `\r
Content-Type: ${value.type || "application/octet-stream"}\r
\r
`);
            blobParts.push(chunk2, value, rn);
            if (typeof value.size === "number") {
              length += chunk2.byteLength + value.size + rn.byteLength;
            } else {
              hasUnknownSizeValue = true;
            }
          }
        }
        const chunk = textEncoder.encode(`--${boundary}--\r
`);
        blobParts.push(chunk);
        length += chunk.byteLength;
        if (hasUnknownSizeValue) {
          length = null;
        }
        source = object;
        action = /* @__PURE__ */ __name(async function* () {
          for (const part of blobParts) {
            if (part.stream) {
              yield* part.stream();
            } else {
              yield part;
            }
          }
        }, "action");
        type = `multipart/form-data; boundary=${boundary}`;
      } else if (webidl.is.Blob(object)) {
        source = object;
        length = object.size;
        if (object.type) {
          type = object.type;
        }
      } else if (typeof object[Symbol.asyncIterator] === "function") {
        if (keepalive) {
          throw new TypeError("keepalive");
        }
        if (util3.isDisturbed(object) || object.locked) {
          throw new TypeError(
            "Response body object should not be disturbed or locked"
          );
        }
        stream2 = webidl.is.ReadableStream(object) ? object : ReadableStreamFrom(object);
      }
      if (typeof source === "string" || util3.isBuffer(source)) {
        length = Buffer.byteLength(source);
      }
      if (action != null) {
        let iterator;
        stream2 = new ReadableStream({
          async start() {
            iterator = action(object)[Symbol.asyncIterator]();
          },
          async pull(controller) {
            const { value, done } = await iterator.next();
            if (done) {
              queueMicrotask(() => {
                controller.close();
                controller.byobRequest?.respond(0);
              });
            } else {
              if (!isErrored(stream2)) {
                const buffer = new Uint8Array(value);
                if (buffer.byteLength) {
                  controller.enqueue(buffer);
                }
              }
            }
            return controller.desiredSize > 0;
          },
          async cancel(reason) {
            await iterator.return();
          },
          type: "bytes"
        });
      }
      const body = { stream: stream2, source, length };
      return [body, type];
    }
    __name(extractBody, "extractBody");
    function safelyExtractBody(object, keepalive = false) {
      if (webidl.is.ReadableStream(object)) {
        assert48(!util3.isDisturbed(object), "The body has already been consumed.");
        assert48(!object.locked, "The stream is locked.");
      }
      return extractBody(object, keepalive);
    }
    __name(safelyExtractBody, "safelyExtractBody");
    function cloneBody(body) {
      const { 0: out1, 1: out2 } = body.stream.tee();
      body.stream = out1;
      return {
        stream: out2,
        length: body.length,
        source: body.source
      };
    }
    __name(cloneBody, "cloneBody");
    function throwIfAborted(state2) {
      if (state2.aborted) {
        throw new DOMException("The operation was aborted.", "AbortError");
      }
    }
    __name(throwIfAborted, "throwIfAborted");
    function bodyMixinMethods(instance, getInternalState) {
      const methods = {
        blob() {
          return consumeBody2(this, (bytes) => {
            let mimeType = bodyMimeType(getInternalState(this));
            if (mimeType === null) {
              mimeType = "";
            } else if (mimeType) {
              mimeType = serializeAMimeType(mimeType);
            }
            return new Blob([bytes], { type: mimeType });
          }, instance, getInternalState);
        },
        arrayBuffer() {
          return consumeBody2(this, (bytes) => {
            return new Uint8Array(bytes).buffer;
          }, instance, getInternalState);
        },
        text() {
          return consumeBody2(this, utf8DecodeBytes, instance, getInternalState);
        },
        json() {
          return consumeBody2(this, parseJSONFromBytes, instance, getInternalState);
        },
        formData() {
          return consumeBody2(this, (value) => {
            const mimeType = bodyMimeType(getInternalState(this));
            if (mimeType !== null) {
              switch (mimeType.essence) {
                case "multipart/form-data": {
                  const parsed = multipartFormDataParser(value, mimeType);
                  const fd = new FormData13();
                  setFormDataState(fd, parsed);
                  return fd;
                }
                case "application/x-www-form-urlencoded": {
                  const entries2 = new URLSearchParams(value.toString());
                  const fd = new FormData13();
                  for (const [name2, value2] of entries2) {
                    fd.append(name2, value2);
                  }
                  return fd;
                }
              }
            }
            throw new TypeError(
              'Content-Type was not one of "multipart/form-data" or "application/x-www-form-urlencoded".'
            );
          }, instance, getInternalState);
        },
        bytes() {
          return consumeBody2(this, (bytes) => {
            return new Uint8Array(bytes);
          }, instance, getInternalState);
        }
      };
      return methods;
    }
    __name(bodyMixinMethods, "bodyMixinMethods");
    function mixinBody(prototype, getInternalState) {
      Object.assign(prototype.prototype, bodyMixinMethods(prototype, getInternalState));
    }
    __name(mixinBody, "mixinBody");
    async function consumeBody2(object, convertBytesToJSValue, instance, getInternalState) {
      webidl.brandCheck(object, instance);
      const state2 = getInternalState(object);
      if (bodyUnusable(state2)) {
        throw new TypeError("Body is unusable: Body has already been read");
      }
      throwIfAborted(state2);
      const promise = createDeferredPromise();
      const errorSteps = /* @__PURE__ */ __name((error2) => promise.reject(error2), "errorSteps");
      const successSteps = /* @__PURE__ */ __name((data) => {
        try {
          promise.resolve(convertBytesToJSValue(data));
        } catch (e8) {
          errorSteps(e8);
        }
      }, "successSteps");
      if (state2.body == null) {
        successSteps(Buffer.allocUnsafe(0));
        return promise.promise;
      }
      fullyReadBody(state2.body, successSteps, errorSteps);
      return promise.promise;
    }
    __name(consumeBody2, "consumeBody");
    function bodyUnusable(object) {
      const body = object.body;
      return body != null && (body.stream.locked || util3.isDisturbed(body.stream));
    }
    __name(bodyUnusable, "bodyUnusable");
    function parseJSONFromBytes(bytes) {
      return JSON.parse(utf8DecodeBytes(bytes));
    }
    __name(parseJSONFromBytes, "parseJSONFromBytes");
    function bodyMimeType(requestOrResponse) {
      const headers = requestOrResponse.headersList;
      const mimeType = extractMimeType(headers);
      if (mimeType === "failure") {
        return null;
      }
      return mimeType;
    }
    __name(bodyMimeType, "bodyMimeType");
    module3.exports = {
      extractBody,
      safelyExtractBody,
      cloneBody,
      mixinBody,
      streamRegistry,
      bodyUnusable
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/client-h1.js
var require_client_h1 = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/client-h1.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var util3 = require_util();
    var { channels } = require_diagnostics();
    var timers = require_timers();
    var {
      RequestContentLengthMismatchError,
      ResponseContentLengthMismatchError,
      RequestAbortedError,
      HeadersTimeoutError,
      HeadersOverflowError,
      SocketError,
      InformationalError,
      BodyTimeoutError,
      HTTPParserError,
      ResponseExceededMaxSizeError
    } = require_errors();
    var {
      kUrl,
      kReset: kReset2,
      kClient,
      kParser,
      kBlocking,
      kRunning,
      kPending,
      kSize,
      kWriting,
      kQueue,
      kNoRef,
      kKeepAliveDefaultTimeout,
      kHostHeader,
      kPendingIdx,
      kRunningIdx,
      kError,
      kPipelining,
      kSocket,
      kKeepAliveTimeoutValue,
      kMaxHeadersSize,
      kKeepAliveMaxTimeout,
      kKeepAliveTimeoutThreshold,
      kHeadersTimeout,
      kBodyTimeout,
      kStrictContentLength,
      kMaxRequests,
      kCounter,
      kMaxResponseSize,
      kOnError,
      kResume,
      kHTTPContext,
      kClosed
    } = require_symbols();
    var constants4 = require_constants2();
    var EMPTY_BUF = Buffer.alloc(0);
    var FastBuffer = Buffer[Symbol.species];
    var removeAllListeners = util3.removeAllListeners;
    var extractBody;
    function lazyllhttp() {
      const llhttpWasmData = process.env.JEST_WORKER_ID ? require_llhttp_wasm() : void 0;
      let mod;
      try {
        mod = new WebAssembly.Module(require_llhttp_simd_wasm());
      } catch (e8) {
        mod = new WebAssembly.Module(llhttpWasmData || require_llhttp_wasm());
      }
      return new WebAssembly.Instance(mod, {
        env: {
          /**
           * @param {number} p
           * @param {number} at
           * @param {number} len
           * @returns {number}
           */
          wasm_on_url: /* @__PURE__ */ __name((p7, at3, len) => {
            return 0;
          }, "wasm_on_url"),
          /**
           * @param {number} p
           * @param {number} at
           * @param {number} len
           * @returns {number}
           */
          wasm_on_status: /* @__PURE__ */ __name((p7, at3, len) => {
            assert48(currentParser.ptr === p7);
            const start = at3 - currentBufferPtr + currentBufferRef.byteOffset;
            return currentParser.onStatus(new FastBuffer(currentBufferRef.buffer, start, len));
          }, "wasm_on_status"),
          /**
           * @param {number} p
           * @returns {number}
           */
          wasm_on_message_begin: /* @__PURE__ */ __name((p7) => {
            assert48(currentParser.ptr === p7);
            return currentParser.onMessageBegin();
          }, "wasm_on_message_begin"),
          /**
           * @param {number} p
           * @param {number} at
           * @param {number} len
           * @returns {number}
           */
          wasm_on_header_field: /* @__PURE__ */ __name((p7, at3, len) => {
            assert48(currentParser.ptr === p7);
            const start = at3 - currentBufferPtr + currentBufferRef.byteOffset;
            return currentParser.onHeaderField(new FastBuffer(currentBufferRef.buffer, start, len));
          }, "wasm_on_header_field"),
          /**
           * @param {number} p
           * @param {number} at
           * @param {number} len
           * @returns {number}
           */
          wasm_on_header_value: /* @__PURE__ */ __name((p7, at3, len) => {
            assert48(currentParser.ptr === p7);
            const start = at3 - currentBufferPtr + currentBufferRef.byteOffset;
            return currentParser.onHeaderValue(new FastBuffer(currentBufferRef.buffer, start, len));
          }, "wasm_on_header_value"),
          /**
           * @param {number} p
           * @param {number} statusCode
           * @param {0|1} upgrade
           * @param {0|1} shouldKeepAlive
           * @returns {number}
           */
          wasm_on_headers_complete: /* @__PURE__ */ __name((p7, statusCode, upgrade, shouldKeepAlive) => {
            assert48(currentParser.ptr === p7);
            return currentParser.onHeadersComplete(statusCode, upgrade === 1, shouldKeepAlive === 1);
          }, "wasm_on_headers_complete"),
          /**
           * @param {number} p
           * @param {number} at
           * @param {number} len
           * @returns {number}
           */
          wasm_on_body: /* @__PURE__ */ __name((p7, at3, len) => {
            assert48(currentParser.ptr === p7);
            const start = at3 - currentBufferPtr + currentBufferRef.byteOffset;
            return currentParser.onBody(new FastBuffer(currentBufferRef.buffer, start, len));
          }, "wasm_on_body"),
          /**
           * @param {number} p
           * @returns {number}
           */
          wasm_on_message_complete: /* @__PURE__ */ __name((p7) => {
            assert48(currentParser.ptr === p7);
            return currentParser.onMessageComplete();
          }, "wasm_on_message_complete")
        }
      });
    }
    __name(lazyllhttp, "lazyllhttp");
    var llhttpInstance = null;
    var currentParser = null;
    var currentBufferRef = null;
    var currentBufferSize = 0;
    var currentBufferPtr = null;
    var USE_NATIVE_TIMER = 0;
    var USE_FAST_TIMER = 1;
    var TIMEOUT_HEADERS = 2 | USE_FAST_TIMER;
    var TIMEOUT_BODY = 4 | USE_FAST_TIMER;
    var TIMEOUT_KEEP_ALIVE = 8 | USE_NATIVE_TIMER;
    var Parser2 = class {
      static {
        __name(this, "Parser");
      }
      /**
         * @param {import('./client.js')} client
         * @param {import('net').Socket} socket
         * @param {*} llhttp
         */
      constructor(client, socket, { exports: exports3 }) {
        this.llhttp = exports3;
        this.ptr = this.llhttp.llhttp_alloc(constants4.TYPE.RESPONSE);
        this.client = client;
        this.socket = socket;
        this.timeout = null;
        this.timeoutValue = null;
        this.timeoutType = null;
        this.statusCode = 0;
        this.statusText = "";
        this.upgrade = false;
        this.headers = [];
        this.headersSize = 0;
        this.headersMaxSize = client[kMaxHeadersSize];
        this.shouldKeepAlive = false;
        this.paused = false;
        this.resume = this.resume.bind(this);
        this.bytesRead = 0;
        this.keepAlive = "";
        this.contentLength = "";
        this.connection = "";
        this.maxResponseSize = client[kMaxResponseSize];
      }
      setTimeout(delay, type) {
        if (delay !== this.timeoutValue || type & USE_FAST_TIMER ^ this.timeoutType & USE_FAST_TIMER) {
          if (this.timeout) {
            timers.clearTimeout(this.timeout);
            this.timeout = null;
          }
          if (delay) {
            if (type & USE_FAST_TIMER) {
              this.timeout = timers.setFastTimeout(onParserTimeout, delay, new WeakRef(this));
            } else {
              this.timeout = setTimeout(onParserTimeout, delay, new WeakRef(this));
              this.timeout?.unref();
            }
          }
          this.timeoutValue = delay;
        } else if (this.timeout) {
          if (this.timeout.refresh) {
            this.timeout.refresh();
          }
        }
        this.timeoutType = type;
      }
      resume() {
        if (this.socket.destroyed || !this.paused) {
          return;
        }
        assert48(this.ptr != null);
        assert48(currentParser === null);
        this.llhttp.llhttp_resume(this.ptr);
        assert48(this.timeoutType === TIMEOUT_BODY);
        if (this.timeout) {
          if (this.timeout.refresh) {
            this.timeout.refresh();
          }
        }
        this.paused = false;
        this.execute(this.socket.read() || EMPTY_BUF);
        this.readMore();
      }
      readMore() {
        while (!this.paused && this.ptr) {
          const chunk = this.socket.read();
          if (chunk === null) {
            break;
          }
          this.execute(chunk);
        }
      }
      /**
       * @param {Buffer} chunk
       */
      execute(chunk) {
        assert48(currentParser === null);
        assert48(this.ptr != null);
        assert48(!this.paused);
        const { socket, llhttp } = this;
        if (chunk.length > currentBufferSize) {
          if (currentBufferPtr) {
            llhttp.free(currentBufferPtr);
          }
          currentBufferSize = Math.ceil(chunk.length / 4096) * 4096;
          currentBufferPtr = llhttp.malloc(currentBufferSize);
        }
        new Uint8Array(llhttp.memory.buffer, currentBufferPtr, currentBufferSize).set(chunk);
        try {
          let ret;
          try {
            currentBufferRef = chunk;
            currentParser = this;
            ret = llhttp.llhttp_execute(this.ptr, currentBufferPtr, chunk.length);
          } catch (err) {
            throw err;
          } finally {
            currentParser = null;
            currentBufferRef = null;
          }
          if (ret !== constants4.ERROR.OK) {
            const data = chunk.subarray(llhttp.llhttp_get_error_pos(this.ptr) - currentBufferPtr);
            if (ret === constants4.ERROR.PAUSED_UPGRADE) {
              this.onUpgrade(data);
            } else if (ret === constants4.ERROR.PAUSED) {
              this.paused = true;
              socket.unshift(data);
            } else {
              const ptr = llhttp.llhttp_get_error_reason(this.ptr);
              let message = "";
              if (ptr) {
                const len = new Uint8Array(llhttp.memory.buffer, ptr).indexOf(0);
                message = "Response does not match the HTTP/1.1 protocol (" + Buffer.from(llhttp.memory.buffer, ptr, len).toString() + ")";
              }
              throw new HTTPParserError(message, constants4.ERROR[ret], data);
            }
          }
        } catch (err) {
          util3.destroy(socket, err);
        }
      }
      destroy() {
        assert48(currentParser === null);
        assert48(this.ptr != null);
        this.llhttp.llhttp_free(this.ptr);
        this.ptr = null;
        this.timeout && timers.clearTimeout(this.timeout);
        this.timeout = null;
        this.timeoutValue = null;
        this.timeoutType = null;
        this.paused = false;
      }
      /**
       * @param {Buffer} buf
       * @returns {0}
       */
      onStatus(buf) {
        this.statusText = buf.toString();
        return 0;
      }
      /**
       * @returns {0|-1}
       */
      onMessageBegin() {
        const { socket, client } = this;
        if (socket.destroyed) {
          return -1;
        }
        const request4 = client[kQueue][client[kRunningIdx]];
        if (!request4) {
          return -1;
        }
        request4.onResponseStarted();
        return 0;
      }
      /**
       * @param {Buffer} buf
       * @returns {number}
       */
      onHeaderField(buf) {
        const len = this.headers.length;
        if ((len & 1) === 0) {
          this.headers.push(buf);
        } else {
          this.headers[len - 1] = Buffer.concat([this.headers[len - 1], buf]);
        }
        this.trackHeader(buf.length);
        return 0;
      }
      /**
       * @param {Buffer} buf
       * @returns {number}
       */
      onHeaderValue(buf) {
        let len = this.headers.length;
        if ((len & 1) === 1) {
          this.headers.push(buf);
          len += 1;
        } else {
          this.headers[len - 1] = Buffer.concat([this.headers[len - 1], buf]);
        }
        const key = this.headers[len - 2];
        if (key.length === 10) {
          const headerName = util3.bufferToLowerCasedHeaderName(key);
          if (headerName === "keep-alive") {
            this.keepAlive += buf.toString();
          } else if (headerName === "connection") {
            this.connection += buf.toString();
          }
        } else if (key.length === 14 && util3.bufferToLowerCasedHeaderName(key) === "content-length") {
          this.contentLength += buf.toString();
        }
        this.trackHeader(buf.length);
        return 0;
      }
      /**
       * @param {number} len
       */
      trackHeader(len) {
        this.headersSize += len;
        if (this.headersSize >= this.headersMaxSize) {
          util3.destroy(this.socket, new HeadersOverflowError());
        }
      }
      /**
       * @param {Buffer} head
       */
      onUpgrade(head) {
        const { upgrade, client, socket, headers, statusCode } = this;
        assert48(upgrade);
        assert48(client[kSocket] === socket);
        assert48(!socket.destroyed);
        assert48(!this.paused);
        assert48((headers.length & 1) === 0);
        const request4 = client[kQueue][client[kRunningIdx]];
        assert48(request4);
        assert48(request4.upgrade || request4.method === "CONNECT");
        this.statusCode = 0;
        this.statusText = "";
        this.shouldKeepAlive = false;
        this.headers = [];
        this.headersSize = 0;
        socket.unshift(head);
        socket[kParser].destroy();
        socket[kParser] = null;
        socket[kClient] = null;
        socket[kError] = null;
        removeAllListeners(socket);
        client[kSocket] = null;
        client[kHTTPContext] = null;
        client[kQueue][client[kRunningIdx]++] = null;
        client.emit("disconnect", client[kUrl], [client], new InformationalError("upgrade"));
        try {
          request4.onUpgrade(statusCode, headers, socket);
        } catch (err) {
          util3.destroy(socket, err);
        }
        client[kResume]();
      }
      /**
       * @param {number} statusCode
       * @param {boolean} upgrade
       * @param {boolean} shouldKeepAlive
       * @returns {number}
       */
      onHeadersComplete(statusCode, upgrade, shouldKeepAlive) {
        const { client, socket, headers, statusText } = this;
        if (socket.destroyed) {
          return -1;
        }
        const request4 = client[kQueue][client[kRunningIdx]];
        if (!request4) {
          return -1;
        }
        assert48(!this.upgrade);
        assert48(this.statusCode < 200);
        if (statusCode === 100) {
          util3.destroy(socket, new SocketError("bad response", util3.getSocketInfo(socket)));
          return -1;
        }
        if (upgrade && !request4.upgrade) {
          util3.destroy(socket, new SocketError("bad upgrade", util3.getSocketInfo(socket)));
          return -1;
        }
        assert48(this.timeoutType === TIMEOUT_HEADERS);
        this.statusCode = statusCode;
        this.shouldKeepAlive = shouldKeepAlive || // Override llhttp value which does not allow keepAlive for HEAD.
        request4.method === "HEAD" && !socket[kReset2] && this.connection.toLowerCase() === "keep-alive";
        if (this.statusCode >= 200) {
          const bodyTimeout = request4.bodyTimeout != null ? request4.bodyTimeout : client[kBodyTimeout];
          this.setTimeout(bodyTimeout, TIMEOUT_BODY);
        } else if (this.timeout) {
          if (this.timeout.refresh) {
            this.timeout.refresh();
          }
        }
        if (request4.method === "CONNECT") {
          assert48(client[kRunning] === 1);
          this.upgrade = true;
          return 2;
        }
        if (upgrade) {
          assert48(client[kRunning] === 1);
          this.upgrade = true;
          return 2;
        }
        assert48((this.headers.length & 1) === 0);
        this.headers = [];
        this.headersSize = 0;
        if (this.shouldKeepAlive && client[kPipelining]) {
          const keepAliveTimeout = this.keepAlive ? util3.parseKeepAliveTimeout(this.keepAlive) : null;
          if (keepAliveTimeout != null) {
            const timeout2 = Math.min(
              keepAliveTimeout - client[kKeepAliveTimeoutThreshold],
              client[kKeepAliveMaxTimeout]
            );
            if (timeout2 <= 0) {
              socket[kReset2] = true;
            } else {
              client[kKeepAliveTimeoutValue] = timeout2;
            }
          } else {
            client[kKeepAliveTimeoutValue] = client[kKeepAliveDefaultTimeout];
          }
        } else {
          socket[kReset2] = true;
        }
        const pause = request4.onHeaders(statusCode, headers, this.resume, statusText) === false;
        if (request4.aborted) {
          return -1;
        }
        if (request4.method === "HEAD") {
          return 1;
        }
        if (statusCode < 200) {
          return 1;
        }
        if (socket[kBlocking]) {
          socket[kBlocking] = false;
          client[kResume]();
        }
        return pause ? constants4.ERROR.PAUSED : 0;
      }
      /**
       * @param {Buffer} buf
       * @returns {number}
       */
      onBody(buf) {
        const { client, socket, statusCode, maxResponseSize } = this;
        if (socket.destroyed) {
          return -1;
        }
        const request4 = client[kQueue][client[kRunningIdx]];
        assert48(request4);
        assert48(this.timeoutType === TIMEOUT_BODY);
        if (this.timeout) {
          if (this.timeout.refresh) {
            this.timeout.refresh();
          }
        }
        assert48(statusCode >= 200);
        if (maxResponseSize > -1 && this.bytesRead + buf.length > maxResponseSize) {
          util3.destroy(socket, new ResponseExceededMaxSizeError());
          return -1;
        }
        this.bytesRead += buf.length;
        if (request4.onData(buf) === false) {
          return constants4.ERROR.PAUSED;
        }
        return 0;
      }
      /**
       * @returns {number}
       */
      onMessageComplete() {
        const { client, socket, statusCode, upgrade, headers, contentLength, bytesRead, shouldKeepAlive } = this;
        if (socket.destroyed && (!statusCode || shouldKeepAlive)) {
          return -1;
        }
        if (upgrade) {
          return 0;
        }
        assert48(statusCode >= 100);
        assert48((this.headers.length & 1) === 0);
        const request4 = client[kQueue][client[kRunningIdx]];
        assert48(request4);
        this.statusCode = 0;
        this.statusText = "";
        this.bytesRead = 0;
        this.contentLength = "";
        this.keepAlive = "";
        this.connection = "";
        this.headers = [];
        this.headersSize = 0;
        if (statusCode < 200) {
          return 0;
        }
        if (request4.method !== "HEAD" && contentLength && bytesRead !== parseInt(contentLength, 10)) {
          util3.destroy(socket, new ResponseContentLengthMismatchError());
          return -1;
        }
        request4.onComplete(headers);
        client[kQueue][client[kRunningIdx]++] = null;
        if (socket[kWriting]) {
          assert48(client[kRunning] === 0);
          util3.destroy(socket, new InformationalError("reset"));
          return constants4.ERROR.PAUSED;
        } else if (!shouldKeepAlive) {
          util3.destroy(socket, new InformationalError("reset"));
          return constants4.ERROR.PAUSED;
        } else if (socket[kReset2] && client[kRunning] === 0) {
          util3.destroy(socket, new InformationalError("reset"));
          return constants4.ERROR.PAUSED;
        } else if (client[kPipelining] == null || client[kPipelining] === 1) {
          setImmediate(client[kResume]);
        } else {
          client[kResume]();
        }
        return 0;
      }
    };
    function onParserTimeout(parser2) {
      const { socket, timeoutType, client, paused } = parser2.deref();
      if (timeoutType === TIMEOUT_HEADERS) {
        if (!socket[kWriting] || socket.writableNeedDrain || client[kRunning] > 1) {
          assert48(!paused, "cannot be paused while waiting for headers");
          util3.destroy(socket, new HeadersTimeoutError());
        }
      } else if (timeoutType === TIMEOUT_BODY) {
        if (!paused) {
          util3.destroy(socket, new BodyTimeoutError());
        }
      } else if (timeoutType === TIMEOUT_KEEP_ALIVE) {
        assert48(client[kRunning] === 0 && client[kKeepAliveTimeoutValue]);
        util3.destroy(socket, new InformationalError("socket idle timeout"));
      }
    }
    __name(onParserTimeout, "onParserTimeout");
    async function connectH1(client, socket) {
      client[kSocket] = socket;
      if (!llhttpInstance) {
        llhttpInstance = lazyllhttp();
      }
      if (socket.errored) {
        throw socket.errored;
      }
      if (socket.destroyed) {
        throw new SocketError("destroyed");
      }
      socket[kNoRef] = false;
      socket[kWriting] = false;
      socket[kReset2] = false;
      socket[kBlocking] = false;
      socket[kParser] = new Parser2(client, socket, llhttpInstance);
      util3.addListener(socket, "error", onHttpSocketError);
      util3.addListener(socket, "readable", onHttpSocketReadable);
      util3.addListener(socket, "end", onHttpSocketEnd);
      util3.addListener(socket, "close", onHttpSocketClose);
      socket[kClosed] = false;
      socket.on("close", onSocketClose);
      return {
        version: "h1",
        defaultPipelining: 1,
        write(request4) {
          return writeH1(client, request4);
        },
        resume() {
          resumeH1(client);
        },
        /**
         * @param {Error|undefined} err
         * @param {() => void} callback
         */
        destroy(err, callback) {
          if (socket[kClosed]) {
            queueMicrotask(callback);
          } else {
            socket.on("close", callback);
            socket.destroy(err);
          }
        },
        /**
         * @returns {boolean}
         */
        get destroyed() {
          return socket.destroyed;
        },
        /**
         * @param {import('../core/request.js')} request
         * @returns {boolean}
         */
        busy(request4) {
          if (socket[kWriting] || socket[kReset2] || socket[kBlocking]) {
            return true;
          }
          if (request4) {
            if (client[kRunning] > 0 && !request4.idempotent) {
              return true;
            }
            if (client[kRunning] > 0 && (request4.upgrade || request4.method === "CONNECT")) {
              return true;
            }
            if (client[kRunning] > 0 && util3.bodyLength(request4.body) !== 0 && (util3.isStream(request4.body) || util3.isAsyncIterable(request4.body) || util3.isFormDataLike(request4.body))) {
              return true;
            }
          }
          return false;
        }
      };
    }
    __name(connectH1, "connectH1");
    function onHttpSocketError(err) {
      assert48(err.code !== "ERR_TLS_CERT_ALTNAME_INVALID");
      const parser2 = this[kParser];
      if (err.code === "ECONNRESET" && parser2.statusCode && !parser2.shouldKeepAlive) {
        parser2.onMessageComplete();
        return;
      }
      this[kError] = err;
      this[kClient][kOnError](err);
    }
    __name(onHttpSocketError, "onHttpSocketError");
    function onHttpSocketReadable() {
      this[kParser]?.readMore();
    }
    __name(onHttpSocketReadable, "onHttpSocketReadable");
    function onHttpSocketEnd() {
      const parser2 = this[kParser];
      if (parser2.statusCode && !parser2.shouldKeepAlive) {
        parser2.onMessageComplete();
        return;
      }
      util3.destroy(this, new SocketError("other side closed", util3.getSocketInfo(this)));
    }
    __name(onHttpSocketEnd, "onHttpSocketEnd");
    function onHttpSocketClose() {
      const parser2 = this[kParser];
      if (parser2) {
        if (!this[kError] && parser2.statusCode && !parser2.shouldKeepAlive) {
          parser2.onMessageComplete();
        }
        this[kParser].destroy();
        this[kParser] = null;
      }
      const err = this[kError] || new SocketError("closed", util3.getSocketInfo(this));
      const client = this[kClient];
      client[kSocket] = null;
      client[kHTTPContext] = null;
      if (client.destroyed) {
        assert48(client[kPending] === 0);
        const requests = client[kQueue].splice(client[kRunningIdx]);
        for (let i6 = 0; i6 < requests.length; i6++) {
          const request4 = requests[i6];
          util3.errorRequest(client, request4, err);
        }
      } else if (client[kRunning] > 0 && err.code !== "UND_ERR_INFO") {
        const request4 = client[kQueue][client[kRunningIdx]];
        client[kQueue][client[kRunningIdx]++] = null;
        util3.errorRequest(client, request4, err);
      }
      client[kPendingIdx] = client[kRunningIdx];
      assert48(client[kRunning] === 0);
      client.emit("disconnect", client[kUrl], [client], err);
      client[kResume]();
    }
    __name(onHttpSocketClose, "onHttpSocketClose");
    function onSocketClose() {
      this[kClosed] = true;
    }
    __name(onSocketClose, "onSocketClose");
    function resumeH1(client) {
      const socket = client[kSocket];
      if (socket && !socket.destroyed) {
        if (client[kSize] === 0) {
          if (!socket[kNoRef] && socket.unref) {
            socket.unref();
            socket[kNoRef] = true;
          }
        } else if (socket[kNoRef] && socket.ref) {
          socket.ref();
          socket[kNoRef] = false;
        }
        if (client[kSize] === 0) {
          if (socket[kParser].timeoutType !== TIMEOUT_KEEP_ALIVE) {
            socket[kParser].setTimeout(client[kKeepAliveTimeoutValue], TIMEOUT_KEEP_ALIVE);
          }
        } else if (client[kRunning] > 0 && socket[kParser].statusCode < 200) {
          if (socket[kParser].timeoutType !== TIMEOUT_HEADERS) {
            const request4 = client[kQueue][client[kRunningIdx]];
            const headersTimeout = request4.headersTimeout != null ? request4.headersTimeout : client[kHeadersTimeout];
            socket[kParser].setTimeout(headersTimeout, TIMEOUT_HEADERS);
          }
        }
      }
    }
    __name(resumeH1, "resumeH1");
    function shouldSendContentLength(method) {
      return method !== "GET" && method !== "HEAD" && method !== "OPTIONS" && method !== "TRACE" && method !== "CONNECT";
    }
    __name(shouldSendContentLength, "shouldSendContentLength");
    function writeH1(client, request4) {
      const { method, path: path77, host, upgrade, blocking, reset } = request4;
      let { body, headers, contentLength } = request4;
      const expectsPayload = method === "PUT" || method === "POST" || method === "PATCH" || method === "QUERY" || method === "PROPFIND" || method === "PROPPATCH";
      if (util3.isFormDataLike(body)) {
        if (!extractBody) {
          extractBody = require_body().extractBody;
        }
        const [bodyStream, contentType] = extractBody(body);
        if (request4.contentType == null) {
          headers.push("content-type", contentType);
        }
        body = bodyStream.stream;
        contentLength = bodyStream.length;
      } else if (util3.isBlobLike(body) && request4.contentType == null && body.type) {
        headers.push("content-type", body.type);
      }
      if (body && typeof body.read === "function") {
        body.read(0);
      }
      const bodyLength = util3.bodyLength(body);
      contentLength = bodyLength ?? contentLength;
      if (contentLength === null) {
        contentLength = request4.contentLength;
      }
      if (contentLength === 0 && !expectsPayload) {
        contentLength = null;
      }
      if (shouldSendContentLength(method) && contentLength > 0 && request4.contentLength !== null && request4.contentLength !== contentLength) {
        if (client[kStrictContentLength]) {
          util3.errorRequest(client, request4, new RequestContentLengthMismatchError());
          return false;
        }
        process.emitWarning(new RequestContentLengthMismatchError());
      }
      const socket = client[kSocket];
      const abort = /* @__PURE__ */ __name((err) => {
        if (request4.aborted || request4.completed) {
          return;
        }
        util3.errorRequest(client, request4, err || new RequestAbortedError());
        util3.destroy(body);
        util3.destroy(socket, new InformationalError("aborted"));
      }, "abort");
      try {
        request4.onConnect(abort);
      } catch (err) {
        util3.errorRequest(client, request4, err);
      }
      if (request4.aborted) {
        return false;
      }
      if (method === "HEAD") {
        socket[kReset2] = true;
      }
      if (upgrade || method === "CONNECT") {
        socket[kReset2] = true;
      }
      if (reset != null) {
        socket[kReset2] = reset;
      }
      if (client[kMaxRequests] && socket[kCounter]++ >= client[kMaxRequests]) {
        socket[kReset2] = true;
      }
      if (blocking) {
        socket[kBlocking] = true;
      }
      let header = `${method} ${path77} HTTP/1.1\r
`;
      if (typeof host === "string") {
        header += `host: ${host}\r
`;
      } else {
        header += client[kHostHeader];
      }
      if (upgrade) {
        header += `connection: upgrade\r
upgrade: ${upgrade}\r
`;
      } else if (client[kPipelining] && !socket[kReset2]) {
        header += "connection: keep-alive\r\n";
      } else {
        header += "connection: close\r\n";
      }
      if (Array.isArray(headers)) {
        for (let n7 = 0; n7 < headers.length; n7 += 2) {
          const key = headers[n7 + 0];
          const val2 = headers[n7 + 1];
          if (Array.isArray(val2)) {
            for (let i6 = 0; i6 < val2.length; i6++) {
              header += `${key}: ${val2[i6]}\r
`;
            }
          } else {
            header += `${key}: ${val2}\r
`;
          }
        }
      }
      if (channels.sendHeaders.hasSubscribers) {
        channels.sendHeaders.publish({ request: request4, headers: header, socket });
      }
      if (!body || bodyLength === 0) {
        writeBuffer(abort, null, client, request4, socket, contentLength, header, expectsPayload);
      } else if (util3.isBuffer(body)) {
        writeBuffer(abort, body, client, request4, socket, contentLength, header, expectsPayload);
      } else if (util3.isBlobLike(body)) {
        if (typeof body.stream === "function") {
          writeIterable(abort, body.stream(), client, request4, socket, contentLength, header, expectsPayload);
        } else {
          writeBlob(abort, body, client, request4, socket, contentLength, header, expectsPayload);
        }
      } else if (util3.isStream(body)) {
        writeStream(abort, body, client, request4, socket, contentLength, header, expectsPayload);
      } else if (util3.isIterable(body)) {
        writeIterable(abort, body, client, request4, socket, contentLength, header, expectsPayload);
      } else {
        assert48(false);
      }
      return true;
    }
    __name(writeH1, "writeH1");
    function writeStream(abort, body, client, request4, socket, contentLength, header, expectsPayload) {
      assert48(contentLength !== 0 || client[kRunning] === 0, "stream body cannot be pipelined");
      let finished = false;
      const writer = new AsyncWriter({ abort, socket, request: request4, contentLength, client, expectsPayload, header });
      const onData = /* @__PURE__ */ __name(function(chunk) {
        if (finished) {
          return;
        }
        try {
          if (!writer.write(chunk) && this.pause) {
            this.pause();
          }
        } catch (err) {
          util3.destroy(this, err);
        }
      }, "onData");
      const onDrain = /* @__PURE__ */ __name(function() {
        if (finished) {
          return;
        }
        if (body.resume) {
          body.resume();
        }
      }, "onDrain");
      const onClose = /* @__PURE__ */ __name(function() {
        queueMicrotask(() => {
          body.removeListener("error", onFinished);
        });
        if (!finished) {
          const err = new RequestAbortedError();
          queueMicrotask(() => onFinished(err));
        }
      }, "onClose");
      const onFinished = /* @__PURE__ */ __name(function(err) {
        if (finished) {
          return;
        }
        finished = true;
        assert48(socket.destroyed || socket[kWriting] && client[kRunning] <= 1);
        socket.off("drain", onDrain).off("error", onFinished);
        body.removeListener("data", onData).removeListener("end", onFinished).removeListener("close", onClose);
        if (!err) {
          try {
            writer.end();
          } catch (er2) {
            err = er2;
          }
        }
        writer.destroy(err);
        if (err && (err.code !== "UND_ERR_INFO" || err.message !== "reset")) {
          util3.destroy(body, err);
        } else {
          util3.destroy(body);
        }
      }, "onFinished");
      body.on("data", onData).on("end", onFinished).on("error", onFinished).on("close", onClose);
      if (body.resume) {
        body.resume();
      }
      socket.on("drain", onDrain).on("error", onFinished);
      if (body.errorEmitted ?? body.errored) {
        setImmediate(onFinished, body.errored);
      } else if (body.endEmitted ?? body.readableEnded) {
        setImmediate(onFinished, null);
      }
      if (body.closeEmitted ?? body.closed) {
        setImmediate(onClose);
      }
    }
    __name(writeStream, "writeStream");
    function writeBuffer(abort, body, client, request4, socket, contentLength, header, expectsPayload) {
      try {
        if (!body) {
          if (contentLength === 0) {
            socket.write(`${header}content-length: 0\r
\r
`, "latin1");
          } else {
            assert48(contentLength === null, "no body must not have content length");
            socket.write(`${header}\r
`, "latin1");
          }
        } else if (util3.isBuffer(body)) {
          assert48(contentLength === body.byteLength, "buffer body must have content length");
          socket.cork();
          socket.write(`${header}content-length: ${contentLength}\r
\r
`, "latin1");
          socket.write(body);
          socket.uncork();
          request4.onBodySent(body);
          if (!expectsPayload && request4.reset !== false) {
            socket[kReset2] = true;
          }
        }
        request4.onRequestSent();
        client[kResume]();
      } catch (err) {
        abort(err);
      }
    }
    __name(writeBuffer, "writeBuffer");
    async function writeBlob(abort, body, client, request4, socket, contentLength, header, expectsPayload) {
      assert48(contentLength === body.size, "blob body must have content length");
      try {
        if (contentLength != null && contentLength !== body.size) {
          throw new RequestContentLengthMismatchError();
        }
        const buffer = Buffer.from(await body.arrayBuffer());
        socket.cork();
        socket.write(`${header}content-length: ${contentLength}\r
\r
`, "latin1");
        socket.write(buffer);
        socket.uncork();
        request4.onBodySent(buffer);
        request4.onRequestSent();
        if (!expectsPayload && request4.reset !== false) {
          socket[kReset2] = true;
        }
        client[kResume]();
      } catch (err) {
        abort(err);
      }
    }
    __name(writeBlob, "writeBlob");
    async function writeIterable(abort, body, client, request4, socket, contentLength, header, expectsPayload) {
      assert48(contentLength !== 0 || client[kRunning] === 0, "iterator body cannot be pipelined");
      let callback = null;
      function onDrain() {
        if (callback) {
          const cb2 = callback;
          callback = null;
          cb2();
        }
      }
      __name(onDrain, "onDrain");
      const waitForDrain = /* @__PURE__ */ __name(() => new Promise((resolve28, reject) => {
        assert48(callback === null);
        if (socket[kError]) {
          reject(socket[kError]);
        } else {
          callback = resolve28;
        }
      }), "waitForDrain");
      socket.on("close", onDrain).on("drain", onDrain);
      const writer = new AsyncWriter({ abort, socket, request: request4, contentLength, client, expectsPayload, header });
      try {
        for await (const chunk of body) {
          if (socket[kError]) {
            throw socket[kError];
          }
          if (!writer.write(chunk)) {
            await waitForDrain();
          }
        }
        writer.end();
      } catch (err) {
        writer.destroy(err);
      } finally {
        socket.off("close", onDrain).off("drain", onDrain);
      }
    }
    __name(writeIterable, "writeIterable");
    var AsyncWriter = class {
      static {
        __name(this, "AsyncWriter");
      }
      /**
       *
       * @param {object} arg
       * @param {AbortCallback} arg.abort
       * @param {import('net').Socket} arg.socket
       * @param {import('../core/request.js')} arg.request
       * @param {number} arg.contentLength
       * @param {import('./client.js')} arg.client
       * @param {boolean} arg.expectsPayload
       * @param {string} arg.header
       */
      constructor({ abort, socket, request: request4, contentLength, client, expectsPayload, header }) {
        this.socket = socket;
        this.request = request4;
        this.contentLength = contentLength;
        this.client = client;
        this.bytesWritten = 0;
        this.expectsPayload = expectsPayload;
        this.header = header;
        this.abort = abort;
        socket[kWriting] = true;
      }
      /**
       * @param {Buffer} chunk
       * @returns
       */
      write(chunk) {
        const { socket, request: request4, contentLength, client, bytesWritten, expectsPayload, header } = this;
        if (socket[kError]) {
          throw socket[kError];
        }
        if (socket.destroyed) {
          return false;
        }
        const len = Buffer.byteLength(chunk);
        if (!len) {
          return true;
        }
        if (contentLength !== null && bytesWritten + len > contentLength) {
          if (client[kStrictContentLength]) {
            throw new RequestContentLengthMismatchError();
          }
          process.emitWarning(new RequestContentLengthMismatchError());
        }
        socket.cork();
        if (bytesWritten === 0) {
          if (!expectsPayload && request4.reset !== false) {
            socket[kReset2] = true;
          }
          if (contentLength === null) {
            socket.write(`${header}transfer-encoding: chunked\r
`, "latin1");
          } else {
            socket.write(`${header}content-length: ${contentLength}\r
\r
`, "latin1");
          }
        }
        if (contentLength === null) {
          socket.write(`\r
${len.toString(16)}\r
`, "latin1");
        }
        this.bytesWritten += len;
        const ret = socket.write(chunk);
        socket.uncork();
        request4.onBodySent(chunk);
        if (!ret) {
          if (socket[kParser].timeout && socket[kParser].timeoutType === TIMEOUT_HEADERS) {
            if (socket[kParser].timeout.refresh) {
              socket[kParser].timeout.refresh();
            }
          }
        }
        return ret;
      }
      /**
       * @returns {void}
       */
      end() {
        const { socket, contentLength, client, bytesWritten, expectsPayload, header, request: request4 } = this;
        request4.onRequestSent();
        socket[kWriting] = false;
        if (socket[kError]) {
          throw socket[kError];
        }
        if (socket.destroyed) {
          return;
        }
        if (bytesWritten === 0) {
          if (expectsPayload) {
            socket.write(`${header}content-length: 0\r
\r
`, "latin1");
          } else {
            socket.write(`${header}\r
`, "latin1");
          }
        } else if (contentLength === null) {
          socket.write("\r\n0\r\n\r\n", "latin1");
        }
        if (contentLength !== null && bytesWritten !== contentLength) {
          if (client[kStrictContentLength]) {
            throw new RequestContentLengthMismatchError();
          } else {
            process.emitWarning(new RequestContentLengthMismatchError());
          }
        }
        if (socket[kParser].timeout && socket[kParser].timeoutType === TIMEOUT_HEADERS) {
          if (socket[kParser].timeout.refresh) {
            socket[kParser].timeout.refresh();
          }
        }
        client[kResume]();
      }
      /**
       * @param {Error} [err]
       * @returns {void}
       */
      destroy(err) {
        const { socket, client, abort } = this;
        socket[kWriting] = false;
        if (err) {
          assert48(client[kRunning] <= 1, "pipeline should only contain this request");
          abort(err);
        }
      }
    };
    module3.exports = connectH1;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/client-h2.js
var require_client_h2 = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/client-h2.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var { pipeline } = __require("stream");
    var util3 = require_util();
    var {
      RequestContentLengthMismatchError,
      RequestAbortedError,
      SocketError,
      InformationalError
    } = require_errors();
    var {
      kUrl,
      kReset: kReset2,
      kClient,
      kRunning,
      kPending,
      kQueue,
      kPendingIdx,
      kRunningIdx,
      kError,
      kSocket,
      kStrictContentLength,
      kOnError,
      kMaxConcurrentStreams,
      kHTTP2Session,
      kResume,
      kSize,
      kHTTPContext,
      kClosed,
      kBodyTimeout
    } = require_symbols();
    var { channels } = require_diagnostics();
    var kOpenStreams = Symbol("open streams");
    var extractBody;
    var http22;
    try {
      http22 = __require("http2");
    } catch {
      http22 = { constants: {} };
    }
    var {
      constants: {
        HTTP2_HEADER_AUTHORITY,
        HTTP2_HEADER_METHOD,
        HTTP2_HEADER_PATH,
        HTTP2_HEADER_SCHEME,
        HTTP2_HEADER_CONTENT_LENGTH,
        HTTP2_HEADER_EXPECT,
        HTTP2_HEADER_STATUS
      }
    } = http22;
    function parseH2Headers(headers) {
      const result = [];
      for (const [name2, value] of Object.entries(headers)) {
        if (Array.isArray(value)) {
          for (const subvalue of value) {
            result.push(Buffer.from(name2), Buffer.from(subvalue));
          }
        } else {
          result.push(Buffer.from(name2), Buffer.from(value));
        }
      }
      return result;
    }
    __name(parseH2Headers, "parseH2Headers");
    async function connectH2(client, socket) {
      client[kSocket] = socket;
      const session = http22.connect(client[kUrl], {
        createConnection: /* @__PURE__ */ __name(() => socket, "createConnection"),
        peerMaxConcurrentStreams: client[kMaxConcurrentStreams],
        settings: {
          // TODO(metcoder95): add support for PUSH
          enablePush: false
        }
      });
      session[kOpenStreams] = 0;
      session[kClient] = client;
      session[kSocket] = socket;
      session[kHTTP2Session] = null;
      util3.addListener(session, "error", onHttp2SessionError);
      util3.addListener(session, "frameError", onHttp2FrameError);
      util3.addListener(session, "end", onHttp2SessionEnd);
      util3.addListener(session, "goaway", onHttp2SessionGoAway);
      util3.addListener(session, "close", onHttp2SessionClose);
      session.unref();
      client[kHTTP2Session] = session;
      socket[kHTTP2Session] = session;
      util3.addListener(socket, "error", onHttp2SocketError);
      util3.addListener(socket, "end", onHttp2SocketEnd);
      util3.addListener(socket, "close", onHttp2SocketClose);
      socket[kClosed] = false;
      socket.on("close", onSocketClose);
      return {
        version: "h2",
        defaultPipelining: Infinity,
        write(request4) {
          return writeH2(client, request4);
        },
        resume() {
          resumeH2(client);
        },
        destroy(err, callback) {
          if (socket[kClosed]) {
            queueMicrotask(callback);
          } else {
            socket.destroy(err).on("close", callback);
          }
        },
        get destroyed() {
          return socket.destroyed;
        },
        busy() {
          return false;
        }
      };
    }
    __name(connectH2, "connectH2");
    function resumeH2(client) {
      const socket = client[kSocket];
      if (socket?.destroyed === false) {
        if (client[kSize] === 0 || client[kMaxConcurrentStreams] === 0) {
          socket.unref();
          client[kHTTP2Session].unref();
        } else {
          socket.ref();
          client[kHTTP2Session].ref();
        }
      }
    }
    __name(resumeH2, "resumeH2");
    function onHttp2SessionError(err) {
      assert48(err.code !== "ERR_TLS_CERT_ALTNAME_INVALID");
      this[kSocket][kError] = err;
      this[kClient][kOnError](err);
    }
    __name(onHttp2SessionError, "onHttp2SessionError");
    function onHttp2FrameError(type, code, id) {
      if (id === 0) {
        const err = new InformationalError(`HTTP/2: "frameError" received - type ${type}, code ${code}`);
        this[kSocket][kError] = err;
        this[kClient][kOnError](err);
      }
    }
    __name(onHttp2FrameError, "onHttp2FrameError");
    function onHttp2SessionEnd() {
      const err = new SocketError("other side closed", util3.getSocketInfo(this[kSocket]));
      this.destroy(err);
      util3.destroy(this[kSocket], err);
    }
    __name(onHttp2SessionEnd, "onHttp2SessionEnd");
    function onHttp2SessionGoAway(errorCode) {
      const err = this[kError] || new SocketError(`HTTP/2: "GOAWAY" frame received with code ${errorCode}`, util3.getSocketInfo(this[kSocket]));
      const client = this[kClient];
      client[kSocket] = null;
      client[kHTTPContext] = null;
      this.close();
      this[kHTTP2Session] = null;
      util3.destroy(this[kSocket], err);
      if (client[kRunningIdx] < client[kQueue].length) {
        const request4 = client[kQueue][client[kRunningIdx]];
        client[kQueue][client[kRunningIdx]++] = null;
        util3.errorRequest(client, request4, err);
        client[kPendingIdx] = client[kRunningIdx];
      }
      assert48(client[kRunning] === 0);
      client.emit("disconnect", client[kUrl], [client], err);
      client.emit("connectionError", client[kUrl], [client], err);
      client[kResume]();
    }
    __name(onHttp2SessionGoAway, "onHttp2SessionGoAway");
    function onHttp2SessionClose() {
      const { [kClient]: client } = this;
      const { [kSocket]: socket } = client;
      const err = this[kSocket][kError] || this[kError] || new SocketError("closed", util3.getSocketInfo(socket));
      client[kSocket] = null;
      client[kHTTPContext] = null;
      if (client.destroyed) {
        assert48(client[kPending] === 0);
        const requests = client[kQueue].splice(client[kRunningIdx]);
        for (let i6 = 0; i6 < requests.length; i6++) {
          const request4 = requests[i6];
          util3.errorRequest(client, request4, err);
        }
      }
    }
    __name(onHttp2SessionClose, "onHttp2SessionClose");
    function onHttp2SocketClose() {
      const err = this[kError] || new SocketError("closed", util3.getSocketInfo(this));
      const client = this[kHTTP2Session][kClient];
      client[kSocket] = null;
      client[kHTTPContext] = null;
      if (this[kHTTP2Session] !== null) {
        this[kHTTP2Session].destroy(err);
      }
      client[kPendingIdx] = client[kRunningIdx];
      assert48(client[kRunning] === 0);
      client.emit("disconnect", client[kUrl], [client], err);
      client[kResume]();
    }
    __name(onHttp2SocketClose, "onHttp2SocketClose");
    function onHttp2SocketError(err) {
      assert48(err.code !== "ERR_TLS_CERT_ALTNAME_INVALID");
      this[kError] = err;
      this[kClient][kOnError](err);
    }
    __name(onHttp2SocketError, "onHttp2SocketError");
    function onHttp2SocketEnd() {
      util3.destroy(this, new SocketError("other side closed", util3.getSocketInfo(this)));
    }
    __name(onHttp2SocketEnd, "onHttp2SocketEnd");
    function onSocketClose() {
      this[kClosed] = true;
    }
    __name(onSocketClose, "onSocketClose");
    function shouldSendContentLength(method) {
      return method !== "GET" && method !== "HEAD" && method !== "OPTIONS" && method !== "TRACE" && method !== "CONNECT";
    }
    __name(shouldSendContentLength, "shouldSendContentLength");
    function writeH2(client, request4) {
      const requestTimeout2 = request4.bodyTimeout ?? client[kBodyTimeout];
      const session = client[kHTTP2Session];
      const { method, path: path77, host, upgrade, expectContinue, signal, headers: reqHeaders } = request4;
      let { body } = request4;
      if (upgrade) {
        util3.errorRequest(client, request4, new Error("Upgrade not supported for H2"));
        return false;
      }
      const headers = {};
      for (let n7 = 0; n7 < reqHeaders.length; n7 += 2) {
        const key = reqHeaders[n7 + 0];
        const val2 = reqHeaders[n7 + 1];
        if (Array.isArray(val2)) {
          for (let i6 = 0; i6 < val2.length; i6++) {
            if (headers[key]) {
              headers[key] += `, ${val2[i6]}`;
            } else {
              headers[key] = val2[i6];
            }
          }
        } else if (headers[key]) {
          headers[key] += `, ${val2}`;
        } else {
          headers[key] = val2;
        }
      }
      let stream2 = null;
      const { hostname: hostname2, port } = client[kUrl];
      headers[HTTP2_HEADER_AUTHORITY] = host || `${hostname2}${port ? `:${port}` : ""}`;
      headers[HTTP2_HEADER_METHOD] = method;
      const abort = /* @__PURE__ */ __name((err) => {
        if (request4.aborted || request4.completed) {
          return;
        }
        err = err || new RequestAbortedError();
        util3.errorRequest(client, request4, err);
        if (stream2 != null) {
          stream2.removeAllListeners("data");
          stream2.close();
          client[kOnError](err);
          client[kResume]();
        }
        util3.destroy(body, err);
      }, "abort");
      try {
        request4.onConnect(abort);
      } catch (err) {
        util3.errorRequest(client, request4, err);
      }
      if (request4.aborted) {
        return false;
      }
      if (method === "CONNECT") {
        session.ref();
        stream2 = session.request(headers, { endStream: false, signal });
        if (!stream2.pending) {
          request4.onUpgrade(null, null, stream2);
          ++session[kOpenStreams];
          client[kQueue][client[kRunningIdx]++] = null;
        } else {
          stream2.once("ready", () => {
            request4.onUpgrade(null, null, stream2);
            ++session[kOpenStreams];
            client[kQueue][client[kRunningIdx]++] = null;
          });
        }
        stream2.once("close", () => {
          session[kOpenStreams] -= 1;
          if (session[kOpenStreams] === 0) session.unref();
        });
        stream2.setTimeout(requestTimeout2);
        return true;
      }
      headers[HTTP2_HEADER_PATH] = path77;
      headers[HTTP2_HEADER_SCHEME] = "https";
      const expectsPayload = method === "PUT" || method === "POST" || method === "PATCH";
      if (body && typeof body.read === "function") {
        body.read(0);
      }
      let contentLength = util3.bodyLength(body);
      if (util3.isFormDataLike(body)) {
        extractBody ??= require_body().extractBody;
        const [bodyStream, contentType] = extractBody(body);
        headers["content-type"] = contentType;
        body = bodyStream.stream;
        contentLength = bodyStream.length;
      }
      if (contentLength == null) {
        contentLength = request4.contentLength;
      }
      if (contentLength === 0 || !expectsPayload) {
        contentLength = null;
      }
      if (shouldSendContentLength(method) && contentLength > 0 && request4.contentLength != null && request4.contentLength !== contentLength) {
        if (client[kStrictContentLength]) {
          util3.errorRequest(client, request4, new RequestContentLengthMismatchError());
          return false;
        }
        process.emitWarning(new RequestContentLengthMismatchError());
      }
      if (contentLength != null) {
        assert48(body, "no body must not have content length");
        headers[HTTP2_HEADER_CONTENT_LENGTH] = `${contentLength}`;
      }
      session.ref();
      if (channels.sendHeaders.hasSubscribers) {
        let header = "";
        for (const key in headers) {
          header += `${key}: ${headers[key]}\r
`;
        }
        channels.sendHeaders.publish({ request: request4, headers: header, socket: session[kSocket] });
      }
      const shouldEndStream = method === "GET" || method === "HEAD" || body === null;
      if (expectContinue) {
        headers[HTTP2_HEADER_EXPECT] = "100-continue";
        stream2 = session.request(headers, { endStream: shouldEndStream, signal });
        stream2.once("continue", writeBodyH2);
      } else {
        stream2 = session.request(headers, {
          endStream: shouldEndStream,
          signal
        });
        writeBodyH2();
      }
      ++session[kOpenStreams];
      stream2.setTimeout(requestTimeout2);
      stream2.once("response", (headers2) => {
        const { [HTTP2_HEADER_STATUS]: statusCode, ...realHeaders } = headers2;
        request4.onResponseStarted();
        if (request4.aborted) {
          stream2.removeAllListeners("data");
          return;
        }
        if (request4.onHeaders(Number(statusCode), parseH2Headers(realHeaders), stream2.resume.bind(stream2), "") === false) {
          stream2.pause();
        }
      });
      stream2.on("data", (chunk) => {
        if (request4.onData(chunk) === false) {
          stream2.pause();
        }
      });
      stream2.once("end", (err) => {
        stream2.removeAllListeners("data");
        if (stream2.state?.state == null || stream2.state.state < 6) {
          if (!request4.aborted && !request4.completed) {
            request4.onComplete({});
          }
          client[kQueue][client[kRunningIdx]++] = null;
          client[kResume]();
        } else {
          --session[kOpenStreams];
          if (session[kOpenStreams] === 0) {
            session.unref();
          }
          abort(err ?? new InformationalError("HTTP/2: stream half-closed (remote)"));
          client[kQueue][client[kRunningIdx]++] = null;
          client[kPendingIdx] = client[kRunningIdx];
          client[kResume]();
        }
      });
      stream2.once("close", () => {
        stream2.removeAllListeners("data");
        session[kOpenStreams] -= 1;
        if (session[kOpenStreams] === 0) {
          session.unref();
        }
      });
      stream2.once("error", function(err) {
        stream2.removeAllListeners("data");
        abort(err);
      });
      stream2.once("frameError", (type, code) => {
        stream2.removeAllListeners("data");
        abort(new InformationalError(`HTTP/2: "frameError" received - type ${type}, code ${code}`));
      });
      stream2.on("aborted", () => {
        stream2.removeAllListeners("data");
      });
      stream2.on("timeout", () => {
        const err = new InformationalError(`HTTP/2: "stream timeout after ${requestTimeout2}"`);
        stream2.removeAllListeners("data");
        session[kOpenStreams] -= 1;
        if (session[kOpenStreams] === 0) {
          session.unref();
        }
        abort(err);
      });
      stream2.once("trailers", (trailers) => {
        if (request4.aborted || request4.completed) {
          return;
        }
        request4.onComplete(trailers);
      });
      return true;
      function writeBodyH2() {
        if (!body || contentLength === 0) {
          writeBuffer(
            abort,
            stream2,
            null,
            client,
            request4,
            client[kSocket],
            contentLength,
            expectsPayload
          );
        } else if (util3.isBuffer(body)) {
          writeBuffer(
            abort,
            stream2,
            body,
            client,
            request4,
            client[kSocket],
            contentLength,
            expectsPayload
          );
        } else if (util3.isBlobLike(body)) {
          if (typeof body.stream === "function") {
            writeIterable(
              abort,
              stream2,
              body.stream(),
              client,
              request4,
              client[kSocket],
              contentLength,
              expectsPayload
            );
          } else {
            writeBlob(
              abort,
              stream2,
              body,
              client,
              request4,
              client[kSocket],
              contentLength,
              expectsPayload
            );
          }
        } else if (util3.isStream(body)) {
          writeStream(
            abort,
            client[kSocket],
            expectsPayload,
            stream2,
            body,
            client,
            request4,
            contentLength
          );
        } else if (util3.isIterable(body)) {
          writeIterable(
            abort,
            stream2,
            body,
            client,
            request4,
            client[kSocket],
            contentLength,
            expectsPayload
          );
        } else {
          assert48(false);
        }
      }
    }
    __name(writeH2, "writeH2");
    function writeBuffer(abort, h2stream, body, client, request4, socket, contentLength, expectsPayload) {
      try {
        if (body != null && util3.isBuffer(body)) {
          assert48(contentLength === body.byteLength, "buffer body must have content length");
          h2stream.cork();
          h2stream.write(body);
          h2stream.uncork();
          h2stream.end();
          request4.onBodySent(body);
        }
        if (!expectsPayload) {
          socket[kReset2] = true;
        }
        request4.onRequestSent();
        client[kResume]();
      } catch (error2) {
        abort(error2);
      }
    }
    __name(writeBuffer, "writeBuffer");
    function writeStream(abort, socket, expectsPayload, h2stream, body, client, request4, contentLength) {
      assert48(contentLength !== 0 || client[kRunning] === 0, "stream body cannot be pipelined");
      const pipe = pipeline(
        body,
        h2stream,
        (err) => {
          if (err) {
            util3.destroy(pipe, err);
            abort(err);
          } else {
            util3.removeAllListeners(pipe);
            request4.onRequestSent();
            if (!expectsPayload) {
              socket[kReset2] = true;
            }
            client[kResume]();
          }
        }
      );
      util3.addListener(pipe, "data", onPipeData);
      function onPipeData(chunk) {
        request4.onBodySent(chunk);
      }
      __name(onPipeData, "onPipeData");
    }
    __name(writeStream, "writeStream");
    async function writeBlob(abort, h2stream, body, client, request4, socket, contentLength, expectsPayload) {
      assert48(contentLength === body.size, "blob body must have content length");
      try {
        if (contentLength != null && contentLength !== body.size) {
          throw new RequestContentLengthMismatchError();
        }
        const buffer = Buffer.from(await body.arrayBuffer());
        h2stream.cork();
        h2stream.write(buffer);
        h2stream.uncork();
        h2stream.end();
        request4.onBodySent(buffer);
        request4.onRequestSent();
        if (!expectsPayload) {
          socket[kReset2] = true;
        }
        client[kResume]();
      } catch (err) {
        abort(err);
      }
    }
    __name(writeBlob, "writeBlob");
    async function writeIterable(abort, h2stream, body, client, request4, socket, contentLength, expectsPayload) {
      assert48(contentLength !== 0 || client[kRunning] === 0, "iterator body cannot be pipelined");
      let callback = null;
      function onDrain() {
        if (callback) {
          const cb2 = callback;
          callback = null;
          cb2();
        }
      }
      __name(onDrain, "onDrain");
      const waitForDrain = /* @__PURE__ */ __name(() => new Promise((resolve28, reject) => {
        assert48(callback === null);
        if (socket[kError]) {
          reject(socket[kError]);
        } else {
          callback = resolve28;
        }
      }), "waitForDrain");
      h2stream.on("close", onDrain).on("drain", onDrain);
      try {
        for await (const chunk of body) {
          if (socket[kError]) {
            throw socket[kError];
          }
          const res = h2stream.write(chunk);
          request4.onBodySent(chunk);
          if (!res) {
            await waitForDrain();
          }
        }
        h2stream.end();
        request4.onRequestSent();
        if (!expectsPayload) {
          socket[kReset2] = true;
        }
        client[kResume]();
      } catch (err) {
        abort(err);
      } finally {
        h2stream.off("close", onDrain).off("drain", onDrain);
      }
    }
    __name(writeIterable, "writeIterable");
    module3.exports = connectH2;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/client.js
var require_client = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/client.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var net2 = __require("net");
    var http6 = __require("http");
    var util3 = require_util();
    var { ClientStats } = require_stats();
    var { channels } = require_diagnostics();
    var Request7 = require_request();
    var DispatcherBase = require_dispatcher_base();
    var {
      InvalidArgumentError,
      InformationalError,
      ClientDestroyedError
    } = require_errors();
    var buildConnector = require_connect();
    var {
      kUrl,
      kServerName,
      kClient,
      kBusy,
      kConnect,
      kResuming,
      kRunning,
      kPending,
      kSize,
      kQueue,
      kConnected,
      kConnecting,
      kNeedDrain,
      kKeepAliveDefaultTimeout,
      kHostHeader,
      kPendingIdx,
      kRunningIdx,
      kError,
      kPipelining,
      kKeepAliveTimeoutValue,
      kMaxHeadersSize,
      kKeepAliveMaxTimeout,
      kKeepAliveTimeoutThreshold,
      kHeadersTimeout,
      kBodyTimeout,
      kStrictContentLength,
      kConnector,
      kMaxRequests,
      kCounter,
      kClose,
      kDestroy,
      kDispatch,
      kLocalAddress,
      kMaxResponseSize,
      kOnError,
      kHTTPContext,
      kMaxConcurrentStreams,
      kResume
    } = require_symbols();
    var connectH1 = require_client_h1();
    var connectH2 = require_client_h2();
    var kClosedResolve = Symbol("kClosedResolve");
    var getDefaultNodeMaxHeaderSize = http6 && http6.maxHeaderSize && Number.isInteger(http6.maxHeaderSize) && http6.maxHeaderSize > 0 ? () => http6.maxHeaderSize : () => {
      throw new InvalidArgumentError("http module not available or http.maxHeaderSize invalid");
    };
    var noop = /* @__PURE__ */ __name(() => {
    }, "noop");
    function getPipelining(client) {
      return client[kPipelining] ?? client[kHTTPContext]?.defaultPipelining ?? 1;
    }
    __name(getPipelining, "getPipelining");
    var Client2 = class extends DispatcherBase {
      static {
        __name(this, "Client");
      }
      /**
       *
       * @param {string|URL} url
       * @param {import('../../types/client.js').Client.Options} options
       */
      constructor(url4, {
        maxHeaderSize,
        headersTimeout,
        socketTimeout,
        requestTimeout: requestTimeout2,
        connectTimeout,
        bodyTimeout,
        idleTimeout,
        keepAlive,
        keepAliveTimeout,
        maxKeepAliveTimeout,
        keepAliveMaxTimeout,
        keepAliveTimeoutThreshold,
        socketPath,
        pipelining,
        tls,
        strictContentLength,
        maxCachedSessions,
        connect: connect2,
        maxRequestsPerClient,
        localAddress,
        maxResponseSize,
        autoSelectFamily,
        autoSelectFamilyAttemptTimeout,
        // h2
        maxConcurrentStreams,
        allowH2
      } = {}) {
        if (keepAlive !== void 0) {
          throw new InvalidArgumentError("unsupported keepAlive, use pipelining=0 instead");
        }
        if (socketTimeout !== void 0) {
          throw new InvalidArgumentError("unsupported socketTimeout, use headersTimeout & bodyTimeout instead");
        }
        if (requestTimeout2 !== void 0) {
          throw new InvalidArgumentError("unsupported requestTimeout, use headersTimeout & bodyTimeout instead");
        }
        if (idleTimeout !== void 0) {
          throw new InvalidArgumentError("unsupported idleTimeout, use keepAliveTimeout instead");
        }
        if (maxKeepAliveTimeout !== void 0) {
          throw new InvalidArgumentError("unsupported maxKeepAliveTimeout, use keepAliveMaxTimeout instead");
        }
        if (maxHeaderSize != null) {
          if (!Number.isInteger(maxHeaderSize) || maxHeaderSize < 1) {
            throw new InvalidArgumentError("invalid maxHeaderSize");
          }
        } else {
          maxHeaderSize = getDefaultNodeMaxHeaderSize();
        }
        if (socketPath != null && typeof socketPath !== "string") {
          throw new InvalidArgumentError("invalid socketPath");
        }
        if (connectTimeout != null && (!Number.isFinite(connectTimeout) || connectTimeout < 0)) {
          throw new InvalidArgumentError("invalid connectTimeout");
        }
        if (keepAliveTimeout != null && (!Number.isFinite(keepAliveTimeout) || keepAliveTimeout <= 0)) {
          throw new InvalidArgumentError("invalid keepAliveTimeout");
        }
        if (keepAliveMaxTimeout != null && (!Number.isFinite(keepAliveMaxTimeout) || keepAliveMaxTimeout <= 0)) {
          throw new InvalidArgumentError("invalid keepAliveMaxTimeout");
        }
        if (keepAliveTimeoutThreshold != null && !Number.isFinite(keepAliveTimeoutThreshold)) {
          throw new InvalidArgumentError("invalid keepAliveTimeoutThreshold");
        }
        if (headersTimeout != null && (!Number.isInteger(headersTimeout) || headersTimeout < 0)) {
          throw new InvalidArgumentError("headersTimeout must be a positive integer or zero");
        }
        if (bodyTimeout != null && (!Number.isInteger(bodyTimeout) || bodyTimeout < 0)) {
          throw new InvalidArgumentError("bodyTimeout must be a positive integer or zero");
        }
        if (connect2 != null && typeof connect2 !== "function" && typeof connect2 !== "object") {
          throw new InvalidArgumentError("connect must be a function or an object");
        }
        if (maxRequestsPerClient != null && (!Number.isInteger(maxRequestsPerClient) || maxRequestsPerClient < 0)) {
          throw new InvalidArgumentError("maxRequestsPerClient must be a positive number");
        }
        if (localAddress != null && (typeof localAddress !== "string" || net2.isIP(localAddress) === 0)) {
          throw new InvalidArgumentError("localAddress must be valid string IP address");
        }
        if (maxResponseSize != null && (!Number.isInteger(maxResponseSize) || maxResponseSize < -1)) {
          throw new InvalidArgumentError("maxResponseSize must be a positive number");
        }
        if (autoSelectFamilyAttemptTimeout != null && (!Number.isInteger(autoSelectFamilyAttemptTimeout) || autoSelectFamilyAttemptTimeout < -1)) {
          throw new InvalidArgumentError("autoSelectFamilyAttemptTimeout must be a positive number");
        }
        if (allowH2 != null && typeof allowH2 !== "boolean") {
          throw new InvalidArgumentError("allowH2 must be a valid boolean value");
        }
        if (maxConcurrentStreams != null && (typeof maxConcurrentStreams !== "number" || maxConcurrentStreams < 1)) {
          throw new InvalidArgumentError("maxConcurrentStreams must be a positive integer, greater than 0");
        }
        super();
        if (typeof connect2 !== "function") {
          connect2 = buildConnector({
            ...tls,
            maxCachedSessions,
            allowH2,
            socketPath,
            timeout: connectTimeout,
            ...typeof autoSelectFamily === "boolean" ? { autoSelectFamily, autoSelectFamilyAttemptTimeout } : void 0,
            ...connect2
          });
        }
        this[kUrl] = util3.parseOrigin(url4);
        this[kConnector] = connect2;
        this[kPipelining] = pipelining != null ? pipelining : 1;
        this[kMaxHeadersSize] = maxHeaderSize;
        this[kKeepAliveDefaultTimeout] = keepAliveTimeout == null ? 4e3 : keepAliveTimeout;
        this[kKeepAliveMaxTimeout] = keepAliveMaxTimeout == null ? 6e5 : keepAliveMaxTimeout;
        this[kKeepAliveTimeoutThreshold] = keepAliveTimeoutThreshold == null ? 2e3 : keepAliveTimeoutThreshold;
        this[kKeepAliveTimeoutValue] = this[kKeepAliveDefaultTimeout];
        this[kServerName] = null;
        this[kLocalAddress] = localAddress != null ? localAddress : null;
        this[kResuming] = 0;
        this[kNeedDrain] = 0;
        this[kHostHeader] = `host: ${this[kUrl].hostname}${this[kUrl].port ? `:${this[kUrl].port}` : ""}\r
`;
        this[kBodyTimeout] = bodyTimeout != null ? bodyTimeout : 3e5;
        this[kHeadersTimeout] = headersTimeout != null ? headersTimeout : 3e5;
        this[kStrictContentLength] = strictContentLength == null ? true : strictContentLength;
        this[kMaxRequests] = maxRequestsPerClient;
        this[kClosedResolve] = null;
        this[kMaxResponseSize] = maxResponseSize > -1 ? maxResponseSize : -1;
        this[kMaxConcurrentStreams] = maxConcurrentStreams != null ? maxConcurrentStreams : 100;
        this[kHTTPContext] = null;
        this[kQueue] = [];
        this[kRunningIdx] = 0;
        this[kPendingIdx] = 0;
        this[kResume] = (sync) => resume(this, sync);
        this[kOnError] = (err) => onError(this, err);
      }
      get pipelining() {
        return this[kPipelining];
      }
      set pipelining(value) {
        this[kPipelining] = value;
        this[kResume](true);
      }
      get stats() {
        return new ClientStats(this);
      }
      get [kPending]() {
        return this[kQueue].length - this[kPendingIdx];
      }
      get [kRunning]() {
        return this[kPendingIdx] - this[kRunningIdx];
      }
      get [kSize]() {
        return this[kQueue].length - this[kRunningIdx];
      }
      get [kConnected]() {
        return !!this[kHTTPContext] && !this[kConnecting] && !this[kHTTPContext].destroyed;
      }
      get [kBusy]() {
        return Boolean(
          this[kHTTPContext]?.busy(null) || this[kSize] >= (getPipelining(this) || 1) || this[kPending] > 0
        );
      }
      /* istanbul ignore: only used for test */
      [kConnect](cb2) {
        connect(this);
        this.once("connect", cb2);
      }
      [kDispatch](opts, handler) {
        const origin = opts.origin || this[kUrl].origin;
        const request4 = new Request7(origin, opts, handler);
        this[kQueue].push(request4);
        if (this[kResuming]) ; else if (util3.bodyLength(request4.body) == null && util3.isIterable(request4.body)) {
          this[kResuming] = 1;
          queueMicrotask(() => resume(this));
        } else {
          this[kResume](true);
        }
        if (this[kResuming] && this[kNeedDrain] !== 2 && this[kBusy]) {
          this[kNeedDrain] = 2;
        }
        return this[kNeedDrain] < 2;
      }
      async [kClose]() {
        return new Promise((resolve28) => {
          if (this[kSize]) {
            this[kClosedResolve] = resolve28;
          } else {
            resolve28(null);
          }
        });
      }
      async [kDestroy](err) {
        return new Promise((resolve28) => {
          const requests = this[kQueue].splice(this[kPendingIdx]);
          for (let i6 = 0; i6 < requests.length; i6++) {
            const request4 = requests[i6];
            util3.errorRequest(this, request4, err);
          }
          const callback = /* @__PURE__ */ __name(() => {
            if (this[kClosedResolve]) {
              this[kClosedResolve]();
              this[kClosedResolve] = null;
            }
            resolve28(null);
          }, "callback");
          if (this[kHTTPContext]) {
            this[kHTTPContext].destroy(err, callback);
            this[kHTTPContext] = null;
          } else {
            queueMicrotask(callback);
          }
          this[kResume]();
        });
      }
    };
    function onError(client, err) {
      if (client[kRunning] === 0 && err.code !== "UND_ERR_INFO" && err.code !== "UND_ERR_SOCKET") {
        assert48(client[kPendingIdx] === client[kRunningIdx]);
        const requests = client[kQueue].splice(client[kRunningIdx]);
        for (let i6 = 0; i6 < requests.length; i6++) {
          const request4 = requests[i6];
          util3.errorRequest(client, request4, err);
        }
        assert48(client[kSize] === 0);
      }
    }
    __name(onError, "onError");
    async function connect(client) {
      assert48(!client[kConnecting]);
      assert48(!client[kHTTPContext]);
      let { host, hostname: hostname2, protocol, port } = client[kUrl];
      if (hostname2[0] === "[") {
        const idx = hostname2.indexOf("]");
        assert48(idx !== -1);
        const ip = hostname2.substring(1, idx);
        assert48(net2.isIPv6(ip));
        hostname2 = ip;
      }
      client[kConnecting] = true;
      if (channels.beforeConnect.hasSubscribers) {
        channels.beforeConnect.publish({
          connectParams: {
            host,
            hostname: hostname2,
            protocol,
            port,
            version: client[kHTTPContext]?.version,
            servername: client[kServerName],
            localAddress: client[kLocalAddress]
          },
          connector: client[kConnector]
        });
      }
      try {
        const socket = await new Promise((resolve28, reject) => {
          client[kConnector]({
            host,
            hostname: hostname2,
            protocol,
            port,
            servername: client[kServerName],
            localAddress: client[kLocalAddress]
          }, (err, socket2) => {
            if (err) {
              reject(err);
            } else {
              resolve28(socket2);
            }
          });
        });
        if (client.destroyed) {
          util3.destroy(socket.on("error", noop), new ClientDestroyedError());
          return;
        }
        assert48(socket);
        try {
          client[kHTTPContext] = socket.alpnProtocol === "h2" ? await connectH2(client, socket) : await connectH1(client, socket);
        } catch (err) {
          socket.destroy().on("error", noop);
          throw err;
        }
        client[kConnecting] = false;
        socket[kCounter] = 0;
        socket[kMaxRequests] = client[kMaxRequests];
        socket[kClient] = client;
        socket[kError] = null;
        if (channels.connected.hasSubscribers) {
          channels.connected.publish({
            connectParams: {
              host,
              hostname: hostname2,
              protocol,
              port,
              version: client[kHTTPContext]?.version,
              servername: client[kServerName],
              localAddress: client[kLocalAddress]
            },
            connector: client[kConnector],
            socket
          });
        }
        client.emit("connect", client[kUrl], [client]);
      } catch (err) {
        if (client.destroyed) {
          return;
        }
        client[kConnecting] = false;
        if (channels.connectError.hasSubscribers) {
          channels.connectError.publish({
            connectParams: {
              host,
              hostname: hostname2,
              protocol,
              port,
              version: client[kHTTPContext]?.version,
              servername: client[kServerName],
              localAddress: client[kLocalAddress]
            },
            connector: client[kConnector],
            error: err
          });
        }
        if (err.code === "ERR_TLS_CERT_ALTNAME_INVALID") {
          assert48(client[kRunning] === 0);
          while (client[kPending] > 0 && client[kQueue][client[kPendingIdx]].servername === client[kServerName]) {
            const request4 = client[kQueue][client[kPendingIdx]++];
            util3.errorRequest(client, request4, err);
          }
        } else {
          onError(client, err);
        }
        client.emit("connectionError", client[kUrl], [client], err);
      }
      client[kResume]();
    }
    __name(connect, "connect");
    function emitDrain(client) {
      client[kNeedDrain] = 0;
      client.emit("drain", client[kUrl], [client]);
    }
    __name(emitDrain, "emitDrain");
    function resume(client, sync) {
      if (client[kResuming] === 2) {
        return;
      }
      client[kResuming] = 2;
      _resume(client, sync);
      client[kResuming] = 0;
      if (client[kRunningIdx] > 256) {
        client[kQueue].splice(0, client[kRunningIdx]);
        client[kPendingIdx] -= client[kRunningIdx];
        client[kRunningIdx] = 0;
      }
    }
    __name(resume, "resume");
    function _resume(client, sync) {
      while (true) {
        if (client.destroyed) {
          assert48(client[kPending] === 0);
          return;
        }
        if (client[kClosedResolve] && !client[kSize]) {
          client[kClosedResolve]();
          client[kClosedResolve] = null;
          return;
        }
        if (client[kHTTPContext]) {
          client[kHTTPContext].resume();
        }
        if (client[kBusy]) {
          client[kNeedDrain] = 2;
        } else if (client[kNeedDrain] === 2) {
          if (sync) {
            client[kNeedDrain] = 1;
            queueMicrotask(() => emitDrain(client));
          } else {
            emitDrain(client);
          }
          continue;
        }
        if (client[kPending] === 0) {
          return;
        }
        if (client[kRunning] >= (getPipelining(client) || 1)) {
          return;
        }
        const request4 = client[kQueue][client[kPendingIdx]];
        if (client[kUrl].protocol === "https:" && client[kServerName] !== request4.servername) {
          if (client[kRunning] > 0) {
            return;
          }
          client[kServerName] = request4.servername;
          client[kHTTPContext]?.destroy(new InformationalError("servername changed"), () => {
            client[kHTTPContext] = null;
            resume(client);
          });
        }
        if (client[kConnecting]) {
          return;
        }
        if (!client[kHTTPContext]) {
          connect(client);
          return;
        }
        if (client[kHTTPContext].destroyed) {
          return;
        }
        if (client[kHTTPContext].busy(request4)) {
          return;
        }
        if (!request4.aborted && client[kHTTPContext].write(request4)) {
          client[kPendingIdx]++;
        } else {
          client[kQueue].splice(client[kPendingIdx], 1);
        }
      }
    }
    __name(_resume, "_resume");
    module3.exports = Client2;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/fixed-queue.js
var require_fixed_queue = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/fixed-queue.js"(exports2, module3) {
    init_import_meta_url();
    var kSize = 2048;
    var kMask = kSize - 1;
    var FixedCircularBuffer = class {
      static {
        __name(this, "FixedCircularBuffer");
      }
      constructor() {
        this.bottom = 0;
        this.top = 0;
        this.list = new Array(kSize).fill(void 0);
        this.next = null;
      }
      /**
       * @returns {boolean}
       */
      isEmpty() {
        return this.top === this.bottom;
      }
      /**
       * @returns {boolean}
       */
      isFull() {
        return (this.top + 1 & kMask) === this.bottom;
      }
      /**
       * @param {T} data
       * @returns {void}
       */
      push(data) {
        this.list[this.top] = data;
        this.top = this.top + 1 & kMask;
      }
      /**
       * @returns {T|null}
       */
      shift() {
        const nextItem = this.list[this.bottom];
        if (nextItem === void 0) {
          return null;
        }
        this.list[this.bottom] = void 0;
        this.bottom = this.bottom + 1 & kMask;
        return nextItem;
      }
    };
    module3.exports = class FixedQueue {
      static {
        __name(this, "FixedQueue");
      }
      constructor() {
        this.head = this.tail = new FixedCircularBuffer();
      }
      /**
       * @returns {boolean}
       */
      isEmpty() {
        return this.head.isEmpty();
      }
      /**
       * @param {T} data
       */
      push(data) {
        if (this.head.isFull()) {
          this.head = this.head.next = new FixedCircularBuffer();
        }
        this.head.push(data);
      }
      /**
       * @returns {T|null}
       */
      shift() {
        const tail = this.tail;
        const next = tail.shift();
        if (tail.isEmpty() && tail.next !== null) {
          this.tail = tail.next;
          tail.next = null;
        }
        return next;
      }
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/pool-base.js
var require_pool_base = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/pool-base.js"(exports2, module3) {
    init_import_meta_url();
    var { PoolStats } = require_stats();
    var DispatcherBase = require_dispatcher_base();
    var FixedQueue = require_fixed_queue();
    var { kConnected, kSize, kRunning, kPending, kQueued, kBusy, kFree, kUrl, kClose, kDestroy, kDispatch } = require_symbols();
    var kClients = Symbol("clients");
    var kNeedDrain = Symbol("needDrain");
    var kQueue = Symbol("queue");
    var kClosedResolve = Symbol("closed resolve");
    var kOnDrain = Symbol("onDrain");
    var kOnConnect = Symbol("onConnect");
    var kOnDisconnect = Symbol("onDisconnect");
    var kOnConnectionError = Symbol("onConnectionError");
    var kGetDispatcher = Symbol("get dispatcher");
    var kAddClient = Symbol("add client");
    var kRemoveClient = Symbol("remove client");
    var PoolBase = class extends DispatcherBase {
      static {
        __name(this, "PoolBase");
      }
      constructor() {
        super();
        this[kQueue] = new FixedQueue();
        this[kClients] = [];
        this[kQueued] = 0;
        const pool = this;
        this[kOnDrain] = /* @__PURE__ */ __name(function onDrain(origin, targets) {
          const queue = pool[kQueue];
          let needDrain = false;
          while (!needDrain) {
            const item = queue.shift();
            if (!item) {
              break;
            }
            pool[kQueued]--;
            needDrain = !this.dispatch(item.opts, item.handler);
          }
          this[kNeedDrain] = needDrain;
          if (!this[kNeedDrain] && pool[kNeedDrain]) {
            pool[kNeedDrain] = false;
            pool.emit("drain", origin, [pool, ...targets]);
          }
          if (pool[kClosedResolve] && queue.isEmpty()) {
            Promise.all(pool[kClients].map((c7) => c7.close())).then(pool[kClosedResolve]);
          }
        }, "onDrain");
        this[kOnConnect] = (origin, targets) => {
          pool.emit("connect", origin, [pool, ...targets]);
        };
        this[kOnDisconnect] = (origin, targets, err) => {
          pool.emit("disconnect", origin, [pool, ...targets], err);
        };
        this[kOnConnectionError] = (origin, targets, err) => {
          pool.emit("connectionError", origin, [pool, ...targets], err);
        };
      }
      get [kBusy]() {
        return this[kNeedDrain];
      }
      get [kConnected]() {
        return this[kClients].filter((client) => client[kConnected]).length;
      }
      get [kFree]() {
        return this[kClients].filter((client) => client[kConnected] && !client[kNeedDrain]).length;
      }
      get [kPending]() {
        let ret = this[kQueued];
        for (const { [kPending]: pending } of this[kClients]) {
          ret += pending;
        }
        return ret;
      }
      get [kRunning]() {
        let ret = 0;
        for (const { [kRunning]: running } of this[kClients]) {
          ret += running;
        }
        return ret;
      }
      get [kSize]() {
        let ret = this[kQueued];
        for (const { [kSize]: size } of this[kClients]) {
          ret += size;
        }
        return ret;
      }
      get stats() {
        return new PoolStats(this);
      }
      async [kClose]() {
        if (this[kQueue].isEmpty()) {
          await Promise.all(this[kClients].map((c7) => c7.close()));
        } else {
          await new Promise((resolve28) => {
            this[kClosedResolve] = resolve28;
          });
        }
      }
      async [kDestroy](err) {
        while (true) {
          const item = this[kQueue].shift();
          if (!item) {
            break;
          }
          item.handler.onError(err);
        }
        await Promise.all(this[kClients].map((c7) => c7.destroy(err)));
      }
      [kDispatch](opts, handler) {
        const dispatcher = this[kGetDispatcher]();
        if (!dispatcher) {
          this[kNeedDrain] = true;
          this[kQueue].push({ opts, handler });
          this[kQueued]++;
        } else if (!dispatcher.dispatch(opts, handler)) {
          dispatcher[kNeedDrain] = true;
          this[kNeedDrain] = !this[kGetDispatcher]();
        }
        return !this[kNeedDrain];
      }
      [kAddClient](client) {
        client.on("drain", this[kOnDrain]).on("connect", this[kOnConnect]).on("disconnect", this[kOnDisconnect]).on("connectionError", this[kOnConnectionError]);
        this[kClients].push(client);
        if (this[kNeedDrain]) {
          queueMicrotask(() => {
            if (this[kNeedDrain]) {
              this[kOnDrain](client[kUrl], [this, client]);
            }
          });
        }
        return this;
      }
      [kRemoveClient](client) {
        client.close(() => {
          const idx = this[kClients].indexOf(client);
          if (idx !== -1) {
            this[kClients].splice(idx, 1);
          }
        });
        this[kNeedDrain] = this[kClients].some((dispatcher) => !dispatcher[kNeedDrain] && dispatcher.closed !== true && dispatcher.destroyed !== true);
      }
    };
    module3.exports = {
      PoolBase,
      kClients,
      kNeedDrain,
      kAddClient,
      kRemoveClient,
      kGetDispatcher
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/pool.js
var require_pool = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/pool.js"(exports2, module3) {
    init_import_meta_url();
    var {
      PoolBase,
      kClients,
      kNeedDrain,
      kAddClient,
      kGetDispatcher,
      kRemoveClient
    } = require_pool_base();
    var Client2 = require_client();
    var {
      InvalidArgumentError
    } = require_errors();
    var util3 = require_util();
    var { kUrl } = require_symbols();
    var buildConnector = require_connect();
    var kOptions = Symbol("options");
    var kConnections = Symbol("connections");
    var kFactory = Symbol("factory");
    function defaultFactory(origin, opts) {
      return new Client2(origin, opts);
    }
    __name(defaultFactory, "defaultFactory");
    var Pool = class extends PoolBase {
      static {
        __name(this, "Pool");
      }
      constructor(origin, {
        connections,
        factory = defaultFactory,
        connect,
        connectTimeout,
        tls,
        maxCachedSessions,
        socketPath,
        autoSelectFamily,
        autoSelectFamilyAttemptTimeout,
        allowH2,
        clientTtl,
        ...options
      } = {}) {
        if (connections != null && (!Number.isFinite(connections) || connections < 0)) {
          throw new InvalidArgumentError("invalid connections");
        }
        if (typeof factory !== "function") {
          throw new InvalidArgumentError("factory must be a function.");
        }
        if (connect != null && typeof connect !== "function" && typeof connect !== "object") {
          throw new InvalidArgumentError("connect must be a function or an object");
        }
        super();
        if (typeof connect !== "function") {
          connect = buildConnector({
            ...tls,
            maxCachedSessions,
            allowH2,
            socketPath,
            timeout: connectTimeout,
            ...typeof autoSelectFamily === "boolean" ? { autoSelectFamily, autoSelectFamilyAttemptTimeout } : void 0,
            ...connect
          });
        }
        this[kConnections] = connections || null;
        this[kUrl] = util3.parseOrigin(origin);
        this[kOptions] = { ...util3.deepClone(options), connect, allowH2, clientTtl };
        this[kOptions].interceptors = options.interceptors ? { ...options.interceptors } : void 0;
        this[kFactory] = factory;
        this.on("connect", (origin2, targets) => {
          if (clientTtl != null && clientTtl > 0) {
            for (const target of targets) {
              Object.assign(target, { ttl: Date.now() });
            }
          }
        });
        this.on("connectionError", (origin2, targets, error2) => {
          for (const target of targets) {
            const idx = this[kClients].indexOf(target);
            if (idx !== -1) {
              this[kClients].splice(idx, 1);
            }
          }
        });
      }
      [kGetDispatcher]() {
        const clientTtlOption = this[kOptions].clientTtl;
        for (const client of this[kClients]) {
          if (clientTtlOption != null && clientTtlOption > 0 && client.ttl && Date.now() - client.ttl > clientTtlOption) {
            this[kRemoveClient](client);
          } else if (!client[kNeedDrain]) {
            return client;
          }
        }
        if (!this[kConnections] || this[kClients].length < this[kConnections]) {
          const dispatcher = this[kFactory](this[kUrl], this[kOptions]);
          this[kAddClient](dispatcher);
          return dispatcher;
        }
      }
    };
    module3.exports = Pool;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/balanced-pool.js
var require_balanced_pool = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/balanced-pool.js"(exports2, module3) {
    init_import_meta_url();
    var {
      BalancedPoolMissingUpstreamError,
      InvalidArgumentError
    } = require_errors();
    var {
      PoolBase,
      kClients,
      kNeedDrain,
      kAddClient,
      kRemoveClient,
      kGetDispatcher
    } = require_pool_base();
    var Pool = require_pool();
    var { kUrl } = require_symbols();
    var { parseOrigin } = require_util();
    var kFactory = Symbol("factory");
    var kOptions = Symbol("options");
    var kGreatestCommonDivisor = Symbol("kGreatestCommonDivisor");
    var kCurrentWeight = Symbol("kCurrentWeight");
    var kIndex = Symbol("kIndex");
    var kWeight = Symbol("kWeight");
    var kMaxWeightPerServer = Symbol("kMaxWeightPerServer");
    var kErrorPenalty = Symbol("kErrorPenalty");
    function getGreatestCommonDivisor(a6, b7) {
      if (a6 === 0) return b7;
      while (b7 !== 0) {
        const t8 = b7;
        b7 = a6 % b7;
        a6 = t8;
      }
      return a6;
    }
    __name(getGreatestCommonDivisor, "getGreatestCommonDivisor");
    function defaultFactory(origin, opts) {
      return new Pool(origin, opts);
    }
    __name(defaultFactory, "defaultFactory");
    var BalancedPool = class extends PoolBase {
      static {
        __name(this, "BalancedPool");
      }
      constructor(upstreams = [], { factory = defaultFactory, ...opts } = {}) {
        if (typeof factory !== "function") {
          throw new InvalidArgumentError("factory must be a function.");
        }
        super();
        this[kOptions] = opts;
        this[kIndex] = -1;
        this[kCurrentWeight] = 0;
        this[kMaxWeightPerServer] = this[kOptions].maxWeightPerServer || 100;
        this[kErrorPenalty] = this[kOptions].errorPenalty || 15;
        if (!Array.isArray(upstreams)) {
          upstreams = [upstreams];
        }
        this[kFactory] = factory;
        for (const upstream of upstreams) {
          this.addUpstream(upstream);
        }
        this._updateBalancedPoolStats();
      }
      addUpstream(upstream) {
        const upstreamOrigin = parseOrigin(upstream).origin;
        if (this[kClients].find((pool2) => pool2[kUrl].origin === upstreamOrigin && pool2.closed !== true && pool2.destroyed !== true)) {
          return this;
        }
        const pool = this[kFactory](upstreamOrigin, Object.assign({}, this[kOptions]));
        this[kAddClient](pool);
        pool.on("connect", () => {
          pool[kWeight] = Math.min(this[kMaxWeightPerServer], pool[kWeight] + this[kErrorPenalty]);
        });
        pool.on("connectionError", () => {
          pool[kWeight] = Math.max(1, pool[kWeight] - this[kErrorPenalty]);
          this._updateBalancedPoolStats();
        });
        pool.on("disconnect", (...args) => {
          const err = args[2];
          if (err && err.code === "UND_ERR_SOCKET") {
            pool[kWeight] = Math.max(1, pool[kWeight] - this[kErrorPenalty]);
            this._updateBalancedPoolStats();
          }
        });
        for (const client of this[kClients]) {
          client[kWeight] = this[kMaxWeightPerServer];
        }
        this._updateBalancedPoolStats();
        return this;
      }
      _updateBalancedPoolStats() {
        let result = 0;
        for (let i6 = 0; i6 < this[kClients].length; i6++) {
          result = getGreatestCommonDivisor(this[kClients][i6][kWeight], result);
        }
        this[kGreatestCommonDivisor] = result;
      }
      removeUpstream(upstream) {
        const upstreamOrigin = parseOrigin(upstream).origin;
        const pool = this[kClients].find((pool2) => pool2[kUrl].origin === upstreamOrigin && pool2.closed !== true && pool2.destroyed !== true);
        if (pool) {
          this[kRemoveClient](pool);
        }
        return this;
      }
      get upstreams() {
        return this[kClients].filter((dispatcher) => dispatcher.closed !== true && dispatcher.destroyed !== true).map((p7) => p7[kUrl].origin);
      }
      [kGetDispatcher]() {
        if (this[kClients].length === 0) {
          throw new BalancedPoolMissingUpstreamError();
        }
        const dispatcher = this[kClients].find((dispatcher2) => !dispatcher2[kNeedDrain] && dispatcher2.closed !== true && dispatcher2.destroyed !== true);
        if (!dispatcher) {
          return;
        }
        const allClientsBusy = this[kClients].map((pool) => pool[kNeedDrain]).reduce((a6, b7) => a6 && b7, true);
        if (allClientsBusy) {
          return;
        }
        let counter = 0;
        let maxWeightIndex = this[kClients].findIndex((pool) => !pool[kNeedDrain]);
        while (counter++ < this[kClients].length) {
          this[kIndex] = (this[kIndex] + 1) % this[kClients].length;
          const pool = this[kClients][this[kIndex]];
          if (pool[kWeight] > this[kClients][maxWeightIndex][kWeight] && !pool[kNeedDrain]) {
            maxWeightIndex = this[kIndex];
          }
          if (this[kIndex] === 0) {
            this[kCurrentWeight] = this[kCurrentWeight] - this[kGreatestCommonDivisor];
            if (this[kCurrentWeight] <= 0) {
              this[kCurrentWeight] = this[kMaxWeightPerServer];
            }
          }
          if (pool[kWeight] >= this[kCurrentWeight] && !pool[kNeedDrain]) {
            return pool;
          }
        }
        this[kCurrentWeight] = this[kClients][maxWeightIndex][kWeight];
        this[kIndex] = maxWeightIndex;
        return this[kClients][maxWeightIndex];
      }
    };
    module3.exports = BalancedPool;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/agent.js
var require_agent = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/agent.js"(exports2, module3) {
    init_import_meta_url();
    var { InvalidArgumentError } = require_errors();
    var { kClients, kRunning, kClose, kDestroy, kDispatch, kUrl } = require_symbols();
    var DispatcherBase = require_dispatcher_base();
    var Pool = require_pool();
    var Client2 = require_client();
    var util3 = require_util();
    var kOnConnect = Symbol("onConnect");
    var kOnDisconnect = Symbol("onDisconnect");
    var kOnConnectionError = Symbol("onConnectionError");
    var kOnDrain = Symbol("onDrain");
    var kFactory = Symbol("factory");
    var kOptions = Symbol("options");
    function defaultFactory(origin, opts) {
      return opts && opts.connections === 1 ? new Client2(origin, opts) : new Pool(origin, opts);
    }
    __name(defaultFactory, "defaultFactory");
    var Agent = class extends DispatcherBase {
      static {
        __name(this, "Agent");
      }
      constructor({ factory = defaultFactory, connect, ...options } = {}) {
        if (typeof factory !== "function") {
          throw new InvalidArgumentError("factory must be a function.");
        }
        if (connect != null && typeof connect !== "function" && typeof connect !== "object") {
          throw new InvalidArgumentError("connect must be a function or an object");
        }
        super();
        if (connect && typeof connect !== "function") {
          connect = { ...connect };
        }
        this[kOptions] = { ...util3.deepClone(options), connect };
        this[kFactory] = factory;
        this[kClients] = /* @__PURE__ */ new Map();
        this[kOnDrain] = (origin, targets) => {
          this.emit("drain", origin, [this, ...targets]);
        };
        this[kOnConnect] = (origin, targets) => {
          const result = this[kClients].get(origin);
          if (result) {
            result.count += 1;
          }
          this.emit("connect", origin, [this, ...targets]);
        };
        this[kOnDisconnect] = (origin, targets, err) => {
          const result = this[kClients].get(origin);
          if (result) {
            result.count -= 1;
            if (result.count <= 0) {
              this[kClients].delete(origin);
              result.dispatcher.destroy();
            }
          }
          this.emit("disconnect", origin, [this, ...targets], err);
        };
        this[kOnConnectionError] = (origin, targets, err) => {
          this.emit("connectionError", origin, [this, ...targets], err);
        };
      }
      get [kRunning]() {
        let ret = 0;
        for (const { dispatcher } of this[kClients].values()) {
          ret += dispatcher[kRunning];
        }
        return ret;
      }
      [kDispatch](opts, handler) {
        let key;
        if (opts.origin && (typeof opts.origin === "string" || opts.origin instanceof URL)) {
          key = String(opts.origin);
        } else {
          throw new InvalidArgumentError("opts.origin must be a non-empty string or URL.");
        }
        const result = this[kClients].get(key);
        let dispatcher = result && result.dispatcher;
        if (!dispatcher) {
          dispatcher = this[kFactory](opts.origin, this[kOptions]).on("drain", this[kOnDrain]).on("connect", this[kOnConnect]).on("disconnect", this[kOnDisconnect]).on("connectionError", this[kOnConnectionError]);
          this[kClients].set(key, { count: 0, dispatcher });
        }
        return dispatcher.dispatch(opts, handler);
      }
      async [kClose]() {
        const closePromises = [];
        for (const { dispatcher } of this[kClients].values()) {
          closePromises.push(dispatcher.close());
        }
        this[kClients].clear();
        await Promise.all(closePromises);
      }
      async [kDestroy](err) {
        const destroyPromises = [];
        for (const { dispatcher } of this[kClients].values()) {
          destroyPromises.push(dispatcher.destroy(err));
        }
        this[kClients].clear();
        await Promise.all(destroyPromises);
      }
      get stats() {
        const allClientStats = {};
        for (const { dispatcher } of this[kClients].values()) {
          if (dispatcher.stats) {
            allClientStats[dispatcher[kUrl].origin] = dispatcher.stats;
          }
        }
        return allClientStats;
      }
    };
    module3.exports = Agent;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/proxy-agent.js
var require_proxy_agent = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/proxy-agent.js"(exports2, module3) {
    init_import_meta_url();
    var { kProxy, kClose, kDestroy, kDispatch } = require_symbols();
    var Agent = require_agent();
    var Pool = require_pool();
    var DispatcherBase = require_dispatcher_base();
    var { InvalidArgumentError, RequestAbortedError, SecureProxyConnectionError } = require_errors();
    var buildConnector = require_connect();
    var Client2 = require_client();
    var kAgent = Symbol("proxy agent");
    var kClient = Symbol("proxy client");
    var kProxyHeaders = Symbol("proxy headers");
    var kRequestTls = Symbol("request tls settings");
    var kProxyTls = Symbol("proxy tls settings");
    var kConnectEndpoint = Symbol("connect endpoint function");
    var kTunnelProxy = Symbol("tunnel proxy");
    function defaultProtocolPort(protocol) {
      return protocol === "https:" ? 443 : 80;
    }
    __name(defaultProtocolPort, "defaultProtocolPort");
    function defaultFactory(origin, opts) {
      return new Pool(origin, opts);
    }
    __name(defaultFactory, "defaultFactory");
    var noop = /* @__PURE__ */ __name(() => {
    }, "noop");
    function defaultAgentFactory(origin, opts) {
      if (opts.connections === 1) {
        return new Client2(origin, opts);
      }
      return new Pool(origin, opts);
    }
    __name(defaultAgentFactory, "defaultAgentFactory");
    var Http1ProxyWrapper = class extends DispatcherBase {
      static {
        __name(this, "Http1ProxyWrapper");
      }
      #client;
      constructor(proxyUrl, { headers = {}, connect, factory }) {
        super();
        if (!proxyUrl) {
          throw new InvalidArgumentError("Proxy URL is mandatory");
        }
        this[kProxyHeaders] = headers;
        if (factory) {
          this.#client = factory(proxyUrl, { connect });
        } else {
          this.#client = new Client2(proxyUrl, { connect });
        }
      }
      [kDispatch](opts, handler) {
        const onHeaders = handler.onHeaders;
        handler.onHeaders = function(statusCode, data, resume) {
          if (statusCode === 407) {
            if (typeof handler.onError === "function") {
              handler.onError(new InvalidArgumentError("Proxy Authentication Required (407)"));
            }
            return;
          }
          if (onHeaders) onHeaders.call(this, statusCode, data, resume);
        };
        const {
          origin,
          path: path77 = "/",
          headers = {}
        } = opts;
        opts.path = origin + path77;
        if (!("host" in headers) && !("Host" in headers)) {
          const { host } = new URL(origin);
          headers.host = host;
        }
        opts.headers = { ...this[kProxyHeaders], ...headers };
        return this.#client[kDispatch](opts, handler);
      }
      async [kClose]() {
        return this.#client.close();
      }
      async [kDestroy](err) {
        return this.#client.destroy(err);
      }
    };
    var ProxyAgent2 = class extends DispatcherBase {
      static {
        __name(this, "ProxyAgent");
      }
      constructor(opts) {
        if (!opts || typeof opts === "object" && !(opts instanceof URL) && !opts.uri) {
          throw new InvalidArgumentError("Proxy uri is mandatory");
        }
        const { clientFactory = defaultFactory } = opts;
        if (typeof clientFactory !== "function") {
          throw new InvalidArgumentError("Proxy opts.clientFactory must be a function.");
        }
        const { proxyTunnel = true } = opts;
        super();
        const url4 = this.#getUrl(opts);
        const { href, origin, port, protocol, username, password, hostname: proxyHostname } = url4;
        this[kProxy] = { uri: href, protocol };
        this[kRequestTls] = opts.requestTls;
        this[kProxyTls] = opts.proxyTls;
        this[kProxyHeaders] = opts.headers || {};
        this[kTunnelProxy] = proxyTunnel;
        if (opts.auth && opts.token) {
          throw new InvalidArgumentError("opts.auth cannot be used in combination with opts.token");
        } else if (opts.auth) {
          this[kProxyHeaders]["proxy-authorization"] = `Basic ${opts.auth}`;
        } else if (opts.token) {
          this[kProxyHeaders]["proxy-authorization"] = opts.token;
        } else if (username && password) {
          this[kProxyHeaders]["proxy-authorization"] = `Basic ${Buffer.from(`${decodeURIComponent(username)}:${decodeURIComponent(password)}`).toString("base64")}`;
        }
        const connect = buildConnector({ ...opts.proxyTls });
        this[kConnectEndpoint] = buildConnector({ ...opts.requestTls });
        const agentFactory = opts.factory || defaultAgentFactory;
        const factory = /* @__PURE__ */ __name((origin2, options) => {
          const { protocol: protocol2 } = new URL(origin2);
          if (!this[kTunnelProxy] && protocol2 === "http:" && this[kProxy].protocol === "http:") {
            return new Http1ProxyWrapper(this[kProxy].uri, {
              headers: this[kProxyHeaders],
              connect,
              factory: agentFactory
            });
          }
          return agentFactory(origin2, options);
        }, "factory");
        this[kClient] = clientFactory(url4, { connect });
        this[kAgent] = new Agent({
          ...opts,
          factory,
          connect: /* @__PURE__ */ __name(async (opts2, callback) => {
            let requestedPath = opts2.host;
            if (!opts2.port) {
              requestedPath += `:${defaultProtocolPort(opts2.protocol)}`;
            }
            try {
              const { socket, statusCode } = await this[kClient].connect({
                origin,
                port,
                path: requestedPath,
                signal: opts2.signal,
                headers: {
                  ...this[kProxyHeaders],
                  host: opts2.host,
                  ...opts2.connections == null || opts2.connections > 0 ? { "proxy-connection": "keep-alive" } : {}
                },
                servername: this[kProxyTls]?.servername || proxyHostname
              });
              if (statusCode !== 200) {
                socket.on("error", noop).destroy();
                callback(new RequestAbortedError(`Proxy response (${statusCode}) !== 200 when HTTP Tunneling`));
              }
              if (opts2.protocol !== "https:") {
                callback(null, socket);
                return;
              }
              let servername;
              if (this[kRequestTls]) {
                servername = this[kRequestTls].servername;
              } else {
                servername = opts2.servername;
              }
              this[kConnectEndpoint]({ ...opts2, servername, httpSocket: socket }, callback);
            } catch (err) {
              if (err.code === "ERR_TLS_CERT_ALTNAME_INVALID") {
                callback(new SecureProxyConnectionError(err));
              } else {
                callback(err);
              }
            }
          }, "connect")
        });
      }
      dispatch(opts, handler) {
        const headers = buildHeaders(opts.headers);
        throwIfProxyAuthIsSent(headers);
        if (headers && !("host" in headers) && !("Host" in headers)) {
          const { host } = new URL(opts.origin);
          headers.host = host;
        }
        return this[kAgent].dispatch(
          {
            ...opts,
            headers
          },
          handler
        );
      }
      /**
       * @param {import('../../types/proxy-agent').ProxyAgent.Options | string | URL} opts
       * @returns {URL}
       */
      #getUrl(opts) {
        if (typeof opts === "string") {
          return new URL(opts);
        } else if (opts instanceof URL) {
          return opts;
        } else {
          return new URL(opts.uri);
        }
      }
      async [kClose]() {
        await this[kAgent].close();
        await this[kClient].close();
      }
      async [kDestroy]() {
        await this[kAgent].destroy();
        await this[kClient].destroy();
      }
    };
    function buildHeaders(headers) {
      if (Array.isArray(headers)) {
        const headersPair = {};
        for (let i6 = 0; i6 < headers.length; i6 += 2) {
          headersPair[headers[i6]] = headers[i6 + 1];
        }
        return headersPair;
      }
      return headers;
    }
    __name(buildHeaders, "buildHeaders");
    function throwIfProxyAuthIsSent(headers) {
      const existProxyAuth = headers && Object.keys(headers).find((key) => key.toLowerCase() === "proxy-authorization");
      if (existProxyAuth) {
        throw new InvalidArgumentError("Proxy-Authorization should be sent in ProxyAgent constructor");
      }
    }
    __name(throwIfProxyAuthIsSent, "throwIfProxyAuthIsSent");
    module3.exports = ProxyAgent2;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/env-http-proxy-agent.js
var require_env_http_proxy_agent = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/env-http-proxy-agent.js"(exports2, module3) {
    init_import_meta_url();
    var DispatcherBase = require_dispatcher_base();
    var { kClose, kDestroy, kClosed, kDestroyed, kDispatch, kNoProxyAgent, kHttpProxyAgent, kHttpsProxyAgent } = require_symbols();
    var ProxyAgent2 = require_proxy_agent();
    var Agent = require_agent();
    var DEFAULT_PORTS2 = {
      "http:": 80,
      "https:": 443
    };
    var EnvHttpProxyAgent = class extends DispatcherBase {
      static {
        __name(this, "EnvHttpProxyAgent");
      }
      #noProxyValue = null;
      #noProxyEntries = null;
      #opts = null;
      constructor(opts = {}) {
        super();
        this.#opts = opts;
        const { httpProxy, httpsProxy, noProxy, ...agentOpts } = opts;
        this[kNoProxyAgent] = new Agent(agentOpts);
        const HTTP_PROXY = httpProxy ?? process.env.http_proxy ?? process.env.HTTP_PROXY;
        if (HTTP_PROXY) {
          this[kHttpProxyAgent] = new ProxyAgent2({ ...agentOpts, uri: HTTP_PROXY });
        } else {
          this[kHttpProxyAgent] = this[kNoProxyAgent];
        }
        const HTTPS_PROXY = httpsProxy ?? process.env.https_proxy ?? process.env.HTTPS_PROXY;
        if (HTTPS_PROXY) {
          this[kHttpsProxyAgent] = new ProxyAgent2({ ...agentOpts, uri: HTTPS_PROXY });
        } else {
          this[kHttpsProxyAgent] = this[kHttpProxyAgent];
        }
        this.#parseNoProxy();
      }
      [kDispatch](opts, handler) {
        const url4 = new URL(opts.origin);
        const agent = this.#getProxyAgentForUrl(url4);
        return agent.dispatch(opts, handler);
      }
      async [kClose]() {
        await this[kNoProxyAgent].close();
        if (!this[kHttpProxyAgent][kClosed]) {
          await this[kHttpProxyAgent].close();
        }
        if (!this[kHttpsProxyAgent][kClosed]) {
          await this[kHttpsProxyAgent].close();
        }
      }
      async [kDestroy](err) {
        await this[kNoProxyAgent].destroy(err);
        if (!this[kHttpProxyAgent][kDestroyed]) {
          await this[kHttpProxyAgent].destroy(err);
        }
        if (!this[kHttpsProxyAgent][kDestroyed]) {
          await this[kHttpsProxyAgent].destroy(err);
        }
      }
      #getProxyAgentForUrl(url4) {
        let { protocol, host: hostname2, port } = url4;
        hostname2 = hostname2.replace(/:\d*$/, "").toLowerCase();
        port = Number.parseInt(port, 10) || DEFAULT_PORTS2[protocol] || 0;
        if (!this.#shouldProxy(hostname2, port)) {
          return this[kNoProxyAgent];
        }
        if (protocol === "https:") {
          return this[kHttpsProxyAgent];
        }
        return this[kHttpProxyAgent];
      }
      #shouldProxy(hostname2, port) {
        if (this.#noProxyChanged) {
          this.#parseNoProxy();
        }
        if (this.#noProxyEntries.length === 0) {
          return true;
        }
        if (this.#noProxyValue === "*") {
          return false;
        }
        for (let i6 = 0; i6 < this.#noProxyEntries.length; i6++) {
          const entry = this.#noProxyEntries[i6];
          if (entry.port && entry.port !== port) {
            continue;
          }
          if (!/^[.*]/.test(entry.hostname)) {
            if (hostname2 === entry.hostname) {
              return false;
            }
          } else {
            if (hostname2.endsWith(entry.hostname.replace(/^\*/, ""))) {
              return false;
            }
          }
        }
        return true;
      }
      #parseNoProxy() {
        const noProxyValue = this.#opts.noProxy ?? this.#noProxyEnv;
        const noProxySplit = noProxyValue.split(/[,\s]/);
        const noProxyEntries = [];
        for (let i6 = 0; i6 < noProxySplit.length; i6++) {
          const entry = noProxySplit[i6];
          if (!entry) {
            continue;
          }
          const parsed = entry.match(/^(.+):(\d+)$/);
          noProxyEntries.push({
            hostname: (parsed ? parsed[1] : entry).toLowerCase(),
            port: parsed ? Number.parseInt(parsed[2], 10) : 0
          });
        }
        this.#noProxyValue = noProxyValue;
        this.#noProxyEntries = noProxyEntries;
      }
      get #noProxyChanged() {
        if (this.#opts.noProxy !== void 0) {
          return false;
        }
        return this.#noProxyValue !== this.#noProxyEnv;
      }
      get #noProxyEnv() {
        return process.env.no_proxy ?? process.env.NO_PROXY ?? "";
      }
    };
    module3.exports = EnvHttpProxyAgent;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/retry-handler.js
var require_retry_handler = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/retry-handler.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var { kRetryHandlerDefaultRetry } = require_symbols();
    var { RequestRetryError } = require_errors();
    var WrapHandler = require_wrap_handler();
    var {
      isDisturbed,
      parseRangeHeader,
      wrapRequestBody
    } = require_util();
    function calculateRetryAfterHeader(retryAfter) {
      const retryTime = new Date(retryAfter).getTime();
      return isNaN(retryTime) ? 0 : retryTime - Date.now();
    }
    __name(calculateRetryAfterHeader, "calculateRetryAfterHeader");
    var RetryHandler = class _RetryHandler {
      static {
        __name(this, "RetryHandler");
      }
      constructor(opts, { dispatch, handler }) {
        const { retryOptions, ...dispatchOpts } = opts;
        const {
          // Retry scoped
          retry: retryFn,
          maxRetries,
          maxTimeout,
          minTimeout,
          timeoutFactor,
          // Response scoped
          methods,
          errorCodes,
          retryAfter,
          statusCodes,
          throwOnError
        } = retryOptions ?? {};
        this.error = null;
        this.dispatch = dispatch;
        this.handler = WrapHandler.wrap(handler);
        this.opts = { ...dispatchOpts, body: wrapRequestBody(opts.body) };
        this.retryOpts = {
          throwOnError: throwOnError ?? true,
          retry: retryFn ?? _RetryHandler[kRetryHandlerDefaultRetry],
          retryAfter: retryAfter ?? true,
          maxTimeout: maxTimeout ?? 30 * 1e3,
          // 30s,
          minTimeout: minTimeout ?? 500,
          // .5s
          timeoutFactor: timeoutFactor ?? 2,
          maxRetries: maxRetries ?? 5,
          // What errors we should retry
          methods: methods ?? ["GET", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"],
          // Indicates which errors to retry
          statusCodes: statusCodes ?? [500, 502, 503, 504, 429],
          // List of errors to retry
          errorCodes: errorCodes ?? [
            "ECONNRESET",
            "ECONNREFUSED",
            "ENOTFOUND",
            "ENETDOWN",
            "ENETUNREACH",
            "EHOSTDOWN",
            "EHOSTUNREACH",
            "EPIPE",
            "UND_ERR_SOCKET"
          ]
        };
        this.retryCount = 0;
        this.retryCountCheckpoint = 0;
        this.headersSent = false;
        this.start = 0;
        this.end = null;
        this.etag = null;
      }
      onResponseStartWithRetry(controller, statusCode, headers, statusMessage, err) {
        if (this.retryOpts.throwOnError) {
          if (this.retryOpts.statusCodes.includes(statusCode) === false) {
            this.headersSent = true;
            this.handler.onResponseStart?.(controller, statusCode, headers, statusMessage);
          } else {
            this.error = err;
          }
          return;
        }
        if (isDisturbed(this.opts.body)) {
          this.headersSent = true;
          this.handler.onResponseStart?.(controller, statusCode, headers, statusMessage);
          return;
        }
        function shouldRetry(passedErr) {
          if (passedErr) {
            this.headersSent = true;
            this.headersSent = true;
            this.handler.onResponseStart?.(controller, statusCode, headers, statusMessage);
            controller.resume();
            return;
          }
          this.error = err;
          controller.resume();
        }
        __name(shouldRetry, "shouldRetry");
        controller.pause();
        this.retryOpts.retry(
          err,
          {
            state: { counter: this.retryCount },
            opts: { retryOptions: this.retryOpts, ...this.opts }
          },
          shouldRetry.bind(this)
        );
      }
      onRequestStart(controller, context2) {
        if (!this.headersSent) {
          this.handler.onRequestStart?.(controller, context2);
        }
      }
      onRequestUpgrade(controller, statusCode, headers, socket) {
        this.handler.onRequestUpgrade?.(controller, statusCode, headers, socket);
      }
      static [kRetryHandlerDefaultRetry](err, { state: state2, opts }, cb2) {
        const { statusCode, code, headers } = err;
        const { method, retryOptions } = opts;
        const {
          maxRetries,
          minTimeout,
          maxTimeout,
          timeoutFactor,
          statusCodes,
          errorCodes,
          methods
        } = retryOptions;
        const { counter } = state2;
        if (code && code !== "UND_ERR_REQ_RETRY" && !errorCodes.includes(code)) {
          cb2(err);
          return;
        }
        if (Array.isArray(methods) && !methods.includes(method)) {
          cb2(err);
          return;
        }
        if (statusCode != null && Array.isArray(statusCodes) && !statusCodes.includes(statusCode)) {
          cb2(err);
          return;
        }
        if (counter > maxRetries) {
          cb2(err);
          return;
        }
        let retryAfterHeader = headers?.["retry-after"];
        if (retryAfterHeader) {
          retryAfterHeader = Number(retryAfterHeader);
          retryAfterHeader = Number.isNaN(retryAfterHeader) ? calculateRetryAfterHeader(headers["retry-after"]) : retryAfterHeader * 1e3;
        }
        const retryTimeout = retryAfterHeader > 0 ? Math.min(retryAfterHeader, maxTimeout) : Math.min(minTimeout * timeoutFactor ** (counter - 1), maxTimeout);
        setTimeout(() => cb2(null), retryTimeout);
      }
      onResponseStart(controller, statusCode, headers, statusMessage) {
        this.error = null;
        this.retryCount += 1;
        if (statusCode >= 300) {
          const err = new RequestRetryError("Request failed", statusCode, {
            headers,
            data: {
              count: this.retryCount
            }
          });
          this.onResponseStartWithRetry(controller, statusCode, headers, statusMessage, err);
          return;
        }
        if (this.headersSent) {
          if (statusCode !== 206 && (this.start > 0 || statusCode !== 200)) {
            throw new RequestRetryError("server does not support the range header and the payload was partially consumed", statusCode, {
              headers,
              data: { count: this.retryCount }
            });
          }
          const contentRange = parseRangeHeader(headers["content-range"]);
          if (!contentRange) {
            throw new RequestRetryError("Content-Range mismatch", statusCode, {
              headers,
              data: { count: this.retryCount }
            });
          }
          if (this.etag != null && this.etag !== headers.etag) {
            throw new RequestRetryError("ETag mismatch", statusCode, {
              headers,
              data: { count: this.retryCount }
            });
          }
          const { start, size, end = size ? size - 1 : null } = contentRange;
          assert48(this.start === start, "content-range mismatch");
          assert48(this.end == null || this.end === end, "content-range mismatch");
          return;
        }
        if (this.end == null) {
          if (statusCode === 206) {
            const range = parseRangeHeader(headers["content-range"]);
            if (range == null) {
              this.headersSent = true;
              this.handler.onResponseStart?.(
                controller,
                statusCode,
                headers,
                statusMessage
              );
              return;
            }
            const { start, size, end = size ? size - 1 : null } = range;
            assert48(
              start != null && Number.isFinite(start),
              "content-range mismatch"
            );
            assert48(end != null && Number.isFinite(end), "invalid content-length");
            this.start = start;
            this.end = end;
          }
          if (this.end == null) {
            const contentLength = headers["content-length"];
            this.end = contentLength != null ? Number(contentLength) - 1 : null;
          }
          assert48(Number.isFinite(this.start));
          assert48(
            this.end == null || Number.isFinite(this.end),
            "invalid content-length"
          );
          this.resume = true;
          this.etag = headers.etag != null ? headers.etag : null;
          if (this.etag != null && this.etag[0] === "W" && this.etag[1] === "/") {
            this.etag = null;
          }
          this.headersSent = true;
          this.handler.onResponseStart?.(
            controller,
            statusCode,
            headers,
            statusMessage
          );
        } else {
          throw new RequestRetryError("Request failed", statusCode, {
            headers,
            data: { count: this.retryCount }
          });
        }
      }
      onResponseData(controller, chunk) {
        if (this.error) {
          return;
        }
        this.start += chunk.length;
        this.handler.onResponseData?.(controller, chunk);
      }
      onResponseEnd(controller, trailers) {
        if (this.error && this.retryOpts.throwOnError) {
          throw this.error;
        }
        if (!this.error) {
          this.retryCount = 0;
          return this.handler.onResponseEnd?.(controller, trailers);
        }
        this.retry(controller);
      }
      retry(controller) {
        if (this.start !== 0) {
          const headers = { range: `bytes=${this.start}-${this.end ?? ""}` };
          if (this.etag != null) {
            headers["if-match"] = this.etag;
          }
          this.opts = {
            ...this.opts,
            headers: {
              ...this.opts.headers,
              ...headers
            }
          };
        }
        try {
          this.retryCountCheckpoint = this.retryCount;
          this.dispatch(this.opts, this);
        } catch (err) {
          this.handler.onResponseError?.(controller, err);
        }
      }
      onResponseError(controller, err) {
        if (controller?.aborted || isDisturbed(this.opts.body)) {
          this.handler.onResponseError?.(controller, err);
          return;
        }
        function shouldRetry(returnedErr) {
          if (!returnedErr) {
            this.retry(controller);
            return;
          }
          this.handler?.onResponseError?.(controller, returnedErr);
        }
        __name(shouldRetry, "shouldRetry");
        if (this.retryCount - this.retryCountCheckpoint > 0) {
          this.retryCount = this.retryCountCheckpoint + (this.retryCount - this.retryCountCheckpoint);
        } else {
          this.retryCount += 1;
        }
        this.retryOpts.retry(
          err,
          {
            state: { counter: this.retryCount },
            opts: { retryOptions: this.retryOpts, ...this.opts }
          },
          shouldRetry.bind(this)
        );
      }
    };
    module3.exports = RetryHandler;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/retry-agent.js
var require_retry_agent = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/retry-agent.js"(exports2, module3) {
    init_import_meta_url();
    var Dispatcher2 = require_dispatcher();
    var RetryHandler = require_retry_handler();
    var RetryAgent = class extends Dispatcher2 {
      static {
        __name(this, "RetryAgent");
      }
      #agent = null;
      #options = null;
      constructor(agent, options = {}) {
        super(options);
        this.#agent = agent;
        this.#options = options;
      }
      dispatch(opts, handler) {
        const retry2 = new RetryHandler({
          ...opts,
          retryOptions: this.#options
        }, {
          dispatch: this.#agent.dispatch.bind(this.#agent),
          handler
        });
        return this.#agent.dispatch(opts, retry2);
      }
      close() {
        return this.#agent.close();
      }
      destroy() {
        return this.#agent.destroy();
      }
    };
    module3.exports = RetryAgent;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/h2c-client.js
var require_h2c_client = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/dispatcher/h2c-client.js"(exports2, module3) {
    init_import_meta_url();
    var { connect } = __require("net");
    var { kClose, kDestroy } = require_symbols();
    var { InvalidArgumentError } = require_errors();
    var util3 = require_util();
    var Client2 = require_client();
    var DispatcherBase = require_dispatcher_base();
    var H2CClient = class extends DispatcherBase {
      static {
        __name(this, "H2CClient");
      }
      #client = null;
      constructor(origin, clientOpts) {
        super();
        if (typeof origin === "string") {
          origin = new URL(origin);
        }
        if (origin.protocol !== "http:") {
          throw new InvalidArgumentError(
            "h2c-client: Only h2c protocol is supported"
          );
        }
        const { connect: connect2, maxConcurrentStreams, pipelining, ...opts } = clientOpts ?? {};
        let defaultMaxConcurrentStreams = 100;
        let defaultPipelining = 100;
        if (maxConcurrentStreams != null && Number.isInteger(maxConcurrentStreams) && maxConcurrentStreams > 0) {
          defaultMaxConcurrentStreams = maxConcurrentStreams;
        }
        if (pipelining != null && Number.isInteger(pipelining) && pipelining > 0) {
          defaultPipelining = pipelining;
        }
        if (defaultPipelining > defaultMaxConcurrentStreams) {
          throw new InvalidArgumentError(
            "h2c-client: pipelining cannot be greater than maxConcurrentStreams"
          );
        }
        this.#client = new Client2(origin, {
          ...opts,
          connect: this.#buildConnector(connect2),
          maxConcurrentStreams: defaultMaxConcurrentStreams,
          pipelining: defaultPipelining,
          allowH2: true
        });
      }
      #buildConnector(connectOpts) {
        return (opts, callback) => {
          const timeout2 = connectOpts?.connectOpts ?? 1e4;
          const { hostname: hostname2, port, pathname } = opts;
          const socket = connect({
            ...opts,
            host: hostname2,
            port,
            pathname
          });
          if (opts.keepAlive == null || opts.keepAlive) {
            const keepAliveInitialDelay = opts.keepAliveInitialDelay == null ? 6e4 : opts.keepAliveInitialDelay;
            socket.setKeepAlive(true, keepAliveInitialDelay);
          }
          socket.alpnProtocol = "h2";
          const clearConnectTimeout = util3.setupConnectTimeout(
            new WeakRef(socket),
            { timeout: timeout2, hostname: hostname2, port }
          );
          socket.setNoDelay(true).once("connect", function() {
            queueMicrotask(clearConnectTimeout);
            if (callback) {
              const cb2 = callback;
              callback = null;
              cb2(null, this);
            }
          }).on("error", function(err) {
            queueMicrotask(clearConnectTimeout);
            if (callback) {
              const cb2 = callback;
              callback = null;
              cb2(err);
            }
          });
          return socket;
        };
      }
      dispatch(opts, handler) {
        return this.#client.dispatch(opts, handler);
      }
      async [kClose]() {
        await this.#client.close();
      }
      async [kDestroy]() {
        await this.#client.destroy();
      }
    };
    module3.exports = H2CClient;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/readable.js
var require_readable = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/readable.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var { Readable: Readable11 } = __require("stream");
    var { RequestAbortedError, NotSupportedError, InvalidArgumentError, AbortError: AbortError2 } = require_errors();
    var util3 = require_util();
    var { ReadableStreamFrom } = require_util();
    var kConsume = Symbol("kConsume");
    var kReading = Symbol("kReading");
    var kBody = Symbol("kBody");
    var kAbort = Symbol("kAbort");
    var kContentType = Symbol("kContentType");
    var kContentLength = Symbol("kContentLength");
    var kUsed = Symbol("kUsed");
    var kBytesRead = Symbol("kBytesRead");
    var noop = /* @__PURE__ */ __name(() => {
    }, "noop");
    var BodyReadable = class extends Readable11 {
      static {
        __name(this, "BodyReadable");
      }
      /**
       * @param {object} opts
       * @param {(this: Readable, size: number) => void} opts.resume
       * @param {() => (void | null)} opts.abort
       * @param {string} [opts.contentType = '']
       * @param {number} [opts.contentLength]
       * @param {number} [opts.highWaterMark = 64 * 1024]
       */
      constructor({
        resume,
        abort,
        contentType = "",
        contentLength,
        highWaterMark = 64 * 1024
        // Same as nodejs fs streams.
      }) {
        super({
          autoDestroy: true,
          read: resume,
          highWaterMark
        });
        this._readableState.dataEmitted = false;
        this[kAbort] = abort;
        this[kConsume] = null;
        this[kBytesRead] = 0;
        this[kBody] = null;
        this[kUsed] = false;
        this[kContentType] = contentType;
        this[kContentLength] = Number.isFinite(contentLength) ? contentLength : null;
        this[kReading] = false;
      }
      /**
       * @param {Error|null} err
       * @param {(error:(Error|null)) => void} callback
       * @returns {void}
       */
      _destroy(err, callback) {
        if (!err && !this._readableState.endEmitted) {
          err = new RequestAbortedError();
        }
        if (err) {
          this[kAbort]();
        }
        if (!this[kUsed]) {
          setImmediate(callback, err);
        } else {
          callback(err);
        }
      }
      /**
       * @param {string|symbol} event
       * @param {(...args: any[]) => void} listener
       * @returns {this}
       */
      on(event, listener) {
        if (event === "data" || event === "readable") {
          this[kReading] = true;
          this[kUsed] = true;
        }
        return super.on(event, listener);
      }
      /**
       * @param {string|symbol} event
       * @param {(...args: any[]) => void} listener
       * @returns {this}
       */
      addListener(event, listener) {
        return this.on(event, listener);
      }
      /**
       * @param {string|symbol} event
       * @param {(...args: any[]) => void} listener
       * @returns {this}
       */
      off(event, listener) {
        const ret = super.off(event, listener);
        if (event === "data" || event === "readable") {
          this[kReading] = this.listenerCount("data") > 0 || this.listenerCount("readable") > 0;
        }
        return ret;
      }
      /**
       * @param {string|symbol} event
       * @param {(...args: any[]) => void} listener
       * @returns {this}
       */
      removeListener(event, listener) {
        return this.off(event, listener);
      }
      /**
       * @param {Buffer|null} chunk
       * @returns {boolean}
       */
      push(chunk) {
        if (chunk) {
          this[kBytesRead] += chunk.length;
          if (this[kConsume]) {
            consumePush(this[kConsume], chunk);
            return this[kReading] ? super.push(chunk) : true;
          }
        }
        return super.push(chunk);
      }
      /**
       * Consumes and returns the body as a string.
       *
       * @see https://fetch.spec.whatwg.org/#dom-body-text
       * @returns {Promise<string>}
       */
      text() {
        return consume(this, "text");
      }
      /**
       * Consumes and returns the body as a JavaScript Object.
       *
       * @see https://fetch.spec.whatwg.org/#dom-body-json
       * @returns {Promise<unknown>}
       */
      json() {
        return consume(this, "json");
      }
      /**
       * Consumes and returns the body as a Blob
       *
       * @see https://fetch.spec.whatwg.org/#dom-body-blob
       * @returns {Promise<Blob>}
       */
      blob() {
        return consume(this, "blob");
      }
      /**
       * Consumes and returns the body as an Uint8Array.
       *
       * @see https://fetch.spec.whatwg.org/#dom-body-bytes
       * @returns {Promise<Uint8Array>}
       */
      bytes() {
        return consume(this, "bytes");
      }
      /**
       * Consumes and returns the body as an ArrayBuffer.
       *
       * @see https://fetch.spec.whatwg.org/#dom-body-arraybuffer
       * @returns {Promise<ArrayBuffer>}
       */
      arrayBuffer() {
        return consume(this, "arrayBuffer");
      }
      /**
       * Not implemented
       *
       * @see https://fetch.spec.whatwg.org/#dom-body-formdata
       * @throws {NotSupportedError}
       */
      async formData() {
        throw new NotSupportedError();
      }
      /**
       * Returns true if the body is not null and the body has been consumed.
       * Otherwise, returns false.
       *
       * @see https://fetch.spec.whatwg.org/#dom-body-bodyused
       * @readonly
       * @returns {boolean}
       */
      get bodyUsed() {
        return util3.isDisturbed(this);
      }
      /**
       * @see https://fetch.spec.whatwg.org/#dom-body-body
       * @readonly
       * @returns {ReadableStream}
       */
      get body() {
        if (!this[kBody]) {
          this[kBody] = ReadableStreamFrom(this);
          if (this[kConsume]) {
            this[kBody].getReader();
            assert48(this[kBody].locked);
          }
        }
        return this[kBody];
      }
      /**
       * Dumps the response body by reading `limit` number of bytes.
       * @param {object} opts
       * @param {number} [opts.limit = 131072] Number of bytes to read.
       * @param {AbortSignal} [opts.signal] An AbortSignal to cancel the dump.
       * @returns {Promise<null>}
       */
      async dump(opts) {
        const signal = opts?.signal;
        if (signal != null && (typeof signal !== "object" || !("aborted" in signal))) {
          throw new InvalidArgumentError("signal must be an AbortSignal");
        }
        const limit2 = opts?.limit && Number.isFinite(opts.limit) ? opts.limit : 128 * 1024;
        signal?.throwIfAborted();
        if (this._readableState.closeEmitted) {
          return null;
        }
        return await new Promise((resolve28, reject) => {
          if (this[kContentLength] && this[kContentLength] > limit2 || this[kBytesRead] > limit2) {
            this.destroy(new AbortError2());
          }
          if (signal) {
            const onAbort = /* @__PURE__ */ __name(() => {
              this.destroy(signal.reason ?? new AbortError2());
            }, "onAbort");
            signal.addEventListener("abort", onAbort);
            this.on("close", function() {
              signal.removeEventListener("abort", onAbort);
              if (signal.aborted) {
                reject(signal.reason ?? new AbortError2());
              } else {
                resolve28(null);
              }
            });
          } else {
            this.on("close", resolve28);
          }
          this.on("error", noop).on("data", () => {
            if (this[kBytesRead] > limit2) {
              this.destroy();
            }
          }).resume();
        });
      }
      /**
       * @param {BufferEncoding} encoding
       * @returns {this}
       */
      setEncoding(encoding) {
        if (Buffer.isEncoding(encoding)) {
          this._readableState.encoding = encoding;
        }
        return this;
      }
    };
    function isLocked(bodyReadable) {
      return bodyReadable[kBody]?.locked === true || bodyReadable[kConsume] !== null;
    }
    __name(isLocked, "isLocked");
    function isUnusable(bodyReadable) {
      return util3.isDisturbed(bodyReadable) || isLocked(bodyReadable);
    }
    __name(isUnusable, "isUnusable");
    function consume(stream2, type) {
      assert48(!stream2[kConsume]);
      return new Promise((resolve28, reject) => {
        if (isUnusable(stream2)) {
          const rState = stream2._readableState;
          if (rState.destroyed && rState.closeEmitted === false) {
            stream2.on("error", reject).on("close", () => {
              reject(new TypeError("unusable"));
            });
          } else {
            reject(rState.errored ?? new TypeError("unusable"));
          }
        } else {
          queueMicrotask(() => {
            stream2[kConsume] = {
              type,
              stream: stream2,
              resolve: resolve28,
              reject,
              length: 0,
              body: []
            };
            stream2.on("error", function(err) {
              consumeFinish(this[kConsume], err);
            }).on("close", function() {
              if (this[kConsume].body !== null) {
                consumeFinish(this[kConsume], new RequestAbortedError());
              }
            });
            consumeStart(stream2[kConsume]);
          });
        }
      });
    }
    __name(consume, "consume");
    function consumeStart(consume2) {
      if (consume2.body === null) {
        return;
      }
      const { _readableState: state2 } = consume2.stream;
      if (state2.bufferIndex) {
        const start = state2.bufferIndex;
        const end = state2.buffer.length;
        for (let n7 = start; n7 < end; n7++) {
          consumePush(consume2, state2.buffer[n7]);
        }
      } else {
        for (const chunk of state2.buffer) {
          consumePush(consume2, chunk);
        }
      }
      if (state2.endEmitted) {
        consumeEnd(this[kConsume], this._readableState.encoding);
      } else {
        consume2.stream.on("end", function() {
          consumeEnd(this[kConsume], this._readableState.encoding);
        });
      }
      consume2.stream.resume();
      while (consume2.stream.read() != null) {
      }
    }
    __name(consumeStart, "consumeStart");
    function chunksDecode(chunks, length, encoding) {
      if (chunks.length === 0 || length === 0) {
        return "";
      }
      const buffer = chunks.length === 1 ? chunks[0] : Buffer.concat(chunks, length);
      const bufferLength = buffer.length;
      const start = bufferLength > 2 && buffer[0] === 239 && buffer[1] === 187 && buffer[2] === 191 ? 3 : 0;
      if (!encoding || encoding === "utf8" || encoding === "utf-8") {
        return buffer.utf8Slice(start, bufferLength);
      } else {
        return buffer.subarray(start, bufferLength).toString(encoding);
      }
    }
    __name(chunksDecode, "chunksDecode");
    function chunksConcat(chunks, length) {
      if (chunks.length === 0 || length === 0) {
        return new Uint8Array(0);
      }
      if (chunks.length === 1) {
        return new Uint8Array(chunks[0]);
      }
      const buffer = new Uint8Array(Buffer.allocUnsafeSlow(length).buffer);
      let offset = 0;
      for (let i6 = 0; i6 < chunks.length; ++i6) {
        const chunk = chunks[i6];
        buffer.set(chunk, offset);
        offset += chunk.length;
      }
      return buffer;
    }
    __name(chunksConcat, "chunksConcat");
    function consumeEnd(consume2, encoding) {
      const { type, body, resolve: resolve28, stream: stream2, length } = consume2;
      try {
        if (type === "text") {
          resolve28(chunksDecode(body, length, encoding));
        } else if (type === "json") {
          resolve28(JSON.parse(chunksDecode(body, length, encoding)));
        } else if (type === "arrayBuffer") {
          resolve28(chunksConcat(body, length).buffer);
        } else if (type === "blob") {
          resolve28(new Blob(body, { type: stream2[kContentType] }));
        } else if (type === "bytes") {
          resolve28(chunksConcat(body, length));
        }
        consumeFinish(consume2);
      } catch (err) {
        stream2.destroy(err);
      }
    }
    __name(consumeEnd, "consumeEnd");
    function consumePush(consume2, chunk) {
      consume2.length += chunk.length;
      consume2.body.push(chunk);
    }
    __name(consumePush, "consumePush");
    function consumeFinish(consume2, err) {
      if (consume2.body === null) {
        return;
      }
      if (err) {
        consume2.reject(err);
      } else {
        consume2.resolve();
      }
      consume2.type = null;
      consume2.stream = null;
      consume2.resolve = null;
      consume2.reject = null;
      consume2.length = 0;
      consume2.body = null;
    }
    __name(consumeFinish, "consumeFinish");
    module3.exports = {
      Readable: BodyReadable,
      chunksDecode
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/api-request.js
var require_api_request = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/api-request.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var { AsyncResource } = __require("async_hooks");
    var { Readable: Readable11 } = require_readable();
    var { InvalidArgumentError, RequestAbortedError } = require_errors();
    var util3 = require_util();
    function noop() {
    }
    __name(noop, "noop");
    var RequestHandler = class extends AsyncResource {
      static {
        __name(this, "RequestHandler");
      }
      constructor(opts, callback) {
        if (!opts || typeof opts !== "object") {
          throw new InvalidArgumentError("invalid opts");
        }
        const { signal, method, opaque, body, onInfo, responseHeaders, highWaterMark } = opts;
        try {
          if (typeof callback !== "function") {
            throw new InvalidArgumentError("invalid callback");
          }
          if (highWaterMark && (typeof highWaterMark !== "number" || highWaterMark < 0)) {
            throw new InvalidArgumentError("invalid highWaterMark");
          }
          if (signal && typeof signal.on !== "function" && typeof signal.addEventListener !== "function") {
            throw new InvalidArgumentError("signal must be an EventEmitter or EventTarget");
          }
          if (method === "CONNECT") {
            throw new InvalidArgumentError("invalid method");
          }
          if (onInfo && typeof onInfo !== "function") {
            throw new InvalidArgumentError("invalid onInfo callback");
          }
          super("UNDICI_REQUEST");
        } catch (err) {
          if (util3.isStream(body)) {
            util3.destroy(body.on("error", noop), err);
          }
          throw err;
        }
        this.method = method;
        this.responseHeaders = responseHeaders || null;
        this.opaque = opaque || null;
        this.callback = callback;
        this.res = null;
        this.abort = null;
        this.body = body;
        this.trailers = {};
        this.context = null;
        this.onInfo = onInfo || null;
        this.highWaterMark = highWaterMark;
        this.reason = null;
        this.removeAbortListener = null;
        if (signal?.aborted) {
          this.reason = signal.reason ?? new RequestAbortedError();
        } else if (signal) {
          this.removeAbortListener = util3.addAbortListener(signal, () => {
            this.reason = signal.reason ?? new RequestAbortedError();
            if (this.res) {
              util3.destroy(this.res.on("error", noop), this.reason);
            } else if (this.abort) {
              this.abort(this.reason);
            }
          });
        }
      }
      onConnect(abort, context2) {
        if (this.reason) {
          abort(this.reason);
          return;
        }
        assert48(this.callback);
        this.abort = abort;
        this.context = context2;
      }
      onHeaders(statusCode, rawHeaders, resume, statusMessage) {
        const { callback, opaque, abort, context: context2, responseHeaders, highWaterMark } = this;
        const headers = responseHeaders === "raw" ? util3.parseRawHeaders(rawHeaders) : util3.parseHeaders(rawHeaders);
        if (statusCode < 200) {
          if (this.onInfo) {
            this.onInfo({ statusCode, headers });
          }
          return;
        }
        const parsedHeaders = responseHeaders === "raw" ? util3.parseHeaders(rawHeaders) : headers;
        const contentType = parsedHeaders["content-type"];
        const contentLength = parsedHeaders["content-length"];
        const res = new Readable11({
          resume,
          abort,
          contentType,
          contentLength: this.method !== "HEAD" && contentLength ? Number(contentLength) : null,
          highWaterMark
        });
        if (this.removeAbortListener) {
          res.on("close", this.removeAbortListener);
          this.removeAbortListener = null;
        }
        this.callback = null;
        this.res = res;
        if (callback !== null) {
          this.runInAsyncScope(callback, null, null, {
            statusCode,
            headers,
            trailers: this.trailers,
            opaque,
            body: res,
            context: context2
          });
        }
      }
      onData(chunk) {
        return this.res.push(chunk);
      }
      onComplete(trailers) {
        util3.parseHeaders(trailers, this.trailers);
        this.res.push(null);
      }
      onError(err) {
        const { res, callback, body, opaque } = this;
        if (callback) {
          this.callback = null;
          queueMicrotask(() => {
            this.runInAsyncScope(callback, null, err, { opaque });
          });
        }
        if (res) {
          this.res = null;
          queueMicrotask(() => {
            util3.destroy(res.on("error", noop), err);
          });
        }
        if (body) {
          this.body = null;
          if (util3.isStream(body)) {
            body.on("error", noop);
            util3.destroy(body, err);
          }
        }
        if (this.removeAbortListener) {
          this.removeAbortListener();
          this.removeAbortListener = null;
        }
      }
    };
    function request4(opts, callback) {
      if (callback === void 0) {
        return new Promise((resolve28, reject) => {
          request4.call(this, opts, (err, data) => {
            return err ? reject(err) : resolve28(data);
          });
        });
      }
      try {
        const handler = new RequestHandler(opts, callback);
        this.dispatch(opts, handler);
      } catch (err) {
        if (typeof callback !== "function") {
          throw err;
        }
        const opaque = opts?.opaque;
        queueMicrotask(() => callback(err, { opaque }));
      }
    }
    __name(request4, "request");
    module3.exports = request4;
    module3.exports.RequestHandler = RequestHandler;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/abort-signal.js
var require_abort_signal = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/abort-signal.js"(exports2, module3) {
    init_import_meta_url();
    var { addAbortListener } = require_util();
    var { RequestAbortedError } = require_errors();
    var kListener = Symbol("kListener");
    var kSignal = Symbol("kSignal");
    function abort(self2) {
      if (self2.abort) {
        self2.abort(self2[kSignal]?.reason);
      } else {
        self2.reason = self2[kSignal]?.reason ?? new RequestAbortedError();
      }
      removeSignal(self2);
    }
    __name(abort, "abort");
    function addSignal(self2, signal) {
      self2.reason = null;
      self2[kSignal] = null;
      self2[kListener] = null;
      if (!signal) {
        return;
      }
      if (signal.aborted) {
        abort(self2);
        return;
      }
      self2[kSignal] = signal;
      self2[kListener] = () => {
        abort(self2);
      };
      addAbortListener(self2[kSignal], self2[kListener]);
    }
    __name(addSignal, "addSignal");
    function removeSignal(self2) {
      if (!self2[kSignal]) {
        return;
      }
      if ("removeEventListener" in self2[kSignal]) {
        self2[kSignal].removeEventListener("abort", self2[kListener]);
      } else {
        self2[kSignal].removeListener("abort", self2[kListener]);
      }
      self2[kSignal] = null;
      self2[kListener] = null;
    }
    __name(removeSignal, "removeSignal");
    module3.exports = {
      addSignal,
      removeSignal
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/api-stream.js
var require_api_stream = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/api-stream.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var { finished } = __require("stream");
    var { AsyncResource } = __require("async_hooks");
    var { InvalidArgumentError, InvalidReturnValueError } = require_errors();
    var util3 = require_util();
    var { addSignal, removeSignal } = require_abort_signal();
    function noop() {
    }
    __name(noop, "noop");
    var StreamHandler = class extends AsyncResource {
      static {
        __name(this, "StreamHandler");
      }
      constructor(opts, factory, callback) {
        if (!opts || typeof opts !== "object") {
          throw new InvalidArgumentError("invalid opts");
        }
        const { signal, method, opaque, body, onInfo, responseHeaders } = opts;
        try {
          if (typeof callback !== "function") {
            throw new InvalidArgumentError("invalid callback");
          }
          if (typeof factory !== "function") {
            throw new InvalidArgumentError("invalid factory");
          }
          if (signal && typeof signal.on !== "function" && typeof signal.addEventListener !== "function") {
            throw new InvalidArgumentError("signal must be an EventEmitter or EventTarget");
          }
          if (method === "CONNECT") {
            throw new InvalidArgumentError("invalid method");
          }
          if (onInfo && typeof onInfo !== "function") {
            throw new InvalidArgumentError("invalid onInfo callback");
          }
          super("UNDICI_STREAM");
        } catch (err) {
          if (util3.isStream(body)) {
            util3.destroy(body.on("error", noop), err);
          }
          throw err;
        }
        this.responseHeaders = responseHeaders || null;
        this.opaque = opaque || null;
        this.factory = factory;
        this.callback = callback;
        this.res = null;
        this.abort = null;
        this.context = null;
        this.trailers = null;
        this.body = body;
        this.onInfo = onInfo || null;
        if (util3.isStream(body)) {
          body.on("error", (err) => {
            this.onError(err);
          });
        }
        addSignal(this, signal);
      }
      onConnect(abort, context2) {
        if (this.reason) {
          abort(this.reason);
          return;
        }
        assert48(this.callback);
        this.abort = abort;
        this.context = context2;
      }
      onHeaders(statusCode, rawHeaders, resume, statusMessage) {
        const { factory, opaque, context: context2, responseHeaders } = this;
        const headers = responseHeaders === "raw" ? util3.parseRawHeaders(rawHeaders) : util3.parseHeaders(rawHeaders);
        if (statusCode < 200) {
          if (this.onInfo) {
            this.onInfo({ statusCode, headers });
          }
          return;
        }
        this.factory = null;
        if (factory === null) {
          return;
        }
        const res = this.runInAsyncScope(factory, null, {
          statusCode,
          headers,
          opaque,
          context: context2
        });
        if (!res || typeof res.write !== "function" || typeof res.end !== "function" || typeof res.on !== "function") {
          throw new InvalidReturnValueError("expected Writable");
        }
        finished(res, { readable: false }, (err) => {
          const { callback, res: res2, opaque: opaque2, trailers, abort } = this;
          this.res = null;
          if (err || !res2?.readable) {
            util3.destroy(res2, err);
          }
          this.callback = null;
          this.runInAsyncScope(callback, null, err || null, { opaque: opaque2, trailers });
          if (err) {
            abort();
          }
        });
        res.on("drain", resume);
        this.res = res;
        const needDrain = res.writableNeedDrain !== void 0 ? res.writableNeedDrain : res._writableState?.needDrain;
        return needDrain !== true;
      }
      onData(chunk) {
        const { res } = this;
        return res ? res.write(chunk) : true;
      }
      onComplete(trailers) {
        const { res } = this;
        removeSignal(this);
        if (!res) {
          return;
        }
        this.trailers = util3.parseHeaders(trailers);
        res.end();
      }
      onError(err) {
        const { res, callback, opaque, body } = this;
        removeSignal(this);
        this.factory = null;
        if (res) {
          this.res = null;
          util3.destroy(res, err);
        } else if (callback) {
          this.callback = null;
          queueMicrotask(() => {
            this.runInAsyncScope(callback, null, err, { opaque });
          });
        }
        if (body) {
          this.body = null;
          util3.destroy(body, err);
        }
      }
    };
    function stream2(opts, factory, callback) {
      if (callback === void 0) {
        return new Promise((resolve28, reject) => {
          stream2.call(this, opts, factory, (err, data) => {
            return err ? reject(err) : resolve28(data);
          });
        });
      }
      try {
        const handler = new StreamHandler(opts, factory, callback);
        this.dispatch(opts, handler);
      } catch (err) {
        if (typeof callback !== "function") {
          throw err;
        }
        const opaque = opts?.opaque;
        queueMicrotask(() => callback(err, { opaque }));
      }
    }
    __name(stream2, "stream");
    module3.exports = stream2;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/api-pipeline.js
var require_api_pipeline = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/api-pipeline.js"(exports2, module3) {
    init_import_meta_url();
    var {
      Readable: Readable11,
      Duplex: Duplex2,
      PassThrough: PassThrough4
    } = __require("stream");
    var assert48 = __require("assert");
    var { AsyncResource } = __require("async_hooks");
    var {
      InvalidArgumentError,
      InvalidReturnValueError,
      RequestAbortedError
    } = require_errors();
    var util3 = require_util();
    var { addSignal, removeSignal } = require_abort_signal();
    function noop() {
    }
    __name(noop, "noop");
    var kResume = Symbol("resume");
    var PipelineRequest = class extends Readable11 {
      static {
        __name(this, "PipelineRequest");
      }
      constructor() {
        super({ autoDestroy: true });
        this[kResume] = null;
      }
      _read() {
        const { [kResume]: resume } = this;
        if (resume) {
          this[kResume] = null;
          resume();
        }
      }
      _destroy(err, callback) {
        this._read();
        callback(err);
      }
    };
    var PipelineResponse = class extends Readable11 {
      static {
        __name(this, "PipelineResponse");
      }
      constructor(resume) {
        super({ autoDestroy: true });
        this[kResume] = resume;
      }
      _read() {
        this[kResume]();
      }
      _destroy(err, callback) {
        if (!err && !this._readableState.endEmitted) {
          err = new RequestAbortedError();
        }
        callback(err);
      }
    };
    var PipelineHandler = class extends AsyncResource {
      static {
        __name(this, "PipelineHandler");
      }
      constructor(opts, handler) {
        if (!opts || typeof opts !== "object") {
          throw new InvalidArgumentError("invalid opts");
        }
        if (typeof handler !== "function") {
          throw new InvalidArgumentError("invalid handler");
        }
        const { signal, method, opaque, onInfo, responseHeaders } = opts;
        if (signal && typeof signal.on !== "function" && typeof signal.addEventListener !== "function") {
          throw new InvalidArgumentError("signal must be an EventEmitter or EventTarget");
        }
        if (method === "CONNECT") {
          throw new InvalidArgumentError("invalid method");
        }
        if (onInfo && typeof onInfo !== "function") {
          throw new InvalidArgumentError("invalid onInfo callback");
        }
        super("UNDICI_PIPELINE");
        this.opaque = opaque || null;
        this.responseHeaders = responseHeaders || null;
        this.handler = handler;
        this.abort = null;
        this.context = null;
        this.onInfo = onInfo || null;
        this.req = new PipelineRequest().on("error", noop);
        this.ret = new Duplex2({
          readableObjectMode: opts.objectMode,
          autoDestroy: true,
          read: /* @__PURE__ */ __name(() => {
            const { body } = this;
            if (body?.resume) {
              body.resume();
            }
          }, "read"),
          write: /* @__PURE__ */ __name((chunk, encoding, callback) => {
            const { req } = this;
            if (req.push(chunk, encoding) || req._readableState.destroyed) {
              callback();
            } else {
              req[kResume] = callback;
            }
          }, "write"),
          destroy: /* @__PURE__ */ __name((err, callback) => {
            const { body, req, res, ret, abort } = this;
            if (!err && !ret._readableState.endEmitted) {
              err = new RequestAbortedError();
            }
            if (abort && err) {
              abort();
            }
            util3.destroy(body, err);
            util3.destroy(req, err);
            util3.destroy(res, err);
            removeSignal(this);
            callback(err);
          }, "destroy")
        }).on("prefinish", () => {
          const { req } = this;
          req.push(null);
        });
        this.res = null;
        addSignal(this, signal);
      }
      onConnect(abort, context2) {
        const { res } = this;
        if (this.reason) {
          abort(this.reason);
          return;
        }
        assert48(!res, "pipeline cannot be retried");
        this.abort = abort;
        this.context = context2;
      }
      onHeaders(statusCode, rawHeaders, resume) {
        const { opaque, handler, context: context2 } = this;
        if (statusCode < 200) {
          if (this.onInfo) {
            const headers = this.responseHeaders === "raw" ? util3.parseRawHeaders(rawHeaders) : util3.parseHeaders(rawHeaders);
            this.onInfo({ statusCode, headers });
          }
          return;
        }
        this.res = new PipelineResponse(resume);
        let body;
        try {
          this.handler = null;
          const headers = this.responseHeaders === "raw" ? util3.parseRawHeaders(rawHeaders) : util3.parseHeaders(rawHeaders);
          body = this.runInAsyncScope(handler, null, {
            statusCode,
            headers,
            opaque,
            body: this.res,
            context: context2
          });
        } catch (err) {
          this.res.on("error", noop);
          throw err;
        }
        if (!body || typeof body.on !== "function") {
          throw new InvalidReturnValueError("expected Readable");
        }
        body.on("data", (chunk) => {
          const { ret, body: body2 } = this;
          if (!ret.push(chunk) && body2.pause) {
            body2.pause();
          }
        }).on("error", (err) => {
          const { ret } = this;
          util3.destroy(ret, err);
        }).on("end", () => {
          const { ret } = this;
          ret.push(null);
        }).on("close", () => {
          const { ret } = this;
          if (!ret._readableState.ended) {
            util3.destroy(ret, new RequestAbortedError());
          }
        });
        this.body = body;
      }
      onData(chunk) {
        const { res } = this;
        return res.push(chunk);
      }
      onComplete(trailers) {
        const { res } = this;
        res.push(null);
      }
      onError(err) {
        const { ret } = this;
        this.handler = null;
        util3.destroy(ret, err);
      }
    };
    function pipeline(opts, handler) {
      try {
        const pipelineHandler = new PipelineHandler(opts, handler);
        this.dispatch({ ...opts, body: pipelineHandler.req }, pipelineHandler);
        return pipelineHandler.ret;
      } catch (err) {
        return new PassThrough4().destroy(err);
      }
    }
    __name(pipeline, "pipeline");
    module3.exports = pipeline;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/api-upgrade.js
var require_api_upgrade = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/api-upgrade.js"(exports2, module3) {
    init_import_meta_url();
    var { InvalidArgumentError, SocketError } = require_errors();
    var { AsyncResource } = __require("async_hooks");
    var assert48 = __require("assert");
    var util3 = require_util();
    var { addSignal, removeSignal } = require_abort_signal();
    var UpgradeHandler = class extends AsyncResource {
      static {
        __name(this, "UpgradeHandler");
      }
      constructor(opts, callback) {
        if (!opts || typeof opts !== "object") {
          throw new InvalidArgumentError("invalid opts");
        }
        if (typeof callback !== "function") {
          throw new InvalidArgumentError("invalid callback");
        }
        const { signal, opaque, responseHeaders } = opts;
        if (signal && typeof signal.on !== "function" && typeof signal.addEventListener !== "function") {
          throw new InvalidArgumentError("signal must be an EventEmitter or EventTarget");
        }
        super("UNDICI_UPGRADE");
        this.responseHeaders = responseHeaders || null;
        this.opaque = opaque || null;
        this.callback = callback;
        this.abort = null;
        this.context = null;
        addSignal(this, signal);
      }
      onConnect(abort, context2) {
        if (this.reason) {
          abort(this.reason);
          return;
        }
        assert48(this.callback);
        this.abort = abort;
        this.context = null;
      }
      onHeaders() {
        throw new SocketError("bad upgrade", null);
      }
      onUpgrade(statusCode, rawHeaders, socket) {
        assert48(statusCode === 101);
        const { callback, opaque, context: context2 } = this;
        removeSignal(this);
        this.callback = null;
        const headers = this.responseHeaders === "raw" ? util3.parseRawHeaders(rawHeaders) : util3.parseHeaders(rawHeaders);
        this.runInAsyncScope(callback, null, null, {
          headers,
          socket,
          opaque,
          context: context2
        });
      }
      onError(err) {
        const { callback, opaque } = this;
        removeSignal(this);
        if (callback) {
          this.callback = null;
          queueMicrotask(() => {
            this.runInAsyncScope(callback, null, err, { opaque });
          });
        }
      }
    };
    function upgrade(opts, callback) {
      if (callback === void 0) {
        return new Promise((resolve28, reject) => {
          upgrade.call(this, opts, (err, data) => {
            return err ? reject(err) : resolve28(data);
          });
        });
      }
      try {
        const upgradeHandler = new UpgradeHandler(opts, callback);
        const upgradeOpts = {
          ...opts,
          method: opts.method || "GET",
          upgrade: opts.protocol || "Websocket"
        };
        this.dispatch(upgradeOpts, upgradeHandler);
      } catch (err) {
        if (typeof callback !== "function") {
          throw err;
        }
        const opaque = opts?.opaque;
        queueMicrotask(() => callback(err, { opaque }));
      }
    }
    __name(upgrade, "upgrade");
    module3.exports = upgrade;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/api-connect.js
var require_api_connect = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/api-connect.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var { AsyncResource } = __require("async_hooks");
    var { InvalidArgumentError, SocketError } = require_errors();
    var util3 = require_util();
    var { addSignal, removeSignal } = require_abort_signal();
    var ConnectHandler = class extends AsyncResource {
      static {
        __name(this, "ConnectHandler");
      }
      constructor(opts, callback) {
        if (!opts || typeof opts !== "object") {
          throw new InvalidArgumentError("invalid opts");
        }
        if (typeof callback !== "function") {
          throw new InvalidArgumentError("invalid callback");
        }
        const { signal, opaque, responseHeaders } = opts;
        if (signal && typeof signal.on !== "function" && typeof signal.addEventListener !== "function") {
          throw new InvalidArgumentError("signal must be an EventEmitter or EventTarget");
        }
        super("UNDICI_CONNECT");
        this.opaque = opaque || null;
        this.responseHeaders = responseHeaders || null;
        this.callback = callback;
        this.abort = null;
        addSignal(this, signal);
      }
      onConnect(abort, context2) {
        if (this.reason) {
          abort(this.reason);
          return;
        }
        assert48(this.callback);
        this.abort = abort;
        this.context = context2;
      }
      onHeaders() {
        throw new SocketError("bad connect", null);
      }
      onUpgrade(statusCode, rawHeaders, socket) {
        const { callback, opaque, context: context2 } = this;
        removeSignal(this);
        this.callback = null;
        let headers = rawHeaders;
        if (headers != null) {
          headers = this.responseHeaders === "raw" ? util3.parseRawHeaders(rawHeaders) : util3.parseHeaders(rawHeaders);
        }
        this.runInAsyncScope(callback, null, null, {
          statusCode,
          headers,
          socket,
          opaque,
          context: context2
        });
      }
      onError(err) {
        const { callback, opaque } = this;
        removeSignal(this);
        if (callback) {
          this.callback = null;
          queueMicrotask(() => {
            this.runInAsyncScope(callback, null, err, { opaque });
          });
        }
      }
    };
    function connect(opts, callback) {
      if (callback === void 0) {
        return new Promise((resolve28, reject) => {
          connect.call(this, opts, (err, data) => {
            return err ? reject(err) : resolve28(data);
          });
        });
      }
      try {
        const connectHandler = new ConnectHandler(opts, callback);
        const connectOptions = { ...opts, method: "CONNECT" };
        this.dispatch(connectOptions, connectHandler);
      } catch (err) {
        if (typeof callback !== "function") {
          throw err;
        }
        const opaque = opts?.opaque;
        queueMicrotask(() => callback(err, { opaque }));
      }
    }
    __name(connect, "connect");
    module3.exports = connect;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/index.js
var require_api = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/api/index.js"(exports2, module3) {
    init_import_meta_url();
    module3.exports.request = require_api_request();
    module3.exports.stream = require_api_stream();
    module3.exports.pipeline = require_api_pipeline();
    module3.exports.upgrade = require_api_upgrade();
    module3.exports.connect = require_api_connect();
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-errors.js
var require_mock_errors = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-errors.js"(exports2, module3) {
    init_import_meta_url();
    var { UndiciError } = require_errors();
    var MockNotMatchedError = class extends UndiciError {
      static {
        __name(this, "MockNotMatchedError");
      }
      constructor(message) {
        super(message);
        this.name = "MockNotMatchedError";
        this.message = message || "The request does not match any registered mock dispatches";
        this.code = "UND_MOCK_ERR_MOCK_NOT_MATCHED";
      }
    };
    module3.exports = {
      MockNotMatchedError
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-symbols.js
var require_mock_symbols = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-symbols.js"(exports2, module3) {
    init_import_meta_url();
    module3.exports = {
      kAgent: Symbol("agent"),
      kOptions: Symbol("options"),
      kFactory: Symbol("factory"),
      kDispatches: Symbol("dispatches"),
      kDispatchKey: Symbol("dispatch key"),
      kDefaultHeaders: Symbol("default headers"),
      kDefaultTrailers: Symbol("default trailers"),
      kContentLength: Symbol("content length"),
      kMockAgent: Symbol("mock agent"),
      kMockAgentSet: Symbol("mock agent set"),
      kMockAgentGet: Symbol("mock agent get"),
      kMockDispatch: Symbol("mock dispatch"),
      kClose: Symbol("close"),
      kOriginalClose: Symbol("original agent close"),
      kOriginalDispatch: Symbol("original dispatch"),
      kOrigin: Symbol("origin"),
      kIsMockActive: Symbol("is mock active"),
      kNetConnect: Symbol("net connect"),
      kGetNetConnect: Symbol("get net connect"),
      kConnected: Symbol("connected"),
      kIgnoreTrailingSlash: Symbol("ignore trailing slash"),
      kMockAgentMockCallHistoryInstance: Symbol("mock agent mock call history name"),
      kMockAgentRegisterCallHistory: Symbol("mock agent register mock call history"),
      kMockAgentAddCallHistoryLog: Symbol("mock agent add call history log"),
      kMockAgentIsCallHistoryEnabled: Symbol("mock agent is call history enabled"),
      kMockAgentAcceptsNonStandardSearchParameters: Symbol("mock agent accepts non standard search parameters"),
      kMockCallHistoryAddLog: Symbol("mock call history add log")
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-utils.js
var require_mock_utils = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-utils.js"(exports2, module3) {
    init_import_meta_url();
    var { MockNotMatchedError } = require_mock_errors();
    var {
      kDispatches,
      kMockAgent,
      kOriginalDispatch,
      kOrigin,
      kGetNetConnect
    } = require_mock_symbols();
    var { serializePathWithQuery } = require_util();
    var { STATUS_CODES: STATUS_CODES2 } = __require("http");
    var {
      types: {
        isPromise: isPromise2
      }
    } = __require("util");
    var { InvalidArgumentError } = require_errors();
    function matchValue(match3, value) {
      if (typeof match3 === "string") {
        return match3 === value;
      }
      if (match3 instanceof RegExp) {
        return match3.test(value);
      }
      if (typeof match3 === "function") {
        return match3(value) === true;
      }
      return false;
    }
    __name(matchValue, "matchValue");
    function lowerCaseEntries(headers) {
      return Object.fromEntries(
        Object.entries(headers).map(([headerName, headerValue]) => {
          return [headerName.toLocaleLowerCase(), headerValue];
        })
      );
    }
    __name(lowerCaseEntries, "lowerCaseEntries");
    function getHeaderByName(headers, key) {
      if (Array.isArray(headers)) {
        for (let i6 = 0; i6 < headers.length; i6 += 2) {
          if (headers[i6].toLocaleLowerCase() === key.toLocaleLowerCase()) {
            return headers[i6 + 1];
          }
        }
        return void 0;
      } else if (typeof headers.get === "function") {
        return headers.get(key);
      } else {
        return lowerCaseEntries(headers)[key.toLocaleLowerCase()];
      }
    }
    __name(getHeaderByName, "getHeaderByName");
    function buildHeadersFromArray(headers) {
      const clone2 = headers.slice();
      const entries2 = [];
      for (let index = 0; index < clone2.length; index += 2) {
        entries2.push([clone2[index], clone2[index + 1]]);
      }
      return Object.fromEntries(entries2);
    }
    __name(buildHeadersFromArray, "buildHeadersFromArray");
    function matchHeaders(mockDispatch2, headers) {
      if (typeof mockDispatch2.headers === "function") {
        if (Array.isArray(headers)) {
          headers = buildHeadersFromArray(headers);
        }
        return mockDispatch2.headers(headers ? lowerCaseEntries(headers) : {});
      }
      if (typeof mockDispatch2.headers === "undefined") {
        return true;
      }
      if (typeof headers !== "object" || typeof mockDispatch2.headers !== "object") {
        return false;
      }
      for (const [matchHeaderName, matchHeaderValue] of Object.entries(mockDispatch2.headers)) {
        const headerValue = getHeaderByName(headers, matchHeaderName);
        if (!matchValue(matchHeaderValue, headerValue)) {
          return false;
        }
      }
      return true;
    }
    __name(matchHeaders, "matchHeaders");
    function normalizeSearchParams(query) {
      if (typeof query !== "string") {
        return query;
      }
      const originalQp = new URLSearchParams(query);
      const normalizedQp = new URLSearchParams();
      for (let [key, value] of originalQp.entries()) {
        key = key.replace("[]", "");
        const valueRepresentsString = /^(['"]).*\1$/.test(value);
        if (valueRepresentsString) {
          normalizedQp.append(key, value);
          continue;
        }
        if (value.includes(",")) {
          const values = value.split(",");
          for (const v8 of values) {
            normalizedQp.append(key, v8);
          }
          continue;
        }
        normalizedQp.append(key, value);
      }
      return normalizedQp;
    }
    __name(normalizeSearchParams, "normalizeSearchParams");
    function safeUrl(path77) {
      if (typeof path77 !== "string") {
        return path77;
      }
      const pathSegments = path77.split("?", 3);
      if (pathSegments.length !== 2) {
        return path77;
      }
      const qp = new URLSearchParams(pathSegments.pop());
      qp.sort();
      return [...pathSegments, qp.toString()].join("?");
    }
    __name(safeUrl, "safeUrl");
    function matchKey(mockDispatch2, { path: path77, method, body, headers }) {
      const pathMatch = matchValue(mockDispatch2.path, path77);
      const methodMatch = matchValue(mockDispatch2.method, method);
      const bodyMatch = typeof mockDispatch2.body !== "undefined" ? matchValue(mockDispatch2.body, body) : true;
      const headersMatch = matchHeaders(mockDispatch2, headers);
      return pathMatch && methodMatch && bodyMatch && headersMatch;
    }
    __name(matchKey, "matchKey");
    function getResponseData(data) {
      if (Buffer.isBuffer(data)) {
        return data;
      } else if (data instanceof Uint8Array) {
        return data;
      } else if (data instanceof ArrayBuffer) {
        return data;
      } else if (typeof data === "object") {
        return JSON.stringify(data);
      } else if (data) {
        return data.toString();
      } else {
        return "";
      }
    }
    __name(getResponseData, "getResponseData");
    function getMockDispatch(mockDispatches, key) {
      const basePath = key.query ? serializePathWithQuery(key.path, key.query) : key.path;
      const resolvedPath2 = typeof basePath === "string" ? safeUrl(basePath) : basePath;
      const resolvedPathWithoutTrailingSlash = removeTrailingSlash2(resolvedPath2);
      let matchedMockDispatches = mockDispatches.filter(({ consumed }) => !consumed).filter(({ path: path77, ignoreTrailingSlash }) => {
        return ignoreTrailingSlash ? matchValue(removeTrailingSlash2(safeUrl(path77)), resolvedPathWithoutTrailingSlash) : matchValue(safeUrl(path77), resolvedPath2);
      });
      if (matchedMockDispatches.length === 0) {
        throw new MockNotMatchedError(`Mock dispatch not matched for path '${resolvedPath2}'`);
      }
      matchedMockDispatches = matchedMockDispatches.filter(({ method }) => matchValue(method, key.method));
      if (matchedMockDispatches.length === 0) {
        throw new MockNotMatchedError(`Mock dispatch not matched for method '${key.method}' on path '${resolvedPath2}'`);
      }
      matchedMockDispatches = matchedMockDispatches.filter(({ body }) => typeof body !== "undefined" ? matchValue(body, key.body) : true);
      if (matchedMockDispatches.length === 0) {
        throw new MockNotMatchedError(`Mock dispatch not matched for body '${key.body}' on path '${resolvedPath2}'`);
      }
      matchedMockDispatches = matchedMockDispatches.filter((mockDispatch2) => matchHeaders(mockDispatch2, key.headers));
      if (matchedMockDispatches.length === 0) {
        const headers = typeof key.headers === "object" ? JSON.stringify(key.headers) : key.headers;
        throw new MockNotMatchedError(`Mock dispatch not matched for headers '${headers}' on path '${resolvedPath2}'`);
      }
      return matchedMockDispatches[0];
    }
    __name(getMockDispatch, "getMockDispatch");
    function addMockDispatch(mockDispatches, key, data, opts) {
      const baseData = { timesInvoked: 0, times: 1, persist: false, consumed: false, ...opts };
      const replyData = typeof data === "function" ? { callback: data } : { ...data };
      const newMockDispatch = { ...baseData, ...key, pending: true, data: { error: null, ...replyData } };
      mockDispatches.push(newMockDispatch);
      return newMockDispatch;
    }
    __name(addMockDispatch, "addMockDispatch");
    function deleteMockDispatch(mockDispatches, key) {
      const index = mockDispatches.findIndex((dispatch) => {
        if (!dispatch.consumed) {
          return false;
        }
        return matchKey(dispatch, key);
      });
      if (index !== -1) {
        mockDispatches.splice(index, 1);
      }
    }
    __name(deleteMockDispatch, "deleteMockDispatch");
    function removeTrailingSlash2(path77) {
      while (path77.endsWith("/")) {
        path77 = path77.slice(0, -1);
      }
      if (path77.length === 0) {
        path77 = "/";
      }
      return path77;
    }
    __name(removeTrailingSlash2, "removeTrailingSlash");
    function buildKey(opts) {
      const { path: path77, method, body, headers, query } = opts;
      return {
        path: path77,
        method,
        body,
        headers,
        query
      };
    }
    __name(buildKey, "buildKey");
    function generateKeyValues(data) {
      const keys = Object.keys(data);
      const result = [];
      for (let i6 = 0; i6 < keys.length; ++i6) {
        const key = keys[i6];
        const value = data[key];
        const name2 = Buffer.from(`${key}`);
        if (Array.isArray(value)) {
          for (let j7 = 0; j7 < value.length; ++j7) {
            result.push(name2, Buffer.from(`${value[j7]}`));
          }
        } else {
          result.push(name2, Buffer.from(`${value}`));
        }
      }
      return result;
    }
    __name(generateKeyValues, "generateKeyValues");
    function getStatusText(statusCode) {
      return STATUS_CODES2[statusCode] || "unknown";
    }
    __name(getStatusText, "getStatusText");
    async function getResponse(body) {
      const buffers = [];
      for await (const data of body) {
        buffers.push(data);
      }
      return Buffer.concat(buffers).toString("utf8");
    }
    __name(getResponse, "getResponse");
    function mockDispatch(opts, handler) {
      const key = buildKey(opts);
      const mockDispatch2 = getMockDispatch(this[kDispatches], key);
      mockDispatch2.timesInvoked++;
      if (mockDispatch2.data.callback) {
        mockDispatch2.data = { ...mockDispatch2.data, ...mockDispatch2.data.callback(opts) };
      }
      const { data: { statusCode, data, headers, trailers, error: error2 }, delay, persist } = mockDispatch2;
      const { timesInvoked, times } = mockDispatch2;
      mockDispatch2.consumed = !persist && timesInvoked >= times;
      mockDispatch2.pending = timesInvoked < times;
      if (error2 !== null) {
        deleteMockDispatch(this[kDispatches], key);
        handler.onError(error2);
        return true;
      }
      if (typeof delay === "number" && delay > 0) {
        setTimeout(() => {
          handleReply(this[kDispatches]);
        }, delay);
      } else {
        handleReply(this[kDispatches]);
      }
      function handleReply(mockDispatches, _data5 = data) {
        const optsHeaders = Array.isArray(opts.headers) ? buildHeadersFromArray(opts.headers) : opts.headers;
        const body = typeof _data5 === "function" ? _data5({ ...opts, headers: optsHeaders }) : _data5;
        if (isPromise2(body)) {
          body.then((newData) => handleReply(mockDispatches, newData));
          return;
        }
        const responseData = getResponseData(body);
        const responseHeaders = generateKeyValues(headers);
        const responseTrailers = generateKeyValues(trailers);
        handler.onConnect?.((err) => handler.onError(err), null);
        handler.onHeaders?.(statusCode, responseHeaders, resume, getStatusText(statusCode));
        handler.onData?.(Buffer.from(responseData));
        handler.onComplete?.(responseTrailers);
        deleteMockDispatch(mockDispatches, key);
      }
      __name(handleReply, "handleReply");
      function resume() {
      }
      __name(resume, "resume");
      return true;
    }
    __name(mockDispatch, "mockDispatch");
    function buildMockDispatch() {
      const agent = this[kMockAgent];
      const origin = this[kOrigin];
      const originalDispatch = this[kOriginalDispatch];
      return /* @__PURE__ */ __name(function dispatch(opts, handler) {
        if (agent.isMockActive) {
          try {
            mockDispatch.call(this, opts, handler);
          } catch (error2) {
            if (error2 instanceof MockNotMatchedError) {
              const netConnect = agent[kGetNetConnect]();
              if (netConnect === false) {
                throw new MockNotMatchedError(`${error2.message}: subsequent request to origin ${origin} was not allowed (net.connect disabled)`);
              }
              if (checkNetConnect(netConnect, origin)) {
                originalDispatch.call(this, opts, handler);
              } else {
                throw new MockNotMatchedError(`${error2.message}: subsequent request to origin ${origin} was not allowed (net.connect is not enabled for this origin)`);
              }
            } else {
              throw error2;
            }
          }
        } else {
          originalDispatch.call(this, opts, handler);
        }
      }, "dispatch");
    }
    __name(buildMockDispatch, "buildMockDispatch");
    function checkNetConnect(netConnect, origin) {
      const url4 = new URL(origin);
      if (netConnect === true) {
        return true;
      } else if (Array.isArray(netConnect) && netConnect.some((matcher) => matchValue(matcher, url4.host))) {
        return true;
      }
      return false;
    }
    __name(checkNetConnect, "checkNetConnect");
    function buildAndValidateMockOptions(opts) {
      if (opts) {
        const { agent, ...mockOptions } = opts;
        if ("enableCallHistory" in mockOptions && typeof mockOptions.enableCallHistory !== "boolean") {
          throw new InvalidArgumentError("options.enableCallHistory must to be a boolean");
        }
        if ("acceptNonStandardSearchParameters" in mockOptions && typeof mockOptions.acceptNonStandardSearchParameters !== "boolean") {
          throw new InvalidArgumentError("options.acceptNonStandardSearchParameters must to be a boolean");
        }
        return mockOptions;
      }
    }
    __name(buildAndValidateMockOptions, "buildAndValidateMockOptions");
    module3.exports = {
      getResponseData,
      getMockDispatch,
      addMockDispatch,
      deleteMockDispatch,
      buildKey,
      generateKeyValues,
      matchValue,
      getResponse,
      getStatusText,
      mockDispatch,
      buildMockDispatch,
      checkNetConnect,
      buildAndValidateMockOptions,
      getHeaderByName,
      buildHeadersFromArray,
      normalizeSearchParams
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-interceptor.js
var require_mock_interceptor = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-interceptor.js"(exports2, module3) {
    init_import_meta_url();
    var { getResponseData, buildKey, addMockDispatch } = require_mock_utils();
    var {
      kDispatches,
      kDispatchKey,
      kDefaultHeaders,
      kDefaultTrailers,
      kContentLength,
      kMockDispatch,
      kIgnoreTrailingSlash
    } = require_mock_symbols();
    var { InvalidArgumentError } = require_errors();
    var { serializePathWithQuery } = require_util();
    var MockScope = class {
      static {
        __name(this, "MockScope");
      }
      constructor(mockDispatch) {
        this[kMockDispatch] = mockDispatch;
      }
      /**
       * Delay a reply by a set amount in ms.
       */
      delay(waitInMs) {
        if (typeof waitInMs !== "number" || !Number.isInteger(waitInMs) || waitInMs <= 0) {
          throw new InvalidArgumentError("waitInMs must be a valid integer > 0");
        }
        this[kMockDispatch].delay = waitInMs;
        return this;
      }
      /**
       * For a defined reply, never mark as consumed.
       */
      persist() {
        this[kMockDispatch].persist = true;
        return this;
      }
      /**
       * Allow one to define a reply for a set amount of matching requests.
       */
      times(repeatTimes) {
        if (typeof repeatTimes !== "number" || !Number.isInteger(repeatTimes) || repeatTimes <= 0) {
          throw new InvalidArgumentError("repeatTimes must be a valid integer > 0");
        }
        this[kMockDispatch].times = repeatTimes;
        return this;
      }
    };
    var MockInterceptor = class {
      static {
        __name(this, "MockInterceptor");
      }
      constructor(opts, mockDispatches) {
        if (typeof opts !== "object") {
          throw new InvalidArgumentError("opts must be an object");
        }
        if (typeof opts.path === "undefined") {
          throw new InvalidArgumentError("opts.path must be defined");
        }
        if (typeof opts.method === "undefined") {
          opts.method = "GET";
        }
        if (typeof opts.path === "string") {
          if (opts.query) {
            opts.path = serializePathWithQuery(opts.path, opts.query);
          } else {
            const parsedURL = new URL(opts.path, "data://");
            opts.path = parsedURL.pathname + parsedURL.search;
          }
        }
        if (typeof opts.method === "string") {
          opts.method = opts.method.toUpperCase();
        }
        this[kDispatchKey] = buildKey(opts);
        this[kDispatches] = mockDispatches;
        this[kIgnoreTrailingSlash] = opts.ignoreTrailingSlash ?? false;
        this[kDefaultHeaders] = {};
        this[kDefaultTrailers] = {};
        this[kContentLength] = false;
      }
      createMockScopeDispatchData({ statusCode, data, responseOptions }) {
        const responseData = getResponseData(data);
        const contentLength = this[kContentLength] ? { "content-length": responseData.length } : {};
        const headers = { ...this[kDefaultHeaders], ...contentLength, ...responseOptions.headers };
        const trailers = { ...this[kDefaultTrailers], ...responseOptions.trailers };
        return { statusCode, data, headers, trailers };
      }
      validateReplyParameters(replyParameters) {
        if (typeof replyParameters.statusCode === "undefined") {
          throw new InvalidArgumentError("statusCode must be defined");
        }
        if (typeof replyParameters.responseOptions !== "object" || replyParameters.responseOptions === null) {
          throw new InvalidArgumentError("responseOptions must be an object");
        }
      }
      /**
       * Mock an undici request with a defined reply.
       */
      reply(replyOptionsCallbackOrStatusCode) {
        if (typeof replyOptionsCallbackOrStatusCode === "function") {
          const wrappedDefaultsCallback = /* @__PURE__ */ __name((opts) => {
            const resolvedData = replyOptionsCallbackOrStatusCode(opts);
            if (typeof resolvedData !== "object" || resolvedData === null) {
              throw new InvalidArgumentError("reply options callback must return an object");
            }
            const replyParameters2 = { data: "", responseOptions: {}, ...resolvedData };
            this.validateReplyParameters(replyParameters2);
            return {
              ...this.createMockScopeDispatchData(replyParameters2)
            };
          }, "wrappedDefaultsCallback");
          const newMockDispatch2 = addMockDispatch(this[kDispatches], this[kDispatchKey], wrappedDefaultsCallback, { ignoreTrailingSlash: this[kIgnoreTrailingSlash] });
          return new MockScope(newMockDispatch2);
        }
        const replyParameters = {
          statusCode: replyOptionsCallbackOrStatusCode,
          data: arguments[1] === void 0 ? "" : arguments[1],
          responseOptions: arguments[2] === void 0 ? {} : arguments[2]
        };
        this.validateReplyParameters(replyParameters);
        const dispatchData = this.createMockScopeDispatchData(replyParameters);
        const newMockDispatch = addMockDispatch(this[kDispatches], this[kDispatchKey], dispatchData, { ignoreTrailingSlash: this[kIgnoreTrailingSlash] });
        return new MockScope(newMockDispatch);
      }
      /**
       * Mock an undici request with a defined error.
       */
      replyWithError(error2) {
        if (typeof error2 === "undefined") {
          throw new InvalidArgumentError("error must be defined");
        }
        const newMockDispatch = addMockDispatch(this[kDispatches], this[kDispatchKey], { error: error2 }, { ignoreTrailingSlash: this[kIgnoreTrailingSlash] });
        return new MockScope(newMockDispatch);
      }
      /**
       * Set default reply headers on the interceptor for subsequent replies
       */
      defaultReplyHeaders(headers) {
        if (typeof headers === "undefined") {
          throw new InvalidArgumentError("headers must be defined");
        }
        this[kDefaultHeaders] = headers;
        return this;
      }
      /**
       * Set default reply trailers on the interceptor for subsequent replies
       */
      defaultReplyTrailers(trailers) {
        if (typeof trailers === "undefined") {
          throw new InvalidArgumentError("trailers must be defined");
        }
        this[kDefaultTrailers] = trailers;
        return this;
      }
      /**
       * Set reply content length header for replies on the interceptor
       */
      replyContentLength() {
        this[kContentLength] = true;
        return this;
      }
    };
    module3.exports.MockInterceptor = MockInterceptor;
    module3.exports.MockScope = MockScope;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-client.js
var require_mock_client = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-client.js"(exports2, module3) {
    init_import_meta_url();
    var { promisify: promisify3 } = __require("util");
    var Client2 = require_client();
    var { buildMockDispatch } = require_mock_utils();
    var {
      kDispatches,
      kMockAgent,
      kClose,
      kOriginalClose,
      kOrigin,
      kOriginalDispatch,
      kConnected,
      kIgnoreTrailingSlash
    } = require_mock_symbols();
    var { MockInterceptor } = require_mock_interceptor();
    var Symbols = require_symbols();
    var { InvalidArgumentError } = require_errors();
    var MockClient = class extends Client2 {
      static {
        __name(this, "MockClient");
      }
      constructor(origin, opts) {
        if (!opts || !opts.agent || typeof opts.agent.dispatch !== "function") {
          throw new InvalidArgumentError("Argument opts.agent must implement Agent");
        }
        super(origin, opts);
        this[kMockAgent] = opts.agent;
        this[kOrigin] = origin;
        this[kIgnoreTrailingSlash] = opts.ignoreTrailingSlash ?? false;
        this[kDispatches] = [];
        this[kConnected] = 1;
        this[kOriginalDispatch] = this.dispatch;
        this[kOriginalClose] = this.close.bind(this);
        this.dispatch = buildMockDispatch.call(this);
        this.close = this[kClose];
      }
      get [Symbols.kConnected]() {
        return this[kConnected];
      }
      /**
       * Sets up the base interceptor for mocking replies from undici.
       */
      intercept(opts) {
        return new MockInterceptor(
          opts && { ignoreTrailingSlash: this[kIgnoreTrailingSlash], ...opts },
          this[kDispatches]
        );
      }
      cleanMocks() {
        this[kDispatches] = [];
      }
      async [kClose]() {
        await promisify3(this[kOriginalClose])();
        this[kConnected] = 0;
        this[kMockAgent][Symbols.kClients].delete(this[kOrigin]);
      }
    };
    module3.exports = MockClient;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-call-history.js
var require_mock_call_history = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-call-history.js"(exports2, module3) {
    init_import_meta_url();
    var { kMockCallHistoryAddLog } = require_mock_symbols();
    var { InvalidArgumentError } = require_errors();
    function handleFilterCallsWithOptions(criteria, options, handler, store) {
      switch (options.operator) {
        case "OR":
          store.push(...handler(criteria));
          return store;
        case "AND":
          return handler.call({ logs: store }, criteria);
        default:
          throw new InvalidArgumentError("options.operator must to be a case insensitive string equal to 'OR' or 'AND'");
      }
    }
    __name(handleFilterCallsWithOptions, "handleFilterCallsWithOptions");
    function buildAndValidateFilterCallsOptions(options = {}) {
      const finalOptions = {};
      if ("operator" in options) {
        if (typeof options.operator !== "string" || options.operator.toUpperCase() !== "OR" && options.operator.toUpperCase() !== "AND") {
          throw new InvalidArgumentError("options.operator must to be a case insensitive string equal to 'OR' or 'AND'");
        }
        return {
          ...finalOptions,
          operator: options.operator.toUpperCase()
        };
      }
      return finalOptions;
    }
    __name(buildAndValidateFilterCallsOptions, "buildAndValidateFilterCallsOptions");
    function makeFilterCalls(parameterName) {
      return (parameterValue) => {
        if (typeof parameterValue === "string" || parameterValue == null) {
          return this.logs.filter((log2) => {
            return log2[parameterName] === parameterValue;
          });
        }
        if (parameterValue instanceof RegExp) {
          return this.logs.filter((log2) => {
            return parameterValue.test(log2[parameterName]);
          });
        }
        throw new InvalidArgumentError(`${parameterName} parameter should be one of string, regexp, undefined or null`);
      };
    }
    __name(makeFilterCalls, "makeFilterCalls");
    function computeUrlWithMaybeSearchParameters(requestInit) {
      try {
        const url4 = new URL(requestInit.path, requestInit.origin);
        if (url4.search.length !== 0) {
          return url4;
        }
        url4.search = new URLSearchParams(requestInit.query).toString();
        return url4;
      } catch (error2) {
        throw new InvalidArgumentError("An error occurred when computing MockCallHistoryLog.url", { cause: error2 });
      }
    }
    __name(computeUrlWithMaybeSearchParameters, "computeUrlWithMaybeSearchParameters");
    var MockCallHistoryLog = class {
      static {
        __name(this, "MockCallHistoryLog");
      }
      constructor(requestInit = {}) {
        this.body = requestInit.body;
        this.headers = requestInit.headers;
        this.method = requestInit.method;
        const url4 = computeUrlWithMaybeSearchParameters(requestInit);
        this.fullUrl = url4.toString();
        this.origin = url4.origin;
        this.path = url4.pathname;
        this.searchParams = Object.fromEntries(url4.searchParams);
        this.protocol = url4.protocol;
        this.host = url4.host;
        this.port = url4.port;
        this.hash = url4.hash;
      }
      toMap() {
        return /* @__PURE__ */ new Map(
          [
            ["protocol", this.protocol],
            ["host", this.host],
            ["port", this.port],
            ["origin", this.origin],
            ["path", this.path],
            ["hash", this.hash],
            ["searchParams", this.searchParams],
            ["fullUrl", this.fullUrl],
            ["method", this.method],
            ["body", this.body],
            ["headers", this.headers]
          ]
        );
      }
      toString() {
        const options = { betweenKeyValueSeparator: "->", betweenPairSeparator: "|" };
        let result = "";
        this.toMap().forEach((value, key) => {
          if (typeof value === "string" || value === void 0 || value === null) {
            result = `${result}${key}${options.betweenKeyValueSeparator}${value}${options.betweenPairSeparator}`;
          }
          if (typeof value === "object" && value !== null || Array.isArray(value)) {
            result = `${result}${key}${options.betweenKeyValueSeparator}${JSON.stringify(value)}${options.betweenPairSeparator}`;
          }
        });
        return result.slice(0, -1);
      }
    };
    var MockCallHistory = class {
      static {
        __name(this, "MockCallHistory");
      }
      logs = [];
      calls() {
        return this.logs;
      }
      firstCall() {
        return this.logs.at(0);
      }
      lastCall() {
        return this.logs.at(-1);
      }
      nthCall(number) {
        if (typeof number !== "number") {
          throw new InvalidArgumentError("nthCall must be called with a number");
        }
        if (!Number.isInteger(number)) {
          throw new InvalidArgumentError("nthCall must be called with an integer");
        }
        if (Math.sign(number) !== 1) {
          throw new InvalidArgumentError("nthCall must be called with a positive value. use firstCall or lastCall instead");
        }
        return this.logs.at(number - 1);
      }
      filterCalls(criteria, options) {
        if (this.logs.length === 0) {
          return this.logs;
        }
        if (typeof criteria === "function") {
          return this.logs.filter(criteria);
        }
        if (criteria instanceof RegExp) {
          return this.logs.filter((log2) => {
            return criteria.test(log2.toString());
          });
        }
        if (typeof criteria === "object" && criteria !== null) {
          if (Object.keys(criteria).length === 0) {
            return this.logs;
          }
          const finalOptions = { operator: "OR", ...buildAndValidateFilterCallsOptions(options) };
          let maybeDuplicatedLogsFiltered = [];
          if ("protocol" in criteria) {
            maybeDuplicatedLogsFiltered = handleFilterCallsWithOptions(criteria.protocol, finalOptions, this.filterCallsByProtocol, maybeDuplicatedLogsFiltered);
          }
          if ("host" in criteria) {
            maybeDuplicatedLogsFiltered = handleFilterCallsWithOptions(criteria.host, finalOptions, this.filterCallsByHost, maybeDuplicatedLogsFiltered);
          }
          if ("port" in criteria) {
            maybeDuplicatedLogsFiltered = handleFilterCallsWithOptions(criteria.port, finalOptions, this.filterCallsByPort, maybeDuplicatedLogsFiltered);
          }
          if ("origin" in criteria) {
            maybeDuplicatedLogsFiltered = handleFilterCallsWithOptions(criteria.origin, finalOptions, this.filterCallsByOrigin, maybeDuplicatedLogsFiltered);
          }
          if ("path" in criteria) {
            maybeDuplicatedLogsFiltered = handleFilterCallsWithOptions(criteria.path, finalOptions, this.filterCallsByPath, maybeDuplicatedLogsFiltered);
          }
          if ("hash" in criteria) {
            maybeDuplicatedLogsFiltered = handleFilterCallsWithOptions(criteria.hash, finalOptions, this.filterCallsByHash, maybeDuplicatedLogsFiltered);
          }
          if ("fullUrl" in criteria) {
            maybeDuplicatedLogsFiltered = handleFilterCallsWithOptions(criteria.fullUrl, finalOptions, this.filterCallsByFullUrl, maybeDuplicatedLogsFiltered);
          }
          if ("method" in criteria) {
            maybeDuplicatedLogsFiltered = handleFilterCallsWithOptions(criteria.method, finalOptions, this.filterCallsByMethod, maybeDuplicatedLogsFiltered);
          }
          const uniqLogsFiltered = [...new Set(maybeDuplicatedLogsFiltered)];
          return uniqLogsFiltered;
        }
        throw new InvalidArgumentError("criteria parameter should be one of function, regexp, or object");
      }
      filterCallsByProtocol = makeFilterCalls.call(this, "protocol");
      filterCallsByHost = makeFilterCalls.call(this, "host");
      filterCallsByPort = makeFilterCalls.call(this, "port");
      filterCallsByOrigin = makeFilterCalls.call(this, "origin");
      filterCallsByPath = makeFilterCalls.call(this, "path");
      filterCallsByHash = makeFilterCalls.call(this, "hash");
      filterCallsByFullUrl = makeFilterCalls.call(this, "fullUrl");
      filterCallsByMethod = makeFilterCalls.call(this, "method");
      clear() {
        this.logs = [];
      }
      [kMockCallHistoryAddLog](requestInit) {
        const log2 = new MockCallHistoryLog(requestInit);
        this.logs.push(log2);
        return log2;
      }
      *[Symbol.iterator]() {
        for (const log2 of this.calls()) {
          yield log2;
        }
      }
    };
    module3.exports.MockCallHistory = MockCallHistory;
    module3.exports.MockCallHistoryLog = MockCallHistoryLog;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-pool.js
var require_mock_pool = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-pool.js"(exports2, module3) {
    init_import_meta_url();
    var { promisify: promisify3 } = __require("util");
    var Pool = require_pool();
    var { buildMockDispatch } = require_mock_utils();
    var {
      kDispatches,
      kMockAgent,
      kClose,
      kOriginalClose,
      kOrigin,
      kOriginalDispatch,
      kConnected,
      kIgnoreTrailingSlash
    } = require_mock_symbols();
    var { MockInterceptor } = require_mock_interceptor();
    var Symbols = require_symbols();
    var { InvalidArgumentError } = require_errors();
    var MockPool = class extends Pool {
      static {
        __name(this, "MockPool");
      }
      constructor(origin, opts) {
        if (!opts || !opts.agent || typeof opts.agent.dispatch !== "function") {
          throw new InvalidArgumentError("Argument opts.agent must implement Agent");
        }
        super(origin, opts);
        this[kMockAgent] = opts.agent;
        this[kOrigin] = origin;
        this[kIgnoreTrailingSlash] = opts.ignoreTrailingSlash ?? false;
        this[kDispatches] = [];
        this[kConnected] = 1;
        this[kOriginalDispatch] = this.dispatch;
        this[kOriginalClose] = this.close.bind(this);
        this.dispatch = buildMockDispatch.call(this);
        this.close = this[kClose];
      }
      get [Symbols.kConnected]() {
        return this[kConnected];
      }
      /**
       * Sets up the base interceptor for mocking replies from undici.
       */
      intercept(opts) {
        return new MockInterceptor(
          opts && { ignoreTrailingSlash: this[kIgnoreTrailingSlash], ...opts },
          this[kDispatches]
        );
      }
      cleanMocks() {
        this[kDispatches] = [];
      }
      async [kClose]() {
        await promisify3(this[kOriginalClose])();
        this[kConnected] = 0;
        this[kMockAgent][Symbols.kClients].delete(this[kOrigin]);
      }
    };
    module3.exports = MockPool;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/pending-interceptors-formatter.js
var require_pending_interceptors_formatter = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/pending-interceptors-formatter.js"(exports2, module3) {
    init_import_meta_url();
    var { Transform: Transform2 } = __require("stream");
    var { Console: Console2 } = __require("console");
    var PERSISTENT = process.versions.icu ? "\u2705" : "Y ";
    var NOT_PERSISTENT = process.versions.icu ? "\u274C" : "N ";
    module3.exports = class PendingInterceptorsFormatter {
      static {
        __name(this, "PendingInterceptorsFormatter");
      }
      constructor({ disableColors } = {}) {
        this.transform = new Transform2({
          transform(chunk, _enc, cb2) {
            cb2(null, chunk);
          }
        });
        this.logger = new Console2({
          stdout: this.transform,
          inspectOptions: {
            colors: !disableColors && !process.env.CI
          }
        });
      }
      format(pendingInterceptors) {
        const withPrettyHeaders = pendingInterceptors.map(
          ({ method, path: path77, data: { statusCode }, persist, times, timesInvoked, origin }) => ({
            Method: method,
            Origin: origin,
            Path: path77,
            "Status code": statusCode,
            Persistent: persist ? PERSISTENT : NOT_PERSISTENT,
            Invocations: timesInvoked,
            Remaining: persist ? Infinity : times - timesInvoked
          })
        );
        this.logger.table(withPrettyHeaders);
        return this.transform.read().toString();
      }
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-agent.js
var require_mock_agent = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/mock-agent.js"(exports2, module3) {
    init_import_meta_url();
    var { kClients } = require_symbols();
    var Agent = require_agent();
    var {
      kAgent,
      kMockAgentSet,
      kMockAgentGet,
      kDispatches,
      kIsMockActive,
      kNetConnect,
      kGetNetConnect,
      kOptions,
      kFactory,
      kMockAgentRegisterCallHistory,
      kMockAgentIsCallHistoryEnabled,
      kMockAgentAddCallHistoryLog,
      kMockAgentMockCallHistoryInstance,
      kMockAgentAcceptsNonStandardSearchParameters,
      kMockCallHistoryAddLog,
      kIgnoreTrailingSlash
    } = require_mock_symbols();
    var MockClient = require_mock_client();
    var MockPool = require_mock_pool();
    var { matchValue, normalizeSearchParams, buildAndValidateMockOptions } = require_mock_utils();
    var { InvalidArgumentError, UndiciError } = require_errors();
    var Dispatcher2 = require_dispatcher();
    var PendingInterceptorsFormatter = require_pending_interceptors_formatter();
    var { MockCallHistory } = require_mock_call_history();
    var MockAgent = class extends Dispatcher2 {
      static {
        __name(this, "MockAgent");
      }
      constructor(opts) {
        super(opts);
        const mockOptions = buildAndValidateMockOptions(opts);
        this[kNetConnect] = true;
        this[kIsMockActive] = true;
        this[kMockAgentIsCallHistoryEnabled] = mockOptions?.enableCallHistory ?? false;
        this[kMockAgentAcceptsNonStandardSearchParameters] = mockOptions?.acceptNonStandardSearchParameters ?? false;
        this[kIgnoreTrailingSlash] = mockOptions?.ignoreTrailingSlash ?? false;
        if (opts?.agent && typeof opts.agent.dispatch !== "function") {
          throw new InvalidArgumentError("Argument opts.agent must implement Agent");
        }
        const agent = opts?.agent ? opts.agent : new Agent(opts);
        this[kAgent] = agent;
        this[kClients] = agent[kClients];
        this[kOptions] = mockOptions;
        if (this[kMockAgentIsCallHistoryEnabled]) {
          this[kMockAgentRegisterCallHistory]();
        }
      }
      get(origin) {
        const originKey = this[kIgnoreTrailingSlash] ? origin.replace(/\/$/, "") : origin;
        let dispatcher = this[kMockAgentGet](originKey);
        if (!dispatcher) {
          dispatcher = this[kFactory](originKey);
          this[kMockAgentSet](originKey, dispatcher);
        }
        return dispatcher;
      }
      dispatch(opts, handler) {
        this.get(opts.origin);
        this[kMockAgentAddCallHistoryLog](opts);
        const acceptNonStandardSearchParameters = this[kMockAgentAcceptsNonStandardSearchParameters];
        const dispatchOpts = { ...opts };
        if (acceptNonStandardSearchParameters && dispatchOpts.path) {
          const [path77, searchParams] = dispatchOpts.path.split("?");
          const normalizedSearchParams = normalizeSearchParams(searchParams, acceptNonStandardSearchParameters);
          dispatchOpts.path = `${path77}?${normalizedSearchParams}`;
        }
        return this[kAgent].dispatch(dispatchOpts, handler);
      }
      async close() {
        this.clearCallHistory();
        await this[kAgent].close();
        this[kClients].clear();
      }
      deactivate() {
        this[kIsMockActive] = false;
      }
      activate() {
        this[kIsMockActive] = true;
      }
      enableNetConnect(matcher) {
        if (typeof matcher === "string" || typeof matcher === "function" || matcher instanceof RegExp) {
          if (Array.isArray(this[kNetConnect])) {
            this[kNetConnect].push(matcher);
          } else {
            this[kNetConnect] = [matcher];
          }
        } else if (typeof matcher === "undefined") {
          this[kNetConnect] = true;
        } else {
          throw new InvalidArgumentError("Unsupported matcher. Must be one of String|Function|RegExp.");
        }
      }
      disableNetConnect() {
        this[kNetConnect] = false;
      }
      enableCallHistory() {
        this[kMockAgentIsCallHistoryEnabled] = true;
        return this;
      }
      disableCallHistory() {
        this[kMockAgentIsCallHistoryEnabled] = false;
        return this;
      }
      getCallHistory() {
        return this[kMockAgentMockCallHistoryInstance];
      }
      clearCallHistory() {
        if (this[kMockAgentMockCallHistoryInstance] !== void 0) {
          this[kMockAgentMockCallHistoryInstance].clear();
        }
      }
      // This is required to bypass issues caused by using global symbols - see:
      // https://github.com/nodejs/undici/issues/1447
      get isMockActive() {
        return this[kIsMockActive];
      }
      [kMockAgentRegisterCallHistory]() {
        if (this[kMockAgentMockCallHistoryInstance] === void 0) {
          this[kMockAgentMockCallHistoryInstance] = new MockCallHistory();
        }
      }
      [kMockAgentAddCallHistoryLog](opts) {
        if (this[kMockAgentIsCallHistoryEnabled]) {
          this[kMockAgentRegisterCallHistory]();
          this[kMockAgentMockCallHistoryInstance][kMockCallHistoryAddLog](opts);
        }
      }
      [kMockAgentSet](origin, dispatcher) {
        this[kClients].set(origin, { count: 0, dispatcher });
      }
      [kFactory](origin) {
        const mockOptions = Object.assign({ agent: this }, this[kOptions]);
        return this[kOptions] && this[kOptions].connections === 1 ? new MockClient(origin, mockOptions) : new MockPool(origin, mockOptions);
      }
      [kMockAgentGet](origin) {
        const result = this[kClients].get(origin);
        if (result?.dispatcher) {
          return result.dispatcher;
        }
        if (typeof origin !== "string") {
          const dispatcher = this[kFactory]("http://localhost:9999");
          this[kMockAgentSet](origin, dispatcher);
          return dispatcher;
        }
        for (const [keyMatcher, result2] of Array.from(this[kClients])) {
          if (result2 && typeof keyMatcher !== "string" && matchValue(keyMatcher, origin)) {
            const dispatcher = this[kFactory](origin);
            this[kMockAgentSet](origin, dispatcher);
            dispatcher[kDispatches] = result2.dispatcher[kDispatches];
            return dispatcher;
          }
        }
      }
      [kGetNetConnect]() {
        return this[kNetConnect];
      }
      pendingInterceptors() {
        const mockAgentClients = this[kClients];
        return Array.from(mockAgentClients.entries()).flatMap(([origin, result]) => result.dispatcher[kDispatches].map((dispatch) => ({ ...dispatch, origin }))).filter(({ pending }) => pending);
      }
      assertNoPendingInterceptors({ pendingInterceptorsFormatter = new PendingInterceptorsFormatter() } = {}) {
        const pending = this.pendingInterceptors();
        if (pending.length === 0) {
          return;
        }
        throw new UndiciError(
          pending.length === 1 ? `1 interceptor is pending:

${pendingInterceptorsFormatter.format(pending)}`.trim() : `${pending.length} interceptors are pending:

${pendingInterceptorsFormatter.format(pending)}`.trim()
        );
      }
    };
    module3.exports = MockAgent;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/snapshot-utils.js
var require_snapshot_utils = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/snapshot-utils.js"(exports2, module3) {
    init_import_meta_url();
    var { InvalidArgumentError } = require_errors();
    function createHeaderFilters(matchOptions = {}) {
      const { ignoreHeaders = [], excludeHeaders = [], matchHeaders = [], caseSensitive = false } = matchOptions;
      return {
        ignore: new Set(ignoreHeaders.map((header) => caseSensitive ? header : header.toLowerCase())),
        exclude: new Set(excludeHeaders.map((header) => caseSensitive ? header : header.toLowerCase())),
        match: new Set(matchHeaders.map((header) => caseSensitive ? header : header.toLowerCase()))
      };
    }
    __name(createHeaderFilters, "createHeaderFilters");
    var crypto8;
    try {
      crypto8 = __require("crypto");
    } catch {
    }
    var hashId = crypto8?.hash ? (value) => crypto8.hash("sha256", value, "base64url") : (value) => Buffer.from(value).toString("base64url");
    function isUndiciHeaders(headers) {
      return Array.isArray(headers) && (headers.length & 1) === 0;
    }
    __name(isUndiciHeaders, "isUndiciHeaders");
    function isUrlExcludedFactory(excludePatterns = []) {
      if (excludePatterns.length === 0) {
        return () => false;
      }
      return /* @__PURE__ */ __name(function isUrlExcluded(url4) {
        let urlLowerCased;
        for (const pattern of excludePatterns) {
          if (typeof pattern === "string") {
            if (!urlLowerCased) {
              urlLowerCased = url4.toLowerCase();
            }
            if (urlLowerCased.includes(pattern.toLowerCase())) {
              return true;
            }
          } else if (pattern instanceof RegExp) {
            if (pattern.test(url4)) {
              return true;
            }
          }
        }
        return false;
      }, "isUrlExcluded");
    }
    __name(isUrlExcludedFactory, "isUrlExcludedFactory");
    function normalizeHeaders(headers) {
      const normalizedHeaders = {};
      if (!headers) return normalizedHeaders;
      if (isUndiciHeaders(headers)) {
        for (let i6 = 0; i6 < headers.length; i6 += 2) {
          const key = headers[i6];
          const value = headers[i6 + 1];
          if (key && value !== void 0) {
            const keyStr = Buffer.isBuffer(key) ? key.toString() : key;
            const valueStr = Buffer.isBuffer(value) ? value.toString() : value;
            normalizedHeaders[keyStr.toLowerCase()] = valueStr;
          }
        }
        return normalizedHeaders;
      }
      if (headers && typeof headers === "object") {
        for (const [key, value] of Object.entries(headers)) {
          if (key && typeof key === "string") {
            normalizedHeaders[key.toLowerCase()] = Array.isArray(value) ? value.join(", ") : String(value);
          }
        }
      }
      return normalizedHeaders;
    }
    __name(normalizeHeaders, "normalizeHeaders");
    var validSnapshotModes = (
      /** @type {const} */
      ["record", "playback", "update"]
    );
    function validateSnapshotMode(mode) {
      if (!validSnapshotModes.includes(mode)) {
        throw new InvalidArgumentError(`Invalid snapshot mode: ${mode}. Must be one of: ${validSnapshotModes.join(", ")}`);
      }
    }
    __name(validateSnapshotMode, "validateSnapshotMode");
    module3.exports = {
      createHeaderFilters,
      hashId,
      isUndiciHeaders,
      normalizeHeaders,
      isUrlExcludedFactory,
      validateSnapshotMode
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/snapshot-recorder.js
var require_snapshot_recorder = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/snapshot-recorder.js"(exports2, module3) {
    init_import_meta_url();
    var { writeFile: writeFile12, readFile: readFile17, mkdir: mkdir5 } = __require("fs/promises");
    var { dirname: dirname19, resolve: resolve28 } = __require("path");
    var { setTimeout: setTimeout8, clearTimeout: clearTimeout2 } = __require("timers");
    var { InvalidArgumentError, UndiciError } = require_errors();
    var { hashId, isUrlExcludedFactory, normalizeHeaders, createHeaderFilters } = require_snapshot_utils();
    function formatRequestKey(opts, headerFilters, matchOptions = {}) {
      const url4 = new URL(opts.path, opts.origin);
      const normalized = opts._normalizedHeaders || normalizeHeaders(opts.headers);
      if (!opts._normalizedHeaders) {
        opts._normalizedHeaders = normalized;
      }
      return {
        method: opts.method || "GET",
        url: matchOptions.matchQuery !== false ? url4.toString() : `${url4.origin}${url4.pathname}`,
        headers: filterHeadersForMatching(normalized, headerFilters, matchOptions),
        body: matchOptions.matchBody !== false && opts.body ? String(opts.body) : ""
      };
    }
    __name(formatRequestKey, "formatRequestKey");
    function filterHeadersForMatching(headers, headerFilters, matchOptions = {}) {
      if (!headers || typeof headers !== "object") return {};
      const {
        caseSensitive = false
      } = matchOptions;
      const filtered = {};
      const { ignore: ignore2, exclude, match: match3 } = headerFilters;
      for (const [key, value] of Object.entries(headers)) {
        const headerKey = caseSensitive ? key : key.toLowerCase();
        if (exclude.has(headerKey)) continue;
        if (ignore2.has(headerKey)) continue;
        if (match3.size !== 0) {
          if (!match3.has(headerKey)) continue;
        }
        filtered[headerKey] = value;
      }
      return filtered;
    }
    __name(filterHeadersForMatching, "filterHeadersForMatching");
    function filterHeadersForStorage(headers, headerFilters, matchOptions = {}) {
      if (!headers || typeof headers !== "object") return {};
      const {
        caseSensitive = false
      } = matchOptions;
      const filtered = {};
      const { exclude: excludeSet } = headerFilters;
      for (const [key, value] of Object.entries(headers)) {
        const headerKey = caseSensitive ? key : key.toLowerCase();
        if (excludeSet.has(headerKey)) continue;
        filtered[headerKey] = value;
      }
      return filtered;
    }
    __name(filterHeadersForStorage, "filterHeadersForStorage");
    function createRequestHash(formattedRequest) {
      const parts = [
        formattedRequest.method,
        formattedRequest.url
      ];
      if (formattedRequest.headers && typeof formattedRequest.headers === "object") {
        const headerKeys = Object.keys(formattedRequest.headers).sort();
        for (const key of headerKeys) {
          const values = Array.isArray(formattedRequest.headers[key]) ? formattedRequest.headers[key] : [formattedRequest.headers[key]];
          parts.push(key);
          for (const value of values.sort()) {
            parts.push(String(value));
          }
        }
      }
      parts.push(formattedRequest.body);
      const content = parts.join("|");
      return hashId(content);
    }
    __name(createRequestHash, "createRequestHash");
    var SnapshotRecorder = class {
      static {
        __name(this, "SnapshotRecorder");
      }
      /** @type {NodeJS.Timeout | null} */
      #flushTimeout;
      /** @type {import('./snapshot-utils').IsUrlExcluded} */
      #isUrlExcluded;
      /** @type {Map<string, SnapshotEntry>} */
      #snapshots = /* @__PURE__ */ new Map();
      /** @type {string|undefined} */
      #snapshotPath;
      /** @type {number} */
      #maxSnapshots = Infinity;
      /** @type {boolean} */
      #autoFlush = false;
      /** @type {import('./snapshot-utils').HeaderFilters} */
      #headerFilters;
      /**
       * Creates a new SnapshotRecorder instance
       * @param {SnapshotRecorderOptions&SnapshotRecorderMatchOptions} [options={}] - Configuration options for the recorder
       */
      constructor(options = {}) {
        this.#snapshotPath = options.snapshotPath;
        this.#maxSnapshots = options.maxSnapshots || Infinity;
        this.#autoFlush = options.autoFlush || false;
        this.flushInterval = options.flushInterval || 3e4;
        this._flushTimer = null;
        this.matchOptions = {
          matchHeaders: options.matchHeaders || [],
          // empty means match all headers
          ignoreHeaders: options.ignoreHeaders || [],
          excludeHeaders: options.excludeHeaders || [],
          matchBody: options.matchBody !== false,
          // default: true
          matchQuery: options.matchQuery !== false,
          // default: true
          caseSensitive: options.caseSensitive || false
        };
        this.#headerFilters = createHeaderFilters(this.matchOptions);
        this.shouldRecord = options.shouldRecord || (() => true);
        this.shouldPlayback = options.shouldPlayback || (() => true);
        this.#isUrlExcluded = isUrlExcludedFactory(options.excludeUrls);
        if (this.#autoFlush && this.#snapshotPath) {
          this.#startAutoFlush();
        }
      }
      /**
       * Records a request-response interaction
       * @param {SnapshotRequestOptions} requestOpts - Request options
       * @param {SnapshotEntryResponse} response - Response data to record
       * @return {Promise<void>} - Resolves when the recording is complete
       */
      async record(requestOpts, response) {
        if (!this.shouldRecord(requestOpts)) {
          return;
        }
        const url4 = new URL(requestOpts.path, requestOpts.origin).toString();
        if (this.#isUrlExcluded(url4)) {
          return;
        }
        const request4 = formatRequestKey(requestOpts, this.#headerFilters, this.matchOptions);
        const hash = createRequestHash(request4);
        const normalizedHeaders = normalizeHeaders(response.headers);
        const responseData = {
          statusCode: response.statusCode,
          headers: filterHeadersForStorage(normalizedHeaders, this.#headerFilters, this.matchOptions),
          body: Buffer.isBuffer(response.body) ? response.body.toString("base64") : Buffer.from(String(response.body || "")).toString("base64"),
          trailers: response.trailers
        };
        if (this.#snapshots.size >= this.#maxSnapshots && !this.#snapshots.has(hash)) {
          const oldestKey = this.#snapshots.keys().next().value;
          this.#snapshots.delete(oldestKey);
        }
        const existingSnapshot = this.#snapshots.get(hash);
        if (existingSnapshot && existingSnapshot.responses) {
          existingSnapshot.responses.push(responseData);
          existingSnapshot.timestamp = (/* @__PURE__ */ new Date()).toISOString();
        } else {
          this.#snapshots.set(hash, {
            request: request4,
            responses: [responseData],
            // Always store as array for consistency
            callCount: 0,
            timestamp: (/* @__PURE__ */ new Date()).toISOString()
          });
        }
        if (this.#autoFlush && this.#snapshotPath) {
          this.#scheduleFlush();
        }
      }
      /**
       * Finds a matching snapshot for the given request
       * Returns the appropriate response based on call count for sequential responses
       *
       * @param {SnapshotRequestOptions} requestOpts - Request options to match
       * @returns {SnapshotEntry&Record<'response', SnapshotEntryResponse>|undefined} - Matching snapshot response or undefined if not found
       */
      findSnapshot(requestOpts) {
        if (!this.shouldPlayback(requestOpts)) {
          return void 0;
        }
        const url4 = new URL(requestOpts.path, requestOpts.origin).toString();
        if (this.#isUrlExcluded(url4)) {
          return void 0;
        }
        const request4 = formatRequestKey(requestOpts, this.#headerFilters, this.matchOptions);
        const hash = createRequestHash(request4);
        const snapshot = this.#snapshots.get(hash);
        if (!snapshot) return void 0;
        const currentCallCount = snapshot.callCount || 0;
        const responseIndex = Math.min(currentCallCount, snapshot.responses.length - 1);
        snapshot.callCount = currentCallCount + 1;
        return {
          ...snapshot,
          response: snapshot.responses[responseIndex]
        };
      }
      /**
       * Loads snapshots from file
       * @param {string} [filePath] - Optional file path to load snapshots from
       * @return {Promise<void>} - Resolves when snapshots are loaded
       */
      async loadSnapshots(filePath) {
        const path77 = filePath || this.#snapshotPath;
        if (!path77) {
          throw new InvalidArgumentError("Snapshot path is required");
        }
        try {
          const data = await readFile17(resolve28(path77), "utf8");
          const parsed = JSON.parse(data);
          if (Array.isArray(parsed)) {
            this.#snapshots.clear();
            for (const { hash, snapshot } of parsed) {
              this.#snapshots.set(hash, snapshot);
            }
          } else {
            this.#snapshots = new Map(Object.entries(parsed));
          }
        } catch (error2) {
          if (error2.code === "ENOENT") {
            this.#snapshots.clear();
          } else {
            throw new UndiciError(`Failed to load snapshots from ${path77}`, { cause: error2 });
          }
        }
      }
      /**
       * Saves snapshots to file
       *
       * @param {string} [filePath] - Optional file path to save snapshots
       * @returns {Promise<void>} - Resolves when snapshots are saved
       */
      async saveSnapshots(filePath) {
        const path77 = filePath || this.#snapshotPath;
        if (!path77) {
          throw new InvalidArgumentError("Snapshot path is required");
        }
        const resolvedPath2 = resolve28(path77);
        await mkdir5(dirname19(resolvedPath2), { recursive: true });
        const data = Array.from(this.#snapshots.entries()).map(([hash, snapshot]) => ({
          hash,
          snapshot
        }));
        await writeFile12(resolvedPath2, JSON.stringify(data, null, 2), { flush: true });
      }
      /**
       * Clears all recorded snapshots
       * @returns {void}
       */
      clear() {
        this.#snapshots.clear();
      }
      /**
       * Gets all recorded snapshots
       * @return {Array<SnapshotEntry>} - Array of all recorded snapshots
       */
      getSnapshots() {
        return Array.from(this.#snapshots.values());
      }
      /**
       * Gets snapshot count
       * @return {number} - Number of recorded snapshots
       */
      size() {
        return this.#snapshots.size;
      }
      /**
       * Resets call counts for all snapshots (useful for test cleanup)
       * @returns {void}
       */
      resetCallCounts() {
        for (const snapshot of this.#snapshots.values()) {
          snapshot.callCount = 0;
        }
      }
      /**
       * Deletes a specific snapshot by request options
       * @param {SnapshotRequestOptions} requestOpts - Request options to match
       * @returns {boolean} - True if snapshot was deleted, false if not found
       */
      deleteSnapshot(requestOpts) {
        const request4 = formatRequestKey(requestOpts, this.#headerFilters, this.matchOptions);
        const hash = createRequestHash(request4);
        return this.#snapshots.delete(hash);
      }
      /**
       * Gets information about a specific snapshot
       * @param {SnapshotRequestOptions} requestOpts - Request options to match
       * @returns {SnapshotInfo|null} - Snapshot information or null if not found
       */
      getSnapshotInfo(requestOpts) {
        const request4 = formatRequestKey(requestOpts, this.#headerFilters, this.matchOptions);
        const hash = createRequestHash(request4);
        const snapshot = this.#snapshots.get(hash);
        if (!snapshot) return null;
        return {
          hash,
          request: snapshot.request,
          responseCount: snapshot.responses ? snapshot.responses.length : snapshot.response ? 1 : 0,
          // .response for legacy snapshots
          callCount: snapshot.callCount || 0,
          timestamp: snapshot.timestamp
        };
      }
      /**
       * Replaces all snapshots with new data (full replacement)
       * @param {Array<{hash: string; snapshot: SnapshotEntry}>|Record<string, SnapshotEntry>} snapshotData - New snapshot data to replace existing ones
       * @returns {void}
       */
      replaceSnapshots(snapshotData) {
        this.#snapshots.clear();
        if (Array.isArray(snapshotData)) {
          for (const { hash, snapshot } of snapshotData) {
            this.#snapshots.set(hash, snapshot);
          }
        } else if (snapshotData && typeof snapshotData === "object") {
          this.#snapshots = new Map(Object.entries(snapshotData));
        }
      }
      /**
       * Starts the auto-flush timer
       * @returns {void}
       */
      #startAutoFlush() {
        return this.#scheduleFlush();
      }
      /**
       * Stops the auto-flush timer
       * @returns {void}
       */
      #stopAutoFlush() {
        if (this.#flushTimeout) {
          clearTimeout2(this.#flushTimeout);
          this.saveSnapshots().catch(() => {
          });
          this.#flushTimeout = null;
        }
      }
      /**
       * Schedules a flush (debounced to avoid excessive writes)
       */
      #scheduleFlush() {
        this.#flushTimeout = setTimeout8(() => {
          this.saveSnapshots().catch(() => {
          });
          if (this.#autoFlush) {
            this.#flushTimeout?.refresh();
          } else {
            this.#flushTimeout = null;
          }
        }, 1e3);
      }
      /**
       * Cleanup method to stop timers
       * @returns {void}
       */
      destroy() {
        this.#stopAutoFlush();
        if (this.#flushTimeout) {
          clearTimeout2(this.#flushTimeout);
          this.#flushTimeout = null;
        }
      }
      /**
       * Async close method that saves all recordings and performs cleanup
       * @returns {Promise<void>}
       */
      async close() {
        if (this.#snapshotPath && this.#snapshots.size !== 0) {
          await this.saveSnapshots();
        }
        this.destroy();
      }
    };
    module3.exports = { SnapshotRecorder, formatRequestKey, createRequestHash, filterHeadersForMatching, filterHeadersForStorage, createHeaderFilters };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/snapshot-agent.js
var require_snapshot_agent = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/mock/snapshot-agent.js"(exports2, module3) {
    init_import_meta_url();
    var Agent = require_agent();
    var MockAgent = require_mock_agent();
    var { SnapshotRecorder } = require_snapshot_recorder();
    var WrapHandler = require_wrap_handler();
    var { InvalidArgumentError, UndiciError } = require_errors();
    var { validateSnapshotMode } = require_snapshot_utils();
    var kSnapshotRecorder = Symbol("kSnapshotRecorder");
    var kSnapshotMode = Symbol("kSnapshotMode");
    var kSnapshotPath = Symbol("kSnapshotPath");
    var kSnapshotLoaded = Symbol("kSnapshotLoaded");
    var kRealAgent = Symbol("kRealAgent");
    var warningEmitted2 = false;
    var SnapshotAgent = class extends MockAgent {
      static {
        __name(this, "SnapshotAgent");
      }
      constructor(opts = {}) {
        if (!warningEmitted2) {
          process.emitWarning(
            "SnapshotAgent is experimental and subject to change",
            "ExperimentalWarning"
          );
          warningEmitted2 = true;
        }
        const {
          mode = "record",
          snapshotPath = null,
          ...mockAgentOpts
        } = opts;
        super(mockAgentOpts);
        validateSnapshotMode(mode);
        if ((mode === "playback" || mode === "update") && !snapshotPath) {
          throw new InvalidArgumentError(`snapshotPath is required when mode is '${mode}'`);
        }
        this[kSnapshotMode] = mode;
        this[kSnapshotPath] = snapshotPath;
        this[kSnapshotRecorder] = new SnapshotRecorder({
          snapshotPath: this[kSnapshotPath],
          mode: this[kSnapshotMode],
          maxSnapshots: opts.maxSnapshots,
          autoFlush: opts.autoFlush,
          flushInterval: opts.flushInterval,
          matchHeaders: opts.matchHeaders,
          ignoreHeaders: opts.ignoreHeaders,
          excludeHeaders: opts.excludeHeaders,
          matchBody: opts.matchBody,
          matchQuery: opts.matchQuery,
          caseSensitive: opts.caseSensitive,
          shouldRecord: opts.shouldRecord,
          shouldPlayback: opts.shouldPlayback,
          excludeUrls: opts.excludeUrls
        });
        this[kSnapshotLoaded] = false;
        if (this[kSnapshotMode] === "record" || this[kSnapshotMode] === "update") {
          this[kRealAgent] = new Agent(opts);
        }
        if ((this[kSnapshotMode] === "playback" || this[kSnapshotMode] === "update") && this[kSnapshotPath]) {
          this.loadSnapshots().catch(() => {
          });
        }
      }
      dispatch(opts, handler) {
        handler = WrapHandler.wrap(handler);
        const mode = this[kSnapshotMode];
        if (mode === "playback" || mode === "update") {
          if (!this[kSnapshotLoaded]) {
            return this.#asyncDispatch(opts, handler);
          }
          const snapshot = this[kSnapshotRecorder].findSnapshot(opts);
          if (snapshot) {
            return this.#replaySnapshot(snapshot, handler);
          } else if (mode === "update") {
            return this.#recordAndReplay(opts, handler);
          } else {
            const error2 = new UndiciError(`No snapshot found for ${opts.method || "GET"} ${opts.path}`);
            if (handler.onError) {
              handler.onError(error2);
              return;
            }
            throw error2;
          }
        } else if (mode === "record") {
          return this.#recordAndReplay(opts, handler);
        }
      }
      /**
       * Async version of dispatch for when we need to load snapshots first
       */
      async #asyncDispatch(opts, handler) {
        await this.loadSnapshots();
        return this.dispatch(opts, handler);
      }
      /**
       * Records a real request and replays the response
       */
      #recordAndReplay(opts, handler) {
        const responseData = {
          statusCode: null,
          headers: {},
          trailers: {},
          body: []
        };
        const self2 = this;
        const recordingHandler = {
          onRequestStart(controller, context2) {
            return handler.onRequestStart(controller, { ...context2, history: this.history });
          },
          onRequestUpgrade(controller, statusCode, headers, socket) {
            return handler.onRequestUpgrade(controller, statusCode, headers, socket);
          },
          onResponseStart(controller, statusCode, headers, statusMessage) {
            responseData.statusCode = statusCode;
            responseData.headers = headers;
            return handler.onResponseStart(controller, statusCode, headers, statusMessage);
          },
          onResponseData(controller, chunk) {
            responseData.body.push(chunk);
            return handler.onResponseData(controller, chunk);
          },
          onResponseEnd(controller, trailers) {
            responseData.trailers = trailers;
            const responseBody = Buffer.concat(responseData.body);
            self2[kSnapshotRecorder].record(opts, {
              statusCode: responseData.statusCode,
              headers: responseData.headers,
              body: responseBody,
              trailers: responseData.trailers
            }).then(() => {
              handler.onResponseEnd(controller, trailers);
            }).catch((error2) => {
              handler.onResponseError(controller, error2);
            });
          }
        };
        const agent = this[kRealAgent];
        return agent.dispatch(opts, recordingHandler);
      }
      /**
       * Replays a recorded response
       *
       * @param {Object} snapshot - The recorded snapshot to replay.
       * @param {Object} handler - The handler to call with the response data.
       * @returns {void}
       */
      #replaySnapshot(snapshot, handler) {
        try {
          const { response } = snapshot;
          const controller = {
            pause() {
            },
            resume() {
            },
            abort(reason) {
              this.aborted = true;
              this.reason = reason;
            },
            aborted: false,
            paused: false
          };
          handler.onRequestStart(controller);
          handler.onResponseStart(controller, response.statusCode, response.headers);
          const body = Buffer.from(response.body, "base64");
          handler.onResponseData(controller, body);
          handler.onResponseEnd(controller, response.trailers);
        } catch (error2) {
          handler.onError?.(error2);
        }
      }
      /**
       * Loads snapshots from file
       *
       * @param {string} [filePath] - Optional file path to load snapshots from.
       * @returns {Promise<void>} - Resolves when snapshots are loaded.
       */
      async loadSnapshots(filePath) {
        await this[kSnapshotRecorder].loadSnapshots(filePath || this[kSnapshotPath]);
        this[kSnapshotLoaded] = true;
        if (this[kSnapshotMode] === "playback") {
          this.#setupMockInterceptors();
        }
      }
      /**
       * Saves snapshots to file
       *
       * @param {string} [filePath] - Optional file path to save snapshots to.
       * @returns {Promise<void>} - Resolves when snapshots are saved.
       */
      async saveSnapshots(filePath) {
        return this[kSnapshotRecorder].saveSnapshots(filePath || this[kSnapshotPath]);
      }
      /**
       * Sets up MockAgent interceptors based on recorded snapshots.
       *
       * This method creates MockAgent interceptors for each recorded snapshot,
       * allowing the SnapshotAgent to fall back to MockAgent's standard intercept
       * mechanism in playback mode. Each interceptor is configured to persist
       * (remain active for multiple requests) and responds with the recorded
       * response data.
       *
       * Called automatically when loading snapshots in playback mode.
       *
       * @returns {void}
       */
      #setupMockInterceptors() {
        for (const snapshot of this[kSnapshotRecorder].getSnapshots()) {
          const { request: request4, responses, response } = snapshot;
          const url4 = new URL(request4.url);
          const mockPool = this.get(url4.origin);
          const responseData = responses ? responses[0] : response;
          if (!responseData) continue;
          mockPool.intercept({
            path: url4.pathname + url4.search,
            method: request4.method,
            headers: request4.headers,
            body: request4.body
          }).reply(responseData.statusCode, responseData.body, {
            headers: responseData.headers,
            trailers: responseData.trailers
          }).persist();
        }
      }
      /**
       * Gets the snapshot recorder
       * @return {SnapshotRecorder} - The snapshot recorder instance
       */
      getRecorder() {
        return this[kSnapshotRecorder];
      }
      /**
       * Gets the current mode
       * @return {import('./snapshot-utils').SnapshotMode} - The current snapshot mode
       */
      getMode() {
        return this[kSnapshotMode];
      }
      /**
       * Clears all snapshots
       * @returns {void}
       */
      clearSnapshots() {
        this[kSnapshotRecorder].clear();
      }
      /**
       * Resets call counts for all snapshots (useful for test cleanup)
       * @returns {void}
       */
      resetCallCounts() {
        this[kSnapshotRecorder].resetCallCounts();
      }
      /**
       * Deletes a specific snapshot by request options
       * @param {import('./snapshot-recorder').SnapshotRequestOptions} requestOpts - Request options to identify the snapshot
       * @return {Promise<boolean>} - Returns true if the snapshot was deleted, false if not found
       */
      deleteSnapshot(requestOpts) {
        return this[kSnapshotRecorder].deleteSnapshot(requestOpts);
      }
      /**
       * Gets information about a specific snapshot
       * @returns {import('./snapshot-recorder').SnapshotInfo|null} - Snapshot information or null if not found
       */
      getSnapshotInfo(requestOpts) {
        return this[kSnapshotRecorder].getSnapshotInfo(requestOpts);
      }
      /**
       * Replaces all snapshots with new data (full replacement)
       * @param {Array<{hash: string; snapshot: import('./snapshot-recorder').SnapshotEntryshotEntry}>|Record<string, import('./snapshot-recorder').SnapshotEntry>} snapshotData - New snapshot data to replace existing snapshots
       * @returns {void}
       */
      replaceSnapshots(snapshotData) {
        this[kSnapshotRecorder].replaceSnapshots(snapshotData);
      }
      /**
       * Closes the agent, saving snapshots and cleaning up resources.
       *
       * @returns {Promise<void>}
       */
      async close() {
        await this[kSnapshotRecorder].close();
        await this[kRealAgent]?.close();
        await super.close();
      }
    };
    module3.exports = SnapshotAgent;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/global.js
var require_global2 = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/global.js"(exports2, module3) {
    init_import_meta_url();
    var globalDispatcher = Symbol.for("undici.globalDispatcher.1");
    var { InvalidArgumentError } = require_errors();
    var Agent = require_agent();
    if (getGlobalDispatcher2() === void 0) {
      setGlobalDispatcher2(new Agent());
    }
    function setGlobalDispatcher2(agent) {
      if (!agent || typeof agent.dispatch !== "function") {
        throw new InvalidArgumentError("Argument agent must implement Agent");
      }
      Object.defineProperty(globalThis, globalDispatcher, {
        value: agent,
        writable: true,
        enumerable: false,
        configurable: false
      });
    }
    __name(setGlobalDispatcher2, "setGlobalDispatcher");
    function getGlobalDispatcher2() {
      return globalThis[globalDispatcher];
    }
    __name(getGlobalDispatcher2, "getGlobalDispatcher");
    module3.exports = {
      setGlobalDispatcher: setGlobalDispatcher2,
      getGlobalDispatcher: getGlobalDispatcher2
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/decorator-handler.js
var require_decorator_handler = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/decorator-handler.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var WrapHandler = require_wrap_handler();
    module3.exports = class DecoratorHandler {
      static {
        __name(this, "DecoratorHandler");
      }
      #handler;
      #onCompleteCalled = false;
      #onErrorCalled = false;
      #onResponseStartCalled = false;
      constructor(handler) {
        if (typeof handler !== "object" || handler === null) {
          throw new TypeError("handler must be an object");
        }
        this.#handler = WrapHandler.wrap(handler);
      }
      onRequestStart(...args) {
        this.#handler.onRequestStart?.(...args);
      }
      onRequestUpgrade(...args) {
        assert48(!this.#onCompleteCalled);
        assert48(!this.#onErrorCalled);
        return this.#handler.onRequestUpgrade?.(...args);
      }
      onResponseStart(...args) {
        assert48(!this.#onCompleteCalled);
        assert48(!this.#onErrorCalled);
        assert48(!this.#onResponseStartCalled);
        this.#onResponseStartCalled = true;
        return this.#handler.onResponseStart?.(...args);
      }
      onResponseData(...args) {
        assert48(!this.#onCompleteCalled);
        assert48(!this.#onErrorCalled);
        return this.#handler.onResponseData?.(...args);
      }
      onResponseEnd(...args) {
        assert48(!this.#onCompleteCalled);
        assert48(!this.#onErrorCalled);
        this.#onCompleteCalled = true;
        return this.#handler.onResponseEnd?.(...args);
      }
      onResponseError(...args) {
        this.#onErrorCalled = true;
        return this.#handler.onResponseError?.(...args);
      }
      /**
       * @deprecated
       */
      onBodySent() {
      }
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/redirect-handler.js
var require_redirect_handler = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/redirect-handler.js"(exports2, module3) {
    init_import_meta_url();
    var util3 = require_util();
    var { kBodyUsed } = require_symbols();
    var assert48 = __require("assert");
    var { InvalidArgumentError } = require_errors();
    var EE = __require("events");
    var redirectableStatusCodes = [300, 301, 302, 303, 307, 308];
    var kBody = Symbol("body");
    var noop = /* @__PURE__ */ __name(() => {
    }, "noop");
    var BodyAsyncIterable = class {
      static {
        __name(this, "BodyAsyncIterable");
      }
      constructor(body) {
        this[kBody] = body;
        this[kBodyUsed] = false;
      }
      async *[Symbol.asyncIterator]() {
        assert48(!this[kBodyUsed], "disturbed");
        this[kBodyUsed] = true;
        yield* this[kBody];
      }
    };
    var RedirectHandler = class _RedirectHandler {
      static {
        __name(this, "RedirectHandler");
      }
      static buildDispatch(dispatcher, maxRedirections) {
        if (maxRedirections != null && (!Number.isInteger(maxRedirections) || maxRedirections < 0)) {
          throw new InvalidArgumentError("maxRedirections must be a positive number");
        }
        const dispatch = dispatcher.dispatch.bind(dispatcher);
        return (opts, originalHandler) => dispatch(opts, new _RedirectHandler(dispatch, maxRedirections, opts, originalHandler));
      }
      constructor(dispatch, maxRedirections, opts, handler) {
        if (maxRedirections != null && (!Number.isInteger(maxRedirections) || maxRedirections < 0)) {
          throw new InvalidArgumentError("maxRedirections must be a positive number");
        }
        this.dispatch = dispatch;
        this.location = null;
        const { maxRedirections: _5, ...cleanOpts } = opts;
        this.opts = cleanOpts;
        this.maxRedirections = maxRedirections;
        this.handler = handler;
        this.history = [];
        if (util3.isStream(this.opts.body)) {
          if (util3.bodyLength(this.opts.body) === 0) {
            this.opts.body.on("data", function() {
              assert48(false);
            });
          }
          if (typeof this.opts.body.readableDidRead !== "boolean") {
            this.opts.body[kBodyUsed] = false;
            EE.prototype.on.call(this.opts.body, "data", function() {
              this[kBodyUsed] = true;
            });
          }
        } else if (this.opts.body && typeof this.opts.body.pipeTo === "function") {
          this.opts.body = new BodyAsyncIterable(this.opts.body);
        } else if (this.opts.body && typeof this.opts.body !== "string" && !ArrayBuffer.isView(this.opts.body) && util3.isIterable(this.opts.body) && !util3.isFormDataLike(this.opts.body)) {
          this.opts.body = new BodyAsyncIterable(this.opts.body);
        }
      }
      onRequestStart(controller, context2) {
        this.handler.onRequestStart?.(controller, { ...context2, history: this.history });
      }
      onRequestUpgrade(controller, statusCode, headers, socket) {
        this.handler.onRequestUpgrade?.(controller, statusCode, headers, socket);
      }
      onResponseStart(controller, statusCode, headers, statusMessage) {
        if (this.opts.throwOnMaxRedirect && this.history.length >= this.maxRedirections) {
          throw new Error("max redirects");
        }
        if ((statusCode === 301 || statusCode === 302) && this.opts.method === "POST") {
          this.opts.method = "GET";
          if (util3.isStream(this.opts.body)) {
            util3.destroy(this.opts.body.on("error", noop));
          }
          this.opts.body = null;
        }
        if (statusCode === 303 && this.opts.method !== "HEAD") {
          this.opts.method = "GET";
          if (util3.isStream(this.opts.body)) {
            util3.destroy(this.opts.body.on("error", noop));
          }
          this.opts.body = null;
        }
        this.location = this.history.length >= this.maxRedirections || util3.isDisturbed(this.opts.body) || redirectableStatusCodes.indexOf(statusCode) === -1 ? null : headers.location;
        if (this.opts.origin) {
          this.history.push(new URL(this.opts.path, this.opts.origin));
        }
        if (!this.location) {
          this.handler.onResponseStart?.(controller, statusCode, headers, statusMessage);
          return;
        }
        const { origin, pathname, search } = util3.parseURL(new URL(this.location, this.opts.origin && new URL(this.opts.path, this.opts.origin)));
        const path77 = search ? `${pathname}${search}` : pathname;
        const redirectUrlString = `${origin}${path77}`;
        for (const historyUrl of this.history) {
          if (historyUrl.toString() === redirectUrlString) {
            throw new InvalidArgumentError(`Redirect loop detected. Cannot redirect to ${origin}. This typically happens when using a Client or Pool with cross-origin redirects. Use an Agent for cross-origin redirects.`);
          }
        }
        this.opts.headers = cleanRequestHeaders(this.opts.headers, statusCode === 303, this.opts.origin !== origin);
        this.opts.path = path77;
        this.opts.origin = origin;
        this.opts.query = null;
      }
      onResponseData(controller, chunk) {
        if (this.location) ; else {
          this.handler.onResponseData?.(controller, chunk);
        }
      }
      onResponseEnd(controller, trailers) {
        if (this.location) {
          this.dispatch(this.opts, this);
        } else {
          this.handler.onResponseEnd(controller, trailers);
        }
      }
      onResponseError(controller, error2) {
        this.handler.onResponseError?.(controller, error2);
      }
    };
    function shouldRemoveHeader(header, removeContent, unknownOrigin) {
      if (header.length === 4) {
        return util3.headerNameToString(header) === "host";
      }
      if (removeContent && util3.headerNameToString(header).startsWith("content-")) {
        return true;
      }
      if (unknownOrigin && (header.length === 13 || header.length === 6 || header.length === 19)) {
        const name2 = util3.headerNameToString(header);
        return name2 === "authorization" || name2 === "cookie" || name2 === "proxy-authorization";
      }
      return false;
    }
    __name(shouldRemoveHeader, "shouldRemoveHeader");
    function cleanRequestHeaders(headers, removeContent, unknownOrigin) {
      const ret = [];
      if (Array.isArray(headers)) {
        for (let i6 = 0; i6 < headers.length; i6 += 2) {
          if (!shouldRemoveHeader(headers[i6], removeContent, unknownOrigin)) {
            ret.push(headers[i6], headers[i6 + 1]);
          }
        }
      } else if (headers && typeof headers === "object") {
        const entries2 = typeof headers[Symbol.iterator] === "function" ? headers : Object.entries(headers);
        for (const [key, value] of entries2) {
          if (!shouldRemoveHeader(key, removeContent, unknownOrigin)) {
            ret.push(key, value);
          }
        }
      } else {
        assert48(headers == null, "headers must be an object or an array");
      }
      return ret;
    }
    __name(cleanRequestHeaders, "cleanRequestHeaders");
    module3.exports = RedirectHandler;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/interceptor/redirect.js
var require_redirect = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/interceptor/redirect.js"(exports2, module3) {
    init_import_meta_url();
    var RedirectHandler = require_redirect_handler();
    function createRedirectInterceptor({ maxRedirections: defaultMaxRedirections } = {}) {
      return (dispatch) => {
        return /* @__PURE__ */ __name(function Intercept(opts, handler) {
          const { maxRedirections = defaultMaxRedirections, ...rest } = opts;
          if (maxRedirections == null || maxRedirections === 0) {
            return dispatch(opts, handler);
          }
          const dispatchOpts = { ...rest };
          const redirectHandler = new RedirectHandler(dispatch, maxRedirections, dispatchOpts, handler);
          return dispatch(dispatchOpts, redirectHandler);
        }, "Intercept");
      };
    }
    __name(createRedirectInterceptor, "createRedirectInterceptor");
    module3.exports = createRedirectInterceptor;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/interceptor/response-error.js
var require_response_error = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/interceptor/response-error.js"(exports2, module3) {
    init_import_meta_url();
    var DecoratorHandler = require_decorator_handler();
    var { ResponseError } = require_errors();
    var ResponseErrorHandler = class extends DecoratorHandler {
      static {
        __name(this, "ResponseErrorHandler");
      }
      #statusCode;
      #contentType;
      #decoder;
      #headers;
      #body;
      constructor(_opts, { handler }) {
        super(handler);
      }
      #checkContentType(contentType) {
        return (this.#contentType ?? "").indexOf(contentType) === 0;
      }
      onRequestStart(controller, context2) {
        this.#statusCode = 0;
        this.#contentType = null;
        this.#decoder = null;
        this.#headers = null;
        this.#body = "";
        return super.onRequestStart(controller, context2);
      }
      onResponseStart(controller, statusCode, headers, statusMessage) {
        this.#statusCode = statusCode;
        this.#headers = headers;
        this.#contentType = headers["content-type"];
        if (this.#statusCode < 400) {
          return super.onResponseStart(controller, statusCode, headers, statusMessage);
        }
        if (this.#checkContentType("application/json") || this.#checkContentType("text/plain")) {
          this.#decoder = new TextDecoder("utf-8");
        }
      }
      onResponseData(controller, chunk) {
        if (this.#statusCode < 400) {
          return super.onResponseData(controller, chunk);
        }
        this.#body += this.#decoder?.decode(chunk, { stream: true }) ?? "";
      }
      onResponseEnd(controller, trailers) {
        if (this.#statusCode >= 400) {
          this.#body += this.#decoder?.decode(void 0, { stream: false }) ?? "";
          if (this.#checkContentType("application/json")) {
            try {
              this.#body = JSON.parse(this.#body);
            } catch {
            }
          }
          let err;
          const stackTraceLimit = Error.stackTraceLimit;
          Error.stackTraceLimit = 0;
          try {
            err = new ResponseError("Response Error", this.#statusCode, {
              body: this.#body,
              headers: this.#headers
            });
          } finally {
            Error.stackTraceLimit = stackTraceLimit;
          }
          super.onResponseError(controller, err);
        } else {
          super.onResponseEnd(controller, trailers);
        }
      }
      onResponseError(controller, err) {
        super.onResponseError(controller, err);
      }
    };
    module3.exports = () => {
      return (dispatch) => {
        return /* @__PURE__ */ __name(function Intercept(opts, handler) {
          return dispatch(opts, new ResponseErrorHandler(opts, { handler }));
        }, "Intercept");
      };
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/interceptor/retry.js
var require_retry = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/interceptor/retry.js"(exports2, module3) {
    init_import_meta_url();
    var RetryHandler = require_retry_handler();
    module3.exports = (globalOpts) => {
      return (dispatch) => {
        return /* @__PURE__ */ __name(function retryInterceptor(opts, handler) {
          return dispatch(
            opts,
            new RetryHandler(
              { ...opts, retryOptions: { ...globalOpts, ...opts.retryOptions } },
              {
                handler,
                dispatch
              }
            )
          );
        }, "retryInterceptor");
      };
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/interceptor/dump.js
var require_dump = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/interceptor/dump.js"(exports2, module3) {
    init_import_meta_url();
    var { InvalidArgumentError, RequestAbortedError } = require_errors();
    var DecoratorHandler = require_decorator_handler();
    var DumpHandler = class extends DecoratorHandler {
      static {
        __name(this, "DumpHandler");
      }
      #maxSize = 1024 * 1024;
      #dumped = false;
      #size = 0;
      #controller = null;
      aborted = false;
      reason = false;
      constructor({ maxSize, signal }, handler) {
        if (maxSize != null && (!Number.isFinite(maxSize) || maxSize < 1)) {
          throw new InvalidArgumentError("maxSize must be a number greater than 0");
        }
        super(handler);
        this.#maxSize = maxSize ?? this.#maxSize;
      }
      #abort(reason) {
        this.aborted = true;
        this.reason = reason;
      }
      onRequestStart(controller, context2) {
        controller.abort = this.#abort.bind(this);
        this.#controller = controller;
        return super.onRequestStart(controller, context2);
      }
      onResponseStart(controller, statusCode, headers, statusMessage) {
        const contentLength = headers["content-length"];
        if (contentLength != null && contentLength > this.#maxSize) {
          throw new RequestAbortedError(
            `Response size (${contentLength}) larger than maxSize (${this.#maxSize})`
          );
        }
        if (this.aborted === true) {
          return true;
        }
        return super.onResponseStart(controller, statusCode, headers, statusMessage);
      }
      onResponseError(controller, err) {
        if (this.#dumped) {
          return;
        }
        err = this.#controller?.reason ?? err;
        super.onResponseError(controller, err);
      }
      onResponseData(controller, chunk) {
        this.#size = this.#size + chunk.length;
        if (this.#size >= this.#maxSize) {
          this.#dumped = true;
          if (this.aborted === true) {
            super.onResponseError(controller, this.reason);
          } else {
            super.onResponseEnd(controller, {});
          }
        }
        return true;
      }
      onResponseEnd(controller, trailers) {
        if (this.#dumped) {
          return;
        }
        if (this.#controller.aborted === true) {
          super.onResponseError(controller, this.reason);
          return;
        }
        super.onResponseEnd(controller, trailers);
      }
    };
    function createDumpInterceptor({ maxSize: defaultMaxSize } = {
      maxSize: 1024 * 1024
    }) {
      return (dispatch) => {
        return /* @__PURE__ */ __name(function Intercept(opts, handler) {
          const { dumpMaxSize = defaultMaxSize } = opts;
          const dumpHandler = new DumpHandler({ maxSize: dumpMaxSize, signal: opts.signal }, handler);
          return dispatch(opts, dumpHandler);
        }, "Intercept");
      };
    }
    __name(createDumpInterceptor, "createDumpInterceptor");
    module3.exports = createDumpInterceptor;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/interceptor/dns.js
var require_dns = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/interceptor/dns.js"(exports2, module3) {
    init_import_meta_url();
    var { isIP } = __require("net");
    var { lookup } = __require("dns");
    var DecoratorHandler = require_decorator_handler();
    var { InvalidArgumentError, InformationalError } = require_errors();
    var maxInt = Math.pow(2, 31) - 1;
    var DNSInstance = class {
      static {
        __name(this, "DNSInstance");
      }
      #maxTTL = 0;
      #maxItems = 0;
      #records = /* @__PURE__ */ new Map();
      dualStack = true;
      affinity = null;
      lookup = null;
      pick = null;
      constructor(opts) {
        this.#maxTTL = opts.maxTTL;
        this.#maxItems = opts.maxItems;
        this.dualStack = opts.dualStack;
        this.affinity = opts.affinity;
        this.lookup = opts.lookup ?? this.#defaultLookup;
        this.pick = opts.pick ?? this.#defaultPick;
      }
      get full() {
        return this.#records.size === this.#maxItems;
      }
      runLookup(origin, opts, cb2) {
        const ips = this.#records.get(origin.hostname);
        if (ips == null && this.full) {
          cb2(null, origin);
          return;
        }
        const newOpts = {
          affinity: this.affinity,
          dualStack: this.dualStack,
          lookup: this.lookup,
          pick: this.pick,
          ...opts.dns,
          maxTTL: this.#maxTTL,
          maxItems: this.#maxItems
        };
        if (ips == null) {
          this.lookup(origin, newOpts, (err, addresses) => {
            if (err || addresses == null || addresses.length === 0) {
              cb2(err ?? new InformationalError("No DNS entries found"));
              return;
            }
            this.setRecords(origin, addresses);
            const records = this.#records.get(origin.hostname);
            const ip = this.pick(
              origin,
              records,
              newOpts.affinity
            );
            let port;
            if (typeof ip.port === "number") {
              port = `:${ip.port}`;
            } else if (origin.port !== "") {
              port = `:${origin.port}`;
            } else {
              port = "";
            }
            cb2(
              null,
              new URL(`${origin.protocol}//${ip.family === 6 ? `[${ip.address}]` : ip.address}${port}`)
            );
          });
        } else {
          const ip = this.pick(
            origin,
            ips,
            newOpts.affinity
          );
          if (ip == null) {
            this.#records.delete(origin.hostname);
            this.runLookup(origin, opts, cb2);
            return;
          }
          let port;
          if (typeof ip.port === "number") {
            port = `:${ip.port}`;
          } else if (origin.port !== "") {
            port = `:${origin.port}`;
          } else {
            port = "";
          }
          cb2(
            null,
            new URL(`${origin.protocol}//${ip.family === 6 ? `[${ip.address}]` : ip.address}${port}`)
          );
        }
      }
      #defaultLookup(origin, opts, cb2) {
        lookup(
          origin.hostname,
          {
            all: true,
            family: this.dualStack === false ? this.affinity : 0,
            order: "ipv4first"
          },
          (err, addresses) => {
            if (err) {
              return cb2(err);
            }
            const results = /* @__PURE__ */ new Map();
            for (const addr of addresses) {
              results.set(`${addr.address}:${addr.family}`, addr);
            }
            cb2(null, results.values());
          }
        );
      }
      #defaultPick(origin, hostnameRecords, affinity) {
        let ip = null;
        const { records, offset } = hostnameRecords;
        let family;
        if (this.dualStack) {
          if (affinity == null) {
            if (offset == null || offset === maxInt) {
              hostnameRecords.offset = 0;
              affinity = 4;
            } else {
              hostnameRecords.offset++;
              affinity = (hostnameRecords.offset & 1) === 1 ? 6 : 4;
            }
          }
          if (records[affinity] != null && records[affinity].ips.length > 0) {
            family = records[affinity];
          } else {
            family = records[affinity === 4 ? 6 : 4];
          }
        } else {
          family = records[affinity];
        }
        if (family == null || family.ips.length === 0) {
          return ip;
        }
        if (family.offset == null || family.offset === maxInt) {
          family.offset = 0;
        } else {
          family.offset++;
        }
        const position = family.offset % family.ips.length;
        ip = family.ips[position] ?? null;
        if (ip == null) {
          return ip;
        }
        if (Date.now() - ip.timestamp > ip.ttl) {
          family.ips.splice(position, 1);
          return this.pick(origin, hostnameRecords, affinity);
        }
        return ip;
      }
      pickFamily(origin, ipFamily) {
        const records = this.#records.get(origin.hostname)?.records;
        if (!records) {
          return null;
        }
        const family = records[ipFamily];
        if (!family) {
          return null;
        }
        if (family.offset == null || family.offset === maxInt) {
          family.offset = 0;
        } else {
          family.offset++;
        }
        const position = family.offset % family.ips.length;
        const ip = family.ips[position] ?? null;
        if (ip == null) {
          return ip;
        }
        if (Date.now() - ip.timestamp > ip.ttl) {
          family.ips.splice(position, 1);
        }
        return ip;
      }
      setRecords(origin, addresses) {
        const timestamp = Date.now();
        const records = { records: { 4: null, 6: null } };
        for (const record of addresses) {
          record.timestamp = timestamp;
          if (typeof record.ttl === "number") {
            record.ttl = Math.min(record.ttl, this.#maxTTL);
          } else {
            record.ttl = this.#maxTTL;
          }
          const familyRecords = records.records[record.family] ?? { ips: [] };
          familyRecords.ips.push(record);
          records.records[record.family] = familyRecords;
        }
        this.#records.set(origin.hostname, records);
      }
      deleteRecords(origin) {
        this.#records.delete(origin.hostname);
      }
      getHandler(meta, opts) {
        return new DNSDispatchHandler(this, meta, opts);
      }
    };
    var DNSDispatchHandler = class extends DecoratorHandler {
      static {
        __name(this, "DNSDispatchHandler");
      }
      #state = null;
      #opts = null;
      #dispatch = null;
      #origin = null;
      #controller = null;
      #newOrigin = null;
      #firstTry = true;
      constructor(state2, { origin, handler, dispatch, newOrigin }, opts) {
        super(handler);
        this.#origin = origin;
        this.#newOrigin = newOrigin;
        this.#opts = { ...opts };
        this.#state = state2;
        this.#dispatch = dispatch;
      }
      onResponseError(controller, err) {
        switch (err.code) {
          case "ETIMEDOUT":
          case "ECONNREFUSED": {
            if (this.#state.dualStack) {
              if (!this.#firstTry) {
                super.onResponseError(controller, err);
                return;
              }
              this.#firstTry = false;
              const otherFamily = this.#newOrigin.hostname[0] === "[" ? 4 : 6;
              const ip = this.#state.pickFamily(this.#origin, otherFamily);
              if (ip == null) {
                super.onResponseError(controller, err);
                return;
              }
              let port;
              if (typeof ip.port === "number") {
                port = `:${ip.port}`;
              } else if (this.#origin.port !== "") {
                port = `:${this.#origin.port}`;
              } else {
                port = "";
              }
              const dispatchOpts = {
                ...this.#opts,
                origin: `${this.#origin.protocol}//${ip.family === 6 ? `[${ip.address}]` : ip.address}${port}`
              };
              this.#dispatch(dispatchOpts, this);
              return;
            }
            super.onResponseError(controller, err);
            break;
          }
          case "ENOTFOUND":
            this.#state.deleteRecords(this.#origin);
            super.onResponseError(controller, err);
            break;
          default:
            super.onResponseError(controller, err);
            break;
        }
      }
    };
    module3.exports = (interceptorOpts) => {
      if (interceptorOpts?.maxTTL != null && (typeof interceptorOpts?.maxTTL !== "number" || interceptorOpts?.maxTTL < 0)) {
        throw new InvalidArgumentError("Invalid maxTTL. Must be a positive number");
      }
      if (interceptorOpts?.maxItems != null && (typeof interceptorOpts?.maxItems !== "number" || interceptorOpts?.maxItems < 1)) {
        throw new InvalidArgumentError(
          "Invalid maxItems. Must be a positive number and greater than zero"
        );
      }
      if (interceptorOpts?.affinity != null && interceptorOpts?.affinity !== 4 && interceptorOpts?.affinity !== 6) {
        throw new InvalidArgumentError("Invalid affinity. Must be either 4 or 6");
      }
      if (interceptorOpts?.dualStack != null && typeof interceptorOpts?.dualStack !== "boolean") {
        throw new InvalidArgumentError("Invalid dualStack. Must be a boolean");
      }
      if (interceptorOpts?.lookup != null && typeof interceptorOpts?.lookup !== "function") {
        throw new InvalidArgumentError("Invalid lookup. Must be a function");
      }
      if (interceptorOpts?.pick != null && typeof interceptorOpts?.pick !== "function") {
        throw new InvalidArgumentError("Invalid pick. Must be a function");
      }
      const dualStack = interceptorOpts?.dualStack ?? true;
      let affinity;
      if (dualStack) {
        affinity = interceptorOpts?.affinity ?? null;
      } else {
        affinity = interceptorOpts?.affinity ?? 4;
      }
      const opts = {
        maxTTL: interceptorOpts?.maxTTL ?? 1e4,
        // Expressed in ms
        lookup: interceptorOpts?.lookup ?? null,
        pick: interceptorOpts?.pick ?? null,
        dualStack,
        affinity,
        maxItems: interceptorOpts?.maxItems ?? Infinity
      };
      const instance = new DNSInstance(opts);
      return (dispatch) => {
        return /* @__PURE__ */ __name(function dnsInterceptor(origDispatchOpts, handler) {
          const origin = origDispatchOpts.origin.constructor === URL ? origDispatchOpts.origin : new URL(origDispatchOpts.origin);
          if (isIP(origin.hostname) !== 0) {
            return dispatch(origDispatchOpts, handler);
          }
          instance.runLookup(origin, origDispatchOpts, (err, newOrigin) => {
            if (err) {
              return handler.onResponseError(null, err);
            }
            const dispatchOpts = {
              ...origDispatchOpts,
              servername: origin.hostname,
              // For SNI on TLS
              origin: newOrigin.origin,
              headers: {
                host: origin.host,
                ...origDispatchOpts.headers
              }
            };
            dispatch(
              dispatchOpts,
              instance.getHandler(
                { origin, dispatch, handler, newOrigin },
                origDispatchOpts
              )
            );
          });
          return true;
        }, "dnsInterceptor");
      };
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/util/cache.js
var require_cache = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/util/cache.js"(exports2, module3) {
    init_import_meta_url();
    var {
      safeHTTPMethods
    } = require_util();
    var { serializePathWithQuery } = require_util();
    function makeCacheKey(opts) {
      if (!opts.origin) {
        throw new Error("opts.origin is undefined");
      }
      let fullPath;
      try {
        fullPath = serializePathWithQuery(opts.path || "/", opts.query);
      } catch (error2) {
        fullPath = opts.path || "/";
      }
      return {
        origin: opts.origin.toString(),
        method: opts.method,
        path: fullPath,
        headers: opts.headers
      };
    }
    __name(makeCacheKey, "makeCacheKey");
    function normalizeHeaders(opts) {
      let headers;
      if (opts.headers == null) {
        headers = {};
      } else if (typeof opts.headers[Symbol.iterator] === "function") {
        headers = {};
        for (const x7 of opts.headers) {
          if (!Array.isArray(x7)) {
            throw new Error("opts.headers is not a valid header map");
          }
          const [key, val2] = x7;
          if (typeof key !== "string" || typeof val2 !== "string") {
            throw new Error("opts.headers is not a valid header map");
          }
          headers[key.toLowerCase()] = val2;
        }
      } else if (typeof opts.headers === "object") {
        headers = {};
        for (const key of Object.keys(opts.headers)) {
          headers[key.toLowerCase()] = opts.headers[key];
        }
      } else {
        throw new Error("opts.headers is not an object");
      }
      return headers;
    }
    __name(normalizeHeaders, "normalizeHeaders");
    function assertCacheKey(key) {
      if (typeof key !== "object") {
        throw new TypeError(`expected key to be object, got ${typeof key}`);
      }
      for (const property of ["origin", "method", "path"]) {
        if (typeof key[property] !== "string") {
          throw new TypeError(`expected key.${property} to be string, got ${typeof key[property]}`);
        }
      }
      if (key.headers !== void 0 && typeof key.headers !== "object") {
        throw new TypeError(`expected headers to be object, got ${typeof key}`);
      }
    }
    __name(assertCacheKey, "assertCacheKey");
    function assertCacheValue(value) {
      if (typeof value !== "object") {
        throw new TypeError(`expected value to be object, got ${typeof value}`);
      }
      for (const property of ["statusCode", "cachedAt", "staleAt", "deleteAt"]) {
        if (typeof value[property] !== "number") {
          throw new TypeError(`expected value.${property} to be number, got ${typeof value[property]}`);
        }
      }
      if (typeof value.statusMessage !== "string") {
        throw new TypeError(`expected value.statusMessage to be string, got ${typeof value.statusMessage}`);
      }
      if (value.headers != null && typeof value.headers !== "object") {
        throw new TypeError(`expected value.rawHeaders to be object, got ${typeof value.headers}`);
      }
      if (value.vary !== void 0 && typeof value.vary !== "object") {
        throw new TypeError(`expected value.vary to be object, got ${typeof value.vary}`);
      }
      if (value.etag !== void 0 && typeof value.etag !== "string") {
        throw new TypeError(`expected value.etag to be string, got ${typeof value.etag}`);
      }
    }
    __name(assertCacheValue, "assertCacheValue");
    function parseCacheControlHeader(header) {
      const output = {};
      let directives;
      if (Array.isArray(header)) {
        directives = [];
        for (const directive of header) {
          directives.push(...directive.split(","));
        }
      } else {
        directives = header.split(",");
      }
      for (let i6 = 0; i6 < directives.length; i6++) {
        const directive = directives[i6].toLowerCase();
        const keyValueDelimiter = directive.indexOf("=");
        let key;
        let value;
        if (keyValueDelimiter !== -1) {
          key = directive.substring(0, keyValueDelimiter).trimStart();
          value = directive.substring(keyValueDelimiter + 1);
        } else {
          key = directive.trim();
        }
        switch (key) {
          case "min-fresh":
          case "max-stale":
          case "max-age":
          case "s-maxage":
          case "stale-while-revalidate":
          case "stale-if-error": {
            if (value === void 0 || value[0] === " ") {
              continue;
            }
            if (value.length >= 2 && value[0] === '"' && value[value.length - 1] === '"') {
              value = value.substring(1, value.length - 1);
            }
            const parsedValue = parseInt(value, 10);
            if (parsedValue !== parsedValue) {
              continue;
            }
            if (key === "max-age" && key in output && output[key] >= parsedValue) {
              continue;
            }
            output[key] = parsedValue;
            break;
          }
          case "private":
          case "no-cache": {
            if (value) {
              if (value[0] === '"') {
                const headers = [value.substring(1)];
                let foundEndingQuote = value[value.length - 1] === '"';
                if (!foundEndingQuote) {
                  for (let j7 = i6 + 1; j7 < directives.length; j7++) {
                    const nextPart = directives[j7];
                    const nextPartLength = nextPart.length;
                    headers.push(nextPart.trim());
                    if (nextPartLength !== 0 && nextPart[nextPartLength - 1] === '"') {
                      foundEndingQuote = true;
                      break;
                    }
                  }
                }
                if (foundEndingQuote) {
                  let lastHeader = headers[headers.length - 1];
                  if (lastHeader[lastHeader.length - 1] === '"') {
                    lastHeader = lastHeader.substring(0, lastHeader.length - 1);
                    headers[headers.length - 1] = lastHeader;
                  }
                  if (key in output) {
                    output[key] = output[key].concat(headers);
                  } else {
                    output[key] = headers;
                  }
                }
              } else {
                if (key in output) {
                  output[key] = output[key].concat(value);
                } else {
                  output[key] = [value];
                }
              }
              break;
            }
          }
          // eslint-disable-next-line no-fallthrough
          case "public":
          case "no-store":
          case "must-revalidate":
          case "proxy-revalidate":
          case "immutable":
          case "no-transform":
          case "must-understand":
          case "only-if-cached":
            if (value) {
              continue;
            }
            output[key] = true;
            break;
          default:
            continue;
        }
      }
      return output;
    }
    __name(parseCacheControlHeader, "parseCacheControlHeader");
    function parseVaryHeader(varyHeader, headers) {
      if (typeof varyHeader === "string" && varyHeader.includes("*")) {
        return headers;
      }
      const output = (
        /** @type {Record<string, string | string[] | null>} */
        {}
      );
      const varyingHeaders = typeof varyHeader === "string" ? varyHeader.split(",") : varyHeader;
      for (const header of varyingHeaders) {
        const trimmedHeader = header.trim().toLowerCase();
        output[trimmedHeader] = headers[trimmedHeader] ?? null;
      }
      return output;
    }
    __name(parseVaryHeader, "parseVaryHeader");
    function isEtagUsable(etag) {
      if (etag.length <= 2) {
        return false;
      }
      if (etag[0] === '"' && etag[etag.length - 1] === '"') {
        return !(etag[1] === '"' || etag.startsWith('"W/'));
      }
      if (etag.startsWith('W/"') && etag[etag.length - 1] === '"') {
        return etag.length !== 4;
      }
      return false;
    }
    __name(isEtagUsable, "isEtagUsable");
    function assertCacheStore(store, name2 = "CacheStore") {
      if (typeof store !== "object" || store === null) {
        throw new TypeError(`expected type of ${name2} to be a CacheStore, got ${store === null ? "null" : typeof store}`);
      }
      for (const fn2 of ["get", "createWriteStream", "delete"]) {
        if (typeof store[fn2] !== "function") {
          throw new TypeError(`${name2} needs to have a \`${fn2}()\` function`);
        }
      }
    }
    __name(assertCacheStore, "assertCacheStore");
    function assertCacheMethods(methods, name2 = "CacheMethods") {
      if (!Array.isArray(methods)) {
        throw new TypeError(`expected type of ${name2} needs to be an array, got ${methods === null ? "null" : typeof methods}`);
      }
      if (methods.length === 0) {
        throw new TypeError(`${name2} needs to have at least one method`);
      }
      for (const method of methods) {
        if (!safeHTTPMethods.includes(method)) {
          throw new TypeError(`element of ${name2}-array needs to be one of following values: ${safeHTTPMethods.join(", ")}, got ${method}`);
        }
      }
    }
    __name(assertCacheMethods, "assertCacheMethods");
    module3.exports = {
      makeCacheKey,
      normalizeHeaders,
      assertCacheKey,
      assertCacheValue,
      parseCacheControlHeader,
      parseVaryHeader,
      isEtagUsable,
      assertCacheMethods,
      assertCacheStore
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/util/date.js
var require_date = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/util/date.js"(exports2, module3) {
    init_import_meta_url();
    var IMF_DAYS = ["mon", "tue", "wed", "thu", "fri", "sat", "sun"];
    var IMF_SPACES = [4, 7, 11, 16, 25];
    var IMF_MONTHS = ["jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"];
    var IMF_COLONS = [19, 22];
    var ASCTIME_SPACES = [3, 7, 10, 19];
    var RFC850_DAYS = ["monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"];
    function parseHttpDate(date, now) {
      date = date.toLowerCase();
      switch (date[3]) {
        case ",":
          return parseImfDate(date);
        case " ":
          return parseAscTimeDate(date);
        default:
          return parseRfc850Date(date, now);
      }
    }
    __name(parseHttpDate, "parseHttpDate");
    function parseImfDate(date) {
      if (date.length !== 29) {
        return void 0;
      }
      if (!date.endsWith("gmt")) {
        return void 0;
      }
      for (const spaceInx of IMF_SPACES) {
        if (date[spaceInx] !== " ") {
          return void 0;
        }
      }
      for (const colonIdx of IMF_COLONS) {
        if (date[colonIdx] !== ":") {
          return void 0;
        }
      }
      const dayName = date.substring(0, 3);
      if (!IMF_DAYS.includes(dayName)) {
        return void 0;
      }
      const dayString = date.substring(5, 7);
      const day = Number.parseInt(dayString);
      if (isNaN(day) || day < 10 && dayString[0] !== "0") {
        return void 0;
      }
      const month = date.substring(8, 11);
      const monthIdx = IMF_MONTHS.indexOf(month);
      if (monthIdx === -1) {
        return void 0;
      }
      const year = Number.parseInt(date.substring(12, 16));
      if (isNaN(year)) {
        return void 0;
      }
      const hourString = date.substring(17, 19);
      const hour = Number.parseInt(hourString);
      if (isNaN(hour) || hour < 10 && hourString[0] !== "0") {
        return void 0;
      }
      const minuteString = date.substring(20, 22);
      const minute = Number.parseInt(minuteString);
      if (isNaN(minute) || minute < 10 && minuteString[0] !== "0") {
        return void 0;
      }
      const secondString = date.substring(23, 25);
      const second = Number.parseInt(secondString);
      if (isNaN(second) || second < 10 && secondString[0] !== "0") {
        return void 0;
      }
      return new Date(Date.UTC(year, monthIdx, day, hour, minute, second));
    }
    __name(parseImfDate, "parseImfDate");
    function parseAscTimeDate(date) {
      if (date.length !== 24) {
        return void 0;
      }
      for (const spaceIdx of ASCTIME_SPACES) {
        if (date[spaceIdx] !== " ") {
          return void 0;
        }
      }
      const dayName = date.substring(0, 3);
      if (!IMF_DAYS.includes(dayName)) {
        return void 0;
      }
      const month = date.substring(4, 7);
      const monthIdx = IMF_MONTHS.indexOf(month);
      if (monthIdx === -1) {
        return void 0;
      }
      const dayString = date.substring(8, 10);
      const day = Number.parseInt(dayString);
      if (isNaN(day) || day < 10 && dayString[0] !== " ") {
        return void 0;
      }
      const hourString = date.substring(11, 13);
      const hour = Number.parseInt(hourString);
      if (isNaN(hour) || hour < 10 && hourString[0] !== "0") {
        return void 0;
      }
      const minuteString = date.substring(14, 16);
      const minute = Number.parseInt(minuteString);
      if (isNaN(minute) || minute < 10 && minuteString[0] !== "0") {
        return void 0;
      }
      const secondString = date.substring(17, 19);
      const second = Number.parseInt(secondString);
      if (isNaN(second) || second < 10 && secondString[0] !== "0") {
        return void 0;
      }
      const year = Number.parseInt(date.substring(20, 24));
      if (isNaN(year)) {
        return void 0;
      }
      return new Date(Date.UTC(year, monthIdx, day, hour, minute, second));
    }
    __name(parseAscTimeDate, "parseAscTimeDate");
    function parseRfc850Date(date, now = /* @__PURE__ */ new Date()) {
      if (!date.endsWith("gmt")) {
        return void 0;
      }
      const commaIndex = date.indexOf(",");
      if (commaIndex === -1) {
        return void 0;
      }
      if (date.length - commaIndex - 1 !== 23) {
        return void 0;
      }
      const dayName = date.substring(0, commaIndex);
      if (!RFC850_DAYS.includes(dayName)) {
        return void 0;
      }
      if (date[commaIndex + 1] !== " " || date[commaIndex + 4] !== "-" || date[commaIndex + 8] !== "-" || date[commaIndex + 11] !== " " || date[commaIndex + 14] !== ":" || date[commaIndex + 17] !== ":" || date[commaIndex + 20] !== " ") {
        return void 0;
      }
      const dayString = date.substring(commaIndex + 2, commaIndex + 4);
      const day = Number.parseInt(dayString);
      if (isNaN(day) || day < 10 && dayString[0] !== "0") {
        return void 0;
      }
      const month = date.substring(commaIndex + 5, commaIndex + 8);
      const monthIdx = IMF_MONTHS.indexOf(month);
      if (monthIdx === -1) {
        return void 0;
      }
      let year = Number.parseInt(date.substring(commaIndex + 9, commaIndex + 11));
      if (isNaN(year)) {
        return void 0;
      }
      const currentYear = now.getUTCFullYear();
      const currentDecade = currentYear % 100;
      const currentCentury = Math.floor(currentYear / 100);
      if (year > currentDecade && year - currentDecade >= 50) {
        year += (currentCentury - 1) * 100;
      } else {
        year += currentCentury * 100;
      }
      const hourString = date.substring(commaIndex + 12, commaIndex + 14);
      const hour = Number.parseInt(hourString);
      if (isNaN(hour) || hour < 10 && hourString[0] !== "0") {
        return void 0;
      }
      const minuteString = date.substring(commaIndex + 15, commaIndex + 17);
      const minute = Number.parseInt(minuteString);
      if (isNaN(minute) || minute < 10 && minuteString[0] !== "0") {
        return void 0;
      }
      const secondString = date.substring(commaIndex + 18, commaIndex + 20);
      const second = Number.parseInt(secondString);
      if (isNaN(second) || second < 10 && secondString[0] !== "0") {
        return void 0;
      }
      return new Date(Date.UTC(year, monthIdx, day, hour, minute, second));
    }
    __name(parseRfc850Date, "parseRfc850Date");
    module3.exports = {
      parseHttpDate
    };
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/cache-handler.js
var require_cache_handler = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/cache-handler.js"(exports2, module3) {
    init_import_meta_url();
    var util3 = require_util();
    var {
      parseCacheControlHeader,
      parseVaryHeader,
      isEtagUsable
    } = require_cache();
    var { parseHttpDate } = require_date();
    function noop() {
    }
    __name(noop, "noop");
    var HEURISTICALLY_CACHEABLE_STATUS_CODES = [
      200,
      203,
      204,
      206,
      300,
      301,
      308,
      404,
      405,
      410,
      414,
      501
    ];
    var NOT_UNDERSTOOD_STATUS_CODES = [
      206,
      304
    ];
    var MAX_RESPONSE_AGE = 2147483647e3;
    var CacheHandler = class {
      static {
        __name(this, "CacheHandler");
      }
      /**
       * @type {import('../../types/cache-interceptor.d.ts').default.CacheKey}
       */
      #cacheKey;
      /**
       * @type {import('../../types/cache-interceptor.d.ts').default.CacheHandlerOptions['type']}
       */
      #cacheType;
      /**
       * @type {number | undefined}
       */
      #cacheByDefault;
      /**
       * @type {import('../../types/cache-interceptor.d.ts').default.CacheStore}
       */
      #store;
      /**
       * @type {import('../../types/dispatcher.d.ts').default.DispatchHandler}
       */
      #handler;
      /**
       * @type {import('node:stream').Writable | undefined}
       */
      #writeStream;
      /**
       * @param {import('../../types/cache-interceptor.d.ts').default.CacheHandlerOptions} opts
       * @param {import('../../types/cache-interceptor.d.ts').default.CacheKey} cacheKey
       * @param {import('../../types/dispatcher.d.ts').default.DispatchHandler} handler
       */
      constructor({ store, type, cacheByDefault }, cacheKey, handler) {
        this.#store = store;
        this.#cacheType = type;
        this.#cacheByDefault = cacheByDefault;
        this.#cacheKey = cacheKey;
        this.#handler = handler;
      }
      onRequestStart(controller, context2) {
        this.#writeStream?.destroy();
        this.#writeStream = void 0;
        this.#handler.onRequestStart?.(controller, context2);
      }
      onRequestUpgrade(controller, statusCode, headers, socket) {
        this.#handler.onRequestUpgrade?.(controller, statusCode, headers, socket);
      }
      /**
       * @param {import('../../types/dispatcher.d.ts').default.DispatchController} controller
       * @param {number} statusCode
       * @param {import('../../types/header.d.ts').IncomingHttpHeaders} resHeaders
       * @param {string} statusMessage
       */
      onResponseStart(controller, statusCode, resHeaders, statusMessage) {
        const downstreamOnHeaders = /* @__PURE__ */ __name(() => this.#handler.onResponseStart?.(
          controller,
          statusCode,
          resHeaders,
          statusMessage
        ), "downstreamOnHeaders");
        if (!util3.safeHTTPMethods.includes(this.#cacheKey.method) && statusCode >= 200 && statusCode <= 399) {
          try {
            this.#store.delete(this.#cacheKey)?.catch?.(noop);
          } catch {
          }
          return downstreamOnHeaders();
        }
        const cacheControlHeader = resHeaders["cache-control"];
        const heuristicallyCacheable = resHeaders["last-modified"] && HEURISTICALLY_CACHEABLE_STATUS_CODES.includes(statusCode);
        if (!cacheControlHeader && !resHeaders["expires"] && !heuristicallyCacheable && !this.#cacheByDefault) {
          return downstreamOnHeaders();
        }
        const cacheControlDirectives = cacheControlHeader ? parseCacheControlHeader(cacheControlHeader) : {};
        if (!canCacheResponse(this.#cacheType, statusCode, resHeaders, cacheControlDirectives)) {
          return downstreamOnHeaders();
        }
        const now = Date.now();
        const resAge = resHeaders.age ? getAge(resHeaders.age) : void 0;
        if (resAge && resAge >= MAX_RESPONSE_AGE) {
          return downstreamOnHeaders();
        }
        const resDate = typeof resHeaders.date === "string" ? parseHttpDate(resHeaders.date) : void 0;
        const staleAt = determineStaleAt(this.#cacheType, now, resAge, resHeaders, resDate, cacheControlDirectives) ?? this.#cacheByDefault;
        if (staleAt === void 0 || resAge && resAge > staleAt) {
          return downstreamOnHeaders();
        }
        const baseTime = resDate ? resDate.getTime() : now;
        const absoluteStaleAt = staleAt + baseTime;
        if (now >= absoluteStaleAt) {
          return downstreamOnHeaders();
        }
        let varyDirectives;
        if (this.#cacheKey.headers && resHeaders.vary) {
          varyDirectives = parseVaryHeader(resHeaders.vary, this.#cacheKey.headers);
          if (!varyDirectives) {
            return downstreamOnHeaders();
          }
        }
        const deleteAt = determineDeleteAt(baseTime, cacheControlDirectives, absoluteStaleAt);
        const strippedHeaders = stripNecessaryHeaders(resHeaders, cacheControlDirectives);
        const value = {
          statusCode,
          statusMessage,
          headers: strippedHeaders,
          vary: varyDirectives,
          cacheControlDirectives,
          cachedAt: resAge ? now - resAge : now,
          staleAt: absoluteStaleAt,
          deleteAt
        };
        if (typeof resHeaders.etag === "string" && isEtagUsable(resHeaders.etag)) {
          value.etag = resHeaders.etag;
        }
        this.#writeStream = this.#store.createWriteStream(this.#cacheKey, value);
        if (!this.#writeStream) {
          return downstreamOnHeaders();
        }
        const handler = this;
        this.#writeStream.on("drain", () => controller.resume()).on("error", function() {
          handler.#writeStream = void 0;
          handler.#store.delete(handler.#cacheKey);
        }).on("close", function() {
          if (handler.#writeStream === this) {
            handler.#writeStream = void 0;
          }
          controller.resume();
        });
        return downstreamOnHeaders();
      }
      onResponseData(controller, chunk) {
        if (this.#writeStream?.write(chunk) === false) {
          controller.pause();
        }
        this.#handler.onResponseData?.(controller, chunk);
      }
      onResponseEnd(controller, trailers) {
        this.#writeStream?.end();
        this.#handler.onResponseEnd?.(controller, trailers);
      }
      onResponseError(controller, err) {
        this.#writeStream?.destroy(err);
        this.#writeStream = void 0;
        this.#handler.onResponseError?.(controller, err);
      }
    };
    function canCacheResponse(cacheType, statusCode, resHeaders, cacheControlDirectives) {
      if (statusCode < 200 || NOT_UNDERSTOOD_STATUS_CODES.includes(statusCode)) {
        return false;
      }
      if (!HEURISTICALLY_CACHEABLE_STATUS_CODES.includes(statusCode) && !resHeaders["expires"] && !cacheControlDirectives.public && cacheControlDirectives["max-age"] === void 0 && // RFC 9111: a private response directive, if the cache is not shared
      !(cacheControlDirectives.private && cacheType === "private") && !(cacheControlDirectives["s-maxage"] !== void 0 && cacheType === "shared")) {
        return false;
      }
      if (cacheControlDirectives["no-store"]) {
        return false;
      }
      if (cacheType === "shared" && cacheControlDirectives.private === true) {
        return false;
      }
      if (resHeaders.vary?.includes("*")) {
        return false;
      }
      if (resHeaders.authorization) {
        if (!cacheControlDirectives.public || typeof resHeaders.authorization !== "string") {
          return false;
        }
        if (Array.isArray(cacheControlDirectives["no-cache"]) && cacheControlDirectives["no-cache"].includes("authorization")) {
          return false;
        }
        if (Array.isArray(cacheControlDirectives["private"]) && cacheControlDirectives["private"].includes("authorization")) {
          return false;
        }
      }
      return true;
    }
    __name(canCacheResponse, "canCacheResponse");
    function getAge(ageHeader) {
      const age = parseInt(Array.isArray(ageHeader) ? ageHeader[0] : ageHeader);
      return isNaN(age) ? void 0 : age * 1e3;
    }
    __name(getAge, "getAge");
    function determineStaleAt(cacheType, now, age, resHeaders, responseDate, cacheControlDirectives) {
      if (cacheType === "shared") {
        const sMaxAge = cacheControlDirectives["s-maxage"];
        if (sMaxAge !== void 0) {
          return sMaxAge > 0 ? sMaxAge * 1e3 : void 0;
        }
      }
      const maxAge = cacheControlDirectives["max-age"];
      if (maxAge !== void 0) {
        return maxAge > 0 ? maxAge * 1e3 : void 0;
      }
      if (typeof resHeaders.expires === "string") {
        const expiresDate = parseHttpDate(resHeaders.expires);
        if (expiresDate) {
          if (now >= expiresDate.getTime()) {
            return void 0;
          }
          if (responseDate) {
            if (responseDate >= expiresDate) {
              return void 0;
            }
            if (age !== void 0 && age > expiresDate - responseDate) {
              return void 0;
            }
          }
          return expiresDate.getTime() - now;
        }
      }
      if (typeof resHeaders["last-modified"] === "string") {
        const lastModified = new Date(resHeaders["last-modified"]);
        if (isValidDate2(lastModified)) {
          if (lastModified.getTime() >= now) {
            return void 0;
          }
          const responseAge = now - lastModified.getTime();
          return responseAge * 0.1;
        }
      }
      if (cacheControlDirectives.immutable) {
        return 31536e3;
      }
      return void 0;
    }
    __name(determineStaleAt, "determineStaleAt");
    function determineDeleteAt(now, cacheControlDirectives, staleAt) {
      let staleWhileRevalidate = -Infinity;
      let staleIfError = -Infinity;
      let immutable = -Infinity;
      if (cacheControlDirectives["stale-while-revalidate"]) {
        staleWhileRevalidate = staleAt + cacheControlDirectives["stale-while-revalidate"] * 1e3;
      }
      if (cacheControlDirectives["stale-if-error"]) {
        staleIfError = staleAt + cacheControlDirectives["stale-if-error"] * 1e3;
      }
      if (staleWhileRevalidate === -Infinity && staleIfError === -Infinity) {
        immutable = now + 31536e6;
      }
      return Math.max(staleAt, staleWhileRevalidate, staleIfError, immutable);
    }
    __name(determineDeleteAt, "determineDeleteAt");
    function stripNecessaryHeaders(resHeaders, cacheControlDirectives) {
      const headersToRemove = [
        "connection",
        "proxy-authenticate",
        "proxy-authentication-info",
        "proxy-authorization",
        "proxy-connection",
        "te",
        "transfer-encoding",
        "upgrade",
        // We'll add age back when serving it
        "age"
      ];
      if (resHeaders["connection"]) {
        if (Array.isArray(resHeaders["connection"])) {
          headersToRemove.push(...resHeaders["connection"].map((header) => header.trim()));
        } else {
          headersToRemove.push(...resHeaders["connection"].split(",").map((header) => header.trim()));
        }
      }
      if (Array.isArray(cacheControlDirectives["no-cache"])) {
        headersToRemove.push(...cacheControlDirectives["no-cache"]);
      }
      if (Array.isArray(cacheControlDirectives["private"])) {
        headersToRemove.push(...cacheControlDirectives["private"]);
      }
      let strippedHeaders;
      for (const headerName of headersToRemove) {
        if (resHeaders[headerName]) {
          strippedHeaders ??= { ...resHeaders };
          delete strippedHeaders[headerName];
        }
      }
      return strippedHeaders ?? resHeaders;
    }
    __name(stripNecessaryHeaders, "stripNecessaryHeaders");
    function isValidDate2(date) {
      return date instanceof Date && Number.isFinite(date.valueOf());
    }
    __name(isValidDate2, "isValidDate");
    module3.exports = CacheHandler;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/cache/memory-cache-store.js
var require_memory_cache_store = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/cache/memory-cache-store.js"(exports2, module3) {
    init_import_meta_url();
    var { Writable: Writable5 } = __require("stream");
    var { EventEmitter: EventEmitter5 } = __require("events");
    var { assertCacheKey, assertCacheValue } = require_cache();
    var MemoryCacheStore = class extends EventEmitter5 {
      static {
        __name(this, "MemoryCacheStore");
      }
      #maxCount = 1024;
      #maxSize = 104857600;
      // 100MB
      #maxEntrySize = 5242880;
      // 5MB
      #size = 0;
      #count = 0;
      #entries = /* @__PURE__ */ new Map();
      #hasEmittedMaxSizeEvent = false;
      /**
       * @param {import('../../types/cache-interceptor.d.ts').default.MemoryCacheStoreOpts | undefined} [opts]
       */
      constructor(opts) {
        super();
        if (opts) {
          if (typeof opts !== "object") {
            throw new TypeError("MemoryCacheStore options must be an object");
          }
          if (opts.maxCount !== void 0) {
            if (typeof opts.maxCount !== "number" || !Number.isInteger(opts.maxCount) || opts.maxCount < 0) {
              throw new TypeError("MemoryCacheStore options.maxCount must be a non-negative integer");
            }
            this.#maxCount = opts.maxCount;
          }
          if (opts.maxSize !== void 0) {
            if (typeof opts.maxSize !== "number" || !Number.isInteger(opts.maxSize) || opts.maxSize < 0) {
              throw new TypeError("MemoryCacheStore options.maxSize must be a non-negative integer");
            }
            this.#maxSize = opts.maxSize;
          }
          if (opts.maxEntrySize !== void 0) {
            if (typeof opts.maxEntrySize !== "number" || !Number.isInteger(opts.maxEntrySize) || opts.maxEntrySize < 0) {
              throw new TypeError("MemoryCacheStore options.maxEntrySize must be a non-negative integer");
            }
            this.#maxEntrySize = opts.maxEntrySize;
          }
        }
      }
      /**
       * Get the current size of the cache in bytes
       * @returns {number} The current size of the cache in bytes
       */
      get size() {
        return this.#size;
      }
      /**
       * Check if the cache is full (either max size or max count reached)
       * @returns {boolean} True if the cache is full, false otherwise
       */
      isFull() {
        return this.#size >= this.#maxSize || this.#count >= this.#maxCount;
      }
      /**
       * @param {import('../../types/cache-interceptor.d.ts').default.CacheKey} req
       * @returns {import('../../types/cache-interceptor.d.ts').default.GetResult | undefined}
       */
      get(key) {
        assertCacheKey(key);
        const topLevelKey = `${key.origin}:${key.path}`;
        const now = Date.now();
        const entries2 = this.#entries.get(topLevelKey);
        const entry = entries2 ? findEntry(key, entries2, now) : null;
        return entry == null ? void 0 : {
          statusMessage: entry.statusMessage,
          statusCode: entry.statusCode,
          headers: entry.headers,
          body: entry.body,
          vary: entry.vary ? entry.vary : void 0,
          etag: entry.etag,
          cacheControlDirectives: entry.cacheControlDirectives,
          cachedAt: entry.cachedAt,
          staleAt: entry.staleAt,
          deleteAt: entry.deleteAt
        };
      }
      /**
       * @param {import('../../types/cache-interceptor.d.ts').default.CacheKey} key
       * @param {import('../../types/cache-interceptor.d.ts').default.CacheValue} val
       * @returns {Writable | undefined}
       */
      createWriteStream(key, val2) {
        assertCacheKey(key);
        assertCacheValue(val2);
        const topLevelKey = `${key.origin}:${key.path}`;
        const store = this;
        const entry = { ...key, ...val2, body: [], size: 0 };
        return new Writable5({
          write(chunk, encoding, callback) {
            if (typeof chunk === "string") {
              chunk = Buffer.from(chunk, encoding);
            }
            entry.size += chunk.byteLength;
            if (entry.size >= store.#maxEntrySize) {
              this.destroy();
            } else {
              entry.body.push(chunk);
            }
            callback(null);
          },
          final(callback) {
            let entries2 = store.#entries.get(topLevelKey);
            if (!entries2) {
              entries2 = [];
              store.#entries.set(topLevelKey, entries2);
            }
            const previousEntry = findEntry(key, entries2, Date.now());
            if (previousEntry) {
              const index = entries2.indexOf(previousEntry);
              entries2.splice(index, 1, entry);
              store.#size -= previousEntry.size;
            } else {
              entries2.push(entry);
              store.#count += 1;
            }
            store.#size += entry.size;
            if (store.#size > store.#maxSize || store.#count > store.#maxCount) {
              if (!store.#hasEmittedMaxSizeEvent) {
                store.emit("maxSizeExceeded", {
                  size: store.#size,
                  maxSize: store.#maxSize,
                  count: store.#count,
                  maxCount: store.#maxCount
                });
                store.#hasEmittedMaxSizeEvent = true;
              }
              for (const [key2, entries3] of store.#entries) {
                for (const entry2 of entries3.splice(0, entries3.length / 2)) {
                  store.#size -= entry2.size;
                  store.#count -= 1;
                }
                if (entries3.length === 0) {
                  store.#entries.delete(key2);
                }
              }
              if (store.#size < store.#maxSize && store.#count < store.#maxCount) {
                store.#hasEmittedMaxSizeEvent = false;
              }
            }
            callback(null);
          }
        });
      }
      /**
       * @param {CacheKey} key
       */
      delete(key) {
        if (typeof key !== "object") {
          throw new TypeError(`expected key to be object, got ${typeof key}`);
        }
        const topLevelKey = `${key.origin}:${key.path}`;
        for (const entry of this.#entries.get(topLevelKey) ?? []) {
          this.#size -= entry.size;
          this.#count -= 1;
        }
        this.#entries.delete(topLevelKey);
      }
    };
    function findEntry(key, entries2, now) {
      return entries2.find((entry) => entry.deleteAt > now && entry.method === key.method && (entry.vary == null || Object.keys(entry.vary).every((headerName) => {
        if (entry.vary[headerName] === null) {
          return key.headers[headerName] === void 0;
        }
        return entry.vary[headerName] === key.headers[headerName];
      })));
    }
    __name(findEntry, "findEntry");
    module3.exports = MemoryCacheStore;
  }
});

// ../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/cache-revalidation-handler.js
var require_cache_revalidation_handler = __commonJS({
  "../../node_modules/.pnpm/undici@7.14.0/node_modules/undici/lib/handler/cache-revalidation-handler.js"(exports2, module3) {
    init_import_meta_url();
    var assert48 = __require("assert");
    var CacheRevalidationHandler = class {
      static {
        __name(this, "CacheRevalidationHandler");
      }
      #successful = false;
      /**
       * @type {((boolean, any) => void) | null}
       */
      #callback;
      /**
       * @type {(import('../../types/dispatcher.d.ts').default.DispatchHandler)}
       */
      #handler;
      #context;
      /**
       * @type {boolean}
       */
      #allowErrorStatusCodes;
      /**
       * @param {(boolean) => void} callback Function to call if the cached value is valid
       * @param {import('../../types/dispatcher.d.ts').default.DispatchHandlers} handler
       * @param {boolean} allowErrorStatusCodes
       */
      constructor(callback, handler, allowErrorStatusCodes) {
        if (typeof callback !== "function") {
          throw new TypeError("callback must be a function");
        }
        this.#callback = callback;
        this.#handler = handler;
        this.#allowErrorStatusCodes = allowErrorStatusCodes;
      }
      onRequestStart(_5, context2) {
        this.#successful = false;
        this.#context = context2;
      }
      onRequestUpgrade(controller, statusCode, headers, socket) {
        this.#handler.onRequestUpgrade?.(controller, statusCode, headers, socket);
      }
      onResponseStart(controller, statusCode, headers, statusMessage) {
        assert48(this.#callback != null);
        this.#successful = statusCode === 304 || this.#allowErrorStatusCodes && statusCode >= 500 && statusCode <= 504;
        this.#callback(this.#successful, this.#context);
        this.#callback = null;
        if (this.#successful) {
          return true;
        }
        this.#handler.onRequestStart?.(controller, this.#context);
        this.#handler.onResponseStart?.(
          controller,
          statusCode,
          headers,
          statusMessage
        );
      }
      onResponseData(controller, chunk) {
        if (this.#successful) {
          return;
        }
        return this.#handler.onResponseData?.(controller, chunk);
      }
      onResponseEnd(controller, trailers) {
        if (this.#successful) {
          return;
        }
        this.#handler.onResponseEnd?.(controller, trailers);
      }
      onResponseError(controller, err) {
        if (this.#successful) {
          return;
        }
        if (this.#callback) {
          this.#callback(false);
          this.#callback = null;
        }
       