/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.Closeable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.Decryptor;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.fs.CommonConfigurationKeysPublic;
import org.apache.hadoop.thirdparty.com.google.common.base.Splitter;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.util.PerformanceAdvisory;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class CryptoCodec
implements Configurable,
Closeable {
    public static Logger LOG = LoggerFactory.getLogger(CryptoCodec.class);

    public static CryptoCodec getInstance(Configuration conf, CipherSuite cipherSuite) {
        List<Class<? extends CryptoCodec>> klasses = CryptoCodec.getCodecClasses(conf, cipherSuite);
        if (klasses == null) {
            return null;
        }
        CryptoCodec codec = null;
        for (Class<? extends CryptoCodec> klass : klasses) {
            try {
                CryptoCodec c = ReflectionUtils.newInstance(klass, conf);
                if (c.getCipherSuite().getName().equals(cipherSuite.getName())) {
                    if (codec != null) continue;
                    PerformanceAdvisory.LOG.debug("Using crypto codec {}.", (Object)klass.getName());
                    codec = c;
                    continue;
                }
                PerformanceAdvisory.LOG.debug("Crypto codec {} doesn't meet the cipher suite {}.", (Object)klass.getName(), (Object)cipherSuite.getName());
            }
            catch (Exception e) {
                PerformanceAdvisory.LOG.debug("Crypto codec {} is not available.", (Object)klass.getName());
            }
        }
        return codec;
    }

    public static CryptoCodec getInstance(Configuration conf) {
        String name = conf.get("hadoop.security.crypto.cipher.suite", "AES/CTR/NoPadding");
        return CryptoCodec.getInstance(conf, CipherSuite.convert(name));
    }

    private static List<Class<? extends CryptoCodec>> getCodecClasses(Configuration conf, CipherSuite cipherSuite) {
        ArrayList result = Lists.newArrayList();
        String configName = "hadoop.security.crypto.codec.classes" + cipherSuite.getConfigSuffix();
        String codecString = configName.equals(CommonConfigurationKeysPublic.HADOOP_SECURITY_CRYPTO_CODEC_CLASSES_AES_CTR_NOPADDING_KEY) ? conf.get(configName, CommonConfigurationKeysPublic.HADOOP_SECURITY_CRYPTO_CODEC_CLASSES_AES_CTR_NOPADDING_DEFAULT) : conf.get(configName);
        if (codecString == null) {
            PerformanceAdvisory.LOG.debug("No crypto codec classes with cipher suite configured.");
            return null;
        }
        for (String c : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)codecString)) {
            try {
                Class<?> cls = conf.getClassByName(c);
                result.add(cls.asSubclass(CryptoCodec.class));
            }
            catch (ClassCastException e) {
                PerformanceAdvisory.LOG.debug("Class {} is not a CryptoCodec.", (Object)c);
            }
            catch (ClassNotFoundException e) {
                PerformanceAdvisory.LOG.debug("Crypto codec {} not found.", (Object)c);
            }
        }
        return result;
    }

    public abstract CipherSuite getCipherSuite();

    public abstract Encryptor createEncryptor() throws GeneralSecurityException;

    public abstract Decryptor createDecryptor() throws GeneralSecurityException;

    public abstract void calculateIV(byte[] var1, long var2, byte[] var4);

    public abstract void generateSecureRandom(byte[] var1);
}

