/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.indexInsight;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

public class IndexInsightAccessControllerHelper {
    @Generated
    private static final Logger log = LogManager.getLogger(IndexInsightAccessControllerHelper.class);

    public static void verifyAccessController(Client client, ActionListener<Boolean> actionListener, String sourceIndex) {
        GetMappingsRequest getMappingsRequest = (GetMappingsRequest)new GetMappingsRequest().indices(new String[]{sourceIndex});
        client.admin().indices().getMappings(getMappingsRequest, ActionListener.wrap(getMappingsResponse -> {
            if (getMappingsResponse.getMappings().isEmpty()) {
                actionListener.onFailure((Exception)new IllegalArgumentException("No matching indices found for: " + sourceIndex));
                return;
            }
            SearchRequest searchRequest = IndexInsightAccessControllerHelper.constructSimpleQueryRequest(sourceIndex);
            client.search(searchRequest, ActionListener.wrap(r -> actionListener.onResponse((Object)true), e -> {
                log.error(e.getMessage(), (Throwable)e);
                actionListener.onFailure(e);
            }));
        }, e -> {
            log.error(e.getMessage(), (Throwable)e);
            actionListener.onFailure(e);
        }));
    }

    public static SearchRequest constructSimpleQueryRequest(String sourceIndex) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)new MatchAllQueryBuilder());
        searchSourceBuilder.size(1);
        SearchRequest searchRequest = new SearchRequest(new String[]{sourceIndex});
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }
}

