/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalScoreFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.similarities.Similarity;

class IntervalScorer
extends Scorer {
    private final IntervalIterator intervals;
    private final Similarity.SimScorer simScorer;
    private final float boost;
    private final int minExtent;
    private float freq;
    private int lastScoredDoc = -1;

    IntervalScorer(IntervalIterator intervals, int minExtent, float boost, IntervalScoreFunction scoreFunction) {
        this.intervals = intervals;
        this.minExtent = minExtent;
        this.boost = boost;
        this.simScorer = scoreFunction.scorer(boost);
    }

    public int docID() {
        return this.intervals.docID();
    }

    public float score() throws IOException {
        this.ensureFreq();
        return this.simScorer.score(this.freq, 1L);
    }

    float freq() throws IOException {
        this.ensureFreq();
        return this.freq;
    }

    private void ensureFreq() throws IOException {
        if (this.lastScoredDoc != this.docID()) {
            this.lastScoredDoc = this.docID();
            this.freq = 0.0f;
            do {
                int length = this.intervals.end() - this.intervals.start() + 1;
                this.freq = (float)((double)this.freq + 1.0 / (double)Math.max(length - this.minExtent + 1, 1));
            } while (this.intervals.nextInterval() != Integer.MAX_VALUE);
        }
    }

    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.twoPhaseIterator());
    }

    public TwoPhaseIterator twoPhaseIterator() {
        return new TwoPhaseIterator(this.intervals){

            public boolean matches() throws IOException {
                return IntervalScorer.this.intervals.nextInterval() != Integer.MAX_VALUE;
            }

            public float matchCost() {
                return IntervalScorer.this.intervals.matchCost();
            }
        };
    }

    public float getMaxScore(int upTo) {
        return this.boost;
    }
}

