/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.Point2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYGeometry;

public final class XYPoint
extends XYGeometry {
    private final float x;
    private final float y;

    public XYPoint(float x, float y) {
        this.x = XYEncodingUtils.checkVal(x);
        this.y = XYEncodingUtils.checkVal(y);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    @Override
    protected Component2D toComponent2D() {
        return Point2D.create(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XYPoint)) {
            return false;
        }
        XYPoint point = (XYPoint)o;
        return Float.compare(point.x, this.x) == 0 && Float.compare(point.y, this.y) == 0;
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = 31 * result + Float.hashCode(this.y);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYPoint(");
        sb.append(this.x);
        sb.append(",");
        sb.append(this.y);
        sb.append(')');
        return sb.toString();
    }
}

