/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.util.BytesRef;

public class BytesRefsCollectionBuilder
implements Consumer<BytesRef>,
Supplier<Collection<BytesRef>> {
    protected final List<BytesRef> terms;
    protected ConsumerStrategy delegate = this.createStartStrategy();

    public BytesRefsCollectionBuilder(int sizeExpected) {
        this.terms = new ArrayList<BytesRef>(sizeExpected);
    }

    @Override
    public void accept(BytesRef bytesRef) {
        this.delegate = (ConsumerStrategy)this.delegate.apply(bytesRef);
    }

    @Override
    public Collection<BytesRef> get() {
        Collection result = (Collection)this.delegate.get();
        this.delegate = this.createFrozenStrategy(result);
        return result;
    }

    protected ConsumerStrategy createStartStrategy() {
        return new ConsumerStrategy(){

            @Override
            public ConsumerStrategy apply(BytesRef firstBytes) {
                BytesRefsCollectionBuilder.this.terms.add(firstBytes);
                return BytesRefsCollectionBuilder.this.createSortedStrategy(firstBytes);
            }

            @Override
            public Collection<BytesRef> get() {
                return BytesRefsCollectionBuilder.this.terms;
            }
        };
    }

    protected ConsumerStrategy createSortedStrategy(final BytesRef firstBytes) {
        return new ConsumerStrategy(){
            BytesRef prev;
            {
                this.prev = firstBytes;
            }

            @Override
            public ConsumerStrategy apply(BytesRef bytesRef) {
                BytesRefsCollectionBuilder.this.terms.add(bytesRef);
                if (bytesRef.compareTo(this.prev) >= 0) {
                    this.prev = bytesRef;
                    return this;
                }
                return BytesRefsCollectionBuilder.this.createUnsortedStrategy();
            }

            @Override
            public Collection<BytesRef> get() {
                return new SortedBytesSet(BytesRefsCollectionBuilder.this.terms);
            }
        };
    }

    protected ConsumerStrategy createUnsortedStrategy() {
        return new ConsumerStrategy(){

            @Override
            public ConsumerStrategy apply(BytesRef bytesRef) {
                BytesRefsCollectionBuilder.this.terms.add(bytesRef);
                return this;
            }

            @Override
            public Collection<BytesRef> get() {
                return BytesRefsCollectionBuilder.this.terms;
            }
        };
    }

    protected ConsumerStrategy createFrozenStrategy(final Collection<BytesRef> result) {
        return new ConsumerStrategy(){

            @Override
            public ConsumerStrategy apply(BytesRef bytesRef) {
                throw new IllegalStateException("already build");
            }

            @Override
            public Collection<BytesRef> get() {
                return result;
            }
        };
    }

    protected static interface ConsumerStrategy
    extends Function<BytesRef, ConsumerStrategy>,
    Supplier<Collection<BytesRef>> {
    }

    protected static class SortedBytesSet
    extends AbstractSet<BytesRef>
    implements SortedSet<BytesRef> {
        private final List<BytesRef> bytesRefs;

        public SortedBytesSet(List<BytesRef> bytesRefs) {
            this.bytesRefs = bytesRefs;
        }

        @Override
        public Iterator<BytesRef> iterator() {
            return this.bytesRefs.iterator();
        }

        @Override
        public int size() {
            return this.bytesRefs.size();
        }

        @Override
        public Comparator<? super BytesRef> comparator() {
            return null;
        }

        @Override
        public SortedSet<BytesRef> subSet(BytesRef fromElement, BytesRef toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<BytesRef> headSet(BytesRef toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<BytesRef> tailSet(BytesRef fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef first() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef last() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.bytesRefs.toArray(a);
        }
    }
}

