
#ifndef MESSAGELIST_EXPORT_H
#define MESSAGELIST_EXPORT_H

#ifdef MESSAGELIST_STATIC_DEFINE
#  define MESSAGELIST_EXPORT
#  define MESSAGELIST_NO_EXPORT
#else
#  ifndef MESSAGELIST_EXPORT
#    ifdef KPim6MessageList_EXPORTS
        /* We are building this library */
#      define MESSAGELIST_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define MESSAGELIST_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef MESSAGELIST_NO_EXPORT
#    define MESSAGELIST_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef MESSAGELIST_DECL_DEPRECATED
#  define MESSAGELIST_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef MESSAGELIST_DECL_DEPRECATED_EXPORT
#  define MESSAGELIST_DECL_DEPRECATED_EXPORT MESSAGELIST_EXPORT MESSAGELIST_DECL_DEPRECATED
#endif

#ifndef MESSAGELIST_DECL_DEPRECATED_NO_EXPORT
#  define MESSAGELIST_DECL_DEPRECATED_NO_EXPORT MESSAGELIST_NO_EXPORT MESSAGELIST_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef MESSAGELIST_NO_DEPRECATED
#    define MESSAGELIST_NO_DEPRECATED
#  endif
#endif
#include <messagelist_version.h>

#define MESSAGELIST_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(MESSAGELIST_NO_DEPRECATED)
#  undef MESSAGELIST_DEPRECATED
#  define MESSAGELIST_DEPRECATED_EXPORT MESSAGELIST_EXPORT
#  define MESSAGELIST_DEPRECATED_NO_EXPORT MESSAGELIST_NO_EXPORT
#elif defined(MESSAGELIST_NO_DEPRECATED_WARNINGS)
#  define MESSAGELIST_DEPRECATED
#  define MESSAGELIST_DEPRECATED_EXPORT MESSAGELIST_EXPORT
#  define MESSAGELIST_DEPRECATED_NO_EXPORT MESSAGELIST_NO_EXPORT
#else
#  define MESSAGELIST_DEPRECATED MESSAGELIST_DECL_DEPRECATED
#  define MESSAGELIST_DEPRECATED_EXPORT MESSAGELIST_DECL_DEPRECATED_EXPORT
#  define MESSAGELIST_DEPRECATED_NO_EXPORT MESSAGELIST_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define MESSAGELIST_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define MESSAGELIST_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef MESSAGELIST_NO_DEPRECATED
#  define MESSAGELIST_DISABLE_DEPRECATED_BEFORE_AND_AT MESSAGELIST_VERSION
#endif
#ifdef MESSAGELIST_NO_DEPRECATED_WARNINGS
#  define MESSAGELIST_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef MESSAGELIST_DEPRECATED_WARNINGS_SINCE
#  ifdef MESSAGELIST_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define MESSAGELIST_DEPRECATED_WARNINGS_SINCE MESSAGELIST_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define MESSAGELIST_DEPRECATED_WARNINGS_SINCE MESSAGELIST_VERSION
#  endif
#endif

#ifndef MESSAGELIST_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define MESSAGELIST_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef MESSAGELIST_DEPRECATED
#  define MESSAGELIST_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > MESSAGELIST_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define MESSAGELIST_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* MESSAGELIST_EXPORT_H */
