/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Identify local minima whose depth below the baseline is greater than
h.


HConcaveImageFilter extract local minima that are more than h intensity units below the
(local) background. This has the effect of extracting objects that are
darker than the background by at least h intensity units.

This filter uses the HMinimaImageFilter .

Geodesic morphology and the H-Convex algorithm is described in Chapter
6 of Pierre Soille's book "Morphological Image Analysis: Principles
and Applications", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter , HMaximaImageFilter ,

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::HConcave for the procedural interface

 itk::HConcaveImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHConcaveImageFilter.h
*/
public class HConcaveImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected HConcaveImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.HConcaveImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(HConcaveImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(HConcaveImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::HConcaveImageFilter::~HConcaveImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_HConcaveImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::HConcaveImageFilter::HConcaveImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  HConcaveImageFilter() {
    this(SimpleITKJNI.new_HConcaveImageFilter(), true);
  }

  /**
Self&amp; itk::simple::HConcaveImageFilter::SetHeight(double Height)

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public  void setHeight(double Height) {
    SimpleITKJNI.HConcaveImageFilter_setHeight(swigCPtr, this, Height);
  }

  /**
double itk::simple::HConcaveImageFilter::GetHeight() const

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public  double getHeight() {
    return SimpleITKJNI.HConcaveImageFilter_getHeight(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::HConcaveImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.HConcaveImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::HConcaveImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.HConcaveImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::HConcaveImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.HConcaveImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::HConcaveImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.HConcaveImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::HConcaveImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.HConcaveImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::HConcaveImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.HConcaveImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::HConcaveImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.HConcaveImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
