﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/GlueRequest.h>
#include <aws/glue/Glue_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Glue {
namespace Model {

/**
 */
class StartExportLabelsTaskRunRequest : public GlueRequest {
 public:
  AWS_GLUE_API StartExportLabelsTaskRunRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "StartExportLabelsTaskRun"; }

  AWS_GLUE_API Aws::String SerializePayload() const override;

  AWS_GLUE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The unique identifier of the machine learning transform.</p>
   */
  inline const Aws::String& GetTransformId() const { return m_transformId; }
  inline bool TransformIdHasBeenSet() const { return m_transformIdHasBeenSet; }
  template <typename TransformIdT = Aws::String>
  void SetTransformId(TransformIdT&& value) {
    m_transformIdHasBeenSet = true;
    m_transformId = std::forward<TransformIdT>(value);
  }
  template <typename TransformIdT = Aws::String>
  StartExportLabelsTaskRunRequest& WithTransformId(TransformIdT&& value) {
    SetTransformId(std::forward<TransformIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon S3 path where you export the labels.</p>
   */
  inline const Aws::String& GetOutputS3Path() const { return m_outputS3Path; }
  inline bool OutputS3PathHasBeenSet() const { return m_outputS3PathHasBeenSet; }
  template <typename OutputS3PathT = Aws::String>
  void SetOutputS3Path(OutputS3PathT&& value) {
    m_outputS3PathHasBeenSet = true;
    m_outputS3Path = std::forward<OutputS3PathT>(value);
  }
  template <typename OutputS3PathT = Aws::String>
  StartExportLabelsTaskRunRequest& WithOutputS3Path(OutputS3PathT&& value) {
    SetOutputS3Path(std::forward<OutputS3PathT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_transformId;

  Aws::String m_outputS3Path;
  bool m_transformIdHasBeenSet = false;
  bool m_outputS3PathHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
