define(["exports"],function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.DOMException=void 0,_exports.Headers=Headers,_exports.Request=Request,_exports.Response=Response,_exports.fetch=fetch;var g=globalThis,support={searchParams:"URLSearchParams"in g,iterable:"Symbol"in g&&"iterator"in Symbol,blob:"FileReader"in g&&"Blob"in g&&function(){try{return new Blob,!0}catch(e){return!1}}(),formData:"FormData"in g,arrayBuffer:"ArrayBuffer"in g};var viewClasses=["[object Int8Array]","[object Uint8Array]","[object Uint8ClampedArray]","[object Int16Array]","[object Uint16Array]","[object Int32Array]","[object Uint32Array]","[object Float32Array]","[object Float64Array]"],isArrayBufferView=ArrayBuffer.isView||function(obj){return obj&&-1<viewClasses.indexOf(Object.prototype.toString.call(obj))};function normalizeName(name){if("string"!=typeof name&&(name=String(name)),/[^a-z0-9\-#$%&'*+.^_`|~!]/i.test(name)||""===name)throw new TypeError('Invalid character in header field name: "'+name+'"');return name.toLowerCase()}function normalizeValue(value){return value="string"!=typeof value?String(value):value}function iteratorFor(items){var iterator={next:function(){var value=items.shift();return{done:void 0===value,value:value}}};return support.iterable&&(iterator[Symbol.iterator]=function(){return iterator}),iterator}function Headers(headers){this.map={},headers instanceof Headers?headers.forEach(function(value,name){this.append(name,value)},this):Array.isArray(headers)?headers.forEach(function(header){if(2!==header.length)throw new TypeError("Headers constructor: expected name/value pair to be length 2, found"+header.length);this.append(header[0],header[1])},this):headers&&Object.getOwnPropertyNames(headers).forEach(function(name){this.append(name,headers[name])},this)}function consumed(body){if(!body._noBody)return body.bodyUsed?Promise.reject(new TypeError("Already read")):void(body.bodyUsed=!0)}function fileReaderReady(reader){return new Promise(function(resolve,reject){reader.onload=function(){resolve(reader.result)},reader.onerror=function(){reject(reader.error)}})}function readBlobAsArrayBuffer(blob){var reader=new FileReader,promise=fileReaderReady(reader);return reader.readAsArrayBuffer(blob),promise}function bufferClone(buf){var view;return buf.slice?buf.slice(0):((view=new Uint8Array(buf.byteLength)).set(new Uint8Array(buf)),view.buffer)}function Body(){return this.bodyUsed=!1,this._initBody=function(body){var obj;this.bodyUsed=this.bodyUsed,(this._bodyInit=body)?"string"==typeof body?this._bodyText=body:support.blob&&Blob.prototype.isPrototypeOf(body)?this._bodyBlob=body:support.formData&&FormData.prototype.isPrototypeOf(body)?this._bodyFormData=body:support.searchParams&&URLSearchParams.prototype.isPrototypeOf(body)?this._bodyText=body.toString():support.arrayBuffer&&support.blob&&(obj=body)&&DataView.prototype.isPrototypeOf(obj)?(this._bodyArrayBuffer=bufferClone(body.buffer),this._bodyInit=new Blob([this._bodyArrayBuffer])):support.arrayBuffer&&(ArrayBuffer.prototype.isPrototypeOf(body)||isArrayBufferView(body))?this._bodyArrayBuffer=bufferClone(body):this._bodyText=body=Object.prototype.toString.call(body):(this._noBody=!0,this._bodyText=""),this.headers.get("content-type")||("string"==typeof body?this.headers.set("content-type","text/plain;charset=UTF-8"):this._bodyBlob&&this._bodyBlob.type?this.headers.set("content-type",this._bodyBlob.type):support.searchParams&&URLSearchParams.prototype.isPrototypeOf(body)&&this.headers.set("content-type","application/x-www-form-urlencoded;charset=UTF-8"))},support.blob&&(this.blob=function(){var rejected=consumed(this);if(rejected)return rejected;if(this._bodyBlob)return Promise.resolve(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(new Blob([this._bodyArrayBuffer]));if(this._bodyFormData)throw new Error("could not read FormData body as blob");return Promise.resolve(new Blob([this._bodyText]))}),this.arrayBuffer=function(){if(this._bodyArrayBuffer)return consumed(this)||(ArrayBuffer.isView(this._bodyArrayBuffer)?Promise.resolve(this._bodyArrayBuffer.buffer.slice(this._bodyArrayBuffer.byteOffset,this._bodyArrayBuffer.byteOffset+this._bodyArrayBuffer.byteLength)):Promise.resolve(this._bodyArrayBuffer));if(support.blob)return this.blob().then(readBlobAsArrayBuffer);throw new Error("could not read as ArrayBuffer")},this.text=function(){var reader,promise,match,rejected=consumed(this);if(rejected)return rejected;if(this._bodyBlob)return rejected=this._bodyBlob,reader=new FileReader,promise=fileReaderReady(reader),match=(match=/charset=([A-Za-z0-9_-]+)/.exec(rejected.type))?match[1]:"utf-8",reader.readAsText(rejected,match),promise;if(this._bodyArrayBuffer)return Promise.resolve(function(buf){for(var view=new Uint8Array(buf),chars=new Array(view.length),i=0;i<view.length;i++)chars[i]=String.fromCharCode(view[i]);return chars.join("")}(this._bodyArrayBuffer));if(this._bodyFormData)throw new Error("could not read FormData body as text");return Promise.resolve(this._bodyText)},support.formData&&(this.formData=function(){return this.text().then(decode)}),this.json=function(){return this.text().then(JSON.parse)},this}Headers.prototype.append=function(name,value){name=normalizeName(name),value=normalizeValue(value);var oldValue=this.map[name];this.map[name]=oldValue?oldValue+", "+value:value},Headers.prototype.delete=function(name){delete this.map[normalizeName(name)]},Headers.prototype.get=function(name){return name=normalizeName(name),this.has(name)?this.map[name]:null},Headers.prototype.has=function(name){return this.map.hasOwnProperty(normalizeName(name))},Headers.prototype.set=function(name,value){this.map[normalizeName(name)]=normalizeValue(value)},Headers.prototype.forEach=function(callback,thisArg){for(var name in this.map)this.map.hasOwnProperty(name)&&callback.call(thisArg,this.map[name],name,this)},Headers.prototype.keys=function(){var items=[];return this.forEach(function(value,name){items.push(name)}),iteratorFor(items)},Headers.prototype.values=function(){var items=[];return this.forEach(function(value){items.push(value)}),iteratorFor(items)},Headers.prototype.entries=function(){var items=[];return this.forEach(function(value,name){items.push([name,value])}),iteratorFor(items)},support.iterable&&(Headers.prototype[Symbol.iterator]=Headers.prototype.entries);var methods=["CONNECT","DELETE","GET","HEAD","OPTIONS","PATCH","POST","PUT","TRACE"];function Request(input,options){if(!(this instanceof Request))throw new TypeError('Please use the "new" operator, this DOM object constructor cannot be called as a function.');var upcased,body=(options=options||{}).body;if(input instanceof Request){if(input.bodyUsed)throw new TypeError("Already read");this.url=input.url,this.credentials=input.credentials,options.headers||(this.headers=new Headers(input.headers)),this.method=input.method,this.mode=input.mode,this.signal=input.signal,body||null==input._bodyInit||(body=input._bodyInit,input.bodyUsed=!0)}else this.url=String(input);if(this.credentials=options.credentials||this.credentials||"same-origin",!options.headers&&this.headers||(this.headers=new Headers(options.headers)),this.method=(input=options.method||this.method||"GET",upcased=input.toUpperCase(),-1<methods.indexOf(upcased)?upcased:input),this.mode=options.mode||this.mode||null,this.signal=options.signal||this.signal||function(){if("AbortController"in g)return(new AbortController).signal}(),this.referrer=null,("GET"===this.method||"HEAD"===this.method)&&body)throw new TypeError("Body not allowed for GET or HEAD requests");this._initBody(body),"GET"!==this.method&&"HEAD"!==this.method||"no-store"!==options.cache&&"no-cache"!==options.cache||((upcased=/([?&])_=[^&]*/).test(this.url)?this.url=this.url.replace(upcased,"$1_="+(new Date).getTime()):this.url+=(/\?/.test(this.url)?"&":"?")+"_="+(new Date).getTime())}function decode(body){var form=new FormData;return body.trim().split("&").forEach(function(bytes){var name;bytes&&(name=(bytes=bytes.split("=")).shift().replace(/\+/g," "),bytes=bytes.join("=").replace(/\+/g," "),form.append(decodeURIComponent(name),decodeURIComponent(bytes)))}),form}function Response(bodyInit,options){if(!(this instanceof Response))throw new TypeError('Please use the "new" operator, this DOM object constructor cannot be called as a function.');if(options=options||{},this.type="default",this.status=void 0===options.status?200:options.status,this.status<200||599<this.status)throw new RangeError("Failed to construct 'Response': The status provided (0) is outside the range [200, 599].");this.ok=200<=this.status&&this.status<300,this.statusText=void 0===options.statusText?"":""+options.statusText,this.headers=new Headers(options.headers),this.url=options.url||"",this._initBody(bodyInit)}Request.prototype.clone=function(){return new Request(this,{body:this._bodyInit})},Body.call(Request.prototype),Body.call(Response.prototype),Response.prototype.clone=function(){return new Response(this._bodyInit,{status:this.status,statusText:this.statusText,headers:new Headers(this.headers),url:this.url})},Response.error=function(){var response=new Response(null,{status:200,statusText:""});return response.status=0,response.type="error",response};var redirectStatuses=[301,302,303,307,308],DOMException=(Response.redirect=function(url,status){if(-1===redirectStatuses.indexOf(status))throw new RangeError("Invalid status code");return new Response(null,{status:status,headers:{location:url}})},_exports.DOMException=g.DOMException);try{new DOMException}catch(err){_exports.DOMException=DOMException=function(message,name){this.message=message,this.name=name;name=Error(message);this.stack=name.stack},DOMException.prototype=Object.create(Error.prototype),DOMException.prototype.constructor=DOMException}function fetch(input,init){return new Promise(function(resolve,reject){var xhr,names,request=new Request(input,init);function abortXhr(){xhr.abort()}request.signal&&request.signal.aborted?reject(new DOMException("Aborted","AbortError")):((xhr=new XMLHttpRequest).onload=function(){var rawHeaders,headers,options={status:xhr.status,statusText:xhr.statusText,headers:(rawHeaders=xhr.getAllResponseHeaders()||"",headers=new Headers,rawHeaders.replace(/\r?\n[\t ]+/g," ").split("\r").map(function(header){return 0===header.indexOf("\n")?header.substr(1,header.length):header}).forEach(function(line){var line=line.split(":"),key=line.shift().trim();if(key){line=line.join(":").trim();try{headers.append(key,line)}catch(error){console.warn("Response "+error.message)}}}),headers)},body=(options.url="responseURL"in xhr?xhr.responseURL:options.headers.get("X-Request-URL"),"response"in xhr?xhr.response:xhr.responseText);setTimeout(function(){resolve(new Response(body,options))},0)},xhr.onerror=function(){setTimeout(function(){reject(new TypeError("Network request failed"))},0)},xhr.ontimeout=function(){setTimeout(function(){reject(new TypeError("Network request failed"))},0)},xhr.onabort=function(){setTimeout(function(){reject(new DOMException("Aborted","AbortError"))},0)},xhr.open(request.method,function(url){try{return""===url&&g.location.href?g.location.href:url}catch(e){return url}}(request.url),!0),"include"===request.credentials?xhr.withCredentials=!0:"omit"===request.credentials&&(xhr.withCredentials=!1),"responseType"in xhr&&(support.blob?xhr.responseType="blob":support.arrayBuffer&&(xhr.responseType="arraybuffer")),init&&"object"==typeof init.headers&&!(init.headers instanceof Headers||g.Headers&&init.headers instanceof g.Headers)?(names=[],Object.getOwnPropertyNames(init.headers).forEach(function(name){names.push(normalizeName(name)),xhr.setRequestHeader(name,normalizeValue(init.headers[name]))}),request.headers.forEach(function(value,name){-1===names.indexOf(name)&&xhr.setRequestHeader(name,value)})):request.headers.forEach(function(value,name){xhr.setRequestHeader(name,value)}),request.signal&&(request.signal.addEventListener("abort",abortXhr),xhr.onreadystatechange=function(){4===xhr.readyState&&request.signal.removeEventListener("abort",abortXhr)}),xhr.send(void 0===request._bodyInit?null:request._bodyInit))})}fetch.polyfill=!0,g.fetch||(g.fetch=fetch,g.Headers=Headers,g.Request=Request,g.Response=Response)});