/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.List;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.sql.SqlKind;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.immutables.value.Value;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.opensearch.planner.physical.ImmutableOpenSearchDedupPushdownRule;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchIndexScanRule;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;

@Value.Enclosing
public class OpenSearchDedupPushdownRule
extends RelRule<Config> {
    private static final Logger LOG = LogManager.getLogger();

    protected OpenSearchDedupPushdownRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        List<Integer> selectColumns;
        LogicalProject finalOutput = (LogicalProject)call.rel(0);
        LogicalFilter numOfDedupFilter = (LogicalFilter)call.rel(1);
        LogicalProject projectWithWindow = (LogicalProject)call.rel(2);
        CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(3);
        List<RexWindow> windows = PlanUtils.getRexWindowFromProject(projectWithWindow);
        if (windows.isEmpty() || windows.stream().anyMatch(w -> w.partitionKeys.size() > 1)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the dedup with multiple fields");
            }
            return;
        }
        List<String> fieldNameList = projectWithWindow.getInput().getRowType().getFieldNames();
        String fieldName = fieldNameList.get((selectColumns = PlanUtils.getSelectColumns(windows.getFirst().partitionKeys)).getFirst());
        CalciteLogicalIndexScan newScan = scan.pushDownCollapse(finalOutput, fieldName);
        if (newScan != null) {
            call.transformTo(newScan);
        }
    }

    private static boolean validFilter(LogicalFilter filter) {
        if (filter.getCondition().getKind() != SqlKind.LESS_THAN_OR_EQUAL) {
            return false;
        }
        List<RexNode> operandsOfCondition = ((RexCall)filter.getCondition()).getOperands();
        RexNode leftOperand = operandsOfCondition.getFirst();
        if (!(leftOperand instanceof RexInputRef)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the dedup since the left operand is not RexInputRef");
            }
            return false;
        }
        RexInputRef ref = (RexInputRef)leftOperand;
        String referenceName = filter.getRowType().getFieldNames().get(ref.getIndex());
        if (!referenceName.equals("_row_number_dedup_")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the dedup since the left operand is not {}", (Object)"_row_number_dedup_");
            }
            return false;
        }
        RexNode rightOperand = operandsOfCondition.getLast();
        if (!(rightOperand instanceof RexLiteral)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the dedup since the right operand is not RexLiteral");
            }
            return false;
        }
        RexLiteral numLiteral = (RexLiteral)rightOperand;
        Integer num = numLiteral.getValueAs(Integer.class);
        if (num == null || num > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the dedup since number of duplicate events is larger than 1");
            }
            return false;
        }
        return true;
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableOpenSearchDedupPushdownRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalProject.class).oneInput(b1 -> b1.operand(LogicalFilter.class).predicate(OpenSearchDedupPushdownRule::validFilter).oneInput(b2 -> b2.operand(LogicalProject.class).predicate(PlanUtils::containsRowNumberDedup).oneInput(b3 -> b3.operand(CalciteLogicalIndexScan.class).predicate(Predicate.not(OpenSearchIndexScanRule::isLimitPushed).and(OpenSearchIndexScanRule::noAggregatePushed)).noInputs()))));

        @Override
        default public OpenSearchDedupPushdownRule toRule() {
            return new OpenSearchDedupPushdownRule(this);
        }
    }
}

