/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.time;

import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;

public class MonthSpanHandler {
    public RexNode createExpression(RexNode fieldExpr, int intervalMonths, CalcitePlanContext context) {
        RexNode inputYear = context.rexBuilder.makeCall(PPLBuiltinOperators.YEAR, fieldExpr);
        RexNode inputMonth = context.rexBuilder.makeCall(PPLBuiltinOperators.MONTH, fieldExpr);
        RexNode monthsSinceEpoch = this.calculateMonthsSinceEpoch(inputYear, inputMonth, context);
        RexNode binStartMonths = this.calculateBinStart(monthsSinceEpoch, intervalMonths, context);
        RexNode binStartYear = this.calculateBinStartYear(binStartMonths, context);
        RexNode binStartMonth = this.calculateBinStartMonth(binStartMonths, context);
        RexNode tempDate = context.rexBuilder.makeCall(PPLBuiltinOperators.MAKEDATE, binStartYear, context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, binStartMonth, context.relBuilder.literal(1)), context.relBuilder.literal(31)), context.relBuilder.literal(1)));
        return context.rexBuilder.makeCall(PPLBuiltinOperators.DATE_FORMAT, tempDate, context.relBuilder.literal("%Y-%m"));
    }

    private RexNode calculateMonthsSinceEpoch(RexNode inputYear, RexNode inputMonth, CalcitePlanContext context) {
        RexNode yearsSinceEpoch = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, inputYear, context.relBuilder.literal(1970));
        RexNode monthsFromYears = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, yearsSinceEpoch, context.relBuilder.literal(12));
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, monthsFromYears, context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, inputMonth, context.relBuilder.literal(1)));
    }

    private RexNode calculateBinStart(RexNode value, int interval, CalcitePlanContext context) {
        RexLiteral intervalLiteral = context.relBuilder.literal(interval);
        RexNode positionInCycle = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MOD, value, intervalLiteral);
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, value, positionInCycle);
    }

    private RexNode calculateBinStartYear(RexNode binStartMonths, CalcitePlanContext context) {
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, context.relBuilder.literal(1970), context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, binStartMonths, context.relBuilder.literal(12)));
    }

    private RexNode calculateBinStartMonth(RexNode binStartMonths, CalcitePlanContext context) {
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MOD, binStartMonths, context.relBuilder.literal(12)), context.relBuilder.literal(1));
    }
}

