/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.SearchExpression;
import org.opensearch.sql.ast.expression.SearchLiteral;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.utils.QueryStringUtils;

public class SearchComparison
extends SearchExpression {
    private final Field field;
    private final Operator operator;
    private final SearchLiteral value;

    @Override
    public String toQueryString() {
        String fieldName = QueryStringUtils.escapeFieldName(this.field.getField().toString());
        String valueStr = this.value.toQueryString();
        switch (this.operator.ordinal()) {
            case 1: {
                return "( _exists_:" + fieldName + " AND NOT " + fieldName + ":" + valueStr + " )";
            }
            case 4: {
                return fieldName + ":>" + valueStr;
            }
            case 5: {
                return fieldName + ":>=" + valueStr;
            }
            case 2: {
                return fieldName + ":<" + valueStr;
            }
            case 3: {
                return fieldName + ":<=" + valueStr;
            }
        }
        return fieldName + ":" + valueStr;
    }

    public List<? extends UnresolvedExpression> getChild() {
        return Arrays.asList(this.field, this.value);
    }

    @Generated
    public Field getField() {
        return this.field;
    }

    @Generated
    public Operator getOperator() {
        return this.operator;
    }

    @Generated
    public SearchLiteral getValue() {
        return this.value;
    }

    @Generated
    public SearchComparison(Field field, Operator operator, SearchLiteral value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchComparison)) {
            return false;
        }
        SearchComparison other = (SearchComparison)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        Operator this$operator = this.getOperator();
        Operator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        SearchLiteral this$value = this.getValue();
        SearchLiteral other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SearchComparison;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Field $field = this.getField();
        result2 = result2 * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        Operator $operator = this.getOperator();
        result2 = result2 * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        SearchLiteral $value = this.getValue();
        result2 = result2 * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result2;
    }

    @Override
    @Generated
    public String toString() {
        return "SearchComparison(field=" + String.valueOf(this.getField()) + ", operator=" + String.valueOf((Object)this.getOperator()) + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    public static enum Operator {
        EQUALS("="),
        NOT_EQUALS("!="),
        LESS_THAN("<"),
        LESS_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_OR_EQUAL(">=");

        private final String symbol;

        private Operator(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

