/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.connector.AbstractConnector;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.connector.ConnectorClientConfig;
import org.opensearch.ml.common.connector.ConnectorProtocols;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.utils.StringUtils;

@org.opensearch.ml.common.annotation.Connector(value="http")
public class HttpConnector
extends AbstractConnector {
    @Generated
    private static final Logger log = LogManager.getLogger(HttpConnector.class);
    public static final String CREDENTIAL_FIELD = "credential";
    public static final String RESPONSE_FILTER_FIELD = "response_filter";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String SERVICE_NAME_FIELD = "service_name";
    public static final String REGION_FIELD = "region";
    public static final String LLM_INTERFACE_OPENAI_V1_CHAT_COMPLETIONS = "openai/v1/chat/completions";

    public HttpConnector(String name, String description2, String version, String protocol, Map<String, String> parameters2, Map<String, String> credential, List<ConnectorAction> actions, List<String> backendRoles, AccessMode accessMode, User owner, ConnectorClientConfig connectorClientConfig, String tenantId) {
        ConnectorProtocols.validateProtocol(protocol);
        if (actions != null) {
            for (ConnectorAction action : actions) {
                action.validatePrePostProcessFunctions(parameters2);
            }
        }
        this.name = name;
        this.description = description2;
        this.version = version;
        this.protocol = protocol;
        this.parameters = parameters2;
        this.credential = credential;
        this.actions = actions;
        this.backendRoles = backendRoles;
        this.access = accessMode;
        this.owner = owner;
        this.connectorClientConfig = connectorClientConfig;
        this.tenantId = tenantId;
    }

    public HttpConnector(String protocol, XContentParser parser) throws IOException {
        this.protocol = protocol;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block32: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    this.name = parser.text();
                    continue block32;
                }
                case "version": {
                    this.version = parser.text();
                    continue block32;
                }
                case "description": {
                    this.description = parser.text();
                    continue block32;
                }
                case "protocol": {
                    this.protocol = parser.text();
                    continue block32;
                }
                case "parameters": {
                    Map map = parser.map();
                    this.parameters = StringUtils.getParameterMap(map);
                    continue block32;
                }
                case "credential": {
                    this.credential = new HashMap();
                    this.credential.putAll(parser.mapStrings());
                    continue block32;
                }
                case "actions": {
                    this.actions = new ArrayList();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.actions.add(ConnectorAction.parse(parser));
                    }
                    continue block32;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    this.backendRoles = new ArrayList();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.backendRoles.add(parser.text());
                    }
                    continue block32;
                }
                case "owner": {
                    this.owner = User.parse(parser);
                    continue block32;
                }
                case "access": {
                    this.access = AccessMode.from(parser.text());
                    continue block32;
                }
                case "created_time": {
                    this.createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block32;
                }
                case "last_updated_time": {
                    this.lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block32;
                }
                case "client_config": {
                    this.connectorClientConfig = ConnectorClientConfig.parse(parser);
                    continue block32;
                }
                case "tenant_id": {
                    this.tenantId = parser.textOrNull();
                    continue block32;
                }
            }
            parser.skipChildren();
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.version != null) {
            builder.field("version", this.version);
        }
        if (this.description != null) {
            builder.field("description", this.description);
        }
        if (this.protocol != null) {
            builder.field("protocol", this.protocol);
        }
        if (this.parameters != null) {
            builder.field(PARAMETERS_FIELD, (Object)this.parameters);
        }
        if (this.credential != null) {
            builder.field(CREDENTIAL_FIELD, (Object)this.credential);
        }
        if (this.actions != null) {
            builder.field("actions", (Iterable)this.actions);
        }
        if (this.backendRoles != null) {
            builder.field("backend_roles", (Iterable)this.backendRoles);
        }
        if (this.owner != null) {
            builder.field("owner", (ToXContent)this.owner);
        }
        if (this.access != null) {
            builder.field("access", this.access.getValue());
        }
        if (this.createdTime != null) {
            builder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field("last_updated_time", this.lastUpdateTime.toEpochMilli());
        }
        if (this.connectorClientConfig != null) {
            builder.field("client_config", (ToXContent)this.connectorClientConfig);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public HttpConnector(String protocol, StreamInput input) throws IOException {
        this.protocol = protocol;
        this.parseFromStream(input);
    }

    public HttpConnector(StreamInput input) throws IOException {
        this.protocol = input.readString();
        this.parseFromStream(input);
    }

    private void parseFromStream(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.name = input.readOptionalString();
        this.version = input.readOptionalString();
        this.description = input.readOptionalString();
        if (input.readBoolean()) {
            this.parameters = input.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (input.readBoolean()) {
            this.credential = input.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (input.readBoolean()) {
            this.actions = new ArrayList();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                this.actions.add(new ConnectorAction(input));
            }
        }
        this.backendRoles = input.readOptionalStringList();
        if (input.readBoolean()) {
            this.access = (AccessMode)input.readEnum(AccessMode.class);
        }
        if (input.readBoolean()) {
            this.owner = new User(input);
        }
        this.createdTime = input.readOptionalInstant();
        this.lastUpdateTime = input.readOptionalInstant();
        if (input.readBoolean()) {
            this.connectorClientConfig = new ConnectorClientConfig(input);
        }
        this.tenantId = streamInputVersion.onOrAfter(CommonValue.VERSION_2_19_0) ? input.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.protocol);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.version);
        out.writeOptionalString(this.description);
        if (this.parameters != null) {
            out.writeBoolean(true);
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.credential != null) {
            out.writeBoolean(true);
            out.writeMap(this.credential, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.actions != null) {
            out.writeBoolean(true);
            out.writeInt(this.actions.size());
            for (ConnectorAction action : this.actions) {
                action.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalStringCollection((Collection)this.backendRoles);
        if (this.access != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.access);
        } else {
            out.writeBoolean(false);
        }
        if (this.owner != null) {
            out.writeBoolean(true);
            this.owner.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdateTime);
        if (this.connectorClientConfig != null) {
            out.writeBoolean(true);
            this.connectorClientConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    @Override
    public void update(MLCreateConnectorInput updateContent, BiFunction<String, String, String> function) {
        if (updateContent.getName() != null) {
            this.name = updateContent.getName();
        }
        if (updateContent.getDescription() != null) {
            this.description = updateContent.getDescription();
        }
        if (updateContent.getVersion() != null) {
            this.version = updateContent.getVersion();
        }
        if (updateContent.getProtocol() != null) {
            this.protocol = updateContent.getProtocol();
        }
        if (updateContent.getParameters() != null && !updateContent.getParameters().isEmpty()) {
            this.getParameters().putAll(updateContent.getParameters());
        }
        if (updateContent.getCredential() != null && !updateContent.getCredential().isEmpty()) {
            this.credential = updateContent.getCredential();
            this.encrypt(function, this.tenantId);
        }
        if (updateContent.getActions() != null) {
            this.actions = updateContent.getActions();
        }
        if (updateContent.getBackendRoles() != null) {
            this.backendRoles = updateContent.getBackendRoles();
        }
        if (updateContent.getAccess() != null) {
            this.access = updateContent.getAccess();
        }
        if (updateContent.getConnectorClientConfig() != null) {
            this.connectorClientConfig = updateContent.getConnectorClientConfig();
        }
    }

    @Override
    public <T> T createPayload(String action, Map<String, String> parameters2) {
        Optional<ConnectorAction> connectorAction = this.findAction(action);
        if (connectorAction.isPresent() && connectorAction.get().getRequestBody() != null) {
            String payload = connectorAction.get().getRequestBody();
            payload = this.fillNullParameters(parameters2, payload);
            StringUtils.parseParameters(parameters2);
            StringSubstitutor substitutor = new StringSubstitutor(parameters2, "${parameters.", "}");
            payload = substitutor.replace(payload);
            if (!StringUtils.isJson(payload)) {
                throw new IllegalArgumentException("Invalid payload: " + payload);
            }
            if (this.neededStreamParameterInPayload(parameters2)) {
                JsonObject jsonObject = JsonParser.parseString(payload).getAsJsonObject();
                jsonObject.addProperty("stream", true);
                payload = jsonObject.toString();
            }
            return (T)payload;
        }
        return (T)parameters2.get("http_body");
    }

    private boolean neededStreamParameterInPayload(Map<String, String> parameters2) {
        if (parameters2 == null) {
            return false;
        }
        boolean isStream = parameters2.containsKey("stream");
        if (!isStream) {
            return false;
        }
        String llmInterface = parameters2.get("_llm_interface");
        if (org.apache.commons.lang3.StringUtils.isBlank(llmInterface)) {
            return false;
        }
        llmInterface = llmInterface.trim().toLowerCase(Locale.ROOT);
        switch (llmInterface = StringEscapeUtils.unescapeJava(llmInterface)) {
            case "openai/v1/chat/completions": {
                return true;
            }
        }
        return false;
    }

    protected String fillNullParameters(Map<String, String> parameters2, String payload) {
        List<String> bodyParams = this.findStringParametersWithNullDefaultValue(payload);
        String newPayload = payload;
        for (String key : bodyParams) {
            if (parameters2.containsKey(key) && parameters2.get(key) != null) continue;
            newPayload = newPayload.replace("\"${parameters." + key + ":-null}\"", "null");
        }
        return newPayload;
    }

    private List<String> findStringParametersWithNullDefaultValue(String input) {
        String regex = "\"\\$\\{parameters\\.(\\w+):-null}\"";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        ArrayList<String> paramList = new ArrayList<String>();
        while (matcher.find()) {
            String parameterValue = matcher.group(1);
            paramList.add(parameterValue);
        }
        return paramList;
    }

    @Override
    public void decrypt(String action, BiFunction<String, String, String> function, String tenantId) {
        HashMap<String, String> decrypted = new HashMap<String, String>();
        for (String key : this.credential.keySet()) {
            decrypted.put(key, function.apply((String)this.credential.get(key), tenantId));
        }
        this.decryptedCredential = decrypted;
        Optional<ConnectorAction> connectorAction = this.findAction(action);
        Map headers = connectorAction.map(ConnectorAction::getHeaders).orElse(null);
        this.decryptedHeaders = this.createDecryptedHeaders(headers);
    }

    @Override
    public Connector cloneConnector() {
        HttpConnector httpConnector;
        BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();
        try {
            this.writeTo((StreamOutput)bytesStreamOutput);
            StreamInput streamInput = bytesStreamOutput.bytes().streamInput();
            httpConnector = new HttpConnector(streamInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytesStreamOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bytesStreamOutput.close();
        return httpConnector;
    }

    @Override
    public void encrypt(BiFunction<String, String, String> function, String tenantId) {
        for (String key : this.credential.keySet()) {
            String encrypted = function.apply((String)this.credential.get(key), tenantId);
            this.credential.put(key, encrypted);
        }
    }

    @Override
    public String getActionHttpMethod(String action) {
        return this.findAction(action).get().getMethod();
    }

    @Generated
    public static HttpConnectorBuilder builder() {
        return new HttpConnectorBuilder();
    }

    @Generated
    public HttpConnector() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpConnector)) {
            return false;
        }
        HttpConnector other = (HttpConnector)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpConnector;
    }

    @Generated
    public int hashCode() {
        boolean result2 = true;
        return 1;
    }

    @Generated
    public static class HttpConnectorBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String version;
        @Generated
        private String protocol;
        @Generated
        private Map<String, String> parameters;
        @Generated
        private Map<String, String> credential;
        @Generated
        private List<ConnectorAction> actions;
        @Generated
        private List<String> backendRoles;
        @Generated
        private AccessMode accessMode;
        @Generated
        private User owner;
        @Generated
        private ConnectorClientConfig connectorClientConfig;
        @Generated
        private String tenantId;

        @Generated
        HttpConnectorBuilder() {
        }

        @Generated
        public HttpConnectorBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public HttpConnectorBuilder description(String description2) {
            this.description = description2;
            return this;
        }

        @Generated
        public HttpConnectorBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public HttpConnectorBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Generated
        public HttpConnectorBuilder parameters(Map<String, String> parameters2) {
            this.parameters = parameters2;
            return this;
        }

        @Generated
        public HttpConnectorBuilder credential(Map<String, String> credential) {
            this.credential = credential;
            return this;
        }

        @Generated
        public HttpConnectorBuilder actions(List<ConnectorAction> actions) {
            this.actions = actions;
            return this;
        }

        @Generated
        public HttpConnectorBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public HttpConnectorBuilder accessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
            return this;
        }

        @Generated
        public HttpConnectorBuilder owner(User owner) {
            this.owner = owner;
            return this;
        }

        @Generated
        public HttpConnectorBuilder connectorClientConfig(ConnectorClientConfig connectorClientConfig) {
            this.connectorClientConfig = connectorClientConfig;
            return this;
        }

        @Generated
        public HttpConnectorBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public HttpConnector build() {
            return new HttpConnector(this.name, this.description, this.version, this.protocol, this.parameters, this.credential, this.actions, this.backendRoles, this.accessMode, this.owner, this.connectorClientConfig, this.tenantId);
        }

        @Generated
        public String toString() {
            return "HttpConnector.HttpConnectorBuilder(name=" + this.name + ", description=" + this.description + ", version=" + this.version + ", protocol=" + this.protocol + ", parameters=" + String.valueOf(this.parameters) + ", credential=" + String.valueOf(this.credential) + ", actions=" + String.valueOf(this.actions) + ", backendRoles=" + String.valueOf(this.backendRoles) + ", accessMode=" + String.valueOf((Object)this.accessMode) + ", owner=" + String.valueOf(this.owner) + ", connectorClientConfig=" + String.valueOf(this.connectorClientConfig) + ", tenantId=" + this.tenantId + ")";
        }
    }
}

