/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.util.BigArrays;
import org.opensearch.geo.search.aggregations.metrics.AbstractGeoBoundsAggregator;
import org.opensearch.index.fielddata.MultiGeoPointValues;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

final class GeoBoundsAggregator
extends AbstractGeoBoundsAggregator<ValuesSource.GeoPoint> {
    GeoBoundsAggregator(String name, SearchContext aggregationContext, Aggregator parent, ValuesSourceConfig valuesSourceConfig, boolean wrapLongitude, Map<String, Object> metadata2) throws IOException {
        super(name, aggregationContext, parent, valuesSourceConfig, wrapLongitude, metadata2);
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final MultiGeoPointValues values2 = ((ValuesSource.GeoPoint)this.valuesSource).geoPointValues(ctx);
        return new LeafBucketCollectorBase(this, sub, values2){
            final /* synthetic */ GeoBoundsAggregator this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1);
            }

            public void collect(int doc, long bucket) throws IOException {
                this.this$0.setBucketSize(bucket, bigArrays);
                if (values2.advanceExact(doc)) {
                    int valuesCount = values2.docValueCount();
                    for (int i = 0; i < valuesCount; ++i) {
                        GeoPoint value = values2.nextValue();
                        double top = this.this$0.tops.get(bucket);
                        if (value.lat() > top) {
                            top = value.lat();
                        }
                        double bottom = this.this$0.bottoms.get(bucket);
                        if (value.lat() < bottom) {
                            bottom = value.lat();
                        }
                        double posLeft = this.this$0.posLefts.get(bucket);
                        if (value.lon() >= 0.0 && value.lon() < posLeft) {
                            posLeft = value.lon();
                        }
                        double posRight = this.this$0.posRights.get(bucket);
                        if (value.lon() >= 0.0 && value.lon() > posRight) {
                            posRight = value.lon();
                        }
                        double negLeft = this.this$0.negLefts.get(bucket);
                        if (value.lon() < 0.0 && value.lon() < negLeft) {
                            negLeft = value.lon();
                        }
                        double negRight = this.this$0.negRights.get(bucket);
                        if (value.lon() < 0.0 && value.lon() > negRight) {
                            negRight = value.lon();
                        }
                        this.this$0.tops.set(bucket, top);
                        this.this$0.bottoms.set(bucket, bottom);
                        this.this$0.posLefts.set(bucket, posLeft);
                        this.this$0.posRights.set(bucket, posRight);
                        this.this$0.negLefts.set(bucket, negLeft);
                        this.this$0.negRights.set(bucket, negRight);
                    }
                }
            }
        };
    }
}

