/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class EnumValue
extends ConstantValue<Pair<? extends ClassId, ? extends Name>> {
    @NotNull
    private final ClassId enumClassId;
    @NotNull
    private final Name enumEntryName;

    public EnumValue(@NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
        Intrinsics.checkNotNullParameter(enumClassId, "enumClassId");
        Intrinsics.checkNotNullParameter(enumEntryName, "enumEntryName");
        super(TuplesKt.to(enumClassId, enumEntryName));
        this.enumClassId = enumClassId;
        this.enumEntryName = enumEntryName;
    }

    @NotNull
    public final Name getEnumEntryName() {
        return this.enumEntryName;
    }

    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module) {
        KotlinType kotlinType;
        SimpleType simpleType2;
        SimpleType simpleType3;
        Intrinsics.checkNotNullParameter(module, "module");
        Annotated annotated = FindClassInModuleKt.findClassAcrossModuleDependencies(module, this.enumClassId);
        if (annotated == null) {
            simpleType3 = null;
        } else {
            ClassDescriptor classDescriptor = annotated;
            boolean bl = false;
            boolean bl2 = false;
            DeclarationDescriptor p0 = classDescriptor;
            boolean bl3 = false;
            ClassDescriptor classDescriptor2 = DescriptorUtils.isEnumClass(p0) ? classDescriptor : null;
            simpleType3 = simpleType2 = classDescriptor2 == null ? null : classDescriptor2.getDefaultType();
        }
        if (simpleType2 == null) {
            annotated = ErrorUtils.createErrorType("Containing class for error-class based enum entry " + this.enumClassId + '.' + this.enumEntryName);
            Intrinsics.checkNotNullExpressionValue(annotated, "createErrorType(\"Containing class for error-class based enum entry $enumClassId.$enumEntryName\")");
            kotlinType = (KotlinType)annotated;
        } else {
            kotlinType = simpleType2;
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public String toString() {
        return "" + this.enumClassId.getShortClassName() + '.' + this.enumEntryName;
    }
}

