/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventPublisher;
import io.github.resilience4j.core.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventProcessor<T>
implements EventPublisher<T> {
    List<EventConsumer<T>> onEventConsumers = new CopyOnWriteArrayList<EventConsumer<T>>();
    ConcurrentMap<String, List<EventConsumer<T>>> eventConsumerMap = new ConcurrentHashMap<String, List<EventConsumer<T>>>();
    private boolean consumerRegistered;

    public boolean hasConsumers() {
        return this.consumerRegistered;
    }

    public synchronized void registerConsumer(String className, EventConsumer<? extends T> eventConsumer) {
        this.consumerRegistered = true;
        this.eventConsumerMap.compute(className, (k, consumers) -> {
            if (consumers == null) {
                consumers = new ArrayList<EventConsumer>();
                consumers.add(eventConsumer);
                return consumers;
            }
            consumers.add(eventConsumer);
            return consumers;
        });
    }

    public <E extends T> boolean processEvent(E event) {
        List eventConsumers;
        boolean consumed = false;
        if (!this.onEventConsumers.isEmpty()) {
            this.onEventConsumers.forEach(onEventConsumer -> onEventConsumer.consumeEvent(event));
            consumed = true;
        }
        if (!this.eventConsumerMap.isEmpty() && (eventConsumers = (List)this.eventConsumerMap.get(event.getClass().getSimpleName())) != null && !eventConsumers.isEmpty()) {
            eventConsumers.forEach(consumer -> consumer.consumeEvent(event));
            consumed = true;
        }
        return consumed;
    }

    @Override
    public synchronized void onEvent(@Nullable EventConsumer<T> onEventConsumer) {
        this.consumerRegistered = true;
        this.onEventConsumers.add(onEventConsumer);
    }
}

