/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CommitmentPolicy;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.CryptoMaterialsManager;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.DefaultCryptoMaterialsManager;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.ParsedCiphertext;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.BlockDecryptionHandler;
import com.amazonaws.encryptionsdk.internal.CipherHandler;
import com.amazonaws.encryptionsdk.internal.CryptoHandler;
import com.amazonaws.encryptionsdk.internal.FrameDecryptionHandler;
import com.amazonaws.encryptionsdk.internal.MessageCryptoHandler;
import com.amazonaws.encryptionsdk.internal.ProcessingSummary;
import com.amazonaws.encryptionsdk.internal.SignaturePolicy;
import com.amazonaws.encryptionsdk.internal.TrailingSignatureAlgorithm;
import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.encryptionsdk.model.CiphertextFooters;
import com.amazonaws.encryptionsdk.model.CiphertextHeaders;
import com.amazonaws.encryptionsdk.model.CiphertextType;
import com.amazonaws.encryptionsdk.model.ContentType;
import com.amazonaws.encryptionsdk.model.DecryptionMaterials;
import com.amazonaws.encryptionsdk.model.DecryptionMaterialsRequest;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;

public class DecryptionHandler<K extends MasterKey<K>>
implements MessageCryptoHandler {
    private final CryptoMaterialsManager materialsManager_;
    private final CommitmentPolicy commitmentPolicy_;
    private final int maxEncryptedDataKeys_;
    private final SignaturePolicy signaturePolicy_;
    private final CiphertextHeaders ciphertextHeaders_;
    private final CiphertextFooters ciphertextFooters_;
    private boolean ciphertextHeadersParsed_;
    private CryptoHandler contentCryptoHandler_;
    private DataKey<K> dataKey_;
    private SecretKey decryptionKey_;
    private CryptoAlgorithm cryptoAlgo_;
    private Signature trailingSig_;
    private Map<String, String> encryptionContext_ = null;
    private byte[] unparsedBytes_ = new byte[0];
    private boolean complete_ = false;
    private long ciphertextSizeBound_ = -1L;
    private long ciphertextBytesSupplied_ = 0L;

    private DecryptionHandler(CryptoMaterialsManager materialsManager, CommitmentPolicy commitmentPolicy, SignaturePolicy signaturePolicy, int maxEncryptedDataKeys) {
        Utils.assertNonNull(materialsManager, "materialsManager");
        Utils.assertNonNull(commitmentPolicy, "commitmentPolicy");
        Utils.assertNonNull(signaturePolicy, "signaturePolicy");
        this.materialsManager_ = materialsManager;
        this.commitmentPolicy_ = commitmentPolicy;
        this.maxEncryptedDataKeys_ = maxEncryptedDataKeys;
        this.signaturePolicy_ = signaturePolicy;
        this.ciphertextHeaders_ = new CiphertextHeaders();
        this.ciphertextFooters_ = new CiphertextFooters();
    }

    private DecryptionHandler(CryptoMaterialsManager materialsManager, CiphertextHeaders headers, CommitmentPolicy commitmentPolicy, SignaturePolicy signaturePolicy, int maxEncryptedDataKeys) throws AwsCryptoException {
        Utils.assertNonNull(materialsManager, "materialsManager");
        Utils.assertNonNull(commitmentPolicy, "commitmentPolicy");
        Utils.assertNonNull(signaturePolicy, "signaturePolicy");
        this.materialsManager_ = materialsManager;
        this.ciphertextHeaders_ = headers;
        this.commitmentPolicy_ = commitmentPolicy;
        this.signaturePolicy_ = signaturePolicy;
        this.maxEncryptedDataKeys_ = maxEncryptedDataKeys;
        this.ciphertextFooters_ = new CiphertextFooters();
        this.ciphertextBytesSupplied_ = headers instanceof ParsedCiphertext ? (long)((ParsedCiphertext)headers).getOffset() : (long)headers.toByteArray().length;
        this.readHeaderFields(headers);
        this.updateTrailingSignature(headers);
    }

    public static <K extends MasterKey<K>> DecryptionHandler<K> create(MasterKeyProvider<K> customerMasterKeyProvider, CommitmentPolicy commitmentPolicy, SignaturePolicy signaturePolicy, int maxEncryptedDataKeys) throws AwsCryptoException {
        Utils.assertNonNull(customerMasterKeyProvider, "customerMasterKeyProvider");
        return DecryptionHandler.create(new DefaultCryptoMaterialsManager(customerMasterKeyProvider), commitmentPolicy, signaturePolicy, maxEncryptedDataKeys);
    }

    @Deprecated
    public static <K extends MasterKey<K>> DecryptionHandler<K> create(MasterKeyProvider<K> customerMasterKeyProvider, CiphertextHeaders headers, CommitmentPolicy commitmentPolicy, SignaturePolicy signaturePolicy, int maxEncryptedDataKeys) throws AwsCryptoException {
        Utils.assertNonNull(customerMasterKeyProvider, "customerMasterKeyProvider");
        return DecryptionHandler.create((CryptoMaterialsManager)new DefaultCryptoMaterialsManager(customerMasterKeyProvider), headers, commitmentPolicy, signaturePolicy, maxEncryptedDataKeys);
    }

    public static <K extends MasterKey<K>> DecryptionHandler<K> create(MasterKeyProvider<K> customerMasterKeyProvider, ParsedCiphertext headers, CommitmentPolicy commitmentPolicy, SignaturePolicy signaturePolicy, int maxEncryptedDataKeys) throws AwsCryptoException {
        Utils.assertNonNull(customerMasterKeyProvider, "customerMasterKeyProvider");
        return DecryptionHandler.create((CryptoMaterialsManager)new DefaultCryptoMaterialsManager(customerMasterKeyProvider), headers, commitmentPolicy, signaturePolicy, maxEncryptedDataKeys);
    }

    public static DecryptionHandler<?> create(CryptoMaterialsManager materialsManager, CommitmentPolicy commitmentPolicy, SignaturePolicy signaturePolicy, int maxEncryptedDataKeys) throws AwsCryptoException {
        return new DecryptionHandler(materialsManager, commitmentPolicy, signaturePolicy, maxEncryptedDataKeys);
    }

    @Deprecated
    public static DecryptionHandler<?> create(CryptoMaterialsManager materialsManager, CiphertextHeaders headers, CommitmentPolicy commitmentPolicy, SignaturePolicy signaturePolicy, int maxEncryptedDataKeys) throws AwsCryptoException {
        return new DecryptionHandler(materialsManager, headers, commitmentPolicy, signaturePolicy, maxEncryptedDataKeys);
    }

    public static DecryptionHandler<?> create(CryptoMaterialsManager materialsManager, ParsedCiphertext headers, CommitmentPolicy commitmentPolicy, SignaturePolicy signaturePolicy, int maxEncryptedDataKeys) throws AwsCryptoException {
        return new DecryptionHandler(materialsManager, headers, commitmentPolicy, signaturePolicy, maxEncryptedDataKeys);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProcessingSummary processBytes(byte[] in, int off, int len, byte[] out, int outOff) throws BadCiphertextException, AwsCryptoException {
        if (len < 0 || off < 0) {
            throw new AwsCryptoException(String.format("Invalid values for input offset: %d and length: %d", off, len));
        }
        if (in.length == 0 || len == 0) {
            return ProcessingSummary.ZERO;
        }
        long totalBytesToParse = (long)this.unparsedBytes_.length + (long)len;
        if (totalBytesToParse > Integer.MAX_VALUE) {
            throw new AwsCryptoException("Size of the total bytes to parse and decrypt exceeded allowed maximum:2147483647");
        }
        this.checkSizeBound(len);
        this.ciphertextBytesSupplied_ += (long)len;
        byte[] bytesToParse = new byte[(int)totalBytesToParse];
        int leftoverBytes = this.unparsedBytes_.length;
        System.arraycopy(this.unparsedBytes_, 0, bytesToParse, 0, this.unparsedBytes_.length);
        System.arraycopy(in, off, bytesToParse, this.unparsedBytes_.length, len);
        int totalParsedBytes = 0;
        if (!this.ciphertextHeadersParsed_) {
            totalParsedBytes += this.ciphertextHeaders_.deserialize(bytesToParse, 0, this.maxEncryptedDataKeys_);
            if (this.ciphertextHeaders_.isComplete().booleanValue()) {
                this.readHeaderFields(this.ciphertextHeaders_);
                this.updateTrailingSignature(this.ciphertextHeaders_);
                this.unparsedBytes_ = new byte[0];
            } else {
                this.unparsedBytes_ = Arrays.copyOfRange(bytesToParse, totalParsedBytes, bytesToParse.length);
                return new ProcessingSummary(0, len);
            }
        }
        int actualOutLen = 0;
        if (!this.contentCryptoHandler_.isComplete()) {
            if (bytesToParse.length - totalParsedBytes > 0) {
                ProcessingSummary contentResult = this.contentCryptoHandler_.processBytes(bytesToParse, totalParsedBytes, bytesToParse.length - totalParsedBytes, out, outOff);
                this.updateTrailingSignature(bytesToParse, totalParsedBytes, contentResult.getBytesProcessed());
                actualOutLen = contentResult.getBytesWritten();
                totalParsedBytes += contentResult.getBytesProcessed();
            }
            if (this.contentCryptoHandler_.isComplete()) {
                actualOutLen += this.contentCryptoHandler_.doFinal(out, outOff + actualOutLen);
            }
        }
        if (!this.contentCryptoHandler_.isComplete()) return new ProcessingSummary(actualOutLen, totalParsedBytes - leftoverBytes);
        if (this.cryptoAlgo_.getTrailingSignatureLength() > 0) {
            totalParsedBytes += this.ciphertextFooters_.deserialize(bytesToParse, totalParsedBytes);
            if (this.ciphertextFooters_.isComplete()) {
                this.unparsedBytes_ = new byte[0];
                try {
                    if (!this.trailingSig_.verify(this.ciphertextFooters_.getMAuth())) {
                        throw new BadCiphertextException("Bad trailing signature");
                    }
                }
                catch (SignatureException ex) {
                    throw new BadCiphertextException("Bad trailing signature", ex);
                }
                this.complete_ = true;
                return new ProcessingSummary(actualOutLen, totalParsedBytes - leftoverBytes);
            }
            this.unparsedBytes_ = Arrays.copyOfRange(bytesToParse, totalParsedBytes, bytesToParse.length);
            return new ProcessingSummary(actualOutLen, len);
        }
        this.complete_ = true;
        return new ProcessingSummary(actualOutLen, totalParsedBytes - leftoverBytes);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws BadCiphertextException {
        if (this.ciphertextBytesSupplied_ == 0L) {
            return 0;
        }
        if (this.contentCryptoHandler_ == null) {
            throw new BadCiphertextException("Unable to process entire ciphertext.");
        }
        int result2 = this.contentCryptoHandler_.doFinal(out, outOff);
        if (!this.complete_) {
            throw new BadCiphertextException("Unable to process entire ciphertext.");
        }
        return result2;
    }

    @Override
    public int estimateOutputSize(int inLen) {
        if (this.contentCryptoHandler_ != null) {
            return this.contentCryptoHandler_.estimateOutputSize(inLen);
        }
        return inLen > 0 ? inLen : 0;
    }

    @Override
    public int estimatePartialOutputSize(int inLen) {
        if (this.contentCryptoHandler_ != null) {
            return this.contentCryptoHandler_.estimatePartialOutputSize(inLen);
        }
        return inLen > 0 ? inLen : 0;
    }

    @Override
    public int estimateFinalOutputSize() {
        if (this.contentCryptoHandler_ != null) {
            return this.contentCryptoHandler_.estimateFinalOutputSize();
        }
        return 0;
    }

    @Override
    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext_;
    }

    private void checkSizeBound(long additionalBytes) {
        if (this.ciphertextSizeBound_ != -1L && this.ciphertextBytesSupplied_ + additionalBytes > this.ciphertextSizeBound_) {
            throw new IllegalStateException("Ciphertext size exceeds size bound");
        }
    }

    @Override
    public void setMaxInputLength(long size) {
        if (size < 0L) {
            throw Utils.cannotBeNegative("Max input length");
        }
        if (this.ciphertextSizeBound_ == -1L || this.ciphertextSizeBound_ > size) {
            this.ciphertextSizeBound_ = size;
        }
        this.checkSizeBound(0L);
    }

    long getMaxInputLength() {
        return this.ciphertextSizeBound_;
    }

    private void verifyHeaderIntegrity(CiphertextHeaders ciphertextHeaders) throws BadCiphertextException {
        CipherHandler cipherHandler = new CipherHandler(this.decryptionKey_, 2, this.cryptoAlgo_);
        try {
            byte[] headerTag = ciphertextHeaders.getHeaderTag();
            cipherHandler.cipherData(ciphertextHeaders.getHeaderNonce(), ciphertextHeaders.serializeAuthenticatedFields(), headerTag, 0, headerTag.length);
        }
        catch (BadCiphertextException e) {
            throw new BadCiphertextException("Header integrity check failed.", e);
        }
    }

    private void readHeaderFields(CiphertextHeaders ciphertextHeaders) {
        this.cryptoAlgo_ = ciphertextHeaders.getCryptoAlgoId();
        CiphertextType ciphertextType = ciphertextHeaders.getType();
        if (ciphertextType != CiphertextType.CUSTOMER_AUTHENTICATED_ENCRYPTED_DATA) {
            throw new BadCiphertextException("Invalid type in ciphertext.");
        }
        byte[] messageId = ciphertextHeaders.getMessageId();
        if (!this.commitmentPolicy_.algorithmAllowedForDecrypt(this.cryptoAlgo_)) {
            throw new AwsCryptoException("Configuration conflict. Cannot decrypt message with ID " + messageId + " due to CommitmentPolicy " + (Object)((Object)this.commitmentPolicy_) + " requiring only committed messages. Algorithm ID was " + (Object)((Object)this.cryptoAlgo_) + ". See: https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/troubleshooting-migration.html");
        }
        if (this.maxEncryptedDataKeys_ > 0 && this.ciphertextHeaders_.getEncryptedKeyBlobCount() > this.maxEncryptedDataKeys_) {
            throw new AwsCryptoException("Ciphertext encrypted data keys exceed maxEncryptedDataKeys");
        }
        if (!this.signaturePolicy_.algorithmAllowedForDecrypt(this.cryptoAlgo_)) {
            throw new AwsCryptoException("Configuration conflict. Cannot decrypt message with ID " + messageId + " because AwsCrypto.createUnsignedMessageDecryptingStream()  accepts only unsigned messages. Algorithm ID was " + (Object)((Object)this.cryptoAlgo_) + ".");
        }
        this.encryptionContext_ = ciphertextHeaders.getEncryptionContextMap();
        DecryptionMaterialsRequest request = DecryptionMaterialsRequest.newBuilder().setAlgorithm(this.cryptoAlgo_).setEncryptionContext(this.encryptionContext_).setEncryptedDataKeys(ciphertextHeaders.getEncryptedKeyBlobs()).build();
        DecryptionMaterials result2 = this.materialsManager_.decryptMaterials(request);
        this.dataKey_ = result2.getDataKey();
        PublicKey trailingPublicKey = result2.getTrailingSignatureKey();
        try {
            this.decryptionKey_ = this.cryptoAlgo_.getEncryptionKeyFromDataKey(this.dataKey_.getKey(), ciphertextHeaders);
        }
        catch (InvalidKeyException ex) {
            throw new AwsCryptoException(ex);
        }
        if (this.cryptoAlgo_.getTrailingSignatureLength() > 0) {
            Utils.assertNonNull(trailingPublicKey, "trailing public key");
            TrailingSignatureAlgorithm trailingSignatureAlgorithm = TrailingSignatureAlgorithm.forCryptoAlgorithm(this.cryptoAlgo_);
            try {
                this.trailingSig_ = Signature.getInstance(trailingSignatureAlgorithm.getHashAndSignAlgorithm());
                this.trailingSig_.initVerify(trailingPublicKey);
            }
            catch (GeneralSecurityException e) {
                throw new AwsCryptoException(e);
            }
        } else {
            if (trailingPublicKey != null) {
                throw new AwsCryptoException("Unexpected trailing signature key in context");
            }
            this.trailingSig_ = null;
        }
        ContentType contentType = ciphertextHeaders.getContentType();
        short nonceLen = ciphertextHeaders.getNonceLength();
        int frameLen = ciphertextHeaders.getFrameLength();
        this.verifyHeaderIntegrity(ciphertextHeaders);
        switch (contentType) {
            case FRAME: {
                this.contentCryptoHandler_ = new FrameDecryptionHandler(this.decryptionKey_, (byte)nonceLen, this.cryptoAlgo_, messageId, frameLen);
                break;
            }
            case SINGLEBLOCK: {
                this.contentCryptoHandler_ = new BlockDecryptionHandler(this.decryptionKey_, (byte)nonceLen, this.cryptoAlgo_, messageId);
                break;
            }
        }
        this.ciphertextHeadersParsed_ = true;
    }

    private void updateTrailingSignature(CiphertextHeaders headers) {
        if (this.trailingSig_ != null) {
            byte[] reserializedHeaders = headers.toByteArray();
            this.updateTrailingSignature(reserializedHeaders, 0, reserializedHeaders.length);
        }
    }

    private void updateTrailingSignature(byte[] input, int offset, int len) {
        if (this.trailingSig_ != null) {
            try {
                this.trailingSig_.update(input, offset, len);
            }
            catch (SignatureException ex) {
                throw new AwsCryptoException(ex);
            }
        }
    }

    @Override
    public CiphertextHeaders getHeaders() {
        return this.ciphertextHeaders_;
    }

    public List<K> getMasterKeys() {
        return Collections.singletonList(this.dataKey_.getMasterKey());
    }

    @Override
    public boolean isComplete() {
        return this.complete_;
    }
}

