/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndicesVersions
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndicesVersions> {
    private final int indexCount;
    private final int primaryShardCount;
    private final long totalPrimaryBytes;
    @Nonnull
    private final String version;
    public static final JsonpDeserializer<IndicesVersions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesVersions::setupIndicesVersionsDeserializer);

    private IndicesVersions(Builder builder) {
        this.indexCount = ApiTypeHelper.requireNonNull(builder.indexCount, this, "indexCount");
        this.primaryShardCount = ApiTypeHelper.requireNonNull(builder.primaryShardCount, this, "primaryShardCount");
        this.totalPrimaryBytes = ApiTypeHelper.requireNonNull(builder.totalPrimaryBytes, this, "totalPrimaryBytes");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static IndicesVersions of(Function<Builder, ObjectBuilder<IndicesVersions>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int indexCount() {
        return this.indexCount;
    }

    public final int primaryShardCount() {
        return this.primaryShardCount;
    }

    public final long totalPrimaryBytes() {
        return this.totalPrimaryBytes;
    }

    @Nonnull
    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        generator.writeKey("primary_shard_count");
        generator.write(this.primaryShardCount);
        generator.writeKey("total_primary_bytes");
        generator.write(this.totalPrimaryBytes);
        generator.writeKey("version");
        generator.write(this.version);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndicesVersionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count");
        op.add(Builder::primaryShardCount, JsonpDeserializer.integerDeserializer(), "primary_shard_count");
        op.add(Builder::totalPrimaryBytes, JsonpDeserializer.longDeserializer(), "total_primary_bytes");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.indexCount);
        result = 31 * result + Integer.hashCode(this.primaryShardCount);
        result = 31 * result + Long.hashCode(this.totalPrimaryBytes);
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndicesVersions other = (IndicesVersions)o;
        return this.indexCount == other.indexCount && this.primaryShardCount == other.primaryShardCount && this.totalPrimaryBytes == other.totalPrimaryBytes && this.version.equals(other.version);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndicesVersions> {
        private Integer indexCount;
        private Integer primaryShardCount;
        private Long totalPrimaryBytes;
        private String version;

        public Builder() {
        }

        private Builder(IndicesVersions o) {
            this.indexCount = o.indexCount;
            this.primaryShardCount = o.primaryShardCount;
            this.totalPrimaryBytes = o.totalPrimaryBytes;
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.indexCount = o.indexCount;
            this.primaryShardCount = o.primaryShardCount;
            this.totalPrimaryBytes = o.totalPrimaryBytes;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        @Nonnull
        public final Builder primaryShardCount(int value) {
            this.primaryShardCount = value;
            return this;
        }

        @Nonnull
        public final Builder totalPrimaryBytes(long value) {
            this.totalPrimaryBytes = value;
            return this;
        }

        @Nonnull
        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public IndicesVersions build() {
            this._checkSingleUse();
            return new IndicesVersions(this);
        }
    }
}

