/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gaussdb.ui.config;

import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.gaussdb.model.GaussDBFunction;
import org.jkiss.dbeaver.ext.gaussdb.model.GaussDBProcedure;
import org.jkiss.dbeaver.ext.gaussdb.ui.views.CreateFunctionOrProcedurePage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UITask;

public class GaussDBFunctionConfigurator
implements DBEObjectConfigurator<GaussDBFunction> {
    protected static final Log log = Log.getLog(GaussDBFunctionConfigurator.class);
    public static boolean isFunction = true;

    public GaussDBFunction configureObject(final DBRProgressMonitor monitor, DBECommandContext commandContext, Object container, final GaussDBFunction newProcedure, Map<String, Object> options) {
        return (GaussDBFunction)new UITask<GaussDBFunction>(){

            protected GaussDBFunction runTask() {
                CreateFunctionOrProcedurePage editPage = new CreateFunctionOrProcedurePage(monitor, (GaussDBProcedure)newProcedure, isFunction);
                if (!editPage.edit()) {
                    return null;
                }
                newProcedure.setKind(PostgreProcedureKind.f);
                newProcedure.setReturnType(editPage.getReturnType());
                newProcedure.setName(editPage.getProcedureName());
                PostgreLanguage language = editPage.getLanguage();
                if (language != null) {
                    newProcedure.setLanguage(language);
                }
                String function = "CREATE [OR REPLACE] FUNCTION " + newProcedure.getFullQualifiedSignature() + " ([ parameter [IN|OUT|INOUT] datatype[,parameter [IN|OUT|INOUT] datatype] ])\r\n RETURNS " + newProcedure.getReturnType().getDefaultValue() + "\r\n LANGUAGE " + language.getName() + "\r\n\r\nAS\r\n\r\n '/*iso file path and name*/',$$/*function name*/$$";
                newProcedure.setObjectDefinitionText(function);
                return newProcedure;
            }
        }.execute();
    }
}

