/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.visitor.AttributeCounter;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.constant.visitor.ExceptClassConstantFilter;
import proguard.classfile.editor.AttributeAdder;
import proguard.classfile.editor.InterfaceAdder;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCollector;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.ExceptClassesFilter;
import proguard.classfile.visitor.ImplementedClassConstantFilter;
import proguard.classfile.visitor.ImplementingClassConstantFilter;
import proguard.classfile.visitor.InitializerMethodFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCollector;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.SimilarMemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.info.CaughtClassFilter;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.InstanceofClassFilter;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.info.PackageVisibleMemberContainingClassMarker;
import proguard.optimize.info.PackageVisibleMemberInvokingClassMarker;
import proguard.optimize.info.ProgramClassOptimizationInfo;
import proguard.optimize.info.ProgramFieldOptimizationInfo;
import proguard.optimize.info.SideEffectClassFilter;
import proguard.util.FixedStringMatcher;
import proguard.util.NotMatcher;
import proguard.util.OrMatcher;

public class ClassMerger
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DETAILS = false;
    private final ProgramClass targetClass;
    private final boolean allowAccessModification;
    private final boolean mergeInterfacesAggressively;
    private final boolean mergeWrapperClasses;
    private final ClassVisitor extraClassVisitor;
    private final MemberVisitor fieldOptimizationInfoCopier = new FieldOptimizationInfoCopier();

    public ClassMerger(ProgramClass targetClass, boolean allowAccessModification, boolean mergeInterfacesAggressively, boolean mergeWrapperClasses) {
        this(targetClass, allowAccessModification, mergeInterfacesAggressively, mergeWrapperClasses, null);
    }

    public ClassMerger(ProgramClass targetClass, boolean allowAccessModification, boolean mergeInterfacesAggressively, boolean mergeWrapperClasses, ClassVisitor extraClassVisitor) {
        this.targetClass = targetClass;
        this.allowAccessModification = allowAccessModification;
        this.mergeInterfacesAggressively = mergeInterfacesAggressively;
        this.mergeWrapperClasses = mergeWrapperClasses;
        this.extraClassVisitor = extraClassVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        try {
            this.visitProgramClass0(programClass);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while merging classes:");
            System.err.println("  Class        = [" + programClass.getName() + "]");
            System.err.println("  Target class = [" + this.targetClass.getName() + "]");
            System.err.println("  Exception    = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            throw ex;
        }
    }

    public void visitProgramClass0(ProgramClass programClass) {
        if (!(programClass.equals(this.targetClass) || KeepMarker.isKept(programClass) || KeepMarker.isKept(this.targetClass) || ClassMerger.getTargetClass(programClass) != null || ClassMerger.getTargetClass(this.targetClass) != null || (programClass.getAccessFlags() & 0x2000) != 0 || programClass.u4version != this.targetClass.u4version || !this.allowAccessModification && ((programClass.getAccessFlags() & this.targetClass.getAccessFlags() & 1) == 0 || PackageVisibleMemberContainingClassMarker.containsPackageVisibleMembers(programClass) || PackageVisibleMemberInvokingClassMarker.invokesPackageVisibleMembers(programClass)) && !ClassUtil.internalPackageName(programClass.getName()).equals(ClassUtil.internalPackageName(this.targetClass.getName())) || (programClass.getAccessFlags() & 0x600) != (this.targetClass.getAccessFlags() & 0x600) && (!this.isOnlySubClass(programClass, this.targetClass) || programClass.getSuperClass() == null || !programClass.getSuperClass().equals(this.targetClass) && !programClass.getSuperClass().equals(this.targetClass.getSuperClass())) || this.indirectlyImplementedInterfaces(programClass).contains(this.targetClass) || this.targetClass.extendsOrImplements(programClass) || (programClass.getAccessFlags() & 0x200) != 0 && (this.targetClass.getAccessFlags() & 0x200) != 0 && !this.subInterfaces(programClass, this.targetClass).equals(this.subInterfaces(this.targetClass, programClass)) || !this.sideEffectSuperClasses(programClass).equals(this.sideEffectSuperClasses(this.targetClass)) || !this.instanceofedSuperClasses(programClass).equals(this.instanceofedSuperClasses(this.targetClass)) || !this.caughtSuperClasses(programClass).equals(this.caughtSuperClasses(this.targetClass)) || DotClassMarker.isDotClassed(programClass) && DotClassMarker.isDotClassed(this.targetClass) || !this.mergeWrapperClasses && this.haveAnyIdenticalFields(programClass, this.targetClass) || !this.mergeWrapperClasses && (this.introducesUnwantedFields(programClass, this.targetClass) || this.introducesUnwantedFields(this.targetClass, programClass)) || !this.mergeWrapperClasses && (this.shadowsAnyFields(programClass, this.targetClass) || this.shadowsAnyFields(this.targetClass, programClass)) || this.haveAnyIdenticalMethods(programClass, this.targetClass) || !this.mergeInterfacesAggressively && (this.introducesUnwantedAbstractMethods(programClass, this.targetClass) || this.introducesUnwantedAbstractMethods(this.targetClass, programClass)) || this.overridesAnyMethods(programClass, this.targetClass) || this.overridesAnyMethods(this.targetClass, programClass) || this.shadowsAnyMethods(programClass, this.targetClass) || this.shadowsAnyMethods(this.targetClass, programClass) || this.hasSignatureAttribute(programClass) || this.hasSignatureAttribute(this.targetClass) || !this.mergeWrapperClasses && (programClass.getAccessFlags() & 0x1000) == 0 && this.hasNonCopiableAttributes(programClass))) {
            int targetAccessFlags = this.targetClass.getAccessFlags();
            int sourceAccessFlags = programClass.getAccessFlags();
            this.targetClass.u2accessFlags = targetAccessFlags & sourceAccessFlags & 0x600 | (targetAccessFlags | sourceAccessFlags) & 0x6021;
            programClass.interfaceConstantsAccept(new ExceptClassConstantFilter(this.targetClass.getName(), new ImplementedClassConstantFilter(this.targetClass, new ImplementingClassConstantFilter(this.targetClass, new InterfaceAdder(this.targetClass)))));
            MemberAdder memberAdder = new MemberAdder(this.targetClass, this.fieldOptimizationInfoCopier);
            programClass.fieldsAccept(this.mergeWrapperClasses ? new MemberAccessFilter(8, 0, memberAdder) : memberAdder);
            programClass.methodsAccept(this.mergeWrapperClasses ? new MemberNameFilter(new NotMatcher(new FixedStringMatcher("<init>")), (MemberVisitor)memberAdder) : memberAdder);
            programClass.attributesAccept(new AttributeNameFilter(new NotMatcher(new OrMatcher(new FixedStringMatcher("BootstrapMethods"), new OrMatcher(new FixedStringMatcher("SourceFile"), new OrMatcher(new FixedStringMatcher("InnerClasses"), new FixedStringMatcher("EnclosingMethod"))))), (AttributeVisitor)new AttributeAdder(this.targetClass, true)));
            ProgramClassOptimizationInfo.getProgramClassOptimizationInfo(this.targetClass).merge(ClassOptimizationInfo.getClassOptimizationInfo(programClass));
            ClassMerger.setTargetClass(programClass, this.targetClass);
            if (this.extraClassVisitor != null) {
                this.extraClassVisitor.visitProgramClass(programClass);
            }
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    private boolean print(ProgramClass programClass, String message) {
        System.out.println("Merge [" + this.targetClass.getName() + "] <- [" + programClass.getName() + "] " + message);
        return true;
    }

    private boolean isOnlySubClass(Clazz subClass, ProgramClass clazz) {
        return clazz.subClasses != null && clazz.subClasses.length == 1 && clazz.subClasses[0].equals(subClass);
    }

    private Set indirectlyImplementedInterfaces(Clazz clazz) {
        HashSet set = new HashSet();
        ReferencedClassVisitor referencedInterfaceCollector = new ReferencedClassVisitor(new ClassHierarchyTraveler(false, false, true, false, new ClassCollector(set)));
        clazz.superClassConstantAccept(referencedInterfaceCollector);
        clazz.interfaceConstantsAccept(referencedInterfaceCollector);
        return set;
    }

    private Set subInterfaces(Clazz clazz, Clazz exceptClass) {
        HashSet set = new HashSet();
        clazz.hierarchyAccept(false, false, false, true, new ClassAccessFilter(512, 0, new ExceptClassesFilter(new Clazz[]{exceptClass}, new ClassCollector(set))));
        return set;
    }

    private Set sideEffectSuperClasses(Clazz clazz) {
        HashSet set = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new SideEffectClassFilter(new ClassCollector(set)));
        return set;
    }

    private Set instanceofedSuperClasses(Clazz clazz) {
        HashSet set = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new InstanceofClassFilter(new ClassCollector(set)));
        return set;
    }

    private Set caughtSuperClasses(Clazz clazz) {
        if (!clazz.extends_("java/lang/Throwable")) {
            return Collections.EMPTY_SET;
        }
        HashSet set = new HashSet();
        clazz.hierarchyAccept(true, true, false, false, new CaughtClassFilter(new ClassCollector(set)));
        return set;
    }

    private boolean hasSignatureAttribute(Clazz clazz) {
        AttributeCounter counter = new AttributeCounter();
        clazz.attributesAccept(new AttributeNameFilter(new FixedStringMatcher("Signature"), (AttributeVisitor)counter));
        return counter.getCount() > 0;
    }

    private boolean haveAnyIdenticalFields(Clazz clazz, Clazz targetClass) {
        MemberCounter counter = new MemberCounter();
        clazz.fieldsAccept(new SimilarMemberVisitor(targetClass, true, false, false, false, counter));
        return counter.getCount() > 0;
    }

    private boolean introducesUnwantedFields(Clazz programClass, ProgramClass targetClass) {
        if (!InstantiationClassMarker.isInstantiated(targetClass) && (targetClass.subClasses == null || this.isOnlySubClass(programClass, targetClass))) {
            return false;
        }
        MemberCounter counter = new MemberCounter();
        programClass.fieldsAccept(new MemberAccessFilter(0, 8, counter));
        return counter.getCount() > 0;
    }

    private boolean shadowsAnyFields(Clazz clazz, Clazz targetClass) {
        MemberCounter counter = new MemberCounter();
        clazz.hierarchyAccept(true, false, false, true, new AllFieldVisitor(new SimilarMemberVisitor(targetClass, true, true, true, false, new MemberAccessFilter(0, 2, counter))));
        return counter.getCount() > 0;
    }

    private boolean haveAnyIdenticalMethods(Clazz clazz, Clazz targetClass) {
        MemberCounter counter = new MemberCounter();
        clazz.methodsAccept(new MemberAccessFilter(0, 1024, new SimilarMemberVisitor(targetClass, true, false, false, false, new MemberAccessFilter(0, 1024, counter))));
        return counter.getCount() > 0;
    }

    private boolean introducesUnwantedAbstractMethods(Clazz clazz, ProgramClass targetClass) {
        if ((targetClass.getAccessFlags() & 0x600) != 0 && (targetClass.subClasses == null || this.isOnlySubClass(clazz, targetClass))) {
            return false;
        }
        MemberCounter counter = new MemberCounter();
        HashSet targetSet = new HashSet();
        clazz.methodsAccept(new MemberAccessFilter(1024, 0, new MultiMemberVisitor(counter, new SimilarMemberVisitor(targetClass, true, true, true, false, new MemberAccessFilter(1024, 0, new MemberCollector(false, true, true, targetSet))))));
        return targetSet.size() < counter.getCount();
    }

    private boolean overridesAnyMethods(Clazz clazz, ProgramClass targetClass) {
        if (!InstantiationClassMarker.isInstantiated(targetClass) && (targetClass.subClasses == null || this.isOnlySubClass(clazz, targetClass))) {
            return false;
        }
        MemberCounter counter = new MemberCounter();
        clazz.methodsAccept(new MemberAccessFilter(0, 1024, new InitializerMethodFilter(null, new SimilarMemberVisitor(targetClass, true, true, false, false, new MemberAccessFilter(0, 1034, counter)))));
        return counter.getCount() > 0;
    }

    private boolean shadowsAnyMethods(Clazz clazz, Clazz targetClass) {
        if (clazz.extends_(targetClass) || targetClass.extends_(clazz)) {
            return false;
        }
        MemberCounter counter = new MemberCounter();
        clazz.hierarchyAccept(true, false, false, true, new AllMethodVisitor(new InitializerMethodFilter(null, new SimilarMemberVisitor(targetClass, true, true, false, false, new MemberAccessFilter(16, 0, counter)))));
        if (counter.getCount() > 0) {
            return true;
        }
        clazz.hierarchyAccept(true, false, false, true, new AllMethodVisitor(new MemberAccessFilter(2, 0, new InitializerMethodFilter(null, new SimilarMemberVisitor(targetClass, true, true, true, false, new MemberAccessFilter(0, 2, counter))))));
        if (counter.getCount() > 0) {
            return true;
        }
        clazz.hierarchyAccept(true, false, false, true, new AllMethodVisitor(new MemberAccessFilter(8, 0, new InitializerMethodFilter(null, new SimilarMemberVisitor(targetClass, true, true, true, false, new MemberAccessFilter(0, 2, counter))))));
        return counter.getCount() > 0;
    }

    private boolean hasNonCopiableAttributes(Clazz clazz) {
        AttributeCounter counter = new AttributeCounter();
        clazz.attributesAccept(new AttributeNameFilter(new OrMatcher(new FixedStringMatcher("InnerClasses"), new FixedStringMatcher("EnclosingMethod")), (AttributeVisitor)counter));
        return counter.getCount() > 0;
    }

    public static void setTargetClass(Clazz clazz, Clazz targetClass) {
        ProgramClassOptimizationInfo.getProgramClassOptimizationInfo(clazz).setTargetClass(targetClass);
    }

    public static Clazz getTargetClass(Clazz clazz) {
        Clazz targetClass = null;
        while ((clazz = ClassOptimizationInfo.getClassOptimizationInfo(clazz).getTargetClass()) != null) {
            targetClass = clazz;
        }
        return targetClass;
    }

    private static class FieldOptimizationInfoCopier
    extends SimplifiedVisitor
    implements MemberVisitor {
        private FieldOptimizationInfoCopier() {
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            ProgramField copiedField = (ProgramField)programField.getVisitorInfo();
            Object info = copiedField.getVisitorInfo();
            programField.setVisitorInfo(info instanceof ProgramFieldOptimizationInfo ? new ProgramFieldOptimizationInfo((ProgramFieldOptimizationInfo)info) : info);
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        }
    }
}

