﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mgn/Mgn_EXPORTS.h>
#include <aws/mgn/model/WaveAggregatedStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace mgn {
namespace Model {
class UpdateWaveResult {
 public:
  AWS_MGN_API UpdateWaveResult() = default;
  AWS_MGN_API UpdateWaveResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MGN_API UpdateWaveResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Wave ID.</p>
   */
  inline const Aws::String& GetWaveID() const { return m_waveID; }
  template <typename WaveIDT = Aws::String>
  void SetWaveID(WaveIDT&& value) {
    m_waveIDHasBeenSet = true;
    m_waveID = std::forward<WaveIDT>(value);
  }
  template <typename WaveIDT = Aws::String>
  UpdateWaveResult& WithWaveID(WaveIDT&& value) {
    SetWaveID(std::forward<WaveIDT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Wave ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  UpdateWaveResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Wave name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateWaveResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Wave description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  UpdateWaveResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Wave archival status.</p>
   */
  inline bool GetIsArchived() const { return m_isArchived; }
  inline void SetIsArchived(bool value) {
    m_isArchivedHasBeenSet = true;
    m_isArchived = value;
  }
  inline UpdateWaveResult& WithIsArchived(bool value) {
    SetIsArchived(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Wave aggregated status.</p>
   */
  inline const WaveAggregatedStatus& GetWaveAggregatedStatus() const { return m_waveAggregatedStatus; }
  template <typename WaveAggregatedStatusT = WaveAggregatedStatus>
  void SetWaveAggregatedStatus(WaveAggregatedStatusT&& value) {
    m_waveAggregatedStatusHasBeenSet = true;
    m_waveAggregatedStatus = std::forward<WaveAggregatedStatusT>(value);
  }
  template <typename WaveAggregatedStatusT = WaveAggregatedStatus>
  UpdateWaveResult& WithWaveAggregatedStatus(WaveAggregatedStatusT&& value) {
    SetWaveAggregatedStatus(std::forward<WaveAggregatedStatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Wave creation dateTime.</p>
   */
  inline const Aws::String& GetCreationDateTime() const { return m_creationDateTime; }
  template <typename CreationDateTimeT = Aws::String>
  void SetCreationDateTime(CreationDateTimeT&& value) {
    m_creationDateTimeHasBeenSet = true;
    m_creationDateTime = std::forward<CreationDateTimeT>(value);
  }
  template <typename CreationDateTimeT = Aws::String>
  UpdateWaveResult& WithCreationDateTime(CreationDateTimeT&& value) {
    SetCreationDateTime(std::forward<CreationDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Wave last modified dateTime.</p>
   */
  inline const Aws::String& GetLastModifiedDateTime() const { return m_lastModifiedDateTime; }
  template <typename LastModifiedDateTimeT = Aws::String>
  void SetLastModifiedDateTime(LastModifiedDateTimeT&& value) {
    m_lastModifiedDateTimeHasBeenSet = true;
    m_lastModifiedDateTime = std::forward<LastModifiedDateTimeT>(value);
  }
  template <typename LastModifiedDateTimeT = Aws::String>
  UpdateWaveResult& WithLastModifiedDateTime(LastModifiedDateTimeT&& value) {
    SetLastModifiedDateTime(std::forward<LastModifiedDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Wave tags.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  UpdateWaveResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  UpdateWaveResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateWaveResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_waveID;

  Aws::String m_arn;

  Aws::String m_name;

  Aws::String m_description;

  bool m_isArchived{false};

  WaveAggregatedStatus m_waveAggregatedStatus;

  Aws::String m_creationDateTime;

  Aws::String m_lastModifiedDateTime;

  Aws::Map<Aws::String, Aws::String> m_tags;

  Aws::String m_requestId;
  bool m_waveIDHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_isArchivedHasBeenSet = false;
  bool m_waveAggregatedStatusHasBeenSet = false;
  bool m_creationDateTimeHasBeenSet = false;
  bool m_lastModifiedDateTimeHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace mgn
}  // namespace Aws
