﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/auditmanager/AuditManager_EXPORTS.h>
#include <aws/auditmanager/model/FrameworkType.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AuditManager {
namespace Model {

/**
 * <p> The metadata that's associated with a standard framework or a custom
 * framework. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/AssessmentFrameworkMetadata">AWS
 * API Reference</a></p>
 */
class AssessmentFrameworkMetadata {
 public:
  AWS_AUDITMANAGER_API AssessmentFrameworkMetadata() = default;
  AWS_AUDITMANAGER_API AssessmentFrameworkMetadata(Aws::Utils::Json::JsonView jsonValue);
  AWS_AUDITMANAGER_API AssessmentFrameworkMetadata& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_AUDITMANAGER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The Amazon Resource Name (ARN) of the framework. </p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  AssessmentFrameworkMetadata& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The unique identifier for the framework. </p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  AssessmentFrameworkMetadata& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The framework type, such as a standard framework or a custom framework. </p>
   */
  inline FrameworkType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(FrameworkType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline AssessmentFrameworkMetadata& WithType(FrameworkType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The name of the framework. </p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  AssessmentFrameworkMetadata& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The description of the framework. </p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  AssessmentFrameworkMetadata& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The logo that's associated with the framework. </p>
   */
  inline const Aws::String& GetLogo() const { return m_logo; }
  inline bool LogoHasBeenSet() const { return m_logoHasBeenSet; }
  template <typename LogoT = Aws::String>
  void SetLogo(LogoT&& value) {
    m_logoHasBeenSet = true;
    m_logo = std::forward<LogoT>(value);
  }
  template <typename LogoT = Aws::String>
  AssessmentFrameworkMetadata& WithLogo(LogoT&& value) {
    SetLogo(std::forward<LogoT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The compliance type that the new custom framework supports, such as CIS or
   * HIPAA. </p>
   */
  inline const Aws::String& GetComplianceType() const { return m_complianceType; }
  inline bool ComplianceTypeHasBeenSet() const { return m_complianceTypeHasBeenSet; }
  template <typename ComplianceTypeT = Aws::String>
  void SetComplianceType(ComplianceTypeT&& value) {
    m_complianceTypeHasBeenSet = true;
    m_complianceType = std::forward<ComplianceTypeT>(value);
  }
  template <typename ComplianceTypeT = Aws::String>
  AssessmentFrameworkMetadata& WithComplianceType(ComplianceTypeT&& value) {
    SetComplianceType(std::forward<ComplianceTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The number of controls that are associated with the framework. </p>
   */
  inline int GetControlsCount() const { return m_controlsCount; }
  inline bool ControlsCountHasBeenSet() const { return m_controlsCountHasBeenSet; }
  inline void SetControlsCount(int value) {
    m_controlsCountHasBeenSet = true;
    m_controlsCount = value;
  }
  inline AssessmentFrameworkMetadata& WithControlsCount(int value) {
    SetControlsCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The number of control sets that are associated with the framework. </p>
   */
  inline int GetControlSetsCount() const { return m_controlSetsCount; }
  inline bool ControlSetsCountHasBeenSet() const { return m_controlSetsCountHasBeenSet; }
  inline void SetControlSetsCount(int value) {
    m_controlSetsCountHasBeenSet = true;
    m_controlSetsCount = value;
  }
  inline AssessmentFrameworkMetadata& WithControlSetsCount(int value) {
    SetControlSetsCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The time when the framework was created. </p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  AssessmentFrameworkMetadata& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The time when the framework was most recently updated. </p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdatedAt() const { return m_lastUpdatedAt; }
  inline bool LastUpdatedAtHasBeenSet() const { return m_lastUpdatedAtHasBeenSet; }
  template <typename LastUpdatedAtT = Aws::Utils::DateTime>
  void SetLastUpdatedAt(LastUpdatedAtT&& value) {
    m_lastUpdatedAtHasBeenSet = true;
    m_lastUpdatedAt = std::forward<LastUpdatedAtT>(value);
  }
  template <typename LastUpdatedAtT = Aws::Utils::DateTime>
  AssessmentFrameworkMetadata& WithLastUpdatedAt(LastUpdatedAtT&& value) {
    SetLastUpdatedAt(std::forward<LastUpdatedAtT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_id;

  FrameworkType m_type{FrameworkType::NOT_SET};

  Aws::String m_name;

  Aws::String m_description;

  Aws::String m_logo;

  Aws::String m_complianceType;

  int m_controlsCount{0};

  int m_controlSetsCount{0};

  Aws::Utils::DateTime m_createdAt{};

  Aws::Utils::DateTime m_lastUpdatedAt{};
  bool m_arnHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_typeHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_logoHasBeenSet = false;
  bool m_complianceTypeHasBeenSet = false;
  bool m_controlsCountHasBeenSet = false;
  bool m_controlSetsCountHasBeenSet = false;
  bool m_createdAtHasBeenSet = false;
  bool m_lastUpdatedAtHasBeenSet = false;
};

}  // namespace Model
}  // namespace AuditManager
}  // namespace Aws
